﻿using System;
using System.Windows.Data;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Controls.ViewModel;
using Iri.Modernisation.BaseMVVM.Commands;
namespace Iri.Modernisation.Controls.View
{
    public partial class BookTimeLine : UserControl
    {
        public BookTimeLine()
        {
            InitializeComponent();
       
            TimeStripsPanel.SizeChanged += new SizeChangedEventHandler(TimeStripsPanel_SizeChanged);
            BookTimeLineSlider.MouseLeftButtonUp += new MouseButtonEventHandler(BookTimeLineSlider_MouseLeftButtonUp); 
        }

        void BookTimeLineSlider_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            Commands.TimeChange.Execute(BookTimeLineSlider.Value,DataContext);
        }
		
        void TimeStripsPanel_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            Draw();
        }

       
        public void Draw()
        {
            BookTimeLineVM VM = (BookTimeLineVM)DataContext;
            BookTimeLineElementPanel.Children.Clear();
            BookTimeLineAnnotationPanel.Children.Clear();
            foreach (List<SegmentIndex> LIndex in VM.SegmentIndex)
            {
                foreach (SegmentIndex Index in LIndex)
                {
                   
                    PolemicElementControl pol = new PolemicElementControl();
                    
                    pol.SetValue(Canvas.ZIndexProperty, 10);
                    pol.DataContext = new PolemicElementVM(Index);
                    BookTimeLineElementPanel.Children.Add(pol);
                  
                    Canvas.SetLeft(pol, (Index.TimerIn.TotalMilliseconds * ScaleTimeLine.Value) / VM.TotalDuration);
                    pol.Width = (Index.Duration.TotalMilliseconds * ScaleTimeLine.Value) / VM.TotalDuration;
                }
            }
            int basi = 30;
            foreach (List<Annotation> LAnnotation in VM.Annotations)
            {
                foreach (Annotation Annotation in LAnnotation)
                {
                    PolemicElementControl pol = new PolemicElementControl();
                    pol.SetValue(Canvas.ZIndexProperty, 10);
                    pol.DataContext = new PolemicElementVM(Annotation);
                    BookTimeLineAnnotationPanel.Children.Add(pol);
                    Canvas.SetLeft(pol, (Annotation.TimerIn.TotalMilliseconds * ScaleTimeLine.Value) / VM.TotalDuration);
                    Canvas.SetTop(pol, basi);
                    basi += 10;
                    pol.Width = (Annotation.Duration.TotalMilliseconds * ScaleTimeLine.Value) / VM.TotalDuration;
                }
            }
            BookTimeLineElementPanel.UpdateLayout();
        }

        private void BookTimeLineSlider_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            MessageBox.Show("Change");
            BookTimeLineSlider.Value = (e.GetPosition(BookTimeLineSlider).X) * BookTimeLineSlider.Maximum / BookTimeLineSlider.Width;
        }

        
        
        
       
    }

}
