﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Iri.Modernisation.Controls.View
{
   
    public partial class ButtonHeaderControl : UserControl
    {
        public ButtonHeaderControl()
        {
            InitializeComponent();
        }
        private bool _isMouseInside = false;
        Point tempPoint = new Point();

        private void LayoutRoot_MouseMove(object sender, MouseEventArgs e)
        {
            _isMouseInside = true;
            Point p = e.GetPosition(this);
            tempPoint.X = 1-  (p.X / ActualWidth);
            //tempPoint.Y = p.Y / ActualHeight;
            tempPoint.Y = 1 - (p.Y / ActualWidth); ;
            brushLight.Center = tempPoint;
            brushLight.GradientOrigin = tempPoint;

        }

        string _title = String.Empty;

        /// <summary>
        /// Title of the toolbar item
        /// </summary>
        public string Title
        {
            get { return _title; }
            set { _title = value; }
        }


        /// <summary>
        /// The transition color when we hover over the button
        /// </summary>
        public Color TransitionColor
        {
            get
            {
                return transitionColor.Color;
            }
            set
            {
                transitionColor.Color = value;
                transitionSubColor.Color = Color.FromArgb(64, value.R, value.G, value.B);
            }
        }

        /// <summary>
        /// The source of the image to display for the control
        /// </summary>
        public ImageSource ImageSource
        {
            get { return imgItem.Source; }
            set { imgItem.Source = value; }
        }

        private void LayoutRoot_MouseEnter(object sender, MouseEventArgs e)
        {
            _isMouseInside = true;
            animEnter.Begin();
        }

        private void LayoutRoot_MouseLeave(object sender, MouseEventArgs e)
        {
            _isMouseInside = false;
            animLeave.Begin();

        }

        /// <summary>
        /// Uri to navigate to when clicked
        /// </summary>
        public string NavigateUri { get; set; }

        /// <summary>
        /// true to open link in new window, false to open link in current window
        /// default is false
        /// </summary>
        public bool OpenInNewWindow { get; set; }

        private void UserControl_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (NavigateUri != null)
            {
                if (OpenInNewWindow)
                {
                    System.Windows.Browser.HtmlPage.Window.Navigate(new Uri(NavigateUri, UriKind.Absolute), "_new");
                }
                else
                {
                    System.Windows.Browser.HtmlPage.Window.Navigate(new Uri(NavigateUri, UriKind.Absolute));
                }
            }

        }
    }
}
