﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

using Iri.Modernisation.Controls.ViewModel;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.LDTClass;
using Iri.Modernisation.Data.Models;

namespace Iri.Modernisation
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
          
            InitializeComponent();
           
        }
        private void Start()
        {
            List<VideoBook> SelectedVideoBooks = new List<VideoBook>();
           // Initialisation des commandes //
            Commands.Initialize();
            Commands.FlipView.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(FlipView_Executed);
           //-----------------------------------------//


           // Initialisation des Components //
           ConsultationViewElement.DataContext = new ConsultationViewVM();
           NavigationBarElement.DataContext = new NavigationBarVM() { ConsultMenuViewModel = new ConsultMenuVM(SelectedVideoBooks) };
           HeaderControlElement.DataContext = new HeaderControlVM();
           ProductionViewElement.DataContext = new HeaderProductionVM();
           //------------------------------------------------------//
           
        }
        void FlipView_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            Commands.VideoViewer.Pause.Execute();
            FlipTest.ExecuteFlip();
        }
    }
}
