﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Browser;
using Iri.Modernisation.Controls.ViewModel;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.LDTClass;
using Iri.Modernisation.Data.Models;

namespace Iri.Modernisation.Test.MainInterface
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
           List<VideoBook> SelectedVideoBooks = new List<VideoBook>();
            /*************** Content Demo ***************/
           /* Pour pouvoir tester avec des vidéos :     
            * - Placer les video dans le dossier Bin
            * - Rajouter Application.Current.Host.Source.Host devant le nom du fichier
            */
           LDTFile file = new LDTFile();
            // file.Load(new Uri("Modernisation.FileConvertor;component/ENMI08-I-bernard_stiegler-jauffret.ldt", UriKind.Relative).ToString());
            file.Load("Content/ENMI08-I-bernard_stiegler-jauffret.ldt");
            
            LDTFileReader _LDTFR = new LDTFileReader("Content/ENMI08-I-bernard_stiegler-jauffret.ldt");
            VideoBook temp = _LDTFR.VideoBook;
            temp.Chapters[0].VideoSequences = new List<VideoSequence>();
            temp.Chapters[0].VideoSequences.Add(new VideoSequence());
            temp.MediaPath = Application.Current.Host.Source.Host+@"/test.wmv";
            SelectedVideoBooks.Add(temp);
            temp = new LDTFileReader("Content/ENMI08-II-antoine_masson-jauffret.ldt").VideoBook;
           
            temp.MediaPath = Application.Current.Host.Source.Host+@"/video.mp4";
            SelectedVideoBooks.Add(temp);
            SelectedVideoBooks.Add(new LDTFileReader("Content/ENMI08-III_elizabethrosse-psychologie_et_reseaux_sociaux-jauffret.ldt").VideoBook);
            SelectedVideoBooks.Add(new LDTFileReader("Content/ENMI08-IV-dominiquepasquier-jauffret.ldt").VideoBook);
            /********************************************/

            /*************** Initialisation des commandes ***************/
            Commands.Initialize();
            Commands.FlipView.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(FlipView_Executed);
            /********************************************/

            /*************** Initialisation des Component ***************/
            InitializeComponent();
            ConsultationViewElement.DataContext = new ConsultationViewVM();
            NavigationBarVM navvm = new NavigationBarVM() { ConsultMenuViewModel = new ConsultMenuVM(SelectedVideoBooks) };
            NavigationBarElement.DataContext = navvm;
            HeaderControlElement.DataContext = new HeaderControlVM("L'utilisateur");
            ProductionViewElement.DataContext = new HeaderProductionVM();
            /********************************************/
           
        }

        void FlipView_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            Commands.VideoViewer.Pause.Execute();
            FlipTest.ExecuteFlip();
        }
    }
    
}
