﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using System.Collections.Generic;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel du module BookTimeLine
    /// </summary>
    public class BookTimeLineVM : BaseMVVM.ViewModel.ViewModel
    {
        /// <summary>
        /// Livre sélectionné
        /// </summary>
        private VideoBook _selectedBook;
        public VideoBook SelectedBook
        {
            get
            {
                return _selectedBook;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public String AuthorFullname
        {
            get
            {
                return Author.FirstName + " " + Author.Name;
            }
        }

        /// <summary>
        /// Titre du Livre
        /// </summary>
        private String _title;
        public String Title 
        {
            get
            {
                return _title;
            }
            private set
            {
                _title = value;
                _selectedBook.Title = value;
                OnPropertyChanged("Title");
            }
        }

        /// <summary>
        /// Auteur du Livre
        /// </summary>
        private User _author;
        public User Author
        {
            get
            {
                return _author;
            }
            private set
            {
                _author = value;
                _selectedBook.Author = value;
                OnPropertyChanged("Author");
            }

        }

        /// <summary>
        /// Chapitre du Livre
        /// </summary>
        private VideoChapter[] _chapters;
        public VideoChapter[] Chapters
        {
            get
            {
                return _chapters;
            }
            private set
            {
                _chapters = value;
                _selectedBook.Chapters = value;
                OnPropertyChanged("Chapters");
            }
        }

        /// <summary>
        /// Liste des Index des Chapitres
        /// </summary>
        private List<SegmentIndex>[] _segmentIndex=new List<SegmentIndex>[4];
        public List<SegmentIndex>[] SegmentIndex
        {
            get
            {
                return _segmentIndex;
            }
            set
            {
                _segmentIndex = value;
                OnPropertyChanged("SegmentIndex");
            }
        }

        /// <summary>
        /// Liste des Annotations
        /// </summary>
        private List<Annotation>[] _annotations=new List<Annotation>[4];
        public List<Annotation>[] Annotations
        {
            get
            {
                return _annotations;
            }
            set
            {
                _annotations = value;
                OnPropertyChanged("Annotations");
            }
        }

        /// <summary>
        /// Durée totale du Livre
        /// </summary>
        private TimeSpan _totalDuration;
        public double TotalDuration
        {
            get
            {
                return _totalDuration.TotalMilliseconds;
            }
            set
            {
                _totalDuration = new TimeSpan(0, 0, 0, 0, (int)value);
                _selectedBook.Duration = new TimeSpan(0, 0, 0, 0, (int)value); ;
                OnPropertyChanged("Duration");
            }
        }

        private List<int> _polemicSpectrumData = new List<int>();
        public List<int> PolemicSpectrumData
        {
            get
            {
                return _polemicSpectrumData;
            }
        }

        private List<int> _adhesionSpectrumData = new List<int>();
        public List<int> AdhesionSpectrumData
        {
            get
            {
                return _adhesionSpectrumData;
            }
        }

        private List<int> _referenceSpectrumData = new List<int>();
        public List<int> ReferenceSpectrumData
        {
            get
            {
                return _referenceSpectrumData;
            }
        }

        private List<int> _questionSpectrumData = new List<int>();
        public List<int> QuestionSpectrumData
        {
            get
            {
                return _questionSpectrumData;
            }
        }

        private List<int> _generalSpectrumData = new List<int>();
        public List<int> GeneralSpectrumData
        {
            get
            {
                return _generalSpectrumData;
            }
        }

        /// <summary>
        /// Position du curseur de lecture
        /// </summary>
        private double _position;
        public double Position
        {
            get
            {
                return _position;
            }
            set
            {
                _position = value;
                OnPropertyChanged("Position");
            }
        }

        /// <summary>
        /// Chargement des données et annalyse
        /// </summary>
        private void LoadData()
        {
            if (_selectedBook.Duration != TimeSpan.Zero)
            {
            
            for (double i = 0; i <= _selectedBook.Duration.TotalMilliseconds; i = (i + _selectedBook.Duration.TotalMilliseconds / 150))
            {
                int[] Tem = new int[4]{0,0,0,0};
                foreach (VideoChapter Ch in _selectedBook.Chapters)
                {
                    foreach (Annotation An in Ch.Annotations)
                    {
                        if (An.TimerIn.TotalMilliseconds <= i && An.TimerOut.TotalMilliseconds >= i)
                        {
                            switch (An.Type)
                            {
                                case PolemicElementType.Polemic:
                                    Tem[0]++;
                                    break;
                                case PolemicElementType.Adhesion:
                                    Tem[1]++;
                                    break;
                                case PolemicElementType.Reference:
                                    Tem[2]++;
                                    break;
                                case PolemicElementType.Question:
                                    Tem[3]++;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                }
                _polemicSpectrumData.Add(Tem[0]);
               _adhesionSpectrumData.Add(Tem[1]);
                _referenceSpectrumData.Add(Tem[2]);
              _questionSpectrumData.Add(Tem[3]);
               _generalSpectrumData.Add((Tem[0]+Tem[1]+Tem[2]+Tem[3]));
            }
            }


        }

        /// <summary>
        /// Constructeur    
        /// </summary>
        /// <param name="bookParam">VideoLivre à étudier</param>
        public BookTimeLineVM(VideoBook bookParam)
        {
            _selectedBook = bookParam;
            _title = bookParam.Title;
            _author = bookParam.Author;
            _chapters = bookParam.Chapters;
            _totalDuration = bookParam.Duration;
            LoadData();
            LoadElements();
            Commands.TimeChange.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(TimeChange_Executed);

        }
        private VideoViewerVM _videoViewerVM;
        public VideoViewerVM ViewModelVideoViewer
        {
            get
            {
                return _videoViewerVM;
            }
            set
            {
                _videoViewerVM = value;
                OnPropertyChanged("ViewModelVideoViewer");
            }
        }
        void TimeChange_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
          //  Position = ((Slider)e.Parameter).Value;
           // Commands.VideoViewer.Pause.Execute();

            ViewModelVideoViewer.GoTo(TimeSpan.FromMilliseconds(((Slider)e.Parameter).Value));
            //Commands.GoToTime.Execute(((Slider)e.Parameter).Value);
            
           // Commands.VideoViewer.Play.Execute();
        }

      
        /// <summary>
        /// Chargement des éléments du livre (Index et Annotations)
        /// </summary>
        private void LoadElements()
        {
            for(int key=0;key< _selectedBook.Chapters.Length;key++)
            {
              _segmentIndex[key] = _selectedBook.Chapters[key].Index;
               _annotations[key] = _selectedBook.Chapters[key].Annotations;
            }
        }
      
    }
}
