﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Controls.View;
using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace Iri.Modernisation.Controls.ViewModel
{
    public class ProductionTimeLineVM : BaseMVVM.ViewModel.ViewModel
    {


        private bool _isIndexing;
        public bool IsIndexing
        {
            get
            {
                return _isIndexing;
            }
            set
            {
                _isIndexing = value;
                OnPropertyChanged("IsIndexing");
            }
        }

        private VideoBook _newBook;
        private ObservableCollection<VideoSequence>[] _listVideoSequences = new ObservableCollection<VideoSequence>[4];
        public ObservableCollection<VideoSequence>[] ListVideoSequences
        {
            get
            {
                return _listVideoSequences;
            }
            set
            {
                _listVideoSequences = value;
                OnPropertyChanged("ListVideoSequences");
            }
        }
        
        public ObservableCollection<VideoSequence> SelectedVideoSequences
        {
            get
            {
                
                return _listVideoSequences[SelectedChapter];
            }
            set
            {
                _listVideoSequences[SelectedChapter] = value;
                //_newBook.Chapters[SelectedChapter].VideoSequences = value;
                OnPropertyChanged("SelectedVideoSequences");
            }
        }
        public TimeSpan TotalBookDuration
        {
            get
            {
                TimeSpan temp = TimeSpan.Zero;
                foreach (ObservableCollection<VideoSequence> Ocvs in _listVideoSequences)
                {
                    foreach (VideoSequence Vs in Ocvs)
                    {
                        temp += Vs.Duration;
                    }
                }
                return temp;
            }
        }
        public VideoChapter[] Chapters
        {
            get
            {
                return _newBook.Chapters;
            }
          
        
        }
        public VideoChapter SelectedBookChapter
        {
            get
            {
                return _newBook.Chapters[SelectedChapter];
            }
        }

        private int _selectedChapter=0;
        public int SelectedChapter
        {
            get
            {
                return _selectedChapter;
            }
            set
            {
                _selectedChapter = value;
                OnPropertyChanged("SelectedChapter");
            }
        }


        private double _position;
        public double Position
        {
            get
            {
                return _position;
            }
            set
            {
                _position = value;
                OnPropertyChanged("Position");
            }
        }

        private ObservableCollection<SegmentIndex>[] _listSegmentIndex;
        public ObservableCollection<SegmentIndex>[] ListIndex
        {
            get
            {
                return _listSegmentIndex;
            }
        }
        public ObservableCollection<SegmentIndex> SelectedIndex
        {
            get
            {
                return _listSegmentIndex[SelectedChapter];
            }
            set
            {
                _listSegmentIndex[SelectedChapter] = value;
                //_newBook.Chapters[SelectedChapter].Index = value;
                OnPropertyChanged("SelectedIndex");
            }
        }

        private VideoChapterType _selectedChapterType;
        public VideoChapterType SelectedChapterType
        {
            get
            {
                return _selectedChapterType;
            }
            set
            {
                _selectedChapterType = value;
                OnPropertyChanged("SelectedChapterType");
            }
        }
 
      
        public ProductionTimeLineVM()
        {
            _newBook = new VideoBook();
            _listVideoSequences = new ObservableCollection<VideoSequence>[4]
            {
                new ObservableCollection<VideoSequence>(),
                new ObservableCollection<VideoSequence>(),
                new ObservableCollection<VideoSequence>(),
                new ObservableCollection<VideoSequence>()
            };
           // PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(ProductionTimeLineVM_PropertyChanged);
           // SelectedVideoSequences = new ObservableCollection<VideoSequence>();
            Commands.ProductionView.DelVideoSequence.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(DelVideoSequence_Executed);
            Commands.ProductionTimeLine.EditorPartSelected.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EditorPartSelected_Executed);
            Commands.ProductionTimeLine.EditorPartFinished.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EditorPartFinished_Executed);
            Commands.ProductionView.ClickAddIndex.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickAddIndex_Executed);
            _listVideoSequences[0].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listVideoSequences[1].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listVideoSequences[2].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listVideoSequences[3].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);

            _listSegmentIndex = new ObservableCollection<SegmentIndex>[4]
            {
                new ObservableCollection<SegmentIndex>(),
                new ObservableCollection<SegmentIndex>(),
                new ObservableCollection<SegmentIndex>(),
                new ObservableCollection<SegmentIndex>()
            };
            _listSegmentIndex[0].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listSegmentIndex[1].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listSegmentIndex[2].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
            _listSegmentIndex[3].CollectionChanged += new System.Collections.Specialized.NotifyCollectionChangedEventHandler(SelectedVideoSequences_CollectionChanged);
        }

        void ClickAddIndex_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if(IsIndexing)
            {
                TimeSpan dur = TimeSpan.Zero;
                // Permet de créer un Index avec une durée calé sur les videos.
                foreach (VideoSequence Vs in SelectedVideoSequences)
                {
                    dur += Vs.Duration;
                }
                foreach (SegmentIndex Si in SelectedIndex)
                {
                    dur -= Si.Duration;
                }
                SelectedIndex.Add(new SegmentIndex(SelectedBookChapter) 
                { 
                    TimerIn = TimeSpan.Zero, 
                    TimerOut = dur,
                    Chapter = SelectedBookChapter
                });

            }
 
        }

        void DelVideoSequence_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedVideoSequences.Remove(((CustomableVideoElementVM)e.Parameter).VideoSequence);
            OnPropertyChanged("TotalBookDuration");
        }

        void SelectedVideoSequences_CollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            OnPropertyChanged("TotalBookDuration");
            Commands.ProductionView.VideoRecordUpdated.Execute();
        }

        void ProductionTimeLineVM_PropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            //Commands.ProductionView.VideoRecordUpdated.Execute();
        }

        void EditorPartFinished_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            SelectedChapter = -1;
        }

        void EditorPartSelected_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
           
            SelectedChapter = (int)((HeaderProductionEventArgs)e.Source).ChapterType;
            SelectedChapterType = ((HeaderProductionEventArgs)e.Source).ChapterType ;
            IsIndexing = ((HeaderProductionEventArgs)e.Source).IsIndexPart;
        }

    }
}
