﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Controls.ViewModel;
using System.Collections.ObjectModel;
namespace Iri.Modernisation.Controls.View
{
  
	public partial class ProductionTimeLine : UserControl
	{
        public static double ScaleTime
        {
            get
            {
                return 0.0001;
            }
        }
		public ProductionTimeLine()
		{
			// Required to initialize variables
			InitializeComponent();
            Commands.ProductionTimeLine.EditorPartSelected.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EditorPartSelected_Executed);
            Commands.ProductionView.VideoRecordUpdated.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(VideoRecordUpdated_Executed);
            Commands.Action.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(Action_Executed);
          
		}

        void EditorPartSelected_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            UpdateElements();
        }

        void VideoRecordUpdated_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
          UpdateElements();
        }
     

        void Action_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            AddSequenceButton.Content = ((MouseEventArgs)e.Parameter).GetPosition(this).X;
        }
        private double _sumOfLengh=0;
        public void UpdateElements()
        {
            if (DataContext != null)
            {
                if (((ProductionTimeLineVM)this.DataContext).SelectedChapter != -1)
                {
                    if (!((ProductionTimeLineVM)DataContext).IsIndexing)
                    {
                        VideoTimeStrip.Children.Clear();
                        int intChapter = 0;
                        _sumOfLengh = 0;
                        foreach (ObservableCollection<VideoSequence> Ocvs in ((ProductionTimeLineVM)this.DataContext).ListVideoSequences)
                        {
                            
                            foreach (VideoSequence Vs in Ocvs)
                            {
                                CustomableVideoElement _temp = new CustomableVideoElement()
                                {
                                    DataContext = new CustomableVideoElementVM(Vs)
                                    {
                                        Chapter = (VideoChapterType)intChapter
                                    },
                                };
                                _temp.MouseLeftButtonDown += new MouseButtonEventHandler(CustomableVideoElement_MouseLeftButtonDown);
                                if ((VideoChapterType)intChapter == ((ProductionTimeLineVM)this.DataContext).SelectedBookChapter.Type)
                                {
                                    _temp.MouseMove += new MouseEventHandler(CustomableVideoElement_MouseMove);

                                    _temp.MouseLeftButtonUp += new MouseButtonEventHandler(CustomableVideoElement_MouseLeftButtonUp);
                                }
                                VideoTimeStrip.Children.Add(_temp);// TODO: Add event handler implementation here.
                                _sumOfLengh += _temp.Width;
                            }
                            intChapter++;
                        }
                    }
                    else
                    {
                        AnnotationTimeStrip.Children.Clear();
                      
                        foreach (ObservableCollection<SegmentIndex> Ocsi in ((ProductionTimeLineVM)this.DataContext).ListIndex)
                        {
                            foreach (SegmentIndex Si in Ocsi)
                            {
                                
                                    // PolemicElementControl an = new PolemicElementControl() { IsEnabled = false };
                                    CustomableIndexElement an = new CustomableIndexElement()
                                    {
                                        DataContext = new CustomableIndexElementVM(Si)
                                    };

                                    //an.DataContext = new PolemicElementVM(Si);

                                    an.MouseLeftButtonDown += new MouseButtonEventHandler(an_MouseLeftButtonDown);
                                    an.MouseMove += new MouseEventHandler(an_MouseMove);
                                    an.MouseLeftButtonUp += new MouseButtonEventHandler(an_MouseLeftButtonUp);
                                    //((ProductionTimeLineVM)DataContext).SelectedBookChapter);
                                    AnnotationTimeStrip.Children.Add(an);
                                
                               
                            }
                            
                        }
                       
                    }
                   

                }
                
                
            }
        }

        void an_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            _isTrimRightCapturated = false;
            _isTrimLeftCapturated = false;
        }

        void an_MouseMove(object sender, MouseEventArgs e)
        {
            if (((ProductionTimeLineVM)DataContext).IsIndexing)
            {
                if (e.GetPosition(AnnotationTimeStrip).X <= _sumOfLengh && _isTrimRightCapturated && ((CustomableIndexElement)sender).CaptureMouse())
                {
                    ((CustomableIndexElement)sender).TrimRight = _comePoint.X - e.GetPosition(((CustomableIndexElement)sender)).X;
                    _comePoint = e.GetPosition(((CustomableIndexElement)sender));
                }
               
            }
        }
        private CustomableIndexElement _selectedIndex;
        void an_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            _selectedIndex = ((CustomableIndexElement)sender);
            if (e.GetPosition(((CustomableIndexElement)sender)).X >= ((CustomableIndexElement)sender).Width - 5)
            {
                _comePoint = e.GetPosition(((CustomableIndexElement)sender));
                _isTrimRightCapturated = true;
            }
            foreach(ObservableCollection<SegmentIndex> Ocsi in ((ProductionTimeLineVM)DataContext).ListIndex)
            {
                foreach (SegmentIndex Si in Ocsi )
                {
                   
                    if (((CustomableIndexElementVM)_selectedIndex.DataContext).SegmentIndex == Si)
                    {
                        if (Ocsi == ((ProductionTimeLineVM)DataContext).SelectedIndex)
                        {
                            Commands.ProductionTimeLine.IndexSelected.Execute(true,Si);
                        }
                        else
                        {

                            Commands.ProductionTimeLine.IndexSelected.Execute(false, Si); 
                        }
                        
                    }
                }
            }

        
           
        }
        private void AddSequenceButton_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            AddSequenceButton.Content = ((ProductionTimeLineVM)DataContext).TotalBookDuration;
        }

        

        private void slider_ValueChanged(object sender, System.Windows.RoutedPropertyChangedEventArgs<double> e)
        {
        	 AddSequenceButton.Content = e.NewValue;
			// TODO: Add event handler implementation here.
        }



        private Point _comePoint; 
        private bool _isTrimRightCapturated = false;
        private bool _isTrimLeftCapturated = false;

        private CustomableVideoElement _selected;
        void CustomableVideoElement_MouseMove(object sender, MouseEventArgs e)
        {

            if (!((ProductionTimeLineVM)DataContext).IsIndexing)
            {
                if (_isTrimRightCapturated && ((CustomableVideoElement)sender).CaptureMouse())
                {
                    ((CustomableVideoElement)sender).TrimRight = _comePoint.X - e.GetPosition(((CustomableVideoElement)sender)).X;
                    _comePoint = e.GetPosition(((CustomableVideoElement)sender));
                }
                else if (_isTrimLeftCapturated && ((CustomableVideoElement)sender).CaptureMouse())
                {
                    ((CustomableVideoElement)sender).TrimLeft = e.GetPosition(((CustomableVideoElement)sender)).X - _comePoint.X;
                    _comePoint = e.GetPosition(((CustomableVideoElement)sender));
                }
            }
           
        }
        void CustomableVideoElement_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            _isTrimRightCapturated = false;
            _isTrimLeftCapturated = false;
        }

        void CustomableVideoElement_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            _selected = ((CustomableVideoElement)sender);
            if (e.GetPosition(((CustomableVideoElement)sender)).X >= ((CustomableVideoElement)sender).Width - 5)
            {
                _comePoint = e.GetPosition(((CustomableVideoElement)sender));
                _isTrimRightCapturated = true;
            }
            if (e.GetPosition(((CustomableVideoElement)sender)).X <= 5)
            {
                _comePoint = e.GetPosition(((CustomableVideoElement)sender));
                _isTrimLeftCapturated = true;
            }
        }

        private void DeleteSequenceButton_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            //VideoTimeStrip.Children.Remove(_selected);
            Commands.ProductionView.DelVideoSequence.Execute(((CustomableVideoElement)_selected).DataContext);
        }
	}
}