﻿using System;
using System.Windows.Data;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.Controls.ViewModel;
using Iri.Modernisation.BaseMVVM.Commands;
using System.IO;
namespace Iri.Modernisation.Controls.View
{
    public partial class BookTimeLine : UserControl
    {
        public BookTimeLine()
        {
            InitializeComponent();
       
            TimeStripsPanel.SizeChanged += new SizeChangedEventHandler(TimeStripsPanel_SizeChanged);
            BookTimeLineSlider.ThumbDragStarted += new EventHandler<EventArgs>(TimeSlider_ThumbDragCompleted);
            BookTimeLineSlider.ThumbDragCompleted += new EventHandler<EventArgs>(TimeSlider_ThumbDragCompleted);
            BookTimeLineSlider.MouseLeftButtonUp += new MouseButtonEventHandler(BookTimeLineSlider_MouseLeftButtonUp);
            saveAnnotationsButton.Click += new RoutedEventHandler(saveAnnotationsButton_Click);
            Commands.AnnotationMaker.NewAnnotationFinished.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(NewAnnotationFinished_Executed);
        }

        void saveAnnotationsButton_Click(object sender, RoutedEventArgs e)
        {
            SaveFileDialog mySaveDialog = new SaveFileDialog();
            mySaveDialog.Filter = "Ldt File (.ldt)|*.ldt|All Files|*.*";
            bool? ret = mySaveDialog.ShowDialog();
            if (ret == true)
            {


                VideoBookUploader.UpdateAnnotation(((BookTimeLineVM)DataContext).SelectedBook, new StreamWriter(mySaveDialog.OpenFile()));
               
            }
    
        }
        private bool _saveVideoViewerState { get; set; }
        private void TimeSlider_ThumbDragCompleted(object sender, EventArgs e)
        {
            if (_saveVideoViewerState)
            {
                ((BookTimeLineVM)DataContext).ViewModelVideoViewer.Play();
            }
        }

        private void TimeSlider_ThumbDragStarted(object sender, EventArgs e)
        {
            _saveVideoViewerState = ((BookTimeLineVM)DataContext).ViewModelVideoViewer.IsPLayed;
            ((BookTimeLineVM)DataContext).ViewModelVideoViewer.Pause();

        }
        private void NewAnnotationFinished_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            Draw();
        }

        private void BookTimeLineSlider_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            Commands.TimeChange.Execute(BookTimeLineSlider.Value,DataContext);
        }

        private void TimeStripsPanel_SizeChanged(object sender, SizeChangedEventArgs e)
        {
            Draw();
        }

       
        public void Draw()
        {
            BookTimeLineVM VM = (BookTimeLineVM)DataContext;
            BookTimeLineElementPanel.Children.Clear();
            BookTimeLineAnnotationPanel.Children.Clear();
            foreach (List<SegmentIndex> LIndex in VM.SegmentIndex)
            {
                foreach (SegmentIndex Index in LIndex)
                {
                   
                    PolemicElementControl pol = new PolemicElementControl();
                    pol.SetValue(Canvas.ZIndexProperty, 10);
                    pol.DataContext = new PolemicElementVM(Index);
                    BookTimeLineElementPanel.Children.Add(pol);
                    double timeleft = (double)((Index.TimerIn.TotalMilliseconds  / BookTimeLineVM.ratioPixMs) * ScaleTimeLine.Value);
                    Canvas.SetLeft(pol,timeleft);
                    pol.Width = (Index.Duration.TotalMilliseconds / BookTimeLineVM.ratioPixMs) * ScaleTimeLine.Value;
                }
            }
            int basi = 0;
            foreach (List<Annotation> LAnnotation in VM.Annotations)
            {
                foreach (Annotation Annotation in LAnnotation)
                {
                    PolemicElementControl pol = new PolemicElementControl();
                    pol.SetValue(Canvas.ZIndexProperty, 10);
                    pol.DataContext = new PolemicElementVM(Annotation);
                    
                    Canvas.SetLeft(pol, (Annotation.TimerIn.TotalMilliseconds / BookTimeLineVM.ratioPixMs)* ScaleTimeLine.Value);
                   
                    /** It's TETRIS time **/
                    foreach (PolemicElementControl lockedControl in BookTimeLineAnnotationPanel.Children)
                    {
                        if (
                            ((PolemicElementVM)pol.DataContext).TimerIn >= ((PolemicElementVM)lockedControl.DataContext).TimerIn && ((PolemicElementVM)pol.DataContext).TimerIn <= ((PolemicElementVM)lockedControl.DataContext).TimerOut
                            || ((PolemicElementVM)pol.DataContext).TimerOut >= ((PolemicElementVM)lockedControl.DataContext).TimerIn && ((PolemicElementVM)pol.DataContext).TimerOut <= ((PolemicElementVM)lockedControl.DataContext).TimerOut
                           
                           )
                        {
                            int actualTop = (int)Canvas.GetTop(lockedControl);
                            if (basi <= actualTop)
                           {
                                basi += 10;
                           }
                            
                        }
                    }

                    Canvas.SetTop(pol, basi);
                  /***********************/
                    
                    
                 //   pol.Width = (Annotation.Duration.TotalMilliseconds * ScaleTimeLine.Value) / VM.TotalDuration;
                    pol.Width = (Annotation.Duration.TotalMilliseconds / BookTimeLineVM.ratioPixMs)* ScaleTimeLine.Value;
                    BookTimeLineAnnotationPanel.Children.Add(pol);
                    basi = 0;
                }
            }
            BookTimeLineElementPanel.UpdateLayout();
        }

       

        
        
        
       
    }

}
