﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using System.Collections.Generic;
using System.IO;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel du module BookTimeLine
    /// </summary>
    public class BookTimeLineVM : BaseMVVM.ViewModel.ViewModel
    {
        static public double ratioPixMs = 6000;
        private VideoBook _selectedBook;
        /// <summary>
        /// Livre sélectionné
        /// </summary>
        public VideoBook SelectedBook
        {
            get
            {
                return _selectedBook;
            }
        }

        /// <summary>
        /// Nom de l'auteur
        /// </summary>
        public String AuthorFullname
        {
            get
            {
                return Author.UserName;
            }
        }

        
        private String _title;
        /// <summary>
        /// Titre du Livre
        /// </summary>
        public String Title 
        {
            get
            {
                return _title;
            }
            private set
            {
                _title = value;
                _selectedBook.Title = value;
                OnPropertyChanged("Title");
            }
        }

        
        private User _author;
        /// <summary>
        /// Auteur du Livre
        /// </summary>
        public User Author
        {
            get
            {
                return _author;
            }
            private set
            {
                _author = value;
                _selectedBook.Author = value;
                OnPropertyChanged("Author");
            }

        }

        private VideoChapter[] _chapters;
        /// <summary>
        /// Chapitre du Livre
        /// </summary>
        public VideoChapter[] Chapters
        {
            get
            {
                return _chapters;
            }
            private set
            {
                _chapters = value;
                _selectedBook.Chapters = value;
                OnPropertyChanged("Chapters");
            }
        }


        private List<SegmentIndex>[] _segmentIndex;
        /// <summary>
        /// Liste des Index des Chapitres
        /// </summary>
        public List<SegmentIndex>[] SegmentIndex
        {
            get
            {
                return _segmentIndex;
            }
            set
            {
                _segmentIndex = value;
                OnPropertyChanged("SegmentIndex");
            }
        }


        private List<Annotation>[] _annotations;
        /// <summary>
        /// Liste des Annotations
        /// </summary>
        public List<Annotation>[] Annotations
        {
            get
            {
                return _annotations;
            }
            set
            {
                _annotations = value;
                OnPropertyChanged("Annotations");
            }
        }

      
        private TimeSpan _totalDuration;
        /// <summary>
        /// Durée totale du Livre
        /// </summary>
        public double TotalDuration
        {
            get
            {
                return _totalDuration.TotalMilliseconds;
            }
            set
            {
                _totalDuration = new TimeSpan(0, 0, 0, 0, (int)value);
                _selectedBook.Duration = new TimeSpan(0, 0, 0, 0, (int)value); ;
                OnPropertyChanged("Duration");
            }
        }

        
        private double _position;
        /// <summary>
        /// Position du curseur de lecture
        /// </summary>
        public double Position
        {
            get
            {
                return _position;
            }
            set
            {
                _position = value;
                OnPropertyChanged("Position");
            }
        }

       

        /// <summary>
        /// Constructeur    
        /// </summary>
        /// <param name="bookParam">VideoLivre à étudier</param>
        public BookTimeLineVM(VideoBook bookParam)
        {
            ScaleValue = 1;
            _selectedBook = bookParam;
            _title = bookParam.Title;
            _author = bookParam.Author;
            _chapters = bookParam.Chapters;
            _totalDuration = bookParam.Duration;
            _segmentIndex = new List<SegmentIndex>[bookParam.Chapters.Length];
            _annotations = new List<Annotation>[bookParam.Chapters.Length];
            LoadElements();
            Commands.TimeChange.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(TimeChange_Executed);
            Commands.BookTimeLine.SaveAnnotations.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(SaveAnnotations_Executed);

        }

        void SaveAnnotations_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
         
        }
        private double _scaleValue;
        public double ScaleValue
        {
            get
            {
                return _scaleValue;
            }
            set
            {
                _scaleValue = value;
                OnPropertyChanged("ScaleValue");
                OnPropertyChanged("WidthTimeStrip");
            }
        }
        public double WidthTimeStrip
        {
            get
            {
                return (_selectedBook.Duration.TotalMilliseconds / BookTimeLineVM.ratioPixMs) * ScaleValue;
            }
        }
        private VideoViewerVM _videoViewerVM;
        /// <summary>
        /// ViewModel de VideoViewer
        /// </summary>
        public VideoViewerVM ViewModelVideoViewer
        {
            get
            {
                return _videoViewerVM;
            }
            set
            {
                _videoViewerVM = value;
                OnPropertyChanged("ViewModelVideoViewer");
            }
        }
        private void TimeChange_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if(e.Source == this)
            {
                ViewModelVideoViewer.GoTo(TimeSpan.FromMilliseconds(((double)e.Parameter)));
            }
        }

      
        /// <summary>
        /// Chargement des éléments du livre (Index et Annotations)
        /// </summary>
        private void LoadElements()
        {
            for(int key=0;key< _selectedBook.Chapters.Length;key++)
            {
              _segmentIndex[key] = _selectedBook.Chapters[key].Index;
              if (_selectedBook.Chapters[key].Annotations != null)
                {
                    _annotations[key] = _selectedBook.Chapters[key].Annotations;
                }
            }
        }
      
    }
}
