﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
using System.Threading;
using Iri.Modernisation.Data.LDTClass;
using System.IO;
namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// Classe VideoLivre
    /// </summary>
    public class VideoBook
    {
        /// <summary>
        /// Titre du VideoLivre
        /// </summary>
        public String Title { get; set; }

        /// <summary>
        /// Auteur du VideoLivre
        /// </summary>
        public User Author { get; set; }

        /// <summary>
        /// Chapitre du VideoLivre
        /// </summary>
        public VideoChapter[] Chapters { get; set; }

        /// <summary>
        /// Durée du VideoLivre
        /// </summary>
        public TimeSpan Duration { get; set; }

        /// <summary>
        /// Chemin de la vidéo fini
        /// </summary>
        public String MediaPath { get; set; }

        /// <summary>
        /// Chemin du projet .ldt
        /// </summary>
        public String LdtPath { get; set; }

        /// <summary>
        /// Chemin du .iri
        /// </summary>
        public String IriPath { get; set; }


        public List<PolemicLink> BasicLinks { get; set; }

        public List<PolemicLink> PolemicLinks { get; set; }
        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        public VideoBook()
        {
            BasicLinks = new List<PolemicLink>();
            PolemicLinks = new List<PolemicLink>();
            Chapters = new VideoChapter[FactoryVideoLivre.VideoChapterDescriptions.Length];
            for (int nbChapitre = 0; nbChapitre < FactoryVideoLivre.VideoChapterDescriptions.Length; nbChapitre++)
            {
                Chapters[nbChapitre] = new VideoChapter(this,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Id,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Title,
                                                         FactoryVideoLivre.VideoChapterDescriptions[nbChapitre].Color);

            }
         
        }

        public LDTFile GetLDTFile()
        {
            LDTFile ldt = new LDTFile();
            ldt.Project = new LDTProject()
             {
                 
             };
            ldt.Medias = new List<LDTMedia>()
             {
                 new LDTMedia()
                 {
                     Src = IriPath
                 }
             };
            foreach (VideoChapter Vc in Chapters)
            {
                ldt.Annotations.Add(
                       new LDTAnnotationsContent()
                       {

                       });
                foreach (Annotation An in Vc.Annotations)
                {
                    LDTAnnotationsDecoupage decoupage = new LDTAnnotationsDecoupage()
                    {
                        Title = Vc.Title,
                        Author = SettingsProject.ActualUser.UserName
                    };
                    decoupage.Elements.Add(
                                            new LDTElement()
                                            {
                                                Id = An.Id,
                                                Title = An.Title,
                                                Abstract = An.Description,
                                                Date = DateTime.Now,
                                                Begin = An.TimerIn.TotalMilliseconds,
                                                Dur = An.Duration.TotalMilliseconds,
                                                Tags = An.Tags,
                                                Author = SettingsProject.ActualUser.UserName,
                                            }
                                                );



                    ldt.Annotations[ldt.Annotations.Count - 1].Content.Add(decoupage);
                }
                foreach (PolemicLink Pl in BasicLinks)
                {
                    ldt.BasicRelations.Add(new LDTRelation()
                    {
                        Type = Pl.Type.Title,
                        IdElementFrom = Pl.FromElement.Id,
                        IdElementTo = Pl.ToElement.Id,
                        Title = Pl.ToElement.Title
                    });
                }
                foreach (PolemicLink Pl in PolemicLinks)
                {
                    ldt.PolemicRelations.Add(new LDTRelation()
                    {
                        Type = Pl.Type.Title,
                        IdElementFrom = Pl.FromElement.Id,
                        IdElementTo = Pl.ToElement.Id,
                        Title = Pl.ToElement.Title
                    });
                   
                }
               
            }
            return ldt;
        }

      

        /// <summary>
        /// Méthode static pour le Loader de la list de videoBook
        /// </summary>
        /// <param name="XDoc">XDoc du fichier pointant tous les chemin .ldt des videoLivre disponible</param>
        /// <returns>List des VideoLivre (non chargé)</returns>
        public static List<VideoBook> GetListVideoBook(XDocument XDoc)
        {
            
            List<VideoBook> ListReturn = new List<VideoBook>();
            
            foreach (XElement XVideoBook in XDoc.Root.Elements())
            {

                VideoBook temp = new VideoBook();
                temp.LdtPath = XVideoBook.Attribute("metafile").Value; ;
                temp.Title = XVideoBook.Attribute("title").Value;
                ListReturn.Add(temp);


            }
            return ListReturn;
        }
           
        
        
    }
    public class VideoBookUploader
    {
        private static Loader<LDTFile> loaderLdt = new Loader<LDTFile>(LDTFile.FromXML);
        private static LDTFile ldt = new LDTFile();
        private static VideoBook videoBookToUpdate;
        private static StreamWriter Sw;
        public static void UpdateAnnotation(VideoBook update,StreamWriter sw)
        {
            Sw = sw;
            videoBookToUpdate = update;
            loaderLdt.LoaderFinished += new EventHandler<EventArgs>(loaderLdt_LoaderFinished);
            loaderLdt.Load(videoBookToUpdate.LdtPath);

        }
        public static void UpdateAnnotation(VideoBook update)
        {
            videoBookToUpdate = update;
            loaderLdt.LoaderFinished += new EventHandler<EventArgs>(loaderLdt_LoaderFinished);
            loaderLdt.Load(videoBookToUpdate.LdtPath);

        }

        static void loaderLdt_LoaderFinished(object sender, EventArgs e)
        {
            ldt = ((LoaderEventArgs<LDTFile>)e).CreatedObject;
            ldt.Annotations.Clear();
            
            foreach (VideoChapter Vc in videoBookToUpdate.Chapters)
            {
                 ldt.Annotations.Add(
                        new LDTAnnotationsContent()
                        {
                         
                        });
                foreach(Annotation An in Vc.Annotations)
                {
                    LDTAnnotationsDecoupage decoupage = new LDTAnnotationsDecoupage()
                    {
                        Title = Vc.Title,
                        Author = SettingsProject.ActualUser.UserName
                    };
                    decoupage.Elements.Add(
                                            new LDTElement()
                                            {
                                                Id = An.Id,
                                                Title = An.Title,
                                                Abstract = An.Description,
                                                Date = DateTime.Now,
                                                Begin = An.TimerIn.TotalMilliseconds,
                                                Dur = An.Duration.TotalMilliseconds,
                                                Tags = An.Tags,
                                                Author = SettingsProject.ActualUser.UserName,
                                            }
                                                );
                  


                    ldt.Annotations[ldt.Annotations.Count - 1].Content.Add(decoupage);
                }
                foreach (PolemicLink Pl in videoBookToUpdate.BasicLinks)
                {
                    ldt.BasicRelations.Add(new LDTRelation()
                        {
                            Type = Pl.Type.Title,
                            IdElementFrom = Pl.FromElement.Id,
                            IdElementTo = Pl.ToElement.Id,
                            Title = Pl.ToElement.Title
                        });
                }
                foreach (PolemicLink Pl in videoBookToUpdate.PolemicLinks)
                {
                    ldt.PolemicRelations.Add(new LDTRelation()
                    {
                        Type = Pl.Type.Title,
                        IdElementFrom = Pl.FromElement.Id,
                        IdElementTo = Pl.ToElement.Id,
                        Title = Pl.ToElement.Title
                    });
                }
            }
           
                     WebClient WebWriter = new WebClient();
            
               
                     WebWriter.OpenWriteCompleted +=new OpenWriteCompletedEventHandler(WebWriter_OpenWriteCompleted);
          WebWriter.OpenWriteAsync(new Uri(videoBookToUpdate.LdtPath, UriKind.RelativeOrAbsolute));
                 //    WebWriter.UploadStringCompleted += new UploadStringCompletedEventHandler(WebWriter_UploadStringCompleted);
                //     WebWriter.UploadStringAsync(new Uri(videoBookToUpdate.LdtPath, UriKind.RelativeOrAbsolute),"azerty");

        }
    

        static void WebWriter_UploadStringCompleted(object sender, UploadStringCompletedEventArgs e)
        {
          
        }


        static void WebWriter_OpenWriteCompleted(object sender, OpenWriteCompletedEventArgs e)
        {
           
            
           /*using (Stream fs = e.Result)
            {

                // Add some information to the file.
                byte[] info = new System.Text.UTF8Encoding(true).GetBytes("This is some text in the file.");

                fs.Write(info, 0, info.Length);

                fs.Close();

            }*/

            StreamWriter fs = Sw;
         
                  
                    fs.Write(ldt.ToString());
                    fs.Close();
               
            
            /*StreamWriter fs = new StreamWriter(e.Result);
            //MessageBox.Show(ldt.ToString());
            fs.Write(ldt.ToString());
            fs.Flush();
            fs.Close();*/
        }
    }
    public class VideoBookLoader
    {
        private Loader<IRIFile> _iriFile;
        private Loader<LDTFile> _ldtFile;
        private IRIFile _loadedIriFile;
        private LDTFile _loadedLdtFile;
        public VideoBookLoader()
        {
            _iriFile = new Loader<IRIFile>(IRIFile.FromXML);
            _ldtFile = new Loader<LDTFile>(LDTFile.FromXML);
            _ldtFile.LoaderFinished += new EventHandler<EventArgs>(_ldtFile_LoaderFinished);
            _iriFile.LoaderFinished += new EventHandler<EventArgs>(_iriFile_LoaderFinished);
        }

        void _iriFile_LoaderFinished(object sender, EventArgs e)
        {
            _loadedIriFile = ((LoaderEventArgs<IRIFile>)e).CreatedObject;
            
            LoaderFinished(this,new LoaderEventArgs<VideoBook>(LDTFileReader.ConvertToVideoBook(_loadedLdtFile,_loadedIriFile)));
        }

        void _ldtFile_LoaderFinished(object sender, EventArgs e)
        {
            _loadedLdtFile = ((LoaderEventArgs<LDTFile>)e).CreatedObject;
            _loadedLdtFile.Path = _ldtFile.Path;
            _iriFile.Load(_loadedLdtFile.Medias[0].Src);
            
        }
        public void Load(String ldtPath)
        {
            _ldtFile.Load(ldtPath);
        }
        public event EventHandler<LoaderEventArgs<VideoBook>> LoaderFinished;

        
    }


    /// <summary>
    /// Comparateur pour Trier les livres
    /// </summary>
    public class VideoBookComparer : IComparer<VideoBook>
    {
        public int Compare(VideoBook x, VideoBook y)
        {
            return x.Title.CompareTo(y.Title);
        }
    }

}
