﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using System.Xml.Linq;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.LDTClass
{
    public class LDTFileReader
    {
        public static VideoBook ConvertToVideoBook(XDocument Path)
        {
            LDTFile _ldtFile = new LDTFile();
            _ldtFile.Load(Path);
           
            VideoBook _videoBook = new VideoBook();
            
            if (_ldtFile != null)
            {
                // Initialisation du VideoBook
                _videoBook = new VideoBook()
                {
                    Title = _ldtFile.Project.Title,
                    Author = new User()
                    {
                        UserName = _ldtFile.Project.User,
                        
                    },
                    Duration = new TimeSpan(),
                    IriPath = _ldtFile.Medias[0].Src,
                    LdtPath = _ldtFile.Path,

                };

                // Initialisation des index
                foreach (LDTAnnotationsContent LDTAC in _ldtFile.Annotations)
                {
                    int count=0;
                    int decoupage = LDTAC.Content[2].Elements.Count/4;
                    int selectedChapter = 0;
                    foreach(LDTElement LDTE  in LDTAC.Content[2].Elements)
                    {
                       
                       
                        _videoBook.Chapters[selectedChapter].Index.Add(new SegmentIndex(_videoBook.Chapters[selectedChapter])
                        {
                            Id= LDTE.Id,
                            Title = LDTE.Title,
                            Description = LDTE.Abstract,
                            Tags = LDTE.Tags,
                            TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                            Duration = new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur),
                            
                        });
                        count++;
                        if (count % decoupage == 0)
                        {
                            selectedChapter++;
                            if (selectedChapter >= 4)
                            {
                                selectedChapter = 3;
                            }
                        }
                        
                       _videoBook.Duration =  _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur));
                    }
                    foreach (LDTElement LDTE in LDTAC.Content[3].Elements)
                    {
                        _videoBook.Chapters[0].Annotations.Add(new Annotation(_videoBook.Chapters[0])
                        {
                            Id = LDTE.Id,
                            Title = LDTE.Title,
                            Description = LDTE.Abstract,
                            Tags = LDTE.Tags,
                            TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                            Duration = new TimeSpan(0, 0, 0, 0, (int)(LDTE.Dur+5000)),
                            Type = FactoryVideoLivre.AnnotationDescriptions[0]
                        });
                       // _videoBook.Duration = _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)(LDTE.Dur)));
                    }
                      foreach (LDTElement LDTE in LDTAC.Content[1].Elements)
                      {
                          _videoBook.Chapters[0].Annotations.Add(new Annotation(_videoBook.Chapters[0])
                          {
                              Title = LDTE.Title,
                              Description = LDTE.Abstract,
                              Tags = LDTE.Tags,
                              TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                              Duration = new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur),
                              Type = FactoryVideoLivre.AnnotationDescriptions[1]
                          });
                         // _videoBook.Duration = _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur));
                      }

                }
                return _videoBook;
                // Initialisation des Annotations
                //Initialisation des Liens
            }
            else
            {
                throw new Exception("Fichier LDT Null");
            }

        }
        public static VideoBook ConvertToVideoBook(LDTFile ldt, IRIFile iri)
        {
           
          
            // Initialisation du VideoBook
           VideoBook _videoBook = new VideoBook()
            {
                Title = ldt.Project.Title,
                Author = new User()
                {
                    UserName = ldt.Project.User,

                },
                Duration = new TimeSpan(),
                IriPath = ldt.Medias[0].Src,
                LdtPath = ldt.Path,
                MediaPath = iri.Body.Medias[0].Videos[0].Src

            };

            // Initialisation des index
              TimeSpan totalDur = TimeSpan.Zero;
            foreach(IRIEnsemble Iens in iri.Body.Ensembles)
            {
                int chapter = 0;
              
                foreach (IRIElement elem in Iens.Decoupages[0].Elements)
                {
                    _videoBook.Chapters[chapter].Index.Add(new SegmentIndex(_videoBook.Chapters[chapter])
                    {
                        Id = elem.Id,
                        Title = elem.Title,
                        Description = elem.Abstract,
                        Tags = elem.Tags,
                        TimerIn = elem.Begin,
                        Duration = elem.Dur

                    });
                    totalDur += elem.Dur;
                }
                chapter++;
            }

            Dictionary<String, String> BasicRelation = new Dictionary<string, string>();
            foreach (LDTRelation LDTR in ldt.BasicRelations)
            {
                BasicRelation.Add(LDTR.IdElementTo, LDTR.Type);
            }

            foreach (LDTAnnotationsContent LDTAC in ldt.Annotations)
            {
               int chapterIndex = 0;
               foreach(LDTAnnotationsDecoupage LDTAD  in LDTAC.Content)
               {
                   User author = new User() {UserName = LDTAD.Author };
                   LDTElement elem = LDTAD.Elements[0];
                   
                       _videoBook.Chapters[chapterIndex].Annotations.Add(
                           new Annotation(_videoBook.Chapters[chapterIndex])
                           {
                               Id = elem.Id,
                               Title = elem.Title,
                               Description = elem.Abstract,
                               Tags = elem.Tags,
                               TimerIn = new TimeSpan(0, 0, 0, 0, (int)elem.Begin),
                               Duration = new TimeSpan(0, 0, 0, 0, (int)elem.Dur),
                             Type = FactoryVideoLivre.DictionaryAnnotationDescriptions[BasicRelation[elem.Id]],
                               Contributer = author

                           });
                   
                 
               }
               chapterIndex++;
            }
            _videoBook.Duration = iri.Body.Medias[0].Videos[0].Dur;
            _videoBook.LdtPath = ldt.Path;
            return _videoBook;
        }
    }
}
