﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Controls.View;
using System.Collections.Generic;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class CustomableVideoElementVM : BaseMVVM.ViewModel.ViewModel
    {
        public CustomableVideoElementVM(VideoSequence paramSeq)
        {
            _videoSequence = paramSeq;
            _runTime = paramSeq.RunTime;
            _beginTrim = paramSeq.BeginTrim;
            _endTrim = paramSeq.EndTrim;
           
            OnPropertyChanged("Duration");
        }

        private VideoSequence _videoSequence;

        private TimeSpan _runTime;
        public TimeSpan RunTime 
        {
            get
            {
                return _runTime;
            }
            set
            {
                _runTime = value;
                _videoSequence.RunTime = value;
                OnPropertyChanged(String.Empty);
               
            }
        }

        private TimeSpan _beginTrim;
        public TimeSpan BeginTrim 
        {
            get
            {
                return _beginTrim;
            }
            set
            {
                _beginTrim = value;
                _videoSequence.BeginTrim = value;
                OnPropertyChanged(String.Empty);
            }
        }

        private TimeSpan _endTrim;
        public TimeSpan EndTrim 
        { 
            get
            {
                return _endTrim;
            }
            set
            {
                _endTrim = value;
                _videoSequence.EndTrim = value;
                OnPropertyChanged(String.Empty);
            }
        }

        private double _duration;
        public new double Duration
        {
            get
            {
                return( RunTime.TotalMilliseconds - (BeginTrim.TotalMilliseconds + EndTrim.TotalMilliseconds))*ProductionTimeLine.ScaleTime;
            }

        }

        private VideoChapterType _chapter;
        public VideoChapterType Chapter
        {
            get
            {
                return _chapter;
            }
            set
            {
                _chapter = value;
                OnPropertyChanged("Chapter");
            }
        }

        public new TimeSpan DurationTimeSpan
        {
            get
            {
                return _videoSequence.Duration;
            }

        }

       
        
    }
}
