﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;

namespace Iri.Modernisation.Data.LDTClass
{
    public class LDTFileReader
    {
        private LDTFile _ldtFile;
        private VideoBook _videoBook;
        public VideoBook VideoBook
        {
            get
            {
                return _videoBook;
            }
        }
        public LDTFileReader(String LDTPath)
        {
            _ldtFile = new LDTFile();
            _ldtFile.Load(LDTPath);
            ConvertLdtToVideoBook();
        }
        public LDTFileReader(LDTFile ldtFile)
        {
            _ldtFile = ldtFile;
            ConvertLdtToVideoBook();
        }
        private void ConvertLdtToVideoBook()
        {
            if (_ldtFile != null)
            {
                // Initialisation du VideoBook
                _videoBook = new VideoBook()
                {
                    Title = _ldtFile.Project.Title,
                    Author = new User()
                    {
                        UserName = _ldtFile.Project.User,
                        
                    },
                    Duration = new TimeSpan()
                    

                };

                // Initialisation des index
                foreach (LDTAnnotationsContent LDTAC in _ldtFile.Annotations)
                {
                    int count=0;
                    int decoupage = LDTAC.Content[2].Elements.Count/4;
                    int selectedChapter = 0;
                    foreach(LDTElement LDTE  in LDTAC.Content[2].Elements)
                    {
                       
                       
                        _videoBook.Chapters[selectedChapter].Index.Add(new SegmentIndex(_videoBook.Chapters[selectedChapter])
                        {
                            Title = LDTE.Title,
                            Description = LDTE.Abstract,
                            Tags = LDTE.Tags,
                            TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                            Duration = new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur),
                            
                        });
                        count++;
                        if (count % decoupage == 0)
                        {
                            selectedChapter++;
                            if (selectedChapter >= 4)
                            {
                                selectedChapter = 3;
                            }
                        }
                        
                       _videoBook.Duration =  _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur));
                    }
                    foreach (LDTElement LDTE in LDTAC.Content[3].Elements)
                    {
                        _videoBook.Chapters[0].Annotations.Add(new Annotation(_videoBook.Chapters[0])
                        {
                            Title = LDTE.Title,
                            Description = LDTE.Abstract,
                            Tags = LDTE.Tags,
                            TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                            Duration = new TimeSpan(0, 0, 0, 0, (int)(LDTE.Dur+5000)),
                            Type = PolemicElementType.Polemic
                        });
                       // _videoBook.Duration = _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)(LDTE.Dur)));
                    }
                      foreach (LDTElement LDTE in LDTAC.Content[1].Elements)
                      {
                          _videoBook.Chapters[0].Annotations.Add(new Annotation(_videoBook.Chapters[0])
                          {
                              Title = LDTE.Title,
                              Description = LDTE.Abstract,
                              Tags = LDTE.Tags,
                              TimerIn = new TimeSpan(0, 0, 0, 0, (int)LDTE.Begin),
                              Duration = new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur),
                              Type = PolemicElementType.Reference
                          });
                         // _videoBook.Duration = _videoBook.Duration.Add(new TimeSpan(0, 0, 0, 0, (int)LDTE.Dur));
                      }

                }
                // Initialisation des Annotations
                //Initialisation des Liens
            }
            else
            {
                throw new Exception("Fichier LDT Null");
            }

        }
    }
}
