﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using SLExtensions.Input;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Data.Models;
using System.Collections.Generic;
using SLExtensions.Collections.ObjectModel;

using System.Linq;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class ChutierVM : BaseMVVM.ViewModel.ViewModel
    {
        protected ObservableCollection<PolemicElement> _annotations = new ObservableCollection<PolemicElement>();
        protected ObservableCollection<PolemicElement> list = new ObservableCollection<PolemicElement>();
        public ObservableCollection<PolemicElement> Annotations
        {
            get
            {
                if (SearchWord != String.Empty)
                {
                    return list;
                }
                else
                {
                    return _annotations;
                }

            }
            set
            {
                list = value;
                OnPropertyChanged("Annotations");
            }
        }
        protected String _searchWord = "";
        public String SearchWord
        {
            get
            {
                return _searchWord;
            }

            set
            {
                _searchWord = value;
                OnPropertyChanged("SearchWord");
               
            }
        }
        public ChutierVM()
        {
          InitializeCommands();
        }

        private void InitializeCommands()
        {
             }

       

        public ChutierVM(ObservableCollection<PolemicElement> argList)
        {
            _annotations = argList;
            InitializeCommands();
        }

        protected void Search()
        {
           
              var query = from c in _annotations
                        where c.Title.Contains(_searchWord)
                        select c;
              Annotations = new ObservableCollection<PolemicElement>(query.ToList());
        }
        public void ClickAnnotation_Executed(object sender, ExecutedEventArgs e)
        {
            Annotation VB = (Annotation)e.Parameter;
            MessageBox.Show(VB.Contributer.UserName + " - " + VB.Title);
        }

        public void ChutierSearch_Executed(object sender, ExecutedEventArgs e)
        {
            Search();

        }
        
    }
    public class PersonnalChutierVM : ChutierVM
    {
        public PersonnalChutierVM(ObservableCollection<PolemicElement> argList)
            : base( argList)
        {
            InitializeCommands();
        }

        private void InitializeCommands()
        {
            Commands.PersonnalChutier.Search.Executed += new EventHandler<ExecutedEventArgs>(ChutierSearch_Executed);
            Commands.PersonnalChutier.ClickAnnotation.Executed += new EventHandler<ExecutedEventArgs>(ClickAnnotation_Executed);
        }

        
    }

    public class ReferencesChutierVM : ChutierVM
    {
        public ReferencesChutierVM(ObservableCollection<PolemicElement> argList)
            : base(argList)
        {
            InitializeCommands();
        }

        private void InitializeCommands()
        {
            Commands.ReferencesChutier.RefChutierAdd.Executed += new EventHandler<ExecutedEventArgs>(RefChutierAdd_Executed);
     
            Commands.ReferencesChutier.Search.Executed += new EventHandler<ExecutedEventArgs>(ChutierSearch_Executed);
            Commands.ReferencesChutier.ClickAnnotation.Executed += new EventHandler<ExecutedEventArgs>(ClickAnnotation_Executed);
        }
        void RefChutierAdd_Executed(object sender, ExecutedEventArgs e)
        {
             if(!_annotations.Contains((PolemicElement)e.Parameter))
             {
                  _annotations.Add((PolemicElement)e.Parameter);
             }
             else
             {
                 MessageBox.Show("Element déjà sauvegardé");
             }
           
        }

        
    }

}
