﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.Models
{
    public enum VideoChapterType
    {
        Modernite=0,
        Modernisation=1,
        Postmodernite,
        Ouverture
    }

    /// <summary>
    /// Chapitre d'un VideoLivre
    /// </summary>
    public class VideoChapter
    {
        /// <summary>
        /// VideoLivre
        /// </summary>
        public VideoBook Book {get;set;}

        /// <summary>
        /// Chapitre
        /// </summary>
        public VideoChapterType Type { get; set; }

        /// <summary>
        /// Titre du chapitre
        /// </summary>
        public String Title { get; set; }

        /// <summary>
        /// Liste des index contenu dans le chapitre
        /// </summary>
        public List<SegmentIndex> Index { get; set; }

        /// <summary>
        /// Liste des annotations contenu dans le chapitre
        /// </summary>
        public List<Annotation> Annotations { get; set; }

        /// <summary>
        /// Sequence Vidéo contenu dans le chapitre
        /// </summary>
        public List<VideoSequence> VideoSequences { get; set; }

        /// <summary>
        /// Constructeur
        /// </summary>
        /// <param name="name">Nom du chaptire</param>
        public VideoChapter(VideoBook fromBook,String name,VideoChapterType type)
        {
            Book = fromBook;
            Type = type;
            Title = name;
            Index = new List<SegmentIndex>();
            Annotations = new List<Annotation>();
            VideoSequences = new List<VideoSequence>();
            
        }
       
        



    }
}
