﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Data;
namespace Iri.Modernisation.Controls.View
{
	public partial class HeaderProductionPartControler : UserControl
	{



        public bool IsActive
        {
            get { return (bool)GetValue(IsActiveProperty); }
            set 
            { 
                
                if (value)
                {
                    Active();
                }
                else
                {
                }
                SetValue(IsActiveProperty, value);
            }
        }

        // Using a DependencyProperty as the backing store for IsActive.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty IsActiveProperty =
            DependencyProperty.Register("IsActive", typeof(bool), typeof(HeaderProductionPartControler), new PropertyMetadata(false));



        public String Text
        {
            get { return (String)GetValue(TextProperty); }
            set 
            { SetValue(TextProperty, value); 
                textBlock.Text = value; 
            }
        }
            
        // Using a DependencyProperty as the backing store for Text.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty TextProperty =
            DependencyProperty.Register("Text", typeof(String), typeof(HeaderProductionPartControler), new PropertyMetadata(""));


		
		public HeaderProductionPartControler()
		{
			// Required to initialize variables
			InitializeComponent();
            IsActive = false;
			_activated = false;
			_finished= false;
          
            
           

		}
		
        private bool _activated;
		private bool _finished;
		
		public void Active()
		{
			if(!_activated && !_finished)
			{
				VisualStateManager.GoToState(this,"Available",true);
				_activated=true;
			}
            
		}
		
		public void UnSelect()
		{
			if(_activated && !_finished)
			VisualStateManager.GoToState(this,"Available",true);
		}
		private void Button_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
		{
           
		
		}

		private void but_Click(object sender, System.Windows.RoutedEventArgs e)
		{
		     	
				if(_activated)
				{
					VisualStateManager.GoToState(this,"Finished",true);
                    if (HeaderProductionPartFinished!=null)
                    {
                      HeaderProductionPartFinished(this, new HeaderProductionPartControlerEventArgs(sender));
                    }
					_finished=true;
                    
				}
		}
        public void Select()
        {
            if (_activated && !_finished)
            {
                VisualStateManager.GoToState(this, "Selected", true);
            }
        }
		private void textBlock_MouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
		{
            if (_activated && !_finished)
            {
                if (HeaderProductionPartSelected != null)
                    HeaderProductionPartSelected(this, new HeaderProductionPartControlerEventArgs(this));
            }
        }
        public event EventHandler<HeaderProductionPartControlerEventArgs> HeaderProductionPartUnSelected;
        public event EventHandler<HeaderProductionPartControlerEventArgs> HeaderProductionPartFinished;
        public event EventHandler<HeaderProductionPartControlerEventArgs> HeaderProductionPartSelected;
	}

    public class HeaderProductionPartControlerEventArgs : EventArgs
    {
        public object sender { get; set; }
        public HeaderProductionPartControlerEventArgs(object psender)
        {
            sender = psender;
        }

    }
}