<?php
$config = array(
    'rep' => basename(__DIR__),
    'title' => 'Entretiens du Nouveau Monde Industriel 2020 - Sessions 5 et 6',
    'hashtag' => "#enmi20",
    'abstract' => "<b>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</b><br><em>Paris. Centre Pompidou. Grande Salle.<br>22 et 23 décembre 2020</em>", 

    'description' => "
    <h3>Session 5 : Éducation et capacitation dans l’ère post-véridique : technologies numériques, médias sociaux et savoirs transgénérationnels</h3>
    <p>
    En tant qu’elles constituent un nouveau milieu mnémotechnique, les technologies numériques opèrent des disruptions majeures dans les champs de la recherche et de l’éducation : plutôt que de permettre le partage de savoirs (processus dynamiques et transgénérationnels qui font l’objet de pratiques singulières), les médias sociaux favorisent la diffusion d’informations mémétiques,  chargée en signaux émotionnels, calculables par des algorithmes et susceptibles de produire des effets de “buzz” en temps réel. La loi de l’audience et du marché semble ainsi s’imposer sur ces plateformes, en dépit des nombreuses potentialités contributives des technologies numériques. En effet, contrairement aux technologies analogiques traditionnelles, les technologies numériques contiennent en puissance la possibilité de dépasser la frontière entre producteurs et consommateurs d’images, en ouvrant de nouvelles possibilités d’analyse, d’annotation et d’éditorialisation des objets temporels audiovisuels (films, émissions, vidéos, cours, etc.). De telles pratiques sont au principe de la réflexivité critique que l’école a pour fonction de développer, et qui devrait permettre aux plus jeunes générations d’affronter les enjeux de l’ère post-vérité. Alors que se développe le télé-enseignement, l’école et l’université sauront-elles inventer de nouvelles pratiques et outils capacitants fondés sur les potentialités contributives des technologies audiovisuelles numérisées ? Sauront-elles transformer les spectateurs passifs en contributeurs critiques, et les audiences en publics, afin de redonner une chance à la démocratie ?
    </p>
    <br>
    <h4>Mercredi 23 décembre – 14h00-16h30</h4>
    <ul>
    <li><b>14h00</b> : Victor Chaix (Étudiant et activiste, Institut de Recherche et d’Innovation et Association des amis de la génération Thunberg)</li>

    <li><b>14h15</b> : Tyler Reigeluth (Philosophie, université catholique de Lille)</li>

    <li><b>14h45</b> : Franck Cormerais (Sciences de l’information et de la communication, université Bordeaux Montaigne)</li>

    <li><b>15h15</b> : Maxime Barilleau (Enseignement, référent numérique et coordinateur du projet UNEJ, collège Raymond Poincaré et DANE Créteil)</li>

    <li><b>15h45</b> :  Discussion</li>

    <li><b>16h30</b> : Pause</li>
    </ul>
    <br>
    <br>
    <h3>Session 6 : Recherche et design dans les milieux digitaux : des programmes aux bifurcations</h3>
    <p>
    L’industrialisation de la production et l’avènement des sociétés de consommation ont engendré une prolétarisation des modes de vie, désormais prescrits par les campagnes publicitaires, elles-mêmes préparées par des études de marketing. La mise en circulation d’objets techniques « fermés » dont le fonctionnement interne demeure indéchiffrable et dont l’obsolescence est programmée, a contribué à transformer les praticiens en utilisateurs : alors que dans le monde industriel, l’impératif de l’innovation se substitue à l’exercice de l’invention, la socialisation des objets de la vie quotidienne, qui s’opérait traditionnellement à travers la transmission intergénérationnelle de savoirs, tend désormais à s’effectuer à travers les modes d’emploi standardisés. La numérisation des environnements et objets quotidiens (smartphones, objets et habitats connectés) a largement contribué à aggraver cette tendance, en multipliant les « boites noires » et les dispositifs d’« intelligence artificielle » « auto-apprenants ». Mais qu’appelle-t-on ici « apprendre » ? Les programmes et les logiciels peuvent-ils servir de supports pour la recherche, la création collective et la vie politique ? Comment intégrer dans les dispositifs computationnels des fonctions délibératives et interprétatives, qui dépassent les programmes calculables en produisant des bifurcations improbables ?
    </p>
    <br>
    <h4>Mercredi 23 décembre – 17h-19h30</h4>
    <ul>
    <li><b>17h00</b> : Tallulah Frappier (Design d’interaction et plateformes de délibérations, ENS Cachan) & Samuel Huron (Mines-Telecom)</li>

    <li><b>17h20</b> : Anthony Masure (Design, HEAD – Genève)</li>

    <li><b>17h40</b> : Stéphane Crozat (Framasoft et UTC)</li>

    <li><b>18h00</b> : Sébastien Massart (Directeur de la stratégie de Dassault Systèmes)</li>

    <li><b>18h30</b> : Discussion</li>
    </ul>
    <br>
    <br>
    <h3>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</h3>
    <p>22 et 23 décembre 2020<br>
    <a href=\"https://enmi-conf.org/wp/enmi20\" target=\"_blank\">https://enmi-conf.org</a>
    </p>
    <br>
    <strong>14ème édition</strong>
    <br><br>

    <p>
    Argumentaire et programme rédigés par Anne Alombert (UCL), 
    Victor Chaix (IRI) et Maël Montévil (IRI)
    </p>

    <p>
    En proposant de prendre soin de l’informatique et des générations, 
    les Entretiens du Nouveau Monde Industriel 2020 poursuivent deux objectifs principaux&nbsp;:
    </p>

    <p>
    . interroger les fondements théoriques de l’informatique 
    qui commandent le fonctionnement des technologies numériques contemporaines&nbsp;;
    </p>

    <p>
    . et concevoir de nouveaux dispositifs et de nouvelles pratiques pour mettre 
    ces technologies au service de la transmission, du partage et de la constitution de savoirs transgénérationnels.
    </p>

    <p>
    Nous tenterons ainsi de repenser la question de l’intelligence artificielle à partir 
    d’un nouveau paradigme théorique, qui ne se fonde plus sur l’analogie entre l’humain 
    et la machine, mais qui prenne en compte les interactions entre individus psychiques, 
    milieux techniques et organisations sociales : au lieu d’envisager la vie ou l’esprit 
    comme des processus de traitement d’information, comme le propose les paradigmes cybernétiques 
    et cognitivistes dominants, nous nous interrogerons sur le processus d’exosomatisation, à travers
    lequel les vivants humains extériorisent leurs fonctions noétiques dans des organes artificiels, 
    qui peuvent ainsi devenir les supports d’une mémoire collective et de savoirs transgénérationnels dont il faut prendre soin.
    </p>

    <p>
    Nous tenterons ensuite de traduire ces questions théoriques en terme de conception 
    et de développement technologiques. Comment réaliser des plateformes numériques au service 
    des relations sociales et intergénérationnelles, aujourd’hui menacées par les applications addictives 
    et l’économie des données ? Comment intégrer dans les dispositifs computationnels des fonctions délibératives
    et interprétatives, qui dépassent toujours les programmes calculables en produisant des bifurcations improbables ? 
    Comment transformer les technologies de l’information et de la communication en supports de mémoire, d’interprétation, 
    de délibération et d’invention, au service du partage des savoirs et de l’intelligence collective, et pour répondre aux 
    enjeux de l’ère post-vérité ? En un mot, comment penser un web herméneutique et transgénérationnel ?
    </p>

    <br>",

    'link' => "https://enmi-conf.org/wp/enmi20/",
    'islive' => false,
    'islive_embed' => "",
    'keywords' => "Informatique, générations, ENMI, Centre Pompidou, soin",
    'annotation_protocol_version' => "3",
    'partenaires' => "<a href=\"http://www.iri.centrepompidou.fr/\" class=\"footerLink\" target=\"_blank\">&nbsp;IRI </a> |&nbsp; <a href=\"https://www.univ-catholille.fr/\" class=\"footerLink\" target=\"_blank\">Université Catholique de Lille</a> |&nbsp; <a href=\"https://www.capdigital.com/\" class=\"footerLink\" target=\"_blank\">Cap Digital</a>  &nbsp;|&nbsp; <a href=\"http://realsms.eu/\" class=\"footerLink\" target=\"_blank\"> Real Smart Cities </a>",

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2020 - Sessions 5 et 6",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou le 23 décembre 2020',

    'client_visual' => "images/client_visual.jpg",
    'head_logo' => "images/logo-enmi.png",
    'slide_background' => "images/slide_background.jpg",
    'archive_img' => "images/archive_img.jpg",
    'metadata'    => "002ec70b-54c3-11eb-aff6-00145ea4a2be",
);
