<?php

/**
 * If you haven't edited php.ini to add the Zend Framework and the
 * Zend Framework Incubator to the PHP include_path, then do so here.
 * Don't use mine!
 */
set_include_path(
    'lib'
    . PATH_SEPARATOR . get_include_path()
);

/**
* Base configuration
*/
$C_default_rep = 'JaneMcGonigal-gameDesign';
$C_feedback_form_url = 'http://www.rslnmag.fr/blog/theme/les-rencontres-rsln/2011/7/4/jane-mcgonigal_invitee-des-rencontres-rsln_vendredi-16-septembre/';

$configuration = array(
    'siteUrl'        => 'http://twitter.com/oauth',
    'consumerKey' 	 => '***REMOVED***',
    'consumerSecret' => '***REMOVED***'
);


$req_rep = $C_default_rep;
if(isset($config) && isset($config['rep'])) {
	$req_rep = $config['rep'];
}

include_once dirname(__FILE__).'/traduction.php';
if(file_exists(dirname(__FILE__)."/$req_rep/traduction.php")) {
	include_once dirname(__FILE__)."/$req_rep/traduction.php";
}


/**
 * Make sure Zend_Oauth's Consumer is loaded
 */
require_once dirname(__FILE__).'/lib/Zend/Oauth/Consumer.php';

/** Zend_Locale */
require_once dirname(__FILE__).'/lib/Zend/Locale.php';
 
/** Zend_Translate_Adapter */
require_once dirname(__FILE__).'/lib/Zend/Translate/Adapter.php';

/**
 * Start up the ol' session engine
 */
session_start();

/**
 * Include the configuration data for our OAuth Client (array $configuration)
 */
include_once dirname(__FILE__).'/config.php';
 

$configuration['callbackUrl'] = URL_ROOT."$req_rep/callback.php";


/**
 * Setup an instance of the Consumer for use
 */
$consumer = new Zend_Oauth_Consumer($configuration);

/**
 * TRADUCTION
**/


Zend_Loader::loadClass('Zend_Translate'); 
Zend_Loader::loadClass('Zend_Http_Cookie'); 


$client = new Zend_Http_Client();
$translate = new Zend_Translate('array', $init, 'fr');

$translate->addTranslation($english, 'en');
$translate->addTranslation($japan, 'ja_JP');
$translate->addTranslation($french, 'fr');

$actual = $translate->getLocale();

//$translate->setLocale("en");
// $acceptCookie = $this->_request->getCookie('acceptCookie',0);

if(isset($_GET['lang'])==false and isset($_SESSION['lang'])==false){
	
	if($actual!='fr' and $actual!='en' and $actual!='ja_JP'){
		$translate->setLocale("fr");
		 $_SESSION['lang']="fr";
	}
	
} else if (isset($_GET['lang'])==true){
	$translate->setLocale($_GET['lang']);
    $_SESSION['lang'] = $_GET['lang'];
    $actual = $_SESSION['lang'];

} else if (isset($_SESSION['lang'])==true){
	$translate->setLocale( $_SESSION['lang']);
    $actual = $_SESSION['lang'];
	
}

$js_registry = array(
	'local' => array(
	    'jquery' 		=> URL_ROOT.'res/js/jquery-1.4.3.min.js',
	    'raphael' 		=> URL_ROOT.'res/raphael/raphael-min.js',
	    'jquery-ui' 	=> URL_ROOT.'res/js/jquery-ui-1.8.13.min.js',
	    'niceforms' 	=> URL_ROOT.'res/niceforms/niceforms.js',
	    'jquery-url' 	=> URL_ROOT.'res/js/jquery.url.js',
	    'ldtplayer' 	=> URL_ROOT.'res/metadataplayer/src/js/LdtPlayer.js',
		'fancybox' 		=> URL_ROOT.'res/jquery.fancybox/fancybox/jquery.fancybox-1.3.4.pack.js',
		'jquery-tools' 	=> URL_ROOT.'res/metadataplayer/res/js/jquery.tools.min.js',
		'tw-widget' 	=> URL_ROOT.'res/js/tw_widget.js',
		'jquery-mousewheel' => URL_ROOT.'res/jquery.fancybox/fancybox/jquery.mousewheel-3.0.4.pack.js',
		'swfobject' 	=> URL_ROOT.'res/metadataplayer/res/js/swfobject.js',
		'json-js' 		=> URL_ROOT.'res/douglascrockford-JSON-js/json2.js',

	),
	'cdn' => array(
	    'jquery' 		=> 'http://ajax.googleapis.com/ajax/libs/jquery/1.4.3/jquery.min.js',
		'raphael' 		=> URL_ROOT.'res/raphael/raphael-min.js',
		'jquery-ui' 	=> 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.13/jquery-ui.min.js',
		'niceforms' 	=> URL_ROOT.'res/niceforms/niceforms.js',
		'jquery-url' 	=> URL_ROOT.'res/js/jquery.url.js',
		'ldtplayer' 	=> URL_ROOT.'res/metadataplayer/src/js/LdtPlayer.js',
		'fancybox' 		=> URL_ROOT.'res/jquery.fancybox/fancybox/jquery.fancybox-1.3.4.pack.js',
		'jquery-tools' 	=> 'http://cdn.jquerytools.org/1.2.4/all/jquery.tools.min.js',
		'tw-widget' 	=> 'http://widgets.twimg.com/j/2/widget.js',
		'jquery-mousewheel' => URL_ROOT.'res/jquery.fancybox/fancybox/jquery.mousewheel-3.0.4.pack.js',
		'swfobject' 	=> 'http://ajax.googleapis.com/ajax/libs/swfobject/2.2/swfobject.js',
		'json-js' 		=> URL_ROOT.'res/douglascrockford-JSON-js/json2.js',
		
	)
);

$font_registry = array(
	'local' => array(
		'PT-Sans_Narrow' => URL_ROOT.'res/fonts/PT_Sans-Narrow-Web-Regular.css',
		'PT-Sans' 		 => URL_ROOT.'res/fonts/PT_Sans-Web-Regular.css',
		'Geo' 			 => URL_ROOT.'res/fonts/Geo-Regular.css'
	),
	'cdn' => array(
		'PT-Sans_Narrow' => 'http://fonts.googleapis.com/css?family=PT+Sans+Narrow&subset=latin',
		'PT-Sans' 		 => 'http://fonts.googleapis.com/css?family=PT+Sans&subset=latin',
		'Geo' 			 => 'http://fonts.googleapis.com/css?family=Geo&subset=latin'
	)
);


$css_registry = array(
	'local' => array(
	   	'blueprint-screen' => URL_ROOT.'res/blueprint/screen.css',
		'blueprint-print' => URL_ROOT.'res/blueprint/print.css',
		'blueprint-ie' => URL_ROOT.'res/blueprint/ie.css',
		'blueprint-plugins-fancy-type' => URL_ROOT.'res/blueprint/plugins/fancy-type/screen.css',
		'custom' => URL_ROOT.'res/css/custom.css',
		'fancybox' => URL_ROOT.'res/jquery.fancybox/fancybox/jquery.fancybox-1.3.4.css',
		'jquery-ui' => URL_ROOT.'res/metadataplayer/res/css/jq-css/themes/base/jquery-ui.css',
		'tabs-slideshow' => URL_ROOT.'res/css/tabs-slideshow.css',
	),
	'cdn' => array(
		'blueprint-screen' => URL_ROOT.'res/blueprint/screen.css',
		'blueprint-print' => URL_ROOT.'res/blueprint/print.css',
		'blueprint-ie' => URL_ROOT.'res/blueprint/ie.css',
		'blueprint-plugins-fancy-type' => URL_ROOT.'res/blueprint/plugins/fancy-type/screen.css',
		'custom' => URL_ROOT.'res/css/custom.css',
		'fancybox' => URL_ROOT.'res/jquery.fancybox/fancybox/jquery.fancybox-1.3.4.css',
		'jquery-ui' => "http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.13/themes/base/jquery-ui.css",
		'tabs-slideshow' => URL_ROOT.'res/css/tabs-slideshow.css',
	)
);

$archives_list = array(
    "rsln", "rsln-opendata", "rsln-mercedes-bunz",
	"enmi2011-technologie-confiance", "CPV", array("fens_FabLab_Design_Metadata","fablab"),
	array("fens_FabLab_Design_Metadata","designmd"), array("mashup","conference"), array("mashup","tableronde"),
	"sig-chi-paris-2011", "rwd-meetup-patrimoine", "JaneMcGonigal-gameDesign"
);

function registry_url($key, $type, $registry_def=null) {

	global $js_registry, $font_registry, $css_registry, $C_default_registry;

	if($registry_def != null) {
		$registry = $registry_def;
	}
	elseif(isset($C_default_registry)) {
		$registry = $C_default_registry;
	}
	else {
		$registry = 'local';
	}
	$registry_name = $type."_registry";
	return ${
		$registry_name}[$registry][$key];

}

function get_archive_box($rep, $metadata, $url_root, $basepath) {

	include("$basepath$rep/config.php");

	$id = "abox_$rep".(($metadata!=null)?"_$metadata":"");
	$hash = ($metadata!=null)?"#metadata=$metadata":"";
	$tail_img = $config['archive_img'];
	if(is_array($tail_img)) {
		$tail_img = $tail_img[$metadata];
	}
	$archive_title = $config['archive_title'];
	if(is_array($archive_title)) {
		$archive_title = $archive_title[$metadata];
	}
	$archive_description = $config['archive_description'];
	if(is_array($archive_description)) {
		$archive_description = $archive_description[$metadata];
	}


	$res  = "<div id=\"$id\" class=\"archivesVideoBox\">\n";
	$res .= "    <a href=\"$rep/polemicaltimeline.php$hash\">\n";
	$res .= "        <img src=\"$url_root$rep/$tail_img\" width=\"270\" height=\"150\"/>";
	$res .= "    </a>";
	$res .= "    <div class=\"AVBtitle\">$archive_title</div>\n";
	$res .= "    <div class=\"AVBtext\">\n";
	$res .= "        $archive_description\n";
	$res .= "    </div>\n";
	$res .= "</div>\n";

	return $res;

}

function display_archives_list($archives_list, $box_class, $url_root, $basepath) {
	for($i=0;$i<count($archives_list);$i++) {
		if(($i % 3)==0) {
			print("			    <div class=\"$box_class\">\n");
		}
		$archive_ref = $archives_list[$i];
	
		$archive_name = $archive_ref;
		$metadata = null;
		if(is_array($archive_ref)) {
			$archive_name = $archive_ref[0];
			$metadata = $archive_ref[1];
		}
		print(get_archive_box($archive_name,$metadata, $url_root, $basepath));
		if(($i % 3)==2 || $i == (count($archives_list)-1)) {
			print("			    </div>\n");
		}
	}
}


