import sqlite3
import twython

def get_option():
    
    parser = OptionParser()

    parser.add_option("-l", "--log", dest="logfile",
                      help="log to file", metavar="LOG", default="stderr")
    parser.add_option("-v", dest="verbose", action="count",
                      help="verbose", metavar="VERBOSE", default=0)
    parser.add_option("-q", dest="quiet", action="count",
                      help="quiet", metavar="QUIET", default=0)
    parser.add_option("-r", "--request", dest="request",
                      help="twitter request", metavar="REQUEST", default=0)
    #add request token
    #add 

    return parser.parse_args()

if __name__ == "__main__":

    twitter = twython.Twython()
    conn = sqlite3.connect('enmi2010_twitter_rest.db')
    try:
        conn.row_factory = sqlite3.Row
        curs = conn.cursor()
        curs.execute("create table if not exists tweet_tweet (json);")
        conn.commit()
        
        results = twitter.searchTwitter(q="#enmi", rpp="50")
        for tweet in results["results"]:
            print tweet
            curs.execute("insert into tweet_tweet (json) values (:json);", {"json":unicode(tweet)})
        conn.commit()
    finally:
        conn.close()


