# util/__init__.py
# Copyright (C) 2005-2013 the SQLAlchemy authors and contributors <see AUTHORS file>
#
# This module is part of SQLAlchemy and is released under
# the MIT License: http://www.opensource.org/licenses/mit-license.php

from .compat import callable, cmp, reduce,  \
    threading, py3k, py33, py2k, py3k_warning, jython, pypy, cpython, win32, \
    set_types, \
    pickle, dottedgetter, parse_qsl, namedtuple, next, WeakSet, reraise, \
    raise_from_cause, u, b, ue, string_types, text_type, int_types

from ._collections import KeyedTuple, ImmutableContainer, immutabledict, \
    Properties, OrderedProperties, ImmutableProperties, OrderedDict, \
    OrderedSet, IdentitySet, OrderedIdentitySet, column_set, \
    column_dict, ordered_column_set, populate_column_dict, unique_list, \
    UniqueAppender, PopulateDict, EMPTY_SET, to_list, to_set, \
    to_column_set, update_copy, flatten_iterator, \
    LRUCache, ScopedRegistry, ThreadLocalRegistry, WeakSequence

from .langhelpers import iterate_attributes, class_hierarchy, \
    portable_instancemethod, unbound_method_to_callable, \
    getargspec_init, format_argspec_init, format_argspec_plus, \
    get_func_kwargs, get_cls_kwargs, decorator, as_interface, \
    memoized_property, memoized_instancemethod, md5_hex, \
    group_expirable_memoized_property, importlater, decode_slice, \
    monkeypatch_proxied_specials, asbool, bool_or_str, coerce_kw_type,\
    duck_type_collection, assert_arg_type, symbol, dictlike_iteritems,\
    classproperty, set_creation_order, warn_exception, warn, NoneType,\
    constructor_copy, methods_equivalent, chop_traceback, asint,\
    generic_repr, counter, PluginLoader, hybridmethod, safe_reraise

from .deprecations import warn_deprecated, warn_pending_deprecation, \
    deprecated, pending_deprecation

# things that used to be not always available,
# but are now as of current support Python versions
from collections import defaultdict
from functools import partial
from functools import update_wrapper
from contextlib import contextmanager
