<?php
$config = array(
   	'hashtag'    => '#enmi13',
   	
   	'title' => "Entretiens du Nouveau Monde Industriel 2013",
   	
	'abstract'   => "<b>#ENMI13</b><br /><b>LE NOUVEL ÂGE DE L'AUTOMATISATION</b><br /> Algorithmes, données, individuations<br/><em>les 16 et 17 décembre 2013<br/>Centre Pompidou, Grande Salle</em>",
   	
   	'description'=> "<h3>LE NOUVEL ÂGE DE L'AUTOMATISATION</h3>
   	<p>Paris. Centre Pompidou. Grande Salle. 
   	<br/>16 et 17 décembre 2013</p>
    <strong>7ème édition</strong>
	<p>Les Entretiens du Nouveau Monde Industriel proposent cette année une réflexion prospective sur la question de l'automatisation qui affecte la notion même de travail et son évolution dans le contexte numérique. Si la question de l'automatisation précède et accompagne toute l'histoire de la société industrielle, elle se présente de nos jours sous un angle absolument neuf : avec la numérisation de toutes les relations (à soi, aux autres, aux choses, à l'espace, au temps), les automatismes sont désormais présents dans la plupart des activités humaines – que les humains en soient conscients ou non. C'est sur cette base que s'opère une mutation industrielle d'une immense ampleur.</p>
    <strong>Approche</strong>
    <p>L'automatisation généralisée a et aura des effets dans tous les domaines : production, enseignement, médecine, commerce, transports, recherche scientifique, édition et presse, relations sociales, vie quotidienne domestique, vie politique, relations intergénérationnelles, géopolitique, géoéconomie, diplomatie, politiques militaires, etc. Pour cette édition nous chercherons à évaluer l'impact de cette automatisation généralisée au travers d'exemples tels que les imprimantes 3D et la production décentralisée, la robotisation et la normalisation, les “big data” et plus généralement la statistique, le quantified self, …</p>
    <h3>Programme</h3>
    <p><strong>Lundi 16 décembre</strong></p>
    <ul>
        <li>
            <p><strong>9h30</strong></p>
            <p>Session 1 : L'automatisation contre l'autonomisation ?</p>
            <p>L'automatisme est généralement appréhendé comme ce qui s'oppose à l'autonomie : un comportement automatique est irréfléchi. Pourtant, l'acquisition d'automatismes, par exemple comme apprentissage de la lecture, ou comme pratique instrumentale virtuose, est la condition de ces formes caractéristiques de l'autonomie que sont la citoyenneté ou l'art du musicien. L'autonomie serait donc moins ce qui s'oppose à l'automatisme que ce qui compose avec elle. Jusqu'où et dans quelles conditions une telle composition est-elle encore possible au stade contemporain de l'automatisation ?</p>
            <p><strong>Intervenants</strong> : Bernard Stiegler (IRI), David Bates (Berkeley Un.), Patrick Crogan  (Univ. of the West of England, Bristol)</p>
        </li>
        <li>
            <p><strong>11h00</strong></p>
            <p>Session 2 : L'automatisation dans l'histoire technique, industrielle et économique et à l'époque contemporaine</p>
            <p>La « grande industrie » qui apparaît au XIXè siècle est fondée sur l'introduction des automatismes au service de la transformation de la matière. En optimisant l'automatisation, le taylorisme devient la base du fordisme, qui constitue lui-même la matrice de la destruction créatrice décrite par Joseph Schumpeter. Partiellement redistribués en pouvoir d'achat, les gains de productivité ainsi réalisés permettent la stabilisation du consumer capitalism. L'automatisation généralisée que provoque la numérisation ne remet-elle pas fondamentalement en cause ce modèle fondé sur l'emploi comme condition d'un pouvoir d'achat ? Comment concevoir la solvabilité d'un système basé sur l'automatisation généralisée et le déclin systémique de l'emploi ?</p>
            <p><strong>Intervenants</strong> : Marc Giget (IESCI), Michel Volle (Institut Xerfi) </p>
        </li>
        <li>
            <p><strong>14h</strong></p>
            <p>Session 3 : Temps du travail, temps du savoir et valeur du temps à l'époque de l'écriture réticulaire</p>
            <p>Les gains de productivité résultant de l'automatisation sont des gains de temps : peuvent-ils être redistribués sous d'autres formes que celles permises par le salariat comme pouvoir d'achat – c'est à dire sans passer par la monétisation intégrale du temps gagné en argent ? De nouvelles conceptions du temps, de la valeur et du travail sont-elles possibles au moment où la robotisation paraît conduire au pur et simple remplacement de la main d'œuvre par des systèmes automatiques intégrés cependant que, par ailleurs, la numérisation fait apparaître de nouvelles formes de production de valeur et de savoir ?</p>
            <p><strong>Intervenants</strong> : Maurizio Lazzarato (CNRS-Paris I), Jean-Yves Boulin (IRISSO-Paris X) </p>
        </li>
        <li>
            <p><strong>16h</strong></p>
            <p>Session 4 : Imprimantes 3D et production décentralisée – vers “l'usine à domicile” ?</p>
            <p>Pendant que le <em>human computing</em> semble installer un nouveau type de prolétarisation hors salariat, la technologie numérique donne corps à des réseaux de savoirs fondés sur des relations entre pairs qui paraissent constituer autant de nouveaux processus de capacitation, d'individuation et d'autonomisation – y compris dans le domaine de la production décentralisée des biens matériels par l'intermédiaire des imprimantes 3D. Les nouvelles formes de savoirs qui émergent ainsi sont elles des précurseurs d'un modèle industriel fondé sur la déprolétarisation, préfigurent-elles au contraire une forme libertarienne d'auto-aliénation, ou bien ces deux tendances sont-elles l'enjeu de choix de sociétés possibles polarisées par elles ?</p>
            <p><strong>Intervenants</strong> :  Johan Söderberg (Göteborg Un.), Camille Bosqué (Ensci), Clément Moreau (Sculptéo)</p>
        </li>
    </ul>
    <p><strong>Mardi 18 décembre </strong></p>
    <ul>
        <li>
            <p><strong>9h30</strong></p>
            <p>Session 5 : Automatisation, production et normalisation</p>
            <p>La publication et le traitement automatique de données sont conditionnés par des formats, des normes et des standards industriels à tous les niveaux.<br/>Or le numérique en réseau procède à une combinatoire exponentielle des données entre elles – ces écritures croisées que sont les hypertextes – jusqu'à produire les fameuses Big Data. Or, sachant la diversité des formats numériques, comment cette pluralité combinatoire des données peut-elle être homogène et normalisée pour être traitée de manière automatique ?<br/>Sur le chemin de l'automatisation généralisée, il y a l'épreuve de la normalisation technologique qui surdétermine les choix de société possibles ; dès lors, comment peut-on normaliser à la fois pour des questions technologiques mais aussi en même temps pour des enjeux économiques, politiques et sociaux ? Mais aussi et surtout, comment faire que les normes d'automatisation ouvrent la possibilité essentielle d'un rapport avec le non-automatique ?</p>
            <p><strong>Intervenants</strong> : Raphael Troncy (Eurecom), Christian Fauré (Ars Industrialis), Frédéric Kaplan (EPFL)</p>
        </li>
        <li>
            <p><strong>11h</strong></p>
            <p>Session 6 : Recherche scientifique et organologie numérique</p>
            <p>Quelles politiques de recherche, quelle organisation des rapports entre monde académique et développement technologique, quelle épistémologie générale et quelle épistémè faut-il concevoir à l'époque des digital humanities et des digital studies ? Quels enjeux nouveaux et bouleversements axiomatiques sont-ils induits par les technologies algorithmiques de corrélation, de visualisation et d'extrapolation big data issue des mathématiques à l'époque de l'organologie numérique? La conception fondamentalement causaliste du savoir rationnel est-elle condamnée à régresser, ou bien une nouvelle conception de sa causalité est-elle en gestation ?</p>
            <p><strong>Intervenants</strong> : François Taddeï (CRI), Francis Jutand (Institut Mines Télécom), Jean-Yves Berthou (ANR) </p>
        </li>
        <li>
            <p><strong>14h</strong></p>
            <p>Session 7 : Automates et data</p>
            <p>C'est un dispositif planétaire de publication real time fondé sur la traçabilité de toute choses et de tous comportements qui est à l'origine des très grands nombres de données et de métadonnées qui constituent ce que l'on appelle les big data. Cette publication constitue-t-elle une nouvelle res publica? Cette chose publique numérique est-elle porteuse de nouvelles formes d'intelligence collective, c'est à dire de sociétés politiques, ou bien conduit-elle à une société d'hypercontrôle automatisé, fondé sur la fascination et la stupéfaction – sinon sur la functionnal stupidity ainsi étendue bien au-delà des limites de l'entreprise ?</p>
            <p><strong>Intervenants</strong> : Henri Verdier (EtaLab), Valérie Peugeot (Orange Labs), Antoinette Rouvroy (Namur Un.)</p>
        </li>
        <li>
            <p><strong>16h</strong></p>
            <p>Session 8 : L'automatisation de soi</p>
            <p>La « quantification » de soi se développe au moment où le neuromarketing optimise ses performances en sollicitant systématiquement les automatismes pulsionnels via les observations issues de l'imagerie cérébrale. Une psyché nouvelle, fondée sur un nouveau socius digitalisé, et porteuse de capacités inédites de désautomatisation de soi (c'est à dire de production de nouvelles formes de singularités psychiques et collectives) est-elle en germe dans ce qui peut être assimilé à des technologies du soi psychique comme du soi social ? Ou bien peut-on, avec le neuromarketing, réduire tout acte individuel et collectif à un comportement de consommation (de soi comme des autres et du monde) ?</p>
            <p><strong>Intervenants</strong> : Eric Sadin (Ecrivain et philosophe), Christian Licoppe (Institut Mines Télécom), Michael Hagner (ETH Zurich) </p>
        </li>
        <li><strong>18h :</strong> Clôture des Entretiens par Jean-François Caron</li>
    </ul>
    ",
   	
   	'link' => 'http://enmi-conf.org/wp/enmi13/',
   	
   	'islive'     => true,
   	
   	'keywords'   => 'iri, nouveau monde industriel, automatisation, algorithmes',
   	
   	'rep' => basename(__DIR__),
   	
   	'partenaires'=> "<a href='http://www.iri.centrepompidou.fr/' class='footerLink' target='_blank'>IRI</a>
   	| <a href='http://www.ensci.com/' class='footerLink' target='_blank'>Ensci</a>
   	| <a href='http://www.capdigital.com/' class='footerLink' target='_blank'>Cap Digital</a>
   	| <a href='http://www.alcatel-lucent.com/' class='footerLink' target='_blank'>Alcatel Lucent</a>
   	| <a href='http://www.francetelevisions.fr/' class='footerLink' target='_blank'>France Télévisions</a>
   	| <a href='http://www.mines-telecom.fr/' class='footerLink' target='_blank'>Institut Mines-Télécom</a>",

    'client_visual' => 'images/client_visual.jpg',// 480 × 320 pixels
    
 	'head_logo' => 'images/logo-enmi.png', // 171 × 63 pixels
 	
  	'slide_background' => 'images/slide_background.jpg', // 606 × 282 pixels
    
  	'archive_img' => 'images/archive_img.jpg', // 270 × 150 pixels

 	'archive_title' => "Entretiens du Nouveau Monde Industriel 2012",
 	'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou les 16 et 17 décembre 2013',

    // After the event
	'metadata'    => "00"
);
