<?php
$config = array(
    'rep' => basename(__DIR__),
    'title' => 'Entretiens du Nouveau Monde Industriel 2020 - Session 1',
    'hashtag' => "#enmi20",
    'abstract' => "<b>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</b><br><em>Paris. Centre Pompidou. Grande Salle.<br>22 et 23 décembre 2020</em>", 

    'description' => "
    <h3>Session 1 : Vers une nouvelle informatique théorique : de l’information à l’exosomatisation, enjeux philosophiques, économiques et politiques</h3>

    <p>Le fonctionnement des dispositifs numériques et des systèmes d’intelligence artificielle contemporains repose sur des modèles théoriques hautement problématiques : la cybernétique et le cognitivisme auquel elle a donné lieu se fondent tous deux sur une notion vague d’information, qui rend possible des analogies entre les machines et le vivant d’une part, et entre les ordinateurs et le cerveau et l’esprit d’autre part, les uns et les autres étant compris comme des processus de traitement d’informations. Or, la réinscription de la machine et de l’ordinateur dans l’histoire des techniques, donc dans l’évolution exosomatique du vivant, implique un changement de paradigme théorique : loin de constituer des modèles du vivant ou de la pensée, les machines et les ordinateurs constituent des produits de la vie technique dans lesquels s’extériorisent des fonctions vitales et noétiques, qui évoluent donc avec les systèmes d’écritures et de calculs. Dès lors, la question qui se pose est moins celle des performances desdites « intelligences artificielles », que celle de la transformation des différents types de savoirs dans les milieux digitaux, et en particulier, celle de l’avenir des capacités de délibérer, de raisonner et de décider, qui sont au fondement de la vie politique, mais qui semblent bien aujourd’hui menacées par l’automatisation numérique, l’efficience des algorithmes et l’hégémonie du marché.</p>
    <br>
    <h4>Mardi 22 décembre – 09h30-12h30</h4>
    <ul>
    <li><b>09h30</b> : Introduction générale</li>

    <li><b>10h15</b> : Anne Alombert (Philosophie, université Catholique de Lille)</li>

    <li><b>10h45</b> : Mathieu Triclot  (Philosophie, université de technologie de Belfort-Montbéliard)</li>

    <li><b>11h15</b> : Pause</li>

    <li><b>11h30</b> : Daniel Ross (Philosophie politique, collectif Internation)</li>

    <li><b>12h00</b> : Discussion</li>

    <li><b>12h30</b> : Pause déjeuner</li>
    </ul>

    <br><br>
    <h3>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</h3>
    <p>22 et 23 décembre 2020<br>
    <a href=\"https://enmi-conf.org/wp/enmi20\" target=\"_blank\">https://enmi-conf.org</a>
    </p>
    <br>
    <strong>14ème édition</strong>
    <br><br>

    <p>
    Argumentaire et programme rédigés par Anne Alombert (UCL), 
    Victor Chaix (IRI) et Maël Montévil (IRI)
    </p>

    <p>
    En proposant de prendre soin de l’informatique et des générations, 
    les Entretiens du Nouveau Monde Industriel 2020 poursuivent deux objectifs principaux&nbsp;:
    </p>

    <p>
    . interroger les fondements théoriques de l’informatique 
    qui commandent le fonctionnement des technologies numériques contemporaines&nbsp;;
    </p>

    <p>
    . et concevoir de nouveaux dispositifs et de nouvelles pratiques pour mettre 
    ces technologies au service de la transmission, du partage et de la constitution de savoirs transgénérationnels.
    </p>

    <p>
    Nous tenterons ainsi de repenser la question de l’intelligence artificielle à partir 
    d’un nouveau paradigme théorique, qui ne se fonde plus sur l’analogie entre l’humain 
    et la machine, mais qui prenne en compte les interactions entre individus psychiques, 
    milieux techniques et organisations sociales : au lieu d’envisager la vie ou l’esprit 
    comme des processus de traitement d’information, comme le propose les paradigmes cybernétiques 
    et cognitivistes dominants, nous nous interrogerons sur le processus d’exosomatisation, à travers
    lequel les vivants humains extériorisent leurs fonctions noétiques dans des organes artificiels, 
    qui peuvent ainsi devenir les supports d’une mémoire collective et de savoirs transgénérationnels dont il faut prendre soin.
    </p>

    <p>
    Nous tenterons ensuite de traduire ces questions théoriques en terme de conception 
    et de développement technologiques. Comment réaliser des plateformes numériques au service 
    des relations sociales et intergénérationnelles, aujourd’hui menacées par les applications addictives 
    et l’économie des données ? Comment intégrer dans les dispositifs computationnels des fonctions délibératives
    et interprétatives, qui dépassent toujours les programmes calculables en produisant des bifurcations improbables ? 
    Comment transformer les technologies de l’information et de la communication en supports de mémoire, d’interprétation, 
    de délibération et d’invention, au service du partage des savoirs et de l’intelligence collective, et pour répondre aux 
    enjeux de l’ère post-vérité ? En un mot, comment penser un web herméneutique et transgénérationnel ?
    </p>

    <br>",

    'link' => "https://enmi-conf.org/wp/enmi20/",
    'islive' => false,
    'islive_embed' => "",
    'keywords' => "Informatique, générations, ENMI, Centre Pompidou, soin",
    'annotation_protocol_version' => "3",
    'partenaires' => "<a href=\"http://www.iri.centrepompidou.fr/\" class=\"footerLink\" target=\"_blank\">&nbsp;IRI </a> |&nbsp; <a href=\"https://www.univ-catholille.fr/\" class=\"footerLink\" target=\"_blank\">Université Catholique de Lille</a> |&nbsp; <a href=\"https://www.capdigital.com/\" class=\"footerLink\" target=\"_blank\">Cap Digital</a>  &nbsp;|&nbsp; <a href=\"http://realsms.eu/\" class=\"footerLink\" target=\"_blank\"> Real Smart Cities </a>",

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2020 - Session 1",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou le 22 décembre 2020',

    'client_visual' => "images/client_visual.jpg",
    'head_logo' => "images/logo-enmi.png",
    'slide_background' => "images/slide_background.jpg",
    'archive_img' => "images/archive_img.jpg",
    'metadata'    => "a402991e-5424-11eb-afe9-00145ea4a2be",
);
