<?php
header('P3P:CP="IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT"');
if(!isset($_REQUEST['rep'])) {
    include_once dirname(__FILE__).'/common.php';
    header('Location: ' . URL_ROOT . "$C_default_rep/client.php" );
    exit();
}

$rep = $_REQUEST['rep'];
include_once dirname(__FILE__).'/'.$rep.'/config.php';

include_once 'common.php';

/**
 * Do we already have a valid Access Token or need to go get one?
 */
if (!isset($_SESSION['TWITTER_ACCESS_TOKEN']) && isset($_GET['CONNECT']) ) {
    /**
     * Guess we need to go get one!
     */
    $token = $consumer->getRequestToken();
    $_SESSION['TWITTER_REQUEST_TOKEN'] = serialize($token);

    /**
     * Now redirect user to Twitter site so they can log in and
     * approve our access
     */
    $consumer->redirect();
} else {
    if (isset($_SESSION['TWITTER_REDIRECT_URL'])) {
        unset($_SESSION['TWITTER_REDIRECT_URL']);
    }
}


$big_visual_url = URL_ROOT."/$rep/images/big_visuel_rsln_mb.jpg";
if($translate->_('config__client_visual') != 'config__client_visual' && $translate->_('config__client_visual') != null ) {
    $big_visual_url = URL_ROOT."$rep/".$translate->_('config__client_visual');
}

$head_logo = URL_ROOT."$rep/images/head_logo.gif";
if($translate->_('config__head_logo') != 'config__head_logo' && $translate->_('config__head_logo') != null ) {
    $head_logo = URL_ROOT."$rep/".$translate->_('config__head_logo');
}

$embed = (isset($_REQUEST['embed']) && $_REQUEST['embed']);
$videoWidth = ( $embed ? 412 : 480 );
$videoHeight = ( $embed ? 280 : 320 );
if ($embed && !isset($_SESSION['TWITTER_ACCESS_TOKEN']) && (isset($_REQUEST['auth_redirect']) || isset($_SERVER['HTTP_REFERER']))) {
    $_SESSION['TWITTER_REDIRECT_URL'] = isset($_REQUEST['auth_redirect']) ? $_REQUEST['auth_redirect'] : $_SERVER['HTTP_REFERER'];
};

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN"
   "http://www.w3.org/TR/html4/strict.dtd">

<html lang="<?php echo($actual); ?>">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Live Video and Annotation</title>
    <meta http-equiv="X-UA-Compatible" content="IE=9" />

    <!-- FONT -->
    <link href='<?php echo(registry_url('PT-Sans_Narrow','font'))?>' rel='stylesheet' type='text/css'>
    <link href='<?php echo(registry_url('PT-Sans','font'))?>' rel='stylesheet' type='text/css'>
    
    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo(registry_url('fancybox','css'));?>" type="text/css" media="screen">
    <link rel="stylesheet" href="<?php echo(registry_url('tweetcast','css'));?>" type="text/css" media="screen, projection"/>

    <!-- JAVASCRIPT -->
    <script type="text/javascript" src="<?php echo(registry_url('jquery','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('jquery-mousewheel','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('jquery-scrollto','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('underscore','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('raphael','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('fancybox','js'))?>"></script>
    
    <script type="text/javascript">
        <?php
        if (isset($config['tracking_keywords']) && count($config['tracking_keywords'])) {
            echo "var tracking_keywords = ".json_encode($config['tracking_keywords']).';';
        } elseif (isset($config['hashtag'])) {
            echo "var tracking_keywords = ".json_encode(array($config['hashtag'])).";";
        }
        ?>
        <?php if (isset($config['suggested_keywords'])) echo "var suggested_keywords = ".json_encode($config['suggested_keywords']).";"; ?>
        <?php if (isset($config['js_config'])) echo $config['js_config']; ?>
        l10n = { "rechercher" : "<?php echo $translate->_('Rechercher'); ?>" }
        var annotations = {
            "default" : {
                "colors" : {
                    "h" : 0,
                    "s" : 0
                }
            },
            "positive" : {
                "display_name" : "++ | <?php echo $translate->_('Agree'); ?>",
                "keywords" : [ /\+\+/ ],
                "colors" : {
                    "h" : .3,
                    "s" : .65
                }
            },
            "negative" : {
                "display_name" : "-- | <?php echo $translate->_('Disagree'); ?>",
                "keywords" : [ /\-\-/ ],
                "colors" : {
                    "h" : 0,
                    "s" : .8
                }
            },
            "reference" : {
                "display_name" : "== | <?php echo $translate->_('Reference'); ?>",
                "keywords" : [ /\=\=/ ],
                "colors" : {
                    "h" : .16,
                    "s" : .8
                }
            },
            "question" : {
                "display_name" : "?? | <?php echo $translate->_('Question'); ?>",
                "keywords" : [ /\?\?/ ],
                "colors" : {
                    "h" : .6,
                    "s" : .8
                }
            }
        }    
    </script>
    <script type="text/javascript" src="<?php echo(registry_url('twcx-main','js'))?>"></script>

    <script type="text/javascript">
    
    function add_grammar(value) {
        var _st = $('#status'),
            _val = _st.val();
        _st.val( _val + ( _val[_val.length - 1] == " " ? "" : " " ) + value ).change();
    }
    
    $(document).ready(function() {
        
            
            function updateCounter() {
                var _v = $("#status").val();
                if (_v.length > 140) {
                    _v = _v.substr(0,140);
                    $("#status").val(_v);
                }
                $('#tweetCounter').html(140-_v.length);
                if(140-_v.length < 0) {
                    $('#tweetCounter').addClass("tweetCounterNegative");
                }
                else {
                    $('#tweetCounter').removeClass("tweetCounterNegative");
                }
                $(".tweetButton").each(function(_i, _e) {
                    if (_v.search($(_e).find('span.twbSyntax').text().replace(/(\W)/g, '\\$1')) > -1) {
                        $(_e).addClass('selected');
                    } else {
                        $(_e).removeClass('selected');
                    }
                });
            }
            
            // BUTTONS
            $(".tweetButton").click(function() {
                add_grammar($(this).find('span.twbSyntax').text());
                updateCounter();
            })
            
            // SEND TWEETS
            $("#sendTweet").click(function(){
                var MyStatus = $('#status').val();
                $.post('tweet_ajax.php', {status:MyStatus}
                ,function(data) {
                
                    if(data=="true"){
                        $("#messageSuccess").show('fast');
                        $("#messageSuccess").delay(800).hide('slow');
                        $('#status').val("<?php echo($config['hashtag']); ?>");
                        $('#status').change();
                    }else{
                        $("#error").text(data);
                        $("#messageFailed").show('fast');
                        $("#messageFailed").delay(800).hide('slow');
                    }
                    
                });
                
            });
            

            $("#status").bind("change keyup paste blur focus",updateCounter);
            
            
            $("#Program").fancybox({
                'width'             : '75%',
                'height'            : '75%',
                'autoScale'         : false,
                'transitionIn'      : 'none',
                'transitionOut'     : 'none',
                'type'              : 'iframe'
            });
            $(".embedbutton").fancybox({
                'width'             : 360,
                'height'            : 360,
                'autoDimensions'    : false,
                'transitionIn'      : 'none',
                'transitionOut'     : 'none',
                'type'              : 'iframe'
            });
            
    $("#onglets a").click(function() {
        $("div.ifwrap").hide();
        $("#onglets li").removeClass("selected");
        $(this).parent().addClass("selected");
        var hr = $(this).attr("href");
        if (hr[0] == '#') {
            $(hr).show();
        } else {
            $("#iframeWrap").show();
            $("#graphFrame").attr("src", hr);
        }
        return false;
    });
            

        });

        //<!-- LIMIT TEXTAREA:
        // End -->

    </script>
    
    <script type="text/javascript">
    
      var _gaq = _gaq || [];
      _gaq.push(['_setAccount', 'UA-23581291-1']);
      _gaq.push(['_trackPageview']);
      _gaq.push(['_setAllowAnchor', true]);
    
      (function() {
        var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
        ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
        var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
      })();
    
    </script>
    
  </head>
  <body<?php if ($embed) { echo ' class="embed"'; } ?>>
    <div id="sendUsFeedBack"><a href="<?php echo($C_feedback_form_url); ?>" target="_blank"><img src="<?php echo(URL_ROOT); ?>images/sendusfeedback.png"></a></div>

        <div id="container">
            
            <div id="coldroite">
                
                <div class="embedbar">
                    <a class="embedbutton" href="<?php echo(URL_ROOT.$rep)?>/live_embed_form.php">Intégrer</a>
                    <!-- AddThis Button BEGIN -->
                    <div class="addthis_toolbox addthis_default_style addthis_32x32_style">
                        <a class="addthis_button_facebook"></a>
                        <a class="addthis_button_twitter"></a>
                        <a class="addthis_button_email"></a>
                        <a class="addthis_button_compact"></a>
                    </div>
                    <script type="text/javascript" src="http://s7.addthis.com/js/250/addthis_widget.js"></script>
                    <!-- AddThis Button END -->
                </div>
                <ul id="onglets">
<?php if (isset($config['semantic_board']) or isset($config['knowtex_url'])) { ?>
                    <li class="selected">
                        <a href="#vlWrap"><?php echo($translate->_('Video')); ?></a>
                    </li>
<?php } ?>
<?php if (isset($config['semantic_board']) and $config['semantic_board']) { ?>
                    <li>
                        <a href="semanticboard.php?small=1&theme=jour"><?php echo($translate->_('SemanticBoard')); ?></a>
                    </li>
<?php } ?>
<?php if (isset($config['knowtex_url'])) { ?>
                    <li>
                        <a href="<?php echo $config['knowtex_url'] ?>"><?php echo($translate->_('SocialGraph')); ?></a>
                    </li>
<?php } ?>
                </ul>
                <div class="ifwrap" id="vlWrap">
                    <div id="videoLivePlayer">
                    <?php if (isset($config['islive']) && $config['islive']):?>
                        <object id="player" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" name="player" width="<?php echo $videoWidth; ?>" height="<?php echo $videoHeight; ?>">
                            <param name="movie" value="<?php echo(URL_ROOT); ?>res/mediaplayer/player.swf" />
                            <param name="allowfullscreen" value="true" />
                            <param name="allowscriptaccess" value="always" />
                            <param name="wmode" value="transparent" />
                            <?php

function flv_param($name,$default) {
    global $config;
    return ( isset($config["flv_$name"]) ? ( $config["flv_$name"] ? "&$name=".$config["flv_$name"] : "" ) : "&$name=$default" );
}

$flashvars = "autostart=true&live=true".flv_param("provider", "rtmp").flv_param("streamer", "rtmp://media.iri.centrepompidou.fr/ddc_player/").flv_param("file", "livestream")."&image=$big_visual_url&controlbar=none&autostart=true";
                            ?>
                            <param name="flashvars" value="<?php echo $flashvars; ?>" />
                            <embed
                                type="application/x-shockwave-flash"
                                id="player2"
                                name="player2"
                                src="<?php echo(URL_ROOT); ?>res/mediaplayer/player.swf"
                                width="<?php echo $videoWidth; ?>"
                                height="<?php echo $videoHeight; ?>"
                                allowscriptaccess="always"
                                allowfullscreen="true"
                                wmode="transparent"
                                flashvars="<?php echo $flashvars; ?>"
                            />
                        </object>
                    <?php elseif(isset($config['islive_embed']) && $config['islive_embed']):?>
                        <?php echo str_replace(array('{{width}}','{{height}}'), array($videoWidth, $videoHeight), $config['islive_embed']); ?>
                    <?php else: ?>
                        <img class="live-thumbnail" src="<?php echo($big_visual_url); ?>" />
                    <?php endif; ?>
                    </div>
                </div>
                <div class="ifwrap hidden" id="iframeWrap">
                    <iframe id="graphFrame"></iframe>
                </div>
                <div id="out_fleche">
                <!--    <div id="in_fleche"></div> -->
                </div>
                <ul id="accordeon">
                    <li class="acctitre">
                        <h3><?php echo($translate->_('config__title')); ?></h3>
                    </li>
                    <li class="acctexte">
                        <p><?php echo($translate->_('config__description')); ?></p>
                    </li>
                    <li class="acctitre">
                        <h3><?php echo($translate->_('keywords')); ?></h3>
                    </li>
                    <li>
                        <ul>
                            <li class="acctexte">
                                <div class="accsubtitle">
                                    <div class="aroundsubtitle">
                                        <h4><?php echo($translate->_('suggested')); ?></h4>
                                    </div>
                                </div>
                                <div class="tagcloud" id="suggkw">
                                    <div class="clearer"></div>
                                </div>
                            </li>
                            <li class="acctexte">
                                <div class="accsubtitle">
                                    <div class="aroundsubtitle">
                                        <h4><?php echo($translate->_('contextual')); ?></h4>
                                    </div>
                                </div>
                                <div class="tagcloud" id="motscles">
                                    <div class="clearer"></div>
                                </div>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <div id="colgauche">
                <div class="barre">
                    <img id="headlogo" src="<?php echo($head_logo); ?>" width="171" height="63" />
                    <div id="minilogo"></div>
                    <ul class="menu">
                        <li>
                            <a href="<?php echo(URL_ROOT); ?>" class="menuLink">
                                <?php print $translate->_("Accueil"); ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo($translate->_('config__link')); ?>" class="menuLink" target="_blank" id='Program'>
                                <?php print $translate->_("Programme"); ?>
                            </a>
                        </li>
                        <li>
                            <a href="../about.php" class="menuLink" >
                                <?php print $translate->_("A propos"); ?>
                            </a>
                        </li>
                    </ul>
                    <ul class="menu">
                        <li>
                            <a href="<?php URL_ROOT ?>client.php?lang=ja_JP" class="menuLink" >
                                <img src='<?php echo(URL_ROOT); ?>images/flag_jp.gif'<?php if($actual!="ja_JP"){echo("style='opacity: .5;'"); } ?> />
                                <?php print $translate->_("Japonais"); ?>
                            </a></li>
                        <li>
                            <a href="<?php URL_ROOT ?>client.php?lang=fr" class="menuLink">
                                <img src='<?php echo(URL_ROOT); ?>images/flag_fr.gif' <?php if($actual!="fr"){echo("style='opacity: .5;'"); } ?> />
                                <?php print $translate->_("Français"); ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?php URL_ROOT ?>client.php?lang=en" class="menuLink">
                                <img src='<?php echo(URL_ROOT); ?>images/flag_en.gif' <?php if($actual!="en"){echo("style='opacity: .5;'"); } ?> />
                                <?php print $translate->_("Anglais"); ?>
                            </a>
                        </li>
                    </ul>
                </div>
                <div id="twwWrap">
                    <div id="tweetWriter">
                            <?php if (isset($_SESSION['TWITTER_ACCESS_TOKEN'])): ?>
                            <div id="tweetCounter"><?php echo(140-strlen($config['hashtag']));?></div>
                            <?php endif;?>
                        <h3 class="tweetWriterTitle"><?php print $translate->_("ClientTitle1 :"); ?></h3>
                        <form  action="tweet.php" method="post" id="statusform" >
                            <?php if (!isset($_SESSION['TWITTER_ACCESS_TOKEN'])){
                                echo("<div class='loginbutton'><a href='".URL_ROOT."$rep/client.php?CONNECT=true' target='_top' class='loginlink'>".$translate->_("Vous n'êtes pas connecté.")."</a></div>");
                            } else {
                                echo("<textarea name='status' id='status' rows='3' cols='50'>$config[hashtag]</textarea>");
                            }
                            ?>
                            <div id="messageSuccess" style="background-color:lightgreen; display: none;">
                                <?php print $translate->_("Envoyé"); ?><br/><br/>
                            </div>
                            <div id="messageFailed" style="background-color:red; display: none;">
                                <?php print $translate->_("Erreur1"); ?><div id="error">&nbsp;</div><br/><br/>
                            </div>
                            <a href="#"  id="sendTweet" >
                                <span><?php print $translate->_("Envoyer"); ?></span>
                            </a>
                            <a id="positive" title="++ | <?php echo $translate->_('Agree'); ?>" class="tweetButton twbGreen">
                                <span class="twbSyntax">++</span>
                                <span class="twbSeparator">|</span>
                                <span class="twbLabel"><?php echo $translate->_('Agree'); ?></span>
                            </a>
                            <a id="negative" title="-- | <?php echo $translate->_('Disagree'); ?>" class="tweetButton twbRed">
                                <span class="twbSyntax">--</span>
                                <span class="twbSeparator">|</span>
                                <span class="twbLabel"><?php echo $translate->_('Disagree'); ?></span>
                            </a>
                            <a id="reference" title="== | <?php echo $translate->_('Reference'); ?>" class="tweetButton twbYellow">
                                <span class="twbSyntax">==</span>
                                <span class="twbSeparator">|</span>
                                <span class="twbLabel"><?php echo $translate->_('Reference'); ?></span>
                            </a>
                            <a id="question" title="?? | <?php echo $translate->_('Question'); ?>" class="tweetButton twbBlue">
                                <span class="twbSyntax">??</span>
                                <span class="twbSeparator">|</span>
                                <span class="twbLabel"><?php echo $translate->_('Question'); ?></span>
                            </a>
                            
                            <div style="clear: both;"></div>
                        </form>
                    </div>
                </div>
                <div id="tweetviz">
                    <div class="barre">
                        <form id="recherche">
                            <input autocomplete="off" class="greyed" id="inp_q" value="<?php echo $translate->_('Rechercher'); ?>" />
                            <input id="inp_submit" type="submit" />
                            <input id="inp_reset" type="reset" />
                            <div id="time_controls">
                                <div id="time_legende"></div>
                                <div id="time_scale"></div>
                                <a href="#" id="time_zoomout"></a>
                                <a href="#" id="time_zoomin"></a>
                            </div>
                            <div id="recherche_annot">
                                <?php echo $translate->_('SearchByPolemic'); ?> : <span id="rech_list_annot"></span><br />
                            </div>
                        </form>
                    </div>
                    <ul id="tweetlist"></ul>
                    <div id="timeline"></div>
                    <div id="scrollcont">
                        <div id="scrollin"></div>
                    </div>
                </div>
            </div>
            <div class="footer">
                <hr />
         <?php
                echo($translate->_('config__partenaires'));
                
                if (isset($_SESSION['TWITTER_ACCESS_TOKEN'])){
                    echo("| <a href='clear.php' class='footerLink'>".$translate->_("D&eacute;connexion")."</a>");
                }
         ?>
            </div>
        </div>
        <div id="hovertweet">
            <div id="hovercontent"></div>
            <div id="hoverarrow"></div>
        </div>
        <ul id="hoverkw">
            <li><a id="hkwsearch" href="#"><?php echo $translate->_('Rechercher'); ?></a></li>
            <li><a id="hkwtweet" href="#"><?php echo $translate->_('addToTweet'); ?></a></li>
        </ul>
  </body>
</html>