<?php
header('P3P:CP="IDC DSP COR ADM DEVi TAIi PSA PSD IVAi IVDi CONi HIS OUR IND CNT"');
if(!isset($_REQUEST['rep'])) {
    include_once __DIR__.'/common.php';
    header('Location: ' . URL_ROOT . "$C_default_rep/client.php" );
    exit();
}

$rep = $_REQUEST['rep'];
include_once __DIR__.'/'.$rep.'/config.php';

include_once 'common.php';

/**
 * Do we already have a valid Access Token or need to go get one?
 */
if ((!isset($_SESSION['SOCIAL_ACCESS_TOKEN'])) && isset($_GET['CONNECT']) ) {
    
    // /**
    //  * Guess we need to go get one!
    //  */
    // $token = $consumer->getRequestToken();
    // $_SESSION['TWITTER_REQUEST_TOKEN'] = serialize($token);

    // /**
    //  * Now redirect user to Twitter site so they can log in and
    //  * approve our access
    //  */
    // $consumer->redirect();
    $socialDomain = $_GET['CONNECT'];
    if (isset($_SESSION['SOCIAL_AUTH_STATE'])) {
        unset($_SESSION['SOCIAL_AUTH_STATE']);
    }
    $get_social_request_token($socialDomain, $config);
} else {
    if (isset($_SESSION['TWITTER_REDIRECT_URL'])) {
        unset($_SESSION['TWITTER_REDIRECT_URL']);
    }
}


$big_visual_url = URL_ROOT."/$rep/images/big_visuel_rsln_mb.jpg";
if($translate->_('config__client_visual') != 'config__client_visual' && $translate->_('config__client_visual') != null ) {
    $big_visual_url = URL_ROOT."$rep/".$translate->_('config__client_visual');
}

$head_logo = URL_ROOT."$rep/images/head_logo.gif";
if($translate->_('config__head_logo') != 'config__head_logo' && $translate->_('config__head_logo') != null ) {
    $head_logo = URL_ROOT."$rep/".$translate->_('config__head_logo');
}

$embed = (isset($_REQUEST['embed']) && $_REQUEST['embed']);
$embed_video = isset($_REQUEST['embed_video']) ? 
    boolval($_REQUEST['embed_video']) :
    (isset($config['islive_embed']) && $config['islive_embed']) || (isset($config['islive']) && $config['islive']);
$videoWidth = ( $embed ? 412 : 480 );
$videoHeight = ( $embed ? 280 : 320 );
if ($embed && !isset($_SESSION['SOCIAL_ACCESS_TOKEN']) && (isset($_REQUEST['auth_redirect']) || isset($_SERVER['HTTP_REFERER']))) {
    $_SESSION['TWITTER_REDIRECT_URL'] = isset($_REQUEST['auth_redirect']) ? $_REQUEST['auth_redirect'] : $_SERVER['HTTP_REFERER'];
};

$defaultAnnotations = get_default_annotations_config($config, $translate);
$annotations = array();
foreach ($defaultAnnotations as $annot_cat => $annot_def) {
    if($annot_cat !== 'default' && !isset($annot_def['colors_class'])) {
        $annot_def['colors_class'] = 'tweetButton_'.md5($annot_cat);
    }
    $annotations[$annot_cat] = $annot_def;
}


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN"
   "http://www.w3.org/TR/html4/strict.dtd">

<html lang="<?php echo($actual); ?>">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Polemic Tweet &mdash; <?php echo($translate->_('config__title')); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=9" />
    <link rel="icon" type="image/x-icon" href="<?php echo(URL_ROOT); ?>images/favico.png">

    <!-- CSS -->
    <link href='<?php echo(URL_ROOT); ?>res/css/main.css' rel='stylesheet' type='text/css'/>
    <link href='<?php echo(URL_ROOT); ?>res/css/vendors.css' rel='stylesheet' type='text/css'/>
    <link href='<?php echo(URL_ROOT); ?>res/css/common.css' rel='stylesheet' type='text/css'/>

    <!-- JAVASCRIPT -->
    <?php if( isset($config['additional_js']) && !empty($config['additional_js'])) { 
        foreach ($config['additional_js'] as $jsUrl) {?>
    <script type="text/javascript" src="<?php echo($jsUrl)?>"></script>
        <?php }
    } ?>

    <style>
    video {
       width: <?php echo($videoWidth); ?>px;
       height: <?php echo($videoHeight); ?>px;
    }
    <?php
    foreach ($annotations as $annot_cat => $annot_def) {
        if($annot_cat === 'default') {
            continue;
        }
        $hVal = intval(($annot_def['colors']['h']<1.0)?floatval($annot_def['colors']['h']) * 360.0:$annot_def['colors']['h']);
        $sVal = intval(floatval($annot_def['colors']['s']) * 100.0);

        $baseColor = "hsl($hVal, {$sVal}%, 90%)";
        $borderColor = "hsl($hVal, {$sVal}%, 60%)";
        $selectedColor = "hsl($hVal, 15%, 70%)";
        $selectedBorderColor = "hsl($hVal, 15%, 60%)";
        $gradientColor = "hsl($hVal, {$sVal}%, 50%)";
    ?>
    .tweetButton.<?php echo($annot_def['colors_class']) ?> {
        background: <?php echo($baseColor); ?>;
        border: solid <?php echo($borderColor); ?> 1px;
        background-image: -webkit-linear-gradient(top, <?php echo($baseColor); ?>, <?php echo($gradientColor); ?>);
        background-image: -moz-linear-gradient(top, <?php echo($baseColor); ?>, <?php echo($gradientColor); ?>);
        background-image: -ms-linear-gradient(top, <?php echo($baseColor); ?>, <?php echo($gradientColor); ?>);
        background-image: -o-linear-gradient(top, <?php echo($baseColor); ?>, <?php echo($gradientColor); ?>);
        background-image: linear-gradient(to bottom, <?php echo($baseColor); ?>, <?php echo($gradientColor); ?>);  
    } <?php // eslint-disable-line ?>
    .tweetButton.<?php echo($annot_def['colors_class']) ?>.selected,.tweetButton:active.<?php echo($annot_def['colors_class']) ?>:active,.tweetButton:hover.<?php echo($annot_def['colors_class']) ?>:hover.selected {
        background: <?php echo($selectedColor); ?>;
        border: solid <?php echo($selectedBorderColor); ?> 1px;
    } <?php // eslint-disable-line ?>
    .tweetButton.<?php echo($annot_def['colors_class']) ?>:hover {
        background-image: -webkit-linear-gradient(top, <?php echo($gradientColor); ?>, <?php echo($baseColor); ?>);
        background-image: -moz-linear-gradient(top, <?php echo($gradientColor); ?>, <?php echo($baseColor); ?>);
        background-image: -ms-linear-gradient(top, <?php echo($gradientColor); ?>, <?php echo($baseColor); ?>);
        background-image: -o-linear-gradient(top, <?php echo($gradientColor); ?>, <?php echo($baseColor); ?>);
        background-image: linear-gradient(to bottom, <?php echo($gradientColor); ?>, <?php echo($baseColor); ?>);
    } <?php // eslint-disable-line ?>
    <?php } ?>
    </style>

    <script type="text/javascript">
        var social_login_domain = "<?php echo($_SESSION['SOCIAL_LOGIN_DOMAIN']); ?>";
        var social_access_token = "<?php echo(unserialize($_SESSION['SOCIAL_ACCESS_TOKEN'])); ?>";
        var social_network = '<?php echo($config['social_network']); ?>' || 'Twitter';
        var social_group = "<?php echo($config['group']); ?>";
        <?php
        if (isset($config['tracking_keywords']) && count($config['tracking_keywords'])) {
            echo "var tracking_keywords = ".json_encode($config['tracking_keywords']).';';
        } elseif (isset($config['hashtag'])) {
            echo "var tracking_keywords = ".json_encode(array($config['hashtag'])).";";
        }
        ?>
        <?php if (isset($config['suggested_keywords'])) echo "var suggested_keywords = ".json_encode($config['suggested_keywords']).";"; ?>
        <?php if (isset($config['js_config'])) echo "\n".$config['js_config']."\n"; ?>
        l10n = { "rechercher" : "<?php echo $translate->_('Rechercher'); ?>" }
        if (typeof annotations == "undefined" || !annotations) {
            var annotations = JSON.parse("<?php echo addslashes(json_encode($annotations)); ?>");
            for(var annot_cat in annotations) {
                if("keywords" in annotations[annot_cat]) {
                    annotations[annot_cat]['keywords'] = [ new RegExp(annotations[annot_cat]['keywords']), ];
                }
            }
        }
        global.annotations = annotations;
        console.log("ANNOTATIONS",annotations);
    </script>
    <?php if (isset($_SESSION['SOCIAL_ACCESS_TOKEN'])) { ?>
    <script type="text/javascript" src="<?php echo(URL_ROOT); ?>res/js/live-polemic.js" ></script>
    <?php } ?>
    <script type="text/javascript">

    function add_grammar(value) {
        var _st = $('#status'),
            _val = _st.val();
        _st.val( _val + ( _val[_val.length - 1] == " " ? "" : " " ) + value ).change();
    }

    $(document).ready(function() {

            const TWEET_LENGTH = <?php echo(TWEET_LENGTH)?>;
            function updateCounter() {
                var _v = $("#status").val();
                if(!_v) {
                    return;
                }
                var _tRes = twitter.parseTweet(_v);
                if(_tRes.valid) {
                    $('#tweetCounter').removeClass("tweetCounterNegative");
                    $('#sendTweet').prop("disabled",false);
                    $('#sendTweet').removeClass("sendTweetDisabled");
                    $('#tweetCounter').html("");
                } else {
                    $('#tweetCounter').addClass("tweetCounterNegative");
                    $('#sendTweet').prop("disabled",true);
                    $('#sendTweet').addClass("sendTweetDisabled");
                    $('#tweetCounter').html(_tRes.validRangeEnd - _tRes.displayRangeEnd);
                }
                $(".tweetButton").each(function(_i, _e) {
                    if (_v.search($(_e).find('span.twbSyntax').text().replace(/(\W)/g, '\\$1')) > -1) {
                        $(_e).addClass('selected');
                    } else {
                        $(_e).removeClass('selected');
                    }
                });
            }
            updateCounter();

            // BUTTONS
            $(".tweetButton").click(function() {
                add_grammar($(this).find('span.twbSyntax').text());
                updateCounter();
            })

            // SEND TWEETS
            $("#sendTweet").click(function(e){
                if($('#sendTweet').prop('disabled')) {
                    console.log("Send disabled")
                    return;
                }
                $('#sendTweet').prop('disabled', true);
                $('#sendTweet').toggleClass('sending');
                var MyStatus = $('#status').val();
                $.post('tweet_ajax.php', {
                    status:MyStatus,
                    social_network: "<?php echo($config['social_network']) ?>",
                    domain: "<?php echo(isset($_SESSION['SOCIAL_LOGIN_DOMAIN'])?$_SESSION['SOCIAL_LOGIN_DOMAIN']:'') ?>",
                    hashtag: "<?php echo($config['hashtag']) ?>",
                    group: "<?php echo($config['group'] ?? "") ?>"
                    }
                ,function(data) {

                    $('#sendTweet').toggleClass('sending');
                    $('#sendTweet').prop('disabled', false);
                    if(data=="true"){
                        $("#messageSuccess").show('fast');
                        $("#messageSuccess").delay(800).hide('slow');
                        $('#status').val("<?php echo($config['hashtag']); ?>");
                        $('#status').change();
                    }else{
                        $("#error").text(data);
                        $("#messageFailed").show('fast');
                        $("#messageFailed").delay(800).hide('slow');
                    }

                });

            });


            $("#status").bind("change keyup paste blur focus",updateCounter);


            $("#Program").fancybox({
                'width'             : '75%',
                'height'            : '75%',
                'autoScale'         : false,
                'transitionIn'      : 'none',
                'transitionOut'     : 'none',
                'type'              : 'iframe'
            });
            $(".embedbutton").fancybox({
                'width'             : 360,
                'height'            : 360,
                'autoDimensions'    : false,
                'transitionIn'      : 'none',
                'transitionOut'     : 'none',
                'type'              : 'iframe'
            });

            $("#onglets a").click(function() {
                $("div.ifwrap").hide();
                $("#onglets li").removeClass("selected");
                $(this).parent().addClass("selected");
                var hr = $(this).attr("href");
                if (hr[0] == '#') {
                    $(hr).show();
                } else {
                    $("#iframeWrap").show();
                    $("#graphFrame").attr("src", hr);
                }
                return false;
            });

        });

        // hightlight
        <?php
        $effect = "highlight";
        if(isset($_REQUEST['highlight_effect']) && !empty($_REQUEST['highlight_effect'])) {
            $effect = $_REQUEST['highlight_effect'];
        }
        if( isset($_REQUEST['highlight']) && !empty($_REQUEST['highlight'])) { ?>
        $(function() {
            $("<?php echo $_REQUEST['highlight'];?>").delay(1000).effect("<?php echo $effect; ?>", {}, 5000);
        });
        <?php } ?>

        //<!-- LIMIT TEXTAREA:
        // End -->

    </script>
  </head>
  <body<?php if ($embed) { echo ' class="embed"'; } ?>>
    <!--div id="sendUsFeedBack"><a href="<?php echo($C_feedback_form_url); ?>" target="_blank"><img src="<?php echo(URL_ROOT); ?>images/sendusfeedback.png"></a></div-->

        <div id="container">

            <div id="coldroite">

                <div class="embedbar">
                    <a class="embedbutton" href="<?php echo(URL_ROOT.$rep)?>/live_embed_form.php">Intégrer</a>
                    <?php
                    $share_title = "Polemic Tweet - ".$translate->_('config__title');
                    $share_url = rtrim(URL_ROOT,"/").$rep;
                    $share_description = strip_tags(preg_replace('/<\s?br\s*\\?>/i', "\n", str_replace("&nbsp;", " ", $translate->_('config__abstract'))));
                    ?>
                    <!-- cf. https://sharingbuttons.io/ -->
                    <div class="share_toolbox">
                        <!-- Sharingbutton E-Mail -->
                        <a class="resp-sharing-button__link" href="mailto:?subject=<?php echo rawurlencode($share_title); ?>&amp;body=<?php echo rawurlencode("$share_description - $share_url"); ?>" target="_self" rel="noopener" aria-label="">
                          <div class="resp-sharing-button resp-sharing-button--email resp-sharing-button--small"><div aria-hidden="true" class="resp-sharing-button__icon resp-sharing-button__icon--solid">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M22 4H2C.9 4 0 4.9 0 6v12c0 1.1.9 2 2 2h20c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM7.25 14.43l-3.5 2c-.08.05-.17.07-.25.07-.17 0-.34-.1-.43-.25-.14-.24-.06-.55.18-.68l3.5-2c.24-.14.55-.06.68.18.14.24.06.55-.18.68zm4.75.07c-.1 0-.2-.03-.27-.08l-8.5-5.5c-.23-.15-.3-.46-.15-.7.15-.22.46-.3.7-.14L12 13.4l8.23-5.32c.23-.15.54-.08.7.15.14.23.07.54-.16.7l-8.5 5.5c-.08.04-.17.07-.27.07zm8.93 1.75c-.1.16-.26.25-.43.25-.08 0-.17-.02-.25-.07l-3.5-2c-.24-.13-.32-.44-.18-.68s.44-.32.68-.18l3.5 2c.24.13.32.44.18.68z"/></svg>
                            </div>
                          </div>
                        </a>
                    </div>
                </div>
                <ul id="onglets">
<?php if (isset($config['semantic_board']) or isset($config['knowtex_url'])) { ?>
                    <li class="selected">
                        <a href="#vlWrap"><?php echo($translate->_('Video')); ?></a>
                    </li>
<?php } ?>
<?php if (isset($config['semantic_board']) and $config['semantic_board']) { ?>
                    <li>
                        <a href="semanticboard.php?small=1&theme=jour"><?php echo($translate->_('SemanticBoard')); ?></a>
                    </li>
<?php } ?>
<?php if (isset($config['knowtex_url'])) { ?>
                    <li>
                        <a href="<?php echo $config['knowtex_url'] ?>"><?php echo($translate->_('SocialGraph')); ?></a>
                    </li>
<?php } ?>
                </ul>
                <div class="ifwrap" id="vlWrap">
                    <div id="videoLivePlayer">
                    <?php if(!$embed_video): ?>
                        <?php if(!$embed): ?>
                          <img src='<?php echo($big_visual_url); ?>' />
                        <?php else: ?>
                          <img width=<?php echo($videoWidth); ?> height=<?php echo($videoHeight); ?> src='<?php echo($big_visual_url); ?>' />
                        <?php endif; ?>
                    <?php elseif(isset($config['islive_embed']) && $config['islive_embed']):?>
                        <?php echo str_replace(array('{{width}}','{{height}}'), array($videoWidth, $videoHeight), $translate->_('config__islive_embed')); ?>
                    <?php else: ?>
                        <video id="videoPlayer" width=<?php echo($videoWidth); ?> height=<?php echo($videoHeight); ?> autoplay controls poster="<?php echo($big_visual_url); ?>" class="video-js vjs-default-skin"><img class="live-thumbnail" src="<?php echo($big_visual_url); ?>" /></video>
                    <?php endif; ?>
                    </div>
<?php
    if (isset($config['islive']) && $config['islive']) {
        $videofile = $translate->_('config__video_file');
        if ($videofile === 'config__video_file') $videofile = "https://media.iri.centrepompidou.fr/dash/livestream.mpd";
?>

                    <script type="text/javascript">
                        (function(){
                            var url = "<?php echo($videofile)?>";
                            var player = dashjs.MediaPlayer().create();
                            player.initialize(document.querySelector("#videoPlayer"), url, true);
                        })();
                    </script>
<?php
    }
?>

                </div>
                <div class="ifwrap hidden" id="iframeWrap">
                    <iframe id="graphFrame"></iframe>
                </div>
                <ul class="accordeon">
                    <li class="acctitre" id="event-title">
                        <h3><?php echo($translate->_('config__title')); ?></h3>
                    </li>
                    <li class="acctexte acclimited" id="event-description">
                        <?php echo($translate->_('config__description')); ?>
                    </li>
                    <li class="acctitre">
                        <h3><?php echo($translate->_('keywords')); ?></h3>
                    </li>
                    <li>
                        <ul>
                            <li class="acctexte">
                                <div class="accsubtitle">
                                    <div class="aroundsubtitle">
                                        <h4><?php echo($translate->_('suggested')); ?></h4>
                                    </div>
                                </div>
                                <div class="tagcloud" id="suggkw">
                                    <div class="clearer"></div>
                                </div>
                            </li>
                            <li class="acctexte">
                                <div class="accsubtitle">
                                    <div class="aroundsubtitle">
                                        <h4><?php echo($translate->_('contextual')); ?></h4>
                                    </div>
                                </div>
                                <div class="tagcloud" id="motscles">
                                    <div class="clearer"></div>
                                </div>
                            </li>
                        </ul>
                    </li>
                </ul>
                <p id="iri_logo" style="text-align:right;">
                    Powered by <a href="http://www.iri.centrepompidou.fr" target="_blank"><img src="<?php echo(URL_ROOT); ?>images/logo_iri_bleu_transparent_petit.png" alt="logo IRI"/></a>
                </p>
            </div>
            <div id="colgauche">
                <div class="barre">
                    <img id="headlogo" src="<?php echo($head_logo); ?>" width="171" height="63" />
                    <div id="minilogo"></div>
                    <ul class="menu">
                        <li>
                            <a href="<?php echo(URL_ROOT); ?>" class="menuLink">
                                <?php print $translate->_("Accueil"); ?>
                            </a>
                        </li>
                        <li id="event-link">
                            <a href="<?php echo($translate->_('config__link')); ?>" class="menuLink" target="_blank" id='Program'>
                                <?php print $translate->_("Programme"); ?>
                            </a>
                        </li>
                        <li>
                            <a href="../about.php" class="menuLink" >
                                <?php print $translate->_("A propos"); ?>
                            </a>
                        </li>
                    </ul>
                    <ul class="menu">
                        <li>
                            <a href="<?php URL_ROOT ?>client.php?lang=ja_JP" class="menuLink" >
                                <img src='<?php echo(URL_ROOT); ?>images/flag_jp.gif' <?php if($actual!="ja_JP"){echo("style='opacity: .5;'"); } ?> />
                                <?php print $translate->_("Japonais"); ?>
                            </a></li>
                        <li>
                            <a href="<?php URL_ROOT ?>client.php?lang=fr" class="menuLink">
                                <img src='<?php echo(URL_ROOT); ?>images/flag_fr.gif' <?php if($actual!="fr"){echo("style='opacity: .5;'"); } ?> />
                                <?php print $translate->_("Français"); ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?php URL_ROOT ?>client.php?lang=en" class="menuLink">
                                <img src='<?php echo(URL_ROOT); ?>images/flag_en.gif' <?php if($actual!="en"){echo("style='opacity: .5;'"); } ?> />
                                <?php print $translate->_("Anglais"); ?>
                            </a>
                        </li>
                    </ul>
                </div>
                <div id="twwWrap">
                    <div id="tweetWriter">
                            <?php if (isset($_SESSION['SOCIAL_ACCESS_TOKEN'])): ?>
                            <div id="tweetCounter"><?php echo(TWEET_LENGTH-strlen($config['hashtag']));?></div>
                            <?php endif;?>
                        <h3 class="tweetWriterTitle"><?php print $translate->_("ClientTitle1 :"); ?></h3>
                        
                            <?php if (!isset($_SESSION['SOCIAL_ACCESS_TOKEN'])){
                                $loginform  = "<div class='loginbutton'>";
                                $socialNetwork = isset($config['social_network'])?$config['social_network']:'Twitter';
                                if($socialNetwork === 'Twitter') {
                                    $loginform .= "<a href='".URL_ROOT."$rep/client.php?CONNECT=true' target='_top' class='loginlink'>".$translate->_("Vous n'êtes pas connecté.")."</a>";
                                } else {
                                    $loginform .= "<form action='".URL_ROOT."$rep/client.php' method='GET' target='_top'>";
                                    $loginform .= "<div class='loginlink'>".$translate->_("Vous n'êtes pas connecté à Mastodon.")."</div>";
                                    $loginform .= "<ol class='loginlist'>";
                                    $loginform .= "<li><input type='text' id='social_domain' name='CONNECT' value='mastodon.svc.iri-research.org'/>";
                                    $loginform .= "<input type='submit' value='Connect'/>".$translate->_("Connexion Mastodon 1")."</li>";
                                    $loginform .= "</form>";
                                    $loginform .= "<li>".$translate->_("Connexion Mastodon 2")."<code>".$config['group']."</code></li>";
                                    $loginform .= "</ol>";

                                }
                                $loginform .= "</div>";
                                echo($loginform);
                            } else {
                                echo('<form  action="tweet.php" method="post" id="statusform" >');
                                echo("<textarea name='status' id='status' rows='3' cols='50'>$config[hashtag]</textarea>");
                            }
                            ?>
                            <div id="messageSuccess" style="background-color:lightgreen; display: none;">
                                <?php print $translate->_("Envoyé"); ?><br/><br/>
                            </div>
                            <div id="messageFailed" style="background-color:red; display: none;">
                                <?php print $translate->_("Erreur1"); ?><div id="error">&nbsp;</div><br/><br/>
                            </div>
                            <a href="#"  id="sendTweet" >
                                <span><?php print $translate->_("Envoyer"); ?></span>
                            </a>
                            <?php foreach ($annotations as $annot_cat => $annot_def) {
                                if($annot_cat == "default") {
                                    continue;
                                }
                                $display_parts = explode(" | ", $annot_def['display_name']);
                                ?>
                                <a id="<?php echo $annot_cat; ?>" title="<?php echo $annot_def['display_name']; ?>" class="tweetButton <?php echo $annot_def['colors_class']; ?>">
                                    <span class="twbSyntax"><?php echo $display_parts[0]; ?></span>
                                    <span class="twbSeparator">|</span>
                                    <span class="twbLabel"><?php echo $display_parts[1]; ?></span>
                                </a>
                            <?php } ?>

                            <div style="clear: both;"></div>
                        <?php if (isset($_SESSION['SOCIAL_ACCESS_TOKEN'])){ ?>
                        </form>
                        <?php } ?>
                    </div>
                </div>

            <?php if (isset($_SESSION['SOCIAL_ACCESS_TOKEN'])) { ?>

                <div id="tweetviz">
                    <div class="barre">
                        <form id="recherche">
                            <input autocomplete="off" class="greyed" id="inp_q" value="<?php echo $translate->_('Rechercher'); ?>" />
                            <input id="inp_submit" type="submit" />
                            <input id="inp_reset" type="reset" />
                            <div id="time_controls">
                                <div id="time_legende"></div>
                                <div id="time_scale"></div>
                                <a href="#" id="time_zoomout"></a>
                                <a href="#" id="time_zoomin"></a>
                            </div>
                            <div id="recherche_annot">
                                <?php echo $translate->_('SearchByPolemic'); ?> : <span id="rech_list_annot"></span><br />
                            </div>
                        </form>
                    </div>
                    <ul id="tweetlist"></ul>
                    <div id="timeline"></div>
                    <div id="scrollcont">
                        <div id="scrollin"></div>
                    </div>
                </div>

            <?php } else {?>

                <p class="connect-message"><a href="<?php echo URL_ROOT.$rep; ?>/client.php?CONNECT=mastodon.svc.iri-research.org"><?php echo $translate->_('You must be connected with your account to read the conversation'); ?></a></p>

            <?php } ?>

            </div>
            <?php $pad_url = $translate->_('config__pad_url');?>
            <?php if ($pad_url !== "config__pad_url"):?>
                <ul class="accordeon">
                    <li class="acctitre">
                        <h3><?php echo $translate->_('CollaborativePad');?></h3>
                    </li>
                    <li class="acctexte">
                        <?php echo $translate->_('ThisIsTheCollaborativePad');?>
                        <iframe src='<?php echo($pad_url); ?>' width='100%' height=400></iframe>
                    </li>
                </ul>
            </div>
            <?php endif;?>
            <div class="footer">
                <hr />
         <?php
                echo("<span id=\"event-partenaires\">".$translate->_('config__partenaires')."</span>");

                if (isset($_SESSION['SOCIAL_ACCESS_TOKEN'])){
                    echo("| <a href='clear.php' class='footerLink'>".$translate->_("D&eacute;connexion")."</a>");
                }
         ?><br>
            </div>
        </div>
        <div id="hovertweet">
            <div id="hovercontent"></div>
            <div id="hoverarrow"></div>
        </div>
        <ul id="hoverkw">
            <li><a id="hkwsearch" href="#"><?php echo $translate->_('Rechercher'); ?></a></li>
            <li><a id="hkwtweet" href="#"><?php echo $translate->_('addToTweet'); ?></a></li>
        </ul>
  </body>
