from iri_tweet import models, processor, utils
from optparse import OptionParser
import anyjson
import re
import twitter


def get_option():
    
    parser = OptionParser()

    parser.add_option("-l", "--log", dest="logfile",
                      help="log to file", metavar="LOG", default="stderr")
    parser.add_option("-v", dest="verbose", action="count",
                      help="verbose", metavar="VERBOSE", default=0)
    parser.add_option("-q", dest="quiet", action="count",
                      help="quiet", metavar="QUIET", default=0)
    parser.add_option("-Q", dest="query",
                      help="query", metavar="QUERY")
    parser.add_option("-P", dest="rpp", metavar="RPP", default="50",
                      help="Result per page")
    parser.add_option("-t", dest="token_filename", metavar="TOKEN_FILENAME", default=".oauth_token",
                      help="Token file name")
    parser.add_argument("-k", "--key", dest="consumer_key",
                        help="Twitter consumer key", metavar="CONSUMER_KEY", required=True)
    parser.add_argument("-s", "--secret", dest="consumer_secret",
                        help="Twitter consumer secret", metavar="CONSUMER_SECRET", required=True)
    
    return parser.parse_args()

def get_auth(options, access_token):
    consumer_key = options.consumer_key
    consumer_secret = options.consumer_secret
    auth = twitter.OAuth(token=access_token[0], token_secret=access_token[1], consumer_key=consumer_key, consumer_secret=consumer_secret)
    return auth

if __name__ == "__main__":

    (options, args) = get_option()
    
    access_token = utils.get_oauth_token(consumer_key=options.consumer_key, consumer_secret=options.consumer_secret, token_file_path=options.token_filename)
    auth = get_auth(options, access_token)

    t = twitter.Twitter(domain="api.twitter.com",api_version="1.1",secure=True, auth=auth)
    
    conn_str = args[0].strip()
    if not re.match("^\w+://.+", conn_str):
        conn_str = 'sqlite:///' + conn_str

    
    engine, metadata, Session = models.setup_database(conn_str, echo=((options.verbose-options.quiet)>0), create_all=True)
    session = None
    try:
        session = Session()
        #conn.row_factory = sqlite3.Row
        #curs = conn.cursor()
        #curs.execute("create table if not exists tweet_tweet (json);")
        #conn.commit()
        
        results = None        
        page = 1
        print options.query
        
        while page <= int(1500/int(options.rpp)) and  ( results is None  or len(results) > 0):
            results = t.search.tweets(q=options.query, rpp=options.rpp, page=page, include_entities=True)
            
            for tweet in results["results"]:
                print tweet
                tweet_str = anyjson.serialize(tweet)
                #invalidate user id
                processor = processor.TwitterProcessorStatus(json_dict=tweet, json_txt=tweet_str, source_id=None, session=session, consumer_token=None, access_token=None, token_filename=options.token_filename, user_query_twitter=False, logger=None)
                processor.process()
                session.flush()
                session.commit()
            page += 1
            #session.commit()
    finally:
        if session:
            session.close()


