var THRESHOLD = 13,
    DROPCOUNT = 12;

var swTw = {
    "keyword" : "#enmi",
    "columns_words" : [
        "confiance",
        "croyance",
        "crédit",
        "trace",
        "foi",
        "risque", 
        "assurance", 
        "démocratie", 
        "expertise",
        "catastrophe",
        "transparence",
        "politique",
    ],
    "tweets" : [],
    "tweetsIndex" : [],
    "twInCol" : [],
    "firstDisplayedTweet" : 0,
    "cursor" : -1,
    "annotations" : {
        "positive" : {
            "keyword" : "++",
            "colors" : {
                "tweet" : "#c5e7cd",
                "timeline" : "#1D973D"
            }
        },
        "negative" : {
            "keyword" : "--",
            "colors" : {
                "tweet" : "#f6ced0",
                "timeline" : "#CE0A15"
            }
        },
        "reference" : {
            "keyword" : "==",
            "colors" : {
                "tweet" : "#efefa1",
                "timeline" : "#C5A62D"
            }
        },
        "question" : {
            "keyword" : "??",
            "colors" : {
                "tweet" : "#bfdbec",
                "timeline" : "#036AAE"
            }
        }
    }
}

function highlightKeyword(stra, strb, color) {
    var rgxp = RegExp( '(' + strb.replace(/(\W)/gm, '\\$1') + ')', "gim");
    return stra.replace(rgxp, '<span class="highlight" style="background:' + color + ';">$1</span>');
}

function highlightText(txt) {
    res = swTw.columns_words.reduce(function(a, b) {
        return highlightKeyword(a,b, '#333333');
    }, txt);
    res = _(swTw.annotations).reduce(function(a, b) {
        return (b.keyword ? highlightKeyword(a,b.keyword,b.colors.timeline) : a);
    }, res);
    return res;
}

function nextTweet() {
    if (!swTw.tweets.length) {
        return;
    }
    if (swTw.cursor < swTw.tweets.length - 1) {
        swTw.cursor = Math.max(swTw.cursor + 1, swTw.tweets.length - 120);
        var tweet = swTw.tweets[swTw.cursor],
            html = '<img src="'
                + tweet.profile_image_url
                + '" /><p>@'
                + tweet.from_user
                + ' ('
                + tweet.from_user_name
                + ')'
                + '</p><p class="tweet_text">'
                + highlightText(tweet.text)
                + '</p>';
        $("#tweetcont").html(html)
    } else {
        $("#tweetcont").html("")
    }
}

function dropOldTweets() {
    var _newPos = swTw.firstDisplayedTweet + DROPCOUNT;
    _(swTw.tweets.slice(swTw.firstDisplayedTweet,_newPos)).each(function(tweet) {
        swTw.twInCol = _(swTw.twInCol).map(function(col) {
           return _(col).without(tweet.id_str);
        });
        _(tweet.elements).each(function(elid) {
            $("#" + elid).animate({
                "width": "0px"
            },
            2000,
            function() {
                $(this).detach();
            })
        });
    });
    swTw.firstDisplayedTweet = _newPos;
}

function callbackTweets(tweets) {
    _(tweets).each(function(tweet) {
        var tl = tweet.text.toLowerCase();
        tweet.columns = swTw.columns_words.filter(function(word) {
            return tl.search(word) != -1
        });
        tweet.elements = [];
        _(tweet.columns).each(function(word) {
            var iword = swTw.columns_words.indexOf(word),
                icol = ( swTw.twInCol[iword*2+1].length < swTw.twInCol[iword*2].length ? iword*2+1 : iword*2 ),
                elid = 'avatar_' + tweet.id_str + '_' + iword,
                colA = swTw.colAnnot[iword],
                ttl = 0;
            _(swTw.annotations).each(function(v,k) {
               if (tweet.text.indexOf(v.keyword) != -1) {
                   colA[k]++;
                   ttl++;
               }
            });
            colA.total += Math.max(1,ttl);
            $('#tube_' + icol).append(
                '<div class="avatar" id="'
                + elid
                + '" style="margin-right: 500px;"><img src="'
                + tweet.profile_image_url
                + '" /></div>'
            );
            tweet.elements.push(elid);
            swTw.twInCol[icol].push(tweet.id_str);
            $("#" + elid).animate({
                "margin-right" : "0px"
            },
            2000);
        })
        swTw.tweets.push(tweet);
        swTw.tweetsIndex.push(tweet.id_str);
    });
    while (_(swTw.twInCol).any(function(col) {
        return col.length > THRESHOLD
    })) {
        dropOldTweets();
    }
    _(swTw.colAnnot).each(function(colA, i) {
        _(swTw.annotations).each(function(v, k) {
           $("#polemic_" + i + "_" + k).css("width", ~~(100 * colA[k] / colA.total) + "%"); 
        });
    })
}

function retrieveTweets() {
    var options =  {
//        "keyword" : swTw.columns_words.join(" OR "),
//        "lang" : "fr",
        "keyword" : "#enmi",
        "pages" : 1,
        "rpp" : 100,
        "cbEnd" : function() {
            callbackTweets(this.tweets);
            }
        }
    if (swTw.tweets.length) {
        options.since_id = swTw.tweets[swTw.tweets.length - 1].id_str;
    }
    getTweets(options);
}

function getTweets(options) {
    function getTweetUrl(url) {
        $.getJSON(url, function(data) {
            options.tweets = options.tweets.concat(data.results);
            options.currentPage = data.page;
            if (options.cbData) {
                options.cbData();
            }
            if (data.next_page && data.page < options.pages) {
                getTweetUrl(baseurl + data.next_page + suffix);
            } else {
                options.tweets.sort(function(a,b) {
                   return a.id - b.id; 
                });
                if (options.cbEnd) {
                    options.cbEnd();
                }
            }
        });
    }
    
    options.tweets = [];
    options.pages || (options.pages = 1);
    options.rpp || (options.rpp = 100);
    options.currentPage = 0;
    
    var baseurl = "http://search.twitter.com/search.json",
        suffix = (options.since_id ? "&since_id=" + options.since_id : '' ) + "&callback=?",
        jsonurl = baseurl + "?q=" + encodeURIComponent(options.keyword)+ "&rpp=" + options.rpp
            + (options.lang ? "&lang=" + options.lang : '' ) + suffix;
    getTweetUrl(jsonurl);
}

$(document).ready(function() {
    $("#columncont").html( swTw.columns_words.map(
        function(mot, i) {
            return '<div class="column" id="column_'
            + i
            + '"><div class="column-tube"><div class="tube" id="tube_'
            + (2*i)
            + '"></div><div class="tube" id="tube_'
            + (2*i+1)
            + '"></div></div><div class="column-title">'
            + _(swTw.annotations).map(function(v,k) {
                return '<div class="polemicvol" id="polemic_' 
                    + i
                    + '_'
                    + k
                    + '" style="background:'
                    + v.colors.timeline
                    + '"></div>'
            }).join('')
            +'<h3>'
            + mot
            + '</h3></div></div>'
        }
    ).join("") );
   
   for (var i = 0; i < swTw.columns_words.length * 2; i++) {
       swTw.twInCol.push([]);
   }
   
   swTw.colAnnot = swTw.columns_words.map(function() {
      var res = { "total" : 0 }
      _(swTw.annotations).map(function(v,k) {
          res[k] = 0;
      });
      return res;
   });
   
   retrieveTweets();
   
   setInterval(retrieveTweets, 5000);
   
   setInterval(nextTweet, 6000);
    
});
