<?php

/**
 * If you haven't edited php.ini to add the Zend Framework and the
 * Zend Framework Incubator to the PHP include_path, then do so here.
 * Don't use mine!
 */
set_include_path(
    'lib'
    . PATH_SEPARATOR . get_include_path()
);


include_once dirname(__FILE__).'/traduction.php';


/**
 * Make sure Zend_Oauth's Consumer is loaded
 */
require_once dirname(__FILE__).'/lib/Zend/Oauth/Consumer.php';

/** Zend_Locale */
require_once dirname(__FILE__).'/lib/Zend/Locale.php';
 
/** Zend_Translate_Adapter */
require_once dirname(__FILE__).'/lib/Zend/Translate/Adapter.php';

/**
 * Start up the ol' session engine
 */
session_start();

/**
 * Include the configuration data for our OAuth Client (array $configuration)
 */
include_once dirname(__FILE__).'/config.php';

/**
 * Setup an instance of the Consumer for use
 */
$consumer = new Zend_Oauth_Consumer($configuration);

/**
 * TRADUCTION
**/


Zend_Loader::loadClass('Zend_Translate'); 
Zend_Loader::loadClass('Zend_Http_Cookie'); 


$client = new Zend_Http_Client();
$translate = new Zend_Translate('array', $init, 'fr');

$translate->addTranslation($english, 'en');
$translate->addTranslation($japan, 'ja_JP');
$translate->addTranslation($french, 'fr');

$actual = $translate->getLocale();

//$translate->setLocale("en");
// $acceptCookie = $this->_request->getCookie('acceptCookie',0);

if(isset($_GET['lang'])==false and isset($_SESSION['lang'])==false){
	
	if($actual!='fr' and $actual!='en' and $actual!='ja_JP'){
		$translate->setLocale("fr");
		 $_SESSION['lang']="fr";
	}
	
} else if (isset($_GET['lang'])==true){
	$translate->setLocale($_GET['lang']);
    $_SESSION['lang'] = $_GET['lang'];
    $actual = $_SESSION['lang'];

} else if (isset($_SESSION['lang'])==true){
	$translate->setLocale( $_SESSION['lang']);
    $actual = $_SESSION['lang'];
	
}

/* NEXT CONFERENCE AND CLIENT PAGE INFORMATION
*/
/* CLIENT VAR LIVE */

$C_hashtag= "#enmi";
$C_link  = "http://www.iri.centrepompidou.fr/evenement/atelier-preparatoire-aux-entretiens-du-nouveau-monde-industriel-technologies-de-la-confiance/";
$C_title = "Atelier préparatoire ENMI 2011 : Technologies de la Confiance";
$C_abstract = "Atelier préparatoire ENMI 2011 : Technologies de la Confiance
Mercredi 25 mai de 10h à 18h à l’ENSCI – Les Ateliers
48 rue Saint Sabin, Paris 11ème
Métro Bastille ou Saint-Sabin
";
$C_REP   = "enmi2011-technologie-confiance/";
$C_description  = "Une société, quelle que soit sa forme, est avant tout un dispositif de production de fidélité. Croire en l’autre – et non seulement lui faire confiance : compter sur lui au-delà même de tout calcul, comme garant d’une inconditionnalité, c’est à dire comme garantissant des principes, une droiture, une probité, etc. Tels sont les rôles tenus par son père, son curé, son instituteur, son agriculteur, son officier, etc. Parce que ces personnages sont en cela chargés d’une sorte de mission surmoïque, ceux qui croient en eux investissent en eux – et aussi bien, dans la Nation, dans le Christ, dans la Révolution, mais aussi dans le projet social qu’ils incarnent et que doit également incarner tout entrepreneur au sens de Max Weber.
Nous savons depuis Weber que le capitalisme a transformé le type de fidélité qui structurait la société occidentale – fondée sur la foi propre à la croyance religieuse monothéiste – en confiance entendue comme calculabilité fiduciaire. Cependant, la crise du capitalisme qui s’est déclenchée en 2007-2008 nous a appris que cette transformation de la fidélité en calculabilité, opérée par les appareils fiduciaires, a rencontré une limite où le crédit s’est massivement renversé en discrédit. Ce devenir, qui relève de ce que Weber aussi bien qu’Adorno désignèrent comme une rationalisation, conduisant à un désenchantement, est essentiellement lié à un processus de grammatisation auquel, durant la Renaissance, l’imprimerie conféra une dimension nouvelle qui constitua pour la Réforme un objet de luttes politico-religieuses sans précédent. Au cours de ces luttes, la « pharmacologie de l’esprit » que forment le Livre et les livres, et la thérapeutique que requièrent de tels « pharmaka » (poisons qui sont aussi des remèdes) deviendront les thèmes d’un conflit spirituel au service d’une nouvelle thérapeutique religieuse et laïque.
Nul ne peut ignorer qu’avec le développement du numérique, qui est le stade le plus récent du processus de grammatisation, les grandes questions que posa l’imprimerie et qui induisirent en large par la Réforme puis la Contre-Réforme réapparaissent : la confiance, dans le monde du metadataware, des réseaux sociaux et de la traçabilité (sans parler des questions de paiements sécurisés qui prennent ce sujet par son enjeu le plus superficiel) est devenue une question primordiale. C’est à tenter d’évaluer sa portée et les modèles économiques, organisationnels, industriels, technologiques et sociaux capables de reconstruire de la confiance que les Entretiens 2011 seront consacrés – enchaînant ainsi sur la question de la défiance face aux nanotechnologies abordée au cours des Entretiens 2010.
<br/>
<strong>10h00-12h00 SESSION 1 – HISTOIRE ET ANTHROPOLOGIE DE LA CONFIANCE</strong>
Confiance, foi, fidélité. Histoire du don, apparition du fiduciaire.
<br/>
Retour sur l’histoire de la confiance pensée en conjonction avec le développement des processus de grammatisation et des dispositifs d’inscription des traces, depuis la crise induite par l’imprimerie jusqu’au développement contemporain du numérique.
<ul>
	<li>Bernard Stiegler, Directeur de l’Institut de Recherche et d’Innovation (IRI)</li>
	<li>Alain Mille, Professeur en Informatique, Université Claude Bernard Lyon 1, Directeur de l'Ecole Doctorale InfoMaths</li>
</ul>
<br/>
<strong>12h00-13h00 SESSION 2 - CONFIANCE, CALCUL ET SAVOIR</strong>
<br/>
Risque, assurance, technologies de la confiance, société du risque, actualité du nucléaire.

Expertise, science, le rapport de défiance à la science.

La confiance relève-t-elle du calculable, de l’évaluation quantifiée des risques (risques financiers, sanitaires, nucléaires, technologiques, etc.) ou ne ressortit-elle pas, au contraire, de principes tout à fait différents, nécessitant de reprendre la question de l’expertise, de la science, du savoir et de la démocratie à nouveaux frais ?
<ul>
	<li>Judith Simon, Post-doctorante à l’Institut Jean Nicod, CNRS-EHESS-ENS/Université de Vienne, Autriche</li>
</ul>
<br/>
<strong>14h30-16h00 SESSION 3 – ECONOMIE, MARKETING et DESIGN de la CONFIANCE</strong>
<br/>
La confiance dans la relation. L’industrialisation de la relation. Les créateurs d’espaces de confiance. Design de la confiance et sciences cognitives. Les marques.
Au-delà du calcul du risque proprement dit s’est développée une ingénierie de la confiance  et de nouveaux espaces tentant de la recréer, en particulier sur le Web. Quelles difficultés entendent-ils pallier ? Quelles solutions proposent-ils et que penser de la demande sous-jacente qu’ils expriment ?
<ul>
	<li>Nicolas Auray, Maître de conférences en sociologie, École Nationale Supérieure des Télécommunications (ENST)</li>
	<li>Cécile Méadel, Professeur, Centre de Sociologie de l’Innovation, Mines-ParisTech</li>
</ul>
<br/>
<strong>16h15 -17h45 SESSION 4 - CONFIANCE ET POLITIQUE</strong>
Le rapport public-privé, Wikileaks, Public data, le Care.
<br/>
Les Public data sont-elles une solution miracle pour les Etats désireux de rebâtir de la confiance ou, au contraire, un dévoiement du public aux intérêts privés ? Qu’en est-il des exceptions sur les données sensibles – la  transparence peut-être est-ce expliquer clairement pour quelles raisons l’on n’est pas transparent sur certains sujets ?
<ul>
	<li>Albert Ogien, Sociologue, Directeur de recherche au CNRS et membre du CEMS (EHESS)</li>
	<li>Godefroy Dang Nguyen, Docteur en Économie, Directeur Scientifique adjoint Télécom Bretagne</li>
</ul>";

$C_partenaires  = "
		 <a href='http://www.iri.centrepompidou.fr/' class='footerLink' target='_blank'> IRI </a>
		 |  <a href='http://www.ensci.com/' class='footerLink' target='_blank' > ENSCI  </a>
		 |  <a href='http://www.capdigital.com/' class='footerLink' target='_blank'> Cap Digital </a>";


