from iri_tweet.models import setup_database, Message, UserMessage, User
from iri_tweet.utils import (get_oauth_token, get_user_query, set_logging_options, 
    set_logging, parse_date, get_logger)
from optparse import OptionParser #@UnresolvedImport
from sqlalchemy import BigInteger
from sqlalchemy.schema import Table, Column
from sqlalchemy.sql import and_
import datetime
import re
import sys
import twitter

APPLICATION_NAME = "Tweet recorder user"
CONSUMER_KEY = "Vdr5ZcsjI1G3esTPI8yDg"
CONSUMER_SECRET = "LMhNrY99R6a7E0YbZZkRFpUZpX5EfB1qATbDk1sIVLs"


def get_options():
    parser = OptionParser()
    parser.add_option("-d", "--database", dest="database",
                      help="Input database", metavar="DATABASE")
    parser.add_option("-s", "--start-date", dest="start_date",
                      help="start date", metavar="START_DATE", default=None)
    parser.add_option("-e", "--end-date", dest="end_date",
                      help="end date", metavar="END_DATE")
    parser.add_option("-H", "--hashtag", dest="hashtag",
                      help="Hashtag", metavar="HASHTAG", default=[], action="append")                      
    parser.add_option("-x", "--exclude", dest="exclude",
                      help="file containing the id to exclude", metavar="EXCLUDE")
    parser.add_option("-D", "--duration", dest="duration", type="int",
                      help="Duration", metavar="DURATION", default=None)
    parser.add_option("-m", "--message", dest="message",
                      help="tweet", metavar="MESSAGE", default="")    
    parser.add_option("-u", "--user", dest="user",
                      help="user", metavar="USER")    
    parser.add_option("-w", "--password", dest="password",
                      help="password", metavar="PASSWORD")    
    parser.add_option("-t", dest="token_filename", metavar="TOKEN_FILENAME", default=".oauth_token",
                      help="Token file name")
    parser.add_option("-S", dest="simulate", metavar="SIMULATE", default=False, action="store_true", help="Simulate call to twitter. Do not change the database")
    parser.add_option("--direct-message", dest="direct_message", metavar="DIRECT_MESSAGE", default=False, action="store_true", help="send direc t message to the user, else create a status update mentioning the user (@username)")
    parser.add_option("-f", dest="force", metavar="FORCE", default=False, action="store_true", help="force sending message to all user even if it has already been sent")


    set_logging_options(parser)
    
    return parser.parse_args()


if __name__ == "__main__":
    
    (options, args) = get_options()
    
    set_logging(options)
        
    get_logger().debug("OPTIONS : " + repr(options)) #@UndefinedVariable

    if not options.message or len(options.message) == 0:
        get_logger().warning("No message exiting")
        sys.exit()

    conn_str = options.database.strip()
    if not re.match("^\w+://.+", conn_str):
        conn_str = 'sqlite:///' + conn_str

    engine, metadata, Session = setup_database(conn_str, echo=((options.verbose-options.quiet)>0), create_all = False)        
    
    conn = None
    try :
        conn = engine.connect()  
        session = None      
        try:
            session = Session(bind=conn, autoflush=True, autocommit=True)
            tweet_exclude_table = Table("tweet_exclude", metadata, Column('id', BigInteger, primary_key=True), prefixes=['TEMPORARY'])
            metadata.create_all(bind=conn,tables=[tweet_exclude_table])

            start_date_str = options.start_date
            end_date_str = options.end_date
            duration = options.duration
            hashtags = options.hashtag
            
            start_date = None
            if start_date_str:
                start_date = parse_date(start_date_str) 

            end_date = None
            if end_date_str:
                end_date = parse_date(end_date_str)
            elif start_date and duration:
                end_date = start_date + datetime.timedelta(seconds=duration)
            
            base_message = options.message.decode(sys.getfilesystemencoding())
            #get or create message
            message_obj = session.query(Message).filter(Message.text == base_message).first()
            if not message_obj :
                message_obj = Message(text=base_message)
                session.add(message_obj) 
                session.flush()           
            
            query = get_user_query(session, start_date, end_date, hashtags, tweet_exclude_table)

            if not options.force:
                query = query.outerjoin(UserMessage, and_(User.id == UserMessage.user_id, UserMessage.message_id == message_obj.id)).filter(UserMessage.message_id == None)
                
            query_res = query.all()
            
            acess_token_key, access_token_secret = get_oauth_token(consumer_key=CONSUMER_KEY, consumer_secret=CONSUMER_SECRET, token_file_path=options.token_filename, application_name=APPLICATION_NAME)
            t = twitter.Twitter(auth=twitter.OAuth(acess_token_key, access_token_secret, CONSUMER_KEY, CONSUMER_SECRET))

            for user in query_res:
                screen_name = user.screen_name
                
                if options.direct_message:
                    message = base_message
                else:
                    message = u"@%s: %s" % (screen_name, base_message)

                print("new message : " + message)
                get_logger().debug("new message : " + message) #@UndefinedVariable

                if not options.simulate:
                    if options.direct_message:
                        t.direct_messages.new(user_id=user.id, screen_name=screen_name, text=message)
                    else:
                        t.statuses.update(status=message)
                    user_message = UserMessage(user_id=user.id, message_id=message_obj.id)
                    session.add(user_message)
                    session.flush()
        finally:
            # if message created and simulate, do not
            if session:  
                session.close()
    finally:
        if conn:
            conn.close()

