const path = require('path');
const webpack = require('webpack');

const CssMinimizerPlugin = require("css-minimizer-webpack-plugin");

const nodeModulesPath = path.resolve(__dirname, 'node_modules');

module.exports = {
  entry: [
    __dirname + '/src/js/index.js',
    __dirname + '/src/css/main.scss',
    __dirname + '/src/css/common.scss',
    __dirname + '/src/css/vendors.scss',
    
  ],
  output: {
    filename: 'live-polemic.js',
    path: path.resolve(__dirname, 'res/js'),
  },
  plugins: [
    new webpack.ProvidePlugin({
        $: "jquery",
        jQuery: "jquery",
    })
  ],
//  devtool: 'eval',
  optimization: {
    minimizer: [
      // For webpack@5 you can use the `...` syntax to extend existing minimizers (i.e. `terser-webpack-plugin`), uncomment the next line
      `...`,
      new CssMinimizerPlugin(),
    ],
    minimize: true,
  },
  module: {
    rules: [
      {
        test: /\.s?css$/,
        exclude: [ "/res/css" ],

        type: 'asset/resource',
        generator: {
          filename: '../css/[name].css'
        },
        use: [
          'resolve-url-loader',
          {
            loader: 'sass-loader',
            options: {
              sourceMap: true,
              // sassOptions: {
              //   includePaths: [nodeModulesPath],
              // },
            }
          },
        ]
      },
      {
        test: /\.(eot|ttf|woff|woff2)$/i,
        // More information here https://webpack.js.org/guides/asset-modules/
        type: "asset",
        generator: {
          filename: '../emits/fonts/[hash][ext][query]'
        },
      },
      {
        test: /\.(png|jpe?g|gif|svg)$/i,
        // More information here https://webpack.js.org/guides/asset-modules/
        type: "asset",
        generator: {
          filename: '../emits/images/[hash][ext][query]'
        },

      },
    ]
  }

};
