/*! For license information please see live-polemic.js.LICENSE.txt */
(()=>{var __webpack_modules__={"./node_modules/@videojs/vhs-utils/es/byte-helpers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ENDIANNESS: () => (/* binding */ ENDIANNESS),\n/* harmony export */   IS_BIG_ENDIAN: () => (/* binding */ IS_BIG_ENDIAN),\n/* harmony export */   IS_LITTLE_ENDIAN: () => (/* binding */ IS_LITTLE_ENDIAN),\n/* harmony export */   bytesMatch: () => (/* binding */ bytesMatch),\n/* harmony export */   bytesToNumber: () => (/* binding */ bytesToNumber),\n/* harmony export */   bytesToString: () => (/* binding */ bytesToString),\n/* harmony export */   concatTypedArrays: () => (/* binding */ concatTypedArrays),\n/* harmony export */   countBits: () => (/* binding */ countBits),\n/* harmony export */   countBytes: () => (/* binding */ countBytes),\n/* harmony export */   isArrayBufferView: () => (/* binding */ isArrayBufferView),\n/* harmony export */   isTypedArray: () => (/* binding */ isTypedArray),\n/* harmony export */   numberToBytes: () => (/* binding */ numberToBytes),\n/* harmony export */   padStart: () => (/* binding */ padStart),\n/* harmony export */   reverseBytes: () => (/* binding */ reverseBytes),\n/* harmony export */   sliceBytes: () => (/* binding */ sliceBytes),\n/* harmony export */   stringToBytes: () => (/* binding */ stringToBytes),\n/* harmony export */   toBinaryString: () => (/* binding */ toBinaryString),\n/* harmony export */   toHexString: () => (/* binding */ toHexString),\n/* harmony export */   toUint8: () => (/* binding */ toUint8)\n/* harmony export */ });\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! global/window */ \"./node_modules/global/window.js\");\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_0__);\n // const log2 = Math.log2 ? Math.log2 : (x) => (Math.log(x) / Math.log(2));\n\nvar repeat = function repeat(str, len) {\n  var acc = '';\n\n  while (len--) {\n    acc += str;\n  }\n\n  return acc;\n}; // count the number of bits it would take to represent a number\n// we used to do this with log2 but BigInt does not support builtin math\n// Math.ceil(log2(x));\n\n\nvar countBits = function countBits(x) {\n  return x.toString(2).length;\n}; // count the number of whole bytes it would take to represent a number\n\nvar countBytes = function countBytes(x) {\n  return Math.ceil(countBits(x) / 8);\n};\nvar padStart = function padStart(b, len, str) {\n  if (str === void 0) {\n    str = ' ';\n  }\n\n  return (repeat(str, len) + b.toString()).slice(-len);\n};\nvar isArrayBufferView = function isArrayBufferView(obj) {\n  if (ArrayBuffer.isView === 'function') {\n    return ArrayBuffer.isView(obj);\n  }\n\n  return obj && obj.buffer instanceof ArrayBuffer;\n};\nvar isTypedArray = function isTypedArray(obj) {\n  return isArrayBufferView(obj);\n};\nvar toUint8 = function toUint8(bytes) {\n  if (bytes instanceof Uint8Array) {\n    return bytes;\n  }\n\n  if (!Array.isArray(bytes) && !isTypedArray(bytes) && !(bytes instanceof ArrayBuffer)) {\n    // any non-number or NaN leads to empty uint8array\n    // eslint-disable-next-line\n    if (typeof bytes !== 'number' || typeof bytes === 'number' && bytes !== bytes) {\n      bytes = 0;\n    } else {\n      bytes = [bytes];\n    }\n  }\n\n  return new Uint8Array(bytes && bytes.buffer || bytes, bytes && bytes.byteOffset || 0, bytes && bytes.byteLength || 0);\n};\nvar toHexString = function toHexString(bytes) {\n  bytes = toUint8(bytes);\n  var str = '';\n\n  for (var i = 0; i < bytes.length; i++) {\n    str += padStart(bytes[i].toString(16), 2, '0');\n  }\n\n  return str;\n};\nvar toBinaryString = function toBinaryString(bytes) {\n  bytes = toUint8(bytes);\n  var str = '';\n\n  for (var i = 0; i < bytes.length; i++) {\n    str += padStart(bytes[i].toString(2), 8, '0');\n  }\n\n  return str;\n};\nvar BigInt = (global_window__WEBPACK_IMPORTED_MODULE_0___default().BigInt) || Number;\nvar BYTE_TABLE = [BigInt('0x1'), BigInt('0x100'), BigInt('0x10000'), BigInt('0x1000000'), BigInt('0x100000000'), BigInt('0x10000000000'), BigInt('0x1000000000000'), BigInt('0x100000000000000'), BigInt('0x10000000000000000')];\nvar ENDIANNESS = function () {\n  var a = new Uint16Array([0xFFCC]);\n  var b = new Uint8Array(a.buffer, a.byteOffset, a.byteLength);\n\n  if (b[0] === 0xFF) {\n    return 'big';\n  }\n\n  if (b[0] === 0xCC) {\n    return 'little';\n  }\n\n  return 'unknown';\n}();\nvar IS_BIG_ENDIAN = ENDIANNESS === 'big';\nvar IS_LITTLE_ENDIAN = ENDIANNESS === 'little';\nvar bytesToNumber = function bytesToNumber(bytes, _temp) {\n  var _ref = _temp === void 0 ? {} : _temp,\n      _ref$signed = _ref.signed,\n      signed = _ref$signed === void 0 ? false : _ref$signed,\n      _ref$le = _ref.le,\n      le = _ref$le === void 0 ? false : _ref$le;\n\n  bytes = toUint8(bytes);\n  var fn = le ? 'reduce' : 'reduceRight';\n  var obj = bytes[fn] ? bytes[fn] : Array.prototype[fn];\n  var number = obj.call(bytes, function (total, byte, i) {\n    var exponent = le ? i : Math.abs(i + 1 - bytes.length);\n    return total + BigInt(byte) * BYTE_TABLE[exponent];\n  }, BigInt(0));\n\n  if (signed) {\n    var max = BYTE_TABLE[bytes.length] / BigInt(2) - BigInt(1);\n    number = BigInt(number);\n\n    if (number > max) {\n      number -= max;\n      number -= max;\n      number -= BigInt(2);\n    }\n  }\n\n  return Number(number);\n};\nvar numberToBytes = function numberToBytes(number, _temp2) {\n  var _ref2 = _temp2 === void 0 ? {} : _temp2,\n      _ref2$le = _ref2.le,\n      le = _ref2$le === void 0 ? false : _ref2$le;\n\n  // eslint-disable-next-line\n  if (typeof number !== 'bigint' && typeof number !== 'number' || typeof number === 'number' && number !== number) {\n    number = 0;\n  }\n\n  number = BigInt(number);\n  var byteCount = countBytes(number);\n  var bytes = new Uint8Array(new ArrayBuffer(byteCount));\n\n  for (var i = 0; i < byteCount; i++) {\n    var byteIndex = le ? i : Math.abs(i + 1 - bytes.length);\n    bytes[byteIndex] = Number(number / BYTE_TABLE[i] & BigInt(0xFF));\n\n    if (number < 0) {\n      bytes[byteIndex] = Math.abs(~bytes[byteIndex]);\n      bytes[byteIndex] -= i === 0 ? 1 : 2;\n    }\n  }\n\n  return bytes;\n};\nvar bytesToString = function bytesToString(bytes) {\n  if (!bytes) {\n    return '';\n  } // TODO: should toUint8 handle cases where we only have 8 bytes\n  // but report more since this is a Uint16+ Array?\n\n\n  bytes = Array.prototype.slice.call(bytes);\n  var string = String.fromCharCode.apply(null, toUint8(bytes));\n\n  try {\n    return decodeURIComponent(escape(string));\n  } catch (e) {// if decodeURIComponent/escape fails, we are dealing with partial\n    // or full non string data. Just return the potentially garbled string.\n  }\n\n  return string;\n};\nvar stringToBytes = function stringToBytes(string, stringIsBytes) {\n  if (typeof string !== 'string' && string && typeof string.toString === 'function') {\n    string = string.toString();\n  }\n\n  if (typeof string !== 'string') {\n    return new Uint8Array();\n  } // If the string already is bytes, we don't have to do this\n  // otherwise we do this so that we split multi length characters\n  // into individual bytes\n\n\n  if (!stringIsBytes) {\n    string = unescape(encodeURIComponent(string));\n  }\n\n  var view = new Uint8Array(string.length);\n\n  for (var i = 0; i < string.length; i++) {\n    view[i] = string.charCodeAt(i);\n  }\n\n  return view;\n};\nvar concatTypedArrays = function concatTypedArrays() {\n  for (var _len = arguments.length, buffers = new Array(_len), _key = 0; _key < _len; _key++) {\n    buffers[_key] = arguments[_key];\n  }\n\n  buffers = buffers.filter(function (b) {\n    return b && (b.byteLength || b.length) && typeof b !== 'string';\n  });\n\n  if (buffers.length <= 1) {\n    // for 0 length we will return empty uint8\n    // for 1 length we return the first uint8\n    return toUint8(buffers[0]);\n  }\n\n  var totalLen = buffers.reduce(function (total, buf, i) {\n    return total + (buf.byteLength || buf.length);\n  }, 0);\n  var tempBuffer = new Uint8Array(totalLen);\n  var offset = 0;\n  buffers.forEach(function (buf) {\n    buf = toUint8(buf);\n    tempBuffer.set(buf, offset);\n    offset += buf.byteLength;\n  });\n  return tempBuffer;\n};\n/**\n * Check if the bytes \"b\" are contained within bytes \"a\".\n *\n * @param {Uint8Array|Array} a\n *        Bytes to check in\n *\n * @param {Uint8Array|Array} b\n *        Bytes to check for\n *\n * @param {Object} options\n *        options\n *\n * @param {Array|Uint8Array} [offset=0]\n *        offset to use when looking at bytes in a\n *\n * @param {Array|Uint8Array} [mask=[]]\n *        mask to use on bytes before comparison.\n *\n * @return {boolean}\n *         If all bytes in b are inside of a, taking into account\n *         bit masks.\n */\n\nvar bytesMatch = function bytesMatch(a, b, _temp3) {\n  var _ref3 = _temp3 === void 0 ? {} : _temp3,\n      _ref3$offset = _ref3.offset,\n      offset = _ref3$offset === void 0 ? 0 : _ref3$offset,\n      _ref3$mask = _ref3.mask,\n      mask = _ref3$mask === void 0 ? [] : _ref3$mask;\n\n  a = toUint8(a);\n  b = toUint8(b); // ie 11 does not support uint8 every\n\n  var fn = b.every ? b.every : Array.prototype.every;\n  return b.length && a.length - offset >= b.length && // ie 11 doesn't support every on uin8\n  fn.call(b, function (bByte, i) {\n    var aByte = mask[i] ? mask[i] & a[offset + i] : a[offset + i];\n    return bByte === aByte;\n  });\n};\nvar sliceBytes = function sliceBytes(src, start, end) {\n  if (Uint8Array.prototype.slice) {\n    return Uint8Array.prototype.slice.call(src, start, end);\n  }\n\n  return new Uint8Array(Array.prototype.slice.call(src, start, end));\n};\nvar reverseBytes = function reverseBytes(src) {\n  if (src.reverse) {\n    return src.reverse();\n  }\n\n  return Array.prototype.reverse.call(src);\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/byte-helpers.js?")},"./node_modules/@videojs/vhs-utils/es/codec-helpers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getAv1Codec: () => (/* binding */ getAv1Codec),\n/* harmony export */   getAvcCodec: () => (/* binding */ getAvcCodec),\n/* harmony export */   getHvcCodec: () => (/* binding */ getHvcCodec)\n/* harmony export */ });\n/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/byte-helpers.js\");\n // https://aomediacodec.github.io/av1-isobmff/#av1codecconfigurationbox-syntax\n// https://developer.mozilla.org/en-US/docs/Web/Media/Formats/codecs_parameter#AV1\n\nvar getAv1Codec = function getAv1Codec(bytes) {\n  var codec = '';\n  var profile = bytes[1] >>> 3;\n  var level = bytes[1] & 0x1F;\n  var tier = bytes[2] >>> 7;\n  var highBitDepth = (bytes[2] & 0x40) >> 6;\n  var twelveBit = (bytes[2] & 0x20) >> 5;\n  var monochrome = (bytes[2] & 0x10) >> 4;\n  var chromaSubsamplingX = (bytes[2] & 0x08) >> 3;\n  var chromaSubsamplingY = (bytes[2] & 0x04) >> 2;\n  var chromaSamplePosition = bytes[2] & 0x03;\n  codec += profile + \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(level, 2, '0');\n\n  if (tier === 0) {\n    codec += 'M';\n  } else if (tier === 1) {\n    codec += 'H';\n  }\n\n  var bitDepth;\n\n  if (profile === 2 && highBitDepth) {\n    bitDepth = twelveBit ? 12 : 10;\n  } else {\n    bitDepth = highBitDepth ? 10 : 8;\n  }\n\n  codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(bitDepth, 2, '0'); // TODO: can we parse color range??\n\n  codec += \".\" + monochrome;\n  codec += \".\" + chromaSubsamplingX + chromaSubsamplingY + chromaSamplePosition;\n  return codec;\n};\nvar getAvcCodec = function getAvcCodec(bytes) {\n  var profileId = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(bytes[1]);\n  var constraintFlags = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(bytes[2] & 0xFC);\n  var levelId = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(bytes[3]);\n  return \"\" + profileId + constraintFlags + levelId;\n};\nvar getHvcCodec = function getHvcCodec(bytes) {\n  var codec = '';\n  var profileSpace = bytes[1] >> 6;\n  var profileId = bytes[1] & 0x1F;\n  var tierFlag = (bytes[1] & 0x20) >> 5;\n  var profileCompat = bytes.subarray(2, 6);\n  var constraintIds = bytes.subarray(6, 12);\n  var levelId = bytes[12];\n\n  if (profileSpace === 1) {\n    codec += 'A';\n  } else if (profileSpace === 2) {\n    codec += 'B';\n  } else if (profileSpace === 3) {\n    codec += 'C';\n  }\n\n  codec += profileId + \".\"; // ffmpeg does this in big endian\n\n  var profileCompatVal = parseInt((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toBinaryString)(profileCompat).split('').reverse().join(''), 2); // apple does this in little endian...\n\n  if (profileCompatVal > 255) {\n    profileCompatVal = parseInt((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toBinaryString)(profileCompat), 2);\n  }\n\n  codec += profileCompatVal.toString(16) + \".\";\n\n  if (tierFlag === 0) {\n    codec += 'L';\n  } else {\n    codec += 'H';\n  }\n\n  codec += levelId;\n  var constraints = '';\n\n  for (var i = 0; i < constraintIds.length; i++) {\n    var v = constraintIds[i];\n\n    if (v) {\n      if (constraints) {\n        constraints += '.';\n      }\n\n      constraints += v.toString(16);\n    }\n  }\n\n  if (constraints) {\n    codec += \".\" + constraints;\n  }\n\n  return codec;\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/codec-helpers.js?")},"./node_modules/@videojs/vhs-utils/es/codecs.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DEFAULT_AUDIO_CODEC: () => (/* binding */ DEFAULT_AUDIO_CODEC),\n/* harmony export */   DEFAULT_VIDEO_CODEC: () => (/* binding */ DEFAULT_VIDEO_CODEC),\n/* harmony export */   browserSupportsCodec: () => (/* binding */ browserSupportsCodec),\n/* harmony export */   codecsFromDefault: () => (/* binding */ codecsFromDefault),\n/* harmony export */   getMimeForCodec: () => (/* binding */ getMimeForCodec),\n/* harmony export */   isAudioCodec: () => (/* binding */ isAudioCodec),\n/* harmony export */   isTextCodec: () => (/* binding */ isTextCodec),\n/* harmony export */   isVideoCodec: () => (/* binding */ isVideoCodec),\n/* harmony export */   mapLegacyAvcCodecs: () => (/* binding */ mapLegacyAvcCodecs),\n/* harmony export */   muxerSupportsCodec: () => (/* binding */ muxerSupportsCodec),\n/* harmony export */   parseCodecs: () => (/* binding */ parseCodecs),\n/* harmony export */   translateLegacyCodec: () => (/* binding */ translateLegacyCodec),\n/* harmony export */   translateLegacyCodecs: () => (/* binding */ translateLegacyCodecs)\n/* harmony export */ });\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! global/window */ \"./node_modules/global/window.js\");\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_0__);\n\nvar regexs = {\n  // to determine mime types\n  mp4: /^(av0?1|avc0?[1234]|vp0?9|flac|opus|mp3|mp4a|mp4v|stpp.ttml.im1t)/,\n  webm: /^(vp0?[89]|av0?1|opus|vorbis)/,\n  ogg: /^(vp0?[89]|theora|flac|opus|vorbis)/,\n  // to determine if a codec is audio or video\n  video: /^(av0?1|avc0?[1234]|vp0?[89]|hvc1|hev1|theora|mp4v)/,\n  audio: /^(mp4a|flac|vorbis|opus|ac-[34]|ec-3|alac|mp3|speex|aac)/,\n  text: /^(stpp.ttml.im1t)/,\n  // mux.js support regex\n  muxerVideo: /^(avc0?1)/,\n  muxerAudio: /^(mp4a)/,\n  // match nothing as muxer does not support text right now.\n  // there cannot never be a character before the start of a string\n  // so this matches nothing.\n  muxerText: /a^/\n};\nvar mediaTypes = ['video', 'audio', 'text'];\nvar upperMediaTypes = ['Video', 'Audio', 'Text'];\n/**\n * Replace the old apple-style `avc1.<dd>.<dd>` codec string with the standard\n * `avc1.<hhhhhh>`\n *\n * @param {string} codec\n *        Codec string to translate\n * @return {string}\n *         The translated codec string\n */\n\nvar translateLegacyCodec = function translateLegacyCodec(codec) {\n  if (!codec) {\n    return codec;\n  }\n\n  return codec.replace(/avc1\\.(\\d+)\\.(\\d+)/i, function (orig, profile, avcLevel) {\n    var profileHex = ('00' + Number(profile).toString(16)).slice(-2);\n    var avcLevelHex = ('00' + Number(avcLevel).toString(16)).slice(-2);\n    return 'avc1.' + profileHex + '00' + avcLevelHex;\n  });\n};\n/**\n * Replace the old apple-style `avc1.<dd>.<dd>` codec strings with the standard\n * `avc1.<hhhhhh>`\n *\n * @param {string[]} codecs\n *        An array of codec strings to translate\n * @return {string[]}\n *         The translated array of codec strings\n */\n\nvar translateLegacyCodecs = function translateLegacyCodecs(codecs) {\n  return codecs.map(translateLegacyCodec);\n};\n/**\n * Replace codecs in the codec string with the old apple-style `avc1.<dd>.<dd>` to the\n * standard `avc1.<hhhhhh>`.\n *\n * @param {string} codecString\n *        The codec string\n * @return {string}\n *         The codec string with old apple-style codecs replaced\n *\n * @private\n */\n\nvar mapLegacyAvcCodecs = function mapLegacyAvcCodecs(codecString) {\n  return codecString.replace(/avc1\\.(\\d+)\\.(\\d+)/i, function (match) {\n    return translateLegacyCodecs([match])[0];\n  });\n};\n/**\n * @typedef {Object} ParsedCodecInfo\n * @property {number} codecCount\n *           Number of codecs parsed\n * @property {string} [videoCodec]\n *           Parsed video codec (if found)\n * @property {string} [videoObjectTypeIndicator]\n *           Video object type indicator (if found)\n * @property {string|null} audioProfile\n *           Audio profile\n */\n\n/**\n * Parses a codec string to retrieve the number of codecs specified, the video codec and\n * object type indicator, and the audio profile.\n *\n * @param {string} [codecString]\n *        The codec string to parse\n * @return {ParsedCodecInfo}\n *         Parsed codec info\n */\n\nvar parseCodecs = function parseCodecs(codecString) {\n  if (codecString === void 0) {\n    codecString = '';\n  }\n\n  var codecs = codecString.split(',');\n  var result = [];\n  codecs.forEach(function (codec) {\n    codec = codec.trim();\n    var codecType;\n    mediaTypes.forEach(function (name) {\n      var match = regexs[name].exec(codec.toLowerCase());\n\n      if (!match || match.length <= 1) {\n        return;\n      }\n\n      codecType = name; // maintain codec case\n\n      var type = codec.substring(0, match[1].length);\n      var details = codec.replace(type, '');\n      result.push({\n        type: type,\n        details: details,\n        mediaType: name\n      });\n    });\n\n    if (!codecType) {\n      result.push({\n        type: codec,\n        details: '',\n        mediaType: 'unknown'\n      });\n    }\n  });\n  return result;\n};\n/**\n * Returns a ParsedCodecInfo object for the default alternate audio playlist if there is\n * a default alternate audio playlist for the provided audio group.\n *\n * @param {Object} master\n *        The master playlist\n * @param {string} audioGroupId\n *        ID of the audio group for which to find the default codec info\n * @return {ParsedCodecInfo}\n *         Parsed codec info\n */\n\nvar codecsFromDefault = function codecsFromDefault(master, audioGroupId) {\n  if (!master.mediaGroups.AUDIO || !audioGroupId) {\n    return null;\n  }\n\n  var audioGroup = master.mediaGroups.AUDIO[audioGroupId];\n\n  if (!audioGroup) {\n    return null;\n  }\n\n  for (var name in audioGroup) {\n    var audioType = audioGroup[name];\n\n    if (audioType.default && audioType.playlists) {\n      // codec should be the same for all playlists within the audio type\n      return parseCodecs(audioType.playlists[0].attributes.CODECS);\n    }\n  }\n\n  return null;\n};\nvar isVideoCodec = function isVideoCodec(codec) {\n  if (codec === void 0) {\n    codec = '';\n  }\n\n  return regexs.video.test(codec.trim().toLowerCase());\n};\nvar isAudioCodec = function isAudioCodec(codec) {\n  if (codec === void 0) {\n    codec = '';\n  }\n\n  return regexs.audio.test(codec.trim().toLowerCase());\n};\nvar isTextCodec = function isTextCodec(codec) {\n  if (codec === void 0) {\n    codec = '';\n  }\n\n  return regexs.text.test(codec.trim().toLowerCase());\n};\nvar getMimeForCodec = function getMimeForCodec(codecString) {\n  if (!codecString || typeof codecString !== 'string') {\n    return;\n  }\n\n  var codecs = codecString.toLowerCase().split(',').map(function (c) {\n    return translateLegacyCodec(c.trim());\n  }); // default to video type\n\n  var type = 'video'; // only change to audio type if the only codec we have is\n  // audio\n\n  if (codecs.length === 1 && isAudioCodec(codecs[0])) {\n    type = 'audio';\n  } else if (codecs.length === 1 && isTextCodec(codecs[0])) {\n    // text uses application/<container> for now\n    type = 'application';\n  } // default the container to mp4\n\n\n  var container = 'mp4'; // every codec must be able to go into the container\n  // for that container to be the correct one\n\n  if (codecs.every(function (c) {\n    return regexs.mp4.test(c);\n  })) {\n    container = 'mp4';\n  } else if (codecs.every(function (c) {\n    return regexs.webm.test(c);\n  })) {\n    container = 'webm';\n  } else if (codecs.every(function (c) {\n    return regexs.ogg.test(c);\n  })) {\n    container = 'ogg';\n  }\n\n  return type + \"/\" + container + \";codecs=\\\"\" + codecString + \"\\\"\";\n};\nvar browserSupportsCodec = function browserSupportsCodec(codecString) {\n  if (codecString === void 0) {\n    codecString = '';\n  }\n\n  return (global_window__WEBPACK_IMPORTED_MODULE_0___default().MediaSource) && (global_window__WEBPACK_IMPORTED_MODULE_0___default().MediaSource).isTypeSupported && global_window__WEBPACK_IMPORTED_MODULE_0___default().MediaSource.isTypeSupported(getMimeForCodec(codecString)) || false;\n};\nvar muxerSupportsCodec = function muxerSupportsCodec(codecString) {\n  if (codecString === void 0) {\n    codecString = '';\n  }\n\n  return codecString.toLowerCase().split(',').every(function (codec) {\n    codec = codec.trim(); // any match is supported.\n\n    for (var i = 0; i < upperMediaTypes.length; i++) {\n      var type = upperMediaTypes[i];\n\n      if (regexs[\"muxer\" + type].test(codec)) {\n        return true;\n      }\n    }\n\n    return false;\n  });\n};\nvar DEFAULT_AUDIO_CODEC = 'mp4a.40.2';\nvar DEFAULT_VIDEO_CODEC = 'avc1.4d400d';\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/codecs.js?")},"./node_modules/@videojs/vhs-utils/es/containers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   detectContainerForBytes: () => (/* binding */ detectContainerForBytes),\n/* harmony export */   isLikely: () => (/* binding */ isLikely),\n/* harmony export */   isLikelyFmp4MediaSegment: () => (/* binding */ isLikelyFmp4MediaSegment)\n/* harmony export */ });\n/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/byte-helpers.js\");\n/* harmony import */ var _mp4_helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mp4-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/mp4-helpers.js\");\n/* harmony import */ var _ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ebml-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/ebml-helpers.js\");\n/* harmony import */ var _id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./id3-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/id3-helpers.js\");\n/* harmony import */ var _nal_helpers_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./nal-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/nal-helpers.js\");\n\n\n\n\n\nvar CONSTANTS = {\n  // \"webm\" string literal in hex\n  'webm': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x77, 0x65, 0x62, 0x6d]),\n  // \"matroska\" string literal in hex\n  'matroska': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x6d, 0x61, 0x74, 0x72, 0x6f, 0x73, 0x6b, 0x61]),\n  // \"fLaC\" string literal in hex\n  'flac': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x4c, 0x61, 0x43]),\n  // \"OggS\" string literal in hex\n  'ogg': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x4f, 0x67, 0x67, 0x53]),\n  // ac-3 sync byte, also works for ec-3 as that is simply a codec\n  // of ac-3\n  'ac3': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x0b, 0x77]),\n  // \"RIFF\" string literal in hex used for wav and avi\n  'riff': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x52, 0x49, 0x46, 0x46]),\n  // \"AVI\" string literal in hex\n  'avi': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x41, 0x56, 0x49]),\n  // \"WAVE\" string literal in hex\n  'wav': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x57, 0x41, 0x56, 0x45]),\n  // \"ftyp3g\" string literal in hex\n  '3gp': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x74, 0x79, 0x70, 0x33, 0x67]),\n  // \"ftyp\" string literal in hex\n  'mp4': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x74, 0x79, 0x70]),\n  // \"styp\" string literal in hex\n  'fmp4': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x73, 0x74, 0x79, 0x70]),\n  // \"ftypqt\" string literal in hex\n  'mov': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x66, 0x74, 0x79, 0x70, 0x71, 0x74]),\n  // moov string literal in hex\n  'moov': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x6D, 0x6F, 0x6F, 0x76]),\n  // moof string literal in hex\n  'moof': (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x6D, 0x6F, 0x6F, 0x66])\n};\nvar _isLikely = {\n  aac: function aac(bytes) {\n    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, [0xFF, 0x10], {\n      offset: offset,\n      mask: [0xFF, 0x16]\n    });\n  },\n  mp3: function mp3(bytes) {\n    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, [0xFF, 0x02], {\n      offset: offset,\n      mask: [0xFF, 0x06]\n    });\n  },\n  webm: function webm(bytes) {\n    var docType = (0,_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.findEbml)(bytes, [_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.EBML, _ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.DocType])[0]; // check if DocType EBML tag is webm\n\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(docType, CONSTANTS.webm);\n  },\n  mkv: function mkv(bytes) {\n    var docType = (0,_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.findEbml)(bytes, [_ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.EBML, _ebml_helpers_js__WEBPACK_IMPORTED_MODULE_2__.EBML_TAGS.DocType])[0]; // check if DocType EBML tag is matroska\n\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(docType, CONSTANTS.matroska);\n  },\n  mp4: function mp4(bytes) {\n    // if this file is another base media file format, it is not mp4\n    if (_isLikely['3gp'](bytes) || _isLikely.mov(bytes)) {\n      return false;\n    } // if this file starts with a ftyp or styp box its mp4\n\n\n    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.mp4, {\n      offset: 4\n    }) || (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.fmp4, {\n      offset: 4\n    })) {\n      return true;\n    } // if this file starts with a moof/moov box its mp4\n\n\n    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.moof, {\n      offset: 4\n    }) || (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.moov, {\n      offset: 4\n    })) {\n      return true;\n    }\n  },\n  mov: function mov(bytes) {\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.mov, {\n      offset: 4\n    });\n  },\n  '3gp': function gp(bytes) {\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS['3gp'], {\n      offset: 4\n    });\n  },\n  ac3: function ac3(bytes) {\n    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.ac3, {\n      offset: offset\n    });\n  },\n  ts: function ts(bytes) {\n    if (bytes.length < 189 && bytes.length >= 1) {\n      return bytes[0] === 0x47;\n    }\n\n    var i = 0; // check the first 376 bytes for two matching sync bytes\n\n    while (i + 188 < bytes.length && i < 188) {\n      if (bytes[i] === 0x47 && bytes[i + 188] === 0x47) {\n        return true;\n      }\n\n      i += 1;\n    }\n\n    return false;\n  },\n  flac: function flac(bytes) {\n    var offset = (0,_id3_helpers_js__WEBPACK_IMPORTED_MODULE_3__.getId3Offset)(bytes);\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.flac, {\n      offset: offset\n    });\n  },\n  ogg: function ogg(bytes) {\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.ogg);\n  },\n  avi: function avi(bytes) {\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.riff) && (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.avi, {\n      offset: 8\n    });\n  },\n  wav: function wav(bytes) {\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.riff) && (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, CONSTANTS.wav, {\n      offset: 8\n    });\n  },\n  'h264': function h264(bytes) {\n    // find seq_parameter_set_rbsp\n    return (0,_nal_helpers_js__WEBPACK_IMPORTED_MODULE_4__.findH264Nal)(bytes, 7, 3).length;\n  },\n  'h265': function h265(bytes) {\n    // find video_parameter_set_rbsp or seq_parameter_set_rbsp\n    return (0,_nal_helpers_js__WEBPACK_IMPORTED_MODULE_4__.findH265Nal)(bytes, [32, 33], 3).length;\n  }\n}; // get all the isLikely functions\n// but make sure 'ts' is above h264 and h265\n// but below everything else as it is the least specific\n\nvar isLikelyTypes = Object.keys(_isLikely) // remove ts, h264, h265\n.filter(function (t) {\n  return t !== 'ts' && t !== 'h264' && t !== 'h265';\n}) // add it back to the bottom\n.concat(['ts', 'h264', 'h265']); // make sure we are dealing with uint8 data.\n\nisLikelyTypes.forEach(function (type) {\n  var isLikelyFn = _isLikely[type];\n\n  _isLikely[type] = function (bytes) {\n    return isLikelyFn((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes));\n  };\n}); // export after wrapping\n\nvar isLikely = _isLikely; // A useful list of file signatures can be found here\n// https://en.wikipedia.org/wiki/List_of_file_signatures\n\nvar detectContainerForBytes = function detectContainerForBytes(bytes) {\n  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n\n  for (var i = 0; i < isLikelyTypes.length; i++) {\n    var type = isLikelyTypes[i];\n\n    if (isLikely[type](bytes)) {\n      return type;\n    }\n  }\n\n  return '';\n}; // fmp4 is not a container\n\nvar isLikelyFmp4MediaSegment = function isLikelyFmp4MediaSegment(bytes) {\n  return (0,_mp4_helpers_js__WEBPACK_IMPORTED_MODULE_1__.findBox)(bytes, ['moof']).length > 0;\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/containers.js?")},"./node_modules/@videojs/vhs-utils/es/decode-b64-to-uint8-array.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ decodeB64ToUint8Array)\n/* harmony export */ });\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! global/window */ \"./node_modules/global/window.js\");\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_0__);\n\n\nvar atob = function atob(s) {\n  return (global_window__WEBPACK_IMPORTED_MODULE_0___default().atob) ? global_window__WEBPACK_IMPORTED_MODULE_0___default().atob(s) : Buffer.from(s, 'base64').toString('binary');\n};\n\nfunction decodeB64ToUint8Array(b64Text) {\n  var decodedString = atob(b64Text);\n  var array = new Uint8Array(decodedString.length);\n\n  for (var i = 0; i < decodedString.length; i++) {\n    array[i] = decodedString.charCodeAt(i);\n  }\n\n  return array;\n}\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/decode-b64-to-uint8-array.js?")},"./node_modules/@videojs/vhs-utils/es/ebml-helpers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EBML_TAGS: () => (/* binding */ EBML_TAGS),\n/* harmony export */   decodeBlock: () => (/* binding */ decodeBlock),\n/* harmony export */   findEbml: () => (/* binding */ findEbml),\n/* harmony export */   parseData: () => (/* binding */ parseData),\n/* harmony export */   parseTracks: () => (/* binding */ parseTracks)\n/* harmony export */ });\n/* harmony import */ var _byte_helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers */ \"./node_modules/@videojs/vhs-utils/es/byte-helpers.js\");\n/* harmony import */ var _codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./codec-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/codec-helpers.js\");\n\n // relevant specs for this parser:\n// https://matroska-org.github.io/libebml/specs.html\n// https://www.matroska.org/technical/elements.html\n// https://www.webmproject.org/docs/container/\n\nvar EBML_TAGS = {\n  EBML: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x1A, 0x45, 0xDF, 0xA3]),\n  DocType: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x42, 0x82]),\n  Segment: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x18, 0x53, 0x80, 0x67]),\n  SegmentInfo: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x15, 0x49, 0xA9, 0x66]),\n  Tracks: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x16, 0x54, 0xAE, 0x6B]),\n  Track: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xAE]),\n  TrackNumber: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xd7]),\n  DefaultDuration: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x23, 0xe3, 0x83]),\n  TrackEntry: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xAE]),\n  TrackType: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x83]),\n  FlagDefault: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x88]),\n  CodecID: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x86]),\n  CodecPrivate: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x63, 0xA2]),\n  VideoTrack: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xe0]),\n  AudioTrack: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xe1]),\n  // Not used yet, but will be used for live webm/mkv\n  // see https://www.matroska.org/technical/basics.html#block-structure\n  // see https://www.matroska.org/technical/basics.html#simpleblock-structure\n  Cluster: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x1F, 0x43, 0xB6, 0x75]),\n  Timestamp: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xE7]),\n  TimestampScale: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x2A, 0xD7, 0xB1]),\n  BlockGroup: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xA0]),\n  BlockDuration: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x9B]),\n  Block: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xA1]),\n  SimpleBlock: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0xA3])\n};\n/**\n * This is a simple table to determine the length\n * of things in ebml. The length is one based (starts at 1,\n * rather than zero) and for every zero bit before a one bit\n * we add one to length. We also need this table because in some\n * case we have to xor all the length bits from another value.\n */\n\nvar LENGTH_TABLE = [128, 64, 32, 16, 8, 4, 2, 1];\n\nvar getLength = function getLength(byte) {\n  var len = 1;\n\n  for (var i = 0; i < LENGTH_TABLE.length; i++) {\n    if (byte & LENGTH_TABLE[i]) {\n      break;\n    }\n\n    len++;\n  }\n\n  return len;\n}; // length in ebml is stored in the first 4 to 8 bits\n// of the first byte. 4 for the id length and 8 for the\n// data size length. Length is measured by converting the number to binary\n// then 1 + the number of zeros before a 1 is encountered starting\n// from the left.\n\n\nvar getvint = function getvint(bytes, offset, removeLength, signed) {\n  if (removeLength === void 0) {\n    removeLength = true;\n  }\n\n  if (signed === void 0) {\n    signed = false;\n  }\n\n  var length = getLength(bytes[offset]);\n  var valueBytes = bytes.subarray(offset, offset + length); // NOTE that we do **not** subarray here because we need to copy these bytes\n  // as they will be modified below to remove the dataSizeLen bits and we do not\n  // want to modify the original data. normally we could just call slice on\n  // uint8array but ie 11 does not support that...\n\n  if (removeLength) {\n    valueBytes = Array.prototype.slice.call(bytes, offset, offset + length);\n    valueBytes[0] ^= LENGTH_TABLE[length - 1];\n  }\n\n  return {\n    length: length,\n    value: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(valueBytes, {\n      signed: signed\n    }),\n    bytes: valueBytes\n  };\n};\n\nvar normalizePath = function normalizePath(path) {\n  if (typeof path === 'string') {\n    return path.match(/.{1,2}/g).map(function (p) {\n      return normalizePath(p);\n    });\n  }\n\n  if (typeof path === 'number') {\n    return (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.numberToBytes)(path);\n  }\n\n  return path;\n};\n\nvar normalizePaths = function normalizePaths(paths) {\n  if (!Array.isArray(paths)) {\n    return [normalizePath(paths)];\n  }\n\n  return paths.map(function (p) {\n    return normalizePath(p);\n  });\n};\n\nvar getInfinityDataSize = function getInfinityDataSize(id, bytes, offset) {\n  if (offset >= bytes.length) {\n    return bytes.length;\n  }\n\n  var innerid = getvint(bytes, offset, false);\n\n  if ((0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(id.bytes, innerid.bytes)) {\n    return offset;\n  }\n\n  var dataHeader = getvint(bytes, offset + innerid.length);\n  return getInfinityDataSize(id, bytes, offset + dataHeader.length + dataHeader.value + innerid.length);\n};\n/**\n * Notes on the EBLM format.\n *\n * EBLM uses \"vints\" tags. Every vint tag contains\n * two parts\n *\n * 1. The length from the first byte. You get this by\n *    converting the byte to binary and counting the zeros\n *    before a 1. Then you add 1 to that. Examples\n *    00011111 = length 4 because there are 3 zeros before a 1.\n *    00100000 = length 3 because there are 2 zeros before a 1.\n *    00000011 = length 7 because there are 6 zeros before a 1.\n *\n * 2. The bits used for length are removed from the first byte\n *    Then all the bytes are merged into a value. NOTE: this\n *    is not the case for id ebml tags as there id includes\n *    length bits.\n *\n */\n\n\nvar findEbml = function findEbml(bytes, paths) {\n  paths = normalizePaths(paths);\n  bytes = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n  var results = [];\n\n  if (!paths.length) {\n    return results;\n  }\n\n  var i = 0;\n\n  while (i < bytes.length) {\n    var id = getvint(bytes, i, false);\n    var dataHeader = getvint(bytes, i + id.length);\n    var dataStart = i + id.length + dataHeader.length; // dataSize is unknown or this is a live stream\n\n    if (dataHeader.value === 0x7f) {\n      dataHeader.value = getInfinityDataSize(id, bytes, dataStart);\n\n      if (dataHeader.value !== bytes.length) {\n        dataHeader.value -= dataStart;\n      }\n    }\n\n    var dataEnd = dataStart + dataHeader.value > bytes.length ? bytes.length : dataStart + dataHeader.value;\n    var data = bytes.subarray(dataStart, dataEnd);\n\n    if ((0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(paths[0], id.bytes)) {\n      if (paths.length === 1) {\n        // this is the end of the paths and we've found the tag we were\n        // looking for\n        results.push(data);\n      } else {\n        // recursively search for the next tag inside of the data\n        // of this one\n        results = results.concat(findEbml(data, paths.slice(1)));\n      }\n    }\n\n    var totalLength = id.length + dataHeader.length + data.length; // move past this tag entirely, we are not looking for it\n\n    i += totalLength;\n  }\n\n  return results;\n}; // see https://www.matroska.org/technical/basics.html#block-structure\n\nvar decodeBlock = function decodeBlock(block, type, timestampScale, clusterTimestamp) {\n  var duration;\n\n  if (type === 'group') {\n    duration = findEbml(block, [EBML_TAGS.BlockDuration])[0];\n\n    if (duration) {\n      duration = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(duration);\n      duration = 1 / timestampScale * duration * timestampScale / 1000;\n    }\n\n    block = findEbml(block, [EBML_TAGS.Block])[0];\n    type = 'block'; // treat data as a block after this point\n  }\n\n  var dv = new DataView(block.buffer, block.byteOffset, block.byteLength);\n  var trackNumber = getvint(block, 0);\n  var timestamp = dv.getInt16(trackNumber.length, false);\n  var flags = block[trackNumber.length + 2];\n  var data = block.subarray(trackNumber.length + 3); // pts/dts in seconds\n\n  var ptsdts = 1 / timestampScale * (clusterTimestamp + timestamp) * timestampScale / 1000; // return the frame\n\n  var parsed = {\n    duration: duration,\n    trackNumber: trackNumber.value,\n    keyframe: type === 'simple' && flags >> 7 === 1,\n    invisible: (flags & 0x08) >> 3 === 1,\n    lacing: (flags & 0x06) >> 1,\n    discardable: type === 'simple' && (flags & 0x01) === 1,\n    frames: [],\n    pts: ptsdts,\n    dts: ptsdts,\n    timestamp: timestamp\n  };\n\n  if (!parsed.lacing) {\n    parsed.frames.push(data);\n    return parsed;\n  }\n\n  var numberOfFrames = data[0] + 1;\n  var frameSizes = [];\n  var offset = 1; // Fixed\n\n  if (parsed.lacing === 2) {\n    var sizeOfFrame = (data.length - offset) / numberOfFrames;\n\n    for (var i = 0; i < numberOfFrames; i++) {\n      frameSizes.push(sizeOfFrame);\n    }\n  } // xiph\n\n\n  if (parsed.lacing === 1) {\n    for (var _i = 0; _i < numberOfFrames - 1; _i++) {\n      var size = 0;\n\n      do {\n        size += data[offset];\n        offset++;\n      } while (data[offset - 1] === 0xFF);\n\n      frameSizes.push(size);\n    }\n  } // ebml\n\n\n  if (parsed.lacing === 3) {\n    // first vint is unsinged\n    // after that vints are singed and\n    // based on a compounding size\n    var _size = 0;\n\n    for (var _i2 = 0; _i2 < numberOfFrames - 1; _i2++) {\n      var vint = _i2 === 0 ? getvint(data, offset) : getvint(data, offset, true, true);\n      _size += vint.value;\n      frameSizes.push(_size);\n      offset += vint.length;\n    }\n  }\n\n  frameSizes.forEach(function (size) {\n    parsed.frames.push(data.subarray(offset, offset + size));\n    offset += size;\n  });\n  return parsed;\n}; // VP9 Codec Feature Metadata (CodecPrivate)\n// https://www.webmproject.org/docs/container/\n\nvar parseVp9Private = function parseVp9Private(bytes) {\n  var i = 0;\n  var params = {};\n\n  while (i < bytes.length) {\n    var id = bytes[i] & 0x7f;\n    var len = bytes[i + 1];\n    var val = void 0;\n\n    if (len === 1) {\n      val = bytes[i + 2];\n    } else {\n      val = bytes.subarray(i + 2, i + 2 + len);\n    }\n\n    if (id === 1) {\n      params.profile = val;\n    } else if (id === 2) {\n      params.level = val;\n    } else if (id === 3) {\n      params.bitDepth = val;\n    } else if (id === 4) {\n      params.chromaSubsampling = val;\n    } else {\n      params[id] = val;\n    }\n\n    i += 2 + len;\n  }\n\n  return params;\n};\n\nvar parseTracks = function parseTracks(bytes) {\n  bytes = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n  var decodedTracks = [];\n  var tracks = findEbml(bytes, [EBML_TAGS.Segment, EBML_TAGS.Tracks, EBML_TAGS.Track]);\n\n  if (!tracks.length) {\n    tracks = findEbml(bytes, [EBML_TAGS.Tracks, EBML_TAGS.Track]);\n  }\n\n  if (!tracks.length) {\n    tracks = findEbml(bytes, [EBML_TAGS.Track]);\n  }\n\n  if (!tracks.length) {\n    return decodedTracks;\n  }\n\n  tracks.forEach(function (track) {\n    var trackType = findEbml(track, EBML_TAGS.TrackType)[0];\n\n    if (!trackType || !trackType.length) {\n      return;\n    } // 1 is video, 2 is audio, 17 is subtitle\n    // other values are unimportant in this context\n\n\n    if (trackType[0] === 1) {\n      trackType = 'video';\n    } else if (trackType[0] === 2) {\n      trackType = 'audio';\n    } else if (trackType[0] === 17) {\n      trackType = 'subtitle';\n    } else {\n      return;\n    } // todo parse language\n\n\n    var decodedTrack = {\n      rawCodec: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(findEbml(track, [EBML_TAGS.CodecID])[0]),\n      type: trackType,\n      codecPrivate: findEbml(track, [EBML_TAGS.CodecPrivate])[0],\n      number: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(findEbml(track, [EBML_TAGS.TrackNumber])[0]),\n      defaultDuration: (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(findEbml(track, [EBML_TAGS.DefaultDuration])[0]),\n      default: findEbml(track, [EBML_TAGS.FlagDefault])[0],\n      rawData: track\n    };\n    var codec = '';\n\n    if (/V_MPEG4\\/ISO\\/AVC/.test(decodedTrack.rawCodec)) {\n      codec = \"avc1.\" + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAvcCodec)(decodedTrack.codecPrivate);\n    } else if (/V_MPEGH\\/ISO\\/HEVC/.test(decodedTrack.rawCodec)) {\n      codec = \"hev1.\" + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getHvcCodec)(decodedTrack.codecPrivate);\n    } else if (/V_MPEG4\\/ISO\\/ASP/.test(decodedTrack.rawCodec)) {\n      if (decodedTrack.codecPrivate) {\n        codec = 'mp4v.20.' + decodedTrack.codecPrivate[4].toString();\n      } else {\n        codec = 'mp4v.20.9';\n      }\n    } else if (/^V_THEORA/.test(decodedTrack.rawCodec)) {\n      codec = 'theora';\n    } else if (/^V_VP8/.test(decodedTrack.rawCodec)) {\n      codec = 'vp8';\n    } else if (/^V_VP9/.test(decodedTrack.rawCodec)) {\n      if (decodedTrack.codecPrivate) {\n        var _parseVp9Private = parseVp9Private(decodedTrack.codecPrivate),\n            profile = _parseVp9Private.profile,\n            level = _parseVp9Private.level,\n            bitDepth = _parseVp9Private.bitDepth,\n            chromaSubsampling = _parseVp9Private.chromaSubsampling;\n\n        codec = 'vp09.';\n        codec += (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(profile, 2, '0') + \".\";\n        codec += (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(level, 2, '0') + \".\";\n        codec += (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(bitDepth, 2, '0') + \".\";\n        codec += \"\" + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(chromaSubsampling, 2, '0'); // Video -> Colour -> Ebml name\n\n        var matrixCoefficients = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xB1]])[0] || [];\n        var videoFullRangeFlag = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xB9]])[0] || [];\n        var transferCharacteristics = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xBA]])[0] || [];\n        var colourPrimaries = findEbml(track, [0xE0, [0x55, 0xB0], [0x55, 0xBB]])[0] || []; // if we find any optional codec parameter specify them all.\n\n        if (matrixCoefficients.length || videoFullRangeFlag.length || transferCharacteristics.length || colourPrimaries.length) {\n          codec += \".\" + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(colourPrimaries[0], 2, '0');\n          codec += \".\" + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(transferCharacteristics[0], 2, '0');\n          codec += \".\" + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(matrixCoefficients[0], 2, '0');\n          codec += \".\" + (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.padStart)(videoFullRangeFlag[0], 2, '0');\n        }\n      } else {\n        codec = 'vp9';\n      }\n    } else if (/^V_AV1/.test(decodedTrack.rawCodec)) {\n      codec = \"av01.\" + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAv1Codec)(decodedTrack.codecPrivate);\n    } else if (/A_ALAC/.test(decodedTrack.rawCodec)) {\n      codec = 'alac';\n    } else if (/A_MPEG\\/L2/.test(decodedTrack.rawCodec)) {\n      codec = 'mp2';\n    } else if (/A_MPEG\\/L3/.test(decodedTrack.rawCodec)) {\n      codec = 'mp3';\n    } else if (/^A_AAC/.test(decodedTrack.rawCodec)) {\n      if (decodedTrack.codecPrivate) {\n        codec = 'mp4a.40.' + (decodedTrack.codecPrivate[0] >>> 3).toString();\n      } else {\n        codec = 'mp4a.40.2';\n      }\n    } else if (/^A_AC3/.test(decodedTrack.rawCodec)) {\n      codec = 'ac-3';\n    } else if (/^A_PCM/.test(decodedTrack.rawCodec)) {\n      codec = 'pcm';\n    } else if (/^A_MS\\/ACM/.test(decodedTrack.rawCodec)) {\n      codec = 'speex';\n    } else if (/^A_EAC3/.test(decodedTrack.rawCodec)) {\n      codec = 'ec-3';\n    } else if (/^A_VORBIS/.test(decodedTrack.rawCodec)) {\n      codec = 'vorbis';\n    } else if (/^A_FLAC/.test(decodedTrack.rawCodec)) {\n      codec = 'flac';\n    } else if (/^A_OPUS/.test(decodedTrack.rawCodec)) {\n      codec = 'opus';\n    }\n\n    decodedTrack.codec = codec;\n    decodedTracks.push(decodedTrack);\n  });\n  return decodedTracks.sort(function (a, b) {\n    return a.number - b.number;\n  });\n};\nvar parseData = function parseData(data, tracks) {\n  var allBlocks = [];\n  var segment = findEbml(data, [EBML_TAGS.Segment])[0];\n  var timestampScale = findEbml(segment, [EBML_TAGS.SegmentInfo, EBML_TAGS.TimestampScale])[0]; // in nanoseconds, defaults to 1ms\n\n  if (timestampScale && timestampScale.length) {\n    timestampScale = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(timestampScale);\n  } else {\n    timestampScale = 1000000;\n  }\n\n  var clusters = findEbml(segment, [EBML_TAGS.Cluster]);\n\n  if (!tracks) {\n    tracks = parseTracks(segment);\n  }\n\n  clusters.forEach(function (cluster, ci) {\n    var simpleBlocks = findEbml(cluster, [EBML_TAGS.SimpleBlock]).map(function (b) {\n      return {\n        type: 'simple',\n        data: b\n      };\n    });\n    var blockGroups = findEbml(cluster, [EBML_TAGS.BlockGroup]).map(function (b) {\n      return {\n        type: 'group',\n        data: b\n      };\n    });\n    var timestamp = findEbml(cluster, [EBML_TAGS.Timestamp])[0] || 0;\n\n    if (timestamp && timestamp.length) {\n      timestamp = (0,_byte_helpers__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(timestamp);\n    } // get all blocks then sort them into the correct order\n\n\n    var blocks = simpleBlocks.concat(blockGroups).sort(function (a, b) {\n      return a.data.byteOffset - b.data.byteOffset;\n    });\n    blocks.forEach(function (block, bi) {\n      var decoded = decodeBlock(block.data, block.type, timestampScale, timestamp);\n      allBlocks.push(decoded);\n    });\n  });\n  return {\n    tracks: tracks,\n    blocks: allBlocks\n  };\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/ebml-helpers.js?")},"./node_modules/@videojs/vhs-utils/es/id3-helpers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getId3Offset: () => (/* binding */ getId3Offset),\n/* harmony export */   getId3Size: () => (/* binding */ getId3Size)\n/* harmony export */ });\n/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ "./node_modules/@videojs/vhs-utils/es/byte-helpers.js");\n\nvar ID3 = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x49, 0x44, 0x33]);\nvar getId3Size = function getId3Size(bytes, offset) {\n  if (offset === void 0) {\n    offset = 0;\n  }\n\n  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n  var flags = bytes[offset + 5];\n  var returnSize = bytes[offset + 6] << 21 | bytes[offset + 7] << 14 | bytes[offset + 8] << 7 | bytes[offset + 9];\n  var footerPresent = (flags & 16) >> 4;\n\n  if (footerPresent) {\n    return returnSize + 20;\n  }\n\n  return returnSize + 10;\n};\nvar getId3Offset = function getId3Offset(bytes, offset) {\n  if (offset === void 0) {\n    offset = 0;\n  }\n\n  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n\n  if (bytes.length - offset < 10 || !(0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes, ID3, {\n    offset: offset\n  })) {\n    return offset;\n  }\n\n  offset += getId3Size(bytes, offset); // recursive check for id3 tags as some files\n  // have multiple ID3 tag sections even though\n  // they should not.\n\n  return getId3Offset(bytes, offset);\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/id3-helpers.js?')},"./node_modules/@videojs/vhs-utils/es/media-groups.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   forEachMediaGroup: () => (/* binding */ forEachMediaGroup)\n/* harmony export */ });\n/**\n * Loops through all supported media groups in master and calls the provided\n * callback for each group\n *\n * @param {Object} master\n *        The parsed master manifest object\n * @param {string[]} groups\n *        The media groups to call the callback for\n * @param {Function} callback\n *        Callback to call for each media group\n */\nvar forEachMediaGroup = function forEachMediaGroup(master, groups, callback) {\n  groups.forEach(function (mediaType) {\n    for (var groupKey in master.mediaGroups[mediaType]) {\n      for (var labelKey in master.mediaGroups[mediaType][groupKey]) {\n        var mediaProperties = master.mediaGroups[mediaType][groupKey][labelKey];\n        callback(mediaProperties, mediaType, groupKey, labelKey);\n      }\n    }\n  });\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/media-groups.js?")},"./node_modules/@videojs/vhs-utils/es/media-types.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   simpleTypeFromSourceType: () => (/* binding */ simpleTypeFromSourceType)\n/* harmony export */ });\nvar MPEGURL_REGEX = /^(audio|video|application)\\/(x-|vnd\\.apple\\.)?mpegurl/i;\nvar DASH_REGEX = /^application\\/dash\\+xml/i;\n/**\n * Returns a string that describes the type of source based on a video source object's\n * media type.\n *\n * @see {@link https://dev.w3.org/html5/pf-summary/video.html#dom-source-type|Source Type}\n *\n * @param {string} type\n *        Video source object media type\n * @return {('hls'|'dash'|'vhs-json'|null)}\n *         VHS source type string\n */\n\nvar simpleTypeFromSourceType = function simpleTypeFromSourceType(type) {\n  if (MPEGURL_REGEX.test(type)) {\n    return 'hls';\n  }\n\n  if (DASH_REGEX.test(type)) {\n    return 'dash';\n  } // Denotes the special case of a manifest object passed to http-streaming instead of a\n  // source URL.\n  //\n  // See https://en.wikipedia.org/wiki/Media_type for details on specifying media types.\n  //\n  // In this case, vnd stands for vendor, video.js for the organization, VHS for this\n  // project, and the +json suffix identifies the structure of the media type.\n\n\n  if (type === 'application/vnd.videojs.vhs+json') {\n    return 'vhs-json';\n  }\n\n  return null;\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/media-types.js?")},"./node_modules/@videojs/vhs-utils/es/mp4-helpers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   addSampleDescription: () => (/* binding */ addSampleDescription),\n/* harmony export */   buildFrameTable: () => (/* binding */ buildFrameTable),\n/* harmony export */   findBox: () => (/* binding */ findBox),\n/* harmony export */   findNamedBox: () => (/* binding */ findNamedBox),\n/* harmony export */   parseDescriptors: () => (/* binding */ parseDescriptors),\n/* harmony export */   parseMediaInfo: () => (/* binding */ parseMediaInfo),\n/* harmony export */   parseTracks: () => (/* binding */ parseTracks)\n/* harmony export */ });\n/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/byte-helpers.js\");\n/* harmony import */ var _codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./codec-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/codec-helpers.js\");\n/* harmony import */ var _opus_helpers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./opus-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/opus-helpers.js\");\n\n\n\n\nvar normalizePath = function normalizePath(path) {\n  if (typeof path === 'string') {\n    return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.stringToBytes)(path);\n  }\n\n  if (typeof path === 'number') {\n    return path;\n  }\n\n  return path;\n};\n\nvar normalizePaths = function normalizePaths(paths) {\n  if (!Array.isArray(paths)) {\n    return [normalizePath(paths)];\n  }\n\n  return paths.map(function (p) {\n    return normalizePath(p);\n  });\n};\n\nvar DESCRIPTORS;\nvar parseDescriptors = function parseDescriptors(bytes) {\n  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n  var results = [];\n  var i = 0;\n\n  while (bytes.length > i) {\n    var tag = bytes[i];\n    var size = 0;\n    var headerSize = 0; // tag\n\n    headerSize++;\n    var byte = bytes[headerSize]; // first byte\n\n    headerSize++;\n\n    while (byte & 0x80) {\n      size = (byte & 0x7F) << 7;\n      byte = bytes[headerSize];\n      headerSize++;\n    }\n\n    size += byte & 0x7F;\n\n    for (var z = 0; z < DESCRIPTORS.length; z++) {\n      var _DESCRIPTORS$z = DESCRIPTORS[z],\n          id = _DESCRIPTORS$z.id,\n          parser = _DESCRIPTORS$z.parser;\n\n      if (tag === id) {\n        results.push(parser(bytes.subarray(headerSize, headerSize + size)));\n        break;\n      }\n    }\n\n    i += size + headerSize;\n  }\n\n  return results;\n};\nDESCRIPTORS = [{\n  id: 0x03,\n  parser: function parser(bytes) {\n    var desc = {\n      tag: 0x03,\n      id: bytes[0] << 8 | bytes[1],\n      flags: bytes[2],\n      size: 3,\n      dependsOnEsId: 0,\n      ocrEsId: 0,\n      descriptors: [],\n      url: ''\n    }; // depends on es id\n\n    if (desc.flags & 0x80) {\n      desc.dependsOnEsId = bytes[desc.size] << 8 | bytes[desc.size + 1];\n      desc.size += 2;\n    } // url\n\n\n    if (desc.flags & 0x40) {\n      var len = bytes[desc.size];\n      desc.url = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(bytes.subarray(desc.size + 1, desc.size + 1 + len));\n      desc.size += len;\n    } // ocr es id\n\n\n    if (desc.flags & 0x20) {\n      desc.ocrEsId = bytes[desc.size] << 8 | bytes[desc.size + 1];\n      desc.size += 2;\n    }\n\n    desc.descriptors = parseDescriptors(bytes.subarray(desc.size)) || [];\n    return desc;\n  }\n}, {\n  id: 0x04,\n  parser: function parser(bytes) {\n    // DecoderConfigDescriptor\n    var desc = {\n      tag: 0x04,\n      oti: bytes[0],\n      streamType: bytes[1],\n      bufferSize: bytes[2] << 16 | bytes[3] << 8 | bytes[4],\n      maxBitrate: bytes[5] << 24 | bytes[6] << 16 | bytes[7] << 8 | bytes[8],\n      avgBitrate: bytes[9] << 24 | bytes[10] << 16 | bytes[11] << 8 | bytes[12],\n      descriptors: parseDescriptors(bytes.subarray(13))\n    };\n    return desc;\n  }\n}, {\n  id: 0x05,\n  parser: function parser(bytes) {\n    // DecoderSpecificInfo\n    return {\n      tag: 0x05,\n      bytes: bytes\n    };\n  }\n}, {\n  id: 0x06,\n  parser: function parser(bytes) {\n    // SLConfigDescriptor\n    return {\n      tag: 0x06,\n      bytes: bytes\n    };\n  }\n}];\n/**\n * find any number of boxes by name given a path to it in an iso bmff\n * such as mp4.\n *\n * @param {TypedArray} bytes\n *        bytes for the iso bmff to search for boxes in\n *\n * @param {Uint8Array[]|string[]|string|Uint8Array} name\n *        An array of paths or a single path representing the name\n *        of boxes to search through in bytes. Paths may be\n *        uint8 (character codes) or strings.\n *\n * @param {boolean} [complete=false]\n *        Should we search only for complete boxes on the final path.\n *        This is very useful when you do not want to get back partial boxes\n *        in the case of streaming files.\n *\n * @return {Uint8Array[]}\n *         An array of the end paths that we found.\n */\n\nvar findBox = function findBox(bytes, paths, complete) {\n  if (complete === void 0) {\n    complete = false;\n  }\n\n  paths = normalizePaths(paths);\n  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n  var results = [];\n\n  if (!paths.length) {\n    // short-circuit the search for empty paths\n    return results;\n  }\n\n  var i = 0;\n\n  while (i < bytes.length) {\n    var size = (bytes[i] << 24 | bytes[i + 1] << 16 | bytes[i + 2] << 8 | bytes[i + 3]) >>> 0;\n    var type = bytes.subarray(i + 4, i + 8); // invalid box format.\n\n    if (size === 0) {\n      break;\n    }\n\n    var end = i + size;\n\n    if (end > bytes.length) {\n      // this box is bigger than the number of bytes we have\n      // and complete is set, we cannot find any more boxes.\n      if (complete) {\n        break;\n      }\n\n      end = bytes.length;\n    }\n\n    var data = bytes.subarray(i + 8, end);\n\n    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(type, paths[0])) {\n      if (paths.length === 1) {\n        // this is the end of the path and we've found the box we were\n        // looking for\n        results.push(data);\n      } else {\n        // recursively search for the next box along the path\n        results.push.apply(results, findBox(data, paths.slice(1), complete));\n      }\n    }\n\n    i = end;\n  } // we've finished searching all of bytes\n\n\n  return results;\n};\n/**\n * Search for a single matching box by name in an iso bmff format like\n * mp4. This function is useful for finding codec boxes which\n * can be placed arbitrarily in sample descriptions depending\n * on the version of the file or file type.\n *\n * @param {TypedArray} bytes\n *        bytes for the iso bmff to search for boxes in\n *\n * @param {string|Uint8Array} name\n *        The name of the box to find.\n *\n * @return {Uint8Array[]}\n *         a subarray of bytes representing the name boxed we found.\n */\n\nvar findNamedBox = function findNamedBox(bytes, name) {\n  name = normalizePath(name);\n\n  if (!name.length) {\n    // short-circuit the search for empty paths\n    return bytes.subarray(bytes.length);\n  }\n\n  var i = 0;\n\n  while (i < bytes.length) {\n    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i, i + name.length), name)) {\n      var size = (bytes[i - 4] << 24 | bytes[i - 3] << 16 | bytes[i - 2] << 8 | bytes[i - 1]) >>> 0;\n      var end = size > 1 ? i + size : bytes.byteLength;\n      return bytes.subarray(i + 4, end);\n    }\n\n    i++;\n  } // we've finished searching all of bytes\n\n\n  return bytes.subarray(bytes.length);\n};\n\nvar parseSamples = function parseSamples(data, entrySize, parseEntry) {\n  if (entrySize === void 0) {\n    entrySize = 4;\n  }\n\n  if (parseEntry === void 0) {\n    parseEntry = function parseEntry(d) {\n      return (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(d);\n    };\n  }\n\n  var entries = [];\n\n  if (!data || !data.length) {\n    return entries;\n  }\n\n  var entryCount = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(data.subarray(4, 8));\n\n  for (var i = 8; entryCount; i += entrySize, entryCount--) {\n    entries.push(parseEntry(data.subarray(i, i + entrySize)));\n  }\n\n  return entries;\n};\n\nvar buildFrameTable = function buildFrameTable(stbl, timescale) {\n  var keySamples = parseSamples(findBox(stbl, ['stss'])[0]);\n  var chunkOffsets = parseSamples(findBox(stbl, ['stco'])[0]);\n  var timeToSamples = parseSamples(findBox(stbl, ['stts'])[0], 8, function (entry) {\n    return {\n      sampleCount: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(0, 4)),\n      sampleDelta: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(4, 8))\n    };\n  });\n  var samplesToChunks = parseSamples(findBox(stbl, ['stsc'])[0], 12, function (entry) {\n    return {\n      firstChunk: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(0, 4)),\n      samplesPerChunk: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(4, 8)),\n      sampleDescriptionIndex: (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(entry.subarray(8, 12))\n    };\n  });\n  var stsz = findBox(stbl, ['stsz'])[0]; // stsz starts with a 4 byte sampleSize which we don't need\n\n  var sampleSizes = parseSamples(stsz && stsz.length && stsz.subarray(4) || null);\n  var frames = [];\n\n  for (var chunkIndex = 0; chunkIndex < chunkOffsets.length; chunkIndex++) {\n    var samplesInChunk = void 0;\n\n    for (var i = 0; i < samplesToChunks.length; i++) {\n      var sampleToChunk = samplesToChunks[i];\n      var isThisOne = chunkIndex + 1 >= sampleToChunk.firstChunk && (i + 1 >= samplesToChunks.length || chunkIndex + 1 < samplesToChunks[i + 1].firstChunk);\n\n      if (isThisOne) {\n        samplesInChunk = sampleToChunk.samplesPerChunk;\n        break;\n      }\n    }\n\n    var chunkOffset = chunkOffsets[chunkIndex];\n\n    for (var _i = 0; _i < samplesInChunk; _i++) {\n      var frameEnd = sampleSizes[frames.length]; // if we don't have key samples every frame is a keyframe\n\n      var keyframe = !keySamples.length;\n\n      if (keySamples.length && keySamples.indexOf(frames.length + 1) !== -1) {\n        keyframe = true;\n      }\n\n      var frame = {\n        keyframe: keyframe,\n        start: chunkOffset,\n        end: chunkOffset + frameEnd\n      };\n\n      for (var k = 0; k < timeToSamples.length; k++) {\n        var _timeToSamples$k = timeToSamples[k],\n            sampleCount = _timeToSamples$k.sampleCount,\n            sampleDelta = _timeToSamples$k.sampleDelta;\n\n        if (frames.length <= sampleCount) {\n          // ms to ns\n          var lastTimestamp = frames.length ? frames[frames.length - 1].timestamp : 0;\n          frame.timestamp = lastTimestamp + sampleDelta / timescale * 1000;\n          frame.duration = sampleDelta;\n          break;\n        }\n      }\n\n      frames.push(frame);\n      chunkOffset += frameEnd;\n    }\n  }\n\n  return frames;\n};\nvar addSampleDescription = function addSampleDescription(track, bytes) {\n  var codec = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(bytes.subarray(0, 4));\n\n  if (track.type === 'video') {\n    track.info = track.info || {};\n    track.info.width = bytes[28] << 8 | bytes[29];\n    track.info.height = bytes[30] << 8 | bytes[31];\n  } else if (track.type === 'audio') {\n    track.info = track.info || {};\n    track.info.channels = bytes[20] << 8 | bytes[21];\n    track.info.bitDepth = bytes[22] << 8 | bytes[23];\n    track.info.sampleRate = bytes[28] << 8 | bytes[29];\n  }\n\n  if (codec === 'avc1') {\n    var avcC = findNamedBox(bytes, 'avcC'); // AVCDecoderConfigurationRecord\n\n    codec += \".\" + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAvcCodec)(avcC);\n    track.info.avcC = avcC; // TODO: do we need to parse all this?\n\n    /* {\n      configurationVersion: avcC[0],\n      profile: avcC[1],\n      profileCompatibility: avcC[2],\n      level: avcC[3],\n      lengthSizeMinusOne: avcC[4] & 0x3\n    };\n     let spsNalUnitCount = avcC[5] & 0x1F;\n    const spsNalUnits = track.info.avc.spsNalUnits = [];\n     // past spsNalUnitCount\n    let offset = 6;\n     while (spsNalUnitCount--) {\n      const nalLen = avcC[offset] << 8 | avcC[offset + 1];\n       spsNalUnits.push(avcC.subarray(offset + 2, offset + 2 + nalLen));\n       offset += nalLen + 2;\n    }\n    let ppsNalUnitCount = avcC[offset];\n    const ppsNalUnits = track.info.avc.ppsNalUnits = [];\n     // past ppsNalUnitCount\n    offset += 1;\n     while (ppsNalUnitCount--) {\n      const nalLen = avcC[offset] << 8 | avcC[offset + 1];\n       ppsNalUnits.push(avcC.subarray(offset + 2, offset + 2 + nalLen));\n       offset += nalLen + 2;\n    }*/\n    // HEVCDecoderConfigurationRecord\n  } else if (codec === 'hvc1' || codec === 'hev1') {\n    codec += \".\" + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getHvcCodec)(findNamedBox(bytes, 'hvcC'));\n  } else if (codec === 'mp4a' || codec === 'mp4v') {\n    var esds = findNamedBox(bytes, 'esds');\n    var esDescriptor = parseDescriptors(esds.subarray(4))[0];\n    var decoderConfig = esDescriptor && esDescriptor.descriptors.filter(function (_ref) {\n      var tag = _ref.tag;\n      return tag === 0x04;\n    })[0];\n\n    if (decoderConfig) {\n      // most codecs do not have a further '.'\n      // such as 0xa5 for ac-3 and 0xa6 for e-ac-3\n      codec += '.' + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toHexString)(decoderConfig.oti);\n\n      if (decoderConfig.oti === 0x40) {\n        codec += '.' + (decoderConfig.descriptors[0].bytes[0] >> 3).toString();\n      } else if (decoderConfig.oti === 0x20) {\n        codec += '.' + decoderConfig.descriptors[0].bytes[4].toString();\n      } else if (decoderConfig.oti === 0xdd) {\n        codec = 'vorbis';\n      }\n    } else if (track.type === 'audio') {\n      codec += '.40.2';\n    } else {\n      codec += '.20.9';\n    }\n  } else if (codec === 'av01') {\n    // AV1DecoderConfigurationRecord\n    codec += \".\" + (0,_codec_helpers_js__WEBPACK_IMPORTED_MODULE_1__.getAv1Codec)(findNamedBox(bytes, 'av1C'));\n  } else if (codec === 'vp09') {\n    // VPCodecConfigurationRecord\n    var vpcC = findNamedBox(bytes, 'vpcC'); // https://www.webmproject.org/vp9/mp4/\n\n    var profile = vpcC[0];\n    var level = vpcC[1];\n    var bitDepth = vpcC[2] >> 4;\n    var chromaSubsampling = (vpcC[2] & 0x0F) >> 1;\n    var videoFullRangeFlag = (vpcC[2] & 0x0F) >> 3;\n    var colourPrimaries = vpcC[3];\n    var transferCharacteristics = vpcC[4];\n    var matrixCoefficients = vpcC[5];\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(profile, 2, '0');\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(level, 2, '0');\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(bitDepth, 2, '0');\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(chromaSubsampling, 2, '0');\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(colourPrimaries, 2, '0');\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(transferCharacteristics, 2, '0');\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(matrixCoefficients, 2, '0');\n    codec += \".\" + (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.padStart)(videoFullRangeFlag, 2, '0');\n  } else if (codec === 'theo') {\n    codec = 'theora';\n  } else if (codec === 'spex') {\n    codec = 'speex';\n  } else if (codec === '.mp3') {\n    codec = 'mp4a.40.34';\n  } else if (codec === 'msVo') {\n    codec = 'vorbis';\n  } else if (codec === 'Opus') {\n    codec = 'opus';\n    var dOps = findNamedBox(bytes, 'dOps');\n    track.info.opus = (0,_opus_helpers_js__WEBPACK_IMPORTED_MODULE_2__.parseOpusHead)(dOps); // TODO: should this go into the webm code??\n    // Firefox requires a codecDelay for opus playback\n    // see https://bugzilla.mozilla.org/show_bug.cgi?id=1276238\n\n    track.info.codecDelay = 6500000;\n  } else {\n    codec = codec.toLowerCase();\n  }\n  /* eslint-enable */\n  // flac, ac-3, ec-3, opus\n\n\n  track.codec = codec;\n};\nvar parseTracks = function parseTracks(bytes, frameTable) {\n  if (frameTable === void 0) {\n    frameTable = true;\n  }\n\n  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n  var traks = findBox(bytes, ['moov', 'trak'], true);\n  var tracks = [];\n  traks.forEach(function (trak) {\n    var track = {\n      bytes: trak\n    };\n    var mdia = findBox(trak, ['mdia'])[0];\n    var hdlr = findBox(mdia, ['hdlr'])[0];\n    var trakType = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(hdlr.subarray(8, 12));\n\n    if (trakType === 'soun') {\n      track.type = 'audio';\n    } else if (trakType === 'vide') {\n      track.type = 'video';\n    } else {\n      track.type = trakType;\n    }\n\n    var tkhd = findBox(trak, ['tkhd'])[0];\n\n    if (tkhd) {\n      var view = new DataView(tkhd.buffer, tkhd.byteOffset, tkhd.byteLength);\n      var tkhdVersion = view.getUint8(0);\n      track.number = tkhdVersion === 0 ? view.getUint32(12) : view.getUint32(20);\n    }\n\n    var mdhd = findBox(mdia, ['mdhd'])[0];\n\n    if (mdhd) {\n      // mdhd is a FullBox, meaning it will have its own version as the first byte\n      var version = mdhd[0];\n      var index = version === 0 ? 12 : 20;\n      track.timescale = (mdhd[index] << 24 | mdhd[index + 1] << 16 | mdhd[index + 2] << 8 | mdhd[index + 3]) >>> 0;\n    }\n\n    var stbl = findBox(mdia, ['minf', 'stbl'])[0];\n    var stsd = findBox(stbl, ['stsd'])[0];\n    var descriptionCount = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(stsd.subarray(4, 8));\n    var offset = 8; // add codec and codec info\n\n    while (descriptionCount--) {\n      var len = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(stsd.subarray(offset, offset + 4));\n      var sampleDescriptor = stsd.subarray(offset + 4, offset + 4 + len);\n      addSampleDescription(track, sampleDescriptor);\n      offset += 4 + len;\n    }\n\n    if (frameTable) {\n      track.frameTable = buildFrameTable(stbl, track.timescale);\n    } // codec has no sub parameters\n\n\n    tracks.push(track);\n  });\n  return tracks;\n};\nvar parseMediaInfo = function parseMediaInfo(bytes) {\n  var mvhd = findBox(bytes, ['moov', 'mvhd'], true)[0];\n\n  if (!mvhd || !mvhd.length) {\n    return;\n  }\n\n  var info = {}; // ms to ns\n  // mvhd v1 has 8 byte duration and other fields too\n\n  if (mvhd[0] === 1) {\n    info.timestampScale = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(20, 24));\n    info.duration = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(24, 32));\n  } else {\n    info.timestampScale = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(12, 16));\n    info.duration = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesToNumber)(mvhd.subarray(16, 20));\n  }\n\n  info.bytes = mvhd;\n  return info;\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/mp4-helpers.js?")},"./node_modules/@videojs/vhs-utils/es/nal-helpers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EMULATION_PREVENTION: () => (/* binding */ EMULATION_PREVENTION),\n/* harmony export */   NAL_TYPE_ONE: () => (/* binding */ NAL_TYPE_ONE),\n/* harmony export */   NAL_TYPE_TWO: () => (/* binding */ NAL_TYPE_TWO),\n/* harmony export */   discardEmulationPreventionBytes: () => (/* binding */ discardEmulationPreventionBytes),\n/* harmony export */   findH264Nal: () => (/* binding */ findH264Nal),\n/* harmony export */   findH265Nal: () => (/* binding */ findH265Nal),\n/* harmony export */   findNal: () => (/* binding */ findNal)\n/* harmony export */ });\n/* harmony import */ var _byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byte-helpers.js */ \"./node_modules/@videojs/vhs-utils/es/byte-helpers.js\");\n\nvar NAL_TYPE_ONE = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x00, 0x00, 0x00, 0x01]);\nvar NAL_TYPE_TWO = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x00, 0x00, 0x01]);\nvar EMULATION_PREVENTION = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)([0x00, 0x00, 0x03]);\n/**\n * Expunge any \"Emulation Prevention\" bytes from a \"Raw Byte\n * Sequence Payload\"\n *\n * @param data {Uint8Array} the bytes of a RBSP from a NAL\n * unit\n * @return {Uint8Array} the RBSP without any Emulation\n * Prevention Bytes\n */\n\nvar discardEmulationPreventionBytes = function discardEmulationPreventionBytes(bytes) {\n  var positions = [];\n  var i = 1; // Find all `Emulation Prevention Bytes`\n\n  while (i < bytes.length - 2) {\n    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i, i + 3), EMULATION_PREVENTION)) {\n      positions.push(i + 2);\n      i++;\n    }\n\n    i++;\n  } // If no Emulation Prevention Bytes were found just return the original\n  // array\n\n\n  if (positions.length === 0) {\n    return bytes;\n  } // Create a new array to hold the NAL unit data\n\n\n  var newLength = bytes.length - positions.length;\n  var newData = new Uint8Array(newLength);\n  var sourceIndex = 0;\n\n  for (i = 0; i < newLength; sourceIndex++, i++) {\n    if (sourceIndex === positions[0]) {\n      // Skip this byte\n      sourceIndex++; // Remove this position index\n\n      positions.shift();\n    }\n\n    newData[i] = bytes[sourceIndex];\n  }\n\n  return newData;\n};\nvar findNal = function findNal(bytes, dataType, types, nalLimit) {\n  if (nalLimit === void 0) {\n    nalLimit = Infinity;\n  }\n\n  bytes = (0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.toUint8)(bytes);\n  types = [].concat(types);\n  var i = 0;\n  var nalStart;\n  var nalsFound = 0; // keep searching until:\n  // we reach the end of bytes\n  // we reach the maximum number of nals they want to seach\n  // NOTE: that we disregard nalLimit when we have found the start\n  // of the nal we want so that we can find the end of the nal we want.\n\n  while (i < bytes.length && (nalsFound < nalLimit || nalStart)) {\n    var nalOffset = void 0;\n\n    if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i), NAL_TYPE_ONE)) {\n      nalOffset = 4;\n    } else if ((0,_byte_helpers_js__WEBPACK_IMPORTED_MODULE_0__.bytesMatch)(bytes.subarray(i), NAL_TYPE_TWO)) {\n      nalOffset = 3;\n    } // we are unsynced,\n    // find the next nal unit\n\n\n    if (!nalOffset) {\n      i++;\n      continue;\n    }\n\n    nalsFound++;\n\n    if (nalStart) {\n      return discardEmulationPreventionBytes(bytes.subarray(nalStart, i));\n    }\n\n    var nalType = void 0;\n\n    if (dataType === 'h264') {\n      nalType = bytes[i + nalOffset] & 0x1f;\n    } else if (dataType === 'h265') {\n      nalType = bytes[i + nalOffset] >> 1 & 0x3f;\n    }\n\n    if (types.indexOf(nalType) !== -1) {\n      nalStart = i + nalOffset;\n    } // nal header is 1 length for h264, and 2 for h265\n\n\n    i += nalOffset + (dataType === 'h264' ? 1 : 2);\n  }\n\n  return bytes.subarray(0, 0);\n};\nvar findH264Nal = function findH264Nal(bytes, type, nalLimit) {\n  return findNal(bytes, 'h264', type, nalLimit);\n};\nvar findH265Nal = function findH265Nal(bytes, type, nalLimit) {\n  return findNal(bytes, 'h265', type, nalLimit);\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/nal-helpers.js?")},"./node_modules/@videojs/vhs-utils/es/opus-helpers.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OPUS_HEAD: () => (/* binding */ OPUS_HEAD),\n/* harmony export */   parseOpusHead: () => (/* binding */ parseOpusHead),\n/* harmony export */   setOpusHead: () => (/* binding */ setOpusHead)\n/* harmony export */ });\nvar OPUS_HEAD = new Uint8Array([// O, p, u, s\n0x4f, 0x70, 0x75, 0x73, // H, e, a, d\n0x48, 0x65, 0x61, 0x64]); // https://wiki.xiph.org/OggOpus\n// https://vfrmaniac.fushizen.eu/contents/opus_in_isobmff.html\n// https://opus-codec.org/docs/opusfile_api-0.7/structOpusHead.html\n\nvar parseOpusHead = function parseOpusHead(bytes) {\n  var view = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength);\n  var version = view.getUint8(0); // version 0, from mp4, does not use littleEndian.\n\n  var littleEndian = version !== 0;\n  var config = {\n    version: version,\n    channels: view.getUint8(1),\n    preSkip: view.getUint16(2, littleEndian),\n    sampleRate: view.getUint32(4, littleEndian),\n    outputGain: view.getUint16(8, littleEndian),\n    channelMappingFamily: view.getUint8(10)\n  };\n\n  if (config.channelMappingFamily > 0 && bytes.length > 10) {\n    config.streamCount = view.getUint8(11);\n    config.twoChannelStreamCount = view.getUint8(12);\n    config.channelMapping = [];\n\n    for (var c = 0; c < config.channels; c++) {\n      config.channelMapping.push(view.getUint8(13 + c));\n    }\n  }\n\n  return config;\n};\nvar setOpusHead = function setOpusHead(config) {\n  var size = config.channelMappingFamily <= 0 ? 11 : 12 + config.channels;\n  var view = new DataView(new ArrayBuffer(size));\n  var littleEndian = config.version !== 0;\n  view.setUint8(0, config.version);\n  view.setUint8(1, config.channels);\n  view.setUint16(2, config.preSkip, littleEndian);\n  view.setUint32(4, config.sampleRate, littleEndian);\n  view.setUint16(8, config.outputGain, littleEndian);\n  view.setUint8(10, config.channelMappingFamily);\n\n  if (config.channelMappingFamily > 0) {\n    view.setUint8(11, config.streamCount);\n    config.channelMapping.foreach(function (cm, i) {\n      view.setUint8(12 + i, cm);\n    });\n  }\n\n  return new Uint8Array(view.buffer);\n};\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/opus-helpers.js?")},"./node_modules/@videojs/vhs-utils/es/resolve-url.js":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var url_toolkit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! url-toolkit */ \"./node_modules/url-toolkit/src/url-toolkit.js\");\n/* harmony import */ var url_toolkit__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(url_toolkit__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! global/window */ \"./node_modules/global/window.js\");\n/* harmony import */ var global_window__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(global_window__WEBPACK_IMPORTED_MODULE_1__);\n\n\nvar DEFAULT_LOCATION = 'http://example.com';\n\nvar resolveUrl = function resolveUrl(baseUrl, relativeUrl) {\n  // return early if we don't need to resolve\n  if (/^[a-z]+:/i.test(relativeUrl)) {\n    return relativeUrl;\n  } // if baseUrl is a data URI, ignore it and resolve everything relative to window.location\n\n\n  if (/^data:/.test(baseUrl)) {\n    baseUrl = (global_window__WEBPACK_IMPORTED_MODULE_1___default().location) && (global_window__WEBPACK_IMPORTED_MODULE_1___default().location).href || '';\n  } // IE11 supports URL but not the URL constructor\n  // feature detect the behavior we want\n\n\n  var nativeURL = typeof (global_window__WEBPACK_IMPORTED_MODULE_1___default().URL) === 'function';\n  var protocolLess = /^\\/\\//.test(baseUrl); // remove location if window.location isn't available (i.e. we're in node)\n  // and if baseUrl isn't an absolute url\n\n  var removeLocation = !(global_window__WEBPACK_IMPORTED_MODULE_1___default().location) && !/\\/\\//i.test(baseUrl); // if the base URL is relative then combine with the current location\n\n  if (nativeURL) {\n    baseUrl = new (global_window__WEBPACK_IMPORTED_MODULE_1___default().URL)(baseUrl, (global_window__WEBPACK_IMPORTED_MODULE_1___default().location) || DEFAULT_LOCATION);\n  } else if (!/\\/\\//i.test(baseUrl)) {\n    baseUrl = url_toolkit__WEBPACK_IMPORTED_MODULE_0___default().buildAbsoluteURL((global_window__WEBPACK_IMPORTED_MODULE_1___default().location) && (global_window__WEBPACK_IMPORTED_MODULE_1___default().location).href || '', baseUrl);\n  }\n\n  if (nativeURL) {\n    var newUrl = new URL(relativeUrl, baseUrl); // if we're a protocol-less url, remove the protocol\n    // and if we're location-less, remove the location\n    // otherwise, return the url unmodified\n\n    if (removeLocation) {\n      return newUrl.href.slice(DEFAULT_LOCATION.length);\n    } else if (protocolLess) {\n      return newUrl.href.slice(newUrl.protocol.length);\n    }\n\n    return newUrl.href;\n  }\n\n  return url_toolkit__WEBPACK_IMPORTED_MODULE_0___default().buildAbsoluteURL(baseUrl, relativeUrl);\n};\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (resolveUrl);\n\n//# sourceURL=webpack://web/./node_modules/@videojs/vhs-utils/es/resolve-url.js?")},"./node_modules/@videojs/xhr/lib/http-handler.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar window = __webpack_require__(/*! global/window */ \"./node_modules/global/window.js\");\n\nvar httpResponseHandler = function httpResponseHandler(callback, decodeResponseBody) {\n  if (decodeResponseBody === void 0) {\n    decodeResponseBody = false;\n  }\n\n  return function (err, response, responseBody) {\n    // if the XHR failed, return that error\n    if (err) {\n      callback(err);\n      return;\n    } // if the HTTP status code is 4xx or 5xx, the request also failed\n\n\n    if (response.statusCode >= 400 && response.statusCode <= 599) {\n      var cause = responseBody;\n\n      if (decodeResponseBody) {\n        if (window.TextDecoder) {\n          var charset = getCharset(response.headers && response.headers['content-type']);\n\n          try {\n            cause = new TextDecoder(charset).decode(responseBody);\n          } catch (e) {}\n        } else {\n          cause = String.fromCharCode.apply(null, new Uint8Array(responseBody));\n        }\n      }\n\n      callback({\n        cause: cause\n      });\n      return;\n    } // otherwise, request succeeded\n\n\n    callback(null, responseBody);\n  };\n};\n\nfunction getCharset(contentTypeHeader) {\n  if (contentTypeHeader === void 0) {\n    contentTypeHeader = '';\n  }\n\n  return contentTypeHeader.toLowerCase().split(';').reduce(function (charset, contentType) {\n    var _contentType$split = contentType.split('='),\n        type = _contentType$split[0],\n        value = _contentType$split[1];\n\n    if (type.trim() === 'charset') {\n      return value.trim();\n    }\n\n    return charset;\n  }, 'utf-8');\n}\n\nmodule.exports = httpResponseHandler;\n\n//# sourceURL=webpack://web/./node_modules/@videojs/xhr/lib/http-handler.js?")},"./node_modules/@videojs/xhr/lib/index.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar window = __webpack_require__(/*! global/window */ "./node_modules/global/window.js");\n\nvar _extends = __webpack_require__(/*! @babel/runtime/helpers/extends */ "./node_modules/@babel/runtime/helpers/extends.js");\n\nvar isFunction = __webpack_require__(/*! is-function */ "./node_modules/is-function/index.js");\n\ncreateXHR.httpHandler = __webpack_require__(/*! ./http-handler.js */ "./node_modules/@videojs/xhr/lib/http-handler.js");\n/**\n * @license\n * slighly modified parse-headers 2.0.2 <https://github.com/kesla/parse-headers/>\n * Copyright (c) 2014 David Björklund\n * Available under the MIT license\n * <https://github.com/kesla/parse-headers/blob/master/LICENCE>\n */\n\nvar parseHeaders = function parseHeaders(headers) {\n  var result = {};\n\n  if (!headers) {\n    return result;\n  }\n\n  headers.trim().split(\'\\n\').forEach(function (row) {\n    var index = row.indexOf(\':\');\n    var key = row.slice(0, index).trim().toLowerCase();\n    var value = row.slice(index + 1).trim();\n\n    if (typeof result[key] === \'undefined\') {\n      result[key] = value;\n    } else if (Array.isArray(result[key])) {\n      result[key].push(value);\n    } else {\n      result[key] = [result[key], value];\n    }\n  });\n  return result;\n};\n\nmodule.exports = createXHR; // Allow use of default import syntax in TypeScript\n\nmodule.exports["default"] = createXHR;\ncreateXHR.XMLHttpRequest = window.XMLHttpRequest || noop;\ncreateXHR.XDomainRequest = "withCredentials" in new createXHR.XMLHttpRequest() ? createXHR.XMLHttpRequest : window.XDomainRequest;\nforEachArray(["get", "put", "post", "patch", "head", "delete"], function (method) {\n  createXHR[method === "delete" ? "del" : method] = function (uri, options, callback) {\n    options = initParams(uri, options, callback);\n    options.method = method.toUpperCase();\n    return _createXHR(options);\n  };\n});\n\nfunction forEachArray(array, iterator) {\n  for (var i = 0; i < array.length; i++) {\n    iterator(array[i]);\n  }\n}\n\nfunction isEmpty(obj) {\n  for (var i in obj) {\n    if (obj.hasOwnProperty(i)) return false;\n  }\n\n  return true;\n}\n\nfunction initParams(uri, options, callback) {\n  var params = uri;\n\n  if (isFunction(options)) {\n    callback = options;\n\n    if (typeof uri === "string") {\n      params = {\n        uri: uri\n      };\n    }\n  } else {\n    params = _extends({}, options, {\n      uri: uri\n    });\n  }\n\n  params.callback = callback;\n  return params;\n}\n\nfunction createXHR(uri, options, callback) {\n  options = initParams(uri, options, callback);\n  return _createXHR(options);\n}\n\nfunction _createXHR(options) {\n  if (typeof options.callback === "undefined") {\n    throw new Error("callback argument missing");\n  }\n\n  var called = false;\n\n  var callback = function cbOnce(err, response, body) {\n    if (!called) {\n      called = true;\n      options.callback(err, response, body);\n    }\n  };\n\n  function readystatechange() {\n    if (xhr.readyState === 4) {\n      setTimeout(loadFunc, 0);\n    }\n  }\n\n  function getBody() {\n    // Chrome with requestType=blob throws errors arround when even testing access to responseText\n    var body = undefined;\n\n    if (xhr.response) {\n      body = xhr.response;\n    } else {\n      body = xhr.responseText || getXml(xhr);\n    }\n\n    if (isJson) {\n      try {\n        body = JSON.parse(body);\n      } catch (e) {}\n    }\n\n    return body;\n  }\n\n  function errorFunc(evt) {\n    clearTimeout(timeoutTimer);\n\n    if (!(evt instanceof Error)) {\n      evt = new Error("" + (evt || "Unknown XMLHttpRequest Error"));\n    }\n\n    evt.statusCode = 0;\n    return callback(evt, failureResponse);\n  } // will load the data & process the response in a special response object\n\n\n  function loadFunc() {\n    if (aborted) return;\n    var status;\n    clearTimeout(timeoutTimer);\n\n    if (options.useXDR && xhr.status === undefined) {\n      //IE8 CORS GET successful response doesn\'t have a status field, but body is fine\n      status = 200;\n    } else {\n      status = xhr.status === 1223 ? 204 : xhr.status;\n    }\n\n    var response = failureResponse;\n    var err = null;\n\n    if (status !== 0) {\n      response = {\n        body: getBody(),\n        statusCode: status,\n        method: method,\n        headers: {},\n        url: uri,\n        rawRequest: xhr\n      };\n\n      if (xhr.getAllResponseHeaders) {\n        //remember xhr can in fact be XDR for CORS in IE\n        response.headers = parseHeaders(xhr.getAllResponseHeaders());\n      }\n    } else {\n      err = new Error("Internal XMLHttpRequest Error");\n    }\n\n    return callback(err, response, response.body);\n  }\n\n  var xhr = options.xhr || null;\n\n  if (!xhr) {\n    if (options.cors || options.useXDR) {\n      xhr = new createXHR.XDomainRequest();\n    } else {\n      xhr = new createXHR.XMLHttpRequest();\n    }\n  }\n\n  var key;\n  var aborted;\n  var uri = xhr.url = options.uri || options.url;\n  var method = xhr.method = options.method || "GET";\n  var body = options.body || options.data;\n  var headers = xhr.headers = options.headers || {};\n  var sync = !!options.sync;\n  var isJson = false;\n  var timeoutTimer;\n  var failureResponse = {\n    body: undefined,\n    headers: {},\n    statusCode: 0,\n    method: method,\n    url: uri,\n    rawRequest: xhr\n  };\n\n  if ("json" in options && options.json !== false) {\n    isJson = true;\n    headers["accept"] || headers["Accept"] || (headers["Accept"] = "application/json"); //Don\'t override existing accept header declared by user\n\n    if (method !== "GET" && method !== "HEAD") {\n      headers["content-type"] || headers["Content-Type"] || (headers["Content-Type"] = "application/json"); //Don\'t override existing accept header declared by user\n\n      body = JSON.stringify(options.json === true ? body : options.json);\n    }\n  }\n\n  xhr.onreadystatechange = readystatechange;\n  xhr.onload = loadFunc;\n  xhr.onerror = errorFunc; // IE9 must have onprogress be set to a unique function.\n\n  xhr.onprogress = function () {// IE must die\n  };\n\n  xhr.onabort = function () {\n    aborted = true;\n  };\n\n  xhr.ontimeout = errorFunc;\n  xhr.open(method, uri, !sync, options.username, options.password); //has to be after open\n\n  if (!sync) {\n    xhr.withCredentials = !!options.withCredentials;\n  } // Cannot set timeout with sync request\n  // not setting timeout on the xhr object, because of old webkits etc. not handling that correctly\n  // both npm\'s request and jquery 1.x use this kind of timeout, so this is being consistent\n\n\n  if (!sync && options.timeout > 0) {\n    timeoutTimer = setTimeout(function () {\n      if (aborted) return;\n      aborted = true; //IE9 may still call readystatechange\n\n      xhr.abort("timeout");\n      var e = new Error("XMLHttpRequest timeout");\n      e.code = "ETIMEDOUT";\n      errorFunc(e);\n    }, options.timeout);\n  }\n\n  if (xhr.setRequestHeader) {\n    for (key in headers) {\n      if (headers.hasOwnProperty(key)) {\n        xhr.setRequestHeader(key, headers[key]);\n      }\n    }\n  } else if (options.headers && !isEmpty(options.headers)) {\n    throw new Error("Headers cannot be set on an XDomainRequest object");\n  }\n\n  if ("responseType" in options) {\n    xhr.responseType = options.responseType;\n  }\n\n  if ("beforeSend" in options && typeof options.beforeSend === "function") {\n    options.beforeSend(xhr);\n  } // Microsoft Edge browser sends "undefined" when send is called with undefined value.\n  // XMLHttpRequest spec says to pass null as body to indicate no body\n  // See https://github.com/naugtur/xhr/issues/100.\n\n\n  xhr.send(body || null);\n  return xhr;\n}\n\nfunction getXml(xhr) {\n  // xhr.responseXML will throw Exception "InvalidStateError" or "DOMException"\n  // See https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/responseXML.\n  try {\n    if (xhr.responseType === "document") {\n      return xhr.responseXML;\n    }\n\n    var firefoxBugTakenEffect = xhr.responseXML && xhr.responseXML.documentElement.nodeName === "parsererror";\n\n    if (xhr.responseType === "" && !firefoxBugTakenEffect) {\n      return xhr.responseXML;\n    }\n  } catch (e) {}\n\n  return null;\n}\n\nfunction noop() {}\n\n//# sourceURL=webpack://web/./node_modules/@videojs/xhr/lib/index.js?')},"./node_modules/@xmldom/xmldom/lib/conventions.js":(__unused_webpack_module,exports)=>{"use strict";eval("\n\n/**\n * Ponyfill for `Array.prototype.find` which is only available in ES6 runtimes.\n *\n * Works with anything that has a `length` property and index access properties, including NodeList.\n *\n * @template {unknown} T\n * @param {Array<T> | ({length:number, [number]: T})} list\n * @param {function (item: T, index: number, list:Array<T> | ({length:number, [number]: T})):boolean} predicate\n * @param {Partial<Pick<ArrayConstructor['prototype'], 'find'>>?} ac `Array.prototype` by default,\n * \t\t\t\tallows injecting a custom implementation in tests\n * @returns {T | undefined}\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/find\n * @see https://tc39.es/ecma262/multipage/indexed-collections.html#sec-array.prototype.find\n */\nfunction find(list, predicate, ac) {\n\tif (ac === undefined) {\n\t\tac = Array.prototype;\n\t}\n\tif (list && typeof ac.find === 'function') {\n\t\treturn ac.find.call(list, predicate);\n\t}\n\tfor (var i = 0; i < list.length; i++) {\n\t\tif (Object.prototype.hasOwnProperty.call(list, i)) {\n\t\t\tvar item = list[i];\n\t\t\tif (predicate.call(undefined, item, i, list)) {\n\t\t\t\treturn item;\n\t\t\t}\n\t\t}\n\t}\n}\n\n/**\n * \"Shallow freezes\" an object to render it immutable.\n * Uses `Object.freeze` if available,\n * otherwise the immutability is only in the type.\n *\n * Is used to create \"enum like\" objects.\n *\n * @template T\n * @param {T} object the object to freeze\n * @param {Pick<ObjectConstructor, 'freeze'> = Object} oc `Object` by default,\n * \t\t\t\tallows to inject custom object constructor for tests\n * @returns {Readonly<T>}\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/freeze\n */\nfunction freeze(object, oc) {\n\tif (oc === undefined) {\n\t\toc = Object\n\t}\n\treturn oc && typeof oc.freeze === 'function' ? oc.freeze(object) : object\n}\n\n/**\n * Since we can not rely on `Object.assign` we provide a simplified version\n * that is sufficient for our needs.\n *\n * @param {Object} target\n * @param {Object | null | undefined} source\n *\n * @returns {Object} target\n * @throws TypeError if target is not an object\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign\n * @see https://tc39.es/ecma262/multipage/fundamental-objects.html#sec-object.assign\n */\nfunction assign(target, source) {\n\tif (target === null || typeof target !== 'object') {\n\t\tthrow new TypeError('target is not an object')\n\t}\n\tfor (var key in source) {\n\t\tif (Object.prototype.hasOwnProperty.call(source, key)) {\n\t\t\ttarget[key] = source[key]\n\t\t}\n\t}\n\treturn target\n}\n\n/**\n * All mime types that are allowed as input to `DOMParser.parseFromString`\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString#Argument02 MDN\n * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#domparsersupportedtype WHATWG HTML Spec\n * @see DOMParser.prototype.parseFromString\n */\nvar MIME_TYPE = freeze({\n\t/**\n\t * `text/html`, the only mime type that triggers treating an XML document as HTML.\n\t *\n\t * @see DOMParser.SupportedType.isHTML\n\t * @see https://www.iana.org/assignments/media-types/text/html IANA MimeType registration\n\t * @see https://en.wikipedia.org/wiki/HTML Wikipedia\n\t * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString MDN\n\t * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-domparser-parsefromstring WHATWG HTML Spec\n\t */\n\tHTML: 'text/html',\n\n\t/**\n\t * Helper method to check a mime type if it indicates an HTML document\n\t *\n\t * @param {string} [value]\n\t * @returns {boolean}\n\t *\n\t * @see https://www.iana.org/assignments/media-types/text/html IANA MimeType registration\n\t * @see https://en.wikipedia.org/wiki/HTML Wikipedia\n\t * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser/parseFromString MDN\n\t * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-domparser-parsefromstring \t */\n\tisHTML: function (value) {\n\t\treturn value === MIME_TYPE.HTML\n\t},\n\n\t/**\n\t * `application/xml`, the standard mime type for XML documents.\n\t *\n\t * @see https://www.iana.org/assignments/media-types/application/xml IANA MimeType registration\n\t * @see https://tools.ietf.org/html/rfc7303#section-9.1 RFC 7303\n\t * @see https://en.wikipedia.org/wiki/XML_and_MIME Wikipedia\n\t */\n\tXML_APPLICATION: 'application/xml',\n\n\t/**\n\t * `text/html`, an alias for `application/xml`.\n\t *\n\t * @see https://tools.ietf.org/html/rfc7303#section-9.2 RFC 7303\n\t * @see https://www.iana.org/assignments/media-types/text/xml IANA MimeType registration\n\t * @see https://en.wikipedia.org/wiki/XML_and_MIME Wikipedia\n\t */\n\tXML_TEXT: 'text/xml',\n\n\t/**\n\t * `application/xhtml+xml`, indicates an XML document that has the default HTML namespace,\n\t * but is parsed as an XML document.\n\t *\n\t * @see https://www.iana.org/assignments/media-types/application/xhtml+xml IANA MimeType registration\n\t * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocument WHATWG DOM Spec\n\t * @see https://en.wikipedia.org/wiki/XHTML Wikipedia\n\t */\n\tXML_XHTML_APPLICATION: 'application/xhtml+xml',\n\n\t/**\n\t * `image/svg+xml`,\n\t *\n\t * @see https://www.iana.org/assignments/media-types/image/svg+xml IANA MimeType registration\n\t * @see https://www.w3.org/TR/SVG11/ W3C SVG 1.1\n\t * @see https://en.wikipedia.org/wiki/Scalable_Vector_Graphics Wikipedia\n\t */\n\tXML_SVG_IMAGE: 'image/svg+xml',\n})\n\n/**\n * Namespaces that are used in this code base.\n *\n * @see http://www.w3.org/TR/REC-xml-names\n */\nvar NAMESPACE = freeze({\n\t/**\n\t * The XHTML namespace.\n\t *\n\t * @see http://www.w3.org/1999/xhtml\n\t */\n\tHTML: 'http://www.w3.org/1999/xhtml',\n\n\t/**\n\t * Checks if `uri` equals `NAMESPACE.HTML`.\n\t *\n\t * @param {string} [uri]\n\t *\n\t * @see NAMESPACE.HTML\n\t */\n\tisHTML: function (uri) {\n\t\treturn uri === NAMESPACE.HTML\n\t},\n\n\t/**\n\t * The SVG namespace.\n\t *\n\t * @see http://www.w3.org/2000/svg\n\t */\n\tSVG: 'http://www.w3.org/2000/svg',\n\n\t/**\n\t * The `xml:` namespace.\n\t *\n\t * @see http://www.w3.org/XML/1998/namespace\n\t */\n\tXML: 'http://www.w3.org/XML/1998/namespace',\n\n\t/**\n\t * The `xmlns:` namespace\n\t *\n\t * @see https://www.w3.org/2000/xmlns/\n\t */\n\tXMLNS: 'http://www.w3.org/2000/xmlns/',\n})\n\nexports.assign = assign;\nexports.find = find;\nexports.freeze = freeze;\nexports.MIME_TYPE = MIME_TYPE;\nexports.NAMESPACE = NAMESPACE;\n\n\n//# sourceURL=webpack://web/./node_modules/@xmldom/xmldom/lib/conventions.js?")},"./node_modules/@xmldom/xmldom/lib/dom-parser.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval("var conventions = __webpack_require__(/*! ./conventions */ \"./node_modules/@xmldom/xmldom/lib/conventions.js\");\nvar dom = __webpack_require__(/*! ./dom */ \"./node_modules/@xmldom/xmldom/lib/dom.js\")\nvar entities = __webpack_require__(/*! ./entities */ \"./node_modules/@xmldom/xmldom/lib/entities.js\");\nvar sax = __webpack_require__(/*! ./sax */ \"./node_modules/@xmldom/xmldom/lib/sax.js\");\n\nvar DOMImplementation = dom.DOMImplementation;\n\nvar NAMESPACE = conventions.NAMESPACE;\n\nvar ParseError = sax.ParseError;\nvar XMLReader = sax.XMLReader;\n\n/**\n * Normalizes line ending according to https://www.w3.org/TR/xml11/#sec-line-ends:\n *\n * > XML parsed entities are often stored in computer files which,\n * > for editing convenience, are organized into lines.\n * > These lines are typically separated by some combination\n * > of the characters CARRIAGE RETURN (#xD) and LINE FEED (#xA).\n * >\n * > To simplify the tasks of applications, the XML processor must behave\n * > as if it normalized all line breaks in external parsed entities (including the document entity)\n * > on input, before parsing, by translating all of the following to a single #xA character:\n * >\n * > 1. the two-character sequence #xD #xA\n * > 2. the two-character sequence #xD #x85\n * > 3. the single character #x85\n * > 4. the single character #x2028\n * > 5. any #xD character that is not immediately followed by #xA or #x85.\n *\n * @param {string} input\n * @returns {string}\n */\nfunction normalizeLineEndings(input) {\n\treturn input\n\t\t.replace(/\\r[\\n\\u0085]/g, '\\n')\n\t\t.replace(/[\\r\\u0085\\u2028]/g, '\\n')\n}\n\n/**\n * @typedef Locator\n * @property {number} [columnNumber]\n * @property {number} [lineNumber]\n */\n\n/**\n * @typedef DOMParserOptions\n * @property {DOMHandler} [domBuilder]\n * @property {Function} [errorHandler]\n * @property {(string) => string} [normalizeLineEndings] used to replace line endings before parsing\n * \t\t\t\t\t\tdefaults to `normalizeLineEndings`\n * @property {Locator} [locator]\n * @property {Record<string, string>} [xmlns]\n *\n * @see normalizeLineEndings\n */\n\n/**\n * The DOMParser interface provides the ability to parse XML or HTML source code\n * from a string into a DOM `Document`.\n *\n * _xmldom is different from the spec in that it allows an `options` parameter,\n * to override the default behavior._\n *\n * @param {DOMParserOptions} [options]\n * @constructor\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMParser\n * @see https://html.spec.whatwg.org/multipage/dynamic-markup-insertion.html#dom-parsing-and-serialization\n */\nfunction DOMParser(options){\n\tthis.options = options ||{locator:{}};\n}\n\nDOMParser.prototype.parseFromString = function(source,mimeType){\n\tvar options = this.options;\n\tvar sax =  new XMLReader();\n\tvar domBuilder = options.domBuilder || new DOMHandler();//contentHandler and LexicalHandler\n\tvar errorHandler = options.errorHandler;\n\tvar locator = options.locator;\n\tvar defaultNSMap = options.xmlns||{};\n\tvar isHTML = /\\/x?html?$/.test(mimeType);//mimeType.toLowerCase().indexOf('html') > -1;\n  \tvar entityMap = isHTML ? entities.HTML_ENTITIES : entities.XML_ENTITIES;\n\tif(locator){\n\t\tdomBuilder.setDocumentLocator(locator)\n\t}\n\n\tsax.errorHandler = buildErrorHandler(errorHandler,domBuilder,locator);\n\tsax.domBuilder = options.domBuilder || domBuilder;\n\tif(isHTML){\n\t\tdefaultNSMap[''] = NAMESPACE.HTML;\n\t}\n\tdefaultNSMap.xml = defaultNSMap.xml || NAMESPACE.XML;\n\tvar normalize = options.normalizeLineEndings || normalizeLineEndings;\n\tif (source && typeof source === 'string') {\n\t\tsax.parse(\n\t\t\tnormalize(source),\n\t\t\tdefaultNSMap,\n\t\t\tentityMap\n\t\t)\n\t} else {\n\t\tsax.errorHandler.error('invalid doc source')\n\t}\n\treturn domBuilder.doc;\n}\nfunction buildErrorHandler(errorImpl,domBuilder,locator){\n\tif(!errorImpl){\n\t\tif(domBuilder instanceof DOMHandler){\n\t\t\treturn domBuilder;\n\t\t}\n\t\terrorImpl = domBuilder ;\n\t}\n\tvar errorHandler = {}\n\tvar isCallback = errorImpl instanceof Function;\n\tlocator = locator||{}\n\tfunction build(key){\n\t\tvar fn = errorImpl[key];\n\t\tif(!fn && isCallback){\n\t\t\tfn = errorImpl.length == 2?function(msg){errorImpl(key,msg)}:errorImpl;\n\t\t}\n\t\terrorHandler[key] = fn && function(msg){\n\t\t\tfn('[xmldom '+key+']\\t'+msg+_locator(locator));\n\t\t}||function(){};\n\t}\n\tbuild('warning');\n\tbuild('error');\n\tbuild('fatalError');\n\treturn errorHandler;\n}\n\n//console.log('#\\n\\n\\n\\n\\n\\n\\n####')\n/**\n * +ContentHandler+ErrorHandler\n * +LexicalHandler+EntityResolver2\n * -DeclHandler-DTDHandler\n *\n * DefaultHandler:EntityResolver, DTDHandler, ContentHandler, ErrorHandler\n * DefaultHandler2:DefaultHandler,LexicalHandler, DeclHandler, EntityResolver2\n * @link http://www.saxproject.org/apidoc/org/xml/sax/helpers/DefaultHandler.html\n */\nfunction DOMHandler() {\n    this.cdata = false;\n}\nfunction position(locator,node){\n\tnode.lineNumber = locator.lineNumber;\n\tnode.columnNumber = locator.columnNumber;\n}\n/**\n * @see org.xml.sax.ContentHandler#startDocument\n * @link http://www.saxproject.org/apidoc/org/xml/sax/ContentHandler.html\n */\nDOMHandler.prototype = {\n\tstartDocument : function() {\n    \tthis.doc = new DOMImplementation().createDocument(null, null, null);\n    \tif (this.locator) {\n        \tthis.doc.documentURI = this.locator.systemId;\n    \t}\n\t},\n\tstartElement:function(namespaceURI, localName, qName, attrs) {\n\t\tvar doc = this.doc;\n\t    var el = doc.createElementNS(namespaceURI, qName||localName);\n\t    var len = attrs.length;\n\t    appendElement(this, el);\n\t    this.currentElement = el;\n\n\t\tthis.locator && position(this.locator,el)\n\t    for (var i = 0 ; i < len; i++) {\n\t        var namespaceURI = attrs.getURI(i);\n\t        var value = attrs.getValue(i);\n\t        var qName = attrs.getQName(i);\n\t\t\tvar attr = doc.createAttributeNS(namespaceURI, qName);\n\t\t\tthis.locator &&position(attrs.getLocator(i),attr);\n\t\t\tattr.value = attr.nodeValue = value;\n\t\t\tel.setAttributeNode(attr)\n\t    }\n\t},\n\tendElement:function(namespaceURI, localName, qName) {\n\t\tvar current = this.currentElement\n\t\tvar tagName = current.tagName;\n\t\tthis.currentElement = current.parentNode;\n\t},\n\tstartPrefixMapping:function(prefix, uri) {\n\t},\n\tendPrefixMapping:function(prefix) {\n\t},\n\tprocessingInstruction:function(target, data) {\n\t    var ins = this.doc.createProcessingInstruction(target, data);\n\t    this.locator && position(this.locator,ins)\n\t    appendElement(this, ins);\n\t},\n\tignorableWhitespace:function(ch, start, length) {\n\t},\n\tcharacters:function(chars, start, length) {\n\t\tchars = _toString.apply(this,arguments)\n\t\t//console.log(chars)\n\t\tif(chars){\n\t\t\tif (this.cdata) {\n\t\t\t\tvar charNode = this.doc.createCDATASection(chars);\n\t\t\t} else {\n\t\t\t\tvar charNode = this.doc.createTextNode(chars);\n\t\t\t}\n\t\t\tif(this.currentElement){\n\t\t\t\tthis.currentElement.appendChild(charNode);\n\t\t\t}else if(/^\\s*$/.test(chars)){\n\t\t\t\tthis.doc.appendChild(charNode);\n\t\t\t\t//process xml\n\t\t\t}\n\t\t\tthis.locator && position(this.locator,charNode)\n\t\t}\n\t},\n\tskippedEntity:function(name) {\n\t},\n\tendDocument:function() {\n\t\tthis.doc.normalize();\n\t},\n\tsetDocumentLocator:function (locator) {\n\t    if(this.locator = locator){// && !('lineNumber' in locator)){\n\t    \tlocator.lineNumber = 0;\n\t    }\n\t},\n\t//LexicalHandler\n\tcomment:function(chars, start, length) {\n\t\tchars = _toString.apply(this,arguments)\n\t    var comm = this.doc.createComment(chars);\n\t    this.locator && position(this.locator,comm)\n\t    appendElement(this, comm);\n\t},\n\n\tstartCDATA:function() {\n\t    //used in characters() methods\n\t    this.cdata = true;\n\t},\n\tendCDATA:function() {\n\t    this.cdata = false;\n\t},\n\n\tstartDTD:function(name, publicId, systemId) {\n\t\tvar impl = this.doc.implementation;\n\t    if (impl && impl.createDocumentType) {\n\t        var dt = impl.createDocumentType(name, publicId, systemId);\n\t        this.locator && position(this.locator,dt)\n\t        appendElement(this, dt);\n\t\t\t\t\tthis.doc.doctype = dt;\n\t    }\n\t},\n\t/**\n\t * @see org.xml.sax.ErrorHandler\n\t * @link http://www.saxproject.org/apidoc/org/xml/sax/ErrorHandler.html\n\t */\n\twarning:function(error) {\n\t\tconsole.warn('[xmldom warning]\\t'+error,_locator(this.locator));\n\t},\n\terror:function(error) {\n\t\tconsole.error('[xmldom error]\\t'+error,_locator(this.locator));\n\t},\n\tfatalError:function(error) {\n\t\tthrow new ParseError(error, this.locator);\n\t}\n}\nfunction _locator(l){\n\tif(l){\n\t\treturn '\\n@'+(l.systemId ||'')+'#[line:'+l.lineNumber+',col:'+l.columnNumber+']'\n\t}\n}\nfunction _toString(chars,start,length){\n\tif(typeof chars == 'string'){\n\t\treturn chars.substr(start,length)\n\t}else{//java sax connect width xmldom on rhino(what about: \"? && !(chars instanceof String)\")\n\t\tif(chars.length >= start+length || start){\n\t\t\treturn new java.lang.String(chars,start,length)+'';\n\t\t}\n\t\treturn chars;\n\t}\n}\n\n/*\n * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/LexicalHandler.html\n * used method of org.xml.sax.ext.LexicalHandler:\n *  #comment(chars, start, length)\n *  #startCDATA()\n *  #endCDATA()\n *  #startDTD(name, publicId, systemId)\n *\n *\n * IGNORED method of org.xml.sax.ext.LexicalHandler:\n *  #endDTD()\n *  #startEntity(name)\n *  #endEntity(name)\n *\n *\n * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/DeclHandler.html\n * IGNORED method of org.xml.sax.ext.DeclHandler\n * \t#attributeDecl(eName, aName, type, mode, value)\n *  #elementDecl(name, model)\n *  #externalEntityDecl(name, publicId, systemId)\n *  #internalEntityDecl(name, value)\n * @link http://www.saxproject.org/apidoc/org/xml/sax/ext/EntityResolver2.html\n * IGNORED method of org.xml.sax.EntityResolver2\n *  #resolveEntity(String name,String publicId,String baseURI,String systemId)\n *  #resolveEntity(publicId, systemId)\n *  #getExternalSubset(name, baseURI)\n * @link http://www.saxproject.org/apidoc/org/xml/sax/DTDHandler.html\n * IGNORED method of org.xml.sax.DTDHandler\n *  #notationDecl(name, publicId, systemId) {};\n *  #unparsedEntityDecl(name, publicId, systemId, notationName) {};\n */\n\"endDTD,startEntity,endEntity,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,resolveEntity,getExternalSubset,notationDecl,unparsedEntityDecl\".replace(/\\w+/g,function(key){\n\tDOMHandler.prototype[key] = function(){return null}\n})\n\n/* Private static helpers treated below as private instance methods, so don't need to add these to the public API; we might use a Relator to also get rid of non-standard public properties */\nfunction appendElement (hander,node) {\n    if (!hander.currentElement) {\n        hander.doc.appendChild(node);\n    } else {\n        hander.currentElement.appendChild(node);\n    }\n}//appendChild and setAttributeNS are preformance key\n\nexports.__DOMHandler = DOMHandler;\nexports.normalizeLineEndings = normalizeLineEndings;\nexports.DOMParser = DOMParser;\n\n\n//# sourceURL=webpack://web/./node_modules/@xmldom/xmldom/lib/dom-parser.js?")},"./node_modules/@xmldom/xmldom/lib/dom.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval("var conventions = __webpack_require__(/*! ./conventions */ \"./node_modules/@xmldom/xmldom/lib/conventions.js\");\n\nvar find = conventions.find;\nvar NAMESPACE = conventions.NAMESPACE;\n\n/**\n * A prerequisite for `[].filter`, to drop elements that are empty\n * @param {string} input\n * @returns {boolean}\n */\nfunction notEmptyString (input) {\n\treturn input !== ''\n}\n/**\n * @see https://infra.spec.whatwg.org/#split-on-ascii-whitespace\n * @see https://infra.spec.whatwg.org/#ascii-whitespace\n *\n * @param {string} input\n * @returns {string[]} (can be empty)\n */\nfunction splitOnASCIIWhitespace(input) {\n\t// U+0009 TAB, U+000A LF, U+000C FF, U+000D CR, U+0020 SPACE\n\treturn input ? input.split(/[\\t\\n\\f\\r ]+/).filter(notEmptyString) : []\n}\n\n/**\n * Adds element as a key to current if it is not already present.\n *\n * @param {Record<string, boolean | undefined>} current\n * @param {string} element\n * @returns {Record<string, boolean | undefined>}\n */\nfunction orderedSetReducer (current, element) {\n\tif (!current.hasOwnProperty(element)) {\n\t\tcurrent[element] = true;\n\t}\n\treturn current;\n}\n\n/**\n * @see https://infra.spec.whatwg.org/#ordered-set\n * @param {string} input\n * @returns {string[]}\n */\nfunction toOrderedSet(input) {\n\tif (!input) return [];\n\tvar list = splitOnASCIIWhitespace(input);\n\treturn Object.keys(list.reduce(orderedSetReducer, {}))\n}\n\n/**\n * Uses `list.indexOf` to implement something like `Array.prototype.includes`,\n * which we can not rely on being available.\n *\n * @param {any[]} list\n * @returns {function(any): boolean}\n */\nfunction arrayIncludes (list) {\n\treturn function(element) {\n\t\treturn list && list.indexOf(element) !== -1;\n\t}\n}\n\nfunction copy(src,dest){\n\tfor(var p in src){\n\t\tif (Object.prototype.hasOwnProperty.call(src, p)) {\n\t\t\tdest[p] = src[p];\n\t\t}\n\t}\n}\n\n/**\n^\\w+\\.prototype\\.([_\\w]+)\\s*=\\s*((?:.*\\{\\s*?[\\r\\n][\\s\\S]*?^})|\\S.*?(?=[;\\r\\n]));?\n^\\w+\\.prototype\\.([_\\w]+)\\s*=\\s*(\\S.*?(?=[;\\r\\n]));?\n */\nfunction _extends(Class,Super){\n\tvar pt = Class.prototype;\n\tif(!(pt instanceof Super)){\n\t\tfunction t(){};\n\t\tt.prototype = Super.prototype;\n\t\tt = new t();\n\t\tcopy(pt,t);\n\t\tClass.prototype = pt = t;\n\t}\n\tif(pt.constructor != Class){\n\t\tif(typeof Class != 'function'){\n\t\t\tconsole.error(\"unknown Class:\"+Class)\n\t\t}\n\t\tpt.constructor = Class\n\t}\n}\n\n// Node Types\nvar NodeType = {}\nvar ELEMENT_NODE                = NodeType.ELEMENT_NODE                = 1;\nvar ATTRIBUTE_NODE              = NodeType.ATTRIBUTE_NODE              = 2;\nvar TEXT_NODE                   = NodeType.TEXT_NODE                   = 3;\nvar CDATA_SECTION_NODE          = NodeType.CDATA_SECTION_NODE          = 4;\nvar ENTITY_REFERENCE_NODE       = NodeType.ENTITY_REFERENCE_NODE       = 5;\nvar ENTITY_NODE                 = NodeType.ENTITY_NODE                 = 6;\nvar PROCESSING_INSTRUCTION_NODE = NodeType.PROCESSING_INSTRUCTION_NODE = 7;\nvar COMMENT_NODE                = NodeType.COMMENT_NODE                = 8;\nvar DOCUMENT_NODE               = NodeType.DOCUMENT_NODE               = 9;\nvar DOCUMENT_TYPE_NODE          = NodeType.DOCUMENT_TYPE_NODE          = 10;\nvar DOCUMENT_FRAGMENT_NODE      = NodeType.DOCUMENT_FRAGMENT_NODE      = 11;\nvar NOTATION_NODE               = NodeType.NOTATION_NODE               = 12;\n\n// ExceptionCode\nvar ExceptionCode = {}\nvar ExceptionMessage = {};\nvar INDEX_SIZE_ERR              = ExceptionCode.INDEX_SIZE_ERR              = ((ExceptionMessage[1]=\"Index size error\"),1);\nvar DOMSTRING_SIZE_ERR          = ExceptionCode.DOMSTRING_SIZE_ERR          = ((ExceptionMessage[2]=\"DOMString size error\"),2);\nvar HIERARCHY_REQUEST_ERR       = ExceptionCode.HIERARCHY_REQUEST_ERR       = ((ExceptionMessage[3]=\"Hierarchy request error\"),3);\nvar WRONG_DOCUMENT_ERR          = ExceptionCode.WRONG_DOCUMENT_ERR          = ((ExceptionMessage[4]=\"Wrong document\"),4);\nvar INVALID_CHARACTER_ERR       = ExceptionCode.INVALID_CHARACTER_ERR       = ((ExceptionMessage[5]=\"Invalid character\"),5);\nvar NO_DATA_ALLOWED_ERR         = ExceptionCode.NO_DATA_ALLOWED_ERR         = ((ExceptionMessage[6]=\"No data allowed\"),6);\nvar NO_MODIFICATION_ALLOWED_ERR = ExceptionCode.NO_MODIFICATION_ALLOWED_ERR = ((ExceptionMessage[7]=\"No modification allowed\"),7);\nvar NOT_FOUND_ERR               = ExceptionCode.NOT_FOUND_ERR               = ((ExceptionMessage[8]=\"Not found\"),8);\nvar NOT_SUPPORTED_ERR           = ExceptionCode.NOT_SUPPORTED_ERR           = ((ExceptionMessage[9]=\"Not supported\"),9);\nvar INUSE_ATTRIBUTE_ERR         = ExceptionCode.INUSE_ATTRIBUTE_ERR         = ((ExceptionMessage[10]=\"Attribute in use\"),10);\n//level2\nvar INVALID_STATE_ERR        \t= ExceptionCode.INVALID_STATE_ERR        \t= ((ExceptionMessage[11]=\"Invalid state\"),11);\nvar SYNTAX_ERR               \t= ExceptionCode.SYNTAX_ERR               \t= ((ExceptionMessage[12]=\"Syntax error\"),12);\nvar INVALID_MODIFICATION_ERR \t= ExceptionCode.INVALID_MODIFICATION_ERR \t= ((ExceptionMessage[13]=\"Invalid modification\"),13);\nvar NAMESPACE_ERR            \t= ExceptionCode.NAMESPACE_ERR           \t= ((ExceptionMessage[14]=\"Invalid namespace\"),14);\nvar INVALID_ACCESS_ERR       \t= ExceptionCode.INVALID_ACCESS_ERR      \t= ((ExceptionMessage[15]=\"Invalid access\"),15);\n\n/**\n * DOM Level 2\n * Object DOMException\n * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/ecma-script-binding.html\n * @see http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html\n */\nfunction DOMException(code, message) {\n\tif(message instanceof Error){\n\t\tvar error = message;\n\t}else{\n\t\terror = this;\n\t\tError.call(this, ExceptionMessage[code]);\n\t\tthis.message = ExceptionMessage[code];\n\t\tif(Error.captureStackTrace) Error.captureStackTrace(this, DOMException);\n\t}\n\terror.code = code;\n\tif(message) this.message = this.message + \": \" + message;\n\treturn error;\n};\nDOMException.prototype = Error.prototype;\ncopy(ExceptionCode,DOMException)\n\n/**\n * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-536297177\n * The NodeList interface provides the abstraction of an ordered collection of nodes, without defining or constraining how this collection is implemented. NodeList objects in the DOM are live.\n * The items in the NodeList are accessible via an integral index, starting from 0.\n */\nfunction NodeList() {\n};\nNodeList.prototype = {\n\t/**\n\t * The number of nodes in the list. The range of valid child node indices is 0 to length-1 inclusive.\n\t * @standard level1\n\t */\n\tlength:0,\n\t/**\n\t * Returns the indexth item in the collection. If index is greater than or equal to the number of nodes in the list, this returns null.\n\t * @standard level1\n\t * @param index  unsigned long\n\t *   Index into the collection.\n\t * @return Node\n\t * \tThe node at the indexth position in the NodeList, or null if that is not a valid index.\n\t */\n\titem: function(index) {\n\t\treturn index >= 0 && index < this.length ? this[index] : null;\n\t},\n\ttoString:function(isHTML,nodeFilter){\n\t\tfor(var buf = [], i = 0;i<this.length;i++){\n\t\t\tserializeToString(this[i],buf,isHTML,nodeFilter);\n\t\t}\n\t\treturn buf.join('');\n\t},\n\t/**\n\t * @private\n\t * @param {function (Node):boolean} predicate\n\t * @returns {Node[]}\n\t */\n\tfilter: function (predicate) {\n\t\treturn Array.prototype.filter.call(this, predicate);\n\t},\n\t/**\n\t * @private\n\t * @param {Node} item\n\t * @returns {number}\n\t */\n\tindexOf: function (item) {\n\t\treturn Array.prototype.indexOf.call(this, item);\n\t},\n};\n\nfunction LiveNodeList(node,refresh){\n\tthis._node = node;\n\tthis._refresh = refresh\n\t_updateLiveList(this);\n}\nfunction _updateLiveList(list){\n\tvar inc = list._node._inc || list._node.ownerDocument._inc;\n\tif (list._inc !== inc) {\n\t\tvar ls = list._refresh(list._node);\n\t\t__set__(list,'length',ls.length);\n\t\tif (!list.$$length || ls.length < list.$$length) {\n\t\t\tfor (var i = ls.length; i in list; i++) {\n\t\t\t\tif (Object.prototype.hasOwnProperty.call(list, i)) {\n\t\t\t\t\tdelete list[i];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tcopy(ls,list);\n\t\tlist._inc = inc;\n\t}\n}\nLiveNodeList.prototype.item = function(i){\n\t_updateLiveList(this);\n\treturn this[i] || null;\n}\n\n_extends(LiveNodeList,NodeList);\n\n/**\n * Objects implementing the NamedNodeMap interface are used\n * to represent collections of nodes that can be accessed by name.\n * Note that NamedNodeMap does not inherit from NodeList;\n * NamedNodeMaps are not maintained in any particular order.\n * Objects contained in an object implementing NamedNodeMap may also be accessed by an ordinal index,\n * but this is simply to allow convenient enumeration of the contents of a NamedNodeMap,\n * and does not imply that the DOM specifies an order to these Nodes.\n * NamedNodeMap objects in the DOM are live.\n * used for attributes or DocumentType entities\n */\nfunction NamedNodeMap() {\n};\n\nfunction _findNodeIndex(list,node){\n\tvar i = list.length;\n\twhile(i--){\n\t\tif(list[i] === node){return i}\n\t}\n}\n\nfunction _addNamedNode(el,list,newAttr,oldAttr){\n\tif(oldAttr){\n\t\tlist[_findNodeIndex(list,oldAttr)] = newAttr;\n\t}else{\n\t\tlist[list.length++] = newAttr;\n\t}\n\tif(el){\n\t\tnewAttr.ownerElement = el;\n\t\tvar doc = el.ownerDocument;\n\t\tif(doc){\n\t\t\toldAttr && _onRemoveAttribute(doc,el,oldAttr);\n\t\t\t_onAddAttribute(doc,el,newAttr);\n\t\t}\n\t}\n}\nfunction _removeNamedNode(el,list,attr){\n\t//console.log('remove attr:'+attr)\n\tvar i = _findNodeIndex(list,attr);\n\tif(i>=0){\n\t\tvar lastIndex = list.length-1\n\t\twhile(i<lastIndex){\n\t\t\tlist[i] = list[++i]\n\t\t}\n\t\tlist.length = lastIndex;\n\t\tif(el){\n\t\t\tvar doc = el.ownerDocument;\n\t\t\tif(doc){\n\t\t\t\t_onRemoveAttribute(doc,el,attr);\n\t\t\t\tattr.ownerElement = null;\n\t\t\t}\n\t\t}\n\t}else{\n\t\tthrow new DOMException(NOT_FOUND_ERR,new Error(el.tagName+'@'+attr))\n\t}\n}\nNamedNodeMap.prototype = {\n\tlength:0,\n\titem:NodeList.prototype.item,\n\tgetNamedItem: function(key) {\n//\t\tif(key.indexOf(':')>0 || key == 'xmlns'){\n//\t\t\treturn null;\n//\t\t}\n\t\t//console.log()\n\t\tvar i = this.length;\n\t\twhile(i--){\n\t\t\tvar attr = this[i];\n\t\t\t//console.log(attr.nodeName,key)\n\t\t\tif(attr.nodeName == key){\n\t\t\t\treturn attr;\n\t\t\t}\n\t\t}\n\t},\n\tsetNamedItem: function(attr) {\n\t\tvar el = attr.ownerElement;\n\t\tif(el && el!=this._ownerElement){\n\t\t\tthrow new DOMException(INUSE_ATTRIBUTE_ERR);\n\t\t}\n\t\tvar oldAttr = this.getNamedItem(attr.nodeName);\n\t\t_addNamedNode(this._ownerElement,this,attr,oldAttr);\n\t\treturn oldAttr;\n\t},\n\t/* returns Node */\n\tsetNamedItemNS: function(attr) {// raises: WRONG_DOCUMENT_ERR,NO_MODIFICATION_ALLOWED_ERR,INUSE_ATTRIBUTE_ERR\n\t\tvar el = attr.ownerElement, oldAttr;\n\t\tif(el && el!=this._ownerElement){\n\t\t\tthrow new DOMException(INUSE_ATTRIBUTE_ERR);\n\t\t}\n\t\toldAttr = this.getNamedItemNS(attr.namespaceURI,attr.localName);\n\t\t_addNamedNode(this._ownerElement,this,attr,oldAttr);\n\t\treturn oldAttr;\n\t},\n\n\t/* returns Node */\n\tremoveNamedItem: function(key) {\n\t\tvar attr = this.getNamedItem(key);\n\t\t_removeNamedNode(this._ownerElement,this,attr);\n\t\treturn attr;\n\n\n\t},// raises: NOT_FOUND_ERR,NO_MODIFICATION_ALLOWED_ERR\n\n\t//for level2\n\tremoveNamedItemNS:function(namespaceURI,localName){\n\t\tvar attr = this.getNamedItemNS(namespaceURI,localName);\n\t\t_removeNamedNode(this._ownerElement,this,attr);\n\t\treturn attr;\n\t},\n\tgetNamedItemNS: function(namespaceURI, localName) {\n\t\tvar i = this.length;\n\t\twhile(i--){\n\t\t\tvar node = this[i];\n\t\t\tif(node.localName == localName && node.namespaceURI == namespaceURI){\n\t\t\t\treturn node;\n\t\t\t}\n\t\t}\n\t\treturn null;\n\t}\n};\n\n/**\n * The DOMImplementation interface represents an object providing methods\n * which are not dependent on any particular document.\n * Such an object is returned by the `Document.implementation` property.\n *\n * __The individual methods describe the differences compared to the specs.__\n *\n * @constructor\n *\n * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation MDN\n * @see https://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-102161490 DOM Level 1 Core (Initial)\n * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-102161490 DOM Level 2 Core\n * @see https://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-102161490 DOM Level 3 Core\n * @see https://dom.spec.whatwg.org/#domimplementation DOM Living Standard\n */\nfunction DOMImplementation() {\n}\n\nDOMImplementation.prototype = {\n\t/**\n\t * The DOMImplementation.hasFeature() method returns a Boolean flag indicating if a given feature is supported.\n\t * The different implementations fairly diverged in what kind of features were reported.\n\t * The latest version of the spec settled to force this method to always return true, where the functionality was accurate and in use.\n\t *\n\t * @deprecated It is deprecated and modern browsers return true in all cases.\n\t *\n\t * @param {string} feature\n\t * @param {string} [version]\n\t * @returns {boolean} always true\n\t *\n\t * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/hasFeature MDN\n\t * @see https://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-5CED94D7 DOM Level 1 Core\n\t * @see https://dom.spec.whatwg.org/#dom-domimplementation-hasfeature DOM Living Standard\n\t */\n\thasFeature: function(feature, version) {\n\t\t\treturn true;\n\t},\n\t/**\n\t * Creates an XML Document object of the specified type with its document element.\n\t *\n\t * __It behaves slightly different from the description in the living standard__:\n\t * - There is no interface/class `XMLDocument`, it returns a `Document` instance.\n\t * - `contentType`, `encoding`, `mode`, `origin`, `url` fields are currently not declared.\n\t * - this implementation is not validating names or qualified names\n\t *   (when parsing XML strings, the SAX parser takes care of that)\n\t *\n\t * @param {string|null} namespaceURI\n\t * @param {string} qualifiedName\n\t * @param {DocumentType=null} doctype\n\t * @returns {Document}\n\t *\n\t * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/createDocument MDN\n\t * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocument DOM Level 2 Core (initial)\n\t * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocument  DOM Level 2 Core\n\t *\n\t * @see https://dom.spec.whatwg.org/#validate-and-extract DOM: Validate and extract\n\t * @see https://www.w3.org/TR/xml/#NT-NameStartChar XML Spec: Names\n\t * @see https://www.w3.org/TR/xml-names/#ns-qualnames XML Namespaces: Qualified names\n\t */\n\tcreateDocument: function(namespaceURI,  qualifiedName, doctype){\n\t\tvar doc = new Document();\n\t\tdoc.implementation = this;\n\t\tdoc.childNodes = new NodeList();\n\t\tdoc.doctype = doctype || null;\n\t\tif (doctype){\n\t\t\tdoc.appendChild(doctype);\n\t\t}\n\t\tif (qualifiedName){\n\t\t\tvar root = doc.createElementNS(namespaceURI, qualifiedName);\n\t\t\tdoc.appendChild(root);\n\t\t}\n\t\treturn doc;\n\t},\n\t/**\n\t * Returns a doctype, with the given `qualifiedName`, `publicId`, and `systemId`.\n\t *\n\t * __This behavior is slightly different from the in the specs__:\n\t * - this implementation is not validating names or qualified names\n\t *   (when parsing XML strings, the SAX parser takes care of that)\n\t *\n\t * @param {string} qualifiedName\n\t * @param {string} [publicId]\n\t * @param {string} [systemId]\n\t * @returns {DocumentType} which can either be used with `DOMImplementation.createDocument` upon document creation\n\t * \t\t\t\t  or can be put into the document via methods like `Node.insertBefore()` or `Node.replaceChild()`\n\t *\n\t * @see https://developer.mozilla.org/en-US/docs/Web/API/DOMImplementation/createDocumentType MDN\n\t * @see https://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocType DOM Level 2 Core\n\t * @see https://dom.spec.whatwg.org/#dom-domimplementation-createdocumenttype DOM Living Standard\n\t *\n\t * @see https://dom.spec.whatwg.org/#validate-and-extract DOM: Validate and extract\n\t * @see https://www.w3.org/TR/xml/#NT-NameStartChar XML Spec: Names\n\t * @see https://www.w3.org/TR/xml-names/#ns-qualnames XML Namespaces: Qualified names\n\t */\n\tcreateDocumentType: function(qualifiedName, publicId, systemId){\n\t\tvar node = new DocumentType();\n\t\tnode.name = qualifiedName;\n\t\tnode.nodeName = qualifiedName;\n\t\tnode.publicId = publicId || '';\n\t\tnode.systemId = systemId || '';\n\n\t\treturn node;\n\t}\n};\n\n\n/**\n * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-1950641247\n */\n\nfunction Node() {\n};\n\nNode.prototype = {\n\tfirstChild : null,\n\tlastChild : null,\n\tpreviousSibling : null,\n\tnextSibling : null,\n\tattributes : null,\n\tparentNode : null,\n\tchildNodes : null,\n\townerDocument : null,\n\tnodeValue : null,\n\tnamespaceURI : null,\n\tprefix : null,\n\tlocalName : null,\n\t// Modified in DOM Level 2:\n\tinsertBefore:function(newChild, refChild){//raises\n\t\treturn _insertBefore(this,newChild,refChild);\n\t},\n\treplaceChild:function(newChild, oldChild){//raises\n\t\t_insertBefore(this, newChild,oldChild, assertPreReplacementValidityInDocument);\n\t\tif(oldChild){\n\t\t\tthis.removeChild(oldChild);\n\t\t}\n\t},\n\tremoveChild:function(oldChild){\n\t\treturn _removeChild(this,oldChild);\n\t},\n\tappendChild:function(newChild){\n\t\treturn this.insertBefore(newChild,null);\n\t},\n\thasChildNodes:function(){\n\t\treturn this.firstChild != null;\n\t},\n\tcloneNode:function(deep){\n\t\treturn cloneNode(this.ownerDocument||this,this,deep);\n\t},\n\t// Modified in DOM Level 2:\n\tnormalize:function(){\n\t\tvar child = this.firstChild;\n\t\twhile(child){\n\t\t\tvar next = child.nextSibling;\n\t\t\tif(next && next.nodeType == TEXT_NODE && child.nodeType == TEXT_NODE){\n\t\t\t\tthis.removeChild(next);\n\t\t\t\tchild.appendData(next.data);\n\t\t\t}else{\n\t\t\t\tchild.normalize();\n\t\t\t\tchild = next;\n\t\t\t}\n\t\t}\n\t},\n  \t// Introduced in DOM Level 2:\n\tisSupported:function(feature, version){\n\t\treturn this.ownerDocument.implementation.hasFeature(feature,version);\n\t},\n    // Introduced in DOM Level 2:\n    hasAttributes:function(){\n    \treturn this.attributes.length>0;\n    },\n\t/**\n\t * Look up the prefix associated to the given namespace URI, starting from this node.\n\t * **The default namespace declarations are ignored by this method.**\n\t * See Namespace Prefix Lookup for details on the algorithm used by this method.\n\t *\n\t * _Note: The implementation seems to be incomplete when compared to the algorithm described in the specs._\n\t *\n\t * @param {string | null} namespaceURI\n\t * @returns {string | null}\n\t * @see https://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-lookupNamespacePrefix\n\t * @see https://www.w3.org/TR/DOM-Level-3-Core/namespaces-algorithms.html#lookupNamespacePrefixAlgo\n\t * @see https://dom.spec.whatwg.org/#dom-node-lookupprefix\n\t * @see https://github.com/xmldom/xmldom/issues/322\n\t */\n    lookupPrefix:function(namespaceURI){\n    \tvar el = this;\n    \twhile(el){\n    \t\tvar map = el._nsMap;\n    \t\t//console.dir(map)\n    \t\tif(map){\n    \t\t\tfor(var n in map){\n\t\t\t\t\t\tif (Object.prototype.hasOwnProperty.call(map, n) && map[n] === namespaceURI) {\n\t\t\t\t\t\t\treturn n;\n\t\t\t\t\t\t}\n    \t\t\t}\n    \t\t}\n    \t\tel = el.nodeType == ATTRIBUTE_NODE?el.ownerDocument : el.parentNode;\n    \t}\n    \treturn null;\n    },\n    // Introduced in DOM Level 3:\n    lookupNamespaceURI:function(prefix){\n    \tvar el = this;\n    \twhile(el){\n    \t\tvar map = el._nsMap;\n    \t\t//console.dir(map)\n    \t\tif(map){\n    \t\t\tif(Object.prototype.hasOwnProperty.call(map, prefix)){\n    \t\t\t\treturn map[prefix] ;\n    \t\t\t}\n    \t\t}\n    \t\tel = el.nodeType == ATTRIBUTE_NODE?el.ownerDocument : el.parentNode;\n    \t}\n    \treturn null;\n    },\n    // Introduced in DOM Level 3:\n    isDefaultNamespace:function(namespaceURI){\n    \tvar prefix = this.lookupPrefix(namespaceURI);\n    \treturn prefix == null;\n    }\n};\n\n\nfunction _xmlEncoder(c){\n\treturn c == '<' && '&lt;' ||\n         c == '>' && '&gt;' ||\n         c == '&' && '&amp;' ||\n         c == '\"' && '&quot;' ||\n         '&#'+c.charCodeAt()+';'\n}\n\n\ncopy(NodeType,Node);\ncopy(NodeType,Node.prototype);\n\n/**\n * @param callback return true for continue,false for break\n * @return boolean true: break visit;\n */\nfunction _visitNode(node,callback){\n\tif(callback(node)){\n\t\treturn true;\n\t}\n\tif(node = node.firstChild){\n\t\tdo{\n\t\t\tif(_visitNode(node,callback)){return true}\n        }while(node=node.nextSibling)\n    }\n}\n\n\n\nfunction Document(){\n\tthis.ownerDocument = this;\n}\n\nfunction _onAddAttribute(doc,el,newAttr){\n\tdoc && doc._inc++;\n\tvar ns = newAttr.namespaceURI ;\n\tif(ns === NAMESPACE.XMLNS){\n\t\t//update namespace\n\t\tel._nsMap[newAttr.prefix?newAttr.localName:''] = newAttr.value\n\t}\n}\n\nfunction _onRemoveAttribute(doc,el,newAttr,remove){\n\tdoc && doc._inc++;\n\tvar ns = newAttr.namespaceURI ;\n\tif(ns === NAMESPACE.XMLNS){\n\t\t//update namespace\n\t\tdelete el._nsMap[newAttr.prefix?newAttr.localName:'']\n\t}\n}\n\n/**\n * Updates `el.childNodes`, updating the indexed items and it's `length`.\n * Passing `newChild` means it will be appended.\n * Otherwise it's assumed that an item has been removed,\n * and `el.firstNode` and it's `.nextSibling` are used\n * to walk the current list of child nodes.\n *\n * @param {Document} doc\n * @param {Node} el\n * @param {Node} [newChild]\n * @private\n */\nfunction _onUpdateChild (doc, el, newChild) {\n\tif(doc && doc._inc){\n\t\tdoc._inc++;\n\t\t//update childNodes\n\t\tvar cs = el.childNodes;\n\t\tif (newChild) {\n\t\t\tcs[cs.length++] = newChild;\n\t\t} else {\n\t\t\tvar child = el.firstChild;\n\t\t\tvar i = 0;\n\t\t\twhile (child) {\n\t\t\t\tcs[i++] = child;\n\t\t\t\tchild = child.nextSibling;\n\t\t\t}\n\t\t\tcs.length = i;\n\t\t\tdelete cs[cs.length];\n\t\t}\n\t}\n}\n\n/**\n * Removes the connections between `parentNode` and `child`\n * and any existing `child.previousSibling` or `child.nextSibling`.\n *\n * @see https://github.com/xmldom/xmldom/issues/135\n * @see https://github.com/xmldom/xmldom/issues/145\n *\n * @param {Node} parentNode\n * @param {Node} child\n * @returns {Node} the child that was removed.\n * @private\n */\nfunction _removeChild (parentNode, child) {\n\tvar previous = child.previousSibling;\n\tvar next = child.nextSibling;\n\tif (previous) {\n\t\tprevious.nextSibling = next;\n\t} else {\n\t\tparentNode.firstChild = next;\n\t}\n\tif (next) {\n\t\tnext.previousSibling = previous;\n\t} else {\n\t\tparentNode.lastChild = previous;\n\t}\n\tchild.parentNode = null;\n\tchild.previousSibling = null;\n\tchild.nextSibling = null;\n\t_onUpdateChild(parentNode.ownerDocument, parentNode);\n\treturn child;\n}\n\n/**\n * Returns `true` if `node` can be a parent for insertion.\n * @param {Node} node\n * @returns {boolean}\n */\nfunction hasValidParentNodeType(node) {\n\treturn (\n\t\tnode &&\n\t\t(node.nodeType === Node.DOCUMENT_NODE || node.nodeType === Node.DOCUMENT_FRAGMENT_NODE || node.nodeType === Node.ELEMENT_NODE)\n\t);\n}\n\n/**\n * Returns `true` if `node` can be inserted according to it's `nodeType`.\n * @param {Node} node\n * @returns {boolean}\n */\nfunction hasInsertableNodeType(node) {\n\treturn (\n\t\tnode &&\n\t\t(isElementNode(node) ||\n\t\t\tisTextNode(node) ||\n\t\t\tisDocTypeNode(node) ||\n\t\t\tnode.nodeType === Node.DOCUMENT_FRAGMENT_NODE ||\n\t\t\tnode.nodeType === Node.COMMENT_NODE ||\n\t\t\tnode.nodeType === Node.PROCESSING_INSTRUCTION_NODE)\n\t);\n}\n\n/**\n * Returns true if `node` is a DOCTYPE node\n * @param {Node} node\n * @returns {boolean}\n */\nfunction isDocTypeNode(node) {\n\treturn node && node.nodeType === Node.DOCUMENT_TYPE_NODE;\n}\n\n/**\n * Returns true if the node is an element\n * @param {Node} node\n * @returns {boolean}\n */\nfunction isElementNode(node) {\n\treturn node && node.nodeType === Node.ELEMENT_NODE;\n}\n/**\n * Returns true if `node` is a text node\n * @param {Node} node\n * @returns {boolean}\n */\nfunction isTextNode(node) {\n\treturn node && node.nodeType === Node.TEXT_NODE;\n}\n\n/**\n * Check if en element node can be inserted before `child`, or at the end if child is falsy,\n * according to the presence and position of a doctype node on the same level.\n *\n * @param {Document} doc The document node\n * @param {Node} child the node that would become the nextSibling if the element would be inserted\n * @returns {boolean} `true` if an element can be inserted before child\n * @private\n * https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity\n */\nfunction isElementInsertionPossible(doc, child) {\n\tvar parentChildNodes = doc.childNodes || [];\n\tif (find(parentChildNodes, isElementNode) || isDocTypeNode(child)) {\n\t\treturn false;\n\t}\n\tvar docTypeNode = find(parentChildNodes, isDocTypeNode);\n\treturn !(child && docTypeNode && parentChildNodes.indexOf(docTypeNode) > parentChildNodes.indexOf(child));\n}\n\n/**\n * Check if en element node can be inserted before `child`, or at the end if child is falsy,\n * according to the presence and position of a doctype node on the same level.\n *\n * @param {Node} doc The document node\n * @param {Node} child the node that would become the nextSibling if the element would be inserted\n * @returns {boolean} `true` if an element can be inserted before child\n * @private\n * https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity\n */\nfunction isElementReplacementPossible(doc, child) {\n\tvar parentChildNodes = doc.childNodes || [];\n\n\tfunction hasElementChildThatIsNotChild(node) {\n\t\treturn isElementNode(node) && node !== child;\n\t}\n\n\tif (find(parentChildNodes, hasElementChildThatIsNotChild)) {\n\t\treturn false;\n\t}\n\tvar docTypeNode = find(parentChildNodes, isDocTypeNode);\n\treturn !(child && docTypeNode && parentChildNodes.indexOf(docTypeNode) > parentChildNodes.indexOf(child));\n}\n\n/**\n * @private\n * Steps 1-5 of the checks before inserting and before replacing a child are the same.\n *\n * @param {Node} parent the parent node to insert `node` into\n * @param {Node} node the node to insert\n * @param {Node=} child the node that should become the `nextSibling` of `node`\n * @returns {Node}\n * @throws DOMException for several node combinations that would create a DOM that is not well-formed.\n * @throws DOMException if `child` is provided but is not a child of `parent`.\n * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity\n * @see https://dom.spec.whatwg.org/#concept-node-replace\n */\nfunction assertPreInsertionValidity1to5(parent, node, child) {\n\t// 1. If `parent` is not a Document, DocumentFragment, or Element node, then throw a \"HierarchyRequestError\" DOMException.\n\tif (!hasValidParentNodeType(parent)) {\n\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Unexpected parent node type ' + parent.nodeType);\n\t}\n\t// 2. If `node` is a host-including inclusive ancestor of `parent`, then throw a \"HierarchyRequestError\" DOMException.\n\t// not implemented!\n\t// 3. If `child` is non-null and its parent is not `parent`, then throw a \"NotFoundError\" DOMException.\n\tif (child && child.parentNode !== parent) {\n\t\tthrow new DOMException(NOT_FOUND_ERR, 'child not in parent');\n\t}\n\tif (\n\t\t// 4. If `node` is not a DocumentFragment, DocumentType, Element, or CharacterData node, then throw a \"HierarchyRequestError\" DOMException.\n\t\t!hasInsertableNodeType(node) ||\n\t\t// 5. If either `node` is a Text node and `parent` is a document,\n\t\t// the sax parser currently adds top level text nodes, this will be fixed in 0.9.0\n\t\t// || (node.nodeType === Node.TEXT_NODE && parent.nodeType === Node.DOCUMENT_NODE)\n\t\t// or `node` is a doctype and `parent` is not a document, then throw a \"HierarchyRequestError\" DOMException.\n\t\t(isDocTypeNode(node) && parent.nodeType !== Node.DOCUMENT_NODE)\n\t) {\n\t\tthrow new DOMException(\n\t\t\tHIERARCHY_REQUEST_ERR,\n\t\t\t'Unexpected node type ' + node.nodeType + ' for parent node type ' + parent.nodeType\n\t\t);\n\t}\n}\n\n/**\n * @private\n * Step 6 of the checks before inserting and before replacing a child are different.\n *\n * @param {Document} parent the parent node to insert `node` into\n * @param {Node} node the node to insert\n * @param {Node | undefined} child the node that should become the `nextSibling` of `node`\n * @returns {Node}\n * @throws DOMException for several node combinations that would create a DOM that is not well-formed.\n * @throws DOMException if `child` is provided but is not a child of `parent`.\n * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity\n * @see https://dom.spec.whatwg.org/#concept-node-replace\n */\nfunction assertPreInsertionValidityInDocument(parent, node, child) {\n\tvar parentChildNodes = parent.childNodes || [];\n\tvar nodeChildNodes = node.childNodes || [];\n\n\t// DocumentFragment\n\tif (node.nodeType === Node.DOCUMENT_FRAGMENT_NODE) {\n\t\tvar nodeChildElements = nodeChildNodes.filter(isElementNode);\n\t\t// If node has more than one element child or has a Text node child.\n\t\tif (nodeChildElements.length > 1 || find(nodeChildNodes, isTextNode)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'More than one element or text in fragment');\n\t\t}\n\t\t// Otherwise, if `node` has one element child and either `parent` has an element child,\n\t\t// `child` is a doctype, or `child` is non-null and a doctype is following `child`.\n\t\tif (nodeChildElements.length === 1 && !isElementInsertionPossible(parent, child)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Element in fragment can not be inserted before doctype');\n\t\t}\n\t}\n\t// Element\n\tif (isElementNode(node)) {\n\t\t// `parent` has an element child, `child` is a doctype,\n\t\t// or `child` is non-null and a doctype is following `child`.\n\t\tif (!isElementInsertionPossible(parent, child)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Only one element can be added and only after doctype');\n\t\t}\n\t}\n\t// DocumentType\n\tif (isDocTypeNode(node)) {\n\t\t// `parent` has a doctype child,\n\t\tif (find(parentChildNodes, isDocTypeNode)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Only one doctype is allowed');\n\t\t}\n\t\tvar parentElementChild = find(parentChildNodes, isElementNode);\n\t\t// `child` is non-null and an element is preceding `child`,\n\t\tif (child && parentChildNodes.indexOf(parentElementChild) < parentChildNodes.indexOf(child)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can only be inserted before an element');\n\t\t}\n\t\t// or `child` is null and `parent` has an element child.\n\t\tif (!child && parentElementChild) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can not be appended since element is present');\n\t\t}\n\t}\n}\n\n/**\n * @private\n * Step 6 of the checks before inserting and before replacing a child are different.\n *\n * @param {Document} parent the parent node to insert `node` into\n * @param {Node} node the node to insert\n * @param {Node | undefined} child the node that should become the `nextSibling` of `node`\n * @returns {Node}\n * @throws DOMException for several node combinations that would create a DOM that is not well-formed.\n * @throws DOMException if `child` is provided but is not a child of `parent`.\n * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity\n * @see https://dom.spec.whatwg.org/#concept-node-replace\n */\nfunction assertPreReplacementValidityInDocument(parent, node, child) {\n\tvar parentChildNodes = parent.childNodes || [];\n\tvar nodeChildNodes = node.childNodes || [];\n\n\t// DocumentFragment\n\tif (node.nodeType === Node.DOCUMENT_FRAGMENT_NODE) {\n\t\tvar nodeChildElements = nodeChildNodes.filter(isElementNode);\n\t\t// If `node` has more than one element child or has a Text node child.\n\t\tif (nodeChildElements.length > 1 || find(nodeChildNodes, isTextNode)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'More than one element or text in fragment');\n\t\t}\n\t\t// Otherwise, if `node` has one element child and either `parent` has an element child that is not `child` or a doctype is following `child`.\n\t\tif (nodeChildElements.length === 1 && !isElementReplacementPossible(parent, child)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Element in fragment can not be inserted before doctype');\n\t\t}\n\t}\n\t// Element\n\tif (isElementNode(node)) {\n\t\t// `parent` has an element child that is not `child` or a doctype is following `child`.\n\t\tif (!isElementReplacementPossible(parent, child)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Only one element can be added and only after doctype');\n\t\t}\n\t}\n\t// DocumentType\n\tif (isDocTypeNode(node)) {\n\t\tfunction hasDoctypeChildThatIsNotChild(node) {\n\t\t\treturn isDocTypeNode(node) && node !== child;\n\t\t}\n\n\t\t// `parent` has a doctype child that is not `child`,\n\t\tif (find(parentChildNodes, hasDoctypeChildThatIsNotChild)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Only one doctype is allowed');\n\t\t}\n\t\tvar parentElementChild = find(parentChildNodes, isElementNode);\n\t\t// or an element is preceding `child`.\n\t\tif (child && parentChildNodes.indexOf(parentElementChild) < parentChildNodes.indexOf(child)) {\n\t\t\tthrow new DOMException(HIERARCHY_REQUEST_ERR, 'Doctype can only be inserted before an element');\n\t\t}\n\t}\n}\n\n/**\n * @private\n * @param {Node} parent the parent node to insert `node` into\n * @param {Node} node the node to insert\n * @param {Node=} child the node that should become the `nextSibling` of `node`\n * @returns {Node}\n * @throws DOMException for several node combinations that would create a DOM that is not well-formed.\n * @throws DOMException if `child` is provided but is not a child of `parent`.\n * @see https://dom.spec.whatwg.org/#concept-node-ensure-pre-insertion-validity\n */\nfunction _insertBefore(parent, node, child, _inDocumentAssertion) {\n\t// To ensure pre-insertion validity of a node into a parent before a child, run these steps:\n\tassertPreInsertionValidity1to5(parent, node, child);\n\n\t// If parent is a document, and any of the statements below, switched on the interface node implements,\n\t// are true, then throw a \"HierarchyRequestError\" DOMException.\n\tif (parent.nodeType === Node.DOCUMENT_NODE) {\n\t\t(_inDocumentAssertion || assertPreInsertionValidityInDocument)(parent, node, child);\n\t}\n\n\tvar cp = node.parentNode;\n\tif(cp){\n\t\tcp.removeChild(node);//remove and update\n\t}\n\tif(node.nodeType === DOCUMENT_FRAGMENT_NODE){\n\t\tvar newFirst = node.firstChild;\n\t\tif (newFirst == null) {\n\t\t\treturn node;\n\t\t}\n\t\tvar newLast = node.lastChild;\n\t}else{\n\t\tnewFirst = newLast = node;\n\t}\n\tvar pre = child ? child.previousSibling : parent.lastChild;\n\n\tnewFirst.previousSibling = pre;\n\tnewLast.nextSibling = child;\n\n\n\tif(pre){\n\t\tpre.nextSibling = newFirst;\n\t}else{\n\t\tparent.firstChild = newFirst;\n\t}\n\tif(child == null){\n\t\tparent.lastChild = newLast;\n\t}else{\n\t\tchild.previousSibling = newLast;\n\t}\n\tdo{\n\t\tnewFirst.parentNode = parent;\n\t}while(newFirst !== newLast && (newFirst= newFirst.nextSibling))\n\t_onUpdateChild(parent.ownerDocument||parent, parent);\n\t//console.log(parent.lastChild.nextSibling == null)\n\tif (node.nodeType == DOCUMENT_FRAGMENT_NODE) {\n\t\tnode.firstChild = node.lastChild = null;\n\t}\n\treturn node;\n}\n\n/**\n * Appends `newChild` to `parentNode`.\n * If `newChild` is already connected to a `parentNode` it is first removed from it.\n *\n * @see https://github.com/xmldom/xmldom/issues/135\n * @see https://github.com/xmldom/xmldom/issues/145\n * @param {Node} parentNode\n * @param {Node} newChild\n * @returns {Node}\n * @private\n */\nfunction _appendSingleChild (parentNode, newChild) {\n\tif (newChild.parentNode) {\n\t\tnewChild.parentNode.removeChild(newChild);\n\t}\n\tnewChild.parentNode = parentNode;\n\tnewChild.previousSibling = parentNode.lastChild;\n\tnewChild.nextSibling = null;\n\tif (newChild.previousSibling) {\n\t\tnewChild.previousSibling.nextSibling = newChild;\n\t} else {\n\t\tparentNode.firstChild = newChild;\n\t}\n\tparentNode.lastChild = newChild;\n\t_onUpdateChild(parentNode.ownerDocument, parentNode, newChild);\n\treturn newChild;\n}\n\nDocument.prototype = {\n\t//implementation : null,\n\tnodeName :  '#document',\n\tnodeType :  DOCUMENT_NODE,\n\t/**\n\t * The DocumentType node of the document.\n\t *\n\t * @readonly\n\t * @type DocumentType\n\t */\n\tdoctype :  null,\n\tdocumentElement :  null,\n\t_inc : 1,\n\n\tinsertBefore :  function(newChild, refChild){//raises\n\t\tif(newChild.nodeType == DOCUMENT_FRAGMENT_NODE){\n\t\t\tvar child = newChild.firstChild;\n\t\t\twhile(child){\n\t\t\t\tvar next = child.nextSibling;\n\t\t\t\tthis.insertBefore(child,refChild);\n\t\t\t\tchild = next;\n\t\t\t}\n\t\t\treturn newChild;\n\t\t}\n\t\t_insertBefore(this, newChild, refChild);\n\t\tnewChild.ownerDocument = this;\n\t\tif (this.documentElement === null && newChild.nodeType === ELEMENT_NODE) {\n\t\t\tthis.documentElement = newChild;\n\t\t}\n\n\t\treturn newChild;\n\t},\n\tremoveChild :  function(oldChild){\n\t\tif(this.documentElement == oldChild){\n\t\t\tthis.documentElement = null;\n\t\t}\n\t\treturn _removeChild(this,oldChild);\n\t},\n\treplaceChild: function (newChild, oldChild) {\n\t\t//raises\n\t\t_insertBefore(this, newChild, oldChild, assertPreReplacementValidityInDocument);\n\t\tnewChild.ownerDocument = this;\n\t\tif (oldChild) {\n\t\t\tthis.removeChild(oldChild);\n\t\t}\n\t\tif (isElementNode(newChild)) {\n\t\t\tthis.documentElement = newChild;\n\t\t}\n\t},\n\t// Introduced in DOM Level 2:\n\timportNode : function(importedNode,deep){\n\t\treturn importNode(this,importedNode,deep);\n\t},\n\t// Introduced in DOM Level 2:\n\tgetElementById :\tfunction(id){\n\t\tvar rtv = null;\n\t\t_visitNode(this.documentElement,function(node){\n\t\t\tif(node.nodeType == ELEMENT_NODE){\n\t\t\t\tif(node.getAttribute('id') == id){\n\t\t\t\t\trtv = node;\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t}\n\t\t})\n\t\treturn rtv;\n\t},\n\n\t/**\n\t * The `getElementsByClassName` method of `Document` interface returns an array-like object\n\t * of all child elements which have **all** of the given class name(s).\n\t *\n\t * Returns an empty list if `classeNames` is an empty string or only contains HTML white space characters.\n\t *\n\t *\n\t * Warning: This is a live LiveNodeList.\n\t * Changes in the DOM will reflect in the array as the changes occur.\n\t * If an element selected by this array no longer qualifies for the selector,\n\t * it will automatically be removed. Be aware of this for iteration purposes.\n\t *\n\t * @param {string} classNames is a string representing the class name(s) to match; multiple class names are separated by (ASCII-)whitespace\n\t *\n\t * @see https://developer.mozilla.org/en-US/docs/Web/API/Document/getElementsByClassName\n\t * @see https://dom.spec.whatwg.org/#concept-getelementsbyclassname\n\t */\n\tgetElementsByClassName: function(classNames) {\n\t\tvar classNamesSet = toOrderedSet(classNames)\n\t\treturn new LiveNodeList(this, function(base) {\n\t\t\tvar ls = [];\n\t\t\tif (classNamesSet.length > 0) {\n\t\t\t\t_visitNode(base.documentElement, function(node) {\n\t\t\t\t\tif(node !== base && node.nodeType === ELEMENT_NODE) {\n\t\t\t\t\t\tvar nodeClassNames = node.getAttribute('class')\n\t\t\t\t\t\t// can be null if the attribute does not exist\n\t\t\t\t\t\tif (nodeClassNames) {\n\t\t\t\t\t\t\t// before splitting and iterating just compare them for the most common case\n\t\t\t\t\t\t\tvar matches = classNames === nodeClassNames;\n\t\t\t\t\t\t\tif (!matches) {\n\t\t\t\t\t\t\t\tvar nodeClassNamesSet = toOrderedSet(nodeClassNames)\n\t\t\t\t\t\t\t\tmatches = classNamesSet.every(arrayIncludes(nodeClassNamesSet))\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tif(matches) {\n\t\t\t\t\t\t\t\tls.push(node);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t\treturn ls;\n\t\t});\n\t},\n\n\t//document factory method:\n\tcreateElement :\tfunction(tagName){\n\t\tvar node = new Element();\n\t\tnode.ownerDocument = this;\n\t\tnode.nodeName = tagName;\n\t\tnode.tagName = tagName;\n\t\tnode.localName = tagName;\n\t\tnode.childNodes = new NodeList();\n\t\tvar attrs\t= node.attributes = new NamedNodeMap();\n\t\tattrs._ownerElement = node;\n\t\treturn node;\n\t},\n\tcreateDocumentFragment :\tfunction(){\n\t\tvar node = new DocumentFragment();\n\t\tnode.ownerDocument = this;\n\t\tnode.childNodes = new NodeList();\n\t\treturn node;\n\t},\n\tcreateTextNode :\tfunction(data){\n\t\tvar node = new Text();\n\t\tnode.ownerDocument = this;\n\t\tnode.appendData(data)\n\t\treturn node;\n\t},\n\tcreateComment :\tfunction(data){\n\t\tvar node = new Comment();\n\t\tnode.ownerDocument = this;\n\t\tnode.appendData(data)\n\t\treturn node;\n\t},\n\tcreateCDATASection :\tfunction(data){\n\t\tvar node = new CDATASection();\n\t\tnode.ownerDocument = this;\n\t\tnode.appendData(data)\n\t\treturn node;\n\t},\n\tcreateProcessingInstruction :\tfunction(target,data){\n\t\tvar node = new ProcessingInstruction();\n\t\tnode.ownerDocument = this;\n\t\tnode.tagName = node.nodeName = node.target = target;\n\t\tnode.nodeValue = node.data = data;\n\t\treturn node;\n\t},\n\tcreateAttribute :\tfunction(name){\n\t\tvar node = new Attr();\n\t\tnode.ownerDocument\t= this;\n\t\tnode.name = name;\n\t\tnode.nodeName\t= name;\n\t\tnode.localName = name;\n\t\tnode.specified = true;\n\t\treturn node;\n\t},\n\tcreateEntityReference :\tfunction(name){\n\t\tvar node = new EntityReference();\n\t\tnode.ownerDocument\t= this;\n\t\tnode.nodeName\t= name;\n\t\treturn node;\n\t},\n\t// Introduced in DOM Level 2:\n\tcreateElementNS :\tfunction(namespaceURI,qualifiedName){\n\t\tvar node = new Element();\n\t\tvar pl = qualifiedName.split(':');\n\t\tvar attrs\t= node.attributes = new NamedNodeMap();\n\t\tnode.childNodes = new NodeList();\n\t\tnode.ownerDocument = this;\n\t\tnode.nodeName = qualifiedName;\n\t\tnode.tagName = qualifiedName;\n\t\tnode.namespaceURI = namespaceURI;\n\t\tif(pl.length == 2){\n\t\t\tnode.prefix = pl[0];\n\t\t\tnode.localName = pl[1];\n\t\t}else{\n\t\t\t//el.prefix = null;\n\t\t\tnode.localName = qualifiedName;\n\t\t}\n\t\tattrs._ownerElement = node;\n\t\treturn node;\n\t},\n\t// Introduced in DOM Level 2:\n\tcreateAttributeNS :\tfunction(namespaceURI,qualifiedName){\n\t\tvar node = new Attr();\n\t\tvar pl = qualifiedName.split(':');\n\t\tnode.ownerDocument = this;\n\t\tnode.nodeName = qualifiedName;\n\t\tnode.name = qualifiedName;\n\t\tnode.namespaceURI = namespaceURI;\n\t\tnode.specified = true;\n\t\tif(pl.length == 2){\n\t\t\tnode.prefix = pl[0];\n\t\t\tnode.localName = pl[1];\n\t\t}else{\n\t\t\t//el.prefix = null;\n\t\t\tnode.localName = qualifiedName;\n\t\t}\n\t\treturn node;\n\t}\n};\n_extends(Document,Node);\n\n\nfunction Element() {\n\tthis._nsMap = {};\n};\nElement.prototype = {\n\tnodeType : ELEMENT_NODE,\n\thasAttribute : function(name){\n\t\treturn this.getAttributeNode(name)!=null;\n\t},\n\tgetAttribute : function(name){\n\t\tvar attr = this.getAttributeNode(name);\n\t\treturn attr && attr.value || '';\n\t},\n\tgetAttributeNode : function(name){\n\t\treturn this.attributes.getNamedItem(name);\n\t},\n\tsetAttribute : function(name, value){\n\t\tvar attr = this.ownerDocument.createAttribute(name);\n\t\tattr.value = attr.nodeValue = \"\" + value;\n\t\tthis.setAttributeNode(attr)\n\t},\n\tremoveAttribute : function(name){\n\t\tvar attr = this.getAttributeNode(name)\n\t\tattr && this.removeAttributeNode(attr);\n\t},\n\n\t//four real opeartion method\n\tappendChild:function(newChild){\n\t\tif(newChild.nodeType === DOCUMENT_FRAGMENT_NODE){\n\t\t\treturn this.insertBefore(newChild,null);\n\t\t}else{\n\t\t\treturn _appendSingleChild(this,newChild);\n\t\t}\n\t},\n\tsetAttributeNode : function(newAttr){\n\t\treturn this.attributes.setNamedItem(newAttr);\n\t},\n\tsetAttributeNodeNS : function(newAttr){\n\t\treturn this.attributes.setNamedItemNS(newAttr);\n\t},\n\tremoveAttributeNode : function(oldAttr){\n\t\t//console.log(this == oldAttr.ownerElement)\n\t\treturn this.attributes.removeNamedItem(oldAttr.nodeName);\n\t},\n\t//get real attribute name,and remove it by removeAttributeNode\n\tremoveAttributeNS : function(namespaceURI, localName){\n\t\tvar old = this.getAttributeNodeNS(namespaceURI, localName);\n\t\told && this.removeAttributeNode(old);\n\t},\n\n\thasAttributeNS : function(namespaceURI, localName){\n\t\treturn this.getAttributeNodeNS(namespaceURI, localName)!=null;\n\t},\n\tgetAttributeNS : function(namespaceURI, localName){\n\t\tvar attr = this.getAttributeNodeNS(namespaceURI, localName);\n\t\treturn attr && attr.value || '';\n\t},\n\tsetAttributeNS : function(namespaceURI, qualifiedName, value){\n\t\tvar attr = this.ownerDocument.createAttributeNS(namespaceURI, qualifiedName);\n\t\tattr.value = attr.nodeValue = \"\" + value;\n\t\tthis.setAttributeNode(attr)\n\t},\n\tgetAttributeNodeNS : function(namespaceURI, localName){\n\t\treturn this.attributes.getNamedItemNS(namespaceURI, localName);\n\t},\n\n\tgetElementsByTagName : function(tagName){\n\t\treturn new LiveNodeList(this,function(base){\n\t\t\tvar ls = [];\n\t\t\t_visitNode(base,function(node){\n\t\t\t\tif(node !== base && node.nodeType == ELEMENT_NODE && (tagName === '*' || node.tagName == tagName)){\n\t\t\t\t\tls.push(node);\n\t\t\t\t}\n\t\t\t});\n\t\t\treturn ls;\n\t\t});\n\t},\n\tgetElementsByTagNameNS : function(namespaceURI, localName){\n\t\treturn new LiveNodeList(this,function(base){\n\t\t\tvar ls = [];\n\t\t\t_visitNode(base,function(node){\n\t\t\t\tif(node !== base && node.nodeType === ELEMENT_NODE && (namespaceURI === '*' || node.namespaceURI === namespaceURI) && (localName === '*' || node.localName == localName)){\n\t\t\t\t\tls.push(node);\n\t\t\t\t}\n\t\t\t});\n\t\t\treturn ls;\n\n\t\t});\n\t}\n};\nDocument.prototype.getElementsByTagName = Element.prototype.getElementsByTagName;\nDocument.prototype.getElementsByTagNameNS = Element.prototype.getElementsByTagNameNS;\n\n\n_extends(Element,Node);\nfunction Attr() {\n};\nAttr.prototype.nodeType = ATTRIBUTE_NODE;\n_extends(Attr,Node);\n\n\nfunction CharacterData() {\n};\nCharacterData.prototype = {\n\tdata : '',\n\tsubstringData : function(offset, count) {\n\t\treturn this.data.substring(offset, offset+count);\n\t},\n\tappendData: function(text) {\n\t\ttext = this.data+text;\n\t\tthis.nodeValue = this.data = text;\n\t\tthis.length = text.length;\n\t},\n\tinsertData: function(offset,text) {\n\t\tthis.replaceData(offset,0,text);\n\n\t},\n\tappendChild:function(newChild){\n\t\tthrow new Error(ExceptionMessage[HIERARCHY_REQUEST_ERR])\n\t},\n\tdeleteData: function(offset, count) {\n\t\tthis.replaceData(offset,count,\"\");\n\t},\n\treplaceData: function(offset, count, text) {\n\t\tvar start = this.data.substring(0,offset);\n\t\tvar end = this.data.substring(offset+count);\n\t\ttext = start + text + end;\n\t\tthis.nodeValue = this.data = text;\n\t\tthis.length = text.length;\n\t}\n}\n_extends(CharacterData,Node);\nfunction Text() {\n};\nText.prototype = {\n\tnodeName : \"#text\",\n\tnodeType : TEXT_NODE,\n\tsplitText : function(offset) {\n\t\tvar text = this.data;\n\t\tvar newText = text.substring(offset);\n\t\ttext = text.substring(0, offset);\n\t\tthis.data = this.nodeValue = text;\n\t\tthis.length = text.length;\n\t\tvar newNode = this.ownerDocument.createTextNode(newText);\n\t\tif(this.parentNode){\n\t\t\tthis.parentNode.insertBefore(newNode, this.nextSibling);\n\t\t}\n\t\treturn newNode;\n\t}\n}\n_extends(Text,CharacterData);\nfunction Comment() {\n};\nComment.prototype = {\n\tnodeName : \"#comment\",\n\tnodeType : COMMENT_NODE\n}\n_extends(Comment,CharacterData);\n\nfunction CDATASection() {\n};\nCDATASection.prototype = {\n\tnodeName : \"#cdata-section\",\n\tnodeType : CDATA_SECTION_NODE\n}\n_extends(CDATASection,CharacterData);\n\n\nfunction DocumentType() {\n};\nDocumentType.prototype.nodeType = DOCUMENT_TYPE_NODE;\n_extends(DocumentType,Node);\n\nfunction Notation() {\n};\nNotation.prototype.nodeType = NOTATION_NODE;\n_extends(Notation,Node);\n\nfunction Entity() {\n};\nEntity.prototype.nodeType = ENTITY_NODE;\n_extends(Entity,Node);\n\nfunction EntityReference() {\n};\nEntityReference.prototype.nodeType = ENTITY_REFERENCE_NODE;\n_extends(EntityReference,Node);\n\nfunction DocumentFragment() {\n};\nDocumentFragment.prototype.nodeName =\t\"#document-fragment\";\nDocumentFragment.prototype.nodeType =\tDOCUMENT_FRAGMENT_NODE;\n_extends(DocumentFragment,Node);\n\n\nfunction ProcessingInstruction() {\n}\nProcessingInstruction.prototype.nodeType = PROCESSING_INSTRUCTION_NODE;\n_extends(ProcessingInstruction,Node);\nfunction XMLSerializer(){}\nXMLSerializer.prototype.serializeToString = function(node,isHtml,nodeFilter){\n\treturn nodeSerializeToString.call(node,isHtml,nodeFilter);\n}\nNode.prototype.toString = nodeSerializeToString;\nfunction nodeSerializeToString(isHtml,nodeFilter){\n\tvar buf = [];\n\tvar refNode = this.nodeType == 9 && this.documentElement || this;\n\tvar prefix = refNode.prefix;\n\tvar uri = refNode.namespaceURI;\n\n\tif(uri && prefix == null){\n\t\t//console.log(prefix)\n\t\tvar prefix = refNode.lookupPrefix(uri);\n\t\tif(prefix == null){\n\t\t\t//isHTML = true;\n\t\t\tvar visibleNamespaces=[\n\t\t\t{namespace:uri,prefix:null}\n\t\t\t//{namespace:uri,prefix:''}\n\t\t\t]\n\t\t}\n\t}\n\tserializeToString(this,buf,isHtml,nodeFilter,visibleNamespaces);\n\t//console.log('###',this.nodeType,uri,prefix,buf.join(''))\n\treturn buf.join('');\n}\n\nfunction needNamespaceDefine(node, isHTML, visibleNamespaces) {\n\tvar prefix = node.prefix || '';\n\tvar uri = node.namespaceURI;\n\t// According to [Namespaces in XML 1.0](https://www.w3.org/TR/REC-xml-names/#ns-using) ,\n\t// and more specifically https://www.w3.org/TR/REC-xml-names/#nsc-NoPrefixUndecl :\n\t// > In a namespace declaration for a prefix [...], the attribute value MUST NOT be empty.\n\t// in a similar manner [Namespaces in XML 1.1](https://www.w3.org/TR/xml-names11/#ns-using)\n\t// and more specifically https://www.w3.org/TR/xml-names11/#nsc-NSDeclared :\n\t// > [...] Furthermore, the attribute value [...] must not be an empty string.\n\t// so serializing empty namespace value like xmlns:ds=\"\" would produce an invalid XML document.\n\tif (!uri) {\n\t\treturn false;\n\t}\n\tif (prefix === \"xml\" && uri === NAMESPACE.XML || uri === NAMESPACE.XMLNS) {\n\t\treturn false;\n\t}\n\n\tvar i = visibleNamespaces.length\n\twhile (i--) {\n\t\tvar ns = visibleNamespaces[i];\n\t\t// get namespace prefix\n\t\tif (ns.prefix === prefix) {\n\t\t\treturn ns.namespace !== uri;\n\t\t}\n\t}\n\treturn true;\n}\n/**\n * Well-formed constraint: No < in Attribute Values\n * > The replacement text of any entity referred to directly or indirectly\n * > in an attribute value must not contain a <.\n * @see https://www.w3.org/TR/xml11/#CleanAttrVals\n * @see https://www.w3.org/TR/xml11/#NT-AttValue\n *\n * Literal whitespace other than space that appear in attribute values\n * are serialized as their entity references, so they will be preserved.\n * (In contrast to whitespace literals in the input which are normalized to spaces)\n * @see https://www.w3.org/TR/xml11/#AVNormalize\n * @see https://w3c.github.io/DOM-Parsing/#serializing-an-element-s-attributes\n */\nfunction addSerializedAttribute(buf, qualifiedName, value) {\n\tbuf.push(' ', qualifiedName, '=\"', value.replace(/[<>&\"\\t\\n\\r]/g, _xmlEncoder), '\"')\n}\n\nfunction serializeToString(node,buf,isHTML,nodeFilter,visibleNamespaces){\n\tif (!visibleNamespaces) {\n\t\tvisibleNamespaces = [];\n\t}\n\n\tif(nodeFilter){\n\t\tnode = nodeFilter(node);\n\t\tif(node){\n\t\t\tif(typeof node == 'string'){\n\t\t\t\tbuf.push(node);\n\t\t\t\treturn;\n\t\t\t}\n\t\t}else{\n\t\t\treturn;\n\t\t}\n\t\t//buf.sort.apply(attrs, attributeSorter);\n\t}\n\n\tswitch(node.nodeType){\n\tcase ELEMENT_NODE:\n\t\tvar attrs = node.attributes;\n\t\tvar len = attrs.length;\n\t\tvar child = node.firstChild;\n\t\tvar nodeName = node.tagName;\n\n\t\tisHTML = NAMESPACE.isHTML(node.namespaceURI) || isHTML\n\n\t\tvar prefixedNodeName = nodeName\n\t\tif (!isHTML && !node.prefix && node.namespaceURI) {\n\t\t\tvar defaultNS\n\t\t\t// lookup current default ns from `xmlns` attribute\n\t\t\tfor (var ai = 0; ai < attrs.length; ai++) {\n\t\t\t\tif (attrs.item(ai).name === 'xmlns') {\n\t\t\t\t\tdefaultNS = attrs.item(ai).value\n\t\t\t\t\tbreak\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (!defaultNS) {\n\t\t\t\t// lookup current default ns in visibleNamespaces\n\t\t\t\tfor (var nsi = visibleNamespaces.length - 1; nsi >= 0; nsi--) {\n\t\t\t\t\tvar namespace = visibleNamespaces[nsi]\n\t\t\t\t\tif (namespace.prefix === '' && namespace.namespace === node.namespaceURI) {\n\t\t\t\t\t\tdefaultNS = namespace.namespace\n\t\t\t\t\t\tbreak\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t\tif (defaultNS !== node.namespaceURI) {\n\t\t\t\tfor (var nsi = visibleNamespaces.length - 1; nsi >= 0; nsi--) {\n\t\t\t\t\tvar namespace = visibleNamespaces[nsi]\n\t\t\t\t\tif (namespace.namespace === node.namespaceURI) {\n\t\t\t\t\t\tif (namespace.prefix) {\n\t\t\t\t\t\t\tprefixedNodeName = namespace.prefix + ':' + nodeName\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tbuf.push('<', prefixedNodeName);\n\n\t\tfor(var i=0;i<len;i++){\n\t\t\t// add namespaces for attributes\n\t\t\tvar attr = attrs.item(i);\n\t\t\tif (attr.prefix == 'xmlns') {\n\t\t\t\tvisibleNamespaces.push({ prefix: attr.localName, namespace: attr.value });\n\t\t\t}else if(attr.nodeName == 'xmlns'){\n\t\t\t\tvisibleNamespaces.push({ prefix: '', namespace: attr.value });\n\t\t\t}\n\t\t}\n\n\t\tfor(var i=0;i<len;i++){\n\t\t\tvar attr = attrs.item(i);\n\t\t\tif (needNamespaceDefine(attr,isHTML, visibleNamespaces)) {\n\t\t\t\tvar prefix = attr.prefix||'';\n\t\t\t\tvar uri = attr.namespaceURI;\n\t\t\t\taddSerializedAttribute(buf, prefix ? 'xmlns:' + prefix : \"xmlns\", uri);\n\t\t\t\tvisibleNamespaces.push({ prefix: prefix, namespace:uri });\n\t\t\t}\n\t\t\tserializeToString(attr,buf,isHTML,nodeFilter,visibleNamespaces);\n\t\t}\n\n\t\t// add namespace for current node\n\t\tif (nodeName === prefixedNodeName && needNamespaceDefine(node, isHTML, visibleNamespaces)) {\n\t\t\tvar prefix = node.prefix||'';\n\t\t\tvar uri = node.namespaceURI;\n\t\t\taddSerializedAttribute(buf, prefix ? 'xmlns:' + prefix : \"xmlns\", uri);\n\t\t\tvisibleNamespaces.push({ prefix: prefix, namespace:uri });\n\t\t}\n\n\t\tif(child || isHTML && !/^(?:meta|link|img|br|hr|input)$/i.test(nodeName)){\n\t\t\tbuf.push('>');\n\t\t\t//if is cdata child node\n\t\t\tif(isHTML && /^script$/i.test(nodeName)){\n\t\t\t\twhile(child){\n\t\t\t\t\tif(child.data){\n\t\t\t\t\t\tbuf.push(child.data);\n\t\t\t\t\t}else{\n\t\t\t\t\t\tserializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());\n\t\t\t\t\t}\n\t\t\t\t\tchild = child.nextSibling;\n\t\t\t\t}\n\t\t\t}else\n\t\t\t{\n\t\t\t\twhile(child){\n\t\t\t\t\tserializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());\n\t\t\t\t\tchild = child.nextSibling;\n\t\t\t\t}\n\t\t\t}\n\t\t\tbuf.push('</',prefixedNodeName,'>');\n\t\t}else{\n\t\t\tbuf.push('/>');\n\t\t}\n\t\t// remove added visible namespaces\n\t\t//visibleNamespaces.length = startVisibleNamespaces;\n\t\treturn;\n\tcase DOCUMENT_NODE:\n\tcase DOCUMENT_FRAGMENT_NODE:\n\t\tvar child = node.firstChild;\n\t\twhile(child){\n\t\t\tserializeToString(child, buf, isHTML, nodeFilter, visibleNamespaces.slice());\n\t\t\tchild = child.nextSibling;\n\t\t}\n\t\treturn;\n\tcase ATTRIBUTE_NODE:\n\t\treturn addSerializedAttribute(buf, node.name, node.value);\n\tcase TEXT_NODE:\n\t\t/**\n\t\t * The ampersand character (&) and the left angle bracket (<) must not appear in their literal form,\n\t\t * except when used as markup delimiters, or within a comment, a processing instruction, or a CDATA section.\n\t\t * If they are needed elsewhere, they must be escaped using either numeric character references or the strings\n\t\t * `&amp;` and `&lt;` respectively.\n\t\t * The right angle bracket (>) may be represented using the string \" &gt; \", and must, for compatibility,\n\t\t * be escaped using either `&gt;` or a character reference when it appears in the string `]]>` in content,\n\t\t * when that string is not marking the end of a CDATA section.\n\t\t *\n\t\t * In the content of elements, character data is any string of characters\n\t\t * which does not contain the start-delimiter of any markup\n\t\t * and does not include the CDATA-section-close delimiter, `]]>`.\n\t\t *\n\t\t * @see https://www.w3.org/TR/xml/#NT-CharData\n\t\t * @see https://w3c.github.io/DOM-Parsing/#xml-serializing-a-text-node\n\t\t */\n\t\treturn buf.push(node.data\n\t\t\t.replace(/[<&>]/g,_xmlEncoder)\n\t\t);\n\tcase CDATA_SECTION_NODE:\n\t\treturn buf.push( '<![CDATA[',node.data,']]>');\n\tcase COMMENT_NODE:\n\t\treturn buf.push( \"\x3c!--\",node.data,\"--\x3e\");\n\tcase DOCUMENT_TYPE_NODE:\n\t\tvar pubid = node.publicId;\n\t\tvar sysid = node.systemId;\n\t\tbuf.push('<!DOCTYPE ',node.name);\n\t\tif(pubid){\n\t\t\tbuf.push(' PUBLIC ', pubid);\n\t\t\tif (sysid && sysid!='.') {\n\t\t\t\tbuf.push(' ', sysid);\n\t\t\t}\n\t\t\tbuf.push('>');\n\t\t}else if(sysid && sysid!='.'){\n\t\t\tbuf.push(' SYSTEM ', sysid, '>');\n\t\t}else{\n\t\t\tvar sub = node.internalSubset;\n\t\t\tif(sub){\n\t\t\t\tbuf.push(\" [\",sub,\"]\");\n\t\t\t}\n\t\t\tbuf.push(\">\");\n\t\t}\n\t\treturn;\n\tcase PROCESSING_INSTRUCTION_NODE:\n\t\treturn buf.push( \"<?\",node.target,\" \",node.data,\"?>\");\n\tcase ENTITY_REFERENCE_NODE:\n\t\treturn buf.push( '&',node.nodeName,';');\n\t//case ENTITY_NODE:\n\t//case NOTATION_NODE:\n\tdefault:\n\t\tbuf.push('??',node.nodeName);\n\t}\n}\nfunction importNode(doc,node,deep){\n\tvar node2;\n\tswitch (node.nodeType) {\n\tcase ELEMENT_NODE:\n\t\tnode2 = node.cloneNode(false);\n\t\tnode2.ownerDocument = doc;\n\t\t//var attrs = node2.attributes;\n\t\t//var len = attrs.length;\n\t\t//for(var i=0;i<len;i++){\n\t\t\t//node2.setAttributeNodeNS(importNode(doc,attrs.item(i),deep));\n\t\t//}\n\tcase DOCUMENT_FRAGMENT_NODE:\n\t\tbreak;\n\tcase ATTRIBUTE_NODE:\n\t\tdeep = true;\n\t\tbreak;\n\t//case ENTITY_REFERENCE_NODE:\n\t//case PROCESSING_INSTRUCTION_NODE:\n\t////case TEXT_NODE:\n\t//case CDATA_SECTION_NODE:\n\t//case COMMENT_NODE:\n\t//\tdeep = false;\n\t//\tbreak;\n\t//case DOCUMENT_NODE:\n\t//case DOCUMENT_TYPE_NODE:\n\t//cannot be imported.\n\t//case ENTITY_NODE:\n\t//case NOTATION_NODE：\n\t//can not hit in level3\n\t//default:throw e;\n\t}\n\tif(!node2){\n\t\tnode2 = node.cloneNode(false);//false\n\t}\n\tnode2.ownerDocument = doc;\n\tnode2.parentNode = null;\n\tif(deep){\n\t\tvar child = node.firstChild;\n\t\twhile(child){\n\t\t\tnode2.appendChild(importNode(doc,child,deep));\n\t\t\tchild = child.nextSibling;\n\t\t}\n\t}\n\treturn node2;\n}\n//\n//var _relationMap = {firstChild:1,lastChild:1,previousSibling:1,nextSibling:1,\n//\t\t\t\t\tattributes:1,childNodes:1,parentNode:1,documentElement:1,doctype,};\nfunction cloneNode(doc,node,deep){\n\tvar node2 = new node.constructor();\n\tfor (var n in node) {\n\t\tif (Object.prototype.hasOwnProperty.call(node, n)) {\n\t\t\tvar v = node[n];\n\t\t\tif (typeof v != \"object\") {\n\t\t\t\tif (v != node2[n]) {\n\t\t\t\t\tnode2[n] = v;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\tif(node.childNodes){\n\t\tnode2.childNodes = new NodeList();\n\t}\n\tnode2.ownerDocument = doc;\n\tswitch (node2.nodeType) {\n\tcase ELEMENT_NODE:\n\t\tvar attrs\t= node.attributes;\n\t\tvar attrs2\t= node2.attributes = new NamedNodeMap();\n\t\tvar len = attrs.length\n\t\tattrs2._ownerElement = node2;\n\t\tfor(var i=0;i<len;i++){\n\t\t\tnode2.setAttributeNode(cloneNode(doc,attrs.item(i),true));\n\t\t}\n\t\tbreak;;\n\tcase ATTRIBUTE_NODE:\n\t\tdeep = true;\n\t}\n\tif(deep){\n\t\tvar child = node.firstChild;\n\t\twhile(child){\n\t\t\tnode2.appendChild(cloneNode(doc,child,deep));\n\t\t\tchild = child.nextSibling;\n\t\t}\n\t}\n\treturn node2;\n}\n\nfunction __set__(object,key,value){\n\tobject[key] = value\n}\n//do dynamic\ntry{\n\tif(Object.defineProperty){\n\t\tObject.defineProperty(LiveNodeList.prototype,'length',{\n\t\t\tget:function(){\n\t\t\t\t_updateLiveList(this);\n\t\t\t\treturn this.$$length;\n\t\t\t}\n\t\t});\n\n\t\tObject.defineProperty(Node.prototype,'textContent',{\n\t\t\tget:function(){\n\t\t\t\treturn getTextContent(this);\n\t\t\t},\n\n\t\t\tset:function(data){\n\t\t\t\tswitch(this.nodeType){\n\t\t\t\tcase ELEMENT_NODE:\n\t\t\t\tcase DOCUMENT_FRAGMENT_NODE:\n\t\t\t\t\twhile(this.firstChild){\n\t\t\t\t\t\tthis.removeChild(this.firstChild);\n\t\t\t\t\t}\n\t\t\t\t\tif(data || String(data)){\n\t\t\t\t\t\tthis.appendChild(this.ownerDocument.createTextNode(data));\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\n\t\t\t\tdefault:\n\t\t\t\t\tthis.data = data;\n\t\t\t\t\tthis.value = data;\n\t\t\t\t\tthis.nodeValue = data;\n\t\t\t\t}\n\t\t\t}\n\t\t})\n\n\t\tfunction getTextContent(node){\n\t\t\tswitch(node.nodeType){\n\t\t\tcase ELEMENT_NODE:\n\t\t\tcase DOCUMENT_FRAGMENT_NODE:\n\t\t\t\tvar buf = [];\n\t\t\t\tnode = node.firstChild;\n\t\t\t\twhile(node){\n\t\t\t\t\tif(node.nodeType!==7 && node.nodeType !==8){\n\t\t\t\t\t\tbuf.push(getTextContent(node));\n\t\t\t\t\t}\n\t\t\t\t\tnode = node.nextSibling;\n\t\t\t\t}\n\t\t\t\treturn buf.join('');\n\t\t\tdefault:\n\t\t\t\treturn node.nodeValue;\n\t\t\t}\n\t\t}\n\n\t\t__set__ = function(object,key,value){\n\t\t\t//console.log(value)\n\t\t\tobject['$$'+key] = value\n\t\t}\n\t}\n}catch(e){//ie8\n}\n\n//if(typeof require == 'function'){\n\texports.DocumentType = DocumentType;\n\texports.DOMException = DOMException;\n\texports.DOMImplementation = DOMImplementation;\n\texports.Element = Element;\n\texports.Node = Node;\n\texports.NodeList = NodeList;\n\texports.XMLSerializer = XMLSerializer;\n//}\n\n\n//# sourceURL=webpack://web/./node_modules/@xmldom/xmldom/lib/dom.js?")},"./node_modules/@xmldom/xmldom/lib/entities.js":(__unused_webpack_module,exports,__webpack_require__)=>{"use strict";eval("\n\nvar freeze = (__webpack_require__(/*! ./conventions */ \"./node_modules/@xmldom/xmldom/lib/conventions.js\").freeze);\n\n/**\n * The entities that are predefined in every XML document.\n *\n * @see https://www.w3.org/TR/2006/REC-xml11-20060816/#sec-predefined-ent W3C XML 1.1\n * @see https://www.w3.org/TR/2008/REC-xml-20081126/#sec-predefined-ent W3C XML 1.0\n * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Predefined_entities_in_XML Wikipedia\n */\nexports.XML_ENTITIES = freeze({\n\tamp: '&',\n\tapos: \"'\",\n\tgt: '>',\n\tlt: '<',\n\tquot: '\"',\n});\n\n/**\n * A map of all entities that are detected in an HTML document.\n * They contain all entries from `XML_ENTITIES`.\n *\n * @see XML_ENTITIES\n * @see DOMParser.parseFromString\n * @see DOMImplementation.prototype.createHTMLDocument\n * @see https://html.spec.whatwg.org/#named-character-references WHATWG HTML(5) Spec\n * @see https://html.spec.whatwg.org/entities.json JSON\n * @see https://www.w3.org/TR/xml-entity-names/ W3C XML Entity Names\n * @see https://www.w3.org/TR/html4/sgml/entities.html W3C HTML4/SGML\n * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Character_entity_references_in_HTML Wikipedia (HTML)\n * @see https://en.wikipedia.org/wiki/List_of_XML_and_HTML_character_entity_references#Entities_representing_special_characters_in_XHTML Wikpedia (XHTML)\n */\nexports.HTML_ENTITIES = freeze({\n\tAacute: '\\u00C1',\n\taacute: '\\u00E1',\n\tAbreve: '\\u0102',\n\tabreve: '\\u0103',\n\tac: '\\u223E',\n\tacd: '\\u223F',\n\tacE: '\\u223E\\u0333',\n\tAcirc: '\\u00C2',\n\tacirc: '\\u00E2',\n\tacute: '\\u00B4',\n\tAcy: '\\u0410',\n\tacy: '\\u0430',\n\tAElig: '\\u00C6',\n\taelig: '\\u00E6',\n\taf: '\\u2061',\n\tAfr: '\\uD835\\uDD04',\n\tafr: '\\uD835\\uDD1E',\n\tAgrave: '\\u00C0',\n\tagrave: '\\u00E0',\n\talefsym: '\\u2135',\n\taleph: '\\u2135',\n\tAlpha: '\\u0391',\n\talpha: '\\u03B1',\n\tAmacr: '\\u0100',\n\tamacr: '\\u0101',\n\tamalg: '\\u2A3F',\n\tAMP: '\\u0026',\n\tamp: '\\u0026',\n\tAnd: '\\u2A53',\n\tand: '\\u2227',\n\tandand: '\\u2A55',\n\tandd: '\\u2A5C',\n\tandslope: '\\u2A58',\n\tandv: '\\u2A5A',\n\tang: '\\u2220',\n\tange: '\\u29A4',\n\tangle: '\\u2220',\n\tangmsd: '\\u2221',\n\tangmsdaa: '\\u29A8',\n\tangmsdab: '\\u29A9',\n\tangmsdac: '\\u29AA',\n\tangmsdad: '\\u29AB',\n\tangmsdae: '\\u29AC',\n\tangmsdaf: '\\u29AD',\n\tangmsdag: '\\u29AE',\n\tangmsdah: '\\u29AF',\n\tangrt: '\\u221F',\n\tangrtvb: '\\u22BE',\n\tangrtvbd: '\\u299D',\n\tangsph: '\\u2222',\n\tangst: '\\u00C5',\n\tangzarr: '\\u237C',\n\tAogon: '\\u0104',\n\taogon: '\\u0105',\n\tAopf: '\\uD835\\uDD38',\n\taopf: '\\uD835\\uDD52',\n\tap: '\\u2248',\n\tapacir: '\\u2A6F',\n\tapE: '\\u2A70',\n\tape: '\\u224A',\n\tapid: '\\u224B',\n\tapos: '\\u0027',\n\tApplyFunction: '\\u2061',\n\tapprox: '\\u2248',\n\tapproxeq: '\\u224A',\n\tAring: '\\u00C5',\n\taring: '\\u00E5',\n\tAscr: '\\uD835\\uDC9C',\n\tascr: '\\uD835\\uDCB6',\n\tAssign: '\\u2254',\n\tast: '\\u002A',\n\tasymp: '\\u2248',\n\tasympeq: '\\u224D',\n\tAtilde: '\\u00C3',\n\tatilde: '\\u00E3',\n\tAuml: '\\u00C4',\n\tauml: '\\u00E4',\n\tawconint: '\\u2233',\n\tawint: '\\u2A11',\n\tbackcong: '\\u224C',\n\tbackepsilon: '\\u03F6',\n\tbackprime: '\\u2035',\n\tbacksim: '\\u223D',\n\tbacksimeq: '\\u22CD',\n\tBackslash: '\\u2216',\n\tBarv: '\\u2AE7',\n\tbarvee: '\\u22BD',\n\tBarwed: '\\u2306',\n\tbarwed: '\\u2305',\n\tbarwedge: '\\u2305',\n\tbbrk: '\\u23B5',\n\tbbrktbrk: '\\u23B6',\n\tbcong: '\\u224C',\n\tBcy: '\\u0411',\n\tbcy: '\\u0431',\n\tbdquo: '\\u201E',\n\tbecaus: '\\u2235',\n\tBecause: '\\u2235',\n\tbecause: '\\u2235',\n\tbemptyv: '\\u29B0',\n\tbepsi: '\\u03F6',\n\tbernou: '\\u212C',\n\tBernoullis: '\\u212C',\n\tBeta: '\\u0392',\n\tbeta: '\\u03B2',\n\tbeth: '\\u2136',\n\tbetween: '\\u226C',\n\tBfr: '\\uD835\\uDD05',\n\tbfr: '\\uD835\\uDD1F',\n\tbigcap: '\\u22C2',\n\tbigcirc: '\\u25EF',\n\tbigcup: '\\u22C3',\n\tbigodot: '\\u2A00',\n\tbigoplus: '\\u2A01',\n\tbigotimes: '\\u2A02',\n\tbigsqcup: '\\u2A06',\n\tbigstar: '\\u2605',\n\tbigtriangledown: '\\u25BD',\n\tbigtriangleup: '\\u25B3',\n\tbiguplus: '\\u2A04',\n\tbigvee: '\\u22C1',\n\tbigwedge: '\\u22C0',\n\tbkarow: '\\u290D',\n\tblacklozenge: '\\u29EB',\n\tblacksquare: '\\u25AA',\n\tblacktriangle: '\\u25B4',\n\tblacktriangledown: '\\u25BE',\n\tblacktriangleleft: '\\u25C2',\n\tblacktriangleright: '\\u25B8',\n\tblank: '\\u2423',\n\tblk12: '\\u2592',\n\tblk14: '\\u2591',\n\tblk34: '\\u2593',\n\tblock: '\\u2588',\n\tbne: '\\u003D\\u20E5',\n\tbnequiv: '\\u2261\\u20E5',\n\tbNot: '\\u2AED',\n\tbnot: '\\u2310',\n\tBopf: '\\uD835\\uDD39',\n\tbopf: '\\uD835\\uDD53',\n\tbot: '\\u22A5',\n\tbottom: '\\u22A5',\n\tbowtie: '\\u22C8',\n\tboxbox: '\\u29C9',\n\tboxDL: '\\u2557',\n\tboxDl: '\\u2556',\n\tboxdL: '\\u2555',\n\tboxdl: '\\u2510',\n\tboxDR: '\\u2554',\n\tboxDr: '\\u2553',\n\tboxdR: '\\u2552',\n\tboxdr: '\\u250C',\n\tboxH: '\\u2550',\n\tboxh: '\\u2500',\n\tboxHD: '\\u2566',\n\tboxHd: '\\u2564',\n\tboxhD: '\\u2565',\n\tboxhd: '\\u252C',\n\tboxHU: '\\u2569',\n\tboxHu: '\\u2567',\n\tboxhU: '\\u2568',\n\tboxhu: '\\u2534',\n\tboxminus: '\\u229F',\n\tboxplus: '\\u229E',\n\tboxtimes: '\\u22A0',\n\tboxUL: '\\u255D',\n\tboxUl: '\\u255C',\n\tboxuL: '\\u255B',\n\tboxul: '\\u2518',\n\tboxUR: '\\u255A',\n\tboxUr: '\\u2559',\n\tboxuR: '\\u2558',\n\tboxur: '\\u2514',\n\tboxV: '\\u2551',\n\tboxv: '\\u2502',\n\tboxVH: '\\u256C',\n\tboxVh: '\\u256B',\n\tboxvH: '\\u256A',\n\tboxvh: '\\u253C',\n\tboxVL: '\\u2563',\n\tboxVl: '\\u2562',\n\tboxvL: '\\u2561',\n\tboxvl: '\\u2524',\n\tboxVR: '\\u2560',\n\tboxVr: '\\u255F',\n\tboxvR: '\\u255E',\n\tboxvr: '\\u251C',\n\tbprime: '\\u2035',\n\tBreve: '\\u02D8',\n\tbreve: '\\u02D8',\n\tbrvbar: '\\u00A6',\n\tBscr: '\\u212C',\n\tbscr: '\\uD835\\uDCB7',\n\tbsemi: '\\u204F',\n\tbsim: '\\u223D',\n\tbsime: '\\u22CD',\n\tbsol: '\\u005C',\n\tbsolb: '\\u29C5',\n\tbsolhsub: '\\u27C8',\n\tbull: '\\u2022',\n\tbullet: '\\u2022',\n\tbump: '\\u224E',\n\tbumpE: '\\u2AAE',\n\tbumpe: '\\u224F',\n\tBumpeq: '\\u224E',\n\tbumpeq: '\\u224F',\n\tCacute: '\\u0106',\n\tcacute: '\\u0107',\n\tCap: '\\u22D2',\n\tcap: '\\u2229',\n\tcapand: '\\u2A44',\n\tcapbrcup: '\\u2A49',\n\tcapcap: '\\u2A4B',\n\tcapcup: '\\u2A47',\n\tcapdot: '\\u2A40',\n\tCapitalDifferentialD: '\\u2145',\n\tcaps: '\\u2229\\uFE00',\n\tcaret: '\\u2041',\n\tcaron: '\\u02C7',\n\tCayleys: '\\u212D',\n\tccaps: '\\u2A4D',\n\tCcaron: '\\u010C',\n\tccaron: '\\u010D',\n\tCcedil: '\\u00C7',\n\tccedil: '\\u00E7',\n\tCcirc: '\\u0108',\n\tccirc: '\\u0109',\n\tCconint: '\\u2230',\n\tccups: '\\u2A4C',\n\tccupssm: '\\u2A50',\n\tCdot: '\\u010A',\n\tcdot: '\\u010B',\n\tcedil: '\\u00B8',\n\tCedilla: '\\u00B8',\n\tcemptyv: '\\u29B2',\n\tcent: '\\u00A2',\n\tCenterDot: '\\u00B7',\n\tcenterdot: '\\u00B7',\n\tCfr: '\\u212D',\n\tcfr: '\\uD835\\uDD20',\n\tCHcy: '\\u0427',\n\tchcy: '\\u0447',\n\tcheck: '\\u2713',\n\tcheckmark: '\\u2713',\n\tChi: '\\u03A7',\n\tchi: '\\u03C7',\n\tcir: '\\u25CB',\n\tcirc: '\\u02C6',\n\tcirceq: '\\u2257',\n\tcirclearrowleft: '\\u21BA',\n\tcirclearrowright: '\\u21BB',\n\tcircledast: '\\u229B',\n\tcircledcirc: '\\u229A',\n\tcircleddash: '\\u229D',\n\tCircleDot: '\\u2299',\n\tcircledR: '\\u00AE',\n\tcircledS: '\\u24C8',\n\tCircleMinus: '\\u2296',\n\tCirclePlus: '\\u2295',\n\tCircleTimes: '\\u2297',\n\tcirE: '\\u29C3',\n\tcire: '\\u2257',\n\tcirfnint: '\\u2A10',\n\tcirmid: '\\u2AEF',\n\tcirscir: '\\u29C2',\n\tClockwiseContourIntegral: '\\u2232',\n\tCloseCurlyDoubleQuote: '\\u201D',\n\tCloseCurlyQuote: '\\u2019',\n\tclubs: '\\u2663',\n\tclubsuit: '\\u2663',\n\tColon: '\\u2237',\n\tcolon: '\\u003A',\n\tColone: '\\u2A74',\n\tcolone: '\\u2254',\n\tcoloneq: '\\u2254',\n\tcomma: '\\u002C',\n\tcommat: '\\u0040',\n\tcomp: '\\u2201',\n\tcompfn: '\\u2218',\n\tcomplement: '\\u2201',\n\tcomplexes: '\\u2102',\n\tcong: '\\u2245',\n\tcongdot: '\\u2A6D',\n\tCongruent: '\\u2261',\n\tConint: '\\u222F',\n\tconint: '\\u222E',\n\tContourIntegral: '\\u222E',\n\tCopf: '\\u2102',\n\tcopf: '\\uD835\\uDD54',\n\tcoprod: '\\u2210',\n\tCoproduct: '\\u2210',\n\tCOPY: '\\u00A9',\n\tcopy: '\\u00A9',\n\tcopysr: '\\u2117',\n\tCounterClockwiseContourIntegral: '\\u2233',\n\tcrarr: '\\u21B5',\n\tCross: '\\u2A2F',\n\tcross: '\\u2717',\n\tCscr: '\\uD835\\uDC9E',\n\tcscr: '\\uD835\\uDCB8',\n\tcsub: '\\u2ACF',\n\tcsube: '\\u2AD1',\n\tcsup: '\\u2AD0',\n\tcsupe: '\\u2AD2',\n\tctdot: '\\u22EF',\n\tcudarrl: '\\u2938',\n\tcudarrr: '\\u2935',\n\tcuepr: '\\u22DE',\n\tcuesc: '\\u22DF',\n\tcularr: '\\u21B6',\n\tcularrp: '\\u293D',\n\tCup: '\\u22D3',\n\tcup: '\\u222A',\n\tcupbrcap: '\\u2A48',\n\tCupCap: '\\u224D',\n\tcupcap: '\\u2A46',\n\tcupcup: '\\u2A4A',\n\tcupdot: '\\u228D',\n\tcupor: '\\u2A45',\n\tcups: '\\u222A\\uFE00',\n\tcurarr: '\\u21B7',\n\tcurarrm: '\\u293C',\n\tcurlyeqprec: '\\u22DE',\n\tcurlyeqsucc: '\\u22DF',\n\tcurlyvee: '\\u22CE',\n\tcurlywedge: '\\u22CF',\n\tcurren: '\\u00A4',\n\tcurvearrowleft: '\\u21B6',\n\tcurvearrowright: '\\u21B7',\n\tcuvee: '\\u22CE',\n\tcuwed: '\\u22CF',\n\tcwconint: '\\u2232',\n\tcwint: '\\u2231',\n\tcylcty: '\\u232D',\n\tDagger: '\\u2021',\n\tdagger: '\\u2020',\n\tdaleth: '\\u2138',\n\tDarr: '\\u21A1',\n\tdArr: '\\u21D3',\n\tdarr: '\\u2193',\n\tdash: '\\u2010',\n\tDashv: '\\u2AE4',\n\tdashv: '\\u22A3',\n\tdbkarow: '\\u290F',\n\tdblac: '\\u02DD',\n\tDcaron: '\\u010E',\n\tdcaron: '\\u010F',\n\tDcy: '\\u0414',\n\tdcy: '\\u0434',\n\tDD: '\\u2145',\n\tdd: '\\u2146',\n\tddagger: '\\u2021',\n\tddarr: '\\u21CA',\n\tDDotrahd: '\\u2911',\n\tddotseq: '\\u2A77',\n\tdeg: '\\u00B0',\n\tDel: '\\u2207',\n\tDelta: '\\u0394',\n\tdelta: '\\u03B4',\n\tdemptyv: '\\u29B1',\n\tdfisht: '\\u297F',\n\tDfr: '\\uD835\\uDD07',\n\tdfr: '\\uD835\\uDD21',\n\tdHar: '\\u2965',\n\tdharl: '\\u21C3',\n\tdharr: '\\u21C2',\n\tDiacriticalAcute: '\\u00B4',\n\tDiacriticalDot: '\\u02D9',\n\tDiacriticalDoubleAcute: '\\u02DD',\n\tDiacriticalGrave: '\\u0060',\n\tDiacriticalTilde: '\\u02DC',\n\tdiam: '\\u22C4',\n\tDiamond: '\\u22C4',\n\tdiamond: '\\u22C4',\n\tdiamondsuit: '\\u2666',\n\tdiams: '\\u2666',\n\tdie: '\\u00A8',\n\tDifferentialD: '\\u2146',\n\tdigamma: '\\u03DD',\n\tdisin: '\\u22F2',\n\tdiv: '\\u00F7',\n\tdivide: '\\u00F7',\n\tdivideontimes: '\\u22C7',\n\tdivonx: '\\u22C7',\n\tDJcy: '\\u0402',\n\tdjcy: '\\u0452',\n\tdlcorn: '\\u231E',\n\tdlcrop: '\\u230D',\n\tdollar: '\\u0024',\n\tDopf: '\\uD835\\uDD3B',\n\tdopf: '\\uD835\\uDD55',\n\tDot: '\\u00A8',\n\tdot: '\\u02D9',\n\tDotDot: '\\u20DC',\n\tdoteq: '\\u2250',\n\tdoteqdot: '\\u2251',\n\tDotEqual: '\\u2250',\n\tdotminus: '\\u2238',\n\tdotplus: '\\u2214',\n\tdotsquare: '\\u22A1',\n\tdoublebarwedge: '\\u2306',\n\tDoubleContourIntegral: '\\u222F',\n\tDoubleDot: '\\u00A8',\n\tDoubleDownArrow: '\\u21D3',\n\tDoubleLeftArrow: '\\u21D0',\n\tDoubleLeftRightArrow: '\\u21D4',\n\tDoubleLeftTee: '\\u2AE4',\n\tDoubleLongLeftArrow: '\\u27F8',\n\tDoubleLongLeftRightArrow: '\\u27FA',\n\tDoubleLongRightArrow: '\\u27F9',\n\tDoubleRightArrow: '\\u21D2',\n\tDoubleRightTee: '\\u22A8',\n\tDoubleUpArrow: '\\u21D1',\n\tDoubleUpDownArrow: '\\u21D5',\n\tDoubleVerticalBar: '\\u2225',\n\tDownArrow: '\\u2193',\n\tDownarrow: '\\u21D3',\n\tdownarrow: '\\u2193',\n\tDownArrowBar: '\\u2913',\n\tDownArrowUpArrow: '\\u21F5',\n\tDownBreve: '\\u0311',\n\tdowndownarrows: '\\u21CA',\n\tdownharpoonleft: '\\u21C3',\n\tdownharpoonright: '\\u21C2',\n\tDownLeftRightVector: '\\u2950',\n\tDownLeftTeeVector: '\\u295E',\n\tDownLeftVector: '\\u21BD',\n\tDownLeftVectorBar: '\\u2956',\n\tDownRightTeeVector: '\\u295F',\n\tDownRightVector: '\\u21C1',\n\tDownRightVectorBar: '\\u2957',\n\tDownTee: '\\u22A4',\n\tDownTeeArrow: '\\u21A7',\n\tdrbkarow: '\\u2910',\n\tdrcorn: '\\u231F',\n\tdrcrop: '\\u230C',\n\tDscr: '\\uD835\\uDC9F',\n\tdscr: '\\uD835\\uDCB9',\n\tDScy: '\\u0405',\n\tdscy: '\\u0455',\n\tdsol: '\\u29F6',\n\tDstrok: '\\u0110',\n\tdstrok: '\\u0111',\n\tdtdot: '\\u22F1',\n\tdtri: '\\u25BF',\n\tdtrif: '\\u25BE',\n\tduarr: '\\u21F5',\n\tduhar: '\\u296F',\n\tdwangle: '\\u29A6',\n\tDZcy: '\\u040F',\n\tdzcy: '\\u045F',\n\tdzigrarr: '\\u27FF',\n\tEacute: '\\u00C9',\n\teacute: '\\u00E9',\n\teaster: '\\u2A6E',\n\tEcaron: '\\u011A',\n\tecaron: '\\u011B',\n\tecir: '\\u2256',\n\tEcirc: '\\u00CA',\n\tecirc: '\\u00EA',\n\tecolon: '\\u2255',\n\tEcy: '\\u042D',\n\tecy: '\\u044D',\n\teDDot: '\\u2A77',\n\tEdot: '\\u0116',\n\teDot: '\\u2251',\n\tedot: '\\u0117',\n\tee: '\\u2147',\n\tefDot: '\\u2252',\n\tEfr: '\\uD835\\uDD08',\n\tefr: '\\uD835\\uDD22',\n\teg: '\\u2A9A',\n\tEgrave: '\\u00C8',\n\tegrave: '\\u00E8',\n\tegs: '\\u2A96',\n\tegsdot: '\\u2A98',\n\tel: '\\u2A99',\n\tElement: '\\u2208',\n\telinters: '\\u23E7',\n\tell: '\\u2113',\n\tels: '\\u2A95',\n\telsdot: '\\u2A97',\n\tEmacr: '\\u0112',\n\temacr: '\\u0113',\n\tempty: '\\u2205',\n\temptyset: '\\u2205',\n\tEmptySmallSquare: '\\u25FB',\n\temptyv: '\\u2205',\n\tEmptyVerySmallSquare: '\\u25AB',\n\temsp: '\\u2003',\n\temsp13: '\\u2004',\n\temsp14: '\\u2005',\n\tENG: '\\u014A',\n\teng: '\\u014B',\n\tensp: '\\u2002',\n\tEogon: '\\u0118',\n\teogon: '\\u0119',\n\tEopf: '\\uD835\\uDD3C',\n\teopf: '\\uD835\\uDD56',\n\tepar: '\\u22D5',\n\teparsl: '\\u29E3',\n\teplus: '\\u2A71',\n\tepsi: '\\u03B5',\n\tEpsilon: '\\u0395',\n\tepsilon: '\\u03B5',\n\tepsiv: '\\u03F5',\n\teqcirc: '\\u2256',\n\teqcolon: '\\u2255',\n\teqsim: '\\u2242',\n\teqslantgtr: '\\u2A96',\n\teqslantless: '\\u2A95',\n\tEqual: '\\u2A75',\n\tequals: '\\u003D',\n\tEqualTilde: '\\u2242',\n\tequest: '\\u225F',\n\tEquilibrium: '\\u21CC',\n\tequiv: '\\u2261',\n\tequivDD: '\\u2A78',\n\teqvparsl: '\\u29E5',\n\terarr: '\\u2971',\n\terDot: '\\u2253',\n\tEscr: '\\u2130',\n\tescr: '\\u212F',\n\tesdot: '\\u2250',\n\tEsim: '\\u2A73',\n\tesim: '\\u2242',\n\tEta: '\\u0397',\n\teta: '\\u03B7',\n\tETH: '\\u00D0',\n\teth: '\\u00F0',\n\tEuml: '\\u00CB',\n\teuml: '\\u00EB',\n\teuro: '\\u20AC',\n\texcl: '\\u0021',\n\texist: '\\u2203',\n\tExists: '\\u2203',\n\texpectation: '\\u2130',\n\tExponentialE: '\\u2147',\n\texponentiale: '\\u2147',\n\tfallingdotseq: '\\u2252',\n\tFcy: '\\u0424',\n\tfcy: '\\u0444',\n\tfemale: '\\u2640',\n\tffilig: '\\uFB03',\n\tfflig: '\\uFB00',\n\tffllig: '\\uFB04',\n\tFfr: '\\uD835\\uDD09',\n\tffr: '\\uD835\\uDD23',\n\tfilig: '\\uFB01',\n\tFilledSmallSquare: '\\u25FC',\n\tFilledVerySmallSquare: '\\u25AA',\n\tfjlig: '\\u0066\\u006A',\n\tflat: '\\u266D',\n\tfllig: '\\uFB02',\n\tfltns: '\\u25B1',\n\tfnof: '\\u0192',\n\tFopf: '\\uD835\\uDD3D',\n\tfopf: '\\uD835\\uDD57',\n\tForAll: '\\u2200',\n\tforall: '\\u2200',\n\tfork: '\\u22D4',\n\tforkv: '\\u2AD9',\n\tFouriertrf: '\\u2131',\n\tfpartint: '\\u2A0D',\n\tfrac12: '\\u00BD',\n\tfrac13: '\\u2153',\n\tfrac14: '\\u00BC',\n\tfrac15: '\\u2155',\n\tfrac16: '\\u2159',\n\tfrac18: '\\u215B',\n\tfrac23: '\\u2154',\n\tfrac25: '\\u2156',\n\tfrac34: '\\u00BE',\n\tfrac35: '\\u2157',\n\tfrac38: '\\u215C',\n\tfrac45: '\\u2158',\n\tfrac56: '\\u215A',\n\tfrac58: '\\u215D',\n\tfrac78: '\\u215E',\n\tfrasl: '\\u2044',\n\tfrown: '\\u2322',\n\tFscr: '\\u2131',\n\tfscr: '\\uD835\\uDCBB',\n\tgacute: '\\u01F5',\n\tGamma: '\\u0393',\n\tgamma: '\\u03B3',\n\tGammad: '\\u03DC',\n\tgammad: '\\u03DD',\n\tgap: '\\u2A86',\n\tGbreve: '\\u011E',\n\tgbreve: '\\u011F',\n\tGcedil: '\\u0122',\n\tGcirc: '\\u011C',\n\tgcirc: '\\u011D',\n\tGcy: '\\u0413',\n\tgcy: '\\u0433',\n\tGdot: '\\u0120',\n\tgdot: '\\u0121',\n\tgE: '\\u2267',\n\tge: '\\u2265',\n\tgEl: '\\u2A8C',\n\tgel: '\\u22DB',\n\tgeq: '\\u2265',\n\tgeqq: '\\u2267',\n\tgeqslant: '\\u2A7E',\n\tges: '\\u2A7E',\n\tgescc: '\\u2AA9',\n\tgesdot: '\\u2A80',\n\tgesdoto: '\\u2A82',\n\tgesdotol: '\\u2A84',\n\tgesl: '\\u22DB\\uFE00',\n\tgesles: '\\u2A94',\n\tGfr: '\\uD835\\uDD0A',\n\tgfr: '\\uD835\\uDD24',\n\tGg: '\\u22D9',\n\tgg: '\\u226B',\n\tggg: '\\u22D9',\n\tgimel: '\\u2137',\n\tGJcy: '\\u0403',\n\tgjcy: '\\u0453',\n\tgl: '\\u2277',\n\tgla: '\\u2AA5',\n\tglE: '\\u2A92',\n\tglj: '\\u2AA4',\n\tgnap: '\\u2A8A',\n\tgnapprox: '\\u2A8A',\n\tgnE: '\\u2269',\n\tgne: '\\u2A88',\n\tgneq: '\\u2A88',\n\tgneqq: '\\u2269',\n\tgnsim: '\\u22E7',\n\tGopf: '\\uD835\\uDD3E',\n\tgopf: '\\uD835\\uDD58',\n\tgrave: '\\u0060',\n\tGreaterEqual: '\\u2265',\n\tGreaterEqualLess: '\\u22DB',\n\tGreaterFullEqual: '\\u2267',\n\tGreaterGreater: '\\u2AA2',\n\tGreaterLess: '\\u2277',\n\tGreaterSlantEqual: '\\u2A7E',\n\tGreaterTilde: '\\u2273',\n\tGscr: '\\uD835\\uDCA2',\n\tgscr: '\\u210A',\n\tgsim: '\\u2273',\n\tgsime: '\\u2A8E',\n\tgsiml: '\\u2A90',\n\tGt: '\\u226B',\n\tGT: '\\u003E',\n\tgt: '\\u003E',\n\tgtcc: '\\u2AA7',\n\tgtcir: '\\u2A7A',\n\tgtdot: '\\u22D7',\n\tgtlPar: '\\u2995',\n\tgtquest: '\\u2A7C',\n\tgtrapprox: '\\u2A86',\n\tgtrarr: '\\u2978',\n\tgtrdot: '\\u22D7',\n\tgtreqless: '\\u22DB',\n\tgtreqqless: '\\u2A8C',\n\tgtrless: '\\u2277',\n\tgtrsim: '\\u2273',\n\tgvertneqq: '\\u2269\\uFE00',\n\tgvnE: '\\u2269\\uFE00',\n\tHacek: '\\u02C7',\n\thairsp: '\\u200A',\n\thalf: '\\u00BD',\n\thamilt: '\\u210B',\n\tHARDcy: '\\u042A',\n\thardcy: '\\u044A',\n\thArr: '\\u21D4',\n\tharr: '\\u2194',\n\tharrcir: '\\u2948',\n\tharrw: '\\u21AD',\n\tHat: '\\u005E',\n\thbar: '\\u210F',\n\tHcirc: '\\u0124',\n\thcirc: '\\u0125',\n\thearts: '\\u2665',\n\theartsuit: '\\u2665',\n\thellip: '\\u2026',\n\thercon: '\\u22B9',\n\tHfr: '\\u210C',\n\thfr: '\\uD835\\uDD25',\n\tHilbertSpace: '\\u210B',\n\thksearow: '\\u2925',\n\thkswarow: '\\u2926',\n\thoarr: '\\u21FF',\n\thomtht: '\\u223B',\n\thookleftarrow: '\\u21A9',\n\thookrightarrow: '\\u21AA',\n\tHopf: '\\u210D',\n\thopf: '\\uD835\\uDD59',\n\thorbar: '\\u2015',\n\tHorizontalLine: '\\u2500',\n\tHscr: '\\u210B',\n\thscr: '\\uD835\\uDCBD',\n\thslash: '\\u210F',\n\tHstrok: '\\u0126',\n\thstrok: '\\u0127',\n\tHumpDownHump: '\\u224E',\n\tHumpEqual: '\\u224F',\n\thybull: '\\u2043',\n\thyphen: '\\u2010',\n\tIacute: '\\u00CD',\n\tiacute: '\\u00ED',\n\tic: '\\u2063',\n\tIcirc: '\\u00CE',\n\ticirc: '\\u00EE',\n\tIcy: '\\u0418',\n\ticy: '\\u0438',\n\tIdot: '\\u0130',\n\tIEcy: '\\u0415',\n\tiecy: '\\u0435',\n\tiexcl: '\\u00A1',\n\tiff: '\\u21D4',\n\tIfr: '\\u2111',\n\tifr: '\\uD835\\uDD26',\n\tIgrave: '\\u00CC',\n\tigrave: '\\u00EC',\n\tii: '\\u2148',\n\tiiiint: '\\u2A0C',\n\tiiint: '\\u222D',\n\tiinfin: '\\u29DC',\n\tiiota: '\\u2129',\n\tIJlig: '\\u0132',\n\tijlig: '\\u0133',\n\tIm: '\\u2111',\n\tImacr: '\\u012A',\n\timacr: '\\u012B',\n\timage: '\\u2111',\n\tImaginaryI: '\\u2148',\n\timagline: '\\u2110',\n\timagpart: '\\u2111',\n\timath: '\\u0131',\n\timof: '\\u22B7',\n\timped: '\\u01B5',\n\tImplies: '\\u21D2',\n\tin: '\\u2208',\n\tincare: '\\u2105',\n\tinfin: '\\u221E',\n\tinfintie: '\\u29DD',\n\tinodot: '\\u0131',\n\tInt: '\\u222C',\n\tint: '\\u222B',\n\tintcal: '\\u22BA',\n\tintegers: '\\u2124',\n\tIntegral: '\\u222B',\n\tintercal: '\\u22BA',\n\tIntersection: '\\u22C2',\n\tintlarhk: '\\u2A17',\n\tintprod: '\\u2A3C',\n\tInvisibleComma: '\\u2063',\n\tInvisibleTimes: '\\u2062',\n\tIOcy: '\\u0401',\n\tiocy: '\\u0451',\n\tIogon: '\\u012E',\n\tiogon: '\\u012F',\n\tIopf: '\\uD835\\uDD40',\n\tiopf: '\\uD835\\uDD5A',\n\tIota: '\\u0399',\n\tiota: '\\u03B9',\n\tiprod: '\\u2A3C',\n\tiquest: '\\u00BF',\n\tIscr: '\\u2110',\n\tiscr: '\\uD835\\uDCBE',\n\tisin: '\\u2208',\n\tisindot: '\\u22F5',\n\tisinE: '\\u22F9',\n\tisins: '\\u22F4',\n\tisinsv: '\\u22F3',\n\tisinv: '\\u2208',\n\tit: '\\u2062',\n\tItilde: '\\u0128',\n\titilde: '\\u0129',\n\tIukcy: '\\u0406',\n\tiukcy: '\\u0456',\n\tIuml: '\\u00CF',\n\tiuml: '\\u00EF',\n\tJcirc: '\\u0134',\n\tjcirc: '\\u0135',\n\tJcy: '\\u0419',\n\tjcy: '\\u0439',\n\tJfr: '\\uD835\\uDD0D',\n\tjfr: '\\uD835\\uDD27',\n\tjmath: '\\u0237',\n\tJopf: '\\uD835\\uDD41',\n\tjopf: '\\uD835\\uDD5B',\n\tJscr: '\\uD835\\uDCA5',\n\tjscr: '\\uD835\\uDCBF',\n\tJsercy: '\\u0408',\n\tjsercy: '\\u0458',\n\tJukcy: '\\u0404',\n\tjukcy: '\\u0454',\n\tKappa: '\\u039A',\n\tkappa: '\\u03BA',\n\tkappav: '\\u03F0',\n\tKcedil: '\\u0136',\n\tkcedil: '\\u0137',\n\tKcy: '\\u041A',\n\tkcy: '\\u043A',\n\tKfr: '\\uD835\\uDD0E',\n\tkfr: '\\uD835\\uDD28',\n\tkgreen: '\\u0138',\n\tKHcy: '\\u0425',\n\tkhcy: '\\u0445',\n\tKJcy: '\\u040C',\n\tkjcy: '\\u045C',\n\tKopf: '\\uD835\\uDD42',\n\tkopf: '\\uD835\\uDD5C',\n\tKscr: '\\uD835\\uDCA6',\n\tkscr: '\\uD835\\uDCC0',\n\tlAarr: '\\u21DA',\n\tLacute: '\\u0139',\n\tlacute: '\\u013A',\n\tlaemptyv: '\\u29B4',\n\tlagran: '\\u2112',\n\tLambda: '\\u039B',\n\tlambda: '\\u03BB',\n\tLang: '\\u27EA',\n\tlang: '\\u27E8',\n\tlangd: '\\u2991',\n\tlangle: '\\u27E8',\n\tlap: '\\u2A85',\n\tLaplacetrf: '\\u2112',\n\tlaquo: '\\u00AB',\n\tLarr: '\\u219E',\n\tlArr: '\\u21D0',\n\tlarr: '\\u2190',\n\tlarrb: '\\u21E4',\n\tlarrbfs: '\\u291F',\n\tlarrfs: '\\u291D',\n\tlarrhk: '\\u21A9',\n\tlarrlp: '\\u21AB',\n\tlarrpl: '\\u2939',\n\tlarrsim: '\\u2973',\n\tlarrtl: '\\u21A2',\n\tlat: '\\u2AAB',\n\tlAtail: '\\u291B',\n\tlatail: '\\u2919',\n\tlate: '\\u2AAD',\n\tlates: '\\u2AAD\\uFE00',\n\tlBarr: '\\u290E',\n\tlbarr: '\\u290C',\n\tlbbrk: '\\u2772',\n\tlbrace: '\\u007B',\n\tlbrack: '\\u005B',\n\tlbrke: '\\u298B',\n\tlbrksld: '\\u298F',\n\tlbrkslu: '\\u298D',\n\tLcaron: '\\u013D',\n\tlcaron: '\\u013E',\n\tLcedil: '\\u013B',\n\tlcedil: '\\u013C',\n\tlceil: '\\u2308',\n\tlcub: '\\u007B',\n\tLcy: '\\u041B',\n\tlcy: '\\u043B',\n\tldca: '\\u2936',\n\tldquo: '\\u201C',\n\tldquor: '\\u201E',\n\tldrdhar: '\\u2967',\n\tldrushar: '\\u294B',\n\tldsh: '\\u21B2',\n\tlE: '\\u2266',\n\tle: '\\u2264',\n\tLeftAngleBracket: '\\u27E8',\n\tLeftArrow: '\\u2190',\n\tLeftarrow: '\\u21D0',\n\tleftarrow: '\\u2190',\n\tLeftArrowBar: '\\u21E4',\n\tLeftArrowRightArrow: '\\u21C6',\n\tleftarrowtail: '\\u21A2',\n\tLeftCeiling: '\\u2308',\n\tLeftDoubleBracket: '\\u27E6',\n\tLeftDownTeeVector: '\\u2961',\n\tLeftDownVector: '\\u21C3',\n\tLeftDownVectorBar: '\\u2959',\n\tLeftFloor: '\\u230A',\n\tleftharpoondown: '\\u21BD',\n\tleftharpoonup: '\\u21BC',\n\tleftleftarrows: '\\u21C7',\n\tLeftRightArrow: '\\u2194',\n\tLeftrightarrow: '\\u21D4',\n\tleftrightarrow: '\\u2194',\n\tleftrightarrows: '\\u21C6',\n\tleftrightharpoons: '\\u21CB',\n\tleftrightsquigarrow: '\\u21AD',\n\tLeftRightVector: '\\u294E',\n\tLeftTee: '\\u22A3',\n\tLeftTeeArrow: '\\u21A4',\n\tLeftTeeVector: '\\u295A',\n\tleftthreetimes: '\\u22CB',\n\tLeftTriangle: '\\u22B2',\n\tLeftTriangleBar: '\\u29CF',\n\tLeftTriangleEqual: '\\u22B4',\n\tLeftUpDownVector: '\\u2951',\n\tLeftUpTeeVector: '\\u2960',\n\tLeftUpVector: '\\u21BF',\n\tLeftUpVectorBar: '\\u2958',\n\tLeftVector: '\\u21BC',\n\tLeftVectorBar: '\\u2952',\n\tlEg: '\\u2A8B',\n\tleg: '\\u22DA',\n\tleq: '\\u2264',\n\tleqq: '\\u2266',\n\tleqslant: '\\u2A7D',\n\tles: '\\u2A7D',\n\tlescc: '\\u2AA8',\n\tlesdot: '\\u2A7F',\n\tlesdoto: '\\u2A81',\n\tlesdotor: '\\u2A83',\n\tlesg: '\\u22DA\\uFE00',\n\tlesges: '\\u2A93',\n\tlessapprox: '\\u2A85',\n\tlessdot: '\\u22D6',\n\tlesseqgtr: '\\u22DA',\n\tlesseqqgtr: '\\u2A8B',\n\tLessEqualGreater: '\\u22DA',\n\tLessFullEqual: '\\u2266',\n\tLessGreater: '\\u2276',\n\tlessgtr: '\\u2276',\n\tLessLess: '\\u2AA1',\n\tlesssim: '\\u2272',\n\tLessSlantEqual: '\\u2A7D',\n\tLessTilde: '\\u2272',\n\tlfisht: '\\u297C',\n\tlfloor: '\\u230A',\n\tLfr: '\\uD835\\uDD0F',\n\tlfr: '\\uD835\\uDD29',\n\tlg: '\\u2276',\n\tlgE: '\\u2A91',\n\tlHar: '\\u2962',\n\tlhard: '\\u21BD',\n\tlharu: '\\u21BC',\n\tlharul: '\\u296A',\n\tlhblk: '\\u2584',\n\tLJcy: '\\u0409',\n\tljcy: '\\u0459',\n\tLl: '\\u22D8',\n\tll: '\\u226A',\n\tllarr: '\\u21C7',\n\tllcorner: '\\u231E',\n\tLleftarrow: '\\u21DA',\n\tllhard: '\\u296B',\n\tlltri: '\\u25FA',\n\tLmidot: '\\u013F',\n\tlmidot: '\\u0140',\n\tlmoust: '\\u23B0',\n\tlmoustache: '\\u23B0',\n\tlnap: '\\u2A89',\n\tlnapprox: '\\u2A89',\n\tlnE: '\\u2268',\n\tlne: '\\u2A87',\n\tlneq: '\\u2A87',\n\tlneqq: '\\u2268',\n\tlnsim: '\\u22E6',\n\tloang: '\\u27EC',\n\tloarr: '\\u21FD',\n\tlobrk: '\\u27E6',\n\tLongLeftArrow: '\\u27F5',\n\tLongleftarrow: '\\u27F8',\n\tlongleftarrow: '\\u27F5',\n\tLongLeftRightArrow: '\\u27F7',\n\tLongleftrightarrow: '\\u27FA',\n\tlongleftrightarrow: '\\u27F7',\n\tlongmapsto: '\\u27FC',\n\tLongRightArrow: '\\u27F6',\n\tLongrightarrow: '\\u27F9',\n\tlongrightarrow: '\\u27F6',\n\tlooparrowleft: '\\u21AB',\n\tlooparrowright: '\\u21AC',\n\tlopar: '\\u2985',\n\tLopf: '\\uD835\\uDD43',\n\tlopf: '\\uD835\\uDD5D',\n\tloplus: '\\u2A2D',\n\tlotimes: '\\u2A34',\n\tlowast: '\\u2217',\n\tlowbar: '\\u005F',\n\tLowerLeftArrow: '\\u2199',\n\tLowerRightArrow: '\\u2198',\n\tloz: '\\u25CA',\n\tlozenge: '\\u25CA',\n\tlozf: '\\u29EB',\n\tlpar: '\\u0028',\n\tlparlt: '\\u2993',\n\tlrarr: '\\u21C6',\n\tlrcorner: '\\u231F',\n\tlrhar: '\\u21CB',\n\tlrhard: '\\u296D',\n\tlrm: '\\u200E',\n\tlrtri: '\\u22BF',\n\tlsaquo: '\\u2039',\n\tLscr: '\\u2112',\n\tlscr: '\\uD835\\uDCC1',\n\tLsh: '\\u21B0',\n\tlsh: '\\u21B0',\n\tlsim: '\\u2272',\n\tlsime: '\\u2A8D',\n\tlsimg: '\\u2A8F',\n\tlsqb: '\\u005B',\n\tlsquo: '\\u2018',\n\tlsquor: '\\u201A',\n\tLstrok: '\\u0141',\n\tlstrok: '\\u0142',\n\tLt: '\\u226A',\n\tLT: '\\u003C',\n\tlt: '\\u003C',\n\tltcc: '\\u2AA6',\n\tltcir: '\\u2A79',\n\tltdot: '\\u22D6',\n\tlthree: '\\u22CB',\n\tltimes: '\\u22C9',\n\tltlarr: '\\u2976',\n\tltquest: '\\u2A7B',\n\tltri: '\\u25C3',\n\tltrie: '\\u22B4',\n\tltrif: '\\u25C2',\n\tltrPar: '\\u2996',\n\tlurdshar: '\\u294A',\n\tluruhar: '\\u2966',\n\tlvertneqq: '\\u2268\\uFE00',\n\tlvnE: '\\u2268\\uFE00',\n\tmacr: '\\u00AF',\n\tmale: '\\u2642',\n\tmalt: '\\u2720',\n\tmaltese: '\\u2720',\n\tMap: '\\u2905',\n\tmap: '\\u21A6',\n\tmapsto: '\\u21A6',\n\tmapstodown: '\\u21A7',\n\tmapstoleft: '\\u21A4',\n\tmapstoup: '\\u21A5',\n\tmarker: '\\u25AE',\n\tmcomma: '\\u2A29',\n\tMcy: '\\u041C',\n\tmcy: '\\u043C',\n\tmdash: '\\u2014',\n\tmDDot: '\\u223A',\n\tmeasuredangle: '\\u2221',\n\tMediumSpace: '\\u205F',\n\tMellintrf: '\\u2133',\n\tMfr: '\\uD835\\uDD10',\n\tmfr: '\\uD835\\uDD2A',\n\tmho: '\\u2127',\n\tmicro: '\\u00B5',\n\tmid: '\\u2223',\n\tmidast: '\\u002A',\n\tmidcir: '\\u2AF0',\n\tmiddot: '\\u00B7',\n\tminus: '\\u2212',\n\tminusb: '\\u229F',\n\tminusd: '\\u2238',\n\tminusdu: '\\u2A2A',\n\tMinusPlus: '\\u2213',\n\tmlcp: '\\u2ADB',\n\tmldr: '\\u2026',\n\tmnplus: '\\u2213',\n\tmodels: '\\u22A7',\n\tMopf: '\\uD835\\uDD44',\n\tmopf: '\\uD835\\uDD5E',\n\tmp: '\\u2213',\n\tMscr: '\\u2133',\n\tmscr: '\\uD835\\uDCC2',\n\tmstpos: '\\u223E',\n\tMu: '\\u039C',\n\tmu: '\\u03BC',\n\tmultimap: '\\u22B8',\n\tmumap: '\\u22B8',\n\tnabla: '\\u2207',\n\tNacute: '\\u0143',\n\tnacute: '\\u0144',\n\tnang: '\\u2220\\u20D2',\n\tnap: '\\u2249',\n\tnapE: '\\u2A70\\u0338',\n\tnapid: '\\u224B\\u0338',\n\tnapos: '\\u0149',\n\tnapprox: '\\u2249',\n\tnatur: '\\u266E',\n\tnatural: '\\u266E',\n\tnaturals: '\\u2115',\n\tnbsp: '\\u00A0',\n\tnbump: '\\u224E\\u0338',\n\tnbumpe: '\\u224F\\u0338',\n\tncap: '\\u2A43',\n\tNcaron: '\\u0147',\n\tncaron: '\\u0148',\n\tNcedil: '\\u0145',\n\tncedil: '\\u0146',\n\tncong: '\\u2247',\n\tncongdot: '\\u2A6D\\u0338',\n\tncup: '\\u2A42',\n\tNcy: '\\u041D',\n\tncy: '\\u043D',\n\tndash: '\\u2013',\n\tne: '\\u2260',\n\tnearhk: '\\u2924',\n\tneArr: '\\u21D7',\n\tnearr: '\\u2197',\n\tnearrow: '\\u2197',\n\tnedot: '\\u2250\\u0338',\n\tNegativeMediumSpace: '\\u200B',\n\tNegativeThickSpace: '\\u200B',\n\tNegativeThinSpace: '\\u200B',\n\tNegativeVeryThinSpace: '\\u200B',\n\tnequiv: '\\u2262',\n\tnesear: '\\u2928',\n\tnesim: '\\u2242\\u0338',\n\tNestedGreaterGreater: '\\u226B',\n\tNestedLessLess: '\\u226A',\n\tNewLine: '\\u000A',\n\tnexist: '\\u2204',\n\tnexists: '\\u2204',\n\tNfr: '\\uD835\\uDD11',\n\tnfr: '\\uD835\\uDD2B',\n\tngE: '\\u2267\\u0338',\n\tnge: '\\u2271',\n\tngeq: '\\u2271',\n\tngeqq: '\\u2267\\u0338',\n\tngeqslant: '\\u2A7E\\u0338',\n\tnges: '\\u2A7E\\u0338',\n\tnGg: '\\u22D9\\u0338',\n\tngsim: '\\u2275',\n\tnGt: '\\u226B\\u20D2',\n\tngt: '\\u226F',\n\tngtr: '\\u226F',\n\tnGtv: '\\u226B\\u0338',\n\tnhArr: '\\u21CE',\n\tnharr: '\\u21AE',\n\tnhpar: '\\u2AF2',\n\tni: '\\u220B',\n\tnis: '\\u22FC',\n\tnisd: '\\u22FA',\n\tniv: '\\u220B',\n\tNJcy: '\\u040A',\n\tnjcy: '\\u045A',\n\tnlArr: '\\u21CD',\n\tnlarr: '\\u219A',\n\tnldr: '\\u2025',\n\tnlE: '\\u2266\\u0338',\n\tnle: '\\u2270',\n\tnLeftarrow: '\\u21CD',\n\tnleftarrow: '\\u219A',\n\tnLeftrightarrow: '\\u21CE',\n\tnleftrightarrow: '\\u21AE',\n\tnleq: '\\u2270',\n\tnleqq: '\\u2266\\u0338',\n\tnleqslant: '\\u2A7D\\u0338',\n\tnles: '\\u2A7D\\u0338',\n\tnless: '\\u226E',\n\tnLl: '\\u22D8\\u0338',\n\tnlsim: '\\u2274',\n\tnLt: '\\u226A\\u20D2',\n\tnlt: '\\u226E',\n\tnltri: '\\u22EA',\n\tnltrie: '\\u22EC',\n\tnLtv: '\\u226A\\u0338',\n\tnmid: '\\u2224',\n\tNoBreak: '\\u2060',\n\tNonBreakingSpace: '\\u00A0',\n\tNopf: '\\u2115',\n\tnopf: '\\uD835\\uDD5F',\n\tNot: '\\u2AEC',\n\tnot: '\\u00AC',\n\tNotCongruent: '\\u2262',\n\tNotCupCap: '\\u226D',\n\tNotDoubleVerticalBar: '\\u2226',\n\tNotElement: '\\u2209',\n\tNotEqual: '\\u2260',\n\tNotEqualTilde: '\\u2242\\u0338',\n\tNotExists: '\\u2204',\n\tNotGreater: '\\u226F',\n\tNotGreaterEqual: '\\u2271',\n\tNotGreaterFullEqual: '\\u2267\\u0338',\n\tNotGreaterGreater: '\\u226B\\u0338',\n\tNotGreaterLess: '\\u2279',\n\tNotGreaterSlantEqual: '\\u2A7E\\u0338',\n\tNotGreaterTilde: '\\u2275',\n\tNotHumpDownHump: '\\u224E\\u0338',\n\tNotHumpEqual: '\\u224F\\u0338',\n\tnotin: '\\u2209',\n\tnotindot: '\\u22F5\\u0338',\n\tnotinE: '\\u22F9\\u0338',\n\tnotinva: '\\u2209',\n\tnotinvb: '\\u22F7',\n\tnotinvc: '\\u22F6',\n\tNotLeftTriangle: '\\u22EA',\n\tNotLeftTriangleBar: '\\u29CF\\u0338',\n\tNotLeftTriangleEqual: '\\u22EC',\n\tNotLess: '\\u226E',\n\tNotLessEqual: '\\u2270',\n\tNotLessGreater: '\\u2278',\n\tNotLessLess: '\\u226A\\u0338',\n\tNotLessSlantEqual: '\\u2A7D\\u0338',\n\tNotLessTilde: '\\u2274',\n\tNotNestedGreaterGreater: '\\u2AA2\\u0338',\n\tNotNestedLessLess: '\\u2AA1\\u0338',\n\tnotni: '\\u220C',\n\tnotniva: '\\u220C',\n\tnotnivb: '\\u22FE',\n\tnotnivc: '\\u22FD',\n\tNotPrecedes: '\\u2280',\n\tNotPrecedesEqual: '\\u2AAF\\u0338',\n\tNotPrecedesSlantEqual: '\\u22E0',\n\tNotReverseElement: '\\u220C',\n\tNotRightTriangle: '\\u22EB',\n\tNotRightTriangleBar: '\\u29D0\\u0338',\n\tNotRightTriangleEqual: '\\u22ED',\n\tNotSquareSubset: '\\u228F\\u0338',\n\tNotSquareSubsetEqual: '\\u22E2',\n\tNotSquareSuperset: '\\u2290\\u0338',\n\tNotSquareSupersetEqual: '\\u22E3',\n\tNotSubset: '\\u2282\\u20D2',\n\tNotSubsetEqual: '\\u2288',\n\tNotSucceeds: '\\u2281',\n\tNotSucceedsEqual: '\\u2AB0\\u0338',\n\tNotSucceedsSlantEqual: '\\u22E1',\n\tNotSucceedsTilde: '\\u227F\\u0338',\n\tNotSuperset: '\\u2283\\u20D2',\n\tNotSupersetEqual: '\\u2289',\n\tNotTilde: '\\u2241',\n\tNotTildeEqual: '\\u2244',\n\tNotTildeFullEqual: '\\u2247',\n\tNotTildeTilde: '\\u2249',\n\tNotVerticalBar: '\\u2224',\n\tnpar: '\\u2226',\n\tnparallel: '\\u2226',\n\tnparsl: '\\u2AFD\\u20E5',\n\tnpart: '\\u2202\\u0338',\n\tnpolint: '\\u2A14',\n\tnpr: '\\u2280',\n\tnprcue: '\\u22E0',\n\tnpre: '\\u2AAF\\u0338',\n\tnprec: '\\u2280',\n\tnpreceq: '\\u2AAF\\u0338',\n\tnrArr: '\\u21CF',\n\tnrarr: '\\u219B',\n\tnrarrc: '\\u2933\\u0338',\n\tnrarrw: '\\u219D\\u0338',\n\tnRightarrow: '\\u21CF',\n\tnrightarrow: '\\u219B',\n\tnrtri: '\\u22EB',\n\tnrtrie: '\\u22ED',\n\tnsc: '\\u2281',\n\tnsccue: '\\u22E1',\n\tnsce: '\\u2AB0\\u0338',\n\tNscr: '\\uD835\\uDCA9',\n\tnscr: '\\uD835\\uDCC3',\n\tnshortmid: '\\u2224',\n\tnshortparallel: '\\u2226',\n\tnsim: '\\u2241',\n\tnsime: '\\u2244',\n\tnsimeq: '\\u2244',\n\tnsmid: '\\u2224',\n\tnspar: '\\u2226',\n\tnsqsube: '\\u22E2',\n\tnsqsupe: '\\u22E3',\n\tnsub: '\\u2284',\n\tnsubE: '\\u2AC5\\u0338',\n\tnsube: '\\u2288',\n\tnsubset: '\\u2282\\u20D2',\n\tnsubseteq: '\\u2288',\n\tnsubseteqq: '\\u2AC5\\u0338',\n\tnsucc: '\\u2281',\n\tnsucceq: '\\u2AB0\\u0338',\n\tnsup: '\\u2285',\n\tnsupE: '\\u2AC6\\u0338',\n\tnsupe: '\\u2289',\n\tnsupset: '\\u2283\\u20D2',\n\tnsupseteq: '\\u2289',\n\tnsupseteqq: '\\u2AC6\\u0338',\n\tntgl: '\\u2279',\n\tNtilde: '\\u00D1',\n\tntilde: '\\u00F1',\n\tntlg: '\\u2278',\n\tntriangleleft: '\\u22EA',\n\tntrianglelefteq: '\\u22EC',\n\tntriangleright: '\\u22EB',\n\tntrianglerighteq: '\\u22ED',\n\tNu: '\\u039D',\n\tnu: '\\u03BD',\n\tnum: '\\u0023',\n\tnumero: '\\u2116',\n\tnumsp: '\\u2007',\n\tnvap: '\\u224D\\u20D2',\n\tnVDash: '\\u22AF',\n\tnVdash: '\\u22AE',\n\tnvDash: '\\u22AD',\n\tnvdash: '\\u22AC',\n\tnvge: '\\u2265\\u20D2',\n\tnvgt: '\\u003E\\u20D2',\n\tnvHarr: '\\u2904',\n\tnvinfin: '\\u29DE',\n\tnvlArr: '\\u2902',\n\tnvle: '\\u2264\\u20D2',\n\tnvlt: '\\u003C\\u20D2',\n\tnvltrie: '\\u22B4\\u20D2',\n\tnvrArr: '\\u2903',\n\tnvrtrie: '\\u22B5\\u20D2',\n\tnvsim: '\\u223C\\u20D2',\n\tnwarhk: '\\u2923',\n\tnwArr: '\\u21D6',\n\tnwarr: '\\u2196',\n\tnwarrow: '\\u2196',\n\tnwnear: '\\u2927',\n\tOacute: '\\u00D3',\n\toacute: '\\u00F3',\n\toast: '\\u229B',\n\tocir: '\\u229A',\n\tOcirc: '\\u00D4',\n\tocirc: '\\u00F4',\n\tOcy: '\\u041E',\n\tocy: '\\u043E',\n\todash: '\\u229D',\n\tOdblac: '\\u0150',\n\todblac: '\\u0151',\n\todiv: '\\u2A38',\n\todot: '\\u2299',\n\todsold: '\\u29BC',\n\tOElig: '\\u0152',\n\toelig: '\\u0153',\n\tofcir: '\\u29BF',\n\tOfr: '\\uD835\\uDD12',\n\tofr: '\\uD835\\uDD2C',\n\togon: '\\u02DB',\n\tOgrave: '\\u00D2',\n\tograve: '\\u00F2',\n\togt: '\\u29C1',\n\tohbar: '\\u29B5',\n\tohm: '\\u03A9',\n\toint: '\\u222E',\n\tolarr: '\\u21BA',\n\tolcir: '\\u29BE',\n\tolcross: '\\u29BB',\n\toline: '\\u203E',\n\tolt: '\\u29C0',\n\tOmacr: '\\u014C',\n\tomacr: '\\u014D',\n\tOmega: '\\u03A9',\n\tomega: '\\u03C9',\n\tOmicron: '\\u039F',\n\tomicron: '\\u03BF',\n\tomid: '\\u29B6',\n\tominus: '\\u2296',\n\tOopf: '\\uD835\\uDD46',\n\toopf: '\\uD835\\uDD60',\n\topar: '\\u29B7',\n\tOpenCurlyDoubleQuote: '\\u201C',\n\tOpenCurlyQuote: '\\u2018',\n\toperp: '\\u29B9',\n\toplus: '\\u2295',\n\tOr: '\\u2A54',\n\tor: '\\u2228',\n\torarr: '\\u21BB',\n\tord: '\\u2A5D',\n\torder: '\\u2134',\n\torderof: '\\u2134',\n\tordf: '\\u00AA',\n\tordm: '\\u00BA',\n\torigof: '\\u22B6',\n\toror: '\\u2A56',\n\torslope: '\\u2A57',\n\torv: '\\u2A5B',\n\toS: '\\u24C8',\n\tOscr: '\\uD835\\uDCAA',\n\toscr: '\\u2134',\n\tOslash: '\\u00D8',\n\toslash: '\\u00F8',\n\tosol: '\\u2298',\n\tOtilde: '\\u00D5',\n\totilde: '\\u00F5',\n\tOtimes: '\\u2A37',\n\totimes: '\\u2297',\n\totimesas: '\\u2A36',\n\tOuml: '\\u00D6',\n\touml: '\\u00F6',\n\tovbar: '\\u233D',\n\tOverBar: '\\u203E',\n\tOverBrace: '\\u23DE',\n\tOverBracket: '\\u23B4',\n\tOverParenthesis: '\\u23DC',\n\tpar: '\\u2225',\n\tpara: '\\u00B6',\n\tparallel: '\\u2225',\n\tparsim: '\\u2AF3',\n\tparsl: '\\u2AFD',\n\tpart: '\\u2202',\n\tPartialD: '\\u2202',\n\tPcy: '\\u041F',\n\tpcy: '\\u043F',\n\tpercnt: '\\u0025',\n\tperiod: '\\u002E',\n\tpermil: '\\u2030',\n\tperp: '\\u22A5',\n\tpertenk: '\\u2031',\n\tPfr: '\\uD835\\uDD13',\n\tpfr: '\\uD835\\uDD2D',\n\tPhi: '\\u03A6',\n\tphi: '\\u03C6',\n\tphiv: '\\u03D5',\n\tphmmat: '\\u2133',\n\tphone: '\\u260E',\n\tPi: '\\u03A0',\n\tpi: '\\u03C0',\n\tpitchfork: '\\u22D4',\n\tpiv: '\\u03D6',\n\tplanck: '\\u210F',\n\tplanckh: '\\u210E',\n\tplankv: '\\u210F',\n\tplus: '\\u002B',\n\tplusacir: '\\u2A23',\n\tplusb: '\\u229E',\n\tpluscir: '\\u2A22',\n\tplusdo: '\\u2214',\n\tplusdu: '\\u2A25',\n\tpluse: '\\u2A72',\n\tPlusMinus: '\\u00B1',\n\tplusmn: '\\u00B1',\n\tplussim: '\\u2A26',\n\tplustwo: '\\u2A27',\n\tpm: '\\u00B1',\n\tPoincareplane: '\\u210C',\n\tpointint: '\\u2A15',\n\tPopf: '\\u2119',\n\tpopf: '\\uD835\\uDD61',\n\tpound: '\\u00A3',\n\tPr: '\\u2ABB',\n\tpr: '\\u227A',\n\tprap: '\\u2AB7',\n\tprcue: '\\u227C',\n\tprE: '\\u2AB3',\n\tpre: '\\u2AAF',\n\tprec: '\\u227A',\n\tprecapprox: '\\u2AB7',\n\tpreccurlyeq: '\\u227C',\n\tPrecedes: '\\u227A',\n\tPrecedesEqual: '\\u2AAF',\n\tPrecedesSlantEqual: '\\u227C',\n\tPrecedesTilde: '\\u227E',\n\tpreceq: '\\u2AAF',\n\tprecnapprox: '\\u2AB9',\n\tprecneqq: '\\u2AB5',\n\tprecnsim: '\\u22E8',\n\tprecsim: '\\u227E',\n\tPrime: '\\u2033',\n\tprime: '\\u2032',\n\tprimes: '\\u2119',\n\tprnap: '\\u2AB9',\n\tprnE: '\\u2AB5',\n\tprnsim: '\\u22E8',\n\tprod: '\\u220F',\n\tProduct: '\\u220F',\n\tprofalar: '\\u232E',\n\tprofline: '\\u2312',\n\tprofsurf: '\\u2313',\n\tprop: '\\u221D',\n\tProportion: '\\u2237',\n\tProportional: '\\u221D',\n\tpropto: '\\u221D',\n\tprsim: '\\u227E',\n\tprurel: '\\u22B0',\n\tPscr: '\\uD835\\uDCAB',\n\tpscr: '\\uD835\\uDCC5',\n\tPsi: '\\u03A8',\n\tpsi: '\\u03C8',\n\tpuncsp: '\\u2008',\n\tQfr: '\\uD835\\uDD14',\n\tqfr: '\\uD835\\uDD2E',\n\tqint: '\\u2A0C',\n\tQopf: '\\u211A',\n\tqopf: '\\uD835\\uDD62',\n\tqprime: '\\u2057',\n\tQscr: '\\uD835\\uDCAC',\n\tqscr: '\\uD835\\uDCC6',\n\tquaternions: '\\u210D',\n\tquatint: '\\u2A16',\n\tquest: '\\u003F',\n\tquesteq: '\\u225F',\n\tQUOT: '\\u0022',\n\tquot: '\\u0022',\n\trAarr: '\\u21DB',\n\trace: '\\u223D\\u0331',\n\tRacute: '\\u0154',\n\tracute: '\\u0155',\n\tradic: '\\u221A',\n\traemptyv: '\\u29B3',\n\tRang: '\\u27EB',\n\trang: '\\u27E9',\n\trangd: '\\u2992',\n\trange: '\\u29A5',\n\trangle: '\\u27E9',\n\traquo: '\\u00BB',\n\tRarr: '\\u21A0',\n\trArr: '\\u21D2',\n\trarr: '\\u2192',\n\trarrap: '\\u2975',\n\trarrb: '\\u21E5',\n\trarrbfs: '\\u2920',\n\trarrc: '\\u2933',\n\trarrfs: '\\u291E',\n\trarrhk: '\\u21AA',\n\trarrlp: '\\u21AC',\n\trarrpl: '\\u2945',\n\trarrsim: '\\u2974',\n\tRarrtl: '\\u2916',\n\trarrtl: '\\u21A3',\n\trarrw: '\\u219D',\n\trAtail: '\\u291C',\n\tratail: '\\u291A',\n\tratio: '\\u2236',\n\trationals: '\\u211A',\n\tRBarr: '\\u2910',\n\trBarr: '\\u290F',\n\trbarr: '\\u290D',\n\trbbrk: '\\u2773',\n\trbrace: '\\u007D',\n\trbrack: '\\u005D',\n\trbrke: '\\u298C',\n\trbrksld: '\\u298E',\n\trbrkslu: '\\u2990',\n\tRcaron: '\\u0158',\n\trcaron: '\\u0159',\n\tRcedil: '\\u0156',\n\trcedil: '\\u0157',\n\trceil: '\\u2309',\n\trcub: '\\u007D',\n\tRcy: '\\u0420',\n\trcy: '\\u0440',\n\trdca: '\\u2937',\n\trdldhar: '\\u2969',\n\trdquo: '\\u201D',\n\trdquor: '\\u201D',\n\trdsh: '\\u21B3',\n\tRe: '\\u211C',\n\treal: '\\u211C',\n\trealine: '\\u211B',\n\trealpart: '\\u211C',\n\treals: '\\u211D',\n\trect: '\\u25AD',\n\tREG: '\\u00AE',\n\treg: '\\u00AE',\n\tReverseElement: '\\u220B',\n\tReverseEquilibrium: '\\u21CB',\n\tReverseUpEquilibrium: '\\u296F',\n\trfisht: '\\u297D',\n\trfloor: '\\u230B',\n\tRfr: '\\u211C',\n\trfr: '\\uD835\\uDD2F',\n\trHar: '\\u2964',\n\trhard: '\\u21C1',\n\trharu: '\\u21C0',\n\trharul: '\\u296C',\n\tRho: '\\u03A1',\n\trho: '\\u03C1',\n\trhov: '\\u03F1',\n\tRightAngleBracket: '\\u27E9',\n\tRightArrow: '\\u2192',\n\tRightarrow: '\\u21D2',\n\trightarrow: '\\u2192',\n\tRightArrowBar: '\\u21E5',\n\tRightArrowLeftArrow: '\\u21C4',\n\trightarrowtail: '\\u21A3',\n\tRightCeiling: '\\u2309',\n\tRightDoubleBracket: '\\u27E7',\n\tRightDownTeeVector: '\\u295D',\n\tRightDownVector: '\\u21C2',\n\tRightDownVectorBar: '\\u2955',\n\tRightFloor: '\\u230B',\n\trightharpoondown: '\\u21C1',\n\trightharpoonup: '\\u21C0',\n\trightleftarrows: '\\u21C4',\n\trightleftharpoons: '\\u21CC',\n\trightrightarrows: '\\u21C9',\n\trightsquigarrow: '\\u219D',\n\tRightTee: '\\u22A2',\n\tRightTeeArrow: '\\u21A6',\n\tRightTeeVector: '\\u295B',\n\trightthreetimes: '\\u22CC',\n\tRightTriangle: '\\u22B3',\n\tRightTriangleBar: '\\u29D0',\n\tRightTriangleEqual: '\\u22B5',\n\tRightUpDownVector: '\\u294F',\n\tRightUpTeeVector: '\\u295C',\n\tRightUpVector: '\\u21BE',\n\tRightUpVectorBar: '\\u2954',\n\tRightVector: '\\u21C0',\n\tRightVectorBar: '\\u2953',\n\tring: '\\u02DA',\n\trisingdotseq: '\\u2253',\n\trlarr: '\\u21C4',\n\trlhar: '\\u21CC',\n\trlm: '\\u200F',\n\trmoust: '\\u23B1',\n\trmoustache: '\\u23B1',\n\trnmid: '\\u2AEE',\n\troang: '\\u27ED',\n\troarr: '\\u21FE',\n\trobrk: '\\u27E7',\n\tropar: '\\u2986',\n\tRopf: '\\u211D',\n\tropf: '\\uD835\\uDD63',\n\troplus: '\\u2A2E',\n\trotimes: '\\u2A35',\n\tRoundImplies: '\\u2970',\n\trpar: '\\u0029',\n\trpargt: '\\u2994',\n\trppolint: '\\u2A12',\n\trrarr: '\\u21C9',\n\tRrightarrow: '\\u21DB',\n\trsaquo: '\\u203A',\n\tRscr: '\\u211B',\n\trscr: '\\uD835\\uDCC7',\n\tRsh: '\\u21B1',\n\trsh: '\\u21B1',\n\trsqb: '\\u005D',\n\trsquo: '\\u2019',\n\trsquor: '\\u2019',\n\trthree: '\\u22CC',\n\trtimes: '\\u22CA',\n\trtri: '\\u25B9',\n\trtrie: '\\u22B5',\n\trtrif: '\\u25B8',\n\trtriltri: '\\u29CE',\n\tRuleDelayed: '\\u29F4',\n\truluhar: '\\u2968',\n\trx: '\\u211E',\n\tSacute: '\\u015A',\n\tsacute: '\\u015B',\n\tsbquo: '\\u201A',\n\tSc: '\\u2ABC',\n\tsc: '\\u227B',\n\tscap: '\\u2AB8',\n\tScaron: '\\u0160',\n\tscaron: '\\u0161',\n\tsccue: '\\u227D',\n\tscE: '\\u2AB4',\n\tsce: '\\u2AB0',\n\tScedil: '\\u015E',\n\tscedil: '\\u015F',\n\tScirc: '\\u015C',\n\tscirc: '\\u015D',\n\tscnap: '\\u2ABA',\n\tscnE: '\\u2AB6',\n\tscnsim: '\\u22E9',\n\tscpolint: '\\u2A13',\n\tscsim: '\\u227F',\n\tScy: '\\u0421',\n\tscy: '\\u0441',\n\tsdot: '\\u22C5',\n\tsdotb: '\\u22A1',\n\tsdote: '\\u2A66',\n\tsearhk: '\\u2925',\n\tseArr: '\\u21D8',\n\tsearr: '\\u2198',\n\tsearrow: '\\u2198',\n\tsect: '\\u00A7',\n\tsemi: '\\u003B',\n\tseswar: '\\u2929',\n\tsetminus: '\\u2216',\n\tsetmn: '\\u2216',\n\tsext: '\\u2736',\n\tSfr: '\\uD835\\uDD16',\n\tsfr: '\\uD835\\uDD30',\n\tsfrown: '\\u2322',\n\tsharp: '\\u266F',\n\tSHCHcy: '\\u0429',\n\tshchcy: '\\u0449',\n\tSHcy: '\\u0428',\n\tshcy: '\\u0448',\n\tShortDownArrow: '\\u2193',\n\tShortLeftArrow: '\\u2190',\n\tshortmid: '\\u2223',\n\tshortparallel: '\\u2225',\n\tShortRightArrow: '\\u2192',\n\tShortUpArrow: '\\u2191',\n\tshy: '\\u00AD',\n\tSigma: '\\u03A3',\n\tsigma: '\\u03C3',\n\tsigmaf: '\\u03C2',\n\tsigmav: '\\u03C2',\n\tsim: '\\u223C',\n\tsimdot: '\\u2A6A',\n\tsime: '\\u2243',\n\tsimeq: '\\u2243',\n\tsimg: '\\u2A9E',\n\tsimgE: '\\u2AA0',\n\tsiml: '\\u2A9D',\n\tsimlE: '\\u2A9F',\n\tsimne: '\\u2246',\n\tsimplus: '\\u2A24',\n\tsimrarr: '\\u2972',\n\tslarr: '\\u2190',\n\tSmallCircle: '\\u2218',\n\tsmallsetminus: '\\u2216',\n\tsmashp: '\\u2A33',\n\tsmeparsl: '\\u29E4',\n\tsmid: '\\u2223',\n\tsmile: '\\u2323',\n\tsmt: '\\u2AAA',\n\tsmte: '\\u2AAC',\n\tsmtes: '\\u2AAC\\uFE00',\n\tSOFTcy: '\\u042C',\n\tsoftcy: '\\u044C',\n\tsol: '\\u002F',\n\tsolb: '\\u29C4',\n\tsolbar: '\\u233F',\n\tSopf: '\\uD835\\uDD4A',\n\tsopf: '\\uD835\\uDD64',\n\tspades: '\\u2660',\n\tspadesuit: '\\u2660',\n\tspar: '\\u2225',\n\tsqcap: '\\u2293',\n\tsqcaps: '\\u2293\\uFE00',\n\tsqcup: '\\u2294',\n\tsqcups: '\\u2294\\uFE00',\n\tSqrt: '\\u221A',\n\tsqsub: '\\u228F',\n\tsqsube: '\\u2291',\n\tsqsubset: '\\u228F',\n\tsqsubseteq: '\\u2291',\n\tsqsup: '\\u2290',\n\tsqsupe: '\\u2292',\n\tsqsupset: '\\u2290',\n\tsqsupseteq: '\\u2292',\n\tsqu: '\\u25A1',\n\tSquare: '\\u25A1',\n\tsquare: '\\u25A1',\n\tSquareIntersection: '\\u2293',\n\tSquareSubset: '\\u228F',\n\tSquareSubsetEqual: '\\u2291',\n\tSquareSuperset: '\\u2290',\n\tSquareSupersetEqual: '\\u2292',\n\tSquareUnion: '\\u2294',\n\tsquarf: '\\u25AA',\n\tsquf: '\\u25AA',\n\tsrarr: '\\u2192',\n\tSscr: '\\uD835\\uDCAE',\n\tsscr: '\\uD835\\uDCC8',\n\tssetmn: '\\u2216',\n\tssmile: '\\u2323',\n\tsstarf: '\\u22C6',\n\tStar: '\\u22C6',\n\tstar: '\\u2606',\n\tstarf: '\\u2605',\n\tstraightepsilon: '\\u03F5',\n\tstraightphi: '\\u03D5',\n\tstrns: '\\u00AF',\n\tSub: '\\u22D0',\n\tsub: '\\u2282',\n\tsubdot: '\\u2ABD',\n\tsubE: '\\u2AC5',\n\tsube: '\\u2286',\n\tsubedot: '\\u2AC3',\n\tsubmult: '\\u2AC1',\n\tsubnE: '\\u2ACB',\n\tsubne: '\\u228A',\n\tsubplus: '\\u2ABF',\n\tsubrarr: '\\u2979',\n\tSubset: '\\u22D0',\n\tsubset: '\\u2282',\n\tsubseteq: '\\u2286',\n\tsubseteqq: '\\u2AC5',\n\tSubsetEqual: '\\u2286',\n\tsubsetneq: '\\u228A',\n\tsubsetneqq: '\\u2ACB',\n\tsubsim: '\\u2AC7',\n\tsubsub: '\\u2AD5',\n\tsubsup: '\\u2AD3',\n\tsucc: '\\u227B',\n\tsuccapprox: '\\u2AB8',\n\tsucccurlyeq: '\\u227D',\n\tSucceeds: '\\u227B',\n\tSucceedsEqual: '\\u2AB0',\n\tSucceedsSlantEqual: '\\u227D',\n\tSucceedsTilde: '\\u227F',\n\tsucceq: '\\u2AB0',\n\tsuccnapprox: '\\u2ABA',\n\tsuccneqq: '\\u2AB6',\n\tsuccnsim: '\\u22E9',\n\tsuccsim: '\\u227F',\n\tSuchThat: '\\u220B',\n\tSum: '\\u2211',\n\tsum: '\\u2211',\n\tsung: '\\u266A',\n\tSup: '\\u22D1',\n\tsup: '\\u2283',\n\tsup1: '\\u00B9',\n\tsup2: '\\u00B2',\n\tsup3: '\\u00B3',\n\tsupdot: '\\u2ABE',\n\tsupdsub: '\\u2AD8',\n\tsupE: '\\u2AC6',\n\tsupe: '\\u2287',\n\tsupedot: '\\u2AC4',\n\tSuperset: '\\u2283',\n\tSupersetEqual: '\\u2287',\n\tsuphsol: '\\u27C9',\n\tsuphsub: '\\u2AD7',\n\tsuplarr: '\\u297B',\n\tsupmult: '\\u2AC2',\n\tsupnE: '\\u2ACC',\n\tsupne: '\\u228B',\n\tsupplus: '\\u2AC0',\n\tSupset: '\\u22D1',\n\tsupset: '\\u2283',\n\tsupseteq: '\\u2287',\n\tsupseteqq: '\\u2AC6',\n\tsupsetneq: '\\u228B',\n\tsupsetneqq: '\\u2ACC',\n\tsupsim: '\\u2AC8',\n\tsupsub: '\\u2AD4',\n\tsupsup: '\\u2AD6',\n\tswarhk: '\\u2926',\n\tswArr: '\\u21D9',\n\tswarr: '\\u2199',\n\tswarrow: '\\u2199',\n\tswnwar: '\\u292A',\n\tszlig: '\\u00DF',\n\tTab: '\\u0009',\n\ttarget: '\\u2316',\n\tTau: '\\u03A4',\n\ttau: '\\u03C4',\n\ttbrk: '\\u23B4',\n\tTcaron: '\\u0164',\n\ttcaron: '\\u0165',\n\tTcedil: '\\u0162',\n\ttcedil: '\\u0163',\n\tTcy: '\\u0422',\n\ttcy: '\\u0442',\n\ttdot: '\\u20DB',\n\ttelrec: '\\u2315',\n\tTfr: '\\uD835\\uDD17',\n\ttfr: '\\uD835\\uDD31',\n\tthere4: '\\u2234',\n\tTherefore: '\\u2234',\n\ttherefore: '\\u2234',\n\tTheta: '\\u0398',\n\ttheta: '\\u03B8',\n\tthetasym: '\\u03D1',\n\tthetav: '\\u03D1',\n\tthickapprox: '\\u2248',\n\tthicksim: '\\u223C',\n\tThickSpace: '\\u205F\\u200A',\n\tthinsp: '\\u2009',\n\tThinSpace: '\\u2009',\n\tthkap: '\\u2248',\n\tthksim: '\\u223C',\n\tTHORN: '\\u00DE',\n\tthorn: '\\u00FE',\n\tTilde: '\\u223C',\n\ttilde: '\\u02DC',\n\tTildeEqual: '\\u2243',\n\tTildeFullEqual: '\\u2245',\n\tTildeTilde: '\\u2248',\n\ttimes: '\\u00D7',\n\ttimesb: '\\u22A0',\n\ttimesbar: '\\u2A31',\n\ttimesd: '\\u2A30',\n\ttint: '\\u222D',\n\ttoea: '\\u2928',\n\ttop: '\\u22A4',\n\ttopbot: '\\u2336',\n\ttopcir: '\\u2AF1',\n\tTopf: '\\uD835\\uDD4B',\n\ttopf: '\\uD835\\uDD65',\n\ttopfork: '\\u2ADA',\n\ttosa: '\\u2929',\n\ttprime: '\\u2034',\n\tTRADE: '\\u2122',\n\ttrade: '\\u2122',\n\ttriangle: '\\u25B5',\n\ttriangledown: '\\u25BF',\n\ttriangleleft: '\\u25C3',\n\ttrianglelefteq: '\\u22B4',\n\ttriangleq: '\\u225C',\n\ttriangleright: '\\u25B9',\n\ttrianglerighteq: '\\u22B5',\n\ttridot: '\\u25EC',\n\ttrie: '\\u225C',\n\ttriminus: '\\u2A3A',\n\tTripleDot: '\\u20DB',\n\ttriplus: '\\u2A39',\n\ttrisb: '\\u29CD',\n\ttritime: '\\u2A3B',\n\ttrpezium: '\\u23E2',\n\tTscr: '\\uD835\\uDCAF',\n\ttscr: '\\uD835\\uDCC9',\n\tTScy: '\\u0426',\n\ttscy: '\\u0446',\n\tTSHcy: '\\u040B',\n\ttshcy: '\\u045B',\n\tTstrok: '\\u0166',\n\ttstrok: '\\u0167',\n\ttwixt: '\\u226C',\n\ttwoheadleftarrow: '\\u219E',\n\ttwoheadrightarrow: '\\u21A0',\n\tUacute: '\\u00DA',\n\tuacute: '\\u00FA',\n\tUarr: '\\u219F',\n\tuArr: '\\u21D1',\n\tuarr: '\\u2191',\n\tUarrocir: '\\u2949',\n\tUbrcy: '\\u040E',\n\tubrcy: '\\u045E',\n\tUbreve: '\\u016C',\n\tubreve: '\\u016D',\n\tUcirc: '\\u00DB',\n\tucirc: '\\u00FB',\n\tUcy: '\\u0423',\n\tucy: '\\u0443',\n\tudarr: '\\u21C5',\n\tUdblac: '\\u0170',\n\tudblac: '\\u0171',\n\tudhar: '\\u296E',\n\tufisht: '\\u297E',\n\tUfr: '\\uD835\\uDD18',\n\tufr: '\\uD835\\uDD32',\n\tUgrave: '\\u00D9',\n\tugrave: '\\u00F9',\n\tuHar: '\\u2963',\n\tuharl: '\\u21BF',\n\tuharr: '\\u21BE',\n\tuhblk: '\\u2580',\n\tulcorn: '\\u231C',\n\tulcorner: '\\u231C',\n\tulcrop: '\\u230F',\n\tultri: '\\u25F8',\n\tUmacr: '\\u016A',\n\tumacr: '\\u016B',\n\tuml: '\\u00A8',\n\tUnderBar: '\\u005F',\n\tUnderBrace: '\\u23DF',\n\tUnderBracket: '\\u23B5',\n\tUnderParenthesis: '\\u23DD',\n\tUnion: '\\u22C3',\n\tUnionPlus: '\\u228E',\n\tUogon: '\\u0172',\n\tuogon: '\\u0173',\n\tUopf: '\\uD835\\uDD4C',\n\tuopf: '\\uD835\\uDD66',\n\tUpArrow: '\\u2191',\n\tUparrow: '\\u21D1',\n\tuparrow: '\\u2191',\n\tUpArrowBar: '\\u2912',\n\tUpArrowDownArrow: '\\u21C5',\n\tUpDownArrow: '\\u2195',\n\tUpdownarrow: '\\u21D5',\n\tupdownarrow: '\\u2195',\n\tUpEquilibrium: '\\u296E',\n\tupharpoonleft: '\\u21BF',\n\tupharpoonright: '\\u21BE',\n\tuplus: '\\u228E',\n\tUpperLeftArrow: '\\u2196',\n\tUpperRightArrow: '\\u2197',\n\tUpsi: '\\u03D2',\n\tupsi: '\\u03C5',\n\tupsih: '\\u03D2',\n\tUpsilon: '\\u03A5',\n\tupsilon: '\\u03C5',\n\tUpTee: '\\u22A5',\n\tUpTeeArrow: '\\u21A5',\n\tupuparrows: '\\u21C8',\n\turcorn: '\\u231D',\n\turcorner: '\\u231D',\n\turcrop: '\\u230E',\n\tUring: '\\u016E',\n\turing: '\\u016F',\n\turtri: '\\u25F9',\n\tUscr: '\\uD835\\uDCB0',\n\tuscr: '\\uD835\\uDCCA',\n\tutdot: '\\u22F0',\n\tUtilde: '\\u0168',\n\tutilde: '\\u0169',\n\tutri: '\\u25B5',\n\tutrif: '\\u25B4',\n\tuuarr: '\\u21C8',\n\tUuml: '\\u00DC',\n\tuuml: '\\u00FC',\n\tuwangle: '\\u29A7',\n\tvangrt: '\\u299C',\n\tvarepsilon: '\\u03F5',\n\tvarkappa: '\\u03F0',\n\tvarnothing: '\\u2205',\n\tvarphi: '\\u03D5',\n\tvarpi: '\\u03D6',\n\tvarpropto: '\\u221D',\n\tvArr: '\\u21D5',\n\tvarr: '\\u2195',\n\tvarrho: '\\u03F1',\n\tvarsigma: '\\u03C2',\n\tvarsubsetneq: '\\u228A\\uFE00',\n\tvarsubsetneqq: '\\u2ACB\\uFE00',\n\tvarsupsetneq: '\\u228B\\uFE00',\n\tvarsupsetneqq: '\\u2ACC\\uFE00',\n\tvartheta: '\\u03D1',\n\tvartriangleleft: '\\u22B2',\n\tvartriangleright: '\\u22B3',\n\tVbar: '\\u2AEB',\n\tvBar: '\\u2AE8',\n\tvBarv: '\\u2AE9',\n\tVcy: '\\u0412',\n\tvcy: '\\u0432',\n\tVDash: '\\u22AB',\n\tVdash: '\\u22A9',\n\tvDash: '\\u22A8',\n\tvdash: '\\u22A2',\n\tVdashl: '\\u2AE6',\n\tVee: '\\u22C1',\n\tvee: '\\u2228',\n\tveebar: '\\u22BB',\n\tveeeq: '\\u225A',\n\tvellip: '\\u22EE',\n\tVerbar: '\\u2016',\n\tverbar: '\\u007C',\n\tVert: '\\u2016',\n\tvert: '\\u007C',\n\tVerticalBar: '\\u2223',\n\tVerticalLine: '\\u007C',\n\tVerticalSeparator: '\\u2758',\n\tVerticalTilde: '\\u2240',\n\tVeryThinSpace: '\\u200A',\n\tVfr: '\\uD835\\uDD19',\n\tvfr: '\\uD835\\uDD33',\n\tvltri: '\\u22B2',\n\tvnsub: '\\u2282\\u20D2',\n\tvnsup: '\\u2283\\u20D2',\n\tVopf: '\\uD835\\uDD4D',\n\tvopf: '\\uD835\\uDD67',\n\tvprop: '\\u221D',\n\tvrtri: '\\u22B3',\n\tVscr: '\\uD835\\uDCB1',\n\tvscr: '\\uD835\\uDCCB',\n\tvsubnE: '\\u2ACB\\uFE00',\n\tvsubne: '\\u228A\\uFE00',\n\tvsupnE: '\\u2ACC\\uFE00',\n\tvsupne: '\\u228B\\uFE00',\n\tVvdash: '\\u22AA',\n\tvzigzag: '\\u299A',\n\tWcirc: '\\u0174',\n\twcirc: '\\u0175',\n\twedbar: '\\u2A5F',\n\tWedge: '\\u22C0',\n\twedge: '\\u2227',\n\twedgeq: '\\u2259',\n\tweierp: '\\u2118',\n\tWfr: '\\uD835\\uDD1A',\n\twfr: '\\uD835\\uDD34',\n\tWopf: '\\uD835\\uDD4E',\n\twopf: '\\uD835\\uDD68',\n\twp: '\\u2118',\n\twr: '\\u2240',\n\twreath: '\\u2240',\n\tWscr: '\\uD835\\uDCB2',\n\twscr: '\\uD835\\uDCCC',\n\txcap: '\\u22C2',\n\txcirc: '\\u25EF',\n\txcup: '\\u22C3',\n\txdtri: '\\u25BD',\n\tXfr: '\\uD835\\uDD1B',\n\txfr: '\\uD835\\uDD35',\n\txhArr: '\\u27FA',\n\txharr: '\\u27F7',\n\tXi: '\\u039E',\n\txi: '\\u03BE',\n\txlArr: '\\u27F8',\n\txlarr: '\\u27F5',\n\txmap: '\\u27FC',\n\txnis: '\\u22FB',\n\txodot: '\\u2A00',\n\tXopf: '\\uD835\\uDD4F',\n\txopf: '\\uD835\\uDD69',\n\txoplus: '\\u2A01',\n\txotime: '\\u2A02',\n\txrArr: '\\u27F9',\n\txrarr: '\\u27F6',\n\tXscr: '\\uD835\\uDCB3',\n\txscr: '\\uD835\\uDCCD',\n\txsqcup: '\\u2A06',\n\txuplus: '\\u2A04',\n\txutri: '\\u25B3',\n\txvee: '\\u22C1',\n\txwedge: '\\u22C0',\n\tYacute: '\\u00DD',\n\tyacute: '\\u00FD',\n\tYAcy: '\\u042F',\n\tyacy: '\\u044F',\n\tYcirc: '\\u0176',\n\tycirc: '\\u0177',\n\tYcy: '\\u042B',\n\tycy: '\\u044B',\n\tyen: '\\u00A5',\n\tYfr: '\\uD835\\uDD1C',\n\tyfr: '\\uD835\\uDD36',\n\tYIcy: '\\u0407',\n\tyicy: '\\u0457',\n\tYopf: '\\uD835\\uDD50',\n\tyopf: '\\uD835\\uDD6A',\n\tYscr: '\\uD835\\uDCB4',\n\tyscr: '\\uD835\\uDCCE',\n\tYUcy: '\\u042E',\n\tyucy: '\\u044E',\n\tYuml: '\\u0178',\n\tyuml: '\\u00FF',\n\tZacute: '\\u0179',\n\tzacute: '\\u017A',\n\tZcaron: '\\u017D',\n\tzcaron: '\\u017E',\n\tZcy: '\\u0417',\n\tzcy: '\\u0437',\n\tZdot: '\\u017B',\n\tzdot: '\\u017C',\n\tzeetrf: '\\u2128',\n\tZeroWidthSpace: '\\u200B',\n\tZeta: '\\u0396',\n\tzeta: '\\u03B6',\n\tZfr: '\\u2128',\n\tzfr: '\\uD835\\uDD37',\n\tZHcy: '\\u0416',\n\tzhcy: '\\u0436',\n\tzigrarr: '\\u21DD',\n\tZopf: '\\u2124',\n\tzopf: '\\uD835\\uDD6B',\n\tZscr: '\\uD835\\uDCB5',\n\tzscr: '\\uD835\\uDCCF',\n\tzwj: '\\u200D',\n\tzwnj: '\\u200C',\n});\n\n/**\n * @deprecated use `HTML_ENTITIES` instead\n * @see HTML_ENTITIES\n */\nexports.entityMap = exports.HTML_ENTITIES;\n\n\n//# sourceURL=webpack://web/./node_modules/@xmldom/xmldom/lib/entities.js?")},"./node_modules/@xmldom/xmldom/lib/index.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval('var dom = __webpack_require__(/*! ./dom */ "./node_modules/@xmldom/xmldom/lib/dom.js")\nexports.DOMImplementation = dom.DOMImplementation\nexports.XMLSerializer = dom.XMLSerializer\nexports.DOMParser = __webpack_require__(/*! ./dom-parser */ "./node_modules/@xmldom/xmldom/lib/dom-parser.js").DOMParser\n\n\n//# sourceURL=webpack://web/./node_modules/@xmldom/xmldom/lib/index.js?')},"./node_modules/@xmldom/xmldom/lib/sax.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval("var NAMESPACE = (__webpack_require__(/*! ./conventions */ \"./node_modules/@xmldom/xmldom/lib/conventions.js\").NAMESPACE);\n\n//[4]   \tNameStartChar\t   ::=   \t\":\" | [A-Z] | \"_\" | [a-z] | [#xC0-#xD6] | [#xD8-#xF6] | [#xF8-#x2FF] | [#x370-#x37D] | [#x37F-#x1FFF] | [#x200C-#x200D] | [#x2070-#x218F] | [#x2C00-#x2FEF] | [#x3001-#xD7FF] | [#xF900-#xFDCF] | [#xFDF0-#xFFFD] | [#x10000-#xEFFFF]\n//[4a]   \tNameChar\t   ::=   \tNameStartChar | \"-\" | \".\" | [0-9] | #xB7 | [#x0300-#x036F] | [#x203F-#x2040]\n//[5]   \tName\t   ::=   \tNameStartChar (NameChar)*\nvar nameStartChar = /[A-Z_a-z\\xC0-\\xD6\\xD8-\\xF6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD]///\\u10000-\\uEFFFF\nvar nameChar = new RegExp(\"[\\\\-\\\\.0-9\"+nameStartChar.source.slice(1,-1)+\"\\\\u00B7\\\\u0300-\\\\u036F\\\\u203F-\\\\u2040]\");\nvar tagNamePattern = new RegExp('^'+nameStartChar.source+nameChar.source+'*(?:\\:'+nameStartChar.source+nameChar.source+'*)?$');\n//var tagNamePattern = /^[a-zA-Z_][\\w\\-\\.]*(?:\\:[a-zA-Z_][\\w\\-\\.]*)?$/\n//var handlers = 'resolveEntity,getExternalSubset,characters,endDocument,endElement,endPrefixMapping,ignorableWhitespace,processingInstruction,setDocumentLocator,skippedEntity,startDocument,startElement,startPrefixMapping,notationDecl,unparsedEntityDecl,error,fatalError,warning,attributeDecl,elementDecl,externalEntityDecl,internalEntityDecl,comment,endCDATA,endDTD,endEntity,startCDATA,startDTD,startEntity'.split(',')\n\n//S_TAG,\tS_ATTR,\tS_EQ,\tS_ATTR_NOQUOT_VALUE\n//S_ATTR_SPACE,\tS_ATTR_END,\tS_TAG_SPACE, S_TAG_CLOSE\nvar S_TAG = 0;//tag name offerring\nvar S_ATTR = 1;//attr name offerring\nvar S_ATTR_SPACE=2;//attr name end and space offer\nvar S_EQ = 3;//=space?\nvar S_ATTR_NOQUOT_VALUE = 4;//attr value(no quot value only)\nvar S_ATTR_END = 5;//attr value end and no space(quot end)\nvar S_TAG_SPACE = 6;//(attr value end || tag end ) && (space offer)\nvar S_TAG_CLOSE = 7;//closed el<el />\n\n/**\n * Creates an error that will not be caught by XMLReader aka the SAX parser.\n *\n * @param {string} message\n * @param {any?} locator Optional, can provide details about the location in the source\n * @constructor\n */\nfunction ParseError(message, locator) {\n\tthis.message = message\n\tthis.locator = locator\n\tif(Error.captureStackTrace) Error.captureStackTrace(this, ParseError);\n}\nParseError.prototype = new Error();\nParseError.prototype.name = ParseError.name\n\nfunction XMLReader(){\n\n}\n\nXMLReader.prototype = {\n\tparse:function(source,defaultNSMap,entityMap){\n\t\tvar domBuilder = this.domBuilder;\n\t\tdomBuilder.startDocument();\n\t\t_copy(defaultNSMap ,defaultNSMap = {})\n\t\tparse(source,defaultNSMap,entityMap,\n\t\t\t\tdomBuilder,this.errorHandler);\n\t\tdomBuilder.endDocument();\n\t}\n}\nfunction parse(source,defaultNSMapCopy,entityMap,domBuilder,errorHandler){\n\tfunction fixedFromCharCode(code) {\n\t\t// String.prototype.fromCharCode does not supports\n\t\t// > 2 bytes unicode chars directly\n\t\tif (code > 0xffff) {\n\t\t\tcode -= 0x10000;\n\t\t\tvar surrogate1 = 0xd800 + (code >> 10)\n\t\t\t\t, surrogate2 = 0xdc00 + (code & 0x3ff);\n\n\t\t\treturn String.fromCharCode(surrogate1, surrogate2);\n\t\t} else {\n\t\t\treturn String.fromCharCode(code);\n\t\t}\n\t}\n\tfunction entityReplacer(a){\n\t\tvar k = a.slice(1,-1);\n\t\tif (Object.hasOwnProperty.call(entityMap, k)) {\n\t\t\treturn entityMap[k];\n\t\t}else if(k.charAt(0) === '#'){\n\t\t\treturn fixedFromCharCode(parseInt(k.substr(1).replace('x','0x')))\n\t\t}else{\n\t\t\terrorHandler.error('entity not found:'+a);\n\t\t\treturn a;\n\t\t}\n\t}\n\tfunction appendText(end){//has some bugs\n\t\tif(end>start){\n\t\t\tvar xt = source.substring(start,end).replace(/&#?\\w+;/g,entityReplacer);\n\t\t\tlocator&&position(start);\n\t\t\tdomBuilder.characters(xt,0,end-start);\n\t\t\tstart = end\n\t\t}\n\t}\n\tfunction position(p,m){\n\t\twhile(p>=lineEnd && (m = linePattern.exec(source))){\n\t\t\tlineStart = m.index;\n\t\t\tlineEnd = lineStart + m[0].length;\n\t\t\tlocator.lineNumber++;\n\t\t\t//console.log('line++:',locator,startPos,endPos)\n\t\t}\n\t\tlocator.columnNumber = p-lineStart+1;\n\t}\n\tvar lineStart = 0;\n\tvar lineEnd = 0;\n\tvar linePattern = /.*(?:\\r\\n?|\\n)|.*$/g\n\tvar locator = domBuilder.locator;\n\n\tvar parseStack = [{currentNSMap:defaultNSMapCopy}]\n\tvar closeMap = {};\n\tvar start = 0;\n\twhile(true){\n\t\ttry{\n\t\t\tvar tagStart = source.indexOf('<',start);\n\t\t\tif(tagStart<0){\n\t\t\t\tif(!source.substr(start).match(/^\\s*$/)){\n\t\t\t\t\tvar doc = domBuilder.doc;\n\t    \t\t\tvar text = doc.createTextNode(source.substr(start));\n\t    \t\t\tdoc.appendChild(text);\n\t    \t\t\tdomBuilder.currentElement = text;\n\t\t\t\t}\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif(tagStart>start){\n\t\t\t\tappendText(tagStart);\n\t\t\t}\n\t\t\tswitch(source.charAt(tagStart+1)){\n\t\t\tcase '/':\n\t\t\t\tvar end = source.indexOf('>',tagStart+3);\n\t\t\t\tvar tagName = source.substring(tagStart + 2, end).replace(/[ \\t\\n\\r]+$/g, '');\n\t\t\t\tvar config = parseStack.pop();\n\t\t\t\tif(end<0){\n\n\t        \t\ttagName = source.substring(tagStart+2).replace(/[\\s<].*/,'');\n\t        \t\terrorHandler.error(\"end tag name: \"+tagName+' is not complete:'+config.tagName);\n\t        \t\tend = tagStart+1+tagName.length;\n\t        \t}else if(tagName.match(/\\s</)){\n\t        \t\ttagName = tagName.replace(/[\\s<].*/,'');\n\t        \t\terrorHandler.error(\"end tag name: \"+tagName+' maybe not complete');\n\t        \t\tend = tagStart+1+tagName.length;\n\t\t\t\t}\n\t\t\t\tvar localNSMap = config.localNSMap;\n\t\t\t\tvar endMatch = config.tagName == tagName;\n\t\t\t\tvar endIgnoreCaseMach = endMatch || config.tagName&&config.tagName.toLowerCase() == tagName.toLowerCase()\n\t\t        if(endIgnoreCaseMach){\n\t\t        \tdomBuilder.endElement(config.uri,config.localName,tagName);\n\t\t\t\t\tif(localNSMap){\n\t\t\t\t\t\tfor (var prefix in localNSMap) {\n\t\t\t\t\t\t\tif (Object.prototype.hasOwnProperty.call(localNSMap, prefix)) {\n\t\t\t\t\t\t\t\tdomBuilder.endPrefixMapping(prefix);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif(!endMatch){\n\t\t            \terrorHandler.fatalError(\"end tag name: \"+tagName+' is not match the current start tagName:'+config.tagName ); // No known test case\n\t\t\t\t\t}\n\t\t        }else{\n\t\t        \tparseStack.push(config)\n\t\t        }\n\n\t\t\t\tend++;\n\t\t\t\tbreak;\n\t\t\t\t// end elment\n\t\t\tcase '?':// <?...?>\n\t\t\t\tlocator&&position(tagStart);\n\t\t\t\tend = parseInstruction(source,tagStart,domBuilder);\n\t\t\t\tbreak;\n\t\t\tcase '!':// <!doctype,<![CDATA,\x3c!--\n\t\t\t\tlocator&&position(tagStart);\n\t\t\t\tend = parseDCC(source,tagStart,domBuilder,errorHandler);\n\t\t\t\tbreak;\n\t\t\tdefault:\n\t\t\t\tlocator&&position(tagStart);\n\t\t\t\tvar el = new ElementAttributes();\n\t\t\t\tvar currentNSMap = parseStack[parseStack.length-1].currentNSMap;\n\t\t\t\t//elStartEnd\n\t\t\t\tvar end = parseElementStartPart(source,tagStart,el,currentNSMap,entityReplacer,errorHandler);\n\t\t\t\tvar len = el.length;\n\n\n\t\t\t\tif(!el.closed && fixSelfClosed(source,end,el.tagName,closeMap)){\n\t\t\t\t\tel.closed = true;\n\t\t\t\t\tif(!entityMap.nbsp){\n\t\t\t\t\t\terrorHandler.warning('unclosed xml attribute');\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tif(locator && len){\n\t\t\t\t\tvar locator2 = copyLocator(locator,{});\n\t\t\t\t\t//try{//attribute position fixed\n\t\t\t\t\tfor(var i = 0;i<len;i++){\n\t\t\t\t\t\tvar a = el[i];\n\t\t\t\t\t\tposition(a.offset);\n\t\t\t\t\t\ta.locator = copyLocator(locator,{});\n\t\t\t\t\t}\n\t\t\t\t\tdomBuilder.locator = locator2\n\t\t\t\t\tif(appendElement(el,domBuilder,currentNSMap)){\n\t\t\t\t\t\tparseStack.push(el)\n\t\t\t\t\t}\n\t\t\t\t\tdomBuilder.locator = locator;\n\t\t\t\t}else{\n\t\t\t\t\tif(appendElement(el,domBuilder,currentNSMap)){\n\t\t\t\t\t\tparseStack.push(el)\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tif (NAMESPACE.isHTML(el.uri) && !el.closed) {\n\t\t\t\t\tend = parseHtmlSpecialContent(source,end,el.tagName,entityReplacer,domBuilder)\n\t\t\t\t} else {\n\t\t\t\t\tend++;\n\t\t\t\t}\n\t\t\t}\n\t\t}catch(e){\n\t\t\tif (e instanceof ParseError) {\n\t\t\t\tthrow e;\n\t\t\t}\n\t\t\terrorHandler.error('element parse error: '+e)\n\t\t\tend = -1;\n\t\t}\n\t\tif(end>start){\n\t\t\tstart = end;\n\t\t}else{\n\t\t\t//TODO: 这里有可能sax回退，有位置错误风险\n\t\t\tappendText(Math.max(tagStart,start)+1);\n\t\t}\n\t}\n}\nfunction copyLocator(f,t){\n\tt.lineNumber = f.lineNumber;\n\tt.columnNumber = f.columnNumber;\n\treturn t;\n}\n\n/**\n * @see #appendElement(source,elStartEnd,el,selfClosed,entityReplacer,domBuilder,parseStack);\n * @return end of the elementStartPart(end of elementEndPart for selfClosed el)\n */\nfunction parseElementStartPart(source,start,el,currentNSMap,entityReplacer,errorHandler){\n\n\t/**\n\t * @param {string} qname\n\t * @param {string} value\n\t * @param {number} startIndex\n\t */\n\tfunction addAttribute(qname, value, startIndex) {\n\t\tif (el.attributeNames.hasOwnProperty(qname)) {\n\t\t\terrorHandler.fatalError('Attribute ' + qname + ' redefined')\n\t\t}\n\t\tel.addValue(\n\t\t\tqname,\n\t\t\t// @see https://www.w3.org/TR/xml/#AVNormalize\n\t\t\t// since the xmldom sax parser does not \"interpret\" DTD the following is not implemented:\n\t\t\t// - recursive replacement of (DTD) entity references\n\t\t\t// - trimming and collapsing multiple spaces into a single one for attributes that are not of type CDATA\n\t\t\tvalue.replace(/[\\t\\n\\r]/g, ' ').replace(/&#?\\w+;/g, entityReplacer),\n\t\t\tstartIndex\n\t\t)\n\t}\n\tvar attrName;\n\tvar value;\n\tvar p = ++start;\n\tvar s = S_TAG;//status\n\twhile(true){\n\t\tvar c = source.charAt(p);\n\t\tswitch(c){\n\t\tcase '=':\n\t\t\tif(s === S_ATTR){//attrName\n\t\t\t\tattrName = source.slice(start,p);\n\t\t\t\ts = S_EQ;\n\t\t\t}else if(s === S_ATTR_SPACE){\n\t\t\t\ts = S_EQ;\n\t\t\t}else{\n\t\t\t\t//fatalError: equal must after attrName or space after attrName\n\t\t\t\tthrow new Error('attribute equal must after attrName'); // No known test case\n\t\t\t}\n\t\t\tbreak;\n\t\tcase '\\'':\n\t\tcase '\"':\n\t\t\tif(s === S_EQ || s === S_ATTR //|| s == S_ATTR_SPACE\n\t\t\t\t){//equal\n\t\t\t\tif(s === S_ATTR){\n\t\t\t\t\terrorHandler.warning('attribute value must after \"=\"')\n\t\t\t\t\tattrName = source.slice(start,p)\n\t\t\t\t}\n\t\t\t\tstart = p+1;\n\t\t\t\tp = source.indexOf(c,start)\n\t\t\t\tif(p>0){\n\t\t\t\t\tvalue = source.slice(start, p);\n\t\t\t\t\taddAttribute(attrName, value, start-1);\n\t\t\t\t\ts = S_ATTR_END;\n\t\t\t\t}else{\n\t\t\t\t\t//fatalError: no end quot match\n\t\t\t\t\tthrow new Error('attribute value no end \\''+c+'\\' match');\n\t\t\t\t}\n\t\t\t}else if(s == S_ATTR_NOQUOT_VALUE){\n\t\t\t\tvalue = source.slice(start, p);\n\t\t\t\taddAttribute(attrName, value, start);\n\t\t\t\terrorHandler.warning('attribute \"'+attrName+'\" missed start quot('+c+')!!');\n\t\t\t\tstart = p+1;\n\t\t\t\ts = S_ATTR_END\n\t\t\t}else{\n\t\t\t\t//fatalError: no equal before\n\t\t\t\tthrow new Error('attribute value must after \"=\"'); // No known test case\n\t\t\t}\n\t\t\tbreak;\n\t\tcase '/':\n\t\t\tswitch(s){\n\t\t\tcase S_TAG:\n\t\t\t\tel.setTagName(source.slice(start,p));\n\t\t\tcase S_ATTR_END:\n\t\t\tcase S_TAG_SPACE:\n\t\t\tcase S_TAG_CLOSE:\n\t\t\t\ts =S_TAG_CLOSE;\n\t\t\t\tel.closed = true;\n\t\t\tcase S_ATTR_NOQUOT_VALUE:\n\t\t\tcase S_ATTR:\n\t\t\t\tbreak;\n\t\t\t\tcase S_ATTR_SPACE:\n\t\t\t\t\tel.closed = true;\n\t\t\t\tbreak;\n\t\t\t//case S_EQ:\n\t\t\tdefault:\n\t\t\t\tthrow new Error(\"attribute invalid close char('/')\") // No known test case\n\t\t\t}\n\t\t\tbreak;\n\t\tcase ''://end document\n\t\t\terrorHandler.error('unexpected end of input');\n\t\t\tif(s == S_TAG){\n\t\t\t\tel.setTagName(source.slice(start,p));\n\t\t\t}\n\t\t\treturn p;\n\t\tcase '>':\n\t\t\tswitch(s){\n\t\t\tcase S_TAG:\n\t\t\t\tel.setTagName(source.slice(start,p));\n\t\t\tcase S_ATTR_END:\n\t\t\tcase S_TAG_SPACE:\n\t\t\tcase S_TAG_CLOSE:\n\t\t\t\tbreak;//normal\n\t\t\tcase S_ATTR_NOQUOT_VALUE://Compatible state\n\t\t\tcase S_ATTR:\n\t\t\t\tvalue = source.slice(start,p);\n\t\t\t\tif(value.slice(-1) === '/'){\n\t\t\t\t\tel.closed  = true;\n\t\t\t\t\tvalue = value.slice(0,-1)\n\t\t\t\t}\n\t\t\tcase S_ATTR_SPACE:\n\t\t\t\tif(s === S_ATTR_SPACE){\n\t\t\t\t\tvalue = attrName;\n\t\t\t\t}\n\t\t\t\tif(s == S_ATTR_NOQUOT_VALUE){\n\t\t\t\t\terrorHandler.warning('attribute \"'+value+'\" missed quot(\")!');\n\t\t\t\t\taddAttribute(attrName, value, start)\n\t\t\t\t}else{\n\t\t\t\t\tif(!NAMESPACE.isHTML(currentNSMap['']) || !value.match(/^(?:disabled|checked|selected)$/i)){\n\t\t\t\t\t\terrorHandler.warning('attribute \"'+value+'\" missed value!! \"'+value+'\" instead!!')\n\t\t\t\t\t}\n\t\t\t\t\taddAttribute(value, value, start)\n\t\t\t\t}\n\t\t\t\tbreak;\n\t\t\tcase S_EQ:\n\t\t\t\tthrow new Error('attribute value missed!!');\n\t\t\t}\n//\t\t\tconsole.log(tagName,tagNamePattern,tagNamePattern.test(tagName))\n\t\t\treturn p;\n\t\t/*xml space '\\x20' | #x9 | #xD | #xA; */\n\t\tcase '\\u0080':\n\t\t\tc = ' ';\n\t\tdefault:\n\t\t\tif(c<= ' '){//space\n\t\t\t\tswitch(s){\n\t\t\t\tcase S_TAG:\n\t\t\t\t\tel.setTagName(source.slice(start,p));//tagName\n\t\t\t\t\ts = S_TAG_SPACE;\n\t\t\t\t\tbreak;\n\t\t\t\tcase S_ATTR:\n\t\t\t\t\tattrName = source.slice(start,p)\n\t\t\t\t\ts = S_ATTR_SPACE;\n\t\t\t\t\tbreak;\n\t\t\t\tcase S_ATTR_NOQUOT_VALUE:\n\t\t\t\t\tvar value = source.slice(start, p);\n\t\t\t\t\terrorHandler.warning('attribute \"'+value+'\" missed quot(\")!!');\n\t\t\t\t\taddAttribute(attrName, value, start)\n\t\t\t\tcase S_ATTR_END:\n\t\t\t\t\ts = S_TAG_SPACE;\n\t\t\t\t\tbreak;\n\t\t\t\t//case S_TAG_SPACE:\n\t\t\t\t//case S_EQ:\n\t\t\t\t//case S_ATTR_SPACE:\n\t\t\t\t//\tvoid();break;\n\t\t\t\t//case S_TAG_CLOSE:\n\t\t\t\t\t//ignore warning\n\t\t\t\t}\n\t\t\t}else{//not space\n//S_TAG,\tS_ATTR,\tS_EQ,\tS_ATTR_NOQUOT_VALUE\n//S_ATTR_SPACE,\tS_ATTR_END,\tS_TAG_SPACE, S_TAG_CLOSE\n\t\t\t\tswitch(s){\n\t\t\t\t//case S_TAG:void();break;\n\t\t\t\t//case S_ATTR:void();break;\n\t\t\t\t//case S_ATTR_NOQUOT_VALUE:void();break;\n\t\t\t\tcase S_ATTR_SPACE:\n\t\t\t\t\tvar tagName =  el.tagName;\n\t\t\t\t\tif (!NAMESPACE.isHTML(currentNSMap['']) || !attrName.match(/^(?:disabled|checked|selected)$/i)) {\n\t\t\t\t\t\terrorHandler.warning('attribute \"'+attrName+'\" missed value!! \"'+attrName+'\" instead2!!')\n\t\t\t\t\t}\n\t\t\t\t\taddAttribute(attrName, attrName, start);\n\t\t\t\t\tstart = p;\n\t\t\t\t\ts = S_ATTR;\n\t\t\t\t\tbreak;\n\t\t\t\tcase S_ATTR_END:\n\t\t\t\t\terrorHandler.warning('attribute space is required\"'+attrName+'\"!!')\n\t\t\t\tcase S_TAG_SPACE:\n\t\t\t\t\ts = S_ATTR;\n\t\t\t\t\tstart = p;\n\t\t\t\t\tbreak;\n\t\t\t\tcase S_EQ:\n\t\t\t\t\ts = S_ATTR_NOQUOT_VALUE;\n\t\t\t\t\tstart = p;\n\t\t\t\t\tbreak;\n\t\t\t\tcase S_TAG_CLOSE:\n\t\t\t\t\tthrow new Error(\"elements closed character '/' and '>' must be connected to\");\n\t\t\t\t}\n\t\t\t}\n\t\t}//end outer switch\n\t\t//console.log('p++',p)\n\t\tp++;\n\t}\n}\n/**\n * @return true if has new namespace define\n */\nfunction appendElement(el,domBuilder,currentNSMap){\n\tvar tagName = el.tagName;\n\tvar localNSMap = null;\n\t//var currentNSMap = parseStack[parseStack.length-1].currentNSMap;\n\tvar i = el.length;\n\twhile(i--){\n\t\tvar a = el[i];\n\t\tvar qName = a.qName;\n\t\tvar value = a.value;\n\t\tvar nsp = qName.indexOf(':');\n\t\tif(nsp>0){\n\t\t\tvar prefix = a.prefix = qName.slice(0,nsp);\n\t\t\tvar localName = qName.slice(nsp+1);\n\t\t\tvar nsPrefix = prefix === 'xmlns' && localName\n\t\t}else{\n\t\t\tlocalName = qName;\n\t\t\tprefix = null\n\t\t\tnsPrefix = qName === 'xmlns' && ''\n\t\t}\n\t\t//can not set prefix,because prefix !== ''\n\t\ta.localName = localName ;\n\t\t//prefix == null for no ns prefix attribute\n\t\tif(nsPrefix !== false){//hack!!\n\t\t\tif(localNSMap == null){\n\t\t\t\tlocalNSMap = {}\n\t\t\t\t//console.log(currentNSMap,0)\n\t\t\t\t_copy(currentNSMap,currentNSMap={})\n\t\t\t\t//console.log(currentNSMap,1)\n\t\t\t}\n\t\t\tcurrentNSMap[nsPrefix] = localNSMap[nsPrefix] = value;\n\t\t\ta.uri = NAMESPACE.XMLNS\n\t\t\tdomBuilder.startPrefixMapping(nsPrefix, value)\n\t\t}\n\t}\n\tvar i = el.length;\n\twhile(i--){\n\t\ta = el[i];\n\t\tvar prefix = a.prefix;\n\t\tif(prefix){//no prefix attribute has no namespace\n\t\t\tif(prefix === 'xml'){\n\t\t\t\ta.uri = NAMESPACE.XML;\n\t\t\t}if(prefix !== 'xmlns'){\n\t\t\t\ta.uri = currentNSMap[prefix || '']\n\n\t\t\t\t//{console.log('###'+a.qName,domBuilder.locator.systemId+'',currentNSMap,a.uri)}\n\t\t\t}\n\t\t}\n\t}\n\tvar nsp = tagName.indexOf(':');\n\tif(nsp>0){\n\t\tprefix = el.prefix = tagName.slice(0,nsp);\n\t\tlocalName = el.localName = tagName.slice(nsp+1);\n\t}else{\n\t\tprefix = null;//important!!\n\t\tlocalName = el.localName = tagName;\n\t}\n\t//no prefix element has default namespace\n\tvar ns = el.uri = currentNSMap[prefix || ''];\n\tdomBuilder.startElement(ns,localName,tagName,el);\n\t//endPrefixMapping and startPrefixMapping have not any help for dom builder\n\t//localNSMap = null\n\tif(el.closed){\n\t\tdomBuilder.endElement(ns,localName,tagName);\n\t\tif(localNSMap){\n\t\t\tfor (prefix in localNSMap) {\n\t\t\t\tif (Object.prototype.hasOwnProperty.call(localNSMap, prefix)) {\n\t\t\t\t\tdomBuilder.endPrefixMapping(prefix);\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}else{\n\t\tel.currentNSMap = currentNSMap;\n\t\tel.localNSMap = localNSMap;\n\t\t//parseStack.push(el);\n\t\treturn true;\n\t}\n}\nfunction parseHtmlSpecialContent(source,elStartEnd,tagName,entityReplacer,domBuilder){\n\tif(/^(?:script|textarea)$/i.test(tagName)){\n\t\tvar elEndStart =  source.indexOf('</'+tagName+'>',elStartEnd);\n\t\tvar text = source.substring(elStartEnd+1,elEndStart);\n\t\tif(/[&<]/.test(text)){\n\t\t\tif(/^script$/i.test(tagName)){\n\t\t\t\t//if(!/\\]\\]>/.test(text)){\n\t\t\t\t\t//lexHandler.startCDATA();\n\t\t\t\t\tdomBuilder.characters(text,0,text.length);\n\t\t\t\t\t//lexHandler.endCDATA();\n\t\t\t\t\treturn elEndStart;\n\t\t\t\t//}\n\t\t\t}//}else{//text area\n\t\t\t\ttext = text.replace(/&#?\\w+;/g,entityReplacer);\n\t\t\t\tdomBuilder.characters(text,0,text.length);\n\t\t\t\treturn elEndStart;\n\t\t\t//}\n\n\t\t}\n\t}\n\treturn elStartEnd+1;\n}\nfunction fixSelfClosed(source,elStartEnd,tagName,closeMap){\n\t//if(tagName in closeMap){\n\tvar pos = closeMap[tagName];\n\tif(pos == null){\n\t\t//console.log(tagName)\n\t\tpos =  source.lastIndexOf('</'+tagName+'>')\n\t\tif(pos<elStartEnd){//忘记闭合\n\t\t\tpos = source.lastIndexOf('</'+tagName)\n\t\t}\n\t\tcloseMap[tagName] =pos\n\t}\n\treturn pos<elStartEnd;\n\t//}\n}\n\nfunction _copy (source, target) {\n\tfor (var n in source) {\n\t\tif (Object.prototype.hasOwnProperty.call(source, n)) {\n\t\t\ttarget[n] = source[n];\n\t\t}\n\t}\n}\n\nfunction parseDCC(source,start,domBuilder,errorHandler){//sure start with '<!'\n\tvar next= source.charAt(start+2)\n\tswitch(next){\n\tcase '-':\n\t\tif(source.charAt(start + 3) === '-'){\n\t\t\tvar end = source.indexOf('--\x3e',start+4);\n\t\t\t//append comment source.substring(4,end)//\x3c!--\n\t\t\tif(end>start){\n\t\t\t\tdomBuilder.comment(source,start+4,end-start-4);\n\t\t\t\treturn end+3;\n\t\t\t}else{\n\t\t\t\terrorHandler.error(\"Unclosed comment\");\n\t\t\t\treturn -1;\n\t\t\t}\n\t\t}else{\n\t\t\t//error\n\t\t\treturn -1;\n\t\t}\n\tdefault:\n\t\tif(source.substr(start+3,6) == 'CDATA['){\n\t\t\tvar end = source.indexOf(']]>',start+9);\n\t\t\tdomBuilder.startCDATA();\n\t\t\tdomBuilder.characters(source,start+9,end-start-9);\n\t\t\tdomBuilder.endCDATA()\n\t\t\treturn end+3;\n\t\t}\n\t\t//<!DOCTYPE\n\t\t//startDTD(java.lang.String name, java.lang.String publicId, java.lang.String systemId)\n\t\tvar matchs = split(source,start);\n\t\tvar len = matchs.length;\n\t\tif(len>1 && /!doctype/i.test(matchs[0][0])){\n\t\t\tvar name = matchs[1][0];\n\t\t\tvar pubid = false;\n\t\t\tvar sysid = false;\n\t\t\tif(len>3){\n\t\t\t\tif(/^public$/i.test(matchs[2][0])){\n\t\t\t\t\tpubid = matchs[3][0];\n\t\t\t\t\tsysid = len>4 && matchs[4][0];\n\t\t\t\t}else if(/^system$/i.test(matchs[2][0])){\n\t\t\t\t\tsysid = matchs[3][0];\n\t\t\t\t}\n\t\t\t}\n\t\t\tvar lastMatch = matchs[len-1]\n\t\t\tdomBuilder.startDTD(name, pubid, sysid);\n\t\t\tdomBuilder.endDTD();\n\n\t\t\treturn lastMatch.index+lastMatch[0].length\n\t\t}\n\t}\n\treturn -1;\n}\n\n\n\nfunction parseInstruction(source,start,domBuilder){\n\tvar end = source.indexOf('?>',start);\n\tif(end){\n\t\tvar match = source.substring(start,end).match(/^<\\?(\\S*)\\s*([\\s\\S]*?)\\s*$/);\n\t\tif(match){\n\t\t\tvar len = match[0].length;\n\t\t\tdomBuilder.processingInstruction(match[1], match[2]) ;\n\t\t\treturn end+2;\n\t\t}else{//error\n\t\t\treturn -1;\n\t\t}\n\t}\n\treturn -1;\n}\n\nfunction ElementAttributes(){\n\tthis.attributeNames = {}\n}\nElementAttributes.prototype = {\n\tsetTagName:function(tagName){\n\t\tif(!tagNamePattern.test(tagName)){\n\t\t\tthrow new Error('invalid tagName:'+tagName)\n\t\t}\n\t\tthis.tagName = tagName\n\t},\n\taddValue:function(qName, value, offset) {\n\t\tif(!tagNamePattern.test(qName)){\n\t\t\tthrow new Error('invalid attribute:'+qName)\n\t\t}\n\t\tthis.attributeNames[qName] = this.length;\n\t\tthis[this.length++] = {qName:qName,value:value,offset:offset}\n\t},\n\tlength:0,\n\tgetLocalName:function(i){return this[i].localName},\n\tgetLocator:function(i){return this[i].locator},\n\tgetQName:function(i){return this[i].qName},\n\tgetURI:function(i){return this[i].uri},\n\tgetValue:function(i){return this[i].value}\n//\t,getIndex:function(uri, localName)){\n//\t\tif(localName){\n//\n//\t\t}else{\n//\t\t\tvar qName = uri\n//\t\t}\n//\t},\n//\tgetValue:function(){return this.getValue(this.getIndex.apply(this,arguments))},\n//\tgetType:function(uri,localName){}\n//\tgetType:function(i){},\n}\n\n\n\nfunction split(source,start){\n\tvar match;\n\tvar buf = [];\n\tvar reg = /'[^']+'|\"[^\"]+\"|[^\\s<>\\/=]+=?|(\\/?\\s*>|<)/g;\n\treg.lastIndex = start;\n\treg.exec(source);//skip <\n\twhile(match = reg.exec(source)){\n\t\tbuf.push(match);\n\t\tif(match[1])return buf;\n\t}\n}\n\nexports.XMLReader = XMLReader;\nexports.ParseError = ParseError;\n\n\n//# sourceURL=webpack://web/./node_modules/@xmldom/xmldom/lib/sax.js?")},"./node_modules/core-js/modules/_a-function.js":module=>{eval("module.exports = function (it) {\n  if (typeof it != 'function') throw TypeError(it + ' is not a function!');\n  return it;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_a-function.js?")},"./node_modules/core-js/modules/_add-to-unscopables.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 22.1.3.31 Array.prototype[@@unscopables]\nvar UNSCOPABLES = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'unscopables\');\nvar ArrayProto = Array.prototype;\nif (ArrayProto[UNSCOPABLES] == undefined) __webpack_require__(/*! ./_hide */ "./node_modules/core-js/modules/_hide.js")(ArrayProto, UNSCOPABLES, {});\nmodule.exports = function (key) {\n  ArrayProto[UNSCOPABLES][key] = true;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_add-to-unscopables.js?')},"./node_modules/core-js/modules/_advance-string-index.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar at = __webpack_require__(/*! ./_string-at */ "./node_modules/core-js/modules/_string-at.js")(true);\n\n // `AdvanceStringIndex` abstract operation\n// https://tc39.github.io/ecma262/#sec-advancestringindex\nmodule.exports = function (S, index, unicode) {\n  return index + (unicode ? at(S, index).length : 1);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_advance-string-index.js?')},"./node_modules/core-js/modules/_an-object.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var isObject = __webpack_require__(/*! ./_is-object */ \"./node_modules/core-js/modules/_is-object.js\");\nmodule.exports = function (it) {\n  if (!isObject(it)) throw TypeError(it + ' is not an object!');\n  return it;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_an-object.js?")},"./node_modules/core-js/modules/_array-includes.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// false -> Array#indexOf\n// true  -> Array#includes\nvar toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/modules/_to-iobject.js");\nvar toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/modules/_to-length.js");\nvar toAbsoluteIndex = __webpack_require__(/*! ./_to-absolute-index */ "./node_modules/core-js/modules/_to-absolute-index.js");\nmodule.exports = function (IS_INCLUDES) {\n  return function ($this, el, fromIndex) {\n    var O = toIObject($this);\n    var length = toLength(O.length);\n    var index = toAbsoluteIndex(fromIndex, length);\n    var value;\n    // Array#includes uses SameValueZero equality algorithm\n    // eslint-disable-next-line no-self-compare\n    if (IS_INCLUDES && el != el) while (length > index) {\n      value = O[index++];\n      // eslint-disable-next-line no-self-compare\n      if (value != value) return true;\n    // Array#indexOf ignores holes, Array#includes - not\n    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {\n      if (O[index] === el) return IS_INCLUDES || index || 0;\n    } return !IS_INCLUDES && -1;\n  };\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_array-includes.js?')},"./node_modules/core-js/modules/_array-methods.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 0 -> Array#forEach\n// 1 -> Array#map\n// 2 -> Array#filter\n// 3 -> Array#some\n// 4 -> Array#every\n// 5 -> Array#find\n// 6 -> Array#findIndex\nvar ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/modules/_ctx.js");\nvar IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/modules/_iobject.js");\nvar toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/modules/_to-object.js");\nvar toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/modules/_to-length.js");\nvar asc = __webpack_require__(/*! ./_array-species-create */ "./node_modules/core-js/modules/_array-species-create.js");\nmodule.exports = function (TYPE, $create) {\n  var IS_MAP = TYPE == 1;\n  var IS_FILTER = TYPE == 2;\n  var IS_SOME = TYPE == 3;\n  var IS_EVERY = TYPE == 4;\n  var IS_FIND_INDEX = TYPE == 6;\n  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;\n  var create = $create || asc;\n  return function ($this, callbackfn, that) {\n    var O = toObject($this);\n    var self = IObject(O);\n    var f = ctx(callbackfn, that, 3);\n    var length = toLength(self.length);\n    var index = 0;\n    var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;\n    var val, res;\n    for (;length > index; index++) if (NO_HOLES || index in self) {\n      val = self[index];\n      res = f(val, index, O);\n      if (TYPE) {\n        if (IS_MAP) result[index] = res;   // map\n        else if (res) switch (TYPE) {\n          case 3: return true;             // some\n          case 5: return val;              // find\n          case 6: return index;            // findIndex\n          case 2: result.push(val);        // filter\n        } else if (IS_EVERY) return false; // every\n      }\n    }\n    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;\n  };\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_array-methods.js?')},"./node_modules/core-js/modules/_array-reduce.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/modules/_a-function.js");\nvar toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/modules/_to-object.js");\nvar IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/modules/_iobject.js");\nvar toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/modules/_to-length.js");\n\nmodule.exports = function (that, callbackfn, aLen, memo, isRight) {\n  aFunction(callbackfn);\n  var O = toObject(that);\n  var self = IObject(O);\n  var length = toLength(O.length);\n  var index = isRight ? length - 1 : 0;\n  var i = isRight ? -1 : 1;\n  if (aLen < 2) for (;;) {\n    if (index in self) {\n      memo = self[index];\n      index += i;\n      break;\n    }\n    index += i;\n    if (isRight ? index < 0 : length <= index) {\n      throw TypeError(\'Reduce of empty array with no initial value\');\n    }\n  }\n  for (;isRight ? index >= 0 : length > index; index += i) if (index in self) {\n    memo = callbackfn(memo, self[index], index, O);\n  }\n  return memo;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_array-reduce.js?')},"./node_modules/core-js/modules/_array-species-constructor.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/modules/_is-object.js");\nvar isArray = __webpack_require__(/*! ./_is-array */ "./node_modules/core-js/modules/_is-array.js");\nvar SPECIES = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'species\');\n\nmodule.exports = function (original) {\n  var C;\n  if (isArray(original)) {\n    C = original.constructor;\n    // cross-realm fallback\n    if (typeof C == \'function\' && (C === Array || isArray(C.prototype))) C = undefined;\n    if (isObject(C)) {\n      C = C[SPECIES];\n      if (C === null) C = undefined;\n    }\n  } return C === undefined ? Array : C;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_array-species-constructor.js?')},"./node_modules/core-js/modules/_array-species-create.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 9.4.2.3 ArraySpeciesCreate(originalArray, length)\nvar speciesConstructor = __webpack_require__(/*! ./_array-species-constructor */ "./node_modules/core-js/modules/_array-species-constructor.js");\n\nmodule.exports = function (original, length) {\n  return new (speciesConstructor(original))(length);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_array-species-create.js?')},"./node_modules/core-js/modules/_classof.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// getting tag from 19.1.3.6 Object.prototype.toString()\nvar cof = __webpack_require__(/*! ./_cof */ \"./node_modules/core-js/modules/_cof.js\");\nvar TAG = __webpack_require__(/*! ./_wks */ \"./node_modules/core-js/modules/_wks.js\")('toStringTag');\n// ES3 wrong here\nvar ARG = cof(function () { return arguments; }()) == 'Arguments';\n\n// fallback for IE11 Script Access Denied error\nvar tryGet = function (it, key) {\n  try {\n    return it[key];\n  } catch (e) { /* empty */ }\n};\n\nmodule.exports = function (it) {\n  var O, T, B;\n  return it === undefined ? 'Undefined' : it === null ? 'Null'\n    // @@toStringTag case\n    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T\n    // builtinTag case\n    : ARG ? cof(O)\n    // ES3 arguments fallback\n    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_classof.js?")},"./node_modules/core-js/modules/_cof.js":module=>{eval("var toString = {}.toString;\n\nmodule.exports = function (it) {\n  return toString.call(it).slice(8, -1);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_cof.js?")},"./node_modules/core-js/modules/_core.js":module=>{eval("var core = module.exports = { version: '2.6.12' };\nif (typeof __e == 'number') __e = core; // eslint-disable-line no-undef\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_core.js?")},"./node_modules/core-js/modules/_create-property.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar $defineProperty = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js");\nvar createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/modules/_property-desc.js");\n\nmodule.exports = function (object, index, value) {\n  if (index in object) $defineProperty.f(object, index, createDesc(0, value));\n  else object[index] = value;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_create-property.js?')},"./node_modules/core-js/modules/_ctx.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// optional / simple context binding\nvar aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/modules/_a-function.js");\nmodule.exports = function (fn, that, length) {\n  aFunction(fn);\n  if (that === undefined) return fn;\n  switch (length) {\n    case 1: return function (a) {\n      return fn.call(that, a);\n    };\n    case 2: return function (a, b) {\n      return fn.call(that, a, b);\n    };\n    case 3: return function (a, b, c) {\n      return fn.call(that, a, b, c);\n    };\n  }\n  return function (/* ...args */) {\n    return fn.apply(that, arguments);\n  };\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_ctx.js?')},"./node_modules/core-js/modules/_defined.js":module=>{eval('// 7.2.1 RequireObjectCoercible(argument)\nmodule.exports = function (it) {\n  if (it == undefined) throw TypeError("Can\'t call method on  " + it);\n  return it;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_defined.js?')},"./node_modules/core-js/modules/_descriptors.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// Thank's IE8 for his funny defineProperty\nmodule.exports = !__webpack_require__(/*! ./_fails */ \"./node_modules/core-js/modules/_fails.js\")(function () {\n  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_descriptors.js?")},"./node_modules/core-js/modules/_dom-create.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/modules/_is-object.js");\nvar document = (__webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js").document);\n// typeof document.createElement is \'object\' in old IE\nvar is = isObject(document) && isObject(document.createElement);\nmodule.exports = function (it) {\n  return is ? document.createElement(it) : {};\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_dom-create.js?')},"./node_modules/core-js/modules/_enum-bug-keys.js":module=>{eval("// IE 8- don't enum bug keys\nmodule.exports = (\n  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'\n).split(',');\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_enum-bug-keys.js?")},"./node_modules/core-js/modules/_enum-keys.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// all enumerable object keys, includes symbols\nvar getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/modules/_object-keys.js");\nvar gOPS = __webpack_require__(/*! ./_object-gops */ "./node_modules/core-js/modules/_object-gops.js");\nvar pIE = __webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/modules/_object-pie.js");\nmodule.exports = function (it) {\n  var result = getKeys(it);\n  var getSymbols = gOPS.f;\n  if (getSymbols) {\n    var symbols = getSymbols(it);\n    var isEnum = pIE.f;\n    var i = 0;\n    var key;\n    while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);\n  } return result;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_enum-keys.js?')},"./node_modules/core-js/modules/_export.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js");\nvar core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/modules/_core.js");\nvar hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/modules/_hide.js");\nvar redefine = __webpack_require__(/*! ./_redefine */ "./node_modules/core-js/modules/_redefine.js");\nvar ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/modules/_ctx.js");\nvar PROTOTYPE = \'prototype\';\n\nvar $export = function (type, name, source) {\n  var IS_FORCED = type & $export.F;\n  var IS_GLOBAL = type & $export.G;\n  var IS_STATIC = type & $export.S;\n  var IS_PROTO = type & $export.P;\n  var IS_BIND = type & $export.B;\n  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE];\n  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});\n  var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});\n  var key, own, out, exp;\n  if (IS_GLOBAL) source = name;\n  for (key in source) {\n    // contains in native\n    own = !IS_FORCED && target && target[key] !== undefined;\n    // export native or passed\n    out = (own ? target : source)[key];\n    // bind timers to global for call from export context\n    exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && typeof out == \'function\' ? ctx(Function.call, out) : out;\n    // extend global\n    if (target) redefine(target, key, out, type & $export.U);\n    // export\n    if (exports[key] != out) hide(exports, key, exp);\n    if (IS_PROTO && expProto[key] != out) expProto[key] = out;\n  }\n};\nglobal.core = core;\n// type bitmap\n$export.F = 1;   // forced\n$export.G = 2;   // global\n$export.S = 4;   // static\n$export.P = 8;   // proto\n$export.B = 16;  // bind\n$export.W = 32;  // wrap\n$export.U = 64;  // safe\n$export.R = 128; // real proto method for `library`\nmodule.exports = $export;\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_export.js?')},"./node_modules/core-js/modules/_fails.js":module=>{eval("module.exports = function (exec) {\n  try {\n    return !!exec();\n  } catch (e) {\n    return true;\n  }\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_fails.js?")},"./node_modules/core-js/modules/_fix-re-wks.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n__webpack_require__(/*! ./es6.regexp.exec */ \"./node_modules/core-js/modules/es6.regexp.exec.js\");\nvar redefine = __webpack_require__(/*! ./_redefine */ \"./node_modules/core-js/modules/_redefine.js\");\nvar hide = __webpack_require__(/*! ./_hide */ \"./node_modules/core-js/modules/_hide.js\");\nvar fails = __webpack_require__(/*! ./_fails */ \"./node_modules/core-js/modules/_fails.js\");\nvar defined = __webpack_require__(/*! ./_defined */ \"./node_modules/core-js/modules/_defined.js\");\nvar wks = __webpack_require__(/*! ./_wks */ \"./node_modules/core-js/modules/_wks.js\");\nvar regexpExec = __webpack_require__(/*! ./_regexp-exec */ \"./node_modules/core-js/modules/_regexp-exec.js\");\n\nvar SPECIES = wks('species');\n\nvar REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function () {\n  // #replace needs built-in support for named groups.\n  // #match works fine because it just return the exec results, even if it has\n  // a \"grops\" property.\n  var re = /./;\n  re.exec = function () {\n    var result = [];\n    result.groups = { a: '7' };\n    return result;\n  };\n  return ''.replace(re, '$<a>') !== '7';\n});\n\nvar SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = (function () {\n  // Chrome 51 has a buggy \"split\" implementation when RegExp#exec !== nativeExec\n  var re = /(?:)/;\n  var originalExec = re.exec;\n  re.exec = function () { return originalExec.apply(this, arguments); };\n  var result = 'ab'.split(re);\n  return result.length === 2 && result[0] === 'a' && result[1] === 'b';\n})();\n\nmodule.exports = function (KEY, length, exec) {\n  var SYMBOL = wks(KEY);\n\n  var DELEGATES_TO_SYMBOL = !fails(function () {\n    // String methods call symbol-named RegEp methods\n    var O = {};\n    O[SYMBOL] = function () { return 7; };\n    return ''[KEY](O) != 7;\n  });\n\n  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL ? !fails(function () {\n    // Symbol-named RegExp methods call .exec\n    var execCalled = false;\n    var re = /a/;\n    re.exec = function () { execCalled = true; return null; };\n    if (KEY === 'split') {\n      // RegExp[@@split] doesn't call the regex's exec method, but first creates\n      // a new one. We need to return the patched regex when creating the new one.\n      re.constructor = {};\n      re.constructor[SPECIES] = function () { return re; };\n    }\n    re[SYMBOL]('');\n    return !execCalled;\n  }) : undefined;\n\n  if (\n    !DELEGATES_TO_SYMBOL ||\n    !DELEGATES_TO_EXEC ||\n    (KEY === 'replace' && !REPLACE_SUPPORTS_NAMED_GROUPS) ||\n    (KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC)\n  ) {\n    var nativeRegExpMethod = /./[SYMBOL];\n    var fns = exec(\n      defined,\n      SYMBOL,\n      ''[KEY],\n      function maybeCallNative(nativeMethod, regexp, str, arg2, forceStringMethod) {\n        if (regexp.exec === regexpExec) {\n          if (DELEGATES_TO_SYMBOL && !forceStringMethod) {\n            // The native String method already delegates to @@method (this\n            // polyfilled function), leasing to infinite recursion.\n            // We avoid it by directly calling the native @@method method.\n            return { done: true, value: nativeRegExpMethod.call(regexp, str, arg2) };\n          }\n          return { done: true, value: nativeMethod.call(str, regexp, arg2) };\n        }\n        return { done: false };\n      }\n    );\n    var strfn = fns[0];\n    var rxfn = fns[1];\n\n    redefine(String.prototype, KEY, strfn);\n    hide(RegExp.prototype, SYMBOL, length == 2\n      // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)\n      // 21.2.5.11 RegExp.prototype[@@split](string, limit)\n      ? function (string, arg) { return rxfn.call(string, this, arg); }\n      // 21.2.5.6 RegExp.prototype[@@match](string)\n      // 21.2.5.9 RegExp.prototype[@@search](string)\n      : function (string) { return rxfn.call(string, this); }\n    );\n  }\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_fix-re-wks.js?")},"./node_modules/core-js/modules/_flags.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n// 21.2.5.3 get RegExp.prototype.flags\nvar anObject = __webpack_require__(/*! ./_an-object */ \"./node_modules/core-js/modules/_an-object.js\");\nmodule.exports = function () {\n  var that = anObject(this);\n  var result = '';\n  if (that.global) result += 'g';\n  if (that.ignoreCase) result += 'i';\n  if (that.multiline) result += 'm';\n  if (that.unicode) result += 'u';\n  if (that.sticky) result += 'y';\n  return result;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_flags.js?")},"./node_modules/core-js/modules/_function-to-string.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("module.exports = __webpack_require__(/*! ./_shared */ \"./node_modules/core-js/modules/_shared.js\")('native-function-to-string', Function.toString);\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_function-to-string.js?")},"./node_modules/core-js/modules/_global.js":module=>{eval("// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028\nvar global = module.exports = typeof window != 'undefined' && window.Math == Math\n  ? window : typeof self != 'undefined' && self.Math == Math ? self\n  // eslint-disable-next-line no-new-func\n  : Function('return this')();\nif (typeof __g == 'number') __g = global; // eslint-disable-line no-undef\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_global.js?")},"./node_modules/core-js/modules/_has.js":module=>{eval("var hasOwnProperty = {}.hasOwnProperty;\nmodule.exports = function (it, key) {\n  return hasOwnProperty.call(it, key);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_has.js?")},"./node_modules/core-js/modules/_hide.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js");\nvar createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/modules/_property-desc.js");\nmodule.exports = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js") ? function (object, key, value) {\n  return dP.f(object, key, createDesc(1, value));\n} : function (object, key, value) {\n  object[key] = value;\n  return object;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_hide.js?')},"./node_modules/core-js/modules/_html.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var document = (__webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js").document);\nmodule.exports = document && document.documentElement;\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_html.js?')},"./node_modules/core-js/modules/_ie8-dom-define.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('module.exports = !__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js") && !__webpack_require__(/*! ./_fails */ "./node_modules/core-js/modules/_fails.js")(function () {\n  return Object.defineProperty(__webpack_require__(/*! ./_dom-create */ "./node_modules/core-js/modules/_dom-create.js")(\'div\'), \'a\', { get: function () { return 7; } }).a != 7;\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_ie8-dom-define.js?')},"./node_modules/core-js/modules/_inherit-if-required.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/modules/_is-object.js");\nvar setPrototypeOf = (__webpack_require__(/*! ./_set-proto */ "./node_modules/core-js/modules/_set-proto.js").set);\nmodule.exports = function (that, target, C) {\n  var S = target.constructor;\n  var P;\n  if (S !== C && typeof S == \'function\' && (P = S.prototype) !== C.prototype && isObject(P) && setPrototypeOf) {\n    setPrototypeOf(that, P);\n  } return that;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_inherit-if-required.js?')},"./node_modules/core-js/modules/_iobject.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// fallback for non-array-like ES3 and non-enumerable old V8 strings\nvar cof = __webpack_require__(/*! ./_cof */ \"./node_modules/core-js/modules/_cof.js\");\n// eslint-disable-next-line no-prototype-builtins\nmodule.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {\n  return cof(it) == 'String' ? it.split('') : Object(it);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_iobject.js?")},"./node_modules/core-js/modules/_is-array-iter.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// check on default Array iterator\nvar Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/modules/_iterators.js");\nvar ITERATOR = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'iterator\');\nvar ArrayProto = Array.prototype;\n\nmodule.exports = function (it) {\n  return it !== undefined && (Iterators.Array === it || ArrayProto[ITERATOR] === it);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_is-array-iter.js?')},"./node_modules/core-js/modules/_is-array.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// 7.2.2 IsArray(argument)\nvar cof = __webpack_require__(/*! ./_cof */ \"./node_modules/core-js/modules/_cof.js\");\nmodule.exports = Array.isArray || function isArray(arg) {\n  return cof(arg) == 'Array';\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_is-array.js?")},"./node_modules/core-js/modules/_is-object.js":module=>{eval("module.exports = function (it) {\n  return typeof it === 'object' ? it !== null : typeof it === 'function';\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_is-object.js?")},"./node_modules/core-js/modules/_is-regexp.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 7.2.8 IsRegExp(argument)\nvar isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/modules/_is-object.js");\nvar cof = __webpack_require__(/*! ./_cof */ "./node_modules/core-js/modules/_cof.js");\nvar MATCH = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'match\');\nmodule.exports = function (it) {\n  var isRegExp;\n  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == \'RegExp\');\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_is-regexp.js?')},"./node_modules/core-js/modules/_iter-call.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// call something on iterator step with safe closing on error\nvar anObject = __webpack_require__(/*! ./_an-object */ \"./node_modules/core-js/modules/_an-object.js\");\nmodule.exports = function (iterator, fn, value, entries) {\n  try {\n    return entries ? fn(anObject(value)[0], value[1]) : fn(value);\n  // 7.4.6 IteratorClose(iterator, completion)\n  } catch (e) {\n    var ret = iterator['return'];\n    if (ret !== undefined) anObject(ret.call(iterator));\n    throw e;\n  }\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_iter-call.js?")},"./node_modules/core-js/modules/_iter-create.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar create = __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/modules/_object-create.js");\nvar descriptor = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/modules/_property-desc.js");\nvar setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/modules/_set-to-string-tag.js");\nvar IteratorPrototype = {};\n\n// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()\n__webpack_require__(/*! ./_hide */ "./node_modules/core-js/modules/_hide.js")(IteratorPrototype, __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'iterator\'), function () { return this; });\n\nmodule.exports = function (Constructor, NAME, next) {\n  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });\n  setToStringTag(Constructor, NAME + \' Iterator\');\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_iter-create.js?')},"./node_modules/core-js/modules/_iter-define.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\nvar LIBRARY = __webpack_require__(/*! ./_library */ \"./node_modules/core-js/modules/_library.js\");\nvar $export = __webpack_require__(/*! ./_export */ \"./node_modules/core-js/modules/_export.js\");\nvar redefine = __webpack_require__(/*! ./_redefine */ \"./node_modules/core-js/modules/_redefine.js\");\nvar hide = __webpack_require__(/*! ./_hide */ \"./node_modules/core-js/modules/_hide.js\");\nvar Iterators = __webpack_require__(/*! ./_iterators */ \"./node_modules/core-js/modules/_iterators.js\");\nvar $iterCreate = __webpack_require__(/*! ./_iter-create */ \"./node_modules/core-js/modules/_iter-create.js\");\nvar setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ \"./node_modules/core-js/modules/_set-to-string-tag.js\");\nvar getPrototypeOf = __webpack_require__(/*! ./_object-gpo */ \"./node_modules/core-js/modules/_object-gpo.js\");\nvar ITERATOR = __webpack_require__(/*! ./_wks */ \"./node_modules/core-js/modules/_wks.js\")('iterator');\nvar BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`\nvar FF_ITERATOR = '@@iterator';\nvar KEYS = 'keys';\nvar VALUES = 'values';\n\nvar returnThis = function () { return this; };\n\nmodule.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {\n  $iterCreate(Constructor, NAME, next);\n  var getMethod = function (kind) {\n    if (!BUGGY && kind in proto) return proto[kind];\n    switch (kind) {\n      case KEYS: return function keys() { return new Constructor(this, kind); };\n      case VALUES: return function values() { return new Constructor(this, kind); };\n    } return function entries() { return new Constructor(this, kind); };\n  };\n  var TAG = NAME + ' Iterator';\n  var DEF_VALUES = DEFAULT == VALUES;\n  var VALUES_BUG = false;\n  var proto = Base.prototype;\n  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];\n  var $default = $native || getMethod(DEFAULT);\n  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;\n  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;\n  var methods, key, IteratorPrototype;\n  // Fix native\n  if ($anyNative) {\n    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));\n    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {\n      // Set @@toStringTag to native iterators\n      setToStringTag(IteratorPrototype, TAG, true);\n      // fix for some old engines\n      if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') hide(IteratorPrototype, ITERATOR, returnThis);\n    }\n  }\n  // fix Array#{values, @@iterator}.name in V8 / FF\n  if (DEF_VALUES && $native && $native.name !== VALUES) {\n    VALUES_BUG = true;\n    $default = function values() { return $native.call(this); };\n  }\n  // Define iterator\n  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {\n    hide(proto, ITERATOR, $default);\n  }\n  // Plug for library\n  Iterators[NAME] = $default;\n  Iterators[TAG] = returnThis;\n  if (DEFAULT) {\n    methods = {\n      values: DEF_VALUES ? $default : getMethod(VALUES),\n      keys: IS_SET ? $default : getMethod(KEYS),\n      entries: $entries\n    };\n    if (FORCED) for (key in methods) {\n      if (!(key in proto)) redefine(proto, key, methods[key]);\n    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);\n  }\n  return methods;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_iter-define.js?")},"./node_modules/core-js/modules/_iter-detect.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var ITERATOR = __webpack_require__(/*! ./_wks */ \"./node_modules/core-js/modules/_wks.js\")('iterator');\nvar SAFE_CLOSING = false;\n\ntry {\n  var riter = [7][ITERATOR]();\n  riter['return'] = function () { SAFE_CLOSING = true; };\n  // eslint-disable-next-line no-throw-literal\n  Array.from(riter, function () { throw 2; });\n} catch (e) { /* empty */ }\n\nmodule.exports = function (exec, skipClosing) {\n  if (!skipClosing && !SAFE_CLOSING) return false;\n  var safe = false;\n  try {\n    var arr = [7];\n    var iter = arr[ITERATOR]();\n    iter.next = function () { return { done: safe = true }; };\n    arr[ITERATOR] = function () { return iter; };\n    exec(arr);\n  } catch (e) { /* empty */ }\n  return safe;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_iter-detect.js?")},"./node_modules/core-js/modules/_iter-step.js":module=>{eval("module.exports = function (done, value) {\n  return { value: value, done: !!done };\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_iter-step.js?")},"./node_modules/core-js/modules/_iterators.js":module=>{eval("module.exports = {};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_iterators.js?")},"./node_modules/core-js/modules/_library.js":module=>{eval("module.exports = false;\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_library.js?")},"./node_modules/core-js/modules/_meta.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var META = __webpack_require__(/*! ./_uid */ \"./node_modules/core-js/modules/_uid.js\")('meta');\nvar isObject = __webpack_require__(/*! ./_is-object */ \"./node_modules/core-js/modules/_is-object.js\");\nvar has = __webpack_require__(/*! ./_has */ \"./node_modules/core-js/modules/_has.js\");\nvar setDesc = (__webpack_require__(/*! ./_object-dp */ \"./node_modules/core-js/modules/_object-dp.js\").f);\nvar id = 0;\nvar isExtensible = Object.isExtensible || function () {\n  return true;\n};\nvar FREEZE = !__webpack_require__(/*! ./_fails */ \"./node_modules/core-js/modules/_fails.js\")(function () {\n  return isExtensible(Object.preventExtensions({}));\n});\nvar setMeta = function (it) {\n  setDesc(it, META, { value: {\n    i: 'O' + ++id, // object ID\n    w: {}          // weak collections IDs\n  } });\n};\nvar fastKey = function (it, create) {\n  // return primitive with prefix\n  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;\n  if (!has(it, META)) {\n    // can't set metadata to uncaught frozen object\n    if (!isExtensible(it)) return 'F';\n    // not necessary to add metadata\n    if (!create) return 'E';\n    // add missing metadata\n    setMeta(it);\n  // return object ID\n  } return it[META].i;\n};\nvar getWeak = function (it, create) {\n  if (!has(it, META)) {\n    // can't set metadata to uncaught frozen object\n    if (!isExtensible(it)) return true;\n    // not necessary to add metadata\n    if (!create) return false;\n    // add missing metadata\n    setMeta(it);\n  // return hash weak collections IDs\n  } return it[META].w;\n};\n// add metadata on freeze-family methods calling\nvar onFreeze = function (it) {\n  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);\n  return it;\n};\nvar meta = module.exports = {\n  KEY: META,\n  NEED: false,\n  fastKey: fastKey,\n  getWeak: getWeak,\n  onFreeze: onFreeze\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_meta.js?")},"./node_modules/core-js/modules/_object-create.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])\nvar anObject = __webpack_require__(/*! ./_an-object */ \"./node_modules/core-js/modules/_an-object.js\");\nvar dPs = __webpack_require__(/*! ./_object-dps */ \"./node_modules/core-js/modules/_object-dps.js\");\nvar enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ \"./node_modules/core-js/modules/_enum-bug-keys.js\");\nvar IE_PROTO = __webpack_require__(/*! ./_shared-key */ \"./node_modules/core-js/modules/_shared-key.js\")('IE_PROTO');\nvar Empty = function () { /* empty */ };\nvar PROTOTYPE = 'prototype';\n\n// Create object with fake `null` prototype: use iframe Object with cleared prototype\nvar createDict = function () {\n  // Thrash, waste and sodomy: IE GC bug\n  var iframe = __webpack_require__(/*! ./_dom-create */ \"./node_modules/core-js/modules/_dom-create.js\")('iframe');\n  var i = enumBugKeys.length;\n  var lt = '<';\n  var gt = '>';\n  var iframeDocument;\n  iframe.style.display = 'none';\n  (__webpack_require__(/*! ./_html */ \"./node_modules/core-js/modules/_html.js\").appendChild)(iframe);\n  iframe.src = 'javascript:'; // eslint-disable-line no-script-url\n  // createDict = iframe.contentWindow.Object;\n  // html.removeChild(iframe);\n  iframeDocument = iframe.contentWindow.document;\n  iframeDocument.open();\n  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);\n  iframeDocument.close();\n  createDict = iframeDocument.F;\n  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];\n  return createDict();\n};\n\nmodule.exports = Object.create || function create(O, Properties) {\n  var result;\n  if (O !== null) {\n    Empty[PROTOTYPE] = anObject(O);\n    result = new Empty();\n    Empty[PROTOTYPE] = null;\n    // add \"__proto__\" for Object.getPrototypeOf polyfill\n    result[IE_PROTO] = O;\n  } else result = createDict();\n  return Properties === undefined ? result : dPs(result, Properties);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-create.js?")},"./node_modules/core-js/modules/_object-dp.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval("var anObject = __webpack_require__(/*! ./_an-object */ \"./node_modules/core-js/modules/_an-object.js\");\nvar IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ \"./node_modules/core-js/modules/_ie8-dom-define.js\");\nvar toPrimitive = __webpack_require__(/*! ./_to-primitive */ \"./node_modules/core-js/modules/_to-primitive.js\");\nvar dP = Object.defineProperty;\n\nexports.f = __webpack_require__(/*! ./_descriptors */ \"./node_modules/core-js/modules/_descriptors.js\") ? Object.defineProperty : function defineProperty(O, P, Attributes) {\n  anObject(O);\n  P = toPrimitive(P, true);\n  anObject(Attributes);\n  if (IE8_DOM_DEFINE) try {\n    return dP(O, P, Attributes);\n  } catch (e) { /* empty */ }\n  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');\n  if ('value' in Attributes) O[P] = Attributes.value;\n  return O;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-dp.js?")},"./node_modules/core-js/modules/_object-dps.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js");\nvar anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/modules/_an-object.js");\nvar getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/modules/_object-keys.js");\n\nmodule.exports = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js") ? Object.defineProperties : function defineProperties(O, Properties) {\n  anObject(O);\n  var keys = getKeys(Properties);\n  var length = keys.length;\n  var i = 0;\n  var P;\n  while (length > i) dP.f(O, P = keys[i++], Properties[P]);\n  return O;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-dps.js?')},"./node_modules/core-js/modules/_object-gopd.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval('var pIE = __webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/modules/_object-pie.js");\nvar createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/modules/_property-desc.js");\nvar toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/modules/_to-iobject.js");\nvar toPrimitive = __webpack_require__(/*! ./_to-primitive */ "./node_modules/core-js/modules/_to-primitive.js");\nvar has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/modules/_has.js");\nvar IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ "./node_modules/core-js/modules/_ie8-dom-define.js");\nvar gOPD = Object.getOwnPropertyDescriptor;\n\nexports.f = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js") ? gOPD : function getOwnPropertyDescriptor(O, P) {\n  O = toIObject(O);\n  P = toPrimitive(P, true);\n  if (IE8_DOM_DEFINE) try {\n    return gOPD(O, P);\n  } catch (e) { /* empty */ }\n  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-gopd.js?')},"./node_modules/core-js/modules/_object-gopn-ext.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window\nvar toIObject = __webpack_require__(/*! ./_to-iobject */ \"./node_modules/core-js/modules/_to-iobject.js\");\nvar gOPN = (__webpack_require__(/*! ./_object-gopn */ \"./node_modules/core-js/modules/_object-gopn.js\").f);\nvar toString = {}.toString;\n\nvar windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames\n  ? Object.getOwnPropertyNames(window) : [];\n\nvar getWindowNames = function (it) {\n  try {\n    return gOPN(it);\n  } catch (e) {\n    return windowNames.slice();\n  }\n};\n\nmodule.exports.f = function getOwnPropertyNames(it) {\n  return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-gopn-ext.js?")},"./node_modules/core-js/modules/_object-gopn.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval("// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)\nvar $keys = __webpack_require__(/*! ./_object-keys-internal */ \"./node_modules/core-js/modules/_object-keys-internal.js\");\nvar hiddenKeys = (__webpack_require__(/*! ./_enum-bug-keys */ \"./node_modules/core-js/modules/_enum-bug-keys.js\").concat)('length', 'prototype');\n\nexports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {\n  return $keys(O, hiddenKeys);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-gopn.js?")},"./node_modules/core-js/modules/_object-gops.js":(__unused_webpack_module,exports)=>{eval("exports.f = Object.getOwnPropertySymbols;\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-gops.js?")},"./node_modules/core-js/modules/_object-gpo.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)\nvar has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/modules/_has.js");\nvar toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/modules/_to-object.js");\nvar IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/modules/_shared-key.js")(\'IE_PROTO\');\nvar ObjectProto = Object.prototype;\n\nmodule.exports = Object.getPrototypeOf || function (O) {\n  O = toObject(O);\n  if (has(O, IE_PROTO)) return O[IE_PROTO];\n  if (typeof O.constructor == \'function\' && O instanceof O.constructor) {\n    return O.constructor.prototype;\n  } return O instanceof Object ? ObjectProto : null;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-gpo.js?')},"./node_modules/core-js/modules/_object-keys-internal.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/modules/_has.js");\nvar toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/modules/_to-iobject.js");\nvar arrayIndexOf = __webpack_require__(/*! ./_array-includes */ "./node_modules/core-js/modules/_array-includes.js")(false);\nvar IE_PROTO = __webpack_require__(/*! ./_shared-key */ "./node_modules/core-js/modules/_shared-key.js")(\'IE_PROTO\');\n\nmodule.exports = function (object, names) {\n  var O = toIObject(object);\n  var i = 0;\n  var result = [];\n  var key;\n  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);\n  // Don\'t enum bug & hidden keys\n  while (names.length > i) if (has(O, key = names[i++])) {\n    ~arrayIndexOf(result, key) || result.push(key);\n  }\n  return result;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-keys-internal.js?')},"./node_modules/core-js/modules/_object-keys.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 19.1.2.14 / 15.2.3.14 Object.keys(O)\nvar $keys = __webpack_require__(/*! ./_object-keys-internal */ "./node_modules/core-js/modules/_object-keys-internal.js");\nvar enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ "./node_modules/core-js/modules/_enum-bug-keys.js");\n\nmodule.exports = Object.keys || function keys(O) {\n  return $keys(O, enumBugKeys);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-keys.js?')},"./node_modules/core-js/modules/_object-pie.js":(__unused_webpack_module,exports)=>{eval("exports.f = {}.propertyIsEnumerable;\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-pie.js?")},"./node_modules/core-js/modules/_object-sap.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// most Object methods by ES6 should accept primitives\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/modules/_core.js");\nvar fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/modules/_fails.js");\nmodule.exports = function (KEY, exec) {\n  var fn = (core.Object || {})[KEY] || Object[KEY];\n  var exp = {};\n  exp[KEY] = exec(fn);\n  $export($export.S + $export.F * fails(function () { fn(1); }), \'Object\', exp);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_object-sap.js?')},"./node_modules/core-js/modules/_own-keys.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// all object keys, includes non-enumerable and symbols\nvar gOPN = __webpack_require__(/*! ./_object-gopn */ "./node_modules/core-js/modules/_object-gopn.js");\nvar gOPS = __webpack_require__(/*! ./_object-gops */ "./node_modules/core-js/modules/_object-gops.js");\nvar anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/modules/_an-object.js");\nvar Reflect = (__webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js").Reflect);\nmodule.exports = Reflect && Reflect.ownKeys || function ownKeys(it) {\n  var keys = gOPN.f(anObject(it));\n  var getSymbols = gOPS.f;\n  return getSymbols ? keys.concat(getSymbols(it)) : keys;\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_own-keys.js?')},"./node_modules/core-js/modules/_property-desc.js":module=>{eval("module.exports = function (bitmap, value) {\n  return {\n    enumerable: !(bitmap & 1),\n    configurable: !(bitmap & 2),\n    writable: !(bitmap & 4),\n    value: value\n  };\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_property-desc.js?")},"./node_modules/core-js/modules/_redefine.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var global = __webpack_require__(/*! ./_global */ \"./node_modules/core-js/modules/_global.js\");\nvar hide = __webpack_require__(/*! ./_hide */ \"./node_modules/core-js/modules/_hide.js\");\nvar has = __webpack_require__(/*! ./_has */ \"./node_modules/core-js/modules/_has.js\");\nvar SRC = __webpack_require__(/*! ./_uid */ \"./node_modules/core-js/modules/_uid.js\")('src');\nvar $toString = __webpack_require__(/*! ./_function-to-string */ \"./node_modules/core-js/modules/_function-to-string.js\");\nvar TO_STRING = 'toString';\nvar TPL = ('' + $toString).split(TO_STRING);\n\n(__webpack_require__(/*! ./_core */ \"./node_modules/core-js/modules/_core.js\").inspectSource) = function (it) {\n  return $toString.call(it);\n};\n\n(module.exports = function (O, key, val, safe) {\n  var isFunction = typeof val == 'function';\n  if (isFunction) has(val, 'name') || hide(val, 'name', key);\n  if (O[key] === val) return;\n  if (isFunction) has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));\n  if (O === global) {\n    O[key] = val;\n  } else if (!safe) {\n    delete O[key];\n    hide(O, key, val);\n  } else if (O[key]) {\n    O[key] = val;\n  } else {\n    hide(O, key, val);\n  }\n// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative\n})(Function.prototype, TO_STRING, function toString() {\n  return typeof this == 'function' && this[SRC] || $toString.call(this);\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_redefine.js?")},"./node_modules/core-js/modules/_regexp-exec-abstract.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar classof = __webpack_require__(/*! ./_classof */ \"./node_modules/core-js/modules/_classof.js\");\nvar builtinExec = RegExp.prototype.exec;\n\n // `RegExpExec` abstract operation\n// https://tc39.github.io/ecma262/#sec-regexpexec\nmodule.exports = function (R, S) {\n  var exec = R.exec;\n  if (typeof exec === 'function') {\n    var result = exec.call(R, S);\n    if (typeof result !== 'object') {\n      throw new TypeError('RegExp exec method returned something other than an Object or null');\n    }\n    return result;\n  }\n  if (classof(R) !== 'RegExp') {\n    throw new TypeError('RegExp#exec called on incompatible receiver');\n  }\n  return builtinExec.call(R, S);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_regexp-exec-abstract.js?")},"./node_modules/core-js/modules/_regexp-exec.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar regexpFlags = __webpack_require__(/*! ./_flags */ \"./node_modules/core-js/modules/_flags.js\");\n\nvar nativeExec = RegExp.prototype.exec;\n// This always refers to the native implementation, because the\n// String#replace polyfill uses ./fix-regexp-well-known-symbol-logic.js,\n// which loads this file before patching the method.\nvar nativeReplace = String.prototype.replace;\n\nvar patchedExec = nativeExec;\n\nvar LAST_INDEX = 'lastIndex';\n\nvar UPDATES_LAST_INDEX_WRONG = (function () {\n  var re1 = /a/,\n      re2 = /b*/g;\n  nativeExec.call(re1, 'a');\n  nativeExec.call(re2, 'a');\n  return re1[LAST_INDEX] !== 0 || re2[LAST_INDEX] !== 0;\n})();\n\n// nonparticipating capturing group, copied from es5-shim's String#split patch.\nvar NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;\n\nvar PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED;\n\nif (PATCH) {\n  patchedExec = function exec(str) {\n    var re = this;\n    var lastIndex, reCopy, match, i;\n\n    if (NPCG_INCLUDED) {\n      reCopy = new RegExp('^' + re.source + '$(?!\\\\s)', regexpFlags.call(re));\n    }\n    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re[LAST_INDEX];\n\n    match = nativeExec.call(re, str);\n\n    if (UPDATES_LAST_INDEX_WRONG && match) {\n      re[LAST_INDEX] = re.global ? match.index + match[0].length : lastIndex;\n    }\n    if (NPCG_INCLUDED && match && match.length > 1) {\n      // Fix browsers whose `exec` methods don't consistently return `undefined`\n      // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/\n      // eslint-disable-next-line no-loop-func\n      nativeReplace.call(match[0], reCopy, function () {\n        for (i = 1; i < arguments.length - 2; i++) {\n          if (arguments[i] === undefined) match[i] = undefined;\n        }\n      });\n    }\n\n    return match;\n  };\n}\n\nmodule.exports = patchedExec;\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_regexp-exec.js?")},"./node_modules/core-js/modules/_set-proto.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// Works with __proto__ only. Old v8 can\'t work with null proto objects.\n/* eslint-disable no-proto */\nvar isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/modules/_is-object.js");\nvar anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/modules/_an-object.js");\nvar check = function (O, proto) {\n  anObject(O);\n  if (!isObject(proto) && proto !== null) throw TypeError(proto + ": can\'t set as prototype!");\n};\nmodule.exports = {\n  set: Object.setPrototypeOf || (\'__proto__\' in {} ? // eslint-disable-line\n    function (test, buggy, set) {\n      try {\n        set = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/modules/_ctx.js")(Function.call, (__webpack_require__(/*! ./_object-gopd */ "./node_modules/core-js/modules/_object-gopd.js").f)(Object.prototype, \'__proto__\').set, 2);\n        set(test, []);\n        buggy = !(test instanceof Array);\n      } catch (e) { buggy = true; }\n      return function setPrototypeOf(O, proto) {\n        check(O, proto);\n        if (buggy) O.__proto__ = proto;\n        else set(O, proto);\n        return O;\n      };\n    }({}, false) : undefined),\n  check: check\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_set-proto.js?')},"./node_modules/core-js/modules/_set-species.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js");\nvar dP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js");\nvar DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js");\nvar SPECIES = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'species\');\n\nmodule.exports = function (KEY) {\n  var C = global[KEY];\n  if (DESCRIPTORS && C && !C[SPECIES]) dP.f(C, SPECIES, {\n    configurable: true,\n    get: function () { return this; }\n  });\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_set-species.js?')},"./node_modules/core-js/modules/_set-to-string-tag.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var def = (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js").f);\nvar has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/modules/_has.js");\nvar TAG = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'toStringTag\');\n\nmodule.exports = function (it, tag, stat) {\n  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_set-to-string-tag.js?')},"./node_modules/core-js/modules/_shared-key.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var shared = __webpack_require__(/*! ./_shared */ "./node_modules/core-js/modules/_shared.js")(\'keys\');\nvar uid = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/modules/_uid.js");\nmodule.exports = function (key) {\n  return shared[key] || (shared[key] = uid(key));\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_shared-key.js?')},"./node_modules/core-js/modules/_shared.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var core = __webpack_require__(/*! ./_core */ \"./node_modules/core-js/modules/_core.js\");\nvar global = __webpack_require__(/*! ./_global */ \"./node_modules/core-js/modules/_global.js\");\nvar SHARED = '__core-js_shared__';\nvar store = global[SHARED] || (global[SHARED] = {});\n\n(module.exports = function (key, value) {\n  return store[key] || (store[key] = value !== undefined ? value : {});\n})('versions', []).push({\n  version: core.version,\n  mode: __webpack_require__(/*! ./_library */ \"./node_modules/core-js/modules/_library.js\") ? 'pure' : 'global',\n  copyright: '© 2020 Denis Pushkarev (zloirock.ru)'\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_shared.js?")},"./node_modules/core-js/modules/_species-constructor.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 7.3.20 SpeciesConstructor(O, defaultConstructor)\nvar anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/modules/_an-object.js");\nvar aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/modules/_a-function.js");\nvar SPECIES = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'species\');\nmodule.exports = function (O, D) {\n  var C = anObject(O).constructor;\n  var S;\n  return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? D : aFunction(S);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_species-constructor.js?')},"./node_modules/core-js/modules/_strict-method.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/modules/_fails.js");\n\nmodule.exports = function (method, arg) {\n  return !!method && fails(function () {\n    // eslint-disable-next-line no-useless-call\n    arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);\n  });\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_strict-method.js?')},"./node_modules/core-js/modules/_string-at.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/modules/_to-integer.js");\nvar defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/modules/_defined.js");\n// true  -> String#at\n// false -> String#codePointAt\nmodule.exports = function (TO_STRING) {\n  return function (that, pos) {\n    var s = String(defined(that));\n    var i = toInteger(pos);\n    var l = s.length;\n    var a, b;\n    if (i < 0 || i >= l) return TO_STRING ? \'\' : undefined;\n    a = s.charCodeAt(i);\n    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff\n      ? TO_STRING ? s.charAt(i) : a\n      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;\n  };\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_string-at.js?')},"./node_modules/core-js/modules/_to-absolute-index.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/modules/_to-integer.js");\nvar max = Math.max;\nvar min = Math.min;\nmodule.exports = function (index, length) {\n  index = toInteger(index);\n  return index < 0 ? max(index + length, 0) : min(index, length);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_to-absolute-index.js?')},"./node_modules/core-js/modules/_to-integer.js":module=>{eval("// 7.1.4 ToInteger\nvar ceil = Math.ceil;\nvar floor = Math.floor;\nmodule.exports = function (it) {\n  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_to-integer.js?")},"./node_modules/core-js/modules/_to-iobject.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// to indexed object, toObject with fallback for non-array-like ES3 strings\nvar IObject = __webpack_require__(/*! ./_iobject */ "./node_modules/core-js/modules/_iobject.js");\nvar defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/modules/_defined.js");\nmodule.exports = function (it) {\n  return IObject(defined(it));\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_to-iobject.js?')},"./node_modules/core-js/modules/_to-length.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 7.1.15 ToLength\nvar toInteger = __webpack_require__(/*! ./_to-integer */ "./node_modules/core-js/modules/_to-integer.js");\nvar min = Math.min;\nmodule.exports = function (it) {\n  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_to-length.js?')},"./node_modules/core-js/modules/_to-object.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('// 7.1.13 ToObject(argument)\nvar defined = __webpack_require__(/*! ./_defined */ "./node_modules/core-js/modules/_defined.js");\nmodule.exports = function (it) {\n  return Object(defined(it));\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_to-object.js?')},"./node_modules/core-js/modules/_to-primitive.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("// 7.1.1 ToPrimitive(input [, PreferredType])\nvar isObject = __webpack_require__(/*! ./_is-object */ \"./node_modules/core-js/modules/_is-object.js\");\n// instead of the ES6 spec version, we didn't implement @@toPrimitive case\n// and the second argument - flag - preferred type is a string\nmodule.exports = function (it, S) {\n  if (!isObject(it)) return it;\n  var fn, val;\n  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;\n  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;\n  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;\n  throw TypeError(\"Can't convert object to primitive value\");\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_to-primitive.js?")},"./node_modules/core-js/modules/_uid.js":module=>{eval("var id = 0;\nvar px = Math.random();\nmodule.exports = function (key) {\n  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_uid.js?")},"./node_modules/core-js/modules/_wks-define.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js");\nvar core = __webpack_require__(/*! ./_core */ "./node_modules/core-js/modules/_core.js");\nvar LIBRARY = __webpack_require__(/*! ./_library */ "./node_modules/core-js/modules/_library.js");\nvar wksExt = __webpack_require__(/*! ./_wks-ext */ "./node_modules/core-js/modules/_wks-ext.js");\nvar defineProperty = (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js").f);\nmodule.exports = function (name) {\n  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});\n  if (name.charAt(0) != \'_\' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_wks-define.js?')},"./node_modules/core-js/modules/_wks-ext.js":(__unused_webpack_module,exports,__webpack_require__)=>{eval('exports.f = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js");\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_wks-ext.js?')},"./node_modules/core-js/modules/_wks.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval("var store = __webpack_require__(/*! ./_shared */ \"./node_modules/core-js/modules/_shared.js\")('wks');\nvar uid = __webpack_require__(/*! ./_uid */ \"./node_modules/core-js/modules/_uid.js\");\nvar Symbol = (__webpack_require__(/*! ./_global */ \"./node_modules/core-js/modules/_global.js\").Symbol);\nvar USE_SYMBOL = typeof Symbol == 'function';\n\nvar $exports = module.exports = function (name) {\n  return store[name] || (store[name] =\n    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));\n};\n\n$exports.store = store;\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/_wks.js?")},"./node_modules/core-js/modules/core.get-iterator-method.js":(module,__unused_webpack_exports,__webpack_require__)=>{eval('var classof = __webpack_require__(/*! ./_classof */ "./node_modules/core-js/modules/_classof.js");\nvar ITERATOR = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'iterator\');\nvar Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/modules/_iterators.js");\nmodule.exports = (__webpack_require__(/*! ./_core */ "./node_modules/core-js/modules/_core.js").getIteratorMethod) = function (it) {\n  if (it != undefined) return it[ITERATOR]\n    || it[\'@@iterator\']\n    || Iterators[classof(it)];\n};\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/core.get-iterator-method.js?')},"./node_modules/core-js/modules/es6.array.filter.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar $filter = __webpack_require__(/*! ./_array-methods */ "./node_modules/core-js/modules/_array-methods.js")(2);\n\n$export($export.P + $export.F * !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/modules/_strict-method.js")([].filter, true), \'Array\', {\n  // 22.1.3.7 / 15.4.4.20 Array.prototype.filter(callbackfn [, thisArg])\n  filter: function filter(callbackfn /* , thisArg */) {\n    return $filter(this, callbackfn, arguments[1]);\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.filter.js?')},"./node_modules/core-js/modules/es6.array.for-each.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar $forEach = __webpack_require__(/*! ./_array-methods */ "./node_modules/core-js/modules/_array-methods.js")(0);\nvar STRICT = __webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/modules/_strict-method.js")([].forEach, true);\n\n$export($export.P + $export.F * !STRICT, \'Array\', {\n  // 22.1.3.10 / 15.4.4.18 Array.prototype.forEach(callbackfn [, thisArg])\n  forEach: function forEach(callbackfn /* , thisArg */) {\n    return $forEach(this, callbackfn, arguments[1]);\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.for-each.js?')},"./node_modules/core-js/modules/es6.array.from.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar ctx = __webpack_require__(/*! ./_ctx */ "./node_modules/core-js/modules/_ctx.js");\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/modules/_to-object.js");\nvar call = __webpack_require__(/*! ./_iter-call */ "./node_modules/core-js/modules/_iter-call.js");\nvar isArrayIter = __webpack_require__(/*! ./_is-array-iter */ "./node_modules/core-js/modules/_is-array-iter.js");\nvar toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/modules/_to-length.js");\nvar createProperty = __webpack_require__(/*! ./_create-property */ "./node_modules/core-js/modules/_create-property.js");\nvar getIterFn = __webpack_require__(/*! ./core.get-iterator-method */ "./node_modules/core-js/modules/core.get-iterator-method.js");\n\n$export($export.S + $export.F * !__webpack_require__(/*! ./_iter-detect */ "./node_modules/core-js/modules/_iter-detect.js")(function (iter) { Array.from(iter); }), \'Array\', {\n  // 22.1.2.1 Array.from(arrayLike, mapfn = undefined, thisArg = undefined)\n  from: function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {\n    var O = toObject(arrayLike);\n    var C = typeof this == \'function\' ? this : Array;\n    var aLen = arguments.length;\n    var mapfn = aLen > 1 ? arguments[1] : undefined;\n    var mapping = mapfn !== undefined;\n    var index = 0;\n    var iterFn = getIterFn(O);\n    var length, result, step, iterator;\n    if (mapping) mapfn = ctx(mapfn, aLen > 2 ? arguments[2] : undefined, 2);\n    // if object isn\'t iterable or it\'s array with default iterator - use simple case\n    if (iterFn != undefined && !(C == Array && isArrayIter(iterFn))) {\n      for (iterator = iterFn.call(O), result = new C(); !(step = iterator.next()).done; index++) {\n        createProperty(result, index, mapping ? call(iterator, mapfn, [step.value, index], true) : step.value);\n      }\n    } else {\n      length = toLength(O.length);\n      for (result = new C(length); length > index; index++) {\n        createProperty(result, index, mapping ? mapfn(O[index], index) : O[index]);\n      }\n    }\n    result.length = index;\n    return result;\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.from.js?')},"./node_modules/core-js/modules/es6.array.index-of.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar $indexOf = __webpack_require__(/*! ./_array-includes */ "./node_modules/core-js/modules/_array-includes.js")(false);\nvar $native = [].indexOf;\nvar NEGATIVE_ZERO = !!$native && 1 / [1].indexOf(1, -0) < 0;\n\n$export($export.P + $export.F * (NEGATIVE_ZERO || !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/modules/_strict-method.js")($native)), \'Array\', {\n  // 22.1.3.11 / 15.4.4.14 Array.prototype.indexOf(searchElement [, fromIndex])\n  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {\n    return NEGATIVE_ZERO\n      // convert -0 to +0\n      ? $native.apply(this, arguments) || 0\n      : $indexOf(this, searchElement, arguments[1]);\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.index-of.js?')},"./node_modules/core-js/modules/es6.array.is-array.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('// 22.1.2.2 / 15.4.3.2 Array.isArray(arg)\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\n\n$export($export.S, \'Array\', { isArray: __webpack_require__(/*! ./_is-array */ "./node_modules/core-js/modules/_is-array.js") });\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.is-array.js?')},"./node_modules/core-js/modules/es6.array.iterator.js":(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\nvar addToUnscopables = __webpack_require__(/*! ./_add-to-unscopables */ \"./node_modules/core-js/modules/_add-to-unscopables.js\");\nvar step = __webpack_require__(/*! ./_iter-step */ \"./node_modules/core-js/modules/_iter-step.js\");\nvar Iterators = __webpack_require__(/*! ./_iterators */ \"./node_modules/core-js/modules/_iterators.js\");\nvar toIObject = __webpack_require__(/*! ./_to-iobject */ \"./node_modules/core-js/modules/_to-iobject.js\");\n\n// 22.1.3.4 Array.prototype.entries()\n// 22.1.3.13 Array.prototype.keys()\n// 22.1.3.29 Array.prototype.values()\n// 22.1.3.30 Array.prototype[@@iterator]()\nmodule.exports = __webpack_require__(/*! ./_iter-define */ \"./node_modules/core-js/modules/_iter-define.js\")(Array, 'Array', function (iterated, kind) {\n  this._t = toIObject(iterated); // target\n  this._i = 0;                   // next index\n  this._k = kind;                // kind\n// 22.1.5.2.1 %ArrayIteratorPrototype%.next()\n}, function () {\n  var O = this._t;\n  var kind = this._k;\n  var index = this._i++;\n  if (!O || index >= O.length) {\n    this._t = undefined;\n    return step(1);\n  }\n  if (kind == 'keys') return step(0, index);\n  if (kind == 'values') return step(0, O[index]);\n  return step(0, [index, O[index]]);\n}, 'values');\n\n// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)\nIterators.Arguments = Iterators.Array;\n\naddToUnscopables('keys');\naddToUnscopables('values');\naddToUnscopables('entries');\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.iterator.js?")},"./node_modules/core-js/modules/es6.array.reduce.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar $reduce = __webpack_require__(/*! ./_array-reduce */ "./node_modules/core-js/modules/_array-reduce.js");\n\n$export($export.P + $export.F * !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/modules/_strict-method.js")([].reduce, true), \'Array\', {\n  // 22.1.3.18 / 15.4.4.21 Array.prototype.reduce(callbackfn [, initialValue])\n  reduce: function reduce(callbackfn /* , initialValue */) {\n    return $reduce(this, callbackfn, arguments.length, arguments[1], false);\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.reduce.js?')},"./node_modules/core-js/modules/es6.array.sort.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar aFunction = __webpack_require__(/*! ./_a-function */ "./node_modules/core-js/modules/_a-function.js");\nvar toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/modules/_to-object.js");\nvar fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/modules/_fails.js");\nvar $sort = [].sort;\nvar test = [1, 2, 3];\n\n$export($export.P + $export.F * (fails(function () {\n  // IE8-\n  test.sort(undefined);\n}) || !fails(function () {\n  // V8 bug\n  test.sort(null);\n  // Old WebKit\n}) || !__webpack_require__(/*! ./_strict-method */ "./node_modules/core-js/modules/_strict-method.js")($sort)), \'Array\', {\n  // 22.1.3.25 Array.prototype.sort(comparefn)\n  sort: function sort(comparefn) {\n    return comparefn === undefined\n      ? $sort.call(toObject(this))\n      : $sort.call(toObject(this), aFunction(comparefn));\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.array.sort.js?')},"./node_modules/core-js/modules/es6.date.to-string.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval("var DateProto = Date.prototype;\nvar INVALID_DATE = 'Invalid Date';\nvar TO_STRING = 'toString';\nvar $toString = DateProto[TO_STRING];\nvar getTime = DateProto.getTime;\nif (new Date(NaN) + '' != INVALID_DATE) {\n  __webpack_require__(/*! ./_redefine */ \"./node_modules/core-js/modules/_redefine.js\")(DateProto, TO_STRING, function toString() {\n    var value = getTime.call(this);\n    // eslint-disable-next-line no-self-compare\n    return value === value ? $toString.call(this) : INVALID_DATE;\n  });\n}\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.date.to-string.js?")},"./node_modules/core-js/modules/es6.object.define-properties.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\n// 19.1.2.3 / 15.2.3.7 Object.defineProperties(O, Properties)\n$export($export.S + $export.F * !__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js"), \'Object\', { defineProperties: __webpack_require__(/*! ./_object-dps */ "./node_modules/core-js/modules/_object-dps.js") });\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.object.define-properties.js?')},"./node_modules/core-js/modules/es6.object.define-property.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('var $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\n// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)\n$export($export.S + $export.F * !__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js"), \'Object\', { defineProperty: (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js").f) });\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.object.define-property.js?')},"./node_modules/core-js/modules/es6.object.keys.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('// 19.1.2.14 Object.keys(O)\nvar toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/modules/_to-object.js");\nvar $keys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/modules/_object-keys.js");\n\n__webpack_require__(/*! ./_object-sap */ "./node_modules/core-js/modules/_object-sap.js")(\'keys\', function () {\n  return function keys(it) {\n    return $keys(toObject(it));\n  };\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.object.keys.js?')},"./node_modules/core-js/modules/es6.object.to-string.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n// 19.1.3.6 Object.prototype.toString()\nvar classof = __webpack_require__(/*! ./_classof */ \"./node_modules/core-js/modules/_classof.js\");\nvar test = {};\ntest[__webpack_require__(/*! ./_wks */ \"./node_modules/core-js/modules/_wks.js\")('toStringTag')] = 'z';\nif (test + '' != '[object z]') {\n  __webpack_require__(/*! ./_redefine */ \"./node_modules/core-js/modules/_redefine.js\")(Object.prototype, 'toString', function toString() {\n    return '[object ' + classof(this) + ']';\n  }, true);\n}\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.object.to-string.js?")},"./node_modules/core-js/modules/es6.regexp.constructor.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('var global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js");\nvar inheritIfRequired = __webpack_require__(/*! ./_inherit-if-required */ "./node_modules/core-js/modules/_inherit-if-required.js");\nvar dP = (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js").f);\nvar gOPN = (__webpack_require__(/*! ./_object-gopn */ "./node_modules/core-js/modules/_object-gopn.js").f);\nvar isRegExp = __webpack_require__(/*! ./_is-regexp */ "./node_modules/core-js/modules/_is-regexp.js");\nvar $flags = __webpack_require__(/*! ./_flags */ "./node_modules/core-js/modules/_flags.js");\nvar $RegExp = global.RegExp;\nvar Base = $RegExp;\nvar proto = $RegExp.prototype;\nvar re1 = /a/g;\nvar re2 = /a/g;\n// "new" creates a new object, old webkit buggy here\nvar CORRECT_NEW = new $RegExp(re1) !== re1;\n\nif (__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js") && (!CORRECT_NEW || __webpack_require__(/*! ./_fails */ "./node_modules/core-js/modules/_fails.js")(function () {\n  re2[__webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js")(\'match\')] = false;\n  // RegExp constructor can alter flags and IsRegExp works correct with @@match\n  return $RegExp(re1) != re1 || $RegExp(re2) == re2 || $RegExp(re1, \'i\') != \'/a/i\';\n}))) {\n  $RegExp = function RegExp(p, f) {\n    var tiRE = this instanceof $RegExp;\n    var piRE = isRegExp(p);\n    var fiU = f === undefined;\n    return !tiRE && piRE && p.constructor === $RegExp && fiU ? p\n      : inheritIfRequired(CORRECT_NEW\n        ? new Base(piRE && !fiU ? p.source : p, f)\n        : Base((piRE = p instanceof $RegExp) ? p.source : p, piRE && fiU ? $flags.call(p) : f)\n      , tiRE ? this : proto, $RegExp);\n  };\n  var proxy = function (key) {\n    key in $RegExp || dP($RegExp, key, {\n      configurable: true,\n      get: function () { return Base[key]; },\n      set: function (it) { Base[key] = it; }\n    });\n  };\n  for (var keys = gOPN(Base), i = 0; keys.length > i;) proxy(keys[i++]);\n  proto.constructor = $RegExp;\n  $RegExp.prototype = proto;\n  __webpack_require__(/*! ./_redefine */ "./node_modules/core-js/modules/_redefine.js")(global, \'RegExp\', $RegExp);\n}\n\n__webpack_require__(/*! ./_set-species */ "./node_modules/core-js/modules/_set-species.js")(\'RegExp\');\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.regexp.constructor.js?')},"./node_modules/core-js/modules/es6.regexp.exec.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar regexpExec = __webpack_require__(/*! ./_regexp-exec */ "./node_modules/core-js/modules/_regexp-exec.js");\n__webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js")({\n  target: \'RegExp\',\n  proto: true,\n  forced: regexpExec !== /./.exec\n}, {\n  exec: regexpExec\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.regexp.exec.js?')},"./node_modules/core-js/modules/es6.regexp.flags.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('// 21.2.5.3 get RegExp.prototype.flags()\nif (__webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js") && /./g.flags != \'g\') (__webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js").f)(RegExp.prototype, \'flags\', {\n  configurable: true,\n  get: __webpack_require__(/*! ./_flags */ "./node_modules/core-js/modules/_flags.js")\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.regexp.flags.js?')},"./node_modules/core-js/modules/es6.regexp.match.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n\nvar anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/modules/_an-object.js");\nvar toLength = __webpack_require__(/*! ./_to-length */ "./node_modules/core-js/modules/_to-length.js");\nvar advanceStringIndex = __webpack_require__(/*! ./_advance-string-index */ "./node_modules/core-js/modules/_advance-string-index.js");\nvar regExpExec = __webpack_require__(/*! ./_regexp-exec-abstract */ "./node_modules/core-js/modules/_regexp-exec-abstract.js");\n\n// @@match logic\n__webpack_require__(/*! ./_fix-re-wks */ "./node_modules/core-js/modules/_fix-re-wks.js")(\'match\', 1, function (defined, MATCH, $match, maybeCallNative) {\n  return [\n    // `String.prototype.match` method\n    // https://tc39.github.io/ecma262/#sec-string.prototype.match\n    function match(regexp) {\n      var O = defined(this);\n      var fn = regexp == undefined ? undefined : regexp[MATCH];\n      return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));\n    },\n    // `RegExp.prototype[@@match]` method\n    // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@match\n    function (regexp) {\n      var res = maybeCallNative($match, regexp, this);\n      if (res.done) return res.value;\n      var rx = anObject(regexp);\n      var S = String(this);\n      if (!rx.global) return regExpExec(rx, S);\n      var fullUnicode = rx.unicode;\n      rx.lastIndex = 0;\n      var A = [];\n      var n = 0;\n      var result;\n      while ((result = regExpExec(rx, S)) !== null) {\n        var matchStr = String(result[0]);\n        A[n] = matchStr;\n        if (matchStr === \'\') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);\n        n++;\n      }\n      return n === 0 ? null : A;\n    }\n  ];\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.regexp.match.js?')},"./node_modules/core-js/modules/es6.regexp.replace.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar anObject = __webpack_require__(/*! ./_an-object */ \"./node_modules/core-js/modules/_an-object.js\");\nvar toObject = __webpack_require__(/*! ./_to-object */ \"./node_modules/core-js/modules/_to-object.js\");\nvar toLength = __webpack_require__(/*! ./_to-length */ \"./node_modules/core-js/modules/_to-length.js\");\nvar toInteger = __webpack_require__(/*! ./_to-integer */ \"./node_modules/core-js/modules/_to-integer.js\");\nvar advanceStringIndex = __webpack_require__(/*! ./_advance-string-index */ \"./node_modules/core-js/modules/_advance-string-index.js\");\nvar regExpExec = __webpack_require__(/*! ./_regexp-exec-abstract */ \"./node_modules/core-js/modules/_regexp-exec-abstract.js\");\nvar max = Math.max;\nvar min = Math.min;\nvar floor = Math.floor;\nvar SUBSTITUTION_SYMBOLS = /\\$([$&`']|\\d\\d?|<[^>]*>)/g;\nvar SUBSTITUTION_SYMBOLS_NO_NAMED = /\\$([$&`']|\\d\\d?)/g;\n\nvar maybeToString = function (it) {\n  return it === undefined ? it : String(it);\n};\n\n// @@replace logic\n__webpack_require__(/*! ./_fix-re-wks */ \"./node_modules/core-js/modules/_fix-re-wks.js\")('replace', 2, function (defined, REPLACE, $replace, maybeCallNative) {\n  return [\n    // `String.prototype.replace` method\n    // https://tc39.github.io/ecma262/#sec-string.prototype.replace\n    function replace(searchValue, replaceValue) {\n      var O = defined(this);\n      var fn = searchValue == undefined ? undefined : searchValue[REPLACE];\n      return fn !== undefined\n        ? fn.call(searchValue, O, replaceValue)\n        : $replace.call(String(O), searchValue, replaceValue);\n    },\n    // `RegExp.prototype[@@replace]` method\n    // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@replace\n    function (regexp, replaceValue) {\n      var res = maybeCallNative($replace, regexp, this, replaceValue);\n      if (res.done) return res.value;\n\n      var rx = anObject(regexp);\n      var S = String(this);\n      var functionalReplace = typeof replaceValue === 'function';\n      if (!functionalReplace) replaceValue = String(replaceValue);\n      var global = rx.global;\n      if (global) {\n        var fullUnicode = rx.unicode;\n        rx.lastIndex = 0;\n      }\n      var results = [];\n      while (true) {\n        var result = regExpExec(rx, S);\n        if (result === null) break;\n        results.push(result);\n        if (!global) break;\n        var matchStr = String(result[0]);\n        if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);\n      }\n      var accumulatedResult = '';\n      var nextSourcePosition = 0;\n      for (var i = 0; i < results.length; i++) {\n        result = results[i];\n        var matched = String(result[0]);\n        var position = max(min(toInteger(result.index), S.length), 0);\n        var captures = [];\n        // NOTE: This is equivalent to\n        //   captures = result.slice(1).map(maybeToString)\n        // but for some reason `nativeSlice.call(result, 1, result.length)` (called in\n        // the slice polyfill when slicing native arrays) \"doesn't work\" in safari 9 and\n        // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.\n        for (var j = 1; j < result.length; j++) captures.push(maybeToString(result[j]));\n        var namedCaptures = result.groups;\n        if (functionalReplace) {\n          var replacerArgs = [matched].concat(captures, position, S);\n          if (namedCaptures !== undefined) replacerArgs.push(namedCaptures);\n          var replacement = String(replaceValue.apply(undefined, replacerArgs));\n        } else {\n          replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);\n        }\n        if (position >= nextSourcePosition) {\n          accumulatedResult += S.slice(nextSourcePosition, position) + replacement;\n          nextSourcePosition = position + matched.length;\n        }\n      }\n      return accumulatedResult + S.slice(nextSourcePosition);\n    }\n  ];\n\n    // https://tc39.github.io/ecma262/#sec-getsubstitution\n  function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {\n    var tailPos = position + matched.length;\n    var m = captures.length;\n    var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;\n    if (namedCaptures !== undefined) {\n      namedCaptures = toObject(namedCaptures);\n      symbols = SUBSTITUTION_SYMBOLS;\n    }\n    return $replace.call(replacement, symbols, function (match, ch) {\n      var capture;\n      switch (ch.charAt(0)) {\n        case '$': return '$';\n        case '&': return matched;\n        case '`': return str.slice(0, position);\n        case \"'\": return str.slice(tailPos);\n        case '<':\n          capture = namedCaptures[ch.slice(1, -1)];\n          break;\n        default: // \\d\\d?\n          var n = +ch;\n          if (n === 0) return match;\n          if (n > m) {\n            var f = floor(n / 10);\n            if (f === 0) return match;\n            if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);\n            return match;\n          }\n          capture = captures[n - 1];\n      }\n      return capture === undefined ? '' : capture;\n    });\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.regexp.replace.js?")},"./node_modules/core-js/modules/es6.regexp.split.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n\nvar isRegExp = __webpack_require__(/*! ./_is-regexp */ \"./node_modules/core-js/modules/_is-regexp.js\");\nvar anObject = __webpack_require__(/*! ./_an-object */ \"./node_modules/core-js/modules/_an-object.js\");\nvar speciesConstructor = __webpack_require__(/*! ./_species-constructor */ \"./node_modules/core-js/modules/_species-constructor.js\");\nvar advanceStringIndex = __webpack_require__(/*! ./_advance-string-index */ \"./node_modules/core-js/modules/_advance-string-index.js\");\nvar toLength = __webpack_require__(/*! ./_to-length */ \"./node_modules/core-js/modules/_to-length.js\");\nvar callRegExpExec = __webpack_require__(/*! ./_regexp-exec-abstract */ \"./node_modules/core-js/modules/_regexp-exec-abstract.js\");\nvar regexpExec = __webpack_require__(/*! ./_regexp-exec */ \"./node_modules/core-js/modules/_regexp-exec.js\");\nvar fails = __webpack_require__(/*! ./_fails */ \"./node_modules/core-js/modules/_fails.js\");\nvar $min = Math.min;\nvar $push = [].push;\nvar $SPLIT = 'split';\nvar LENGTH = 'length';\nvar LAST_INDEX = 'lastIndex';\nvar MAX_UINT32 = 0xffffffff;\n\n// babel-minify transpiles RegExp('x', 'y') -> /x/y and it causes SyntaxError\nvar SUPPORTS_Y = !fails(function () { RegExp(MAX_UINT32, 'y'); });\n\n// @@split logic\n__webpack_require__(/*! ./_fix-re-wks */ \"./node_modules/core-js/modules/_fix-re-wks.js\")('split', 2, function (defined, SPLIT, $split, maybeCallNative) {\n  var internalSplit;\n  if (\n    'abbc'[$SPLIT](/(b)*/)[1] == 'c' ||\n    'test'[$SPLIT](/(?:)/, -1)[LENGTH] != 4 ||\n    'ab'[$SPLIT](/(?:ab)*/)[LENGTH] != 2 ||\n    '.'[$SPLIT](/(.?)(.?)/)[LENGTH] != 4 ||\n    '.'[$SPLIT](/()()/)[LENGTH] > 1 ||\n    ''[$SPLIT](/.?/)[LENGTH]\n  ) {\n    // based on es5-shim implementation, need to rework it\n    internalSplit = function (separator, limit) {\n      var string = String(this);\n      if (separator === undefined && limit === 0) return [];\n      // If `separator` is not a regex, use native split\n      if (!isRegExp(separator)) return $split.call(string, separator, limit);\n      var output = [];\n      var flags = (separator.ignoreCase ? 'i' : '') +\n                  (separator.multiline ? 'm' : '') +\n                  (separator.unicode ? 'u' : '') +\n                  (separator.sticky ? 'y' : '');\n      var lastLastIndex = 0;\n      var splitLimit = limit === undefined ? MAX_UINT32 : limit >>> 0;\n      // Make `global` and avoid `lastIndex` issues by working with a copy\n      var separatorCopy = new RegExp(separator.source, flags + 'g');\n      var match, lastIndex, lastLength;\n      while (match = regexpExec.call(separatorCopy, string)) {\n        lastIndex = separatorCopy[LAST_INDEX];\n        if (lastIndex > lastLastIndex) {\n          output.push(string.slice(lastLastIndex, match.index));\n          if (match[LENGTH] > 1 && match.index < string[LENGTH]) $push.apply(output, match.slice(1));\n          lastLength = match[0][LENGTH];\n          lastLastIndex = lastIndex;\n          if (output[LENGTH] >= splitLimit) break;\n        }\n        if (separatorCopy[LAST_INDEX] === match.index) separatorCopy[LAST_INDEX]++; // Avoid an infinite loop\n      }\n      if (lastLastIndex === string[LENGTH]) {\n        if (lastLength || !separatorCopy.test('')) output.push('');\n      } else output.push(string.slice(lastLastIndex));\n      return output[LENGTH] > splitLimit ? output.slice(0, splitLimit) : output;\n    };\n  // Chakra, V8\n  } else if ('0'[$SPLIT](undefined, 0)[LENGTH]) {\n    internalSplit = function (separator, limit) {\n      return separator === undefined && limit === 0 ? [] : $split.call(this, separator, limit);\n    };\n  } else {\n    internalSplit = $split;\n  }\n\n  return [\n    // `String.prototype.split` method\n    // https://tc39.github.io/ecma262/#sec-string.prototype.split\n    function split(separator, limit) {\n      var O = defined(this);\n      var splitter = separator == undefined ? undefined : separator[SPLIT];\n      return splitter !== undefined\n        ? splitter.call(separator, O, limit)\n        : internalSplit.call(String(O), separator, limit);\n    },\n    // `RegExp.prototype[@@split]` method\n    // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@split\n    //\n    // NOTE: This cannot be properly polyfilled in engines that don't support\n    // the 'y' flag.\n    function (regexp, limit) {\n      var res = maybeCallNative(internalSplit, regexp, this, limit, internalSplit !== $split);\n      if (res.done) return res.value;\n\n      var rx = anObject(regexp);\n      var S = String(this);\n      var C = speciesConstructor(rx, RegExp);\n\n      var unicodeMatching = rx.unicode;\n      var flags = (rx.ignoreCase ? 'i' : '') +\n                  (rx.multiline ? 'm' : '') +\n                  (rx.unicode ? 'u' : '') +\n                  (SUPPORTS_Y ? 'y' : 'g');\n\n      // ^(? + rx + ) is needed, in combination with some S slicing, to\n      // simulate the 'y' flag.\n      var splitter = new C(SUPPORTS_Y ? rx : '^(?:' + rx.source + ')', flags);\n      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;\n      if (lim === 0) return [];\n      if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];\n      var p = 0;\n      var q = 0;\n      var A = [];\n      while (q < S.length) {\n        splitter.lastIndex = SUPPORTS_Y ? q : 0;\n        var z = callRegExpExec(splitter, SUPPORTS_Y ? S : S.slice(q));\n        var e;\n        if (\n          z === null ||\n          (e = $min(toLength(splitter.lastIndex + (SUPPORTS_Y ? 0 : q)), S.length)) === p\n        ) {\n          q = advanceStringIndex(S, q, unicodeMatching);\n        } else {\n          A.push(S.slice(p, q));\n          if (A.length === lim) return A;\n          for (var i = 1; i <= z.length - 1; i++) {\n            A.push(z[i]);\n            if (A.length === lim) return A;\n          }\n          q = p = e;\n        }\n      }\n      A.push(S.slice(p));\n      return A;\n    }\n  ];\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.regexp.split.js?")},"./node_modules/core-js/modules/es6.regexp.to-string.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval("\n__webpack_require__(/*! ./es6.regexp.flags */ \"./node_modules/core-js/modules/es6.regexp.flags.js\");\nvar anObject = __webpack_require__(/*! ./_an-object */ \"./node_modules/core-js/modules/_an-object.js\");\nvar $flags = __webpack_require__(/*! ./_flags */ \"./node_modules/core-js/modules/_flags.js\");\nvar DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ \"./node_modules/core-js/modules/_descriptors.js\");\nvar TO_STRING = 'toString';\nvar $toString = /./[TO_STRING];\n\nvar define = function (fn) {\n  __webpack_require__(/*! ./_redefine */ \"./node_modules/core-js/modules/_redefine.js\")(RegExp.prototype, TO_STRING, fn, true);\n};\n\n// 21.2.5.14 RegExp.prototype.toString()\nif (__webpack_require__(/*! ./_fails */ \"./node_modules/core-js/modules/_fails.js\")(function () { return $toString.call({ source: 'a', flags: 'b' }) != '/a/b'; })) {\n  define(function toString() {\n    var R = anObject(this);\n    return '/'.concat(R.source, '/',\n      'flags' in R ? R.flags : !DESCRIPTORS && R instanceof RegExp ? $flags.call(R) : undefined);\n  });\n// FF44- RegExp#toString has a wrong name\n} else if ($toString.name != TO_STRING) {\n  define(function toString() {\n    return $toString.call(this);\n  });\n}\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.regexp.to-string.js?")},"./node_modules/core-js/modules/es6.string.iterator.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\nvar $at = __webpack_require__(/*! ./_string-at */ "./node_modules/core-js/modules/_string-at.js")(true);\n\n// 21.1.3.27 String.prototype[@@iterator]()\n__webpack_require__(/*! ./_iter-define */ "./node_modules/core-js/modules/_iter-define.js")(String, \'String\', function (iterated) {\n  this._t = String(iterated); // target\n  this._i = 0;                // next index\n// 21.1.5.2.1 %StringIteratorPrototype%.next()\n}, function () {\n  var O = this._t;\n  var index = this._i;\n  var point;\n  if (index >= O.length) return { value: undefined, done: true };\n  point = $at(O, index);\n  this._i += point.length;\n  return { value: point, done: false };\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.string.iterator.js?')},"./node_modules/core-js/modules/es6.symbol.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{"use strict";eval('\n// ECMAScript 6 symbols shim\nvar global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js");\nvar has = __webpack_require__(/*! ./_has */ "./node_modules/core-js/modules/_has.js");\nvar DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "./node_modules/core-js/modules/_descriptors.js");\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar redefine = __webpack_require__(/*! ./_redefine */ "./node_modules/core-js/modules/_redefine.js");\nvar META = (__webpack_require__(/*! ./_meta */ "./node_modules/core-js/modules/_meta.js").KEY);\nvar $fails = __webpack_require__(/*! ./_fails */ "./node_modules/core-js/modules/_fails.js");\nvar shared = __webpack_require__(/*! ./_shared */ "./node_modules/core-js/modules/_shared.js");\nvar setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "./node_modules/core-js/modules/_set-to-string-tag.js");\nvar uid = __webpack_require__(/*! ./_uid */ "./node_modules/core-js/modules/_uid.js");\nvar wks = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js");\nvar wksExt = __webpack_require__(/*! ./_wks-ext */ "./node_modules/core-js/modules/_wks-ext.js");\nvar wksDefine = __webpack_require__(/*! ./_wks-define */ "./node_modules/core-js/modules/_wks-define.js");\nvar enumKeys = __webpack_require__(/*! ./_enum-keys */ "./node_modules/core-js/modules/_enum-keys.js");\nvar isArray = __webpack_require__(/*! ./_is-array */ "./node_modules/core-js/modules/_is-array.js");\nvar anObject = __webpack_require__(/*! ./_an-object */ "./node_modules/core-js/modules/_an-object.js");\nvar isObject = __webpack_require__(/*! ./_is-object */ "./node_modules/core-js/modules/_is-object.js");\nvar toObject = __webpack_require__(/*! ./_to-object */ "./node_modules/core-js/modules/_to-object.js");\nvar toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/modules/_to-iobject.js");\nvar toPrimitive = __webpack_require__(/*! ./_to-primitive */ "./node_modules/core-js/modules/_to-primitive.js");\nvar createDesc = __webpack_require__(/*! ./_property-desc */ "./node_modules/core-js/modules/_property-desc.js");\nvar _create = __webpack_require__(/*! ./_object-create */ "./node_modules/core-js/modules/_object-create.js");\nvar gOPNExt = __webpack_require__(/*! ./_object-gopn-ext */ "./node_modules/core-js/modules/_object-gopn-ext.js");\nvar $GOPD = __webpack_require__(/*! ./_object-gopd */ "./node_modules/core-js/modules/_object-gopd.js");\nvar $GOPS = __webpack_require__(/*! ./_object-gops */ "./node_modules/core-js/modules/_object-gops.js");\nvar $DP = __webpack_require__(/*! ./_object-dp */ "./node_modules/core-js/modules/_object-dp.js");\nvar $keys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/modules/_object-keys.js");\nvar gOPD = $GOPD.f;\nvar dP = $DP.f;\nvar gOPN = gOPNExt.f;\nvar $Symbol = global.Symbol;\nvar $JSON = global.JSON;\nvar _stringify = $JSON && $JSON.stringify;\nvar PROTOTYPE = \'prototype\';\nvar HIDDEN = wks(\'_hidden\');\nvar TO_PRIMITIVE = wks(\'toPrimitive\');\nvar isEnum = {}.propertyIsEnumerable;\nvar SymbolRegistry = shared(\'symbol-registry\');\nvar AllSymbols = shared(\'symbols\');\nvar OPSymbols = shared(\'op-symbols\');\nvar ObjectProto = Object[PROTOTYPE];\nvar USE_NATIVE = typeof $Symbol == \'function\' && !!$GOPS.f;\nvar QObject = global.QObject;\n// Don\'t use setters in Qt Script, https://github.com/zloirock/core-js/issues/173\nvar setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;\n\n// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687\nvar setSymbolDesc = DESCRIPTORS && $fails(function () {\n  return _create(dP({}, \'a\', {\n    get: function () { return dP(this, \'a\', { value: 7 }).a; }\n  })).a != 7;\n}) ? function (it, key, D) {\n  var protoDesc = gOPD(ObjectProto, key);\n  if (protoDesc) delete ObjectProto[key];\n  dP(it, key, D);\n  if (protoDesc && it !== ObjectProto) dP(ObjectProto, key, protoDesc);\n} : dP;\n\nvar wrap = function (tag) {\n  var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);\n  sym._k = tag;\n  return sym;\n};\n\nvar isSymbol = USE_NATIVE && typeof $Symbol.iterator == \'symbol\' ? function (it) {\n  return typeof it == \'symbol\';\n} : function (it) {\n  return it instanceof $Symbol;\n};\n\nvar $defineProperty = function defineProperty(it, key, D) {\n  if (it === ObjectProto) $defineProperty(OPSymbols, key, D);\n  anObject(it);\n  key = toPrimitive(key, true);\n  anObject(D);\n  if (has(AllSymbols, key)) {\n    if (!D.enumerable) {\n      if (!has(it, HIDDEN)) dP(it, HIDDEN, createDesc(1, {}));\n      it[HIDDEN][key] = true;\n    } else {\n      if (has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;\n      D = _create(D, { enumerable: createDesc(0, false) });\n    } return setSymbolDesc(it, key, D);\n  } return dP(it, key, D);\n};\nvar $defineProperties = function defineProperties(it, P) {\n  anObject(it);\n  var keys = enumKeys(P = toIObject(P));\n  var i = 0;\n  var l = keys.length;\n  var key;\n  while (l > i) $defineProperty(it, key = keys[i++], P[key]);\n  return it;\n};\nvar $create = function create(it, P) {\n  return P === undefined ? _create(it) : $defineProperties(_create(it), P);\n};\nvar $propertyIsEnumerable = function propertyIsEnumerable(key) {\n  var E = isEnum.call(this, key = toPrimitive(key, true));\n  if (this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return false;\n  return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;\n};\nvar $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {\n  it = toIObject(it);\n  key = toPrimitive(key, true);\n  if (it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return;\n  var D = gOPD(it, key);\n  if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;\n  return D;\n};\nvar $getOwnPropertyNames = function getOwnPropertyNames(it) {\n  var names = gOPN(toIObject(it));\n  var result = [];\n  var i = 0;\n  var key;\n  while (names.length > i) {\n    if (!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);\n  } return result;\n};\nvar $getOwnPropertySymbols = function getOwnPropertySymbols(it) {\n  var IS_OP = it === ObjectProto;\n  var names = gOPN(IS_OP ? OPSymbols : toIObject(it));\n  var result = [];\n  var i = 0;\n  var key;\n  while (names.length > i) {\n    if (has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true)) result.push(AllSymbols[key]);\n  } return result;\n};\n\n// 19.4.1.1 Symbol([description])\nif (!USE_NATIVE) {\n  $Symbol = function Symbol() {\n    if (this instanceof $Symbol) throw TypeError(\'Symbol is not a constructor!\');\n    var tag = uid(arguments.length > 0 ? arguments[0] : undefined);\n    var $set = function (value) {\n      if (this === ObjectProto) $set.call(OPSymbols, value);\n      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;\n      setSymbolDesc(this, tag, createDesc(1, value));\n    };\n    if (DESCRIPTORS && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });\n    return wrap(tag);\n  };\n  redefine($Symbol[PROTOTYPE], \'toString\', function toString() {\n    return this._k;\n  });\n\n  $GOPD.f = $getOwnPropertyDescriptor;\n  $DP.f = $defineProperty;\n  (__webpack_require__(/*! ./_object-gopn */ "./node_modules/core-js/modules/_object-gopn.js").f) = gOPNExt.f = $getOwnPropertyNames;\n  (__webpack_require__(/*! ./_object-pie */ "./node_modules/core-js/modules/_object-pie.js").f) = $propertyIsEnumerable;\n  $GOPS.f = $getOwnPropertySymbols;\n\n  if (DESCRIPTORS && !__webpack_require__(/*! ./_library */ "./node_modules/core-js/modules/_library.js")) {\n    redefine(ObjectProto, \'propertyIsEnumerable\', $propertyIsEnumerable, true);\n  }\n\n  wksExt.f = function (name) {\n    return wrap(wks(name));\n  };\n}\n\n$export($export.G + $export.W + $export.F * !USE_NATIVE, { Symbol: $Symbol });\n\nfor (var es6Symbols = (\n  // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14\n  \'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables\'\n).split(\',\'), j = 0; es6Symbols.length > j;)wks(es6Symbols[j++]);\n\nfor (var wellKnownSymbols = $keys(wks.store), k = 0; wellKnownSymbols.length > k;) wksDefine(wellKnownSymbols[k++]);\n\n$export($export.S + $export.F * !USE_NATIVE, \'Symbol\', {\n  // 19.4.2.1 Symbol.for(key)\n  \'for\': function (key) {\n    return has(SymbolRegistry, key += \'\')\n      ? SymbolRegistry[key]\n      : SymbolRegistry[key] = $Symbol(key);\n  },\n  // 19.4.2.5 Symbol.keyFor(sym)\n  keyFor: function keyFor(sym) {\n    if (!isSymbol(sym)) throw TypeError(sym + \' is not a symbol!\');\n    for (var key in SymbolRegistry) if (SymbolRegistry[key] === sym) return key;\n  },\n  useSetter: function () { setter = true; },\n  useSimple: function () { setter = false; }\n});\n\n$export($export.S + $export.F * !USE_NATIVE, \'Object\', {\n  // 19.1.2.2 Object.create(O [, Properties])\n  create: $create,\n  // 19.1.2.4 Object.defineProperty(O, P, Attributes)\n  defineProperty: $defineProperty,\n  // 19.1.2.3 Object.defineProperties(O, Properties)\n  defineProperties: $defineProperties,\n  // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)\n  getOwnPropertyDescriptor: $getOwnPropertyDescriptor,\n  // 19.1.2.7 Object.getOwnPropertyNames(O)\n  getOwnPropertyNames: $getOwnPropertyNames,\n  // 19.1.2.8 Object.getOwnPropertySymbols(O)\n  getOwnPropertySymbols: $getOwnPropertySymbols\n});\n\n// Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives\n// https://bugs.chromium.org/p/v8/issues/detail?id=3443\nvar FAILS_ON_PRIMITIVES = $fails(function () { $GOPS.f(1); });\n\n$export($export.S + $export.F * FAILS_ON_PRIMITIVES, \'Object\', {\n  getOwnPropertySymbols: function getOwnPropertySymbols(it) {\n    return $GOPS.f(toObject(it));\n  }\n});\n\n// 24.3.2 JSON.stringify(value [, replacer [, space]])\n$JSON && $export($export.S + $export.F * (!USE_NATIVE || $fails(function () {\n  var S = $Symbol();\n  // MS Edge converts symbol values to JSON as {}\n  // WebKit converts symbol values to JSON as null\n  // V8 throws on boxed symbols\n  return _stringify([S]) != \'[null]\' || _stringify({ a: S }) != \'{}\' || _stringify(Object(S)) != \'{}\';\n})), \'JSON\', {\n  stringify: function stringify(it) {\n    var args = [it];\n    var i = 1;\n    var replacer, $replacer;\n    while (arguments.length > i) args.push(arguments[i++]);\n    $replacer = replacer = args[1];\n    if (!isObject(replacer) && it === undefined || isSymbol(it)) return; // IE8 returns string on undefined\n    if (!isArray(replacer)) replacer = function (key, value) {\n      if (typeof $replacer == \'function\') value = $replacer.call(this, key, value);\n      if (!isSymbol(value)) return value;\n    };\n    args[1] = replacer;\n    return _stringify.apply($JSON, args);\n  }\n});\n\n// 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)\n$Symbol[PROTOTYPE][TO_PRIMITIVE] || __webpack_require__(/*! ./_hide */ "./node_modules/core-js/modules/_hide.js")($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);\n// 19.4.3.5 Symbol.prototype[@@toStringTag]\nsetToStringTag($Symbol, \'Symbol\');\n// 20.2.1.9 Math[@@toStringTag]\nsetToStringTag(Math, \'Math\', true);\n// 24.3.3 JSON[@@toStringTag]\nsetToStringTag(global.JSON, \'JSON\', true);\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es6.symbol.js?')},"./node_modules/core-js/modules/es7.object.get-own-property-descriptors.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('// https://github.com/tc39/proposal-object-getownpropertydescriptors\nvar $export = __webpack_require__(/*! ./_export */ "./node_modules/core-js/modules/_export.js");\nvar ownKeys = __webpack_require__(/*! ./_own-keys */ "./node_modules/core-js/modules/_own-keys.js");\nvar toIObject = __webpack_require__(/*! ./_to-iobject */ "./node_modules/core-js/modules/_to-iobject.js");\nvar gOPD = __webpack_require__(/*! ./_object-gopd */ "./node_modules/core-js/modules/_object-gopd.js");\nvar createProperty = __webpack_require__(/*! ./_create-property */ "./node_modules/core-js/modules/_create-property.js");\n\n$export($export.S, \'Object\', {\n  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {\n    var O = toIObject(object);\n    var getDesc = gOPD.f;\n    var keys = ownKeys(O);\n    var result = {};\n    var i = 0;\n    var key, desc;\n    while (keys.length > i) {\n      desc = getDesc(O, key = keys[i++]);\n      if (desc !== undefined) createProperty(result, key, desc);\n    }\n    return result;\n  }\n});\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/es7.object.get-own-property-descriptors.js?')},"./node_modules/core-js/modules/web.dom.iterable.js":(__unused_webpack_module,__unused_webpack_exports,__webpack_require__)=>{eval('var $iterators = __webpack_require__(/*! ./es6.array.iterator */ "./node_modules/core-js/modules/es6.array.iterator.js");\nvar getKeys = __webpack_require__(/*! ./_object-keys */ "./node_modules/core-js/modules/_object-keys.js");\nvar redefine = __webpack_require__(/*! ./_redefine */ "./node_modules/core-js/modules/_redefine.js");\nvar global = __webpack_require__(/*! ./_global */ "./node_modules/core-js/modules/_global.js");\nvar hide = __webpack_require__(/*! ./_hide */ "./node_modules/core-js/modules/_hide.js");\nvar Iterators = __webpack_require__(/*! ./_iterators */ "./node_modules/core-js/modules/_iterators.js");\nvar wks = __webpack_require__(/*! ./_wks */ "./node_modules/core-js/modules/_wks.js");\nvar ITERATOR = wks(\'iterator\');\nvar TO_STRING_TAG = wks(\'toStringTag\');\nvar ArrayValues = Iterators.Array;\n\nvar DOMIterables = {\n  CSSRuleList: true, // TODO: Not spec compliant, should be false.\n  CSSStyleDeclaration: false,\n  CSSValueList: false,\n  ClientRectList: false,\n  DOMRectList: false,\n  DOMStringList: false,\n  DOMTokenList: true,\n  DataTransferItemList: false,\n  FileList: false,\n  HTMLAllCollection: false,\n  HTMLCollection: false,\n  HTMLFormElement: false,\n  HTMLSelectElement: false,\n  MediaList: true, // TODO: Not spec compliant, should be false.\n  MimeTypeArray: false,\n  NamedNodeMap: false,\n  NodeList: true,\n  PaintRequestList: false,\n  Plugin: false,\n  PluginArray: false,\n  SVGLengthList: false,\n  SVGNumberList: false,\n  SVGPathSegList: false,\n  SVGPointList: false,\n  SVGStringList: false,\n  SVGTransformList: false,\n  SourceBufferList: false,\n  StyleSheetList: true, // TODO: Not spec compliant, should be false.\n  TextTrackCueList: false,\n  TextTrackList: false,\n  TouchList: false\n};\n\nfor (var collections = getKeys(DOMIterables), i = 0; i < collections.length; i++) {\n  var NAME = collections[i];\n  var explicit = DOMIterables[NAME];\n  var Collection = global[NAME];\n  var proto = Collection && Collection.prototype;\n  var key;\n  if (proto) {\n    if (!proto[ITERATOR]) hide(proto, ITERATOR, ArrayValues);\n    if (!proto[TO_STRING_TAG]) hide(proto, TO_STRING_TAG, NAME);\n    Iterators[NAME] = ArrayValues;\n    if (explicit) for (key in $iterators) if (!proto[key]) redefine(proto, key, $iterators[key], true);\n  }\n}\n\n\n//# sourceURL=webpack://web/./node_modules/core-js/modules/web.dom.iterable.js?')},"./node_modules/dashjs/dist/dash.all.min.js":module=>{eval('/*! For license information please see dash.all.min.js.LICENSE.txt */\n!function(e,t){ true?module.exports=t():0}(self,(function(){return function(){var e={4593:function(e,t){var n,r,i,o,u,l=function(e){for(var t=[],n=0;n<e.length;++n){var r=e.charCodeAt(n);r<128?t.push(r):r<2048?(t.push(192|r>>6),t.push(128|63&r)):r<65536?(t.push(224|r>>12),t.push(128|63&r>>6),t.push(128|63&r)):(t.push(240|r>>18),t.push(128|63&r>>12),t.push(128|63&r>>6),t.push(128|63&r))}return t},c=function(e){for(var t=[],n=0;n<e.length;){var r=e[n++];r<128||(r<224?(r=(31&r)<<6,r|=63&e[n++]):r<240?(r=(15&r)<<12,r|=(63&e[n++])<<6,r|=63&e[n++]):(r=(7&r)<<18,r|=(63&e[n++])<<12,r|=(63&e[n++])<<6,r|=63&e[n++])),t.push(String.fromCharCode(r))}return t.join("")},f={};n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",r=function(e){for(var t=0,r=[],i=0|e.length/3;0<i--;){var a=(e[t]<<16)+(e[t+1]<<8)+e[t+2];t+=3,r.push(n.charAt(63&a>>18)),r.push(n.charAt(63&a>>12)),r.push(n.charAt(63&a>>6)),r.push(n.charAt(63&a))}return 2==e.length-t?(a=(e[t]<<16)+(e[t+1]<<8),r.push(n.charAt(63&a>>18)),r.push(n.charAt(63&a>>12)),r.push(n.charAt(63&a>>6)),r.push("=")):1==e.length-t&&(a=e[t]<<16,r.push(n.charAt(63&a>>18)),r.push(n.charAt(63&a>>12)),r.push("==")),r.join("")},i=function(){for(var e=[],t=0;t<n.length;++t)e[n.charCodeAt(t)]=t;return e["=".charCodeAt(0)]=0,e}(),o=function(e){for(var t=0,n=[],r=0|e.length/4;0<r--;){var a=(i[e.charCodeAt(t)]<<18)+(i[e.charCodeAt(t+1)]<<12)+(i[e.charCodeAt(t+2)]<<6)+i[e.charCodeAt(t+3)];n.push(255&a>>16),n.push(255&a>>8),n.push(255&a),t+=4}return n&&("="==e.charAt(t-2)?(n.pop(),n.pop()):"="==e.charAt(t-1)&&n.pop()),n},u={encode:function(e){for(var t=[],n=0;n<e.length;++n)t.push(e.charCodeAt(n));return t},decode:function(e){for(var t=0;t<s.length;++t)a[t]=String.fromCharCode(a[t]);return a.join("")}},f.decodeArray=function(e){var t=o(e);return new Uint8Array(t)},f.encodeASCII=function(e){var t=u.encode(e);return r(t)},f.decodeASCII=function(e){var t=o(e);return u.decode(t)},f.encode=function(e){var t=l(e);return r(t)},f.decode=function(e){var t=o(e);return c(t)},t.decode=f.decode,t.decodeArray=f.decodeArray,t.encode=f.encode,t.encodeASCII=f.encodeASCII},452:function(e,t){!function(e){"use strict";var t={42:225,92:233,94:237,95:243,96:250,123:231,124:247,125:209,126:241,127:9608,128:174,129:176,130:189,131:191,132:8482,133:162,134:163,135:9834,136:224,137:32,138:232,139:226,140:234,141:238,142:244,143:251,144:193,145:201,146:211,147:218,148:220,149:252,150:8216,151:161,152:42,153:8217,154:9473,155:169,156:8480,157:8226,158:8220,159:8221,160:192,161:194,162:199,163:200,164:202,165:203,166:235,167:206,168:207,169:239,170:212,171:217,172:249,173:219,174:171,175:187,176:195,177:227,178:205,179:204,180:236,181:210,182:242,183:213,184:245,185:123,186:125,187:92,188:94,189:95,190:124,191:8764,192:196,193:228,194:214,195:246,196:223,197:165,198:164,199:9475,200:197,201:229,202:216,203:248,204:9487,205:9491,206:9495,207:9499},n=function(e){var n=e;return t.hasOwnProperty(e)&&(n=t[e]),String.fromCharCode(n)},r=15,i=32,a={17:1,18:3,21:5,22:7,23:9,16:11,19:12,20:14},o={17:2,18:4,21:6,22:8,23:10,19:13,20:15},s={25:1,26:3,29:5,30:7,31:9,24:11,27:12,28:14},u={25:2,26:4,29:6,30:8,31:10,27:13,28:15},l=["white","green","blue","cyan","red","yellow","magenta","black","transparent"],c={verboseFilter:{DATA:3,DEBUG:3,INFO:2,WARNING:2,TEXT:1,ERROR:0},time:null,verboseLevel:0,setTime:function(e){this.time=e},log:function(e,t){var n=this.verboseFilter[e];this.verboseLevel>=n&&console.log(this.time+" ["+e+"] "+t)}},f=function(e){for(var t=[],n=0;n<e.length;n++)t.push(e[n].toString(16));return t},d=function(e,t,n,r,i){this.foreground=e||"white",this.underline=t||!1,this.italics=n||!1,this.background=r||"black",this.flash=i||!1};d.prototype={reset:function(){this.foreground="white",this.underline=!1,this.italics=!1,this.background="black",this.flash=!1},setStyles:function(e){for(var t=["foreground","underline","italics","background","flash"],n=0;n<t.length;n++){var r=t[n];e.hasOwnProperty(r)&&(this[r]=e[r])}},isDefault:function(){return"white"===this.foreground&&!this.underline&&!this.italics&&"black"===this.background&&!this.flash},equals:function(e){return this.foreground===e.foreground&&this.underline===e.underline&&this.italics===e.italics&&this.background===e.background&&this.flash===e.flash},copy:function(e){this.foreground=e.foreground,this.underline=e.underline,this.italics=e.italics,this.background=e.background,this.flash=e.flash},toString:function(){return"color="+this.foreground+", underline="+this.underline+", italics="+this.italics+", background="+this.background+", flash="+this.flash}};var g=function(e,t,n,r,i,a){this.uchar=e||" ",this.penState=new d(t,n,r,i,a)};g.prototype={reset:function(){this.uchar=" ",this.penState.reset()},setChar:function(e,t){this.uchar=e,this.penState.copy(t)},setPenState:function(e){this.penState.copy(e)},equals:function(e){return this.uchar===e.uchar&&this.penState.equals(e.penState)},copy:function(e){this.uchar=e.uchar,this.penState.copy(e.penState)},isEmpty:function(){return" "===this.uchar&&this.penState.isDefault()}};var h=function(){this.chars=[];for(var e=0;e<i;e++)this.chars.push(new g);this.pos=0,this.currPenState=new d};h.prototype={equals:function(e){for(var t=!0,n=0;n<i;n++)if(!this.chars[n].equals(e.chars[n])){t=!1;break}return t},copy:function(e){for(var t=0;t<i;t++)this.chars[t].copy(e.chars[t])},isEmpty:function(){for(var e=!0,t=0;t<i;t++)if(!this.chars[t].isEmpty()){e=!1;break}return e},setCursor:function(e){this.pos!==e&&(this.pos=e),this.pos<0?(c.log("ERROR","Negative cursor position "+this.pos),this.pos=0):this.pos>i&&(c.log("ERROR","Too large cursor position "+this.pos),this.pos=i)},moveCursor:function(e){var t=this.pos+e;if(e>1)for(var n=this.pos+1;n<t+1;n++)this.chars[n].setPenState(this.currPenState);this.setCursor(t)},backSpace:function(){this.moveCursor(-1),this.chars[this.pos].setChar(" ",this.currPenState)},insertChar:function(e){e>=144&&this.backSpace();var t=n(e);this.pos>=i?c.log("ERROR","Cannot insert "+e.toString(16)+" ("+t+") at position "+this.pos+". Skipping it!"):(this.chars[this.pos].setChar(t,this.currPenState),this.moveCursor(1))},clearFromPos:function(e){var t;for(t=e;t<i;t++)this.chars[t].reset()},clear:function(){this.clearFromPos(0),this.pos=0,this.currPenState.reset()},clearToEndOfRow:function(){this.clearFromPos(this.pos)},getTextString:function(){for(var e=[],t=!0,n=0;n<i;n++){var r=this.chars[n].uchar;" "!==r&&(t=!1),e.push(r)}return t?"":e.join("")},setPenStyles:function(e){this.currPenState.setStyles(e),this.chars[this.pos].setPenState(this.currPenState)}};var p=function(){this.rows=[];for(var e=0;e<r;e++)this.rows.push(new h);this.currRow=14,this.nrRollUpRows=null,this.reset()};p.prototype={reset:function(){for(var e=0;e<r;e++)this.rows[e].clear();this.currRow=14},equals:function(e){for(var t=!0,n=0;n<r;n++)if(!this.rows[n].equals(e.rows[n])){t=!1;break}return t},copy:function(e){for(var t=0;t<r;t++)this.rows[t].copy(e.rows[t])},isEmpty:function(){for(var e=!0,t=0;t<r;t++)if(!this.rows[t].isEmpty()){e=!1;break}return e},backSpace:function(){this.rows[this.currRow].backSpace()},clearToEndOfRow:function(){this.rows[this.currRow].clearToEndOfRow()},insertChar:function(e){this.rows[this.currRow].insertChar(e)},setPen:function(e){this.rows[this.currRow].setPenStyles(e)},moveCursor:function(e){this.rows[this.currRow].moveCursor(e)},setCursor:function(e){c.log("INFO","setCursor: "+e),this.rows[this.currRow].setCursor(e)},setPAC:function(e){c.log("INFO","pacData = "+JSON.stringify(e));var t=e.row-1;this.nrRollUpRows&&t<this.nrRollUpRows-1&&(t=this.nrRollUpRows-1),this.currRow=t;var n=this.rows[this.currRow];if(null!==e.indent){var r=e.indent,i=Math.max(r-1,0);n.setCursor(e.indent),e.color=n.chars[i].penState.foreground}var a={foreground:e.color,underline:e.underline,italics:e.italics,background:"black",flash:!1};this.setPen(a)},setBkgData:function(e){c.log("INFO","bkgData = "+JSON.stringify(e)),this.backSpace(),this.setPen(e),this.insertChar(32)},setRollUpRows:function(e){this.nrRollUpRows=e},rollUp:function(){if(null!==this.nrRollUpRows){c.log("TEXT",this.getDisplayText());var e=this.currRow+1-this.nrRollUpRows,t=this.rows.splice(e,1)[0];t.clear(),this.rows.splice(this.currRow,0,t),c.log("INFO","Rolling up")}else c.log("DEBUG","roll_up but nrRollUpRows not set yet")},getDisplayText:function(e){e=e||!1;for(var t=[],n="",i=-1,a=0;a<r;a++){var o=this.rows[a].getTextString();o&&(i=a+1,e?t.push("Row "+i+\': "\'+o+\'"\'):t.push(o.trim()))}return t.length>0&&(n=e?"["+t.join(" | ")+"]":t.join("\\n")),n},getTextAndFormat:function(){return this.rows}};var m=function(e,t){this.chNr=e,this.outputFilter=t,this.mode=null,this.verbose=0,this.displayedMemory=new p,this.nonDisplayedMemory=new p,this.lastOutputScreen=new p,this.currRollUpRow=this.displayedMemory.rows[14],this.writeScreen=this.displayedMemory,this.mode=null,this.cueStartTime=null};m.prototype={modes:["MODE_ROLL-UP","MODE_POP-ON","MODE_PAINT-ON","MODE_TEXT"],reset:function(){this.mode=null,this.displayedMemory.reset(),this.nonDisplayedMemory.reset(),this.lastOutputScreen.reset(),this.currRollUpRow=this.displayedMemory.rows[14],this.writeScreen=this.displayedMemory,this.mode=null,this.cueStartTime=null,this.lastCueEndTime=null},getHandler:function(){return this.outputFilter},setHandler:function(e){this.outputFilter=e},setPAC:function(e){this.writeScreen.setPAC(e)},setBkgData:function(e){this.writeScreen.setBkgData(e)},setMode:function(e){e!==this.mode&&(this.mode=e,c.log("INFO","MODE="+e),"MODE_POP-ON"==this.mode?this.writeScreen=this.nonDisplayedMemory:(this.writeScreen=this.displayedMemory,this.writeScreen.reset()),"MODE_ROLL-UP"!==this.mode&&(this.displayedMemory.nrRollUpRows=null,this.nonDisplayedMemory.nrRollUpRows=null),this.mode=e)},insertChars:function(e){for(var t=0;t<e.length;t++)this.writeScreen.insertChar(e[t]);var n=this.writeScreen===this.displayedMemory?"DISP":"NON_DISP";c.log("INFO",n+": "+this.writeScreen.getDisplayText(!0)),"MODE_PAINT-ON"!==this.mode&&"MODE_ROLL-UP"!==this.mode||(c.log("TEXT","DISPLAYED: "+this.displayedMemory.getDisplayText(!0)),this.outputDataUpdate())},cc_RCL:function(){c.log("INFO","RCL - Resume Caption Loading"),this.setMode("MODE_POP-ON")},cc_BS:function(){c.log("INFO","BS - BackSpace"),"MODE_TEXT"!==this.mode&&(this.writeScreen.backSpace(),this.writeScreen===this.displayedMemory&&this.outputDataUpdate())},cc_AOF:function(){},cc_AON:function(){},cc_DER:function(){c.log("INFO","DER- Delete to End of Row"),this.writeScreen.clearToEndOfRow(),this.outputDataUpdate()},cc_RU:function(e){c.log("INFO","RU("+e+") - Roll Up"),this.writeScreen=this.displayedMemory,this.setMode("MODE_ROLL-UP"),this.writeScreen.setRollUpRows(e)},cc_FON:function(){c.log("INFO","FON - Flash On"),this.writeScreen.setPen({flash:!0})},cc_RDC:function(){c.log("INFO","RDC - Resume Direct Captioning"),this.setMode("MODE_PAINT-ON")},cc_TR:function(){c.log("INFO","TR"),this.setMode("MODE_TEXT")},cc_RTD:function(){c.log("INFO","RTD"),this.setMode("MODE_TEXT")},cc_EDM:function(){c.log("INFO","EDM - Erase Displayed Memory"),this.displayedMemory.reset(),this.outputDataUpdate()},cc_CR:function(){c.log("CR - Carriage Return"),this.writeScreen.rollUp(),this.outputDataUpdate()},cc_ENM:function(){c.log("INFO","ENM - Erase Non-displayed Memory"),this.nonDisplayedMemory.reset()},cc_EOC:function(){if(c.log("INFO","EOC - End Of Caption"),"MODE_POP-ON"===this.mode){var e=this.displayedMemory;this.displayedMemory=this.nonDisplayedMemory,this.nonDisplayedMemory=e,this.writeScreen=this.nonDisplayedMemory,c.log("TEXT","DISP: "+this.displayedMemory.getDisplayText())}this.outputDataUpdate()},cc_TO:function(e){c.log("INFO","TO("+e+") - Tab Offset"),this.writeScreen.moveCursor(e)},cc_MIDROW:function(e){var t={flash:!1};if(t.underline=e%2==1,t.italics=e>=46,t.italics)t.foreground="white";else{var n=Math.floor(e/2)-16;t.foreground=["white","green","blue","cyan","red","yellow","magenta"][n]}c.log("INFO","MIDROW: "+JSON.stringify(t)),this.writeScreen.setPen(t)},outputDataUpdate:function(){var e=c.time;null!==e&&this.outputFilter&&(this.outputFilter.updateData&&this.outputFilter.updateData(e,this.displayedMemory),null!==this.cueStartTime||this.displayedMemory.isEmpty()?this.displayedMemory.equals(this.lastOutputScreen)||(this.outputFilter.newCue&&this.outputFilter.newCue(this.cueStartTime,e,this.lastOutputScreen),this.cueStartTime=this.displayedMemory.isEmpty()?null:e):this.cueStartTime=e,this.lastOutputScreen.copy(this.displayedMemory))},cueSplitAtTime:function(e){this.outputFilter&&(this.displayedMemory.isEmpty()||(this.outputFilter.newCue&&this.outputFilter.newCue(this.cueStartTime,e,this.displayedMemory),this.cueStartTime=e))}};var y=function(e,t,n){this.field=e||1,this.outputs=[t,n],this.channels=[new m(1,t),new m(2,n)],this.currChNr=-1,this.lastCmdA=null,this.lastCmdB=null,this.bufferedData=[],this.startTime=null,this.lastTime=null,this.dataCounters={padding:0,char:0,cmd:0,other:0}};y.prototype={getHandler:function(e){return this.channels[e].getHandler()},setHandler:function(e,t){this.channels[e].setHandler(t)},addData:function(e,t){var n,r,i,a=!1;this.lastTime=e,c.setTime(e);for(var o=0;o<t.length;o+=2)r=127&t[o],i=127&t[o+1],r>=16&&r<=31&&r===this.lastCmdA&&i===this.lastCmdB?(this.lastCmdA=null,this.lastCmdB=null,c.log("DEBUG","Repeated command ("+f([r,i])+") is dropped")):0!==r||0!==i?(c.log("DATA","["+f([t[o],t[o+1]])+"] -> ("+f([r,i])+")"),(n=this.parseCmd(r,i))||(n=this.parseMidrow(r,i)),n||(n=this.parsePAC(r,i)),n||(n=this.parseBackgroundAttributes(r,i)),n||(a=this.parseChars(r,i))&&(this.currChNr&&this.currChNr>=0?this.channels[this.currChNr-1].insertChars(a):c.log("WARNING","No channel found yet. TEXT-MODE?")),n?this.dataCounters.cmd+=2:a?this.dataCounters.char+=2:(this.dataCounters.other+=2,c.log("WARNING","Couldn\'t parse cleaned data "+f([r,i])+" orig: "+f([t[o],t[o+1]])))):this.dataCounters.padding+=2},parseCmd:function(e,t){var n;if(!((20===e||21===e||28===e||29===e)&&32<=t&&t<=47||(23===e||31===e)&&33<=t&&t<=35))return!1;n=20===e||21===e||23===e?1:2;var r=this.channels[n-1];return 20===e||21===e||28===e||29===e?32===t?r.cc_RCL():33===t?r.cc_BS():34===t?r.cc_AOF():35===t?r.cc_AON():36===t?r.cc_DER():37===t?r.cc_RU(2):38===t?r.cc_RU(3):39===t?r.cc_RU(4):40===t?r.cc_FON():41===t?r.cc_RDC():42===t?r.cc_TR():43===t?r.cc_RTD():44===t?r.cc_EDM():45===t?r.cc_CR():46===t?r.cc_ENM():47===t&&r.cc_EOC():r.cc_TO(t-32),this.lastCmdA=e,this.lastCmdB=t,this.currChNr=n,!0},parseMidrow:function(e,t){var n=null;if((17===e||25===e)&&32<=t&&t<=47){if((n=17===e?1:2)!==this.currChNr)return c.log("ERROR","Mismatch channel in midrow parsing"),!1;var r=this.channels[n-1];return r.insertChars([32]),r.cc_MIDROW(t),c.log("DEBUG","MIDROW ("+f([e,t])+")"),this.lastCmdA=e,this.lastCmdB=t,!0}return!1},parsePAC:function(e,t){var n,r;if(!((17<=e&&e<=23||25<=e&&e<=31)&&64<=t&&t<=127||(16===e||24===e)&&64<=t&&t<=95))return!1;n=e<=23?1:2,r=64<=t&&t<=95?1===n?a[e]:s[e]:1===n?o[e]:u[e];var i=this.interpretPAC(r,t);return this.channels[n-1].setPAC(i),this.lastCmdA=e,this.lastCmdB=t,this.currChNr=n,!0},interpretPAC:function(e,t){var n,r={color:null,italics:!1,indent:null,underline:!1,row:e};return n=t>95?t-96:t-64,r.underline=1==(1&n),n<=13?r.color=["white","green","blue","cyan","red","yellow","magenta","white"][Math.floor(n/2)]:n<=15?(r.italics=!0,r.color="white"):r.indent=4*Math.floor((n-16)/2),r},parseChars:function(e,t){var r=null,i=null,a=null;if(e>=25?(r=2,a=e-8):(r=1,a=e),17<=a&&a<=19){var o;o=17===a?t+80:18===a?t+112:t+144,c.log("INFO","Special char \'"+n(o)+"\' in channel "+r),i=[o],this.lastCmdA=e,this.lastCmdB=t}else 32<=e&&e<=127&&(i=0===t?[e]:[e,t],this.lastCmdA=null,this.lastCmdB=null);if(i){var s=f(i);c.log("DEBUG","Char codes =  "+s.join(","))}return i},parseBackgroundAttributes:function(e,t){var n,r,i;return((16===e||24===e)&&32<=t&&t<=47||(23===e||31===e)&&45<=t&&t<=47)&&(n={},16===e||24===e?(r=Math.floor((t-32)/2),n.background=l[r],t%2==1&&(n.background=n.background+"_semi")):45===t?n.background="transparent":(n.foreground="black",47===t&&(n.underline=!0)),i=e<24?1:2,this.channels[i-1].setBkgData(n),this.lastCmdA=e,this.lastCmdB=t,!0)},reset:function(){for(var e=0;e<this.channels.length;e++)this.channels[e]&&this.channels[e].reset();this.lastCmdA=null,this.lastCmdB=null},cueSplitAtTime:function(e){for(var t=0;t<this.channels.length;t++)this.channels[t]&&this.channels[t].cueSplitAtTime(e)}},e.logger=c,e.PenState=d,e.CaptionScreen=p,e.Cea608Parser=y,e.findCea608Nalus=function(e,t,n){for(var r=0,i=t,a=[],o=function(e,t,n,r){if(4!==e||t<8)return null;var i=n.getUint8(r),a=n.getUint16(r+1),o=n.getUint32(r+3),s=n.getUint8(r+7);return 181==i&&49==a&&1195456820==o&&3==s};i<t+n;){if(r=e.getUint32(i),6==(31&e.getUint8(i+4)))for(var s=i+5,u=-1;s<i+4+r-1;){u=0;for(var l=255;255===l;)u+=l=e.getUint8(s),s++;var c=0;for(l=255;255===l;)c+=l=e.getUint8(s),s++;o(u,c,e,s)&&a.push([s,c]),s+=c}i+=r+4}return a},e.extractCea608DataFromRange=function(e,t){var n=t[0],r=[[],[]];n+=8;var i=31&e.getUint8(n);n+=2;for(var a=0;a<i;a++){var o=e.getUint8(n),s=4&o,u=3&o;n++;var l=e.getUint8(n);n++;var c=e.getUint8(n);n++,s&&(127&l)+(127&c)!=0&&(0===u?(r[0].push(l),r[0].push(c)):1===u&&(r[1].push(l),r[1].push(c)))}return r}}(t)},8416:function(e,t,n){"use strict";var r=n(7688),i=n(5448),a=n(6398),o=n(2032),s=(n(5530),"undefined"!=typeof window&&window||n.g),u=s.dashjs;u||(u=s.dashjs={}),u.MediaPlayer=r.Z,u.FactoryMaker=i.Z,u.Debug=a.Z,u.Version=(0,o.e)()},6398:function(e,t,n){"use strict";var r=n(5595),i=n(8512),a=n(5448),o=1,s=2,u=3,l=4,c=5;function f(e){e=e||{};var t,n,a,f,d=this.context,g=(0,r.Z)(d).getInstance(),h=e.settings,p=[];function m(e){return e&&e.bind?e.bind(window.console):window.console.log.bind(window.console)}function y(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];S.apply(void 0,[o,this].concat(t))}function E(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];S.apply(void 0,[s,this].concat(t))}function v(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];S.apply(void 0,[u,this].concat(t))}function _(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];S.apply(void 0,[l,this].concat(t))}function T(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];S.apply(void 0,[c,this].concat(t))}function S(e,t){var r="",o=null;n&&(o=(new Date).getTime(),r+="["+(o-f)+"]"),a&&t&&t.getClassName&&(r+="["+t.getClassName()+"]",t.getType&&(r+="["+t.getType()+"]")),r.length>0&&(r+=" ");for(var s=arguments.length,u=new Array(s>2?s-2:0),l=2;l<s;l++)u[l-2]=arguments[l];Array.apply(null,u).forEach((function(e){r+=e+" "})),p[e]&&h&&h.get().debug.logLevel>=e&&p[e](r),h&&h.get().debug.dispatchEvent&&g.trigger(i.Z.LOG,{message:r,level:e})}return t={getLogger:function(e){return{fatal:y.bind(e),error:E.bind(e),warn:v.bind(e),info:_.bind(e),debug:T.bind(e)}},setLogTimestampVisible:function(e){n=e},setCalleeNameVisible:function(e){a=e}},n=!0,a=!0,f=(new Date).getTime(),"undefined"!=typeof window&&window.console&&(p[o]=m(window.console.error),p[s]=m(window.console.error),p[u]=m(window.console.warn),p[l]=m(window.console.info),p[c]=m(window.console.debug)),t}f.__dashjs_factory_name="Debug";var d=a.Z.getSingletonFactory(f);d.LOG_LEVEL_NONE=0,d.LOG_LEVEL_FATAL=o,d.LOG_LEVEL_ERROR=s,d.LOG_LEVEL_WARNING=u,d.LOG_LEVEL_INFO=l,d.LOG_LEVEL_DEBUG=c,a.Z.updateSingletonFactory(f.__dashjs_factory_name,d),t.Z=d},5595:function(e,t,n){"use strict";var r=n(5448),i=n(8825);function a(){var e={};function t(t,n,r){var i=-1;return e[t]?(e[t].some((function(e,t){if(e&&e.callback===n&&(!r||r===e.scope))return i=t,!0})),i):i}var n={on:function(n,r,i){var a=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};if(!n)throw new Error("event type cannot be null or undefined");if(!r||"function"!=typeof r)throw new Error("listener must be a function: "+r);var o=a.priority||0;if(!(t(n,r,i)>=0)){e[n]=e[n]||[];var s={callback:r,scope:i,priority:o};i&&i.getStreamId&&(s.streamId=i.getStreamId()),i&&i.getType&&(s.mediaType=i.getType()),a&&a.mode&&(s.mode=a.mode);var u=e[n].some((function(t,r){if(t&&o>t.priority)return e[n].splice(r,0,s),!0}));u||e[n].push(s)}},off:function(n,r,i){if(n&&r&&e[n]){var a=t(n,r,i);a<0||(e[n][a]=null)}},trigger:function(t){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(t&&e[t]){if((n=n||{}).hasOwnProperty("type"))throw new Error("\'type\' is a reserved word for event dispatching");n.type=t,r.streamId&&(n.streamId=r.streamId),r.mediaType&&(n.mediaType=r.mediaType),e[t].filter((function(e){return!(!e||r.streamId&&e.streamId&&e.streamId!==r.streamId||r.mediaType&&e.mediaType&&e.mediaType!==r.mediaType||r.mode&&e.mode&&e.mode!==r.mode||!e.mode&&r.mode&&r.mode===i.Z.EVENT_MODE_ON_RECEIVE)})).forEach((function(e){return e&&e.callback.call(e.scope,n)}))}},reset:function(){e={}}};return n}a.__dashjs_factory_name="EventBus";var o=r.Z.getSingletonFactory(a);o.EVENT_PRIORITY_LOW=0,o.EVENT_PRIORITY_HIGH=5e3,r.Z.updateSingletonFactory(a.__dashjs_factory_name,o),t.Z=o},5448:function(e,t){"use strict";var n=function(){var e,t=[],n={},r={};function i(e,n){for(var r in t){var i=t[r];if(i.context===e&&i.name===n)return i.instance}return null}function a(e,t){return t[e]}function o(e,t,n){e in n&&(n[e]=t)}function s(t,n,r){var i,a=t.__dashjs_factory_name,o=n[a];if(o){var s=o.instance;if(!o.override)return s.apply({context:n,factory:e},r);for(var u in i=t.apply({context:n},r),s=s.apply({context:n,factory:e,parent:i},r))i.hasOwnProperty(u)&&(i[u]=s[u])}else i=t.apply({context:n},r);return i.getClassName=function(){return a},i}return e={extend:function(e,t,n,r){!r[e]&&t&&(r[e]={instance:t,override:n})},getSingletonInstance:i,setSingletonInstance:function(e,n,r){for(var i in t){var a=t[i];if(a.context===e&&a.name===n)return void(t[i].instance=r)}t.push({name:n,context:e,instance:r})},deleteSingletonInstances:function(e){t=t.filter((function(t){return t.context!==e}))},getSingletonFactory:function(e){var r=a(e.__dashjs_factory_name,n);return r||(r=function(n){var r;return void 0===n&&(n={}),{getInstance:function(){return r||(r=i(n,e.__dashjs_factory_name)),r||(r=s(e,n,arguments),t.push({name:e.__dashjs_factory_name,context:n,instance:r})),r}}},n[e.__dashjs_factory_name]=r),r},getSingletonFactoryByName:function(e){return a(e,n)},updateSingletonFactory:function(e,t){o(e,t,n)},getClassFactory:function(e){var t=a(e.__dashjs_factory_name,r);return t||(t=function(t){return void 0===t&&(t={}),{create:function(){return s(e,t,arguments)}}},r[e.__dashjs_factory_name]=t),t},getClassFactoryByName:function(e){return a(e,r)},updateClassFactory:function(e,t){o(e,t,r)}},e}();t.Z=n},1264:function(e,t,n){"use strict";var r=n(5448),i=n(703),a=n(6398),o=n(3393),s=n(7855),u=n(5595),l=n(8512);function c(e){return c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},c(e)}function f(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function d(){var e,t,n=this.context,r=(0,u.Z)(n).getInstance(),d={"streaming.delay.liveDelay":l.Z.SETTING_UPDATED_LIVE_DELAY,"streaming.delay.liveDelayFragmentCount":l.Z.SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT,"streaming.liveCatchup.enabled":l.Z.SETTING_UPDATED_CATCHUP_ENABLED,"streaming.liveCatchup.playbackRate.min":l.Z.SETTING_UPDATED_PLAYBACK_RATE_MIN,"streaming.liveCatchup.playbackRate.max":l.Z.SETTING_UPDATED_PLAYBACK_RATE_MAX},g={debug:{logLevel:a.Z.LOG_LEVEL_WARNING,dispatchEvent:!1},streaming:{abandonLoadTimeout:1e4,wallclockTimeUpdateInterval:100,manifestUpdateRetryInterval:100,cacheInitSegments:!1,applyServiceDescription:!0,applyProducerReferenceTime:!0,applyContentSteering:!0,eventControllerRefreshDelay:100,enableManifestDurationMismatchFix:!0,parseInbandPrft:!1,enableManifestTimescaleMismatchFix:!1,capabilities:{filterUnsupportedEssentialProperties:!0,useMediaCapabilitiesApi:!1},timeShiftBuffer:{calcFromSegmentTimeline:!1,fallbackToSegmentTimeline:!0},metrics:{maxListDepth:100},delay:{liveDelayFragmentCount:NaN,liveDelay:NaN,useSuggestedPresentationDelay:!0},protection:{keepProtectionMediaKeys:!1,ignoreEmeEncryptedEvent:!1,detectPlayreadyMessageFormat:!0},buffer:{enableSeekDecorrelationFix:!1,fastSwitchEnabled:!0,flushBufferAtTrackSwitch:!1,reuseExistingSourceBuffers:!0,bufferPruningInterval:10,bufferToKeep:20,bufferTimeAtTopQuality:30,bufferTimeAtTopQualityLongForm:60,initialBufferLevel:NaN,stableBufferTime:12,longFormContentDurationThreshold:600,stallThreshold:.3,useAppendWindow:!0,setStallState:!0,avoidCurrentTimeRangePruning:!1,useChangeTypeForTrackSwitch:!0,mediaSourceDurationInfinity:!0,resetSourceBuffersForTrackSwitch:!1},gaps:{jumpGaps:!0,jumpLargeGaps:!0,smallGapLimit:1.5,threshold:.3,enableSeekFix:!0,enableStallFix:!1,stallSeek:.1},utcSynchronization:{enabled:!0,useManifestDateHeaderTimeSource:!0,backgroundAttempts:2,timeBetweenSyncAttempts:30,maximumTimeBetweenSyncAttempts:600,minimumTimeBetweenSyncAttempts:2,timeBetweenSyncAttemptsAdjustmentFactor:2,maximumAllowedDrift:100,enableBackgroundSyncAfterSegmentDownloadError:!0,defaultTimingSource:{scheme:"urn:mpeg:dash:utc:http-xsdate:2014",value:"https://time.akamai.com/?iso&ms"}},scheduling:{defaultTimeout:500,lowLatencyTimeout:0,scheduleWhilePaused:!0},text:{defaultEnabled:!0,extendSegmentedCues:!0,webvtt:{customRenderingEnabled:!1}},liveCatchup:{maxDrift:NaN,playbackRate:{min:NaN,max:NaN},playbackBufferMin:.5,enabled:null,mode:o.Z.LIVE_CATCHUP_MODE_DEFAULT},lastBitrateCachingInfo:{enabled:!0,ttl:36e4},lastMediaSettingsCachingInfo:{enabled:!0,ttl:36e4},saveLastMediaSettingsForCurrentStreamingSession:!0,cacheLoadThresholds:{video:50,audio:5},trackSwitchMode:{audio:o.Z.TRACK_SWITCH_MODE_ALWAYS_REPLACE,video:o.Z.TRACK_SWITCH_MODE_NEVER_REPLACE},selectionModeForInitialTrack:o.Z.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY,fragmentRequestTimeout:2e4,fragmentRequestProgressTimeout:-1,manifestRequestTimeout:1e4,retryIntervals:(e={},f(e,s.w.MPD_TYPE,500),f(e,s.w.XLINK_EXPANSION_TYPE,500),f(e,s.w.MEDIA_SEGMENT_TYPE,1e3),f(e,s.w.INIT_SEGMENT_TYPE,1e3),f(e,s.w.BITSTREAM_SWITCHING_SEGMENT_TYPE,1e3),f(e,s.w.INDEX_SEGMENT_TYPE,1e3),f(e,s.w.MSS_FRAGMENT_INFO_SEGMENT_TYPE,1e3),f(e,s.w.LICENSE,1e3),f(e,s.w.OTHER_TYPE,1e3),f(e,"lowLatencyReductionFactor",10),e),retryAttempts:(t={},f(t,s.w.MPD_TYPE,3),f(t,s.w.XLINK_EXPANSION_TYPE,1),f(t,s.w.MEDIA_SEGMENT_TYPE,3),f(t,s.w.INIT_SEGMENT_TYPE,3),f(t,s.w.BITSTREAM_SWITCHING_SEGMENT_TYPE,3),f(t,s.w.INDEX_SEGMENT_TYPE,3),f(t,s.w.MSS_FRAGMENT_INFO_SEGMENT_TYPE,3),f(t,s.w.LICENSE,3),f(t,s.w.OTHER_TYPE,3),f(t,"lowLatencyMultiplyFactor",5),t),abr:{movingAverageMethod:o.Z.MOVING_AVERAGE_SLIDING_WINDOW,ABRStrategy:o.Z.ABR_STRATEGY_DYNAMIC,additionalAbrRules:{insufficientBufferRule:!0,switchHistoryRule:!0,droppedFramesRule:!0,abandonRequestsRule:!0},abrRulesParameters:{abandonRequestsRule:{graceTimeThreshold:500,abandonMultiplier:1.8,minLengthToAverage:5}},bandwidthSafetyFactor:.9,useDefaultABRRules:!0,useDeadTimeLatency:!0,limitBitrateByPortal:!1,usePixelRatioInLimitBitrateByPortal:!1,maxBitrate:{audio:-1,video:-1},minBitrate:{audio:-1,video:-1},maxRepresentationRatio:{audio:1,video:1},initialBitrate:{audio:-1,video:-1},initialRepresentationRatio:{audio:-1,video:-1},autoSwitchBitrate:{audio:!0,video:!0},fetchThroughputCalculationMode:o.Z.ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING},cmcd:{enabled:!1,sid:null,cid:null,rtp:null,rtpSafetyFactor:5,mode:o.Z.CMCD_MODE_QUERY,enabledKeys:["br","d","ot","tb","bl","dl","mtp","nor","nrr","su","bs","rtp","cid","pr","sf","sid","st","v"]},cmsd:{enabled:!1,abr:{applyMb:!1,etpWeightRatio:0}}},errors:{recoverAttempts:{mediaErrorDecode:5}}},h=i.Z.clone(g);function p(e,t,n){for(var a in e)e.hasOwnProperty(a)&&(t.hasOwnProperty(a)?"object"!==c(e[a])||e[a]instanceof Array||null===e[a]?(t[a]=i.Z.clone(e[a]),d[n+a]&&r.trigger(d[n+a])):p(e[a],t[a],n.slice()+a+"."):console.error("Settings parameter "+n+a+" is not supported"))}return{get:function(){return h},update:function(e){"object"===c(e)&&p(e,h,"")},reset:function(){h=i.Z.clone(g)}}}d.__dashjs_factory_name="Settings";var g=r.Z.getSingletonFactory(d);t.Z=g},703:function(e,t,n){"use strict";var r=n(3875),i=n.n(r),a=n(1067);function o(e){return o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},o(e)}function s(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var u=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e)}var t,n;return t=e,n=[{key:"mixin",value:function(t,n,r){var i,a={};if(t)for(var s in n)n.hasOwnProperty(s)&&(i=n[s],s in t&&(t[s]===i||s in a&&a[s]===i)||("object"===o(t[s])&&null!==t[s]?t[s]=e.mixin(t[s],i,r):t[s]=r(i)));return t}},{key:"clone",value:function(t){if(!t||"object"!==o(t))return t;var n;if(t instanceof Array){n=[];for(var r=0,i=t.length;r<i;++r)r in t&&n.push(e.clone(t[r]))}else n={};return e.mixin(n,t,e.clone)}},{key:"addAditionalQueryParameterToUrl",value:function(e,t){try{if(!t||0===t.length)return e;var n=new URL(e);return t.forEach((function(e){e.key&&e.value&&n.searchParams.set(e.key,e.value)})),n.href}catch(t){return e}}},{key:"parseHttpHeaders",value:function(e){var t={};if(!e)return t;for(var n=e.trim().split("\\r\\n"),r=0,i=n.length;r<i;r++){var a=n[r],o=a.indexOf(": ");o>0&&(t[a.substring(0,o)]=a.substring(o+2))}return t}},{key:"generateUuid",value:function(){var e=(new Date).getTime();return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(t){var n=(e+16*Math.random())%16|0;return e=Math.floor(e/16),("x"==t?n:3&n|8).toString(16)}))}},{key:"generateHashCode",value:function(e){var t=0;if(0===e.length)return t;for(var n=0;n<e.length;n++)t=(t<<5)-t+e.charCodeAt(n),t|=0;return t}},{key:"getRelativeUrl",value:function(e,t){try{var n=new URL(e),r=new URL(t);if(n.protocol=r.protocol,n.origin!==r.origin)return t;var a=i().relative(n.pathname.substr(0,n.pathname.lastIndexOf("/")),r.pathname.substr(0,r.pathname.lastIndexOf("/"))),o=0===a.length?1:0;return a+=r.pathname.substr(r.pathname.lastIndexOf("/")+o,r.pathname.length-1),r.pathname.length<a.length?r.pathname:a}catch(e){return t}}},{key:"parseUserAgent",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;try{var t=null===e&&"undefined"!=typeof navigator?navigator.userAgent.toLowerCase():"";return(0,a.UAParser)(t)}catch(e){return{}}}},{key:"stringHasProtocol",value:function(e){return/(http(s?)):\\/\\//i.test(e)}}],null&&0,n&&s(t,n),e}();t.Z=u},2032:function(e,t,n){"use strict";function r(){return"4.7.3"}n.d(t,{e:function(){return r}})},2230:function(e,t){"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var r=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e)}var t,r;return t=e,(r=[{key:"extend",value:function(e,t){if(e){var n=!!t&&t.override,r=!!t&&t.publicOnly;for(var i in e)!e.hasOwnProperty(i)||this[i]&&!n||r&&-1===e[i].indexOf("public_")||(this[i]=e[i])}}}])&&n(t.prototype,r),e}();t.Z=r},4351:function(e,t,n){"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function i(e,t){return i=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},i(e,t)}function a(e,t){return!t||"object"!==r(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function o(e){return o=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},o(e)}var s=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&i(e,t)}(s,e);var t,n,r=(t=s,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=o(t);if(n){var i=o(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return a(this,e)});function s(){var e;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,s),(e=r.call(this)).ATTEMPT_BACKGROUND_SYNC="attemptBackgroundSync",e.BUFFERING_COMPLETED="bufferingCompleted",e.BUFFER_CLEARED="bufferCleared",e.BYTES_APPENDED_END_FRAGMENT="bytesAppendedEndFragment",e.BUFFER_REPLACEMENT_STARTED="bufferReplacementStarted",e.CHECK_FOR_EXISTENCE_COMPLETED="checkForExistenceCompleted",e.CMSD_STATIC_HEADER="cmsdStaticHeader",e.CURRENT_TRACK_CHANGED="currentTrackChanged",e.DATA_UPDATE_COMPLETED="dataUpdateCompleted",e.INBAND_EVENTS="inbandEvents",e.INITIAL_STREAM_SWITCH="initialStreamSwitch",e.INIT_FRAGMENT_LOADED="initFragmentLoaded",e.INIT_FRAGMENT_NEEDED="initFragmentNeeded",e.INTERNAL_MANIFEST_LOADED="internalManifestLoaded",e.ORIGINAL_MANIFEST_LOADED="originalManifestLoaded",e.LOADING_COMPLETED="loadingCompleted",e.LOADING_PROGRESS="loadingProgress",e.LOADING_DATA_PROGRESS="loadingDataProgress",e.LOADING_ABANDONED="loadingAborted",e.MANIFEST_UPDATED="manifestUpdated",e.MEDIA_FRAGMENT_LOADED="mediaFragmentLoaded",e.MEDIA_FRAGMENT_NEEDED="mediaFragmentNeeded",e.QUOTA_EXCEEDED="quotaExceeded",e.SEGMENT_LOCATION_BLACKLIST_ADD="segmentLocationBlacklistAdd",e.SEGMENT_LOCATION_BLACKLIST_CHANGED="segmentLocationBlacklistChanged",e.SERVICE_LOCATION_BASE_URL_BLACKLIST_ADD="serviceLocationBlacklistAdd",e.SERVICE_LOCATION_BASE_URL_BLACKLIST_CHANGED="serviceLocationBlacklistChanged",e.SERVICE_LOCATION_LOCATION_BLACKLIST_ADD="serviceLocationLocationBlacklistAdd",e.SERVICE_LOCATION_LOCATION_BLACKLIST_CHANGED="serviceLocationLocationBlacklistChanged",e.SET_FRAGMENTED_TEXT_AFTER_DISABLED="setFragmentedTextAfterDisabled",e.SET_NON_FRAGMENTED_TEXT="setNonFragmentedText",e.SOURCE_BUFFER_ERROR="sourceBufferError",e.STREAMS_COMPOSED="streamsComposed",e.STREAM_BUFFERING_COMPLETED="streamBufferingCompleted",e.STREAM_REQUESTING_COMPLETED="streamRequestingCompleted",e.TEXT_TRACKS_QUEUE_INITIALIZED="textTracksQueueInitialized",e.TIME_SYNCHRONIZATION_COMPLETED="timeSynchronizationComplete",e.UPDATE_TIME_SYNC_OFFSET="updateTimeSyncOffset",e.URL_RESOLUTION_FAILED="urlResolutionFailed",e.VIDEO_CHUNK_RECEIVED="videoChunkReceived",e.WALLCLOCK_TIME_UPDATED="wallclockTimeUpdated",e.XLINK_ELEMENT_LOADED="xlinkElementLoaded",e.XLINK_READY="xlinkReady",e.SEEK_TARGET="seekTarget",e.SETTING_UPDATED_LIVE_DELAY="settingUpdatedLiveDelay",e.SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT="settingUpdatedLiveDelayFragmentCount",e.SETTING_UPDATED_CATCHUP_ENABLED="settingUpdatedCatchupEnabled",e.SETTING_UPDATED_PLAYBACK_RATE_MIN="settingUpdatedPlaybackRateMin",e.SETTING_UPDATED_PLAYBACK_RATE_MAX="settingUpdatedPlaybackRateMax",e}return s}(n(8342).Z);t.Z=s},8512:function(e,t,n){"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function i(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function a(e,t){return a=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},a(e,t)}function o(e,t){return!t||"object"!==r(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function s(e){return s=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},s(e)}var u=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&a(e,t)}(u,e);var t,n,r=(t=u,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=s(t);if(n){var i=s(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return o(this,e)});function u(){return i(this,u),r.apply(this,arguments)}return u}(n(4351).Z),l=new u;t.Z=l},8342:function(e,t){"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var r=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e)}var t,r;return t=e,(r=[{key:"extend",value:function(e,t){if(e){var n=!!t&&t.override,r=!!t&&t.publicOnly;for(var i in e)!e.hasOwnProperty(i)||this[i]&&!n||r&&-1===e[i].indexOf("public_")||(this[i]=e[i])}}}])&&n(t.prototype,r),e}();t.Z=r},9326:function(e,t,n){"use strict";var r=n(3186),i=n(7855),a=n(5448),o=n(8825),s=n(7387),u=n(1553);function l(e){var t,n,a,l,c,f=(e=e||{}).eventBus,d=e.debug,g=e.urlUtils,h=e.type,p=e.streamInfo,m=e.segmentsController,y=e.timelineConverter,E=e.baseURLController;function v(){return h}function _(){a=null}function T(e,t,n){var r,i,a=E.resolve(n.path),o={};return a&&t!==a.url&&g.isRelative(t)?(r=a.url,i=a.serviceLocation,o=a.queryParams,t&&(r=g.resolve(t,r))):r=t,!g.isRelative(r)&&(e.url=r,e.serviceLocation=i,e.queryParams=o,!0)}function S(e,t){if(null==t)return null;var n=new r.Z,a=t.representation,o=a.adaptation.period.mpd.manifest.Period_asArray[a.adaptation.period.index].AdaptationSet_asArray[a.adaptation.index].Representation_asArray[a.index].bandwidth,u=t.media;return u=(0,s.vi)(u,"Number",t.replacementNumber),u=(0,s.vi)(u,"Time",t.replacementTime),u=(0,s.vi)(u,"Bandwidth",o),u=(0,s.Aj)(u,a.id),u=(0,s.eR)(u),n.mediaType=v(),n.type=i.w.MEDIA_SEGMENT_TYPE,n.range=t.mediaRange,n.startTime=t.presentationStartTime,n.mediaStartTime=t.mediaStartTime,n.duration=t.duration,n.timescale=a.timescale,n.availabilityStartTime=t.availabilityStartTime,n.availabilityEndTime=t.availabilityEndTime,n.availabilityTimeComplete=a.availabilityTimeComplete,n.wallStartTime=t.wallStartTime,n.quality=a.index,n.index=t.index,n.mediaInfo=e,n.adaptationIndex=a.adaptation.index,n.representationId=a.id,T(n,u,a)?n:void 0}function b(e,t,r){var i=null;if(!t||!t.segmentInfoType)return i;var o=m.getSegmentByTime(t,r);return o&&(a=o,n.debug("Index for time "+r+" is "+o.index),i=S(e,o)),i}function A(e,t,r){var i=null,o=m.getSegmentByIndex(t,r,a?a.mediaStartTime:-1);if(o)i=S(e,o),a=o;else{if(l&&!c)return n.debug(v()+" No segment found at index: "+r+". Wait for next loop"),null;c=!0}return i}function I(){n.debug("Dynamic stream complete"),c=!0}return t={getCurrentIndex:function(){return a?a.index:-1},getInitRequest:function(e,t){return t?function(e,t,n){var a=new r.Z,o=t.adaptation.period,u=o.start;if(a.mediaType=n,a.type=i.w.INIT_SEGMENT_TYPE,a.range=t.range,a.availabilityStartTime=y.calcAvailabilityStartTimeFromPresentationTime(u,t,l),a.availabilityEndTime=y.calcAvailabilityEndTimeFromPresentationTime(u+o.duration,t,l),a.quality=t.index,a.mediaInfo=e,a.representationId=t.id,T(a,t.initialization,t))return a.url=(0,s.vi)(a.url,"Bandwidth",t.bandwidth),a}(e,t,v()):null},getNextSegmentRequest:function(e,t){return t&&t.segmentInfoType?A(e,t,a?a.index+1:0):null},getNextSegmentRequestIdempotent:function(e,t){var n=a?a.index+1:0,r=m.getSegmentByIndex(t,n,a?a.mediaStartTime:-1);return r?S(e,r):null},getSegmentRequestForTime:b,getStreamId:function(){return p.id},getStreamInfo:function(){return p},getType:v,getValidTimeAheadOfTargetTime:function(e,t,n,r){try{if(isNaN(e)||!t||!n)return NaN;if(e<0&&(e=0),isNaN(r)&&(r=.5),b(t,n,e))return e;if(n.adaptation.period.start+n.adaptation.period.duration<e)return NaN;for(var i=isFinite(n.adaptation.period.duration)?n.adaptation.period.start+n.adaptation.period.duration:e+30,a=Math.min(e+r,i),o=NaN,s=null;a<=i;){var u=null;if(a<=i&&(u=b(t,n,a)),u){o=a,s=u;break}a+=r}if(s){var l=s.startTime+s.duration;return e>s.startTime&&l-e>r?e:!isNaN(s.startTime)&&e<s.startTime&&o>s.startTime?s.startTime+.001:Math.min(l-r,o)}return o}catch(e){return NaN}},initialize:function(e){l=e,c=!1,m.initialize(e)},isLastSegmentRequested:function(e,t){if(!e||!a)return!1;if(c)return!0;if(!isFinite(e.adaptation.period.duration))return!1;if(a.presentationStartTime+a.duration>t)return!1;if(e.mediaFinishedInformation&&!isNaN(e.mediaFinishedInformation.numberOfSegments)&&!isNaN(a.index)&&a.index>=e.mediaFinishedInformation.numberOfSegments-1){if(!l||e.segmentInfoType===u.Z.SEGMENT_TEMPLATE)return!0;if(l&&e.segmentInfoType===u.Z.SEGMENT_LIST&&e.adaptation.period.nextPeriodId)return!0}return!!(l&&e.adaptation.period.nextPeriodId&&e.segmentInfoType===u.Z.SEGMENT_TIMELINE&&e.mediaFinishedInformation&&!isNaN(e.mediaFinishedInformation.mediaTimeOfLastSignaledSegment)&&a&&!isNaN(a.mediaStartTime)&&!isNaN(a.duration)&&a.mediaStartTime+a.duration>=e.mediaFinishedInformation.mediaTimeOfLastSignaledSegment-.05)},repeatSegmentRequest:function(e,t){return t&&t.segmentInfoType?A(e,t,a?a.index:0):null},reset:function(){_(),f.off(o.Z.DYNAMIC_TO_STATIC,I,t)}},n=d.getLogger(t),_(),f.on(o.Z.DYNAMIC_TO_STATIC,I,t),t}l.__dashjs_factory_name="DashHandler",t.Z=a.Z.getClassFactory(l)},1553:function(e,t){"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var r=new(function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.init()}var t,r;return t=e,(r=[{key:"init",value:function(){this.BASE_URL="BaseURL",this.SEGMENT_BASE="SegmentBase",this.SEGMENT_TEMPLATE="SegmentTemplate",this.SEGMENT_LIST="SegmentList",this.SEGMENT_URL="SegmentURL",this.SEGMENT_TIMELINE="SegmentTimeline",this.SEGMENT_PROFILES="segmentProfiles",this.ADAPTATION_SET="AdaptationSet",this.REPRESENTATION="Representation",this.REPRESENTATION_INDEX="RepresentationIndex",this.SUB_REPRESENTATION="SubRepresentation",this.INITIALIZATION="Initialization",this.INITIALIZATION_MINUS="initialization",this.MPD="MPD",this.PERIOD="Period",this.ASSET_IDENTIFIER="AssetIdentifier",this.EVENT_STREAM="EventStream",this.ID="id",this.PROFILES="profiles",this.SERVICE_LOCATION="serviceLocation",this.RANGE="range",this.INDEX="index",this.MEDIA="media",this.BYTE_RANGE="byteRange",this.INDEX_RANGE="indexRange",this.MEDIA_RANGE="mediaRange",this.VALUE="value",this.CONTENT_TYPE="contentType",this.MIME_TYPE="mimeType",this.BITSTREAM_SWITCHING="BitstreamSwitching",this.BITSTREAM_SWITCHING_MINUS="bitstreamSwitching",this.CODECS="codecs",this.DEPENDENCY_ID="dependencyId",this.MEDIA_STREAM_STRUCTURE_ID="mediaStreamStructureId",this.METRICS="Metrics",this.METRICS_MINUS="metrics",this.REPORTING="Reporting",this.WIDTH="width",this.HEIGHT="height",this.SAR="sar",this.FRAMERATE="frameRate",this.AUDIO_SAMPLING_RATE="audioSamplingRate",this.MAXIMUM_SAP_PERIOD="maximumSAPPeriod",this.START_WITH_SAP="startWithSAP",this.MAX_PLAYOUT_RATE="maxPlayoutRate",this.CODING_DEPENDENCY="codingDependency",this.SCAN_TYPE="scanType",this.FRAME_PACKING="FramePacking",this.AUDIO_CHANNEL_CONFIGURATION="AudioChannelConfiguration",this.CONTENT_PROTECTION="ContentProtection",this.ESSENTIAL_PROPERTY="EssentialProperty",this.SUPPLEMENTAL_PROPERTY="SupplementalProperty",this.SUPPLEMENTAL_PROPERTY_ASARRAY="SupplementalProperty_asArray",this.INBAND_EVENT_STREAM="InbandEventStream",this.PRODUCER_REFERENCE_TIME="ProducerReferenceTime",this.INBAND="inband",this.TYPE="type",this.ACCESSIBILITY="Accessibility",this.ROLE="Role",this.RATING="Rating",this.CONTENT_COMPONENT="ContentComponent",this.SUBSET="Subset",this.LANG="lang",this.VIEWPOINT="Viewpoint",this.VIEWPOINT_ASARRAY="Viewpoint_asArray",this.ROLE_ASARRAY="Role_asArray",this.REPRESENTATION_ASARRAY="Representation_asArray",this.PRODUCERREFERENCETIME_ASARRAY="ProducerReferenceTime_asArray",this.ACCESSIBILITY_ASARRAY="Accessibility_asArray",this.AUDIOCHANNELCONFIGURATION_ASARRAY="AudioChannelConfiguration_asArray",this.CONTENTPROTECTION_ASARRAY="ContentProtection_asArray",this.MAIN="main",this.DYNAMIC="dynamic",this.STATIC="static",this.MEDIA_PRESENTATION_DURATION="mediaPresentationDuration",this.MINIMUM_UPDATE_PERIOD="minimumUpdatePeriod",this.CODEC_PRIVATE_DATA="codecPrivateData",this.BANDWITH="bandwidth",this.SOURCE_URL="sourceURL",this.TIMESCALE="timescale",this.DURATION="duration",this.START_NUMBER="startNumber",this.PRESENTATION_TIME_OFFSET="presentationTimeOffset",this.AVAILABILITY_START_TIME="availabilityStartTime",this.AVAILABILITY_END_TIME="availabilityEndTime",this.TIMESHIFT_BUFFER_DEPTH="timeShiftBufferDepth",this.MAX_SEGMENT_DURATION="maxSegmentDuration",this.PRESENTATION_TIME="presentationTime",this.MIN_BUFFER_TIME="minBufferTime",this.MAX_SUBSEGMENT_DURATION="maxSubsegmentDuration",this.START="start",this.AVAILABILITY_TIME_OFFSET="availabilityTimeOffset",this.AVAILABILITY_TIME_COMPLETE="availabilityTimeComplete",this.CENC_DEFAULT_KID="cenc:default_KID",this.DVB_PRIORITY="dvb:priority",this.DVB_WEIGHT="dvb:weight",this.SUGGESTED_PRESENTATION_DELAY="suggestedPresentationDelay",this.SERVICE_DESCRIPTION="ServiceDescription",this.SERVICE_DESCRIPTION_SCOPE="Scope",this.SERVICE_DESCRIPTION_LATENCY="Latency",this.SERVICE_DESCRIPTION_PLAYBACK_RATE="PlaybackRate",this.SERVICE_DESCRIPTION_OPERATING_QUALITY="OperatingQuality",this.SERVICE_DESCRIPTION_OPERATING_BANDWIDTH="OperatingBandwidth",this.PATCH_LOCATION="PatchLocation",this.PATCH_LOCATION_AS_ARRAY="PatchLocation_asArray",this.LOCATION="Location",this.LOCATION_AS_ARRAY="Location_asArray",this.PUBLISH_TIME="publishTime",this.ORIGINAL_PUBLISH_TIME="originalPublishTime",this.ORIGINAL_MPD_ID="mpdId",this.WALL_CLOCK_TIME="wallClockTime",this.PRESENTATION_TIME="presentationTime",this.LABEL="Label",this.GROUP_LABEL="GroupLabel",this.CONTENT_STEERING="ContentSteering",this.CONTENT_STEERING_AS_ARRAY="ContentSteering_asArray",this.DEFAULT_SERVICE_LOCATION="defaultServiceLocation",this.QUERY_BEFORE_START="queryBeforeStart",this.CLIENT_REQUIREMENT="clientRequirement",this.TTL="ttl",this.CONTENT_STEERING_RESPONSE={VERSION:"VERSION",TTL:"TTL",RELOAD_URI:"RELOAD-URI",PATHWAY_PRIORITY:"PATHWAY-PRIORITY",PATHWAY_CLONES:"PATHWAY-CLONES",BASE_ID:"BASE-ID",ID:"ID",URI_REPLACEMENT:"URI-REPLACEMENT",HOST:"HOST",PARAMS:"PARAMS"},this.PRODUCER_REFERENCE_TIME_TYPE={ENCODER:"encoder",CAPTURED:"captured",APPLICATION:"application"},this.SEGMENT_ALIGNMENT="segmentAlignment",this.SUB_SEGMENT_ALIGNMENT="subsegmentAlignment"}}])&&n(t.prototype,r),e}());t.Z=r},7802:function(e,t,n){"use strict";var r=n(5448),i=n(1724),a=n(3636),o=n(1736),s=n(5246);function u(e){e=e||{};var t,n,r=this.context,u=e.dashConstants,l=e.type,c=e.segmentBaseController;function f(e){return e?e.segments?n[u.SEGMENT_BASE]:n[e.segmentInfoType]:null}return t={initialize:function(t){n[u.SEGMENT_TIMELINE]=(0,i.Z)(r).create(e,t),n[u.SEGMENT_TEMPLATE]=(0,a.Z)(r).create(e,t),n[u.SEGMENT_LIST]=(0,o.Z)(r).create(e,t),n[u.SEGMENT_BASE]=(0,s.Z)(r).create(e,t)},updateInitData:function(e,t){return t?Promise.resolve():c.getSegmentBaseInitSegment({representation:e,mediaType:l})},updateSegmentData:function(e,t){return t?Promise.resolve():c.getSegmentList({mimeType:e.mimeType,representation:e,mediaType:l})},getSegmentByIndex:function(e,t,n){var r=f(e);return r?r.getSegmentByIndex(e,t,n):null},getSegmentByTime:function(e,t){var n=f(e);return n?n.getSegmentByTime(e,t):null},getMediaFinishedInformation:function(e){var t=f(e);return t?t.getMediaFinishedInformation(e):{numberOfSegments:0,mediaTimeOfLastSignaledSegment:NaN}}},n={},t}u.__dashjs_factory_name="SegmentsController";var l=r.Z.getClassFactory(u);t.Z=l},1736:function(e,t,n){"use strict";var r=n(5448),i=n(3393),a=n(7387);function o(e,t){var n=(e=e||{}).timelineConverter;function r(){if(!n||!n.hasOwnProperty("calcPeriodRelativeTimeFromMpdRelativeTime"))throw new Error(i.Z.MISSING_CONFIG_ERROR)}function o(e,i){if(r(),!e)return null;var o=e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index].Representation_asArray[e.index].SegmentList,s=o.SegmentURL_asArray.length,u=e&&!isNaN(e.startNumber)?e.startNumber:1,l=Math.max(u-1,0),c=Math.max(i-l,0),f=null;if(c<s){var d=o.SegmentURL_asArray[c];(f=(0,a.NF)(n,t,e,i))&&(f.replacementTime=(u+i-1)*e.segmentDuration,f.media=d.media?d.media:"",f.mediaRange=d.mediaRange,f.indexRange=d.indexRange)}return f}return{getSegmentByIndex:o,getSegmentByTime:function(e,t){if(r(),!e)return null;var i=e.segmentDuration;if(isNaN(i))return null;var a=n.calcPeriodRelativeTimeFromMpdRelativeTime(e,t);return o(e,Math.floor(a/i))},getMediaFinishedInformation:function(e){var t={numberOfSegments:0,mediaTimeOfLastSignaledSegment:NaN};if(!e)return t;var n=e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index].Representation_asArray[e.index].SegmentList,r=e&&!isNaN(e.startNumber)?e.startNumber:1,i=Math.max(r-1,0);return t.numberOfSegments=i+n.SegmentURL_asArray.length,t}}}o.__dashjs_factory_name="ListSegmentsGetter";var s=r.Z.getClassFactory(o);t.Z=s},5246:function(e,t,n){"use strict";var r=n(5448),i=n(3393);function a(e){var t=(e=e||{}).timelineConverter;function n(){if(!t||!t.hasOwnProperty("calcPeriodRelativeTimeFromMpdRelativeTime"))throw new Error(i.Z.MISSING_CONFIG_ERROR)}function r(e,t){if(n(),!e)return null;var r,i=e.segments?e.segments.length:-1;if(t<i&&(r=e.segments[t])&&r.index===t)return r;for(var a=0;a<i;a++)if((r=e.segments[a])&&r.index===t)return r;return null}return{getSegmentByIndex:r,getSegmentByTime:function(e,t){n();var i=function(e,t){if(!e)return-1;var n,r,i,a,o,s=e.segments,u=s?s.length:null,l=-1;if(s&&u>0)for(o=0;o<u;o++)if(i=(r=s[o]).presentationStartTime,t+(n=(a=r.duration)/2)>=i&&t-n<i+a){l=r.index;break}return l}(e,t);return r(e,i)},getMediaFinishedInformation:function(e){var t={numberOfSegments:0,mediaTimeOfLastSignaledSegment:NaN};return e&&e.segments?(t.numberOfSegments=e.segments.length,t):t}}}a.__dashjs_factory_name="SegmentBaseGetter";var o=r.Z.getClassFactory(a);t.Z=o},7387:function(e,t,n){"use strict";n.d(t,{Aj:function(){return o},NF:function(){return c},TJ:function(){return f},eR:function(){return a},vi:function(){return s}});var r=n(2011);function i(e,t){for(;e.length<t;)e="0"+e;return e}function a(e){return e?e.split("$$").join("$"):e}function o(e,t){if(!t||!e||-1===e.indexOf("$RepresentationID$"))return e;var n=t.toString();return e.split("$RepresentationID$").join(n)}function s(e,t,n){var r,a,o,s,u,l,c=t.length,f="%0".length;if(!e)return e;for(;;){if((r=e.indexOf("$"+t))<0)return e;if((a=e.indexOf("$",r+c))<0)return e;if((o=e.indexOf("%0",r+c))>r&&o<a)switch(s=e.charAt(a-1),u=parseInt(e.substring(o+f,a-1),10),s){case"d":case"i":case"u":l=i(n.toString(),u);break;case"x":l=i(n.toString(16),u);break;case"X":l=i(n.toString(16),u).toUpperCase();break;case"o":l=i(n.toString(8),u);break;default:return e}else l=n;e=e.substring(0,r)+l+e.substring(a+1)}}function u(e,t,n,i,a,o,s,u){var l,c=new r.Z;return c.representation=e,c.duration=t,c.presentationStartTime=n,c.mediaStartTime=i,c.availabilityStartTime=a.calcAvailabilityStartTimeFromPresentationTime(o,e,s),c.availabilityEndTime=a.calcAvailabilityEndTimeFromPresentationTime(o+t,e,s),c.wallStartTime=a.calcWallTimeForSegment(c,s),c.replacementNumber=(l=u,c.representation.startNumber+l),c.index=u,c}function l(e,t,n,r){var i=t.adaptation.period;if(isFinite(i.duration)&&i.start+i.duration<=n.presentationStartTime)return!1;if(r){if("INF"===t.availabilityTimeOffset)return!0;var a=e.getClientReferenceTime();return n.availabilityStartTime.getTime()<=a&&(!isFinite(n.availabilityEndTime)||n.availabilityEndTime.getTime()>=a)}return!0}function c(e,t,n,r){var i,a,o;i=n.segmentDuration,isNaN(i)&&(i=n.adaptation.period.duration),a=parseFloat((n.adaptation.period.start+r*i).toFixed(5)),o=parseFloat((a+i).toFixed(5));var s=u(n,i,a,e.calcMediaTimeFromPresentationTime(a,n),e,o,t,r);return l(e,n,s,t)?s:null}function f(e,t,n,r,i,a,o,c,f,d){var g,h,p=r/a,m=i/a;return g=e.calcPresentationTimeFromMediaTime(p,n),l(e,n,h=u(n,m,g,p,e,g+m,t,f),t)?(h.replacementTime=d||r,o=s(o,"Number",h.replacementNumber),o=s(o,"Time",h.replacementTime),h.media=o,h.mediaRange=c,h):null}},3636:function(e,t,n){"use strict";var r=n(5448),i=n(3393),a=n(7387);function o(e,t){var n=(e=e||{}).timelineConverter;function r(){if(!n||!n.hasOwnProperty("calcPeriodRelativeTimeFromMpdRelativeTime"))throw new Error(i.Z.MISSING_CONFIG_ERROR)}function o(e,i){if(r(),!e)return null;var o=e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index].Representation_asArray[e.index].SegmentTemplate;i=Math.max(i,0);var s=(0,a.NF)(n,t,e,i);if(s){s.replacementTime=Math.round((i-1)*e.segmentDuration*e.timescale,10);var u=o.media;u=(0,a.vi)(u,"Number",s.replacementNumber),u=(0,a.vi)(u,"Time",s.replacementTime),s.media=u}return s}return{getSegmentByIndex:o,getSegmentByTime:function(e,t){if(r(),!e)return null;var i=e.segmentDuration;if(isNaN(i))return null;var a=n.calcPeriodRelativeTimeFromMpdRelativeTime(e,t);return o(e,Math.floor(a/i))},getMediaFinishedInformation:function(e){var t={numberOfSegments:0,mediaTimeOfLastSignaledSegment:NaN};if(!e)return t;var n=e.segmentDuration;return isNaN(n)?t.numberOfSegments=1:t.numberOfSegments=Math.ceil(e.adaptation.period.duration/n),t}}}o.__dashjs_factory_name="TemplateSegmentsGetter";var s=r.Z.getClassFactory(o);t.Z=s},1724:function(e,t,n){"use strict";var r=n(5448),i=n(3393),a=n(7387);function o(e,t){var n=(e=e||{}).timelineConverter,r=e.dashMetrics;function o(){if(!n)throw new Error(i.Z.MISSING_CONFIG_ERROR)}function s(e,t){var n,r,i,a,o,s,l,c=e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index].Representation_asArray[e.index].SegmentTemplate||e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index].Representation_asArray[e.index].SegmentList,f=c.SegmentTimeline,d=c.SegmentURL_asArray,g=0,h=-1;l=e.timescale;var p=!1;for(i=0,a=(n=f.S_asArray).length;i<a&&!p;i++)for(s=0,(r=n[i]).hasOwnProperty("r")&&(s=r.r),r.hasOwnProperty("t")&&(g=r.t),s<0&&(s=u(e,n[i+1],r,l,g/l)),o=0;o<=s&&!p;o++)(p=t(g,c,d,r,l,++h,i))&&(e.segmentDuration=r.d/l),g+=r.d}function u(e,t,i,a,o){var s;if(t&&t.hasOwnProperty("t"))s=t.t/a;else try{var u=0;if(isNaN(e.adaptation.period.start)||isNaN(e.adaptation.period.duration)||!isFinite(e.adaptation.period.duration)){var l=r.getCurrentDVRInfo();u=isNaN(l.end)?0:l.end}else u=e.adaptation.period.start+e.adaptation.period.duration;s=n.calcMediaTimeFromPresentationTime(u,e),e.segmentDuration=i.d/a}catch(e){s=0}return Math.max(Math.ceil((s-o)/(i.d/a))-1,0)}return{getSegmentByIndex:function(e,r,i){if(o(),!e)return null;var u=null,l=!1;return s(e,(function(r,o,s,c,f,d,g){if(l||i<0){var h=o.media,p=c.mediaRange;return s&&(h=s[g].media||"",p=s[g].mediaRange),u=(0,a.TJ)(n,t,e,r,c.d,f,h,p,d,c.tManifest),!0}return r>=i*f-.5*c.d&&(l=!0),!1})),u},getSegmentByTime:function(e,r){if(o(),!e)return null;void 0===r&&(r=null);var i=null,u=n.calcMediaTimeFromPresentationTime(r,e);return s(e,(function(r,o,s,l,c,f,d){var g=parseFloat((u*c).toPrecision(15));if(g<r+l.d&&g>=r){var h=o.media,p=l.mediaRange;return s&&(h=s[d].media||"",p=s[d].mediaRange),i=(0,a.TJ)(n,t,e,r,l.d,c,h,p,f,l.tManifest),!0}return!1})),i},getMediaFinishedInformation:function(e){if(!e)return 0;var t,n,r,i,a,o,s,l=(e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index].Representation_asArray[e.index].SegmentTemplate||e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index].Representation_asArray[e.index].SegmentList).SegmentTimeline,c=0,f=0,d=0;for(s=e.timescale,i=(t=l.S_asArray).length,r=0;r<i;r++)for(o=0,(n=t[r]).hasOwnProperty("r")&&(o=n.r),n.hasOwnProperty("t")&&(f=(c=n.t)/s),o<0&&(o=u(e,t[r+1],n,s,f)),a=0;a<=o;a++)d++,f=(c+=n.d)/s;return{numberOfSegments:d,mediaTimeOfLastSignaledSegment:f}}}}o.__dashjs_factory_name="TimelineSegmentsGetter";var s=r.Z.getClassFactory(o);t.Z=s},2011:function(e,t){"use strict";t.Z=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.indexRange=null,this.index=null,this.mediaRange=null,this.media=null,this.duration=NaN,this.replacementTime=null,this.replacementNumber=NaN,this.mediaStartTime=NaN,this.presentationStartTime=NaN,this.availabilityStartTime=NaN,this.availabilityEndTime=NaN,this.wallStartTime=NaN,this.representation=null}},2610:function(e,t){"use strict";t.Z=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.schemeIdUri="",this.value=""}},7688:function(e,t,n){"use strict";n.d(t,{Z:function(){return ja}});var r=n(452),i=n.n(r),a=n(3393),o=n(1553),s=n(3860),u=n(5595),l=n(8512),c=n(5448),f=n(6398),d=n(8825);function g(){var e,t,n,r,i,o,c,g,h,p,m,y,E,v,_,T,S,b,A,I,R,w,N,C,D=this.context,O=(0,u.Z)(D).getInstance();function M(){F(),v=!1,p=0,m=0,T=0,w=!1,S=!0,b=!1,N=!1,A=NaN,c&&(O.off(l.Z.DATA_UPDATE_COMPLETED,Q,e),O.off(l.Z.LOADING_PROGRESS,ye,e),O.off(l.Z.MANIFEST_UPDATED,Te,e),O.off(l.Z.STREAMS_COMPOSED,Se,e),O.off(d.Z.PLAYBACK_ENDED,he,e),O.off(d.Z.STREAM_INITIALIZING,ve,e),O.off(d.Z.REPRESENTATION_SWITCH,_e,e),O.off(d.Z.BUFFER_LEVEL_STATE_CHANGED,ee,e),X(),c.removeEventListener("canplay",J),c.removeEventListener("canplaythrough",$),c.removeEventListener("play",te),c.removeEventListener("waiting",ne),c.removeEventListener("playing",re),c.removeEventListener("pause",ie),c.removeEventListener("error",pe),c.removeEventListener("seeking",ae),c.removeEventListener("seeked",oe),c.removeEventListener("timeupdate",se),c.removeEventListener("progress",ue),c.removeEventListener("ratechange",le),c.removeEventListener("loadedmetadata",ce),c.removeEventListener("loadeddata",fe),c.removeEventListener("stalled",Ee),c.removeEventListener("ended",de),c.removeEventListener("volumechange",ge)),h=null,c=null,y=null,E=null}function P(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;return parseFloat((L(e)-B()).toFixed(5))}function L(e){var t=e||y;return t.start+t.duration}function x(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];y&&c&&c.getElement()?(e&&E&&Z(B()),c.play()):v=!0}function F(){y&&c&&c.pause()}function k(e){var n=arguments.length>1&&void 0!==arguments[1]&&arguments[1],r=arguments.length>2&&void 0!==arguments[2]&&arguments[2],i=arguments.length>3&&void 0!==arguments[3]&&arguments[3];if(y&&c&&c.getElement()){var a=isNaN(A)?c.getTime():A;e!==a&&((I=!0===r)||(A=e),t.info("Requesting seek to time: "+e+(I?" (internal)":"")),E&&i&&Z(e),c.setCurrentTime(e,n))}}function U(){if(y&&c&&E){var e=n&&n.hasVideoTrack()?a.Z.VIDEO:a.Z.AUDIO,t=i.getCurrentDVRInfo(e);return t&&t.range?t.range.end:0}}function Z(e){var t=new Date(g.getClientReferenceTime()),n=o.getRegularPeriods()[0],r=g.calcPresentationTimeFromWallTime(t,n);p=r-e}function B(){return y&&c?c.getTime():null}function G(){return y&&c?c.isPaused():null}function q(){return y&&c?c.isSeeking():null}function Y(){return y&&c?c.isStalled():null}function j(){return y&&c?c.getPlaybackRate():null}function H(){return y&&c?c.getEnded():null}function V(){return E}function K(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;if(!G()&&E&&0!==c.getReadyState()&&!q()&&!w){e||(e=n.hasVideoTrack()?a.Z.VIDEO:a.Z.AUDIO);var r=B(),i=z(r,e),o=!isNaN(i)&&i!==r;o&&!q()&&(Y()||R||1===c.getReadyState())&&(t.debug("UpdateCurrentTime: Seek to actual time: ".concat(i," from currentTime: ").concat(r)),k(i,!1,!1))}}function z(e,t){var n=i.getCurrentDVRInfo(t),r=n?n.range:null;return r?e>r.end?Math.max(r.end-p,r.start):e>0&&e+.25<r.start&&Math.abs(e-r.start)<31536e4?b?Math.max(r.end-p,r.start):r.start:e:NaN}function W(){null===h&&(h=setInterval((function(){var e;O.trigger(l.Z.WALLCLOCK_TIME_UPDATED,{isDynamic:E,time:new Date}),V()&&(n.addDVRMetric(),G()?(e=Date.now(),(!_||e>_+500)&&(_=e,se())):K())}),C.get().streaming.wallclockTimeUpdateInterval))}function X(){clearInterval(h),h=null}function Q(e){var t=o.convertRepresentationToRepresentationInfo(e.currentRepresentation),n=t?t.mediaInfo.streamInfo:null;null!==n&&y.id===n.id&&(y=n)}function J(){O.trigger(l.Z.CAN_PLAY)}function $(){O.trigger(l.Z.CAN_PLAY_THROUGH)}function ee(e){e.streamId===n.getActiveStreamInfo().id&&(R=e.state===s.Z.BUFFER_EMPTY,C.get().streaming.buffer.setStallState&&c.setStallState(e.mediaType,e.state===s.Z.BUFFER_EMPTY))}function te(){t.info("Native video element event: play"),K(),W(),O.trigger(l.Z.PLAYBACK_STARTED,{startTime:B()})}function ne(){t.info("Native video element event: waiting"),O.trigger(l.Z.PLAYBACK_WAITING,{playingTime:B()})}function re(){t.info("Native video element event: playing"),I=!1,O.trigger(l.Z.PLAYBACK_PLAYING,{playingTime:B()})}function ie(){t.info("Native video element event: pause"),O.trigger(l.Z.PLAYBACK_PAUSED,{ended:H()})}function ae(){if(!I){var e=B();isNaN(A)||A===e||(e=A),A=NaN,t.info("Seeking to: "+e),W(),O.trigger(l.Z.PLAYBACK_SEEKING,{seekTime:e,streamId:y.id})}}function oe(){t.info("Native video element event: seeked"),I=!1,O.trigger(l.Z.PLAYBACK_SEEKED)}function se(){y&&O.trigger(l.Z.PLAYBACK_TIME_UPDATED,{timeToEnd:P(),time:B(),streamId:y.id})}function ue(){O.trigger(l.Z.PLAYBACK_PROGRESS,{streamId:y.id})}function le(){var e=j();t.info("Native video element event: ratechange: ",e),O.trigger(l.Z.PLAYBACK_RATE_CHANGED,{playbackRate:e})}function ce(){t.info("Native video element event: loadedmetadata"),O.trigger(l.Z.PLAYBACK_METADATA_LOADED),W()}function fe(){t.info("Native video element event: loadeddata"),O.trigger(l.Z.PLAYBACK_LOADED_DATA)}function de(){t.info("Native video element event: ended"),F(),X();var e=n?n.getActiveStreamInfo():null;e&&O.trigger(l.Z.PLAYBACK_ENDED,{isLast:e.isLast})}function ge(){O.trigger(l.Z.PLAYBACK_VOLUME_CHANGED)}function he(e){if(h&&e.isLast){t.info("onPlaybackEnded -- PLAYBACK_ENDED but native video element didn\'t fire ended");var n=e.seekTime?e.seekTime:L();c.setCurrentTime(n),F(),X()}}function pe(e){var t=e.target||e.srcElement;O.trigger(l.Z.PLAYBACK_ERROR,{error:t.error})}function me(){E=!1}function ye(e){if(!1===e.stream&&b&&!isNaN(e.request.duration)){var n=1.2*e.request.duration;n>p&&(t.warn("Browser does not support fetch API with StreamReader. Increasing live delay to be 20% higher than segment duration:",n.toFixed(2)),p=n,m=n)}}function Ee(e){O.trigger(l.Z.PLAYBACK_STALLED,{e:e})}function ve(e){var n;(n=e.mediaInfo)&&n.supplementalProperties&&"true"===n.supplementalProperties[a.Z.SUPPLEMENTAL_PROPERTY_DVB_LL_SCHEME]&&(t.debug("Low Latency critical SupplementalProperty set: Enabling low Latency"),b=!0)}function _e(e){var t=n.getActiveStreamInfo();e&&t&&e.currentRepresentation&&e.streamId&&e.streamId===t.id&&e.mediaType&&(e.mediaType===a.Z.VIDEO||e.mediaType===a.Z.AUDIO)&&(S=e.currentRepresentation.availabilityTimeComplete,(b=!S)&&!N&&(N=!0))}function Te(){w=!0}function Se(){w=!1}return e={initialize:function(t,n){y=t,!0!==n&&(c.addEventListener("canplay",J),c.addEventListener("canplaythrough",$),c.addEventListener("play",te),c.addEventListener("waiting",ne),c.addEventListener("playing",re),c.addEventListener("pause",ie),c.addEventListener("error",pe),c.addEventListener("seeking",ae),c.addEventListener("seeked",oe),c.addEventListener("timeupdate",se),c.addEventListener("progress",ue),c.addEventListener("ratechange",le),c.addEventListener("loadedmetadata",ce),c.addEventListener("loadeddata",fe),c.addEventListener("stalled",Ee),c.addEventListener("ended",de),c.addEventListener("volumechange",ge),E=y.manifestInfo.isDynamic,R=!1,I=!1,O.on(l.Z.DATA_UPDATE_COMPLETED,Q,e),O.on(l.Z.LOADING_PROGRESS,ye,e),O.on(l.Z.MANIFEST_UPDATED,Te,e),O.on(l.Z.STREAMS_COMPOSED,Se,e),O.on(d.Z.PLAYBACK_ENDED,he,e,{priority:u.Z.EVENT_PRIORITY_HIGH}),O.on(d.Z.STREAM_INITIALIZING,ve,e),O.on(d.Z.REPRESENTATION_SWITCH,_e,e),O.on(d.Z.BUFFER_LEVEL_STATE_CHANGED,ee,e),O.on(d.Z.DYNAMIC_TO_STATIC,me,e),v&&(v=!1,x()))},setConfig:function(e){e&&(e.streamController&&(n=e.streamController),e.serviceDescriptionController&&(r=e.serviceDescriptionController),e.dashMetrics&&(i=e.dashMetrics),e.adapter&&(o=e.adapter),e.videoModel&&(c=e.videoModel),e.timelineConverter&&(g=e.timelineConverter),e.settings&&(C=e.settings))},getTimeToStreamEnd:P,getBufferLevel:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=null;return n.getActiveStreamProcessors().forEach((function(n){if(!e||0===e.length||-1===e.indexOf(n.getType())){var r=n.getBufferLevel();t=null===t?r:Math.min(t,r)}})),t},getPlaybackStalled:function(){return R},getTime:B,getLowLatencyModeEnabled:function(){return b},getInitialCatchupModeActivated:function(){return N},getIsManifestUpdateInProgress:function(){return w},getPlaybackRate:j,getPlayedRanges:function(){return y&&c?c.getPlayedRanges():null},getEnded:H,getIsDynamic:V,getStreamController:function(){return n},computeAndSetLiveDelay:function(e,t){var n,i,a,s=!isNaN(e)&&isFinite(e)?e:NaN,u=o.getSuggestedPresentationDelay(),l=r.getServiceDescriptionSettings();return n=isNaN(C.get().streaming.delay.liveDelay)?null===C.get().streaming.delay.liveDelayFragmentCount||isNaN(C.get().streaming.delay.liveDelayFragmentCount)||isNaN(s)?l&&!isNaN(l.liveDelay)&&l.liveDelay>0?l.liveDelay:!0===C.get().streaming.delay.useSuggestedPresentationDelay&&null!==u&&!isNaN(u)&&u>0?u:isNaN(s)?t&&!isNaN(t.minBufferTime)?4*t.minBufferTime:4*y.manifestInfo.minBufferTime:4*s:s*C.get().streaming.delay.liveDelayFragmentCount:C.get().streaming.delay.liveDelay,null!==(a=o.getAvailabilityStartTime())&&(T=a),i=t&&t.dvrWindowSize>0?Math.min(n,t.dvrWindowSize):n,p=i,m=i,i},getLiveDelay:function(){return p},getOriginalLiveDelay:function(){return m},getCurrentLiveLatency:function(){if(!E||isNaN(T))return NaN;var e=B();if(isNaN(e)||0===e)return 0;var t=(new Date).getTime()+1e3*g.getClientTimeOffset();return Math.max(((t-T-1e3*e)/1e3).toFixed(3),0)},play:x,isPaused:G,isStalled:Y,pause:F,isSeeking:q,getStreamEndTime:L,seek:k,seekToOriginalLive:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=U();if(0!==r){var i=r-(p=m);k(i,e,t,n)}},seekToCurrentLive:function(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0],t=arguments.length>1&&void 0!==arguments[1]&&arguments[1],n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=U();if(0!==r){var i=r-p;k(i,e,t,n)}},reset:M,updateCurrentTime:K,getAvailabilityStartTime:function(){return T}},t=(0,f.Z)(D).getInstance().getLogger(e),M(),e}g.__dashjs_factory_name="PlaybackController";var h=c.Z.getSingletonFactory(g),p=n(3186),m="loading",y="executed",E="failed";function v(e){var t,n,r,i,a=(e=e||{}).eventBus,o=e.events,s=e.dashMetrics,u=e.fragmentLoader,l=e.debug,c=e.streamInfo,f=e.type;function d(e){var t;return!!e&&(t=!1,r.some((function(n){if(r=e,i=n,!isNaN(r.index)&&r.startTime===i.startTime&&r.adaptationIndex===i.adaptationIndex&&r.type===i.type||function(e,t){return isNaN(e.index)&&isNaN(t.index)&&e.quality===t.quality}(e,n)||function(e,t){return e.action===p.Z.ACTION_COMPLETE&&e.action===t.action}(e,n))return t=!0;var r,i})),t)}function g(e){return isNaN(e.duration)?.25:Math.min(e.duration/8,.5)}function h(e){r=r.filter((function(t){var n=g(t);return isNaN(t.startTime)||void 0!==e&&t.startTime>=e-n}))}function v(e,t){t<=e+.5||(r=r.filter((function(n){var r=g(n);return isNaN(n.startTime)||n.startTime>=t-r||isNaN(n.duration)||n.startTime+n.duration<=e+r})))}function _(e,t,n){for(var r=e.length-1;r>=0;r--){var i=e[r],a=i.startTime,o=a+i.duration;if(n=isNaN(n)?g(i):n,!isNaN(a)&&!isNaN(o)&&t+n>=a&&t-n<o||isNaN(a)&&isNaN(t))return i}return null}function T(e,t){s.addSchedulingInfo(e,t),s.addRequestsQueue(e.mediaType,i,r)}function S(e){e.sender===u&&(i.splice(i.indexOf(e.request),1),e.response&&!e.error&&r.push(e.request),T(e.request,e.error?E:y),a.trigger(o.FRAGMENT_LOADING_COMPLETED,{request:e.request,response:e.response,error:e.error,sender:this},{streamId:c.id,mediaType:f}))}function b(e){e.sender===u&&a.trigger(o.FRAGMENT_LOADING_PROGRESS,{request:e.request,response:e.response,error:e.error,sender:this},{streamId:c.id,mediaType:f})}function A(e){e.sender===u&&a.trigger(o.FRAGMENT_LOADING_ABANDONED,{request:e.request},{streamId:c.id,mediaType:f})}function I(){r=[],i=[]}return t={getStreamId:function(){return c.id},getType:function(){return f},getRequests:function(e){var t=e?e.state instanceof Array?e.state:[e.state]:[],n=[];return t.forEach((function(t){var a=function(e){var t;switch(e){case m:t=i;break;case y:t=r;break;default:t=[]}return t}(t);n=n.concat(function(e,t){return t.hasOwnProperty("time")?[_(e,t.time,t.threshold)]:e.filter((function(e){for(var n in t)if("state"!==n&&t.hasOwnProperty(n)&&e[n]!=t[n])return!1;return!0}))}(a,e))})),n},isFragmentLoaded:d,isFragmentLoadedOrPending:function(e){var t,n=!1,r=0;if(!(n=d(e)))for(r=0;r<i.length;r++)t=i[r],e.url===t.url&&e.startTime===t.startTime&&(n=!0);return n},removeExecutedRequestsBeforeTime:h,removeExecutedRequestsAfterTime:function(e){r=r.filter((function(t){return isNaN(t.startTime)||void 0!==e&&t.startTime<e}))},syncExecutedRequestsWithBufferedRange:function(e,t){if(e&&0!==e.length){for(var n=0,r=0,i=e.length;r<i;r++)v(n,e.start(r)),n=e.end(r);t>0&&v(n,t)}else h()},abortRequests:function(){n.debug("abort requests"),u.abort(),i=[]},executeRequest:function(e){e.action===p.Z.ACTION_DOWNLOAD?(T(e,m),i.push(e),function(e){a.trigger(o.FRAGMENT_LOADING_STARTED,{request:e},{streamId:c.id,mediaType:f}),u.load(e)}(e)):n.warn("Unknown request action.")},reset:function(){a.off(o.LOADING_COMPLETED,S,this),a.off(o.LOADING_DATA_PROGRESS,b,this),a.off(o.LOADING_ABANDONED,A,this),u&&u.reset(),I()},resetInitialSettings:I,addExecutedRequest:function(e){r.push(e)}},n=l.getLogger(t),I(),a.on(o.LOADING_COMPLETED,S,t),a.on(o.LOADING_DATA_PROGRESS,b,t),a.on(o.LOADING_ABANDONED,A,t),t}v.__dashjs_factory_name="FragmentModel";var _=c.Z.getClassFactory(v);_.FRAGMENT_MODEL_LOADING=m,_.FRAGMENT_MODEL_EXECUTED=y,_.FRAGMENT_MODEL_CANCELED="canceled",_.FRAGMENT_MODEL_FAILED=E,c.Z.updateClassFactory(v.__dashjs_factory_name,_);var T=_,S=n(5459);function b(e){return b="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},b(e)}function A(e,t){return A=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},A(e,t)}function I(e,t){return!t||"object"!==b(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function R(e){return R=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},R(e)}var w=new(function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&A(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=R(t);if(n){var i=R(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return I(this,e)});function i(){var e;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),(e=r.call(this)).MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE=10,e.MANIFEST_LOADER_LOADING_FAILURE_ERROR_CODE=11,e.XLINK_LOADER_LOADING_FAILURE_ERROR_CODE=12,e.SEGMENT_BASE_LOADER_ERROR_CODE=15,e.TIME_SYNC_FAILED_ERROR_CODE=16,e.FRAGMENT_LOADER_LOADING_FAILURE_ERROR_CODE=17,e.FRAGMENT_LOADER_NULL_REQUEST_ERROR_CODE=18,e.URL_RESOLUTION_FAILED_GENERIC_ERROR_CODE=19,e.APPEND_ERROR_CODE=20,e.REMOVE_ERROR_CODE=21,e.DATA_UPDATE_FAILED_ERROR_CODE=22,e.CAPABILITY_MEDIASOURCE_ERROR_CODE=23,e.CAPABILITY_MEDIAKEYS_ERROR_CODE=24,e.DOWNLOAD_ERROR_ID_MANIFEST_CODE=25,e.DOWNLOAD_ERROR_ID_SIDX_CODE=26,e.DOWNLOAD_ERROR_ID_CONTENT_CODE=27,e.DOWNLOAD_ERROR_ID_INITIALIZATION_CODE=28,e.DOWNLOAD_ERROR_ID_XLINK_CODE=29,e.MANIFEST_ERROR_ID_PARSE_CODE=31,e.MANIFEST_ERROR_ID_NOSTREAMS_CODE=32,e.TIMED_TEXT_ERROR_ID_PARSE_CODE=33,e.MANIFEST_ERROR_ID_MULTIPLEXED_CODE=34,e.MEDIASOURCE_TYPE_UNSUPPORTED_CODE=35,e.MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE="parsing failed for ",e.MANIFEST_LOADER_LOADING_FAILURE_ERROR_MESSAGE="Failed loading manifest: ",e.XLINK_LOADER_LOADING_FAILURE_ERROR_MESSAGE="Failed loading Xlink element: ",e.SEGMENTS_UPDATE_FAILED_ERROR_MESSAGE="Segments update failed",e.SEGMENTS_UNAVAILABLE_ERROR_MESSAGE="no segments are available yet",e.SEGMENT_BASE_LOADER_ERROR_MESSAGE="error loading segment ranges from sidx",e.TIME_SYNC_FAILED_ERROR_MESSAGE="Failed to synchronize client and server time",e.FRAGMENT_LOADER_NULL_REQUEST_ERROR_MESSAGE="request is null",e.URL_RESOLUTION_FAILED_GENERIC_ERROR_MESSAGE="Failed to resolve a valid URL",e.APPEND_ERROR_MESSAGE="chunk is not defined",e.REMOVE_ERROR_MESSAGE="Removing data from the SourceBuffer",e.DATA_UPDATE_FAILED_ERROR_MESSAGE="Data update failed",e.CAPABILITY_MEDIASOURCE_ERROR_MESSAGE="mediasource is not supported",e.CAPABILITY_MEDIAKEYS_ERROR_MESSAGE="mediakeys is not supported",e.TIMED_TEXT_ERROR_MESSAGE_PARSE="parsing error :",e.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE="Error creating source buffer of type : ",e}return i}(n(2230).Z)),N=n(1264),C=n(7855);function D(e){var t,n,r,i,o,s,u=this.context,c=(0,N.Z)(u).getInstance(),d=e.textController,g=e.eventBus,h=[],p=[],m=!1,y=e.mediaSource,E=null;function v(e){return new Promise((function(t){M((function(){i.changeType&&i.changeType(e),t()}))}))}function _(e){return i=d.getTextSourceBuffer(e),Promise.resolve()}function T(){if("function"==typeof i.addEventListener)try{i.addEventListener("updateend",D,!1),i.addEventListener("error",O,!1),i.addEventListener("abort",O,!1)}catch(e){s=setInterval(D,50)}else s=setInterval(D,50)}function b(e){return new Promise((function(t){i&&c.get().streaming.buffer.useAppendWindow?M((function(){try{if(!i)return void t();var n=y.duration,a=0;e&&!isNaN(e.start)&&!isNaN(e.duration)&&isFinite(e.duration)&&(n=e.start+e.duration),e&&!isNaN(e.start)&&(a=e.start),i.appendWindowEnd===n&&i.appendWindowStart===a||(i.appendWindowStart=0,i.appendWindowEnd=n+.01,i.appendWindowStart=Math.max(a-.1,0),r.debug("Updated append window for ".concat(o.type,". Set start to ").concat(i.appendWindowStart," and end to ").concat(i.appendWindowEnd))),t()}catch(e){r.warn("Failed to set append window"),t()}})):t()}))}function A(e){return new Promise((function(t){i?M((function(){try{i.timestampOffset===e||isNaN(e)||(i.timestampOffset=e,r.debug("Set MSE timestamp offset to ".concat(e))),t()}catch(e){t()}})):t()}))}function I(){if(!m&&p.length>0){m=!0;var e=p[0];p.splice(0,1);var t=function(){m=!1,p.length>0&&I.call(this),e&&e.data&&e.data.segmentType&&e.data.segmentType!==C.w.INIT_SEGMENT_TYPE&&delete e.data.bytes,e.promise.resolve({chunk:e.data})};try{E=e.request,0===e.data.bytes.byteLength?t.call(this):(i.appendBuffer?i.appendBuffer(e.data.bytes):i.append(e.data.bytes,e.data),M(t.bind(this)))}catch(t){r.fatal(\'SourceBuffer append failed "\'+t+\'"\'),p.length>0?I():m=!1,delete e.data.bytes,e.promise.reject({chunk:e.data,error:new S.Z(t.code,t.message)})}}}function R(){h.length>0&&(i.updating||(h.shift()(),R()))}function D(){i.updating||R()}function O(e){var t,r,i=e.target||{};t=l.Z.SOURCE_BUFFER_ERROR,r={error:i,lastRequestAppended:E}||{},g.trigger(t,r,{streamId:o.streamInfo.id,mediaType:n})}function M(e){h.push(e),i.updating||R()}return t={getType:function(){return n},getAllBufferRanges:function(){try{return i.buffered}catch(e){return r.error("getAllBufferRanges exception: "+e.message),null}},getBuffer:function(){return i},append:function(e){var t=this,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;return new Promise((function(r,i){e?(p.push({data:e,promise:{resolve:r,reject:i},request:n}),M(I.bind(t))):i({chunk:e,error:new S.Z(w.APPEND_ERROR_CODE,w.APPEND_ERROR_MESSAGE)})}))},remove:function(e){return new Promise((function(t,n){var r=e.start,a=e.end;r>=0&&a>r?M((function(){try{i.remove(r,a),M((function(){t({from:r,to:a,unintended:!1}),e.resolve&&e.resolve()}))}catch(t){n({from:r,to:a,unintended:!1,error:new S.Z(w.REMOVE_ERROR_CODE,w.REMOVE_ERROR_MESSAGE)}),e.reject&&e.reject(t)}})):t()}))},abort:function(){return new Promise((function(e){try{p=[],"open"===y.readyState?M((function(){try{i&&i.abort(),e()}catch(t){e()}})):i&&i.setTextTrack&&"ended"===y.readyState?(i.abort(),e()):e()}catch(t){e()}}))},reset:function(){if(i){try{h=[],function(){try{"function"==typeof i.removeEventListener&&(i.removeEventListener("updateend",D,!1),i.removeEventListener("error",O,!1),i.removeEventListener("abort",O,!1)),clearInterval(s)}catch(e){r.error(e)}}(),m=!1,p=[],i.getClassName&&"TextSourceBuffer"===i.getClassName()||(r.debug("Removing sourcebuffer from media source"),y.removeSourceBuffer(i))}catch(e){}i=null}E=null},updateTimestampOffset:A,initializeForStreamSwitch:function(e,t,r){n=(o=e).type;var a=o.codec;!function(e){i=e.getBuffer()}(r),T();var s=[];return s.push(new Promise((function(e){M((function(){var t=i.appendWindowStart,n=i.appendWindowEnd;i&&(i.abort(),i.appendWindowStart=t,i.appendWindowEnd=n),e()}))}))),s.push(b(o.streamInfo)),c.get().streaming.buffer.useChangeTypeForTrackSwitch&&s.push(v(a)),t&&void 0!==t.MSETimeOffset&&s.push(A(t.MSETimeOffset)),Promise.all(s)},initializeForFirstUse:function(e,t,r){n=(o=t).type;var s=o.codec;try{if(s.match(/application\\/mp4;\\s*codecs="(stpp|wvtt).*"/i))return _(e);i=y.addSourceBuffer(s),T();var u=[];return u.push(b(o.streamInfo)),r&&void 0!==r.MSETimeOffset&&u.push(A(r.MSETimeOffset)),Promise.all(u)}catch(t){return o.type==a.Z.TEXT&&!o.isFragmented||-1!==s.indexOf(\'codecs="stpp\')||-1!==s.indexOf(\'codecs="vtt\')||-1!==s.indexOf("text/vtt")?_(e):Promise.reject(t)}},updateAppendWindow:b,changeType:v},r=(0,f.Z)(u).getInstance().getLogger(t),t}D.__dashjs_factory_name="SourceBufferSink";var O=c.Z.getClassFactory(D);function M(e){var t,n,r,i=this.context,a=[],o=e;function s(e,t){return a=a.filter((function(n){return!((isNaN(t)||n.start<t)&&(isNaN(e)||n.end>e))})),Promise.resolve()}return t={getAllBufferRanges:function(){for(var e=[],t=0;t<a.length;t++){var n=a[t];0===e.length||n.start>e[e.length-1].end?e.push({start:n.start,end:n.end}):e[e.length-1].end=n.end}var r={start:function(t){return e[t].start},end:function(t){return e[t].end}};return Object.defineProperty(r,"length",{get:function(){return e.length}}),r},append:function(e){return"InitializationSegment"!==e.segmentType?(a.push(e),a.sort((function(e,t){return e.start-t.start})),r=null):r=e,n.debug("PreBufferSink appended chunk s: "+e.start+"; e: "+e.end),o&&o({chunk:e}),Promise.resolve()},remove:s,abort:function(){return Promise.resolve()},discharge:function(e,t){var n=function(e,t){return a.filter((function(n){return(isNaN(t)||n.start<t)&&(isNaN(e)||n.end>e)}))}(e,t);return r&&(n.push(r),r=null),s(e,t),n},reset:function(){a=[],r=null,o=null},updateTimestampOffset:function(){return Promise.resolve()},waitForUpdateEnd:function(e){e()},getBuffer:function(){return this}},n=(0,f.Z)(i).getInstance().getLogger(t),t}M.__dashjs_factory_name="PreBufferSink";var P=c.Z.getClassFactory(M);function L(){var e={};return{save:function(t){var n=t.streamId,r=t.representationId;e[n]=e[n]||{},e[n][r]=t},extract:function(t,n){return e&&e[t]&&e[t][n]?e[t][n]:null},reset:function(){e={}}}}L.__dashjs_factory_name="InitCache";var x=c.Z.getSingletonFactory(L),F=.01,k="BufferController";function U(e){e=e||{};var t,n,r,i,o,c,g,h,p,m,y,E,v,_,b,A,I,R,N,D,M,L=this.context,U=(0,u.Z)(L).getInstance(),Z=e.errHandler,B=e.fragmentModel,G=e.representationController,q=e.adapter,Y=e.textController,j=e.abrController,H=e.playbackController,V=e.streamInfo,K=e.type,z=e.settings;function W(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;return new Promise((function(n,r){c=e,p&&t&&"function"==typeof p.discharge?(m=p,Q(t).then((function(){n()})).catch((function(e){r(e)}))):n()}))}function X(e){return q.convertRepresentationToRepresentationInfo(G.getRepresentationForQuality(e))}function Q(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];return new Promise((function(n,r){R&&e?c?(y=!1,$(e,t).then((function(e){n(e)})).catch((function(e){r(e)}))):(y=!0,J().then((function(e){n(e)})).catch((function(e){r(e)}))):n(null)}))}function J(){var e=this;return new Promise((function(t,n){var r=j.getQualityFor(K,V.id);p=P(L).create(ie.bind(e)),_e(X(r)).then((function(){t(p)})).catch((function(){n()}))}))}function $(e,t){return new Promise((function(r,i){var o=j.getQualityFor(K,V.id);p=O(L).create({mediaSource:c,textController:Y,eventBus:U}),function(e,t,n){var r=X(n);return t&&t[K]&&(K===a.Z.VIDEO||K===a.Z.AUDIO)?p.initializeForStreamSwitch(e,r,t[K]):p.initializeForFirstUse(V,e,r)}(e,t,o).then((function(){return _e(X(o))})).then((function(){r(p)})).catch((function(e){n.fatal("Caught error on create SourceBuffer: "+e),Z.error(new S.Z(w.MEDIASOURCE_TYPE_UNSUPPORTED_CODE,w.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE+K)),i(e)}))}))}function ee(e){z.get().streaming.cacheInitSegments&&(n.info("Init fragment finished loading saving to",K+"\'s init cache"),R.save(e.chunk)),n.debug("Append Init fragment",K," with representationId:",e.chunk.representationId," and quality:",e.chunk.quality,", data size:",e.chunk.bytes.byteLength),ne(e.chunk)}function te(e){ne(e.chunk,e.request)}function ne(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;p&&(p.append(e,t).then((function(e){ie(e)})).catch((function(e){ie(e)})),e.mediaInfo.type===a.Z.VIDEO&&Ne(l.Z.VIDEO_CHUNK_RECEIVED,{chunk:e}))}function re(e){if(e&&e.length>0)for(var t=0,r=e.length;t<r;t++)n.debug("Buffered range: "+e.start(t)+" - "+e.end(t)+", currentTime = ",H.getTime())}function ie(e){if(e.error)return 22===e.error.code&&function(){if(I=!0,o=.8*Ie(),n.warn("Quota exceeded, Critical Buffer: "+o),o>0){var e=Math.max(.2*o,1),t=o-e,r=Math.min(z.get().streaming.buffer.bufferTimeAtTopQuality,.9*t),i=Math.min(z.get().streaming.buffer.bufferTimeAtTopQualityLongForm,.9*t),a={streaming:{buffer:{bufferToKeep:parseFloat(e.toFixed(5)),bufferTimeAtTopQuality:parseFloat(r.toFixed(5)),bufferTimeAtTopQualityLongForm:parseFloat(i.toFixed(5))}}};z.update(a)}}(),void(22!==e.error.code&&we()||(n.warn("Clearing playback buffer to overcome quota exceed situation"),Ne(l.Z.QUOTA_EXCEEDED,{criticalBufferLevel:o,quotaExceededTime:e.chunk.start}),ye(me())));if(p&&(fe(),I=!1,(_=e.chunk)&&_.endFragment)){_&&!isNaN(_.index)&&(g=Math.max(_.index,g),de());var t=p.getAllBufferRanges();_.segmentType===C.w.MEDIA_SEGMENT_TYPE&&(re(t),se(),function(){if(!isNaN(M)&&!y)if(K===a.Z.AUDIO||K===a.Z.VIDEO){var e=H.getTime(),t=ce(e,0),n=ce(M,0);if(t&&n&&t.start===n.start)M=NaN;else{var r=G.getCurrentRepresentation().segmentDuration,i=ce(M,r);i&&(z.get().streaming.buffer.enableSeekDecorrelationFix&&Math.abs(e-M)>r?M<=i.end&&H.seek(Math.max(M,i.start),!1,!0):e<i.start&&H.seek(i.start,!1,!0))}}else M=NaN}());var r=!1;E&&(E.indexOf(_)>0&&(r=!0),E=null),_&&!r&&Ne(l.Z.BYTES_APPENDED_END_FRAGMENT,{quality:_.quality,startTime:_.start,index:_.index,bufferedRanges:t,segmentType:_.segmentType,mediaType:K})}}function ae(){return new Promise((function(e,t){var n=oe();if(!n||0===n.length)return se(),void e();ye(n).then((function(){e()})).catch((function(e){t(e)}))}))}function oe(e){var t=[],r=p.getAllBufferRanges();if(!r||0===r.length)return t;if(!e&&0!==e||isNaN(e))t.push({start:r.start(0),end:r.end(r.length-1)+.5});else{var i=function(e,t){var n=z.get().streaming.buffer.bufferToKeep,r=t.start(0);if(e-r>n){var i=Math.max(0,e-n),a=B.getRequests({state:T.FRAGMENT_MODEL_EXECUTED,time:e,threshold:F})[0];if(a&&(i=Math.min(a.startTime,i)),i>0)return{start:r,end:i}}return null}(e,r),a=function(e,t){var r=t.end(t.length-1)+.5,i=Re(e),a=V.manifestInfo.duration>=z.get().streaming.buffer.longFormContentDurationThreshold?z.get().streaming.buffer.bufferTimeAtTopQualityLongForm:z.get().streaming.buffer.bufferTimeAtTopQuality,o=isNaN(i)?e:Math.min(i,e+a);if(o>=t.end(t.length-1))return null;var s=B.getRequests({state:T.FRAGMENT_MODEL_EXECUTED,time:e,threshold:F})[0];if(s&&(o=Math.max(s.startTime+s.duration,o)),z.get().streaming.buffer.avoidCurrentTimeRangePruning)for(var u=0;u<t.length;u++)if(t.start(u)<=e&&e<=t.end(u)&&t.start(u)<=o&&o<=t.end(u)){var l=o;o=u+1<t.length?t.start(u+1):t.end(u)+1,n.debug("Buffered range ["+t.start(u)+", "+t.end(u)+"] overlaps with targetTime "+e+" and range to be pruned ["+l+", "+r+"], using ["+o+", "+r+"] instead"+(o<r?"":" (no actual pruning)"));break}return o<t.end(t.length-1)?{start:o,end:r}:null}(e,r);i&&t.push(i),a&&t.push(a)}return t}function se(){(!D||K===a.Z.TEXT&&Y.isTextEnabled())&&fe()}function ue(){ge()}function le(){ge(),M=NaN}function ce(e,t){if(!p)return null;var n,r,i=p.getAllBufferRanges(),a=0,o=0,s=null,u=null,l=0,c=isNaN(t)?.15:t;if(null!=i){for(r=0,n=i.length;r<n;r++)if(a=i.start(r),o=i.end(r),null===s)l=Math.abs(a-e),(e>=a&&e<o||l<=c)&&(s=a,u=o);else{if(!((l=a-u)<=c))break;u=o}if(null!==s)return{start:s,end:u}}return null}function fe(){if(H){var e=H.getTime()||0;y&&(e=isNaN(M)?0:M);var t=z.get().streaming.gaps.jumpGaps&&!isNaN(z.get().streaming.gaps.smallGapLimit)?z.get().streaming.gaps.smallGapLimit:NaN;i=Math.max(function(e,t){var n;return z.get().streaming.gaps.jumpGaps&&(t=z.get().streaming.gaps.smallGapLimit),null===(n=ce(e,t))?0:n.end-e}(e,t),0),Ne(l.Z.BUFFER_LEVEL_UPDATED,{mediaType:K,bufferLevel:i}),ge()}}function de(){var e=g>=h-1,t=H.getTimeToStreamEnd(V)-i<1e-5;!e&&!t||r||(Ae(!0),n.debug("checkIfBufferingCompleted trigger BUFFERING_COMPLETED for stream id ".concat(V.id," and type ").concat(K)))}function ge(){K!==a.Z.AUDIO&&K!==a.Z.VIDEO||((!H.getLowLatencyModeEnabled()&&i<z.get().streaming.buffer.stallThreshold||0===i)&&!r?he(s.Z.BUFFER_EMPTY):(r||i>=z.get().streaming.buffer.stallThreshold||H.getLowLatencyModeEnabled()&&i>0)&&he(s.Z.BUFFER_LOADED))}function he(e){v===e||e===s.Z.BUFFER_EMPTY&&0===H.getTime()||K===a.Z.TEXT&&!Y.isTextEnabled()||(v=e,Ne(l.Z.BUFFER_LEVEL_STATE_CHANGED,{state:e}),Ne(e===s.Z.BUFFER_LOADED?l.Z.BUFFER_LOADED:l.Z.BUFFER_EMPTY),n.debug(e===s.Z.BUFFER_LOADED?"Got enough buffer to start":"Waiting for more buffer before starting playback"))}function pe(){p&&K!==a.Z.TEXT&&(r||ye(me()))}function me(){var e=[],t=p.getAllBufferRanges();if(!t||0===t.length)return e;var n=H.getTime(),r=Math.max(0,n-z.get().streaming.buffer.bufferToKeep),i=B.getRequests({state:T.FRAGMENT_MODEL_EXECUTED,time:n,threshold:F})[0];if(i)r=Math.min(i.startTime,r);else if(0===n&&H.getIsDynamic())return[];if(t.start(0)<=r){for(var a={start:0,end:r},o=0;o<t.length&&t.end(o)<=r;o++)a.end=t.end(o);a.start<a.end&&e.push(a)}return e}function ye(e){return new Promise((function(t,n){if(e&&p&&0!==e.length){var r=[];e.forEach((function(e){r.push(function(e){return new Promise((function(t,n){e.resolve=t,e.reject=n,N.push(e)}))}(e))})),A||Ee(),Promise.all(r).then((function(){t()})).catch((function(e){n(e)}))}else t()}))}function Ee(){try{if(0===N.length||!p)return n.debug("Nothing to prune, halt pruning"),N=[],void(A=!1);var e=p.getBuffer();if(!e||!e.buffered||0===e.buffered.length)return n.debug("SourceBuffer is empty (or does not exist), halt pruning"),N=[],void(A=!1);var t=N.shift();n.debug("".concat(K,": Removing buffer from: ").concat(t.start," to ").concat(t.end)),A=!0,H.getTime()<t.end&&Ae(!1),p.remove(t).then((function(e){ve(e)})).catch((function(e){ve(e)}))}catch(e){A=!1}}function ve(e){n.debug("onRemoved buffer from:",e.from,"to",e.to),p&&(re(p.getAllBufferRanges()),0===N.length&&(A=!1,fe()),e.unintended&&(n.warn("Detected unintended removal from:",e.from,"to",e.to,"setting streamprocessor time to",e.from),Ne(l.Z.SEEK_TARGET,{time:e.from})),A?Ee():(D?D=!1:fe(),Ne(l.Z.BUFFER_CLEARED,{from:e.from,to:e.to,unintended:e.unintended,hasEnoughSpaceToAppend:we(),quotaExceeded:I})))}function _e(e){return new Promise((function(t){e&&void 0!==e.MSETimeOffset&&p&&p.updateTimestampOffset?p.updateTimestampOffset(e.MSETimeOffset).then((function(){t()})).catch((function(){t()})):t()}))}function Te(){return p&&!r?p.updateAppendWindow(V):Promise.resolve()}function Se(){++b*(z.get().streaming.wallclockTimeUpdateInterval/1e3)>=z.get().streaming.buffer.bufferPruningInterval&&(b=0,pe())}function be(){ge()}function Ae(e){(r=e)?Ne(l.Z.BUFFERING_COMPLETED):h=Number.POSITIVE_INFINITY}function Ie(){try{var e,t,n=p.getAllBufferRanges(),r=0;if(!n)return r;for(t=0,e=n.length;t<e;t++)r+=n.end(t)-n.start(t);return r}catch(e){return 0}}function Re(e){try{var t=e,n=p.getAllBufferRanges();if(!n||0===n.length)return NaN;for(var r=0;t===e&&r<n.length;){var i=n.start(r),a=n.end(r);t>=i&&t<=a&&(t=a),r+=1}return t===e?NaN:t}catch(e){}}function we(){var e=Ie();return isNaN(e)||e<o}function Ne(e,t){var n=t||{};U.trigger(e,n,{streamId:V.id,mediaType:K})}function Ce(e,t){if(o=Number.POSITIVE_INFINITY,v=void 0,h=Number.POSITIVE_INFINITY,g=0,_=null,r=!1,A=!1,I=!1,i=0,b=0,N=[],M=NaN,y=!1,p){var n=p;p=null,e||t||n.abort().then((function(){n.reset(t),n=null}))}D=!1}return t={initialize:function(e){W(e),U.on(l.Z.INIT_FRAGMENT_LOADED,ee,t),U.on(l.Z.MEDIA_FRAGMENT_LOADED,te,t),U.on(l.Z.WALLCLOCK_TIME_UPDATED,Se,t),U.on(d.Z.PLAYBACK_PLAYING,le,t),U.on(d.Z.PLAYBACK_PROGRESS,se,t),U.on(d.Z.PLAYBACK_TIME_UPDATED,se,t),U.on(d.Z.PLAYBACK_RATE_CHANGED,be,t),U.on(d.Z.PLAYBACK_STALLED,ue,t)},getStreamId:function(){return V.id},getType:function(){return K},getBufferControllerType:function(){return k},createBufferSink:Q,dischargePreBuffer:function(){if(p&&m&&"function"==typeof m.discharge){var e=m.getAllBufferRanges();if(e.length>0){for(var t="Beginning "+K+"PreBuffer discharge, adding buffer for:",r=0;r<e.length;r++)t+=" start: "+e.start(r)+", end: "+e.end(r)+";";n.debug(t)}else n.debug("PreBuffer discharge requested, but there were no media segments in the PreBuffer.");E=[];for(var i=m.discharge(),a=null,o=0;o<i.length;o++){var s=i[o];if(s.segmentType!==C.w.INIT_SEGMENT_TYPE){var u=R.extract(s.streamId,s.representationId);u&&a!==u&&(E.push(u),p.append(u),a=u)}E.push(s),p.append(s)}m.reset(),m=null}},getBuffer:function(){return p},getBufferLevel:function(){return i},getRangeAt:ce,hasBufferAtTime:function(e){try{var t=p.getAllBufferRanges();if(!t||0===t.length)return!1;for(var r=0;r<t.length;){var i=t.start(r),a=t.end(r);if(e>=i&&e<=a)return!0;r+=1}return!1}catch(e){return n.error(e),!1}},pruneBuffer:pe,setMediaSource:W,getMediaSource:function(){return c},appendInitSegmentFromCache:function(e){var t=R.extract(V.id,e);return!!t&&(n.info("Append Init fragment",K," with representationId:",t.representationId," and quality:",t.quality,", data size:",t.bytes.byteLength),ne(t),!0)},getIsBufferingCompleted:function(){return r},setIsBufferingCompleted:Ae,getIsPruningInProgress:function(){return A},reset:function(e,t){U.off(l.Z.INIT_FRAGMENT_LOADED,ee,this),U.off(l.Z.MEDIA_FRAGMENT_LOADED,te,this),U.off(l.Z.WALLCLOCK_TIME_UPDATED,Se,this),U.off(d.Z.PLAYBACK_PLAYING,le,this),U.off(d.Z.PLAYBACK_PROGRESS,se,this),U.off(d.Z.PLAYBACK_TIME_UPDATED,se,this),U.off(d.Z.PLAYBACK_RATE_CHANGED,be,this),U.off(d.Z.PLAYBACK_STALLED,ue,this),Ce(e,t)},prepareForPlaybackSeek:function(){return r&&Ae(!1),p.abort()},prepareForReplacementTrackSwitch:function(e){return new Promise((function(t,n){p.abort().then((function(){return Te()})).then((function(){return z.get().streaming.buffer.useChangeTypeForTrackSwitch?p.changeType(e):Promise.resolve()})).then((function(){return ae()})).then((function(){Ae(!1),t()})).catch((function(e){n(e)}))}))},prepareForNonReplacementTrackSwitch:function(e){return new Promise((function(t,n){Te().then((function(){return z.get().streaming.buffer.useChangeTypeForTrackSwitch?p.changeType(e):Promise.resolve()})).then((function(){t()})).catch((function(e){n(e)}))}))},prepareForForceReplacementQualitySwitch:function(e){return new Promise((function(t,n){p.abort().then((function(){return Te()})).then((function(){return ae()})).then((function(){return _e(e)})).then((function(){Ae(!1),t()})).catch((function(e){n(e)}))}))},updateAppendWindow:Te,getAllRangesWithSafetyFactor:oe,getContinuousBufferTimeForTargetTime:Re,clearBuffers:ye,pruneAllSafely:ae,updateBufferTimestampOffset:_e,setSeekTarget:function(e){M=e},segmentRequestingCompleted:function(e){isNaN(e)||(h=e,de())}},n=(0,f.Z)(L).getInstance().getLogger(t),R=x(L).getInstance(),Ce(),t}U.__dashjs_factory_name=k;var Z=c.Z.getClassFactory(U),B="NotFragmentedTextBufferController";function G(e){e=e||{};var t,n,r,i,a,o,s=this.context,c=(0,u.Z)(s).getInstance(),f=e.textController,d=e.errHandler,g=e.streamInfo,h=e.type;function p(e){i=e}function m(e){var t,r;n!==e&&(n=e)&&(t=l.Z.BUFFERING_COMPLETED,r={},c.trigger(t,r,{streamId:g.id,mediaType:h}))}function y(e){e.chunk.bytes&&!n&&(o.save(e.chunk),a.append(e.chunk),m(!0))}return t={initialize:function(e){p(e)},getStreamId:function(){return g.id},getType:function(){return h},getBufferControllerType:function(){return B},createBufferSink:function(e){return new Promise((function(t,n){try{(a=O(s).create({mediaSource:i,textController:f,eventBus:c})).initializeForFirstUse(g,e),r||(a.getBuffer()&&"function"==typeof a.getBuffer().initialize&&a.getBuffer().initialize(),r=!0),t(a)}catch(e){d.error(new S.Z(w.MEDIASOURCE_TYPE_UNSUPPORTED_CODE,w.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE+h)),n(e)}}))},dischargePreBuffer:function(){},getBuffer:function(){return a},getBufferLevel:function(){return 0},getRangeAt:function(){return null},pruneBuffer:function(){},hasBufferAtTime:function(){return!0},getAllRangesWithSafetyFactor:function(){return[]},getContinuousBufferTimeForTargetTime:function(){return Number.POSITIVE_INFINITY},setMediaSource:p,getMediaSource:function(){return i},appendInitSegmentFromCache:function(e){return null!==o.extract(g.id,e)},getIsBufferingCompleted:function(){return n},setIsBufferingCompleted:m,getIsPruningInProgress:function(){return!1},reset:function(e){c.off(l.Z.INIT_FRAGMENT_LOADED,y,t),!e&&a&&(a.abort(),a.reset(),a=null)},clearBuffers:function(){return Promise.resolve()},prepareForPlaybackSeek:function(){return Promise.resolve()},prepareForReplacementTrackSwitch:function(){return n=!1,Promise.resolve()},setSeekTarget:function(){},updateAppendWindow:function(){return Promise.resolve()},pruneAllSafely:function(){return Promise.resolve()},updateBufferTimestampOffset:function(){return Promise.resolve()},segmentRequestingCompleted:function(){}},r=!1,i=null,n=!1,o=x(s).getInstance(),c.on(l.Z.INIT_FRAGMENT_LOADED,y,t),t}G.__dashjs_factory_name=B;var q=c.Z.getClassFactory(G);function Y(e){e=e||{};var t,n,r,i,o,c,g,h,p,m,y,E,v,_=this.context,S=(0,u.Z)(_).getInstance(),b=e.dashMetrics,A=e.mediaPlayerModel,I=e.fragmentModel,R=e.abrController,w=e.playbackController,N=e.textController,C=e.type,D=e.bufferController,O=e.representationController,M=e.settings;function P(){E=!0}function L(){E=!1}function x(e){if(!D.getIsBufferingCompleted()){F();var t=isNaN(e)?0:e;o=setTimeout(k,t)}}function F(){o&&(clearTimeout(o),o=null)}function k(){try{if(function(){try{return C===a.Z.TEXT&&!N.isTextEnabled()||w.isPaused()&&(!w.getStreamController().getInitialPlayback()||!w.getStreamController().getAutoPlay())&&!M.get().streaming.scheduling.scheduleWhilePaused}catch(e){return!1}}())return void F();if(function(){try{return!!E&&O.getCurrentRepresentationInfo()&&(isNaN(p)||m||(e=n.id,t=R.getMaxAllowedIndexFor(C,e),!(!isNaN(h)&&h==t||(r.info("Top quality "+C+" index has changed from "+h+" to "+t),h=t,0)))||function(){var e=O.getCurrentRepresentationInfo();return!C||!e||b.getCurrentBufferLevel(C)<U()}())}catch(e){return!1}var e,t}()){var e=!1;v&&(e=R.checkPlaybackQuality(C,n.id)),e||(i=O.getCurrentRepresentationInfo(),y||i.quality!==p||m?(m?(r.debug("Switch track for "+C+", representation id = "+i.id),m=!1):r.debug("Quality has changed, get init request for representationid = "+i.id),S.trigger(l.Z.INIT_FRAGMENT_NEEDED,{representationId:i.id,sender:t},{streamId:n.id,mediaType:C}),v=!1,y=!1):(r.debug("Media segment needed for ".concat(C," and stream id ").concat(n.id)),S.trigger(l.Z.MEDIA_FRAGMENT_NEEDED,{},{streamId:n.id,mediaType:C}),v=!0))}else x(w.getLowLatencyModeEnabled()?M.get().streaming.scheduling.lowLatencyTimeout:M.get().streaming.scheduling.defaultTimeout)}catch(e){x(w.getLowLatencyModeEnabled()?M.get().streaming.scheduling.lowLatencyTimeout:M.get().streaming.scheduling.defaultTimeout)}var i}function U(){var e=NaN,t=O.getCurrentRepresentationInfo();return C&&t?(e=C===a.Z.TEXT?function(){try{if(N.isTextEnabled()){var e=O.getCurrentRepresentationInfo();if(isNaN(e.fragmentDuration)){var t=b.getCurrentSchedulingInfo(s.Z.SCHEDULING_INFO);return t?t.duration:0}return e.fragmentDuration}return 0}catch(e){return 0}}():C===a.Z.AUDIO&&c?function(){try{var e=b.getCurrentBufferLevel(a.Z.VIDEO),t=O.getCurrentRepresentationInfo();return isNaN(t.fragmentDuration)?e+1:Math.max(e+1,t.fragmentDuration)}catch(e){return 0}}():function(){try{var e=O.getCurrentRepresentationInfo().mediaInfo.streamInfo;return R.isPlayingAtTopQuality(e)?e.manifestInfo.duration>=M.get().streaming.buffer.longFormContentDurationThreshold?M.get().streaming.buffer.bufferTimeAtTopQualityLongForm:M.get().streaming.buffer.bufferTimeAtTopQuality:A.getStableBufferTime()}catch(e){return A.getStableBufferTime()}}(),e):e}function Z(){B(!0)}function B(e){if(w&&I){var t=I.getRequests({state:T.FRAGMENT_MODEL_EXECUTED,time:w.getTime(),threshold:0})[0];t&&w.getTime()>=t.startTime&&((!g.mediaInfo||t.mediaInfo.type===g.mediaInfo.type&&t.mediaInfo.index!==g.mediaInfo.index)&&e&&S.trigger(l.Z.TRACK_CHANGE_RENDERED,{mediaType:C,oldMediaInfo:g.mediaInfo,newMediaInfo:t.mediaInfo,streamId:n.id}),t.quality===g.quality&&t.adaptationIndex===g.adaptationIndex||!e||(r.debug("Quality change rendered for streamId ".concat(n.id," and type ").concat(C)),S.trigger(l.Z.QUALITY_CHANGE_RENDERED,{mediaType:C,oldQuality:g.quality,newQuality:t.quality,streamId:n.id})),g={mediaInfo:t.mediaInfo,quality:t.quality,adaptationIndex:t.adaptationIndex})}}function G(){I.abortRequests(),F()}function q(){M.get().streaming.scheduling.scheduleWhilePaused||x()}function Y(e){b.updatePlayListTraceMetrics({playbackspeed:e.playbackRate.toString()})}function j(){v=!0,i=0,p=NaN,g={mediaInfo:void 0,quality:NaN,adaptationIndex:NaN},h=NaN,m=!1,y=!1,E=!0}return t={initialize:function(e){c=e,S.on(l.Z.URL_RESOLUTION_FAILED,G,t),S.on(d.Z.PLAYBACK_STARTED,q,t),S.on(d.Z.PLAYBACK_RATE_CHANGED,Y,t),S.on(d.Z.PLAYBACK_TIME_UPDATED,Z,t),S.on(d.Z.MANAGED_MEDIA_SOURCE_START_STREAMING,P,t),S.on(d.Z.MANAGED_MEDIA_SOURCE_END_STREAMING,L,t)},getType:function(){return C},getStreamId:function(){return n.id},setTimeToLoadDelay:function(e){i=e},getTimeToLoadDelay:function(){return i},setSwitchTrack:function(e){m=e},getSwitchTrack:function(){return m},startScheduleTimer:x,clearScheduleTimer:F,reset:function(){S.off(l.Z.URL_RESOLUTION_FAILED,G,t),S.off(d.Z.PLAYBACK_STARTED,q,t),S.off(d.Z.PLAYBACK_RATE_CHANGED,Y,t),S.off(d.Z.PLAYBACK_TIME_UPDATED,Z,t),S.off(d.Z.MANAGED_MEDIA_SOURCE_START_STREAMING,P,t),S.off(d.Z.MANAGED_MEDIA_SOURCE_END_STREAMING,L,t),F(),B(!1),j(),n=null},getBufferTarget:U,getPlaybackController:function(){return w},setCheckPlaybackQuality:function(e){v=e},setInitSegmentRequired:function(e){y=e},setLastInitializedQuality:function(e){p=e}},r=(0,f.Z)(_).getInstance().getLogger(t),j(),n=e.streamInfo,t}Y.__dashjs_factory_name="ScheduleController";var j=c.Z.getClassFactory(Y),H=n(7387);function V(e){var t,n,r,i,o,s,u=(e=e||{}).eventBus,l=e.events,c=e.abrController,f=e.dashMetrics,g=e.playbackController,h=e.timelineConverter,p=e.type,m=e.streamInfo,y=e.dashConstants,E=e.segmentsController,v=e.isDynamic,_=e.adapter;function T(){return p}function S(){return r}function b(){return s}function A(){n=null,r=!0,i=[],o=null}function I(e){return new Promise((function(t,n){var r=e.hasInitialization(),a=e.hasSegments(),o=[];o.push(E.updateInitData(e,r)),o.push(E.updateSegmentData(e,a)),Promise.all(o).then((function(n){var r;n[0]&&!n[0].error&&(e=function(e,t){return t&&!t.error&&t.representation?t.representation:e}(e,n[0])),n[1]&&!n[1].error&&(e=function(e,t){if(t&&!t.error){var n,r,i,a,o=t.segments,s=[],u=0;for(n=0,r=o?o.length:0;n<r;n++)i=o[n],(a=(0,H.TJ)(h,v,e,i.startTime,i.duration,i.timescale,i.media,i.mediaRange,u))&&(s.push(a),a=null,u++);return s.length>0&&(e.segments=s),e}}(e,n[1])),(r=e).mediaFinishedInformation=E.getMediaFinishedInformation(r),function(e){if(S()){var t,n,r=f.getCurrentManifestUpdate(),a=!1;if(r){for(var o=0;o<r.representationInfo.length;o++)if((t=r.representationInfo[o]).index===e.index&&t.mediaType===T()){a=!0;break}a||f.addManifestUpdateRepresentationInfo(e,T())}if(function(){for(var e=0,t=i.length;e<t;e++){var n=i[e].segmentInfoType;if(!i[e].hasInitialization()||(n===y.SEGMENT_BASE||n===y.BASE_URL)&&!i[e].segments)return!1}return!0}()){c.setPlaybackQuality(p,m,(n=s,i.indexOf(n)));var u=f.getCurrentDVRInfo(p);u&&f.updateManifestUpdateInfo({latency:u.range.end-g.getTime()}),f.getCurrentRepresentationSwitch(b().adaptation.type)||R(),N()}}}(e),t()})).catch((function(e){n(e)}))}))}function R(){!function(){if(!(c&&f&&g&&h))throw new Error(a.Z.MISSING_CONFIG_ERROR)}();var e=new Date,t=b(),n=1e3*g.getTime();t&&f.addRepresentationSwitch(t.adaptation.type,e,n,t.id),u.trigger(d.Z.REPRESENTATION_SWITCH,{mediaType:p,streamId:m.id,currentRepresentation:t,numberOfRepresentations:i.length},{streamId:m.id,mediaType:p})}function w(e){return null==e||e>=i.length?null:i[e]}function N(e){r=!1,u.trigger(l.DATA_UPDATE_COMPLETED,{data:n,currentRepresentation:s,error:e},{streamId:m.id,mediaType:p})}function C(e){s=e,o=_.convertRepresentationToRepresentationInfo(s)}function D(e){if(e.newDuration){var t=b();t&&t.adaptation.period&&(t.adaptation.period.duration=e.newDuration)}}return t={getStreamId:function(){return m.id},getType:T,getData:function(){return n},isUpdating:S,updateData:function(e,t,o,s,u){return new Promise((function(l,c){if(r=!0,i=t,n=e,C(w(u)),o!==a.Z.VIDEO&&o!==a.Z.AUDIO&&(o!==a.Z.TEXT||!s))return N(),void l();for(var f=[],d=0,g=i.length;d<g;d++){var h=i[d];f.push(I(h))}Promise.all(f).then((function(){C(w(u)),l()})).catch((function(e){c(e)}))}))},getCurrentRepresentation:b,getCurrentRepresentationInfo:function(){return o},getRepresentationForQuality:w,prepareQualityChange:function(e){C(w(e)),R()},reset:function(){u.off(d.Z.MANIFEST_VALIDITY_CHANGED,D,t),A()}},A(),u.on(d.Z.MANIFEST_VALIDITY_CHANGED,D,t),t}V.__dashjs_factory_name="RepresentationController";var K=c.Z.getClassFactory(V),z=n(3106),W=n(9326),X=n(7473),Q=n(2594);function J(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var $=function e(){J(this,e),this.start=null,this.mstart=null,this.starttype=null,this.trace=[]};$.INITIAL_PLAYOUT_START_REASON="initial_playout",$.SEEK_START_REASON="seek",$.RESUME_FROM_PAUSE_START_REASON="resume",$.METRICS_COLLECTION_START_REASON="metrics_collection_start";var ee=function e(){J(this,e),this.representationid=null,this.subreplevel=null,this.start=null,this.mstart=null,this.duration=null,this.playbackspeed=null,this.stopreason=null};ee.REPRESENTATION_SWITCH_STOP_REASON="representation_switch",ee.REBUFFERING_REASON="rebuffering",ee.USER_REQUEST_STOP_REASON="user_request",ee.END_OF_PERIOD_STOP_REASON="end_of_period",ee.END_OF_CONTENT_STOP_REASON="end_of_content",ee.METRICS_COLLECTION_STOP_REASON="metrics_collection_end",ee.FAILURE_STOP_REASON="failure";var te=n(7802);function ne(){return{ntpToUTC:function(e){var t=new Date(Date.UTC(1900,0,1,0,0,0));return new Date(t.getTime()+e).getTime()}}}ne.__dashjs_factory_name="TimeUtils";var re=c.Z.getSingletonFactory(ne);function ie(e){e=e||{};var t,n,r,i,c,g,h,p,m,y,E,v,_,b,A,I=this.context,R=(0,u.Z)(I).getInstance(),N=e.streamInfo,D=e.type,O=e.errHandler,M=e.mimeType,P=e.timelineConverter,L=e.adapter,x=e.manifestModel,F=e.mediaPlayerModel,k=e.fragmentModel,U=e.abrController,B=e.playbackController,G=e.mediaController,Y=e.textController,H=e.dashMetrics,V=e.settings,J=e.boxParser,$=e.segmentBlacklistController;function ne(){return N.id}function ie(){return D}function ae(){return L.getIsTextTrack(p.getData())}function oe(){c=[],i=null,b=0,m=!1,y=!1,E=!1,A=null}function se(e){return!isNaN(e)&&!isNaN(N.duration)&&isFinite(N.duration)&&e>=N.start+N.duration}function ue(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(e.sender)if(B.getIsManifestUpdateInProgress())ge();else if((!ae()||Y.isTextEnabled())&&g&&e.representationId&&!g.appendInitSegmentFromCache(e.representationId)){var n=p.getCurrentRepresentation();if(0===n.range)return void le();var r=v?v.getInitRequest(i,n):null;r?k.executeRequest(r):t&&(h.setInitSegmentRequired(!0),ge())}}function le(e){var t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];if(B.getIsManifestUpdateInProgress()||g.getIsPruningInProgress())ge();else{var n=de();n?(m=!1,y=!1,ce(n)):fe(t)}}function ce(e){isNaN(e.startTime+e.duration)||(b=e.startTime+e.duration),e.delayLoadingTime=(new Date).getTime()+h.getTimeToLoadDelay(),h.setTimeToLoadDelay(0),function(e){var t=e.url;return e.range&&(t=t.concat("_",e.range)),$.contains(t)}(e)?(n.warn("Fragment request url ".concat(e.url," for stream id ").concat(N.id," and media type ").concat(D," is on the ignore list and will be skipped")),ge()):(n.debug("Next fragment request url for stream id ".concat(N.id," and media type ").concat(D," is ").concat(e.url)),k.executeRequest(e))}function fe(e){var t,a=p.getCurrentRepresentation();if(!V.get().streaming.gaps.enableSeekFix||!m&&0!==B.getTime()||(r?r&&a.segmentInfoType===o.Z.SEGMENT_TIMELINE&&(t=v.getValidTimeAheadOfTargetTime(b,i,a,V.get().streaming.gaps.threshold)):t=v.getValidTimeAheadOfTargetTime(b,i,a,V.get().streaming.gaps.threshold),isNaN(t)||t===b)){if(v.isLastSegmentRequested(a,b)){var s=v.getCurrentIndex();return n.debug("Segment requesting for stream ".concat(N.id," has finished")),R.trigger(l.Z.STREAM_REQUESTING_COMPLETED,{segmentIndex:s},{streamId:N.id,mediaType:D}),g.segmentRequestingCompleted(s),void h.clearScheduleTimer()}e&&ge()}else B.isSeeking()||0===B.getTime()?(n.warn("Adjusting playback time ".concat(t," because of gap in the manifest. Seeking by ").concat(t-b)),B.seek(t,!1,!1)):(n.warn("Adjusting buffering time ".concat(t," because of gap in the manifest. Adjusting time by ").concat(t-b)),xe(t),e&&ge())}function de(){var e,t=Ne();if(isNaN(b)||ie()===a.Z.TEXT&&!Y.isTextEnabled())return null;if(v){var n=p&&t?p.getRepresentationForQuality(t.quality):null;e=m?v.getSegmentRequestForTime(i,n,b):y?v.repeatSegmentRequest(i,n):v.getNextSegmentRequest(i,n)}return e}function ge(){h.startScheduleTimer(B.getLowLatencyModeEnabled()?V.get().streaming.scheduling.lowLatencyTimeout:V.get().streaming.scheduling.defaultTimeout)}function he(e){e.error||g.getIsBufferingCompleted()||g.updateBufferTimestampOffset(e.currentRepresentation)}function pe(e){H.addBufferState(D,e.state,h.getBufferTarget()),e.state!==s.Z.BUFFER_EMPTY||B.isSeeking()||(n.info("Buffer is empty! Stalling!"),H.pushPlayListTraceMetrics(new Date,ee.REBUFFERING_REASON))}function me(e){k.syncExecutedRequestsWithBufferedRange(g.getBuffer().getAllBufferRanges(),N.duration),e.quotaExceeded&&e.from>B.getTime()&&xe(e.from),e.hasEnoughSpaceToAppend&&e.quotaExceeded&&h.startScheduleTimer()}function ye(e){if(e&&e.lastRequestAppended&&e.lastRequestAppended.url){var t=e.lastRequestAppended.url;e.lastRequestAppended.range&&(t=t.concat("_",e.lastRequestAppended.range)),n.warn("Blacklisting segment with url ".concat(t)),$.add(t)}}function Ee(e){if(n.debug("Appended bytes for ".concat(e.mediaType," and stream id ").concat(e.streamId)),e.segmentType===C.w.INIT_SEGMENT_TYPE){var t=e.quality;h.setLastInitializedQuality(t),n.info("["+D+"] lastInitializedRepresentationInfo changed to "+e.quality)}A?ve(A):h.startScheduleTimer(0)}function ve(e){var t=k.getRequests({state:T.FRAGMENT_MODEL_LOADING});if(t&&t.length>0)return n.debug("Preparing for default quality switch: Waiting for ongoing segment request to be finished before applying switch."),void(A=e);g.updateBufferTimestampOffset(e).then((function(){h.setCheckPlaybackQuality(!1),i.segmentAlignment||i.subSegmentAlignment?h.startScheduleTimer():Pe(),A=null,E=!1})).catch((function(){A=null,E=!1}))}function _e(e){n.info("onFragmentLoadingAbandoned request: "+e.request.url+" has been aborted"),B.isSeeking()||h.getSwitchTrack()||E||(n.info("onFragmentLoadingAbandoned request: "+e.request.url+" has to be downloaded again, origin is not seeking process or switch track call"),e.request&&e.request.isInitializationRequest()?h.setInitSegmentRequired(!0):xe(e.request.startTime+e.request.duration/2),h.startScheduleTimer(0))}function Te(e){n.info("OnFragmentLoadingCompleted for stream id "+N.id+" and media type "+D+" - Url:",e.request?e.request.url:"undefined",e.request.range?", Range:"+e.request.range:""),ae()&&h.startScheduleTimer(0),e.error&&e.request.serviceLocation&&function(e){n.info("Fragment loading completed with an error"),e&&e.request&&e.request.type&&(e.request.type===C.w.INIT_SEGMENT_TYPE?ue({representationId:e.request.representationId,sender:{}},!1):e.request.type===C.w.MEDIA_SEGMENT_TYPE&&(xe(e.request.startTime+e.request.duration/2),le({},!1)))}(e)}function Se(){xe(B.getTime()),we().startScheduleTimer()}function be(e){var t=e.currentTrackInfo;if(t){var n=c.find((function(e){return e.index===t.index&&e.lang===t.lang}));n&&Re(n).then((function(){g.setIsBufferingCompleted(!1),xe(B.getTime()),h.setInitSegmentRequired(!0),h.startScheduleTimer()}))}}function Ae(e){xe(e.quotaExceededTime),h.clearScheduleTimer()}function Ie(){return g?g.getBuffer():null}function Re(e){e===i||e&&i&&e.type!==i.type||(i=e);var t=L.getRealAdaptation(N,i),n=L.getVoRepresentations(i);if(p){var o,s=p.getData(),u=U.getMaxAllowedIndexFor(D,N.id),l=U.getMinAllowedIndexFor(D,N.id),c=null;return null!==s&&s.id===t.id||D===a.Z.TEXT?o=U.getQualityFor(D,N.id):(c=U.getThroughputHistory().getAverageThroughput(D,r)||U.getInitialBitrateFor(D,N.id),o=U.getQualityForBitrate(i,c,N.id)),void 0!==l&&o<l&&(o=l),o>u&&(o=u),p.updateData(t,n,D,i.isFragmented,o)}return Promise.resolve()}function we(){return h}function Ne(e){var t;return void 0!==e?((0,z.SE)(e),t=p?p.getRepresentationForQuality(e):null):t=p?p.getCurrentRepresentation():null,L.convertRepresentationToRepresentationInfo(t)}function Ce(){return!!g&&g.getIsBufferingCompleted()}function De(e){if(V.get().streaming.enableManifestTimescaleMismatchFix){var t=e.chunk,n=t.bytes,r=Ne(t.quality),i=p&&r?p.getRepresentationForQuality(r.quality):null;r&&i&&(i.timescale=J.getMediaTimescaleFromMoov(n))}}function Oe(e){var t=e.chunk,n=t.bytes,r=t.quality,i=Ne(r),a=p&&i?p.getRepresentationForQuality(i.quality):null;if(i&&a){var s;if(V.get().streaming.parseInbandPrft&&e.request.type===C.w.MEDIA_SEGMENT_TYPE){var u=function(e,t){var n=e.getBoxes("prft"),r=[];return n.forEach((function(e){r.push(function(e,t){var n="unknown";switch(e.flags){case 0:n=o.Z.PRODUCER_REFERENCE_TIME_TYPE.ENCODER;break;case 16:n=o.Z.PRODUCER_REFERENCE_TIME_TYPE.APPLICATION;break;case 24:n=o.Z.PRODUCER_REFERENCE_TIME_TYPE.CAPTURED}var r=1e3*e.ntp_timestamp_sec+e.ntp_timestamp_frac/Math.pow(2,32)*1e3;return{type:n,ntpTimestamp:r=re(I).getInstance().ntpToUTC(r),mediaTime:e.media_time/t}}(e,t))})),r}(s=s||J.parse(n),a.timescale);u&&u.length&&R.trigger(d.Z.INBAND_PRFT,{data:u},{streamId:N.id,mediaType:D})}var c=L.getEventsFor(i.mediaInfo,null,N),f=L.getEventsFor(i,a,N);if(c&&c.length>0||f&&f.length>0){var g=k.getRequests({state:T.FRAGMENT_MODEL_EXECUTED,quality:r,index:t.index})[0],h=function(e,t,n,r){try{for(var i={},a=[],o=n.concat(r),s=0,u=o.length;s<u;s++)i[o[s].schemeIdUri+"/"+o[s].value]=o[s];var l=e.getBoxes("emsg");if(!l||0===l.length)return a;for(var c=e.getBox("sidx"),f=!c||isNaN(c.earliest_presentation_time)||isNaN(c.timescale)?t&&!isNaN(t.mediaStartTime)?t.mediaStartTime:0:c.earliest_presentation_time/c.timescale,d=Math.max(f,0),g=p.getCurrentRepresentation(),h=0,m=l.length;h<m;h++){var y=L.getEvent(l[h],i,d,g);y&&a.push(y)}return a}catch(e){return[]}}(s=s||J.parse(n),g,c,f);R.trigger(l.Z.INBAND_EVENTS,{events:h},{streamId:N.id})}}}function Me(){var e=B.getTime();V.get().streaming.buffer.flushBufferAtTrackSwitch&&B.seek(e+.001,!1,!0),xe(e),g.setSeekTarget(e),h.startScheduleTimer()}function Pe(){var e=B.getTime(),t=g.getContinuousBufferTimeForTargetTime(e);xe(isNaN(t)?e:t),h.startScheduleTimer()}function Le(e){e&&!isNaN(e.time)&&(xe(e.time),g.setSeekTarget(e.time))}function xe(e){b=e,m=!0}return t={initialize:function(n,i,s){_=(0,te.Z)(I).create({events:l.Z,eventBus:R,streamInfo:N,timelineConverter:P,dashConstants:o.Z,segmentBaseController:e.segmentBaseController,type:D}),v=(0,W.Z)(I).create({streamInfo:N,type:D,timelineConverter:P,dashMetrics:H,mediaPlayerModel:F,baseURLController:e.baseURLController,errHandler:O,segmentsController:_,settings:V,boxParser:J,events:l.Z,eventBus:R,errors:w,debug:(0,f.Z)(I).getInstance(),requestModifier:(0,X.Z)(I).getInstance(),dashConstants:o.Z,constants:a.Z,urlUtils:(0,Q.Z)(I).getInstance()}),r=N.manifestInfo.isDynamic,v.initialize(r),U.registerStreamType(D,t),p=K(I).create({streamInfo:N,type:D,abrController:U,dashMetrics:H,playbackController:B,timelineConverter:P,dashConstants:o.Z,events:l.Z,eventBus:R,errors:w,isDynamic:r,adapter:L,segmentsController:_}),g=function(e,t){return e?e!==a.Z.TEXT||t?Z(I).create({streamInfo:N,type:e,mediaPlayerModel:F,manifestModel:x,fragmentModel:k,errHandler:O,mediaController:G,representationController:p,adapter:L,textController:Y,abrController:U,playbackController:B,settings:V}):q(I).create({streamInfo:N,type:e,mimeType:M,fragmentModel:k,textController:Y,errHandler:O,settings:V}):(O.error(new S.Z(w.MEDIASOURCE_TYPE_UNSUPPORTED_CODE,w.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE+"not properly defined")),null)}(D,s),g&&g.initialize(n),(h=j(I).create({streamInfo:N,type:D,mimeType:M,adapter:L,dashMetrics:H,mediaPlayerModel:F,fragmentModel:k,abrController:U,playbackController:B,textController:Y,mediaController:G,bufferController:g,representationController:p,settings:V})).initialize(i),b=0,m=!1,y=!1},getStreamId:ne,getType:ie,isUpdating:function(){return!!p&&p.isUpdating()},getBufferController:function(){return g},dischargePreBuffer:function(){g.dischargePreBuffer()},getFragmentModel:function(){return k},getScheduleController:we,getRepresentationController:function(){return p},getRepresentationInfo:Ne,getBufferLevel:function(){return g?g.getBufferLevel():0},isBufferingCompleted:Ce,createBufferSinks:function(e){var t=Ie();return t?Promise.resolve(t):g?g.createBufferSink(i,e):Promise.resolve(null)},updateStreamInfo:function(e){return N=e,Ce()?Promise.resolve():g.updateAppendWindow()},getStreamInfo:function(){return N},selectMediaInfo:Re,clearMediaInfoArray:function(){c=[]},addMediaInfo:function(e){-1===c.indexOf(e)&&c.push(e)},prepareTrackSwitch:function(){return new Promise((function(e){n.debug("Preparing track switch for type ".concat(D));var t=D===a.Z.TEXT||V.get().streaming.trackSwitchMode[D]===a.Z.TRACK_SWITCH_MODE_ALWAYS_REPLACE&&B.getTimeToStreamEnd(N)>V.get().streaming.buffer.stallThreshold;if(g.getIsBufferingCompleted()&&!t)return g.prepareForNonReplacementTrackSwitch(i.codec).then((function(){R.trigger(l.Z.BUFFERING_COMPLETED,{},{streamId:N.id,mediaType:D})})).catch((function(){R.trigger(l.Z.BUFFERING_COMPLETED,{},{streamId:N.id,mediaType:D})})),void e();h.clearScheduleTimer(),h.setSwitchTrack(!0),t?(R.trigger(l.Z.BUFFER_REPLACEMENT_STARTED,{mediaType:D,streamId:N.id},{mediaType:D,streamId:N.id}),k.abortRequests(),g.prepareForReplacementTrackSwitch(i.codec).then((function(){var e=Ne();return g.updateBufferTimestampOffset(e)})).then((function(){Me(),e()})).catch((function(){Me(),e()}))):g.prepareForNonReplacementTrackSwitch(i.codec).then((function(){Pe(),e()})).catch((function(){Pe(),e()}))}))},prepareQualityChange:function(e){A&&n.warning("Canceling queued representation switch to ".concat(A.quality," for ").concat(D)),n.debug("Preparing quality switch for type ".concat(D));var t=e.newQuality;E=!0,h.clearScheduleTimer(),p.prepareQualityChange(t);var r=Ne(t);e.reason&&e.reason.forceReplace?function(e){k.abortRequests(),R.trigger(l.Z.BUFFER_REPLACEMENT_STARTED,{mediaType:D,streamId:N.id},{mediaType:D,streamId:N.id}),h.setCheckPlaybackQuality(!1),g.prepareForForceReplacementQualitySwitch(e).then((function(){Me(),A=null,E=!1})).catch((function(){Me(),A=null,E=!1}))}(r):e&&e.reason&&e.reason.forceAbandon?function(e){g.updateBufferTimestampOffset(e).then((function(){k.abortRequests(),y=!0,h.setCheckPlaybackQuality(!1),h.startScheduleTimer(),E=!1,A=null})).catch((function(){A=null,E=!1}))}(r):V.get().streaming.buffer.fastSwitchEnabled?function(e){var t=B.getTime(),n=1.5*(isNaN(e.fragmentDuration)?1:e.fragmentDuration),r=k.getRequests({state:T.FRAGMENT_MODEL_EXECUTED,time:t+n,threshold:0})[0];if(r&&!ae()){var i=g.getBufferLevel(),a=U.getAbandonmentStateFor(N.id,D);r.quality<e.quality&&i>=n&&a!==s.Z.ABANDON_LOAD?g.updateBufferTimestampOffset(e).then((function(){k.abortRequests(),xe(t+n),h.setCheckPlaybackQuality(!1),h.startScheduleTimer(),E=!1})).catch((function(){E=!1})):ve(e)}else ve(e)}(r):ve(r),H.pushPlayListTraceMetrics(new Date,ee.REPRESENTATION_SWITCH_STOP_REASON),H.createPlaylistTraceMetrics(r.id,1e3*B.getTime(),B.getPlaybackRate())},getMediaInfo:function(){return i},getMediaSource:function(){return g.getMediaSource()},setMediaSource:function(e){return g.setMediaSource(e,i)},getBuffer:Ie,setExplicitBufferingTime:xe,finalisePlayList:function(e,t){H.pushPlayListTraceMetrics(e,t)},probeNextRequest:function(){var e=Ne(),t=p&&e?p.getRepresentationForQuality(e.quality):null;return v.getNextSegmentRequestIdempotent(i,t)},prepareInnerPeriodPlaybackSeeking:function(e){return new Promise((function(t){if(g.hasBufferAtTime(e.seekTime))return g.pruneBuffer(),se(g.getContinuousBufferTimeForTargetTime(e.seekTime))&&g.setIsBufferingCompleted(!0),void t();h.clearScheduleTimer(),k.abortRequests(),g.prepareForPlaybackSeek().then((function(){var t=g.getAllRangesWithSafetyFactor(e.seekTime);return g.clearBuffers(t)})).then((function(){var n=g.getContinuousBufferTimeForTargetTime(e.seekTime);if(se(n))g.setIsBufferingCompleted(!0),t();else{var r=isNaN(n)?e.seekTime:n;xe(r),g.setSeekTarget(r);var i=[];i.push(g.updateAppendWindow());var a=Ne();i.push(g.updateBufferTimestampOffset(a)),Promise.all(i).then((function(){h.setInitSegmentRequired(!0),h.setCheckPlaybackQuality(!1),h.startScheduleTimer(),t()}))}})).catch((function(e){n.error(e)}))}))},prepareOuterPeriodPlaybackSeeking:function(){return new Promise((function(e,t){try{h.clearScheduleTimer(),k.abortRequests(),g.prepareForPlaybackSeek().then((function(){return g.pruneAllSafely()})).then((function(){e()}))}catch(e){t(e)}}))},reset:function(e,n){v&&v.reset(),g&&(g.reset(e,n),g=null),h&&(h.reset(),h=null),p&&(p.reset(),p=null),_&&(_=null),U&&U.unRegisterStreamType(ne(),D),R.off(l.Z.DATA_UPDATE_COMPLETED,he,t),R.off(l.Z.INIT_FRAGMENT_NEEDED,ue,t),R.off(l.Z.MEDIA_FRAGMENT_NEEDED,le,t),R.off(l.Z.INIT_FRAGMENT_LOADED,De,t),R.off(l.Z.MEDIA_FRAGMENT_LOADED,Oe,t),R.off(l.Z.BUFFER_LEVEL_STATE_CHANGED,pe,t),R.off(l.Z.BUFFER_CLEARED,me,t),R.off(l.Z.SEEK_TARGET,Le,t),R.off(l.Z.FRAGMENT_LOADING_ABANDONED,_e,t),R.off(l.Z.FRAGMENT_LOADING_COMPLETED,Te,t),R.off(l.Z.SET_FRAGMENTED_TEXT_AFTER_DISABLED,Se,t),R.off(l.Z.SET_NON_FRAGMENTED_TEXT,be,t),R.off(l.Z.QUOTA_EXCEEDED,Ae,t),R.off(l.Z.SOURCE_BUFFER_ERROR,ye,t),R.off(l.Z.BYTES_APPENDED_END_FRAGMENT,Ee,t),oe(),D=null,N=null}},n=(0,f.Z)(I).getInstance().getLogger(t),oe(),R.on(l.Z.DATA_UPDATE_COMPLETED,he,t,{priority:u.Z.EVENT_PRIORITY_HIGH}),R.on(l.Z.INIT_FRAGMENT_NEEDED,ue,t),R.on(l.Z.MEDIA_FRAGMENT_NEEDED,le,t),R.on(l.Z.INIT_FRAGMENT_LOADED,De,t),R.on(l.Z.MEDIA_FRAGMENT_LOADED,Oe,t),R.on(l.Z.BUFFER_LEVEL_STATE_CHANGED,pe,t),R.on(l.Z.BUFFER_CLEARED,me,t),R.on(l.Z.SEEK_TARGET,Le,t),R.on(l.Z.FRAGMENT_LOADING_ABANDONED,_e,t),R.on(l.Z.FRAGMENT_LOADING_COMPLETED,Te,t),R.on(l.Z.QUOTA_EXCEEDED,Ae,t),R.on(l.Z.SET_FRAGMENTED_TEXT_AFTER_DISABLED,Se,t),R.on(l.Z.SET_NON_FRAGMENTED_TEXT,be,t),R.on(l.Z.SOURCE_BUFFER_ERROR,ye,t),R.on(l.Z.BYTES_APPENDED_END_FRAGMENT,Ee,t),t}ie.__dashjs_factory_name="StreamProcessor";var ae=c.Z.getClassFactory(ie),oe=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.streamId=null,this.mediaInfo=null,this.segmentType=null,this.quality=NaN,this.index=NaN,this.bytes=null,this.start=NaN,this.end=NaN,this.duration=NaN,this.representationId=null,this.endFragment=null},se=n(9032);function ue(e,t){if(e){if("string"==typeof e)return le(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?le(e,t):void 0}}function le(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function ce(e){e=e||{};var t,n,r=this.context,i=e.requestModifier,o=e.lowLatencyThroughputModel,s=e.boxParser,u=(0,N.Z)(r).getInstance();function l(e){var t,r=new Date,l=e.request,d=new Headers;if(l.range&&d.append("Range","bytes="+l.range),e.headers)for(var g in e.headers){var h=e.headers[g];h&&d.append(g,h)}l.requestStartDate||(l.requestStartDate=r),i&&i.modifyRequestHeader&&i.modifyRequestHeader({setRequestHeader:function(e,t){d.append(e,t)}},{url:e.url}),"function"==typeof window.AbortController&&(t=new AbortController,e.abortController=t,t.signal.onabort=e.onabort);var p={method:e.method,headers:d,credentials:e.withCredentials?"include":void 0,signal:t?t.signal:void 0},m=u.get().streaming.abr.fetchThroughputCalculationMode,y=Date.now(),E=0;new Promise((function(e){if(m===a.Z.ABR_FETCH_THROUGHPUT_CALCULATION_AAST&&o&&(E=o.getThroughputCapacityDelayMS(l,1e3*n.getCurrentBufferLevel(l.mediaType))))return setTimeout(e,E);e()})).then((function(){var t=Date.now();fetch(e.url,p).then((function(r){e.response||(e.response={}),e.response.status=r.status,e.response.statusText=r.statusText,e.response.responseURL=r.url,r.ok||e.onerror();var i,u="",d=function(e,t){var n;if("undefined"==typeof Symbol||null==e[Symbol.iterator]){if(Array.isArray(e)||(n=ue(e))){n&&(e=n);var r=0,i=function(){};return{s:i,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var a,o=!0,s=!1;return{s:function(){n=e[Symbol.iterator]()},n:function(){var e=n.next();return o=e.done,e},e:function(e){s=!0,a=e},f:function(){try{o||null==n.return||n.return()}finally{if(s)throw a}}}}(r.headers.keys());try{for(d.s();!(i=d.n()).done;){var g=i.value;u+=g+": "+r.headers.get(g)+"\\r\\n"}}catch(e){d.e(e)}finally{d.f()}if(e.response.responseHeaders=u,!r.body)return r.arrayBuffer().then((function(t){e.response.response=t;var n={loaded:t.byteLength,total:t.byteLength,stream:!1};e.progress(n),e.onload(),e.onend()}));var h,p,v,_,T=parseInt(r.headers.get("Content-Length"),10),S=0,b=!1,A=new Uint8Array,I=0;if(m===a.Z.ABR_FETCH_THROUGHPUT_CALCULATION_AAST&&o){var R=t,w=0,N=(v=r.body.tee(),_=2,function(e){if(Array.isArray(e))return e}(v)||function(e,t){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e)){var n=[],r=!0,i=!1,a=void 0;try{for(var o,s=e[Symbol.iterator]();!(r=(o=s.next()).done)&&(n.push(o.value),!t||n.length!==t);r=!0);}catch(e){i=!0,a=e}finally{try{r||null==s.return||s.return()}finally{if(i)throw a}}return n}}(v,_)||ue(v,_)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()),C=N[0],D=N[1];h=C.getReader(),p=[],h.read().then((function r(i){var a=i.value,s=i.done;if(w=Date.now(),a&&a.length){var c=w-R,f=a.length;p.push({chunkDownloadTimeRelativeMS:w-t,chunkDownloadDurationMS:c,chunkBytes:f,kbps:Math.round(8*f/(c/1e3)),bufferLevel:n.getCurrentBufferLevel(l.mediaType)})}if(s){var d=w-t,g=p.reduce((function(e,t){return e+t.chunkBytes}),0);return o.addMeasurement(l,d,p,y,E,u),void e.progress({loaded:g,total:g,lengthComputable:!0,time:o.getEstimatedDownloadDurationMS(l),stream:!0})}return R=Date.now(),h.read().then(r)})),e.reader=D.getReader()}else e.reader=r.body.getReader();var O=[],M=[],P=[],L=!0;c(e,(function t(n){var r=n.value;if(n.done){if(A){if(m!==a.Z.ABR_FETCH_THROUGHPUT_CALCULATION_AAST){var i=null,o=null;m===a.Z.ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING?(i=function(e,t){try{var n,r;n=e.filter((function(t,n){return n<e.length-1})),r=t.filter((function(e,n){return n<t.length-1}));var i=[];if(n.length>1){for(var a=0,o=0,s=0;s<n.length;s++)if(n[s]&&r[s]){var u=r[s].ts-n[s].ts;if(u>1)i.push(8*r[s].bytes/u),o=0;else{0===o&&(o=n[s].ts,a=0);var l=r[s].ts-o;l>1?(a+=r[s].bytes,i.push(8*a/l),o=0):a+=r[s].bytes}}if(i.length>0)return i.reduce((function(e,t){return e+t}),0)/i.length}return null}catch(e){return null}}(M,P),i&&(o=8*S/i)):m===a.Z.ABR_FETCH_THROUGHPUT_CALCULATION_DOWNLOADED_DATA&&(o=f(O,S)),e.progress({loaded:S,total:isNaN(T)?S:T,lengthComputable:!0,time:o,stream:!0})}e.response.response=A.buffer}return e.onload(),void e.onend()}if(r&&r.length>0){A=function(e,t){if(0===e.length)return t;var n=new Uint8Array(e.length+t.length);return n.set(e),n.set(t,e.length),n}(A,r),S+=r.length,O.push({ts:Date.now(),bytes:r.length}),m===a.Z.ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING&&L&&s.findLastTopIsoBoxCompleted(["moof"],A,I).found&&(L=!1,M.push({ts:performance.now(),bytes:r.length}));var u=s.findLastTopIsoBoxCompleted(["moov","mdat"],A,I);if(u.found){var l,d=u.lastCompletedOffset+u.size;m!==a.Z.ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING||L||(L=!0,P.push({ts:performance.now(),bytes:A.length})),d===A.length?(l=A,A=new Uint8Array):(l=new Uint8Array(A.subarray(0,d)),A=A.subarray(d)),e.progress({data:l.buffer,lengthComputable:!1,noTrace:!0}),I=0}else I=u.lastCompletedOffset,b||(e.progress({lengthComputable:!1,noTrace:!0}),b=!0)}c(e,t)}))})).catch((function(t){e.onerror&&e.onerror(t)}))}))}function c(e,t){e.reader.read().then(t).catch((function(t){e.onerror&&200===e.response.status&&e.onerror(t)}))}function f(e,t){try{if((e=e.filter((function(n){return n.bytes>t/4/e.length}))).length>1){var n=0,r=(e[e.length-1].ts-e[0].ts)/e.length;return e.forEach((function(t,i){var a=e[i+1];if(a){var o=a.ts-t.ts;n+=o<r?o:0}})),n}return null}catch(e){return null}}return t={load:function(e){i&&i.modifyRequest?(0,X.k)(e,i).then((function(){return l(e)})):l(e)},abort:function(e){if(e.abortController)e.abortController.abort();else if(e.reader)try{e.reader.cancel(),e.onabort()}catch(e){}},calculateDownloadedTime:f,setup:function(e){n=e.dashMetrics}},t}ce.__dashjs_factory_name="FetchLoader";var fe=c.Z.getClassFactory(ce),de=n(1180);function ge(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var he=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.id=null,this.index=-1,this.adaptation=null,this.segmentInfoType=null,this.initialization=null,this.codecs=null,this.mimeType=null,this.codecPrivateData=null,this.segmentDuration=NaN,this.timescale=1,this.startNumber=1,this.indexRange=null,this.range=null,this.presentationTimeOffset=0,this.MSETimeOffset=NaN,this.mediaFinishedInformation={numberOfSegments:0,mediaTimeOfLastSignaledSegment:NaN},this.bandwidth=NaN,this.width=NaN,this.height=NaN,this.scanType=null,this.maxPlayoutRate=NaN,this.availabilityTimeOffset=0,this.availabilityTimeComplete=!0,this.frameRate=null}var t,n;return t=e,(n=[{key:"hasInitialization",value:function(){return null!==this.initialization||null!==this.range}},{key:"hasSegments",value:function(){return this.segmentInfoType!==o.Z.BASE_URL&&this.segmentInfoType!==o.Z.SEGMENT_BASE&&!this.indexRange}}])&&ge(t.prototype,n),e}(),pe=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.period=null,this.index=-1,this.type=null},me=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.id=null,this.index=-1,this.duration=NaN,this.start=NaN,this.mpd=null,this.nextPeriodId=null};me.DEFAULT_ID="defaultId";var ye=me,Ee=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.manifest=null,this.suggestedPresentationDelay=0,this.availabilityStartTime=null,this.availabilityEndTime=Number.POSITIVE_INFINITY,this.timeShiftBufferDepth=Number.POSITIVE_INFINITY,this.maxSegmentDuration=Number.POSITIVE_INFINITY,this.publishTime=null,this.minimumUpdatePeriod=NaN,this.mediaPresentationDuration=NaN},ve=n(2610),_e=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.type="",this.duration=NaN,this.presentationTime=NaN,this.id=NaN,this.messageData="",this.eventStream=null,this.presentationTimeDelta=NaN},Te=function e(t,n,r,i){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.url=t||"",this.serviceLocation=n||t||"",this.dvb_priority=r||1,this.dvb_weight=i||1,this.availabilityTimeOffset=0,this.availabilityTimeComplete=!0,this.queryParams={}};Te.DEFAULT_DVB_PRIORITY=1,Te.DEFAULT_DVB_WEIGHT=1;var Se=Te,be=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.adaptionSet=null,this.representation=null,this.period=null,this.timescale=1,this.value="",this.schemeIdUri="",this.presentationTimeOffset=0},Ae=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.id=null,this.inband=!1,this.type="encoder",this.applicationScheme=null,this.wallClockTime=null,this.presentationTime=NaN,this.UTCTiming=null},Ie=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.defaultServiceLocation=null,this.defaultServiceLocationArray=[],this.queryBeforeStart=!1,this.serverUrl=null,this.clientRequirement=!0};function Re(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var we=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.schemeIdUri=null,this.value=null,this.id=null}var t,n;return t=e,(n=[{key:"init",value:function(e){return e&&(this.schemeIdUri=e.schemeIdUri?e.schemeIdUri:null,this.value=e.value?e.value:null,this.id=e.id?e.id:null),this}}])&&Re(t.prototype,n),e}(),Ne=n(3101),Ce=n.n(Ne);function De(){return{areEqual:function(e,t){return Ce()(e,t)}}}De.__dashjs_factory_name="ObjectUtils";var Oe=c.Z.getSingletonFactory(De),Me=n(7803),Pe=function e(t,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.url=t||"",this.serviceLocation=n||null,this.queryParams={}},Le=function e(t,n,r){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.url=t||"",this.serviceLocation=n||null,this.ttl=r||NaN,this.queryParams={}};function xe(e,t){var n;if("undefined"==typeof Symbol||null==e[Symbol.iterator]){if(Array.isArray(e)||(n=Fe(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,i=function(){};return{s:i,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var a,o=!0,s=!1;return{s:function(){n=e[Symbol.iterator]()},n:function(){var e=n.next();return o=e.done,e},e:function(e){s=!0,a=e},f:function(){try{o||null==n.return||n.return()}finally{if(s)throw a}}}}function Fe(e,t){if(e){if("string"==typeof e)return ke(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?ke(e,t):void 0}}function ke(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function Ue(){var e,t,n,r,i=this.context,s=(0,Q.Z)(i).getInstance(),u=Number.isInteger||function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e};function l(e,t){if(!e)throw new Error("adaptation is not defined");if(!t)throw new Error("type is not defined");if(e.Representation_asArray&&e.Representation_asArray.length){var n=v(e.Representation_asArray[0]);if(n&&n.length>0&&Me.Y.indexOf(n[0].schemeIdUri)>=0)return t===a.Z.IMAGE}if(e.ContentComponent_asArray&&e.ContentComponent_asArray.length>0){if(e.ContentComponent_asArray.length>1)return t===a.Z.MUXED;if(e.ContentComponent_asArray[0].contentType===t)return!0}var r=t===a.Z.TEXT?new RegExp("(ttml|vtt|wvtt|stpp)"):new RegExp(t);if(e.Representation_asArray&&e.Representation_asArray.length){var i=e.Representation_asArray[0].codecs;if(r.test(i))return!0}if(e.hasOwnProperty(o.Z.MIME_TYPE))return r.test(e.mimeType);if(e.Representation_asArray)for(var s,u=0;u<e.Representation_asArray.length;u++)if((s=e.Representation_asArray[u]).hasOwnProperty(o.Z.MIME_TYPE))return r.test(s.mimeType);return!1}function c(e){if(!e)throw new Error("adaptation is not defined");if(e.hasOwnProperty(o.Z.SEGMENT_TEMPLATE)||e.hasOwnProperty(o.Z.SEGMENT_TIMELINE)||e.hasOwnProperty(o.Z.SEGMENT_LIST)||e.hasOwnProperty(o.Z.SEGMENT_BASE))return!0;if(e.Representation_asArray&&e.Representation_asArray.length>0){var t=e.Representation_asArray[0];if(t.hasOwnProperty(o.Z.SEGMENT_TEMPLATE)||t.hasOwnProperty(o.Z.SEGMENT_TIMELINE)||t.hasOwnProperty(o.Z.SEGMENT_LIST)||t.hasOwnProperty(o.Z.SEGMENT_BASE))return!0}return!1}function d(e){return l(e,a.Z.VIDEO)}function g(e){return l(e,a.Z.TEXT)}function h(e){return l(e,a.Z.IMAGE)}function p(e){return e&&Array.isArray(e.Representation_asArray)&&e.Representation_asArray.sort((function(e,t){return e.bandwidth-t.bandwidth})),e}function m(e,t){return e&&e.Period_asArray&&u(t)&&e.Period_asArray[t]?e.Period_asArray[t].AdaptationSet_asArray:[]}function y(e){return e&&e.Period_asArray?e.Period_asArray:[]}function E(e){var t=!1;return e&&e.hasOwnProperty("type")&&(t=e.type===o.Z.DYNAMIC),t}function v(e){return e&&e.EssentialProperty_asArray&&e.EssentialProperty_asArray.length?e.EssentialProperty_asArray.map((function(e){return{schemeIdUri:e.schemeIdUri,value:e.value}})):null}function _(e){if(!e||!e.S_asArray)return NaN;var t=e.S_asArray[0],n=e.S_asArray[1];return t.hasOwnProperty("d")?t.d:n.t-t.t}function T(e,t){if(!e)throw new Error("Period cannot be null or undefined");var n=ye.DEFAULT_ID+"_"+t;return e.hasOwnProperty(o.Z.ID)&&e.id.length>0&&"__proto__"!==e.id&&(n=e.id),n}function b(e,t,n){var r,i=[];if(!e)return i;for(r=0;r<e.length;r++){var s=new be;if(s.timescale=1,s.representation=t,!e[r].hasOwnProperty(a.Z.SCHEME_ID_URI))throw new Error("Invalid EventStream. SchemeIdUri has to be set");s.schemeIdUri=e[r].schemeIdUri,e[r].hasOwnProperty(o.Z.TIMESCALE)&&(s.timescale=e[r].timescale),e[r].hasOwnProperty(o.Z.VALUE)&&(s.value=e[r].value),i.push(s),s.period=n}return i}function A(e){var t=[],n=e.BaseURL_asArray||[e.baseUri],r=!1;return n.some((function(n){if(n){var i=new Se,a=n.__text||n;return s.isRelative(a)&&(r=!0,e.baseUri&&(a=s.resolve(a,e.baseUri))),i.url=a,n.hasOwnProperty(o.Z.SERVICE_LOCATION)&&n.serviceLocation.length?i.serviceLocation=n.serviceLocation:i.serviceLocation=a,n.hasOwnProperty(o.Z.DVB_PRIORITY)&&(i.dvb_priority=n[o.Z.DVB_PRIORITY]),n.hasOwnProperty(o.Z.DVB_WEIGHT)&&(i.dvb_weight=n[o.Z.DVB_WEIGHT]),n.hasOwnProperty(o.Z.AVAILABILITY_TIME_OFFSET)&&(i.availabilityTimeOffset=n[o.Z.AVAILABILITY_TIME_OFFSET]),n.hasOwnProperty(o.Z.AVAILABILITY_TIME_COMPLETE)&&(i.availabilityTimeComplete="false"!==n[o.Z.AVAILABILITY_TIME_COMPLETE]),t.push(i),r}})),t}function I(e){var t=new Ie;return t.serverUrl=e.__text,e.hasOwnProperty(o.Z.DEFAULT_SERVICE_LOCATION)&&(t.defaultServiceLocation=e[o.Z.DEFAULT_SERVICE_LOCATION],t.defaultServiceLocationArray=t.defaultServiceLocation.split(" ")),e.hasOwnProperty(o.Z.QUERY_BEFORE_START)&&(t.queryBeforeStart="true"===e[o.Z.QUERY_BEFORE_START].toLowerCase()),e.hasOwnProperty(o.Z.CLIENT_REQUIREMENT)&&(t.clientRequirement="false"!==e[o.Z.CLIENT_REQUIREMENT].toLowerCase()),t}return e={getIsTypeOf:l,getIsText:g,getIsFragmented:c,getProducerReferenceTimesForAdaptation:function(e){var t=e&&e.hasOwnProperty(o.Z.PRODUCERREFERENCETIME_ASARRAY)?e[o.Z.PRODUCERREFERENCETIME_ASARRAY]:[];(e&&e.hasOwnProperty(o.Z.REPRESENTATION_ASARRAY)?e[o.Z.REPRESENTATION_ASARRAY]:[]).forEach((function(e){var n;e.hasOwnProperty(o.Z.PRODUCERREFERENCETIME_ASARRAY)&&t.push.apply(t,function(e){if(Array.isArray(e))return ke(e)}(n=e[o.Z.PRODUCERREFERENCETIME_ASARRAY])||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(n)||Fe(n)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}())}));var n=[];return t.forEach((function(e){var t=new Ae;e.hasOwnProperty(o.Z.ID)&&(t[o.Z.ID]=e[o.Z.ID],e.hasOwnProperty(o.Z.WALL_CLOCK_TIME)&&(t[o.Z.WALL_CLOCK_TIME]=e[o.Z.WALL_CLOCK_TIME],e.hasOwnProperty(o.Z.PRESENTATION_TIME)&&(t[o.Z.PRESENTATION_TIME]=e[o.Z.PRESENTATION_TIME],e.hasOwnProperty(o.Z.INBAND)&&(t[o.Z.INBAND]="false"!==e[o.Z.INBAND]),e.hasOwnProperty(o.Z.TYPE)&&(t[o.Z.TYPE]=e[o.Z.TYPE]),n.push(t))))})),n},getLanguageForAdaptation:function(e){var t="";return e&&e.hasOwnProperty(o.Z.LANG)&&(t=e.lang),t},getViewpointForAdaptation:function(e){return e&&e.hasOwnProperty(o.Z.VIEWPOINT_ASARRAY)&&e[o.Z.VIEWPOINT_ASARRAY].length?e[o.Z.VIEWPOINT_ASARRAY].map((function(e){return(new we).init(e)})):[]},getRolesForAdaptation:function(e){return e&&e.hasOwnProperty(o.Z.ROLE_ASARRAY)&&e[o.Z.ROLE_ASARRAY].length?e[o.Z.ROLE_ASARRAY].map((function(e){return(new we).init(e)})):[]},getAccessibilityForAdaptation:function(e){return e&&e.hasOwnProperty(o.Z.ACCESSIBILITY_ASARRAY)&&e[o.Z.ACCESSIBILITY_ASARRAY].length?e[o.Z.ACCESSIBILITY_ASARRAY].map((function(e){return(new we).init(e)})):[]},getAudioChannelConfigurationForAdaptation:function(e){return e&&e.hasOwnProperty(o.Z.AUDIOCHANNELCONFIGURATION_ASARRAY)&&e[o.Z.AUDIOCHANNELCONFIGURATION_ASARRAY].length?e[o.Z.AUDIOCHANNELCONFIGURATION_ASARRAY].map((function(e){return(new we).init(e)})):[]},getAudioChannelConfigurationForRepresentation:function(e){return e&&e.hasOwnProperty(o.Z.AUDIOCHANNELCONFIGURATION_ASARRAY)&&e[o.Z.AUDIOCHANNELCONFIGURATION_ASARRAY].length?e[o.Z.AUDIOCHANNELCONFIGURATION_ASARRAY].map((function(e){return(new we).init(e)})):[]},getAdaptationForIndex:function(e,t,n){var r=m(t,n);return r.length>0&&u(e)?r[e]:null},getIndexForAdaptation:function(e,t,n){if(!e)return-1;for(var r=m(t,n),a=0;a<r.length;a++)if(Oe(i).getInstance().areEqual(r[a],e))return a;return-1},getAdaptationForId:function(e,t,n){var r,i,a=m(t,n);for(r=0,i=a.length;r<i;r++)if(a[r].hasOwnProperty(o.Z.ID)&&a[r].id===e)return a[r];return null},getAdaptationsForType:function(e,t,n){var r,i,a=m(e,t),o=[];for(r=0,i=a.length;r<i;r++)l(a[r],n)&&o.push(p(a[r]));return o},getRealPeriods:y,getRealPeriodForIndex:function(e,t){var n=y(t);return n.length>0&&u(e)?n[e]:null},getCodec:function(e,t,n){var r=null;if(e&&e.Representation_asArray&&e.Representation_asArray.length>0){var i=u(t)&&t>=0&&t<e.Representation_asArray.length?e.Representation_asArray[t]:e.Representation_asArray[0];i&&(r=i.mimeType+\';codecs="\'+i.codecs+\'"\',n&&void 0!==i.width&&(r+=\';width="\'+i.width+\'";height="\'+i.height+\'"\'))}return r&&(r=r.replace(/\\sprofiles=[^;]*/g,"")),r},getSelectionPriority:function(e){try{var t=e&&void 0!==e.selectionPriority?parseInt(e.selectionPriority):1;return isNaN(t)?1:t}catch(e){return 1}},getMimeType:function(e){return e&&e.Representation_asArray&&e.Representation_asArray.length>0?e.Representation_asArray[0].mimeType:null},getKID:function(e){return e&&e.hasOwnProperty(o.Z.CENC_DEFAULT_KID)?e[o.Z.CENC_DEFAULT_KID]:null},getLabelsForAdaptation:function(e){if(!e||!Array.isArray(e.Label_asArray))return[];for(var t=[],n=0;n<e.Label_asArray.length;n++)t.push({lang:e.Label_asArray[n].lang,text:e.Label_asArray[n].__text||e.Label_asArray[n]});return t},getContentProtectionData:function(e){return e&&e.hasOwnProperty(o.Z.CONTENTPROTECTION_ASARRAY)&&0!==e.ContentProtection_asArray.length?e.ContentProtection_asArray:null},getIsDynamic:E,getId:function(e){return e&&e[o.Z.ID]||null},hasProfile:function(e,t){var n=!1;return e&&e.profiles&&e.profiles.length>0&&(n=-1!==e.profiles.indexOf(t)),n},getDuration:function(e){return e&&e.hasOwnProperty(o.Z.MEDIA_PRESENTATION_DURATION)?e.mediaPresentationDuration:e&&"dynamic"==e.type?Number.POSITIVE_INFINITY:Number.MAX_SAFE_INTEGER||Number.MAX_VALUE},getBandwidth:function(e){return e&&e.bandwidth?e.bandwidth:NaN},getManifestUpdatePeriod:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0,n=NaN;return e&&e.hasOwnProperty(o.Z.MINIMUM_UPDATE_PERIOD)&&(n=e.minimumUpdatePeriod),isNaN(n)?n:Math.max(n-t,1)},getPublishTime:function(e){return e&&e.hasOwnProperty(o.Z.PUBLISH_TIME)?new Date(e[o.Z.PUBLISH_TIME]):null},getRepresentationCount:function(e){return e&&Array.isArray(e.Representation_asArray)?e.Representation_asArray.length:0},getBitrateListForAdaptation:function(e){var t=p(e);return(t&&Array.isArray(t.Representation_asArray)?t.Representation_asArray:[]).map((function(e){return{bandwidth:e.bandwidth,width:e.width||0,height:e.height||0,scanType:e.scanType||null,id:e.id||null}}))},getRepresentationFor:function(e,t){return t&&t.Representation_asArray&&t.Representation_asArray.length>0&&u(e)?t.Representation_asArray[e]:null},getRepresentationsForAdaptation:function(e){var t,n,r,i,a=[],s=function(e){if(e&&e.period&&u(e.period.index)){var t=e.period.mpd.manifest.Period_asArray[e.period.index];if(t&&t.AdaptationSet_asArray&&u(e.index))return p(t.AdaptationSet_asArray[e.index])}}(e);if(s&&s.Representation_asArray){if(e&&e.period&&u(e.period.index)){var l=A(e.period.mpd.manifest);l&&(n=l[0])}for(var f=0,d=s.Representation_asArray.length;f<d;++f){var h=s.Representation_asArray[f],m=new he;if(m.index=f,m.adaptation=e,h.hasOwnProperty(o.Z.ID)&&(m.id=h.id),h.hasOwnProperty(o.Z.CODECS)&&(m.codecs=h.codecs),h.hasOwnProperty(o.Z.MIME_TYPE)&&(m.mimeType=h[o.Z.MIME_TYPE]),h.hasOwnProperty(o.Z.CODEC_PRIVATE_DATA)&&(m.codecPrivateData=h.codecPrivateData),h.hasOwnProperty(o.Z.BANDWITH)&&(m.bandwidth=h.bandwidth),h.hasOwnProperty(o.Z.WIDTH)&&(m.width=h.width),h.hasOwnProperty(o.Z.HEIGHT)&&(m.height=h.height),h.hasOwnProperty(o.Z.SCAN_TYPE)&&(m.scanType=h.scanType),h.hasOwnProperty(o.Z.MAX_PLAYOUT_RATE)&&(m.maxPlayoutRate=h.maxPlayoutRate),h.hasOwnProperty(o.Z.SEGMENT_BASE)?(t=h.SegmentBase,m.segmentInfoType=o.Z.SEGMENT_BASE):h.hasOwnProperty(o.Z.SEGMENT_LIST)?(t=h.SegmentList).hasOwnProperty(o.Z.SEGMENT_TIMELINE)?m.segmentInfoType=o.Z.SEGMENT_TIMELINE:m.segmentInfoType=o.Z.SEGMENT_LIST:h.hasOwnProperty(o.Z.SEGMENT_TEMPLATE)?((t=h.SegmentTemplate).hasOwnProperty(o.Z.SEGMENT_TIMELINE)?m.segmentInfoType=o.Z.SEGMENT_TIMELINE:m.segmentInfoType=o.Z.SEGMENT_TEMPLATE,t.hasOwnProperty(o.Z.INITIALIZATION_MINUS)&&(m.initialization=t.initialization.split("$Bandwidth$").join(h.bandwidth).split("$RepresentationID$").join(h.id))):m.segmentInfoType=o.Z.BASE_URL,m.essentialProperties=v(h),t){if(t.hasOwnProperty(o.Z.INITIALIZATION)){var y=t.Initialization;y.hasOwnProperty(o.Z.SOURCE_URL)&&(m.initialization=y.sourceURL),y.hasOwnProperty(o.Z.RANGE)&&(m.range=y.range)}else g(s)&&c(s)&&s.mimeType&&-1===s.mimeType.indexOf("application/mp4")&&(m.range=0);t.hasOwnProperty(o.Z.TIMESCALE)&&(m.timescale=t.timescale),t.hasOwnProperty(o.Z.DURATION)?m.segmentDuration=t.duration/m.timescale:h.hasOwnProperty(o.Z.SEGMENT_TEMPLATE)&&(t=h.SegmentTemplate).hasOwnProperty(o.Z.SEGMENT_TIMELINE)&&(m.segmentDuration=_(t.SegmentTimeline)/m.timescale),t.hasOwnProperty(o.Z.MEDIA)&&(m.media=t.media),t.hasOwnProperty(o.Z.START_NUMBER)&&(m.startNumber=t.startNumber),t.hasOwnProperty(o.Z.INDEX_RANGE)&&(m.indexRange=t.indexRange),t.hasOwnProperty(o.Z.PRESENTATION_TIME_OFFSET)&&(m.presentationTimeOffset=t.presentationTimeOffset/m.timescale),t.hasOwnProperty(o.Z.AVAILABILITY_TIME_OFFSET)?m.availabilityTimeOffset=t.availabilityTimeOffset:n&&void 0!==n.availabilityTimeOffset&&(m.availabilityTimeOffset=n.availabilityTimeOffset),t.hasOwnProperty(o.Z.AVAILABILITY_TIME_COMPLETE)?m.availabilityTimeComplete="false"!==t.availabilityTimeComplete:n&&void 0!==n.availabilityTimeComplete&&(m.availabilityTimeComplete=n.availabilityTimeComplete)}m.MSETimeOffset=(void 0,i=(r=m).presentationTimeOffset,r.adaptation.period.start-i),m.path=[e.period.index,e.index,f],a.push(m)}}return a},getAdaptationsForPeriod:function(e){var n,r,i,s=e&&u(e.index)?e.mpd.manifest.Period_asArray[e.index]:null,c=[];if(s&&s.AdaptationSet_asArray)for(i=0;i<s.AdaptationSet_asArray.length;i++)r=s.AdaptationSet_asArray[i],n=new pe,r.hasOwnProperty(o.Z.ID)&&(n.id=r.id),n.index=i,n.period=e,l(r,a.Z.MUXED)?n.type=a.Z.MUXED:l(r,a.Z.AUDIO)?n.type=a.Z.AUDIO:d(r)?n.type=a.Z.VIDEO:g(r)?n.type=a.Z.TEXT:h(r)?n.type=a.Z.IMAGE:t.warn("Unknown Adaptation stream type"),c.push(n);return c},getRegularPeriods:function(e){var r,i,s=!!e&&E(e.manifest),u=[],l=null,c=null,f=null,d=null;for(i=0,r=e&&e.manifest&&e.manifest.Period_asArray?e.manifest.Period_asArray.length:0;i<r;i++)(c=e.manifest.Period_asArray[i]).hasOwnProperty(o.Z.START)?(d=new ye).start=c.start:null!==l&&l.hasOwnProperty(o.Z.DURATION)&&null!==f?(d=new ye).start=parseFloat((f.start+f.duration).toFixed(5)):0!==i||s||((d=new ye).start=0),null!==f&&isNaN(f.duration)&&(null!==d?f.duration=parseFloat((d.start-f.start).toFixed(5)):t.warn("First period duration could not be calculated because lack of start and duration period properties. This will cause timing issues during playback")),null!==d&&(d.id=T(c,i),d.index=i,d.mpd=e,c.hasOwnProperty(o.Z.DURATION)&&(d.duration=c.duration),f&&(f.nextPeriodId=d.id),u.push(d),l=c,f=d),c=null,d=null;return 0===u.length||null!==f&&isNaN(f.duration)&&(f.duration=parseFloat((function(e){!function(){if(!n||!n.hasOwnProperty("error"))throw new Error(a.Z.MISSING_CONFIG_ERROR)}();var t,r=E(e.mpd.manifest);return e.mpd.manifest.mediaPresentationDuration?t=e.mpd.manifest.mediaPresentationDuration:e.duration?t=e.duration:r?t=Number.POSITIVE_INFINITY:n.error(new S.Z(w.MANIFEST_ERROR_ID_PARSE_CODE,"Must have @mediaPresentationDuration on MPD or an explicit @duration on the last period.",e)),t}(f)-f.start).toFixed(5))),u},getMpd:function(e){var t=new Ee;return e&&(t.manifest=e,e.hasOwnProperty(o.Z.AVAILABILITY_START_TIME)?t.availabilityStartTime=new Date(e.availabilityStartTime.getTime()):e.loadedTime&&(t.availabilityStartTime=new Date(e.loadedTime.getTime())),e.hasOwnProperty(o.Z.AVAILABILITY_END_TIME)&&(t.availabilityEndTime=new Date(e.availabilityEndTime.getTime())),e.hasOwnProperty(o.Z.MINIMUM_UPDATE_PERIOD)&&(t.minimumUpdatePeriod=e.minimumUpdatePeriod),e.hasOwnProperty(o.Z.MEDIA_PRESENTATION_DURATION)&&(t.mediaPresentationDuration=e.mediaPresentationDuration),e.hasOwnProperty(o.Z.SUGGESTED_PRESENTATION_DELAY)&&(t.suggestedPresentationDelay=e.suggestedPresentationDelay),e.hasOwnProperty(o.Z.TIMESHIFT_BUFFER_DEPTH)&&(t.timeShiftBufferDepth=e.timeShiftBufferDepth),e.hasOwnProperty(o.Z.MAX_SEGMENT_DURATION)&&(t.maxSegmentDuration=e.maxSegmentDuration),e.hasOwnProperty(o.Z.PUBLISH_TIME)&&(t.publishTime=new Date(e.publishTime))),t},getEventsForPeriod:function(e){var t,n,i=e&&e.mpd&&e.mpd.manifest?e.mpd.manifest:null,s=i?i.Period_asArray:null,l=s&&e&&u(e.index)?s[e.index].EventStream_asArray:null,c=[];if(l)for(t=0;t<l.length;t++){var f=new be;if(f.period=e,f.timescale=1,!l[t].hasOwnProperty(a.Z.SCHEME_ID_URI))throw new Error("Invalid EventStream. SchemeIdUri has to be set");for(f.schemeIdUri=l[t][a.Z.SCHEME_ID_URI],l[t].hasOwnProperty(o.Z.TIMESCALE)&&(f.timescale=l[t][o.Z.TIMESCALE]),l[t].hasOwnProperty(o.Z.VALUE)&&(f.value=l[t][o.Z.VALUE]),l[t].hasOwnProperty(o.Z.PRESENTATION_TIME_OFFSET)&&(f.presentationTimeOffset=l[t][o.Z.PRESENTATION_TIME_OFFSET]),n=0;l[t].Event_asArray&&n<l[t].Event_asArray.length;n++){var d=l[t].Event_asArray[n],g=new _e;g.presentationTime=0,g.eventStream=f,d.hasOwnProperty(o.Z.PRESENTATION_TIME)&&(g.presentationTime=d.presentationTime);var h=f.presentationTimeOffset?f.presentationTimeOffset/f.timescale:0;g.calculatedPresentationTime=g.presentationTime/f.timescale+e.start-h,d.hasOwnProperty(o.Z.DURATION)&&(g.duration=d.duration/f.timescale),d.hasOwnProperty(o.Z.ID)?g.id=d.id:g.id=null,d.Signal&&d.Signal.Binary?g.messageData=r.decodeArray(d.Signal.Binary.toString()):g.messageData=d.messageData||d.__cdata||d.__text,c.push(g)}}return c},getEssentialPropertiesForRepresentation:v,getEventStreamForAdaptationSet:function(e,t,n){var r,i,a;return e&&e.Period_asArray&&t&&t.period&&u(t.period.index)&&(i=e.Period_asArray[t.period.index])&&i.AdaptationSet_asArray&&u(t.index)&&(a=i.AdaptationSet_asArray[t.index])&&(r=a.InbandEventStream_asArray),b(r,null,n)},getEventStreamForRepresentation:function(e,t,n){var r,i,a,o;return e&&e.Period_asArray&&t&&t.adaptation&&t.adaptation.period&&u(t.adaptation.period.index)&&(i=e.Period_asArray[t.adaptation.period.index])&&i.AdaptationSet_asArray&&u(t.adaptation.index)&&(a=i.AdaptationSet_asArray[t.adaptation.index])&&a.Representation_asArray&&u(t.index)&&(o=a.Representation_asArray[t.index])&&(r=o.InbandEventStream_asArray),b(r,t,n)},getUTCTimingSources:function(e){var t=E(e),n=!!e&&e.hasOwnProperty(o.Z.AVAILABILITY_START_TIME),r=e?e.UTCTiming_asArray:null,i=[];return(t||n)&&r&&r.forEach((function(e){var t=new ve.Z;e.hasOwnProperty(a.Z.SCHEME_ID_URI)&&(t.schemeIdUri=e.schemeIdUri,e.hasOwnProperty(o.Z.VALUE)&&(t.value=e.value.toString(),i.push(t)))})),i},getBaseURLsFromElement:A,getRepresentationSortFunction:function(){return function(e,t){return e.bandwidth-t.bandwidth}},getContentSteering:function(e){if(e&&e.hasOwnProperty(o.Z.CONTENT_STEERING_AS_ARRAY))return I(e[o.Z.CONTENT_STEERING_AS_ARRAY][0])},getLocation:function(e){return e&&e.hasOwnProperty(o.Z.LOCATION_AS_ARRAY)?e[o.Z.LOCATION_AS_ARRAY].map((function(e){var t=e.__text||e,n=e.hasOwnProperty(o.Z.SERVICE_LOCATION)?e[o.Z.SERVICE_LOCATION]:null;return new Pe(t,n)})):[]},getPatchLocation:function(e){return e&&e.hasOwnProperty(o.Z.PATCH_LOCATION_AS_ARRAY)?e[o.Z.PATCH_LOCATION_AS_ARRAY].map((function(e){var t=e.__text||e,n=e.hasOwnProperty(o.Z.SERVICE_LOCATION)?e[o.Z.SERVICE_LOCATION]:null,r=e.hasOwnProperty(o.Z.TTL)?1e3*parseFloat(e[o.Z.TTL]):NaN;return new Le(t,n,r)})):[]},getSuggestedPresentationDelay:function(e){return e&&e.hasOwnProperty(o.Z.SUGGESTED_PRESENTATION_DELAY)?e.suggestedPresentationDelay:null},getAvailabilityStartTime:function(e){return e&&e.hasOwnProperty(o.Z.AVAILABILITY_START_TIME)&&null!==e.availabilityStartTime?e.availabilityStartTime.getTime():null},getServiceDescriptions:function(e){var t=[];if(e&&e.hasOwnProperty(o.Z.SERVICE_DESCRIPTION)){var n,r=xe(e.ServiceDescription_asArray);try{for(r.s();!(n=r.n()).done;){var i=n.value,a=null,s=null,u=null,l=null,c=null,f=null,d=null;for(var g in i)i.hasOwnProperty(g)&&(g===o.Z.ID?a=i[g]:g===o.Z.SERVICE_DESCRIPTION_SCOPE?s=i[g].schemeIdUri:g===o.Z.SERVICE_DESCRIPTION_LATENCY?u={target:parseInt(i[g].target),max:parseInt(i[g].max),min:parseInt(i[g].min),referenceId:parseInt(i[g].referenceId)}:g===o.Z.SERVICE_DESCRIPTION_PLAYBACK_RATE?l={max:parseFloat(i[g].max),min:parseFloat(i[g].min)}:g===o.Z.SERVICE_DESCRIPTION_OPERATING_QUALITY?c={mediaType:i[g].mediaType,max:parseInt(i[g].max),min:parseInt(i[g].min),target:parseInt(i[g].target),type:i[g].type,maxQualityDifference:parseInt(i[g].maxQualityDifference)}:g===o.Z.SERVICE_DESCRIPTION_OPERATING_BANDWIDTH?f={mediaType:i[g].mediaType,max:parseInt(i[g].max),min:parseInt(i[g].min),target:parseInt(i[g].target)}:g===o.Z.CONTENT_STEERING&&(d=I(i[g])));t.push({id:a,schemeIdUri:s,latency:u,playbackRate:l,operatingQuality:c,operatingBandwidth:f,contentSteering:d})}}catch(e){r.e(e)}finally{r.f()}}return t},getSegmentAlignment:function(e){return!(!e||!e.hasOwnProperty(o.Z.SEGMENT_ALIGNMENT))&&"true"===e[o.Z.SEGMENT_ALIGNMENT]},getSubSegmentAlignment:function(e){return!(!e||!e.hasOwnProperty(o.Z.SUB_SEGMENT_ALIGNMENT))&&"true"===e[o.Z.SUB_SEGMENT_ALIGNMENT]},getSupplementalPropertiesForAdaptation:function(e){var t={};if(e&&e.hasOwnProperty(o.Z.SUPPLEMENTAL_PROPERTY_ASARRAY)){var n,r=xe(e.SupplementalProperty_asArray);try{for(r.s();!(n=r.n()).done;){var i=n.value;i.hasOwnProperty(a.Z.SCHEME_ID_URI)&&i.hasOwnProperty(o.Z.VALUE)&&(t[i[a.Z.SCHEME_ID_URI]]=i[o.Z.VALUE])}}catch(e){r.e(e)}finally{r.f()}}return t},getSupplementalPropertiesAsArrayForAdaptation:function(e){return e&&e.hasOwnProperty(o.Z.SUPPLEMENTAL_PROPERTY_ASARRAY)&&e.SupplementalProperty_asArray.length?e.SupplementalProperty_asArray.map((function(e){return(new we).init(e)})):[]},getSupplementalPropertiesForRepresentation:function(e){var t={};if(e&&e.hasOwnProperty(o.Z.SUPPLEMENTAL_PROPERTY_ASARRAY)){var n,r=xe(e.SupplementalProperty_asArray);try{for(r.s();!(n=r.n()).done;){var i=n.value;i.hasOwnProperty(a.Z.SCHEME_ID_URI)&&i.hasOwnProperty(o.Z.VALUE)&&(t[i[a.Z.SCHEME_ID_URI]]=i[o.Z.VALUE])}}catch(e){r.e(e)}finally{r.f()}}return t},getSupplementalPropertiesAsArrayForRepresentation:function(e){return e&&e.hasOwnProperty(o.Z.SUPPLEMENTAL_PROPERTY_ASARRAY)&&e.SupplementalProperty_asArray.length?e.SupplementalProperty_asArray.map((function(e){return(new we).init(e)})):[]},setConfig:function(e){e&&(e.errHandler&&(n=e.errHandler),e.BASE64&&(r=e.BASE64))}},t=(0,f.Z)(i).getInstance().getLogger(e),e}Ue.__dashjs_factory_name="DashManifestModel";var Ze=c.Z.getSingletonFactory(Ue),Be=n(703);function Ge(e,t){var n;if("undefined"==typeof Symbol||null==e[Symbol.iterator]){if(Array.isArray(e)||(n=function(e,t){if(e){if("string"==typeof e)return qe(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?qe(e,t):void 0}}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,i=function(){};return{s:i,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var a,o=!0,s=!1;return{s:function(){n=e[Symbol.iterator]()},n:function(){var e=n.next();return o=e.done,e},e:function(e){s=!0,a=e},f:function(){try{o||null==n.return||n.return()}finally{if(s)throw a}}}}function qe(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function Ye(){var e,t,n,r,i,o,s,l,c,f,g=this.context,h=(0,u.Z)(g).getInstance(),p=(0,N.Z)(g).getInstance();function m(){n={pr:1,nor:null,st:null,sf:null,sid:"".concat(Be.Z.generateUuid()),cid:null},c={},l={},f={},E()}function y(){E()}function E(){if(o){var e=o.getStreamController();if(e&&"function"==typeof e.getActiveStream){var t=e.getActiveStream();t&&(s=t.getProcessors())}}}function v(e,t){var n,r={},i=Ge(t);try{for(i.s();!(n=i.n()).done;){var a=n.value;e[a]&&(r[a]=e[a])}}catch(e){i.e(e)}finally{i.f()}return r}function _(e){var t=p.get().streaming.cmcd.enabledKeys;return e.filter((function(e){return t.includes(e)}))}function T(e){try{return e.type===C.w.MPD_TYPE?((u=S()).ot="m",u):e.type===C.w.MEDIA_SEGMENT_TYPE?(t=e.mediaType,f.hasOwnProperty(t)||(f[t]=!1),l.hasOwnProperty(t)||(l[t]=!1),c.hasOwnProperty(t)||(c[t]=!1),function(e){var t,u=S(),d=function(e){try{var t=e.quality,n=e.mediaInfo.bitrateList;return parseInt(n[t].bandwidth/1e3)}catch(e){return null}}(e),g=function(e){try{return isNaN(e.duration)?NaN:Math.round(1e3*e.duration)}catch(e){return null}}(e),h=function(e){try{return 100*parseInt(r.getThroughputHistory().getSafeAverageThroughput(e)/100)}catch(e){return null}}(e.mediaType),m=function(e){try{var t=n.pr,r=i.getCurrentBufferLevel(e);return isNaN(t)||isNaN(r)?null:100*parseInt(r/t*10)}catch(e){return null}}(e.mediaType),y=b(e.mediaType),E=function(e){try{var t=r.getTopBitrateInfoFor(e);return Math.round(t.bitrate/1e3)}catch(e){return null}}(e.mediaType),v=n.pr,_=function(e){if(s&&0!==s.length){var t,n=Ge(s);try{for(n.s();!(t=n.n()).done;){var r=t.value;if(r.getType()===e)return r.probeNextRequest()}}catch(e){n.e(e)}finally{n.f()}}}(e.mediaType);e.mediaType===a.Z.VIDEO&&(t="v"),e.mediaType===a.Z.AUDIO&&(t="a"),e.mediaType===a.Z.TEXT&&(t="application/mp4"===e.mediaInfo.mimeType?"tt":"c");var T=p.get().streaming.cmcd.rtp;return T||(T=function(e){try{var t=o.getPlaybackRate();t||(t=1);var n=e.quality,r=e.mediaType,i=e.mediaInfo,a=e.duration;if(!i)return NaN;var s=b(r);0===s&&(s=500);var u=i.bitrateList[n].bandwidth*a/1e3/(s/t/1e3),l=p.get().streaming.cmcd.rtpSafetyFactor&&!isNaN(p.get().streaming.cmcd.rtpSafetyFactor)?p.get().streaming.cmcd.rtpSafetyFactor:5;return 100*(parseInt(u*l/100)+1)}catch(e){return NaN}}(e)),isNaN(T)||(u.rtp=T),_&&(e.url!==_.url?u.nor=encodeURIComponent(Be.Z.getRelativeUrl(e.url,_.url)):_.range&&(u.nrr=_.range)),d&&(u.br=d),t&&(u.ot=t),isNaN(g)||(u.d=g),isNaN(h)||(u.mtp=h),isNaN(m)||(u.dl=m),isNaN(y)||(u.bl=y),isNaN(E)||(u.tb=E),isNaN(v)||1===v||(u.pr=v),c[e.mediaType]&&(u.bs=!0,c[e.mediaType]=!1),!l[e.mediaType]&&f[e.mediaType]||(u.su=!0,l[e.mediaType]=!1,f[e.mediaType]=!0),u}(e)):e.type===C.w.INIT_SEGMENT_TYPE?function(){var e=S();return e.ot="i",e.su=!0,e}():e.type===C.w.OTHER_TYPE||e.type===C.w.XLINK_EXPANSION_TYPE?function(){var e=S();return e.ot="o",e}():e.type===C.w.LICENSE?function(e){var t=S();return t.ot="k",t}():null}catch(e){return null}var t,u}function S(){var e={},t=p.get().streaming.cmcd.cid?p.get().streaming.cmcd.cid:n.cid;return e.v=1,e.sid=p.get().streaming.cmcd.sid?p.get().streaming.cmcd.sid:n.sid,e.sid="".concat(e.sid),t&&(e.cid="".concat(t)),isNaN(n.pr)||1===n.pr||null===n.pr||(e.pr=n.pr),n.st&&(e.st=n.st),n.sf&&(e.sf=n.sf),e}function b(e){try{var t=i.getCurrentBufferLevel(e);return isNaN(t)?null:100*parseInt(10*t)}catch(e){return null}}function A(e){try{n.pr=e.playbackRate}catch(e){}}function I(t){try{var r=e.getIsDynamic(t.data)?"l":"v",i=t.protocol&&"MSS"===t.protocol?"s":"d";n.st="".concat(r),n.sf="".concat(i)}catch(e){}}function R(e){try{e.state&&e.mediaType&&e.state===d.Z.BUFFER_EMPTY&&(c[e.mediaType]||(c[e.mediaType]=!0),l[e.mediaType]||(l[e.mediaType]=!0))}catch(e){}}function w(){for(var e in c)c.hasOwnProperty(e)&&(c[e]=!0);for(var t in l)l.hasOwnProperty(t)&&(l[t]=!0)}function D(e){try{if(!e)return null;var t=Object.keys(e).sort((function(e,t){return e.localeCompare(t)})),n=t.length,r=t.reduce((function(t,r,i){return"v"===r&&1===e[r]||("string"==typeof e[r]&&"ot"!==r&&"sf"!==r&&"st"!==r?t+="".concat(r,"=").concat(JSON.stringify(e[r])):t+="".concat(r,"=").concat(e[r]),i<n-1&&(t+=",")),t}),"");return(r=r.replace(/=true/g,"")).replace(/,\\s*$/,"")}catch(e){return null}}return t={getQueryParameter:function(e){try{if(p.get().streaming.cmcd&&p.get().streaming.cmcd.enabled){var t=T(e),n=function(e){try{var t=p.get().streaming.cmcd.enabledKeys;return Object.keys(e).filter((function(e){return t.includes(e)})).reduce((function(t,n){return t[n]=e[n],t}),{})}catch(t){return e}}(t),r=D(n);return h.trigger(de.Z.CMCD_DATA_GENERATED,{url:e.url,mediaType:e.mediaType,cmcdData:t,cmcdString:r}),{key:"CMCD",value:r}}return null}catch(e){return null}},getHeaderParameters:function(e){try{if(p.get().streaming.cmcd&&p.get().streaming.cmcd.enabled){var t=T(e),n=v(t,_(["br","d","ot","tb"])),r=v(t,_(["bl","dl","mtp","nor","nrr","su"])),i=v(t,_(["bs","rtp"])),a=v(t,_(["cid","pr","sf","sid","st","v"])),o={"CMCD-Object":D(n),"CMCD-Request":D(r),"CMCD-Status":D(i),"CMCD-Session":D(a)};return h.trigger(de.Z.CMCD_DATA_GENERATED,{url:e.url,mediaType:e.mediaType,cmcdData:t,headers:o}),o}return null}catch(e){return null}},setConfig:function(e){e&&(e.abrController&&(r=e.abrController),e.dashMetrics&&(i=e.dashMetrics),e.playbackController&&(o=e.playbackController))},reset:function(){h.off(d.Z.PLAYBACK_RATE_CHANGED,A,this),h.off(d.Z.MANIFEST_LOADED,I,this),h.off(d.Z.BUFFER_LEVEL_STATE_CHANGED,R,t),h.off(d.Z.PLAYBACK_SEEKED,w,t),m()},initialize:function(){h.on(d.Z.PLAYBACK_RATE_CHANGED,A,t),h.on(d.Z.MANIFEST_LOADED,I,t),h.on(d.Z.BUFFER_LEVEL_STATE_CHANGED,R,t),h.on(d.Z.PLAYBACK_SEEKED,w,t),h.on(d.Z.PERIOD_SWITCH_COMPLETED,y,t)}},e=Ze(g).getInstance(),m(),t}Ye.__dashjs_factory_name="CmcdModel";var je=c.Z.getSingletonFactory(Ye);function He(e){return He="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},He(e)}function Ve(e,t){Ve=function(e,t){return new a(e,void 0,t)};var n=ze(RegExp),r=RegExp.prototype,i=new WeakMap;function a(e,t,r){var a=n.call(this,e,t);return i.set(a,r||i.get(e)),a}function o(e,t){var n=i.get(t);return Object.keys(n).reduce((function(t,r){return t[r]=e[n[r]],t}),Object.create(null))}return Ke(a,n),a.prototype.exec=function(e){var t=r.exec.call(this,e);return t&&(t.groups=o(t,this)),t},a.prototype[Symbol.replace]=function(e,t){if("string"==typeof t){var n=i.get(this);return r[Symbol.replace].call(this,e,t.replace(/\\$<([^>]+)>/g,(function(e,t){return"$"+n[t]})))}if("function"==typeof t){var a=this;return r[Symbol.replace].call(this,e,(function(){var e=[];return e.push.apply(e,arguments),"object"!==He(e[e.length-1])&&e.push(o(e,a)),t.apply(this,e)}))}return r[Symbol.replace].call(this,e,t)},Ve.apply(this,arguments)}function Ke(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&Qe(e,t)}function ze(e){var t="function"==typeof Map?new Map:void 0;return ze=function(e){if(null===e||(n=e,-1===Function.toString.call(n).indexOf("[native code]")))return e;var n;if("function"!=typeof e)throw new TypeError("Super expression must either be null or a function");if(void 0!==t){if(t.has(e))return t.get(e);t.set(e,r)}function r(){return We(e,arguments,Je(this).constructor)}return r.prototype=Object.create(e.prototype,{constructor:{value:r,enumerable:!1,writable:!0,configurable:!0}}),Qe(r,e)},ze(e)}function We(e,t,n){return We=Xe()?Reflect.construct:function(e,t,n){var r=[null];r.push.apply(r,t);var i=new(Function.bind.apply(e,r));return n&&Qe(i,n.prototype),i},We.apply(null,arguments)}function Xe(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}function Qe(e,t){return Qe=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},Qe(e,t)}function Je(e){return Je=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},Je(e)}var $e="static",et="dynamic",tt="cmsd-",nt=tt+$e,rt=tt+et,it="stream",at=["mb","st","sf","v"],ot={video:"v",audio:"a",text:"tt",stream:it},st=/^[-0-9]/;function ut(){var e,t,n,r,i=this.context,a=(0,u.Z)(i).getInstance();function o(){n={},r={}}function s(e){e&&Object.keys(e).forEach((function(t){at.includes(t)||delete e[t]}))}function c(e){return!e||"false"!==e.toLowerCase()&&(st.test(e)?parseInt(e,10):e.replace(/["]+/g,""))}function d(e){try{for(var n={},r=e.split(","),i=0;i<r.length;i++){var a=r[i].split("="),o=a[0],s=c(a[1]);n[o]=s}return n}catch(e){t.error("Failed to parse CMSD-Static response header value:",e)}}function g(e){try{for(var n={},r=e.split(","),i=r[r.length-1].split(";"),a=1;a<i.length;a++){var o=i[a].split("="),s=o[0],u=c(o[1]);n[s]=u}return n}catch(e){return t.error("Failed to parse CMSD-Dynamic response header value:",e),[]}}function h(e){return ot[e]||"o"}function p(e,t,i){var a=e===$e?n:r,o=a[t]||{},s=a[it]||{};return o[i]||s[i]}return e={setConfig:function(){},initialize:function(){},reset:function(){o()},parseResponseHeaders:function(e,t){for(var i=null,o=null,u=e.split("\\r\\n"),c=u.length-1;c>=0;c--){var f=u[c].match(Ve(/^((?:(?!:)[\\s\\S])*):[\\t-\\r \\xA0\\u1680\\u2000-\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000\\uFEFF]*(.*)$/,{key:1,value:2}));if(f&&f.groups){var p=f.groups.key.toLowerCase(),m=f.groups.value;switch(p){case nt:i=d(m),a.trigger(l.Z.CMSD_STATIC_HEADER,i);break;case rt:o||(o=g(m))}}}var y=it;return i&&i.ot?y=i.ot:t&&(y=h(t)),s(n[y]),s(r[y]),i&&(n[y]=Object.assign(n[y]||{},i)),o&&(r[y]=Object.assign(r[y]||{},o)),{static:i,dynamic:o}},getMaxBitrate:function(e){var t=h(e);return p(et,t,"mb")||-1},getEstimatedThroughput:function(e){var t=h(e);return p(et,t,"etp")||null},getResponseDelay:function(e){var t=h(e);return p(et,t,"rd")||null},getRoundTripTime:function(e){var t=h(e);return p(et,t,"rtt")||null}},t=(0,f.Z)(i).getInstance().getLogger(e),o(),e}ut.__dashjs_factory_name="CmsdModel";var lt=c.Z.getSingletonFactory(ut);function ct(){var e,t,n=this.context,r={};function i(){t=(0,f.Z)(n).getInstance().getLogger(e)}function a(e){for(var t={},n=0,r=0,i=0,a=0,o=e.length,s=0;s<o;++s)n+=e[s].chunkDownloadTimeRelativeMS,r+=e[s].bufferLevel,i+=e[s].chunkDownloadTimeRelativeMS*e[s].bufferLevel,a+=e[s].chunkDownloadTimeRelativeMS*e[s].chunkDownloadTimeRelativeMS;return t.m=(i-n*r/o)/(a-n*n/o),t.b=r/o-t.m*n/o,function(e){return t.m*e+t.b}}function o(e){var t,n=!0,r=e.reduce((function(e,t){return e+t.bufferLevelAtSegmentEnd}),0)/e.length;return e.forEach((function(e){Math.abs(e.bufferLevelAtSegmentEnd/e.bufferLevelAtSegmentStart)<.95&&(n=!1),e.bufferLevelAtSegmentEnd/r<.8&&(n=!1),t?t>e.bitrate&&(n=!1):t=e.bitrate})),n}return e={setup:i,addMeasurement:function(e,t,n,i,o){e&&e.mediaType&&!r[e.mediaType]&&(r[e.mediaType]=[]);var s=e.mediaInfo.bitrateList.find((function(t){return t.id===e.representationId}));r[e.mediaType].push({index:e.index,repId:e.representationId,mediaType:e.mediaType,requestTimeMS:i,adjustedAvailabilityStartTimeMS:e.availabilityStartTime.getTime(),segDurationMS:1e3*e.duration,chunksDurationMS:n.reduce((function(e,t){return e+t.chunkDownloadDurationMS}),0),segmentBytes:n.reduce((function(e,t){return e+t.chunkBytes}),0),bitrate:s&&s.bandwidth,bitrateList:e.mediaInfo.bitrateList,chunkMeasurements:n,fetchDownloadDurationMS:t,throughputCapacityDelayMS:o,getEstimatedBufferLevel:a(n.slice(1))}),r[e.mediaType].length>10&&r[e.mediaType].shift()},getThroughputCapacityDelayMS:function(e,t){var n=r[e.mediaType]&&r[e.mediaType].slice(-3);return!n||n.length<3?0:o(n)?t/4>250?250:t/4:0},getEstimatedDownloadDurationMS:function(e){var n=r[e.mediaType].slice(-1).pop(),i=r[e.mediaType].slice(-3),a=n.chunkMeasurements.slice(-1).pop().chunkDownloadTimeRelativeMS;n.bufferLevelAtSegmentStart=n.getEstimatedBufferLevel(a/2),n.bufferLevelAtSegmentEnd=n.getEstimatedBufferLevel(a);var s=o(i),u=s?.6:.8;if(n.isBufferStable&&1.05*n.segDurationMS<n.fetchDownloadDurationMS)return n.fetchDownloadDurationMS;if(!s||n.segDurationMS<n.fetchDownloadDurationMS)return.8*n.fetchDownloadDurationMS;if(n.adjustedAvailabilityStartTimeMS<=n.requestTimeMS+n.throughputCapacityDelayMS-n.segDurationMS)return.8*n.fetchDownloadDurationMS;for(var l=n.requestTimeMS+n.throughputCapacityDelayMS-n.adjustedAvailabilityStartTimeMS,c=0,f=0,d=0,g=0;g<n.chunkMeasurements.length;g++){var h=n.chunkMeasurements[g];if(l<f+h.chunkDownloadDurationMS)break;f+=h.chunkDownloadDurationMS,c+=h.chunkBytes,d++}if(l<0&&t.warn("request time was before adjusted availibitly start time"),c&&f&&d>.2*n.chunkMeasurements.length){var p=c/f,m=n.segmentBytes/p;return n.fetchDownloadDurationMS<m?n.fetchDownloadDurationMS*u:m*u}var y=n.bitrate;return n.bitrateList.some((function(e){if(e.bandwidth>n.bitrate)return y=e.bandwidth,!0})),y===n.bitrate?n.fetchDownloadDurationMS*u:u*n.segmentBytes*8*1e3/y}},i(),e}ct.__dashjs_factory_name="LowLatencyThroughputModel";var ft=c.Z.getSingletonFactory(ct),dt=n(5717);function gt(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function ht(e){e=e||{};var t,n,r,i,o,s,c,d,g,h,p,m=this.context,y=e.errHandler,E=e.dashMetrics,v=e.mediaPlayerModel,_=e.requestModifier,T=e.boxParser,b=e.errors,A=e.requestTimeout||0,I=(0,u.Z)(m).getInstance(),R=(0,N.Z)(m).getInstance();function w(e,t){var u,f=e.request,p=[],b=!0,N=!0,D=new Date,O=D,M=0,P=null,L=null;if(!_||!E||!y)throw new Error("config object is not correct or missing");var x,F=function(e){f.requestStartDate=D,f.requestEndDate=new Date,f.firstByteDate=f.firstByteDate||D,f.fileLoaderType=L;var t=u.response?u.response.responseURL:null,n=u.response?u.response.status:null,r=u.response&&u.response.getAllResponseHeaders?u.response.getAllResponseHeaders():u.response?u.response.responseHeaders:null,i=r&&R.get().streaming.cmsd&&R.get().streaming.cmsd.enabled?c.parseResponseHeaders(r,f.mediaType):null;E.addHttpRequest(f,t,n,r,e?p:null,i)},k=function(e){N=!1,F(e),f.type===C.w.MPD_TYPE&&(E.addManifestUpdate(f),I.trigger(l.Z.MANIFEST_LOADING_FINISHED,{request:f}))},U=function(){if(P&&(clearTimeout(P),P=null),-1!==n.indexOf(u)&&(n.splice(n.indexOf(u),1),N))if(k(!1),t>0){try{R.get().streaming.utcSynchronization.enableBackgroundSyncAfterSegmentDownloadError&&f.type===C.w.MEDIA_SEGMENT_TYPE&&v.getRetryAttemptsForType(C.w.MEDIA_SEGMENT_TYPE)===t&&I.trigger(l.Z.ATTEMPT_BACKGROUND_SYNC)}catch(e){}t--;var r={config:e};i.push(r),r.timeout=setTimeout((function(){-1!==i.indexOf(r)&&(i.splice(i.indexOf(r),1),w(e,t))}),v.getRetryIntervalsForType(f.type))}else{if(f.type===C.w.MSS_FRAGMENT_INFO_SEGMENT_TYPE)return;y.error(new S.Z(o[f.type],f.url+" is not available",{request:f,response:u.response})),e.error&&e.error(f,"error",u.response.statusText,u.response),e.complete&&e.complete(f,u.response.statusText)}};f.hasOwnProperty("availabilityTimeComplete")&&!1===f.availabilityTimeComplete&&window.fetch&&"arraybuffer"===f.responseType&&f.type===C.w.MEDIA_SEGMENT_TYPE?((x=fe(m).create({requestModifier:_,lowLatencyThroughputModel:g,boxParser:T})).setup({dashMetrics:E}),L=a.Z.FILE_LOADER_TYPES.FETCH):(x=(0,se.Z)(m).create({requestModifier:_}),L=a.Z.FILE_LOADER_TYPES.XHR);var Z=null,B=_.modifyRequestURL?_.modifyRequestURL(f.url):f.url;if(R.get().streaming.cmcd&&R.get().streaming.cmcd.enabled){var G=R.get().streaming.cmcd.mode;if(G===a.Z.CMCD_MODE_QUERY){var q=function(e){try{var t=[],n=s.getQueryParameter(e);return n&&t.push(n),t}catch(e){return[]}}(f);B=Be.Z.addAditionalQueryParameterToUrl(B,q)}else G===a.Z.CMCD_MODE_HEADER&&(Z=s.getHeaderParameters(f))}var Y=d.getXHRWithCredentialsForType(f.type);if(f.queryParams){var j=Object.keys(f.queryParams).map((function(e){return{key:e,value:f.queryParams[e]}}));B=Be.Z.addAditionalQueryParameterToUrl(B,j)}f.url=B,u={url:B,method:C.w.GET,withCredentials:Y,request:f,onload:function(){u.response.status>=200&&u.response.status<=299&&(k(!0),e.success&&e.success(u.response.response,u.response.statusText,u.response.responseURL),e.complete&&e.complete(f,u.response.statusText))},onend:U,onerror:U,progress:function(t){var n=new Date;b&&(b=!1,(!t.lengthComputable||t.lengthComputable&&t.total!==t.loaded)&&(f.firstByteDate=n)),t.lengthComputable&&(f.bytesLoaded=t.loaded,f.bytesTotal=t.total),t.noTrace||(p.push({s:O,d:t.time?t.time:n.getTime()-O.getTime(),b:[t.loaded?t.loaded-M:0]}),O=n,M=t.loaded),P&&(clearTimeout(P),P=null),R.get().streaming.fragmentRequestProgressTimeout>0&&(P=setTimeout((function(){h.warn("Abort request "+u.url+" due to progress timeout"),u.response.onabort=null,u.loader.abort(u),U()}),R.get().streaming.fragmentRequestProgressTimeout)),e.progress&&t&&e.progress(t)},onabort:function(){F(!0),P&&(clearTimeout(P),P=null),e.abort&&e.abort(f)},ontimeout:function(e){var t;if(e.lengthComputable){var n=e.loaded/e.total*100;t="Request timeout: loaded: "+e.loaded+", out of: "+e.total+" : "+n.toFixed(3)+"% Completed"}else t="Request timeout: non-computable download size";h.warn(t)},loader:x,timeout:A,headers:Z};var H=(new Date).getTime();if(isNaN(f.delayLoadingTime)||H>=f.delayLoadingTime)n.push(u),x.load(u);else{var V={httpRequest:u};r.push(V),V.delayTimeout=setTimeout((function(){if(-1!==r.indexOf(V)){r.splice(r.indexOf(V),1);try{D=new Date,O=D,n.push(V.httpRequest),x.load(V.httpRequest)}catch(e){V.httpRequest.onerror()}}}),f.delayLoadingTime-H)}}return t={load:function(e){e.request?w(e,v.getRetryAttemptsForType(e.request.type)):e.error&&e.error(e.request,"error")},abort:function(){i.forEach((function(e){clearTimeout(e.timeout),e.config.request&&e.config.abort&&e.config.abort(e.config.request)})),i=[],r.forEach((function(e){return clearTimeout(e.delayTimeout)})),r=[],n.forEach((function(e){e.request.type!==C.w.MSS_FRAGMENT_INFO_SEGMENT_TYPE&&(e.onloadend=e.onerror=e.onprogress=void 0,e.loader.abort(e))})),n=[]}},h=(0,f.Z)(m).getInstance().getLogger(t),n=[],r=[],i=[],s=je(m).getInstance(),c=lt(m).getInstance(),g=ft(m).getInstance(),d=(0,dt.Z)(m).getInstance(),gt(p={},C.w.MPD_TYPE,b.DOWNLOAD_ERROR_ID_MANIFEST_CODE),gt(p,C.w.XLINK_EXPANSION_TYPE,b.DOWNLOAD_ERROR_ID_XLINK_CODE),gt(p,C.w.INIT_SEGMENT_TYPE,b.DOWNLOAD_ERROR_ID_INITIALIZATION_CODE),gt(p,C.w.MEDIA_SEGMENT_TYPE,b.DOWNLOAD_ERROR_ID_CONTENT_CODE),gt(p,C.w.INDEX_SEGMENT_TYPE,b.DOWNLOAD_ERROR_ID_CONTENT_CODE),gt(p,C.w.BITSTREAM_SWITCHING_SEGMENT_TYPE,b.DOWNLOAD_ERROR_ID_CONTENT_CODE),gt(p,C.w.OTHER_TYPE,b.DOWNLOAD_ERROR_ID_CONTENT_CODE),o=p,t}ht.__dashjs_factory_name="HTTPLoader";var pt=c.Z.getClassFactory(ht);function mt(){var e;function t(){e={}}function n(){t()}return n(),{getLoader:function(t){for(var n in e)if(e.hasOwnProperty(n)&&t.startsWith(n))return e[n];return pt},registerLoader:function(t,n){e[t]=n},unregisterLoader:function(t){e[t]&&delete e[t]},unregisterAllLoader:t,reset:n}}mt.__dashjs_factory_name="SchemeLoaderFactory";var yt=c.Z.getSingletonFactory(mt);function Et(e){e=e||{};var t,n,r=this.context;return t=yt(r).getInstance(),{load:function(i){if(!n){var a=t.getLoader(i&&i.request?i.request.url:null);n=a(r).create({errHandler:e.errHandler,mediaPlayerModel:e.mediaPlayerModel,requestModifier:e.requestModifier,dashMetrics:e.dashMetrics,boxParser:e.boxParser?e.boxParser:null,constants:e.constants?e.constants:null,dashConstants:e.dashConstants?e.dashConstants:null,urlUtils:e.urlUtils?e.urlUtils:null,requestTimeout:isNaN(e.requestTimeout)?0:e.requestTimeout,errors:e.errors})}n.load(i)},abort:function(){n&&n.abort()}}}Et.__dashjs_factory_name="URLLoader";var vt=c.Z.getClassFactory(Et);function _t(e){return _t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_t(e)}function Tt(e,t){return Tt=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},Tt(e,t)}function St(e,t){return!t||"object"!==_t(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function bt(e){return bt=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},bt(e)}var At=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&Tt(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=bt(t);if(n){var i=bt(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return St(this,e)});function i(e){var t;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),(t=r.call(this,e)).checkForExistenceOnly=!0,t}return i}(p.Z);function It(e){e=e||{};var t,n,r=this.context,i=e.eventBus,o=e.events,s=e.urlUtils,u=e.errors,l=e.streamId;return t={checkForExistence:function(e){var t=function(t){i.trigger(o.CHECK_FOR_EXISTENCE_COMPLETED,{request:e,exists:t})};if(e){var r=new At(e.url);n.load({request:r,success:function(){t(!0)},error:function(){t(!1)}})}else t(!1)},load:function(e){var r=function(n,r){i.trigger(o.LOADING_COMPLETED,{request:e,response:n||null,error:r||null,sender:t})};e?n.load({request:e,progress:function(n){i.trigger(o.LOADING_PROGRESS,{request:e,stream:n.stream,streamId:l}),n.data&&i.trigger(o.LOADING_DATA_PROGRESS,{request:e,response:n.data||null,error:null,sender:t})},success:function(e){r(e)},error:function(e,t,n){r(void 0,new S.Z(u.FRAGMENT_LOADER_LOADING_FAILURE_ERROR_CODE,n,t))},abort:function(e){e&&i.trigger(o.LOADING_ABANDONED,{mediaType:e.mediaType,request:e,sender:t})}}):r(void 0,new S.Z(u.FRAGMENT_LOADER_NULL_REQUEST_ERROR_CODE,u.FRAGMENT_LOADER_NULL_REQUEST_ERROR_MESSAGE))},abort:function(){n&&n.abort()},reset:function(){n&&(n.abort(),n=null)}},n=vt(r).create({errHandler:e.errHandler,errors:u,dashMetrics:e.dashMetrics,mediaPlayerModel:e.mediaPlayerModel,requestModifier:e.requestModifier,urlUtils:s,constants:a.Z,boxParser:e.boxParser,dashConstants:e.dashConstants,requestTimeout:e.settings.get().streaming.fragmentRequestTimeout}),t}It.__dashjs_factory_name="FragmentLoader";var Rt=c.Z.getClassFactory(It);function wt(){return{modifyResponseAsync:function(e){return Promise.resolve(e)}}}wt.__dashjs_factory_name="SegmentResponseModifier";var Nt=c.Z.getSingletonFactory(wt);function Ct(e){e=e||{};var t,n,r,i=this.context,o=(0,u.Z)(i).getInstance(),s=e.errHandler,c=e.mediaPlayerModel,g=e.dashMetrics,h=(0,f.Z)(i).getInstance(),p=Nt(i).getInstance(),m=e.streamInfo;function y(){return m.id}function E(){for(var e in r)r[e].reset();r={}}function v(e){if(e.sender){var t=e.request,r=e.response,i=t.isInitializationRequest(),s=t.mediaInfo.streamInfo;if(e.error&&(t.mediaType===a.Z.AUDIO||t.mediaType===a.Z.VIDEO||t.mediaType===a.Z.TEXT&&t.mediaInfo.isFragmented)&&o.trigger(l.Z.SERVICE_LOCATION_BASE_URL_BLACKLIST_ADD,{entry:e.request.serviceLocation}),r&&s){var u=function(e,t,n,r){var i=new oe;return i.streamId=n,i.mediaInfo=t.mediaInfo,i.segmentType=t.type,i.start=t.startTime,i.duration=t.duration,i.end=i.start+i.duration,i.bytes=e,i.index=t.index,i.quality=t.quality,i.representationId=t.representationId,i.endFragment=r,i}(r,t,m.id,e.type!==l.Z.FRAGMENT_LOADING_PROGRESS);p.modifyResponseAsync(u).then((function(e){o.trigger(i?l.Z.INIT_FRAGMENT_LOADED:l.Z.MEDIA_FRAGMENT_LOADED,{chunk:e,request:t},{streamId:s.id,mediaType:t.mediaType})})).catch((function(e){n.error(e),o.trigger(i?l.Z.INIT_FRAGMENT_LOADED:l.Z.MEDIA_FRAGMENT_LOADED,{chunk:u,request:t},{streamId:s.id,mediaType:t.mediaType})}))}else n.warn("No "+t.mediaType+" bytes to push or stream is inactive.")}}return t={getStreamId:y,getModel:function(t){var n=r[t];return n||(n=T(i).create({streamInfo:m,type:t,dashMetrics:g,fragmentLoader:Rt(i).create({dashMetrics:g,mediaPlayerModel:c,errHandler:s,requestModifier:(0,X.Z)(i).getInstance(),settings:e.settings,boxParser:e.boxParser,eventBus:o,events:l.Z,errors:w,dashConstants:e.dashConstants,urlUtils:e.urlUtils,streamId:y()}),debug:h,eventBus:o,events:l.Z}),r[t]=n),n},reset:function(){o.off(d.Z.FRAGMENT_LOADING_COMPLETED,v,this),o.off(d.Z.FRAGMENT_LOADING_PROGRESS,v,this),E()}},n=h.getLogger(t),E(),o.on(d.Z.FRAGMENT_LOADING_COMPLETED,v,t),o.on(d.Z.FRAGMENT_LOADING_PROGRESS,v,t),t}Ct.__dashjs_factory_name="FragmentController";var Dt=c.Z.getClassFactory(Ct),Ot=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.url=null,this.width=null,this.height=null,this.x=null,this.y=null},Mt=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.mediaType=null,this.bitrate=null,this.width=null,this.height=null,this.scanType=null,this.qualityIndex=NaN};function Pt(e){var t,n,r=this.context,i=e.streamInfo;function o(e){n.setTrackByIndex(e)}function s(){n&&n.reset()}return t={getStreamId:function(){return i.id},initialize:function(){n.addTracks();var e=n.getTracks();e&&e.length>0&&o(0)},provide:function(e,t){if("function"==typeof t){var r,i,a=n.getCurrentTrack();if(!a||a.segmentDuration<=0||null==e)t(null);else{(i=n.getThumbnailRequestForTime(e))&&(a.segmentDuration=i.duration),r=e%a.segmentDuration;var o=Math.floor(r*a.tilesHor*a.tilesVert/a.segmentDuration),s=new Ot;if(s.width=Math.floor(a.widthPerTile),s.height=Math.floor(a.heightPerTile),s.x=Math.floor(o%a.tilesHor)*a.widthPerTile,s.y=Math.floor(o/a.tilesHor)*a.heightPerTile,"readThumbnail"in a)return a.readThumbnail(e,(function(e){s.url=e,t(s)}));if(i)s.url=i.url,a.segmentDuration=NaN;else{var u=Math.floor(e/a.segmentDuration);s.url=function(e,t){var n=t+e.startNumber,r=(0,H.vi)(e.templateUrl,"Number",n);return r=(0,H.vi)(r,"Time",(n-1)*e.segmentDuration*e.timescale),r=(0,H.vi)(r,"Bandwidth",e.bandwidth),(0,H.eR)(r)}(a,u)}t(s)}}},setTrackByIndex:o,getCurrentTrackIndex:function(){return n.getCurrentTrackIndex()},getBitrateList:function(){var e=n.getTracks(),t=0;return e.map((function(e){var n=new Mt;return n.mediaType=a.Z.IMAGE,n.qualityIndex=t++,n.bitrate=e.bitrate,n.width=e.width,n.height=e.height,n}))},reset:s},s(),n=(0,Me.Z)(r).create({streamInfo:i,adapter:e.adapter,baseURLController:e.baseURLController,timelineConverter:e.timelineConverter,debug:e.debug,eventBus:e.eventBus,events:e.events,dashConstants:e.dashConstants,dashMetrics:e.dashMetrics,segmentBaseController:e.segmentBaseController}),t}Pt.__dashjs_factory_name="ThumbnailController";var Lt=c.Z.getClassFactory(Pt),xt=n(7417);function Ft(e){var t;e=e||{};var n=[],r=(0,u.Z)(this.context).getInstance(),i=e.updateEventName,a=e.addBlacklistEventName;function o(e){-1===n.indexOf(e)&&(n.push(e),r.trigger(i,{entry:e}))}return t={add:o,contains:function(e){return!!(n.length&&e&&e.length)&&-1!==n.indexOf(e)},reset:function(){n=[]}},a&&r.on(a,(function(e){o(e.entry)}),t),t}Ft.__dashjs_factory_name="BlackListController";var kt=c.Z.getClassFactory(Ft),Ut=[a.Z.VIDEO,a.Z.AUDIO,a.Z.TEXT,a.Z.MUXED,a.Z.IMAGE];function Zt(e){e=e||{};var t,n,r,i,s,c,d,g,h,p,m,y,E,v,_,T,b,A,I=this.context,R=(0,u.Z)(I).getInstance(),N=(0,Q.Z)(I).getInstance(),C=e.manifestModel,D=e.mediaPlayerModel,O=e.dashMetrics,M=e.manifestUpdater,P=e.adapter,L=e.timelineConverter,x=e.capabilities,F=e.errHandler,k=e.abrController,U=e.playbackController,Z=e.eventController,B=e.mediaController,G=e.protectionController,q=e.textController,Y=e.videoModel,j=e.streamInfo,H=e.settings;function V(e,t){return new Promise((function(i,o){ne(),p=!0,ie();var s=Y.getElement(),u=[];Ut.forEach((function(t){(t!==a.Z.TEXT||e)&&(t!==a.Z.VIDEO||!s||s&&/^VIDEO$/i.test(s.nodeName))&&u.push(K(t,e))})),Promise.all(u).then((function(){return e=t,new Promise((function(t){var n={},i=r.map((function(t){return t.createBufferSinks(e)}));Promise.all(i).then((function(e){e.forEach((function(e){e&&(n[e.getType()]=e)})),t(n)})).catch((function(){t(n)}))}));var e})).then((function(t){if(p=!1,0===r.length){var a="No streams to play.";F.error(new S.Z(w.MANIFEST_ERROR_ID_NOSTREAMS_CODE,a,C.getValue())),n.fatal(a)}else oe();e&&q.createTracks(j),i(t)})).catch((function(e){o(e)}))}))}function K(t,i){var s,u=P.getAllMediaInfoForType(j,t),c=[],f=null;if(!u||0===u.length)return n.info("No "+t+" data."),Promise.resolve();t===a.Z.VIDEO&&(d=!0),t===a.Z.AUDIO&&(g=!0);for(var h=0,p=u.length;h<p;h++)f=u[h],t===a.Z.TEXT&&f.isEmbedded&&(q.addEmbeddedTrack(j,f),c.push(f)),z(f)&&B.addTrack(f);if(c.length>0&&(B.setInitialMediaSettingsForType(t,j),q.addMediaInfosToBuffer(j,t,c)),u=u.filter((function(e){return!e.isEmbedded})),0===u.length)return Promise.resolve();if(t===a.Z.IMAGE)return(y=Lt(I).create({streamInfo:j,adapter:P,baseURLController:e.baseURLController,timelineConverter:e.timelineConverter,debug:T,eventBus:R,events:l.Z,dashConstants:o.Z,dashMetrics:e.dashMetrics,segmentBaseController:e.segmentBaseController})).initialize(),Promise.resolve();R.trigger(l.Z.STREAM_INITIALIZING,{streamInfo:j,mediaInfo:f}),B.setInitialMediaSettingsForType(t,j);var v=function(t,n){var i=t&&t.length>0?t[0]:null,o=m.getModel(i?i.type:null),s=i?i.type:null,u=i?i.mimeType:null,l=i?i.isFragmented:null,c=ae(I).create({streamInfo:j,type:s,mimeType:u,timelineConverter:L,adapter:P,manifestModel:C,mediaPlayerModel:D,fragmentModel:o,dashMetrics:e.dashMetrics,baseURLController:e.baseURLController,segmentBaseController:e.segmentBaseController,abrController:k,playbackController:U,mediaController:B,textController:q,errHandler:F,settings:H,boxParser:_,segmentBlacklistController:E});c.initialize(n,d,l),r.push(c);for(var f=0;f<t.length;f++)c.addMediaInfo(t[f]);return s===a.Z.TEXT&&q.addMediaInfosToBuffer(j,s,t,o),c}(u,i);return(s=B.getCurrentTrackFor(t,j.id))?(k.updateTopQualityIndex(s),v.selectMediaInfo(t===a.Z.TEXT&&s.isEmbedded?u[0]:s)):Promise.resolve()}function z(e){var t,r=e?e.type:null;return r===a.Z.MUXED?(t="Multiplexed representations are intentionally not supported, as they are not compliant with the DASH-AVC/264 guidelines",n.fatal(t),F.error(new S.Z(w.MANIFEST_ERROR_ID_MULTIPLEXED_CODE,t,C.getValue())),!1):!(r!==a.Z.TEXT&&r!==a.Z.IMAGE&&e.contentProtection&&!x.supportsEncryptedMedia()&&(F.error(new S.Z(w.CAPABILITY_MEDIAKEYS_ERROR_CODE,w.CAPABILITY_MEDIAKEYS_ERROR_MESSAGE)),1))}function W(e){for(var t=r?r.length:0,n=0;n<t;n++){var i=r[n].getFragmentModel();i.abortRequests(),i.resetInitialSettings(),r[n].reset(!1,e)}q&&q.deactivateStream(j),r=[],s=!1,c=!1,me(!1),J(!1),R.trigger(l.Z.STREAM_DEACTIVATED,{streamInfo:j})}function X(e){W(e),i=!1,d=!1,g=!1,h={},p=!1,b=!1,A=[]}function J(e){b=e}function $(){return j?j.start:NaN}function ee(){return j?j.id:null}function te(){return j}function ne(){if(!Y||!k)throw new Error(a.Z.MISSING_CONFIG_ERROR)}function re(e){e.error&&(F.error(e.error),n.fatal(e.error.message))}function ie(){if(Z){var e=P.getEventsFor(j);e&&e.length>0&&Z.addInlineEvents(e,j.id)}}function oe(){for(var e=r.length,t=h.audio||h.video?new S.Z(w.DATA_UPDATE_FAILED_ERROR_CODE,w.DATA_UPDATE_FAILED_ERROR_MESSAGE):null,n=0;n<e;n++)if(r[n].isUpdating()||p)return;if(G){G.clearMediaInfoArray();for(var o=0;o<e&&r[o];o++){var s=r[o].getType(),u=r[o].getMediaInfo();if(s===a.Z.AUDIO||s===a.Z.VIDEO||s===a.Z.TEXT&&u.isFragmented){var c=r[o].getMediaInfo();c&&G.initializeForMedia(c)}}G.handleKeySystemFromManifest()}t?F.error(t):i||(i=!0,Y.waitForReadyState(a.Z.VIDEO_ELEMENT_READY_STATES.HAVE_METADATA,(function(){R.trigger(l.Z.STREAM_INITIALIZED,{streamInfo:j})})))}function se(){var e=de(),t=e.length;if(0!==t){for(var r=0;r<t;r++)if(!e[r].isBufferingCompleted()&&(e[r].getType()===a.Z.AUDIO||e[r].getType()===a.Z.VIDEO))return void n.debug("onBufferingCompleted - One streamProcessor has finished but",e[r].getType(),"one is not buffering completed");n.debug("onBufferingCompleted - trigger STREAM_BUFFERING_COMPLETED"),c=!0,R.trigger(l.Z.STREAM_BUFFERING_COMPLETED,{streamInfo:j},{streamInfo:j})}else n.warn("onBufferingCompleted - can\'t trigger STREAM_BUFFERING_COMPLETED because no streamProcessor is defined")}function ue(e){h[e.mediaType]=e.error,oe()}function le(e){Z&&Z.addInbandEvents(e.events,j.id)}function ce(e){return e&&e.type?fe(e.type):null}function fe(e){return e?de().filter((function(t){return t.getType()===e}))[0]:null}function de(){for(var e,t,n=[],i=0;i<r.length;i++)(e=(t=r[i]).getType())!==a.Z.AUDIO&&e!==a.Z.VIDEO&&e!==a.Z.TEXT||n.push(t);return n}function ge(e,t){var n=te(),r=t.getStreamInfo();if(!r||!n)return!0;var i=P.getAdaptationForType(r.index,e,r),a=P.getAdaptationForType(n.index,e,n);return i&&a?!(!he(a)&&he(i)):!i&&!a}function he(e){return!!e&&!!(e.ContentProtection||e.Representation_asArray&&e.Representation_asArray.length>0&&e.Representation_asArray[0].ContentProtection)}function pe(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;if(!e||!e.hasOwnProperty("getStreamInfo"))return!1;var r=e.getStreamInfo(),i=n?n.getStreamInfo():te();if(!r||!i)return!1;var a=P.getAdaptationForType(r.index,t,r),o=P.getAdaptationForType(i.index,t,i);if(!a||!o)return!a&&!o;var s=a&&o&&a.mimeType===o.mimeType,u=o.Representation_asArray.map((function(e){return e.codecs})),l=a.Representation_asArray.map((function(e){return e.codecs})),c=l.some((function(e){return u.indexOf(e)>-1})),f=l.some((function(e){return u.some((function(t){return x.codecRootCompatibleWithCodec(t,e)}))}));return c||f&&s}function me(e){v=e}function ye(){return v}return t={initialize:function(){R.on(l.Z.BUFFERING_COMPLETED,se,t),R.on(l.Z.DATA_UPDATE_COMPLETED,ue,t),R.on(l.Z.INBAND_EVENTS,le,t),G&&(R.on(l.Z.KEY_ERROR,re,t),R.on(l.Z.SERVER_CERTIFICATE_UPDATED,re,t),R.on(l.Z.LICENSE_REQUEST_COMPLETE,re,t),R.on(l.Z.KEY_SYSTEM_SELECTED,re,t),R.on(l.Z.KEY_SESSION_CREATED,re,t),R.on(l.Z.KEY_STATUSES_CHANGED,re,t)),q.initializeForStream(j),R.trigger(l.Z.STREAM_UPDATED,{streamInfo:j})},getStreamId:function(){return j?j.id:null},activate:function(e,t){return new Promise((function(n,r){if(!s)return ye()?(s=!0,R.trigger(l.Z.STREAM_ACTIVATED,{streamInfo:j}),void n(t)):void function(e,t){return V(e,t)}(e,t).then((function(e){s=!0,R.trigger(l.Z.STREAM_ACTIVATED,{streamInfo:j}),n(e)})).catch((function(e){r(e)}));n(t)}))},deactivate:W,getIsActive:function(){return s},getDuration:function(){return j?j.duration:NaN},getStartTime:$,getId:ee,getStreamInfo:te,getHasAudioTrack:function(){return g},getHasVideoTrack:function(){return d},startPreloading:function(e,t){return new Promise((function(i,a){ye()?a():(n.info("[startPreloading] Preloading next stream with id ".concat(ee())),me(!0),V(e,t).then((function(){for(var e=0;e<r.length&&r[e];e++)r[e].setExplicitBufferingTime($()),r[e].getScheduleController().startScheduleTimer();i()})).catch((function(){me(!1),a()})))}))},initializeForTextWithMediaSource:function(e){return new Promise((function(t,n){K(a.Z.TEXT,e).then((function(){return(e=fe(a.Z.TEXT))?e.createBufferSinks():Promise.resolve();var e})).then((function(){q.createTracks(j),t()})).catch((function(e){n(e)}))}))},getThumbnailController:function(){return y},getBitrateListFor:function(e){if(ne(),e===a.Z.IMAGE)return y?y.getBitrateList():[];var t=function(e){for(var t=null,n=0;n<r.length;n++)if((t=r[n]).getType()===e)return t.getMediaInfo();return null}(e);return k.getBitrateList(t)},updateData:function(e){return new Promise((function(t){p=!0,j=e,Z&&ie();for(var n=[],i=0,a=r.length;i<a;i++){var o=r[i],s=o.getMediaInfo();n.push(o.updateStreamInfo(j));var u=P.getAllMediaInfoForType(j,o.getType());if(u=u.filter((function(e){return!e.isEmbedded}))){o.clearMediaInfoArray();for(var c=0;c<u.length;c++){var f=u[c];o.addMediaInfo(u[c]),P.areMediaInfosEqual(s,f)&&(k.updateTopQualityIndex(f),n.push(o.selectMediaInfo(f)))}}}Promise.all(n).then((function(){for(n=[];A.length>0;){var e=A.pop(),t=e.newMediaInfo,r=ce(e.oldMediaInfo);if(!r)return;n.push(r.prepareTrackSwitch()),n.push(r.selectMediaInfo(t))}return Promise.all(n)})).then((function(){p=!1,oe(),R.trigger(l.Z.STREAM_UPDATED,{streamInfo:j}),t()}))}))},reset:function(e){m&&(m.reset(),m=null),k&&j&&k.clearDataForStream(j.id),E&&(E.reset(),E=null),X(e),j=null,R.off(l.Z.DATA_UPDATE_COMPLETED,ue,t),R.off(l.Z.BUFFERING_COMPLETED,se,t),R.off(l.Z.INBAND_EVENTS,le,t),G&&(R.off(l.Z.KEY_ERROR,re,t),R.off(l.Z.SERVER_CERTIFICATE_UPDATED,re,t),R.off(l.Z.LICENSE_REQUEST_COMPLETE,re,t),R.off(l.Z.KEY_SYSTEM_SELECTED,re,t),R.off(l.Z.KEY_SESSION_CREATED,re,t),R.off(l.Z.KEY_STATUSES_CHANGED,re,t))},getProcessors:de,setMediaSource:function(e){return new Promise((function(t,i){for(var a=[],o=0;o<r.length;)z(r[o].getMediaInfo())?(a.push(r[o].setMediaSource(e)),o++):(r[o].reset(),r.splice(o,1));Promise.all(a).then((function(){for(var e=0;e<r.length;e++)r[e].dischargePreBuffer();if(0===r.length){var i="No streams to play.";F.error(new S.Z(w.MANIFEST_ERROR_ID_NOSTREAMS_CODE,i+"nostreams",C.getValue())),n.fatal(i)}t()})).catch((function(e){n.error(e),i(e)}))}))},isMediaCodecCompatible:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;return pe(e,a.Z.VIDEO,t)&&pe(e,a.Z.AUDIO,t)},isProtectionCompatible:function(e){return!e||ge(a.Z.VIDEO,e)&&ge(a.Z.AUDIO,e)},getPreloaded:ye,getIsEndedEventSignaled:function(){return b},setIsEndedEventSignaled:J,getAdapter:function(){return P},getHasFinishedBuffering:function(){return c},setPreloaded:me,startScheduleControllers:function(){for(var e=r.length,t=0;t<e&&r[t];t++)r[t].getScheduleController().startScheduleTimer()},prepareTrackChange:function(e){if(s&&j){c=!1;var t=e.newMediaInfo,r=C.getValue();P.setCurrentMediaInfo(j.id,t.type,t);var i=ce(t);if(i){var o=U.getTime();n.info("Stream -  Process track changed at current time "+o),r.refreshManifestOnSwitchTrack?(A.push(e),M.getIsUpdating()||(n.debug("Stream -  Refreshing manifest for switch track"),M.refreshManifest())):i.selectMediaInfo(t).then((function(){t.type!==a.Z.VIDEO&&t.type!==a.Z.AUDIO||k.updateTopQualityIndex(t),i.prepareTrackSwitch()}))}}},prepareQualityChange:function(e){var t=fe(e.mediaType);t&&t.prepareQualityChange(e)}},function(){try{T=(0,f.Z)(I).getInstance(),n=T.getLogger(t),X(),_=(0,xt.Z)(I).getInstance(),E=kt(I).create({updateEventName:l.Z.SEGMENT_LOCATION_BLACKLIST_CHANGED,addBlacklistEventName:l.Z.SEGMENT_LOCATION_BLACKLIST_ADD}),m=Dt(I).create({streamInfo:j,mediaPlayerModel:D,dashMetrics:O,errHandler:F,settings:H,boxParser:_,dashConstants:o.Z,urlUtils:N})}catch(e){throw e}}(),t}Zt.__dashjs_factory_name="Stream";var Bt=c.Z.getClassFactory(Zt),Gt=function e(t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.url=t||null,this.type=C.w.CONTENT_STEERING_TYPE,this.responseType="json"},qt=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.version=null,this.ttl=300,this.reloadUri=null,this.pathwayPriority=[],this.pathwayClones=[]};function Yt(){var e,t,n,r,i,a,s,u,l,c,g,h,p,m,y,E=this.context,v=(0,Q.Z)(E).getInstance();function _(e){I(e,"baseUrl")}function T(e){I(e,"location")}function S(e){if(e&&e.request&&e.request.serviceLocation&&e.request.requestStartDate&&e.request.requestEndDate&&!isNaN(e.request.bytesTotal)){var t=e.request.serviceLocation,n=e.request.requestEndDate.getTime()-e.request.requestStartDate.getTime();A(t,parseInt(8*e.request.bytesTotal/n*1e3))}}function b(e){e&&e.httpRequest&&e.httpRequest._serviceLocation&&!isNaN(e.throughput)&&A(e.httpRequest._serviceLocation,1e3*e.throughput)}function A(e,t){i[e]||(i[e]=[]),i[e].push(t),i[e].length>4&&i[e].shift()}function I(e,t){if(e&&e.request&&e.request.serviceLocation){var n=e.request.serviceLocation;-1===r[t].all.indexOf(n)&&r[t].all.push(n),r[t].current=n}}function R(){var e=g.getValue(),t=y.getContentSteering(e);return t||(t=p.getServiceDescriptionSettings().contentSteering),t}function N(){return new Promise((function(e){try{var a=R();if(!a||!a.serverUrl)return void e();var u=function(e){var t=e.serverUrl;n&&n.reloadUri&&(t=v.isRelative(n.reloadUri)?v.resolve(n.reloadUri,e.serverUrl):n.reloadUri);var a=[],o=r.baseUrl.all.concat(r.location.all);if(o.length>0){var s=o.map((function(e){var t=function(e){if(!e||!i[e]||0===i[e].length)return-1;var t=i[e].reduce((function(e,t){return e+t}))/i[e].length;return parseInt(t)}(e);return{serviceLocation:e,throughput:t}}));s.sort((function(e,t){return t.throughput-e.throughput}));var u="",l="";s.forEach((function(e,t){0!==t&&(u="".concat(u,","),e.throughput>-1&&(l="".concat(l,","))),u="".concat(u).concat(e.serviceLocation),e.throughput>-1&&(l="".concat(l).concat(e.throughput))})),a.push({key:"_DASH_pathway",value:\'"\'.concat(u,\'"\')}),a.push({key:"_DASH_throughput",value:l})}return t=Be.Z.addAditionalQueryParameterToUrl(t,a)}(a),l=new Gt(u);s.load({request:l,success:function(t){!function(e){e&&e[o.Z.CONTENT_STEERING_RESPONSE.VERSION]&&1===parseInt(e[o.Z.CONTENT_STEERING_RESPONSE.VERSION])&&((n=new qt).version=e[o.Z.CONTENT_STEERING_RESPONSE.VERSION],e[o.Z.CONTENT_STEERING_RESPONSE.TTL]&&!isNaN(e[o.Z.CONTENT_STEERING_RESPONSE.TTL])&&(n.ttl=e[o.Z.CONTENT_STEERING_RESPONSE.TTL]),e[o.Z.CONTENT_STEERING_RESPONSE.RELOAD_URI]&&(n.reloadUri=e[o.Z.CONTENT_STEERING_RESPONSE.RELOAD_URI]),e[o.Z.CONTENT_STEERING_RESPONSE.PATHWAY_PRIORITY]&&(n.pathwayPriority=e[o.Z.CONTENT_STEERING_RESPONSE.PATHWAY_PRIORITY]),e[o.Z.CONTENT_STEERING_RESPONSE.PATHWAY_CLONES]&&(n.pathwayClones=e[o.Z.CONTENT_STEERING_RESPONSE.PATHWAY_CLONES],n.pathwayClones=n.pathwayClones.filter((function(e){return function(e){return e[o.Z.CONTENT_STEERING_RESPONSE.BASE_ID]&&e[o.Z.CONTENT_STEERING_RESPONSE.ID]&&e[o.Z.CONTENT_STEERING_RESPONSE.URI_REPLACEMENT]&&e[o.Z.CONTENT_STEERING_RESPONSE.URI_REPLACEMENT][o.Z.CONTENT_STEERING_RESPONSE.HOST]}(e)}))),O())}(t),m.trigger(d.Z.CONTENT_STEERING_REQUEST_COMPLETED,{currentSteeringResponseData:n,url:u}),e()},error:function(r,i,a,o){!function(e,r){try{switch(t.warn("Error fetching data from content steering server",e),r.status){case 410:break;case 429:var i=r&&r.getResponseHeader?r.getResponseHeader("retry-after"):null;null!==i&&(n||(n={}),n.ttl=parseInt(i)),O();break;default:O()}}catch(e){t.error(e)}}(r,o),e(r)},complete:function(){r.baseUrl.all=C(r.baseUrl),r.location.all=C(r.location)}})}catch(t){e(t)}}))}function C(e){return e.all&&0!==e.all.length&&e.current?e.all.filter((function(t){return t===e.current})):[]}function D(e){try{var r=[];return e&&0!==e.length&&n&&n.pathwayClones&&0!==n.pathwayClones.length?(n.pathwayClones.forEach((function(t){var n=e.filter((function(e){return t[o.Z.CONTENT_STEERING_RESPONSE.BASE_ID]===e.serviceLocation})),i=null;if(n&&n.length>0&&(i=n[0]),i){var a=new URL(i.url),s=t[o.Z.CONTENT_STEERING_RESPONSE.URI_REPLACEMENT][o.Z.CONTENT_STEERING_RESPONSE.HOST];s=Be.Z.stringHasProtocol(s)?s:"".concat(a.protocol,"//").concat(s);var u={synthesizedUrl:"".concat(s).concat(a.pathname),serviceLocation:t[o.Z.CONTENT_STEERING_RESPONSE.ID],queryParams:t[o.Z.CONTENT_STEERING_RESPONSE.URI_REPLACEMENT][o.Z.CONTENT_STEERING_RESPONSE.PARAMS],reference:i};r.push(u)}})),r):r}catch(e){return t.error(e),[]}}function O(){n&&n.ttl&&!isNaN(n.ttl)&&(a&&clearTimeout(a),a=setTimeout((function(){N()}),1e3*n.ttl))}function M(){a&&clearTimeout(a),a=null}function P(){n=null,i={},r={baseUrl:{current:null,all:[]},location:{current:null,all:[]}},M()}return e={reset:function(){P(),m.off(d.Z.FRAGMENT_LOADING_STARTED,_,e),m.off(d.Z.MANIFEST_LOADING_STARTED,T,e),m.off(d.Z.MANIFEST_LOADING_FINISHED,S,e),m.off(d.Z.THROUGHPUT_MEASUREMENT_STORED,b,e)},setConfig:function(e){e&&(e.adapter&&(y=e.adapter),e.errHandler&&(u=e.errHandler),e.dashMetrics&&(l=e.dashMetrics),e.mediaPlayerModel&&(c=e.mediaPlayerModel),e.requestModifier&&(h=e.requestModifier),e.manifestModel&&(g=e.manifestModel),e.serviceDescriptionController&&(p=e.serviceDescriptionController),e.eventBus&&(m=e.eventBus))},loadSteeringData:N,getCurrentSteeringResponseData:function(){return n},shouldQueryBeforeStart:function(){var e=R();return!!e&&e.queryBeforeStart},getSteeringDataFromManifest:R,stopSteeringRequestTimer:M,getSynthesizedBaseUrlElements:function(e){try{return D(e).map((function(e){var t=new Se(e.synthesizedUrl,e.serviceLocation);return t.queryParams=e.queryParams,t.dvb_priority=e.reference.dvb_priority,t.dvb_weight=e.reference.dvb_weight,t.availabilityTimeOffset=e.reference.availabilityTimeOffset,t.availabilityTimeComplete=e.reference.availabilityTimeComplete,t}))}catch(e){return t.error(e),[]}},getSynthesizedLocationElements:function(e){try{return D(e).map((function(e){var t=new Pe(e.synthesizedUrl,e.serviceLocation);return t.queryParams=e.queryParams,t}))}catch(e){return t.error(e),[]}},initialize:function(){s=vt(E).create({errHandler:u,dashMetrics:l,mediaPlayerModel:c,requestModifier:h,errors:w}),m.on(d.Z.FRAGMENT_LOADING_STARTED,_,e),m.on(d.Z.MANIFEST_LOADING_STARTED,T,e),m.on(d.Z.MANIFEST_LOADING_FINISHED,S,e),m.on(d.Z.THROUGHPUT_MEASUREMENT_STORED,b,e)}},t=(0,f.Z)(E).getInstance().getLogger(e),P(),e}Yt.__dashjs_factory_name="ContentSteeringController";var jt=c.Z.getSingletonFactory(Yt);function Ht(){var e,t,n,r=this.context,i=(0,N.Z)(r).getInstance();return e={select:function(e){if(!e||0===e.length)return null;var r=null;return i.get().streaming.applyContentSteering&&(r=function(e){var r=n.getCurrentSteeringResponseData();return r&&r.pathwayPriority&&r.pathwayPriority.length>0?function(){for(var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=0,i=null,a=function(){var a=e[r],o=n.findIndex((function(e){return e.serviceLocation&&e.serviceLocation===a}));if(-1!==o&&!t.contains(n[o].serviceLocation))return i=n[o],"break";r+=1};r<e.length&&"break"!==a(););return i}(r.pathwayPriority,e):null}(e)),r||(r=function(e){return e[0]}(e)),r},setConfig:function(e){e.blacklistController&&(t=e.blacklistController),e.contentSteeringController&&(n=e.contentSteeringController)},reset:function(){t.reset()}},t=kt(r).create({updateEventName:l.Z.SERVICE_LOCATION_LOCATION_BLACKLIST_CHANGED,addBlacklistEventName:l.Z.SERVICE_LOCATION_LOCATION_BLACKLIST_ADD}),n=jt(r).getInstance(),e}Ht.__dashjs_factory_name="LocationSelector";var Vt=c.Z.getClassFactory(Ht);function Kt(){var e,t,n,r,i,a,s,c,g,h,p,m,y,E,v=this.context,_=(0,u.Z)(v).getInstance(),T=(0,Q.Z)(v).getInstance();function S(){n=NaN,s=!1,i=!0,a=!1,b()}function b(){null!==r&&(clearTimeout(r),r=null)}function A(e){b(),a||(isNaN(e)&&!isNaN(n)&&(e=1e3*n),isNaN(e)||(t.debug("Refresh manifest in "+e+" milliseconds."),r=setTimeout(C,e)))}function I(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];s=!0;var t=g.getValue(),n=t.url,r=null,i=p.getPatchLocation(t),a=h.select(i),o=null;if(a&&!e)n=a.url,r=a.serviceLocation,o=a.queryParams;else{var u=R(t),l=h.select(u);l&&(n=l.url,r=l.serviceLocation,o=l.queryParams)}T.isRelative(n)&&(n=T.resolve(n,t.url)),c.load(n,r,o)}function R(e){var t=p.getLocation(e),n=y.getSynthesizedLocationElements(t);return t.concat(n)}function N(e){if(e){if(p.getIsPatch(e)){var r=e;e=g.getValue();var u=p.isPatchValid(e,r),c=u;if(u){var f=p.getPublishTime(e);c=p.applyPatchToManifest(e,r);var d=p.getPublishTime(e);c=f.getTime()!=d.getTime()}if(!c)return t.debug("Patch provided is invalid, performing full manifest refresh"),void I(!0);e.loadedTime=new Date}}else(e=g.getValue()).loadedTime=new Date;if(g.getValue()&&g.getValue().type===o.Z.DYNAMIC&&e.type===o.Z.STATIC)return _.trigger(l.Z.DYNAMIC_TO_STATIC),s=!1,void(a=!0);g.setValue(e);var h=new Date,m=(h.getTime()-e.loadedTime.getTime())/1e3;1e3*(n=p.getManifestUpdatePeriod(e,m))>2147483647&&(n=2147483.647),_.trigger(l.Z.MANIFEST_UPDATED,{manifest:e}),t.info("Manifest has been refreshed at "+h+"["+h.getTime()/1e3+"] "),i||A()}function C(){i||(s?A(E.get().streaming.manifestUpdateRetryInterval):I())}function D(e){e.error?e.error.code===w.MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE&&m.error(e.error):N(e.manifest)}function O(){i=!1,A()}function M(){(i=!E.get().streaming.scheduling.scheduleWhilePaused)&&b()}function P(){s=!1}return e={initialize:function(){S(),_.on(l.Z.STREAMS_COMPOSED,P,this),_.on(d.Z.PLAYBACK_STARTED,O,this),_.on(d.Z.PLAYBACK_PAUSED,M,this),_.on(l.Z.INTERNAL_MANIFEST_LOADED,D,this)},setManifest:function(e){N(e)},refreshManifest:I,getIsUpdating:function(){return s},setConfig:function(e){e&&(e.manifestModel&&(g=e.manifestModel),e.adapter&&(p=e.adapter),e.manifestLoader&&(c=e.manifestLoader),e.errHandler&&(m=e.errHandler),e.locationSelector&&(h=e.locationSelector),e.settings&&(E=e.settings),e.contentSteeringController&&(y=e.contentSteeringController))},reset:function(){_.off(d.Z.PLAYBACK_STARTED,O,this),_.off(d.Z.PLAYBACK_PAUSED,M,this),_.off(l.Z.STREAMS_COMPOSED,P,this),_.off(l.Z.INTERNAL_MANIFEST_LOADED,D,this),S()}},t=(0,f.Z)(v).getInstance().getLogger(e),h=Vt(v).create(),e}Kt.__dashjs_factory_name="ManifestUpdater";var zt=c.Z.getClassFactory(Kt);function Wt(){var e,t,n,r,i,a,o,s,c,d,g,h,p,m,y,E,v=this.context,_=(0,u.Z)(v).getInstance(),T=(0,Q.Z)(v).getInstance();function b(){s=[],c=[],d=null,g=null,p=null,h=NaN,n=!1,r=!1,m=i.get().streaming.utcSynchronization.timeBetweenSyncAttempts}function A(){i.get().streaming.utcSynchronization.enabled&&!n&&!r&&p&&p.value&&p.schemeIdUri&&!isNaN(h)&&!isNaN(i.get().streaming.utcSynchronization.backgroundAttempts)&&(g&&(Date.now()-g)/1e3<30||(s=[],r=!0,I(isNaN(i.get().streaming.utcSynchronization.backgroundAttempts)?2:i.get().streaming.utcSynchronization.backgroundAttempts)))}function I(e){try{if(e<=0)return void B();var t=Date.now();a[p.schemeIdUri](p.value,(function(n){var r=Date.now(),i=N(t,r,n);s.push(i),I(e-1)}),(function(){B()}))}catch(e){B()}}function R(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=e||0;if(!c||0===c.length||t>=c.length)D();else{var n=c[t];if(n)if(a.hasOwnProperty(n.schemeIdUri)){var r=(new Date).getTime();a[n.schemeIdUri](n.value,(function(e){var t=(new Date).getTime(),i=N(r,t,e);p=n,D(i)}),(function(){R(t+1)}))}else R(t+1);else D()}}function N(e,t,n){return n-(t-(t-e)/2)}function D(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:NaN,t=isNaN(e);t&&i.get().streaming.utcSynchronization.useManifestDateHeaderTimeSource?U():Z(t,e)}function O(e){var t=Date.parse(e);return isNaN(t)&&(t=function(e){var t,n,r=/^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})(?::([0-9]*)(\\.[0-9]*)?)?(?:([+\\-])([0-9]{2})([0-9]{2}))?/.exec(e);return t=Date.UTC(parseInt(r[1],10),parseInt(r[2],10)-1,parseInt(r[3],10),parseInt(r[4],10),parseInt(r[5],10),r[6]&&(parseInt(r[6],10)||0),r[7]&&1e3*parseFloat(r[7])||0),r[9]&&r[10]&&(n=60*parseInt(r[9],10)+parseInt(r[10],10),t+=("+"===r[8]?-1:1)*n*60*1e3),new Date(t).getTime()}(e)),t}function M(e){return Date.parse(e)}function P(e){return Date.parse(e)}function L(e,t,n){n()}function x(e,t,n){var r=O(e);isNaN(r)?n():t(r)}function F(e,t,n,r,i){var a,o,s=!1,u=new XMLHttpRequest,l=i?C.w.HEAD:C.w.GET,c=t.match(/\\S+/g);if(t=c.shift(),a=function(){s||(s=!0,c.length?F(e,c.join(" "),n,r,i):r())},o=function(){var t,r;200===u.status&&(t=i?u.getResponseHeader("Date"):u.response,r=e(t),isNaN(r)||(n(r),s=!0))},T.isRelative(t)){var f=E.resolve();f&&(t=T.resolve(t,f.url))}u.open(l,t),u.timeout=5e3,u.onload=o,u.onloadend=a,u.send()}function k(e,t,n){F(P,e,t,n,!0)}function U(){var e=o.getLatestMPDRequestHeaderValueByID("Date"),t=null!==e?new Date(e).getTime():Number.NaN;isNaN(t)?Z(!0):Z(!1,t-Date.now())}function Z(e,r){if(isNaN(h)||isNaN(r)||e||function(e){try{var n,r=G(e),a=isNaN(m)?30:m,o=isNaN(i.get().streaming.utcSynchronization.timeBetweenSyncAttemptsAdjustmentFactor)?2:i.get().streaming.utcSynchronization.timeBetweenSyncAttemptsAdjustmentFactor,s=isNaN(i.get().streaming.utcSynchronization.maximumTimeBetweenSyncAttempts)?600:i.get().streaming.utcSynchronization.maximumTimeBetweenSyncAttempts,u=isNaN(i.get().streaming.utcSynchronization.minimumTimeBetweenSyncAttempts)?2:i.get().streaming.utcSynchronization.minimumTimeBetweenSyncAttempts;r?(n=Math.min(a*o,s),t.debug("Increasing timeBetweenSyncAttempts to ".concat(n))):(n=Math.max(a/o,u),t.debug("Decreasing timeBetweenSyncAttempts to ".concat(n))),m=n}catch(e){}}(r),!e&&!isNaN(r)){d=Date.now(),n=!1;var a=isNaN(h);h=r,a&&A(),t.debug("Completed UTC sync. Setting client - server offset to ".concat(r))}e&&(p=null,n=!1,y.error(new S.Z(w.TIME_SYNC_FAILED_ERROR_CODE,w.TIME_SYNC_FAILED_ERROR_MESSAGE))),_.trigger(l.Z.UPDATE_TIME_SYNC_OFFSET,{offset:r}),_.trigger(l.Z.TIME_SYNCHRONIZATION_COMPLETED)}function B(){if(s&&0!==s.length){var e=s.reduce((function(e,t){return e+t}),0)/s.length;G(e)?t.debug("Completed background UTC sync. Offset is within allowed threshold and is not adjusted."):(t.debug("Completed background UTC sync. Setting client - server offset to ".concat(e)),h=e,_.trigger(l.Z.UPDATE_TIME_SYNC_OFFSET,{offset:h})),r=!1,g=Date.now()}}function G(e){try{if(isNaN(h))return!0;var t=i.get().streaming.utcSynchronization.maximumAllowedDrift&&!isNaN(i.get().streaming.utcSynchronization.maximumAllowedDrift)?i.get().streaming.utcSynchronization.maximumAllowedDrift:100;return e>=h-t&&e<=h+t}catch(e){return!0}}return e={initialize:function(){b(),a={"urn:mpeg:dash:utc:http-head:2014":k,"urn:mpeg:dash:utc:http-xsdate:2014":F.bind(null,O),"urn:mpeg:dash:utc:http-iso:2014":F.bind(null,M),"urn:mpeg:dash:utc:direct:2014":x,"urn:mpeg:dash:utc:http-head:2012":k,"urn:mpeg:dash:utc:http-xsdate:2012":F.bind(null,O),"urn:mpeg:dash:utc:http-iso:2012":F.bind(null,M),"urn:mpeg:dash:utc:direct:2012":x,"urn:mpeg:dash:utc:http-ntp:2014":L,"urn:mpeg:dash:utc:ntp:2014":L,"urn:mpeg:dash:utc:sntp:2014":L}},attemptSync:function(e,t){c=e,n||(function(e){try{if(!e||!i.get().streaming.utcSynchronization.enabled)return!1;var t=isNaN(m)?30:m;return!(d&&t&&!isNaN(t))||(Date.now()-d)/1e3>=t}catch(e){return!0}}(t)?(n=!0,R()):_.trigger(l.Z.TIME_SYNCHRONIZATION_COMPLETED))},setConfig:function(e){e&&(e.dashMetrics&&(o=e.dashMetrics),e.baseURLController&&(E=e.baseURLController),e.errHandler&&(y=e.errHandler),e.settings&&(i=e.settings))},reset:function(){b(),_.off(l.Z.ATTEMPT_BACKGROUND_SYNC,A,e)}},t=(0,f.Z)(v).getInstance().getLogger(e),_.on(l.Z.ATTEMPT_BACKGROUND_SYNC,A,e),e}Wt.__dashjs_factory_name="TimeSyncController";var Xt=c.Z.getSingletonFactory(Wt);Xt.HTTP_TIMEOUT_MS=5e3,c.Z.updateSingletonFactory(Wt.__dashjs_factory_name,Xt);var Qt=Xt;function Jt(){var e,t,n,r,i,a=this.context,o=(0,u.Z)(a).getInstance();return e={attachMediaSource:function(e){var n=window.URL.createObjectURL(t);return e.setSource(n),"managedMediaSource"===r&&(e.setDisableRemotePlayback(!0),t.addEventListener("startstreaming",(function(){o.trigger(d.Z.MANAGED_MEDIA_SOURCE_START_STREAMING)})),t.addEventListener("endstreaming",(function(){o.trigger(d.Z.MANAGED_MEDIA_SOURCE_END_STREAMING)}))),n},createMediaSource:function(){var e="WebKitMediaSource"in window,n="MediaSource"in window;return"ManagedMediaSource"in window?(t=new ManagedMediaSource,r="managedMediaSource",i.info("Created ManagedMediaSource")):n?(t=new MediaSource,r="mediaSource",i.info("Created MediaSource")):e&&(t=new WebKitMediaSource,i.info("Created WebkitMediaSource")),t},detachMediaSource:function(e){e.setSource(null)},setConfig:function(e){e&&e.settings&&(n=e.settings)},setDuration:function e(r){t&&"open"===t.readyState&&(null===r&&isNaN(r)||t.duration!==r&&(r!==1/0||n.get().streaming.buffer.mediaSourceDurationInfinity||(r=Math.pow(2,32)),function(e){for(var t=e.sourceBuffers,n=0;n<t.length;n++)if(t[n].updating)return!0;return!1}(t)?setTimeout(e.bind(null,r),50):(i.info("Set MediaSource duration:"+r),t.duration=r)))},setSeekable:function(e,n){t&&"function"==typeof t.setLiveSeekableRange&&"function"==typeof t.clearLiveSeekableRange&&"open"===t.readyState&&e>=0&&e<n&&(t.clearLiveSeekableRange(),t.setLiveSeekableRange(e,n))},signalEndOfStream:function(e){if(e&&"open"===e.readyState){for(var t=e.sourceBuffers,n=0;n<t.length;n++){if(t[n].updating)return;if(0===t[n].buffered.length)return}i.info("call to mediaSource endOfStream"),e.endOfStream()}}},i=(0,f.Z)(a).getInstance().getLogger(e),e}Jt.__dashjs_factory_name="MediaSourceController";var $t=c.Z.getSingletonFactory(Jt);function en(){var e,t,n,r,i,a,o,s,l,c,g,h="urn:mpeg:dash:event:2012",p="discarded",m="updated",y="added",E=this.context,v=(0,u.Z)(E).getInstance();function _(){if(!o||!s)throw new Error("setConfig function has to be called previously")}function T(){g=!1,n={},r={},i=null,c=!1,a=Date.now()/1e3}function S(){try{if(!c){c=!0;var e=s.getTime(),i=e-a;i=a>0?Math.max(0,i):0,b(r,i,e),b(n,i,e),A(r),A(n),a=e,c=!1}}catch(e){c=!1,t.error(e)}}function b(e,n,r){try{N(e,(function(i){if(void 0!==i){var a=isNaN(i.duration)?0:i.duration;i.calculatedPresentationTime<=r&&i.calculatedPresentationTime+n+a>=r?D(i,d.Z.EVENT_MODE_ON_START):(C(r,a+n,i.calculatedPresentationTime)||function(e){try{var n=e.eventStream.period.start+e.eventStream.period.duration;return e.calculatedPresentationTime>n}catch(e){return t.error(e),!1}}(i))&&(t.debug("Removing event ".concat(i.id," from period ").concat(i.eventStream.period.id," as it is expired or invalid")),function(e,n){try{var r=n.eventStream.schemeIdUri,i=n.eventStream.period.id,a=n.eventStream.value,o=n.id;e[i][r]=e[i][r].filter((function(e){return a&&e.eventStream.value&&e.eventStream.value!==a||e.id!==o})),0===e[i][r].length&&delete e[i][r]}catch(e){t.error(e)}}(e,i))}}))}catch(e){t.error(e)}}function A(e){try{for(var n in e)e.hasOwnProperty(n)&&0===Object.keys(e[n]).length&&delete e[n]}catch(e){t.error(e)}}function I(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=e.eventStream.schemeIdUri,i=e.eventStream.value,a=e.id,o=p;t[r]||(t[r]=[]);var s=t[r].findIndex((function(e){return(!i||e.eventStream.value&&e.eventStream.value===i)&&e.id===a}));if(-1===s)t[r].push(e),e.triggeredReceivedEvent=!1,e.triggeredStartEvent=!1,o=y;else if(n){var u=t[r][s];e.triggeredReceivedEvent=u.triggeredReceivedEvent,e.triggeredStartEvent=u.triggeredStartEvent,t[r][s]=e,o=m}return o}function R(e){try{if(1==e.eventStream.value){var n,r=e.calculatedPresentationTime;n=4294967295==e.calculatedPresentationTime?NaN:e.calculatedPresentationTime+e.duration,v.trigger(d.Z.MANIFEST_VALIDITY_CHANGED,{id:e.id,validUntil:r,newDuration:n,newManifestValidAfter:NaN},{mode:d.Z.EVENT_MODE_ON_START})}}catch(e){t.error(e)}}function w(e){try{var n=s.getTime();N(e,(function(e){var t=e.eventStream&&e.eventStream.period&&!isNaN(e.eventStream.period.duration)?e.eventStream.period.duration:NaN,r=e.eventStream&&e.eventStream.period&&!isNaN(e.eventStream.period.start)?e.eventStream.period.start:NaN;if(!isNaN(t)&&!isNaN(r)){var i=e.calculatedPresentationTime;Math.abs(i-n)<300&&D(e,d.Z.EVENT_MODE_ON_START)}}))}catch(e){t.error(e)}}function N(e,n){try{if(e)for(var r=Object.keys(e),i=0;i<r.length;i++)for(var a=e[r[i]],o=Object.keys(a),s=0;s<o.length;s++)a[o[s]].forEach((function(e){void 0!==e&&n(e)}))}catch(e){t.error(e)}}function C(e,n,r){try{return e-n>r}catch(e){return t.error(e),!1}}function D(e,n){try{var r=s.getTime(),i=e.id;if(n===d.Z.EVENT_MODE_ON_RECEIVE&&!e.triggeredReceivedEvent)return t.debug("Received event ".concat(i)),e.triggeredReceivedEvent=!0,void v.trigger(e.eventStream.schemeIdUri,{event:e},{mode:n});e.triggeredStartEvent||(e.eventStream.schemeIdUri===h&&1==e.eventStream.value?0===e.duration&&0===e.presentationTimeDelta||(t.debug("Starting manifest refresh event ".concat(i," at ").concat(r)),function(){try{_(),o.refreshManifest()}catch(e){t.error(e)}}()):"urn:mpeg:dash:event:callback:2015"===e.eventStream.schemeIdUri&&1==e.eventStream.value?(t.debug("Starting callback event ".concat(i," at ").concat(r)),function(e){try{(0,se.Z)(E).create({}).load({method:"get",url:e,request:{responseType:"arraybuffer"}})}catch(e){t.error(e)}}(e.messageData)):(t.debug("Starting event ".concat(i," from period ").concat(e.eventStream.period.id," at ").concat(r)),v.trigger(e.eventStream.schemeIdUri,{event:e},{mode:n})),e.triggeredStartEvent=!0)}catch(e){t.error(e)}}return e={addInlineEvents:function(e,r){try{if(_(),n[r]||(n[r]={}),e)for(var i=0;i<e.length;i++){var a=e[i];if(!C(s.getTime(),isNaN(a.duration)?0:a.duration,a.calculatedPresentationTime)){var o=I(a,n[r],!0);o===y?(t.debug("Added inline event with id ".concat(a.id," from period ").concat(r)),D(a,d.Z.EVENT_MODE_ON_RECEIVE)):o===m&&t.debug("Updated inline event with id ".concat(a.id," from period ").concat(r))}}}catch(e){throw e}},addInbandEvents:function(e,n){try{_(),r[n]||(r[n]={});for(var i=0;i<e.length;i++){var a=e[i];C(s.getTime(),isNaN(a.duration)?0:a.duration,a.calculatedPresentationTime)||(I(a,r[n],!1)===y?(a.eventStream.schemeIdUri===h&&R(a),t.debug("Added inband event with id ".concat(a.id," from period ").concat(n)),D(a,d.Z.EVENT_MODE_ON_RECEIVE)):t.debug("Inband event with scheme_id_uri ".concat(a.eventStream.schemeIdUri,", value ").concat(a.eventStream.value,", period id ").concat(n," and event id ").concat(a.id," was ignored because it has been added before.")))}S()}catch(e){throw e}},getInbandEvents:function(){return r},getInlineEvents:function(){return n},start:function(){try{_(),t.debug("Start Event Controller");var e=l.get().streaming.eventControllerRefreshDelay;g||isNaN(e)||(g=!0,i=setInterval(S,e))}catch(e){throw e}},setConfig:function(e){try{if(!e)return;e.manifestUpdater&&(o=e.manifestUpdater),e.playbackController&&(s=e.playbackController),e.settings&&(l=e.settings)}catch(e){throw e}},reset:function(){(function(){try{null!==i&&g&&(clearInterval(i),i=null,g=!1,function(){try{w(r),w(n)}catch(e){t.error(e)}}())}catch(e){throw e}})(),T()}},t=(0,f.Z)(E).getInstance().getLogger(e),T(),e}en.__dashjs_factory_name="EventController";var tn=c.Z.getSingletonFactory(en),nn={LEVELS:{SUGGESTION:"Suggestion",WARNING:"Warning",ERROR:"Error"},EVENTS:{NO_UTC_TIMING_ELEMENT:{key:"NO_UTC_TIMING_ELEMENT",message:"No UTCTiming element is present in the manifest. You may experience playback failures. For a detailed validation use https://conformance.dashif.org/"},NON_COMPLIANT_SMPTE_IMAGE_ATTRIBUTE:{key:"NON_COMPLIANT_SMPTE_IMAGE_ATTRIBUTE",message:\'SMPTE 2052-1:2013 defines the attribute name as "imageType" and does not define "imagetype"\'},INVALID_DVR_WINDOW:{key:"INVALID_DVR_WINDOW",message:"No valid segment found when applying a specification compliant DVR window calculation. Using SegmentTimeline entries as a fallback."}}};function rn(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}function an(){var e,t,n,r,i,o,c,g,h,p,m,y,E,v,_,T,b,A,I,R,N,C,D,O,M,P,L,F,k,U,Z,B,G,q,Y,j,H,V,K,z,W,X,Q,J,te,ne,re,ie,ae=this.context,oe=(0,u.Z)(ae).getInstance();function se(){if(!(o&&o.hasOwnProperty("load")&&N&&N.hasOwnProperty("initialize")&&N.hasOwnProperty("reset")&&N.hasOwnProperty("getClientTimeOffset")&&c&&R&&h&&G))throw new Error(a.Z.MISSING_CONFIG_ERROR)}function ue(){if(!i||!i.hasOwnProperty("setManifest"))throw new Error("initialize function has to be called previously")}function le(){!function(){try{var e=g.getStreamsInfo();if(!D&&0===e.length)throw new Error("There are no periods in the MPD");D&&e.length>0&&h.updateManifestUpdateInfo({currentTime:G.getTime(),buffered:B.getBufferRange(),presentationStartTime:e[0].start,clientTimeOffset:N.getClientTimeOffset()}),C.length>0&&function(e){0!==e.length?C=C.filter((function(n){var r=e.filter((function(e){return e.id===n.getId()})).length>0||n.getId()===D.getId();return r||(t.debug("Removing stream ".concat(n.getId())),n.reset(!0)),r})):t.warn("No periods included in the current manifest. Skipping the filtering of outdated stream objects.")}(e);for(var n=[],r=0,i=e.length;r<i;r++){var a=e[r];n.push(fe(a)),h.addManifestUpdateStreamInfo(a)}Promise.all(n).then((function(){return new Promise((function(t,n){D?t():de(e,t,n)}))})).then((function(){oe.trigger(l.Z.STREAMS_COMPOSED),Me()})).catch((function(e){throw e}))}catch(e){R.error(new S.Z(w.MANIFEST_ERROR_ID_NOSTREAMS_CODE,e.message+" nostreamscomposed",c.getValue())),U=!0,Qe()}}()}function ce(){te=!0}function fe(e){var t=ze(e.id);return t?t.updateData(e):(t=Bt(ae).create({manifestModel:c,mediaPlayerModel:Y,dashMetrics:h,manifestUpdater:i,adapter:g,timelineConverter:N,capabilities:n,capabilitiesFilter:r,errHandler:R,baseURLController:E,segmentBaseController:v,textController:M,abrController:T,playbackController:G,eventController:A,mediaController:b,protectionController:O,videoModel:B,streamInfo:e,settings:J}),C.push(t),t.initialize(),Promise.resolve())}function de(e,n,r){try{Ae();var i=h.getCurrentDVRInfo().range;if(i.end<i.start){ne&&clearTimeout(ne);var a=Math.min(1e3*(-1*(i.end-i.start)+2),2147483647);return t.debug("Waiting for ".concat(a," ms before playback can start")),oe.trigger(l.Z.AST_IN_FUTURE,{delay:a}),void(ne=setTimeout((function(){de(e,n,r)}),a))}J.get().streaming.applyProducerReferenceTime&&q.calculateProducerReferenceTimeOffsets(e);var o=e[0].manifestInfo;if(J.get().streaming.applyServiceDescription&&q.applyServiceDescription(o),g.getIsDynamic()){var s=Be(e,o);G.computeAndSetLiveDelay(s,o)}(J.get().streaming.applyContentSteering&&y.shouldQueryBeforeStart()?y.loadSteeringData():Promise.resolve()).then((function(){var e=c.getValue();e&&E.update(e),ge(),n()})).catch((function(e){t.error(e),ge(),n()}))}catch(e){r(e)}}function ge(){var e=function(){var e;if(g.getIsDynamic()){var n=h.getCurrentDVRInfo();e=(n&&n.range?n.range.end:0)-G.getOriginalLiveDelay();var r=n?n.range:null;if(r){if(isNaN(re)&&-1===re.toString().indexOf("posix:")){var i=ke(!0);isNaN(i)||(t.info("Start time from URI parameters: ".concat(i)),e=Math.min(e,i))}else{t.info("Start time provided by the app: ".concat(re));var a=Ue(!0,re);isNaN(a)||(e=Math.min(e,a))}var o=J.get().streaming.timeShiftBuffer.calcFromSegmentTimeline?.1:0;e=Math.max(e,r.start+o)}}else if(e=$e()[0].getStreamInfo().start,isNaN(re)){var s=ke(!1);isNaN(s)||(t.info("Start time from URI parameters: ".concat(s)),e=Math.max(e,s))}else{t.info("Start time provided by the app: ".concat(re));var u=Ue(!1,re);isNaN(u)||(e=Math.max(e,u))}return e}(),n=be(e),r=null!==n?n:C[0];oe.trigger(l.Z.INITIAL_STREAM_SWITCH,{startTime:e}),he(r,null,e),z||(z=setInterval((function(){!F&&G.getTimeToStreamEnd()<=0&&!G.isSeeking()&&oe.trigger(l.Z.PLAYBACK_ENDED,{isLast:Ke().isLast})}),200))}function he(e,n,r){try{if(F||!e||n===e&&e.getIsActive())return;F=!0,oe.trigger(l.Z.PERIOD_SWITCH_STARTED,{fromStreamInfo:n?n.getStreamInfo():null,toStreamInfo:e.getStreamInfo()});var i=!1;D=e,n&&(i=Te(e,n),n.deactivate(i)),r=isNaN(r)?!i&&n?e.getStreamInfo().start:NaN:r,t.info("Switch to stream ".concat(e.getId(),". Seektime is ").concat(r,", current playback time is ").concat(G.getTime(),". Seamless period switch is set to ").concat(i)),X=X.filter((function(e){return e.getId()!==D.getId()})),G.initialize(Ke(),!!n),B.getElement()?pe(r,i,!1):me(r,i)}catch(e){F=!1}}function pe(e,n){var r,i=arguments.length>2&&void 0!==arguments[2]&&arguments[2];function a(){if(Z&&"open"===Z.readyState){t.debug("MediaSource is open!"),window.URL.revokeObjectURL(r),Z.removeEventListener("sourceopen",a),Z.removeEventListener("webkitsourceopen",a),Fe();var o=h.getCurrentDVRInfo();p.setSeekable(o.range.start,o.range.end),i?(isNaN(e)||G.seek(e,!0,!0),D.setMediaSource(Z).then((function(){D.initializeForTextWithMediaSource(Z)}))):me(e,n)}}function o(){Z.addEventListener("sourceopen",a,!1),Z.addEventListener("webkitsourceopen",a,!1),r=p.attachMediaSource(B),t.debug("MediaSource attached to element.  Waiting on open...")}Z?n?me(e,n):(p.detachMediaSource(B),o()):(Z=p.createMediaSource(),o())}function me(e,t){D.activate(Z,t?W:void 0,e).then((function(t){if(t){var n=Object.keys(t);n.length>0&&t[n[0]].getBuffer().changeType&&(Q=!0),W=t}isNaN(e)||(oe.trigger(l.Z.SEEK_TARGET,{time:e},{streamId:D.getId()}),G.seek(e,!1,!0),D.startScheduleControllers()),F=!1,oe.trigger(l.Z.PERIOD_SWITCH_COMPLETED,{toStreamInfo:Ke()})}))}function ye(e){var t=be(e.seekTime);t&&t!==D?t&&t!==D&&(Ee(),function(e,t){var n=e&&!isNaN(e.seekTime)?e.seekTime:NaN,r=D.getProcessors().map((function(t){return t.prepareOuterPeriodPlaybackSeeking(e)}));Promise.all(r).then((function(){he(t,D,n)})).catch((function(e){R.error(e)}))}(e,t)):(Ee(),function(e){D.getProcessors().forEach((function(t){return t.prepareInnerPeriodPlaybackSeeking(e)})),je(ee.USER_REQUEST_STOP_REASON)}(e)),He($.SEEK_START_REASON)}function Ee(){ve()}function ve(){X&&X.length>0&&(X.forEach((function(e){e.deactivate(!0)})),X=[])}function _e(e){if(e.newMediaInfo.streamInfo.id===D.getId()){if(ve(),J.get().streaming.buffer.resetSourceBuffersForTrackSwitch&&e.oldMediaInfo&&e.oldMediaInfo.codec!==e.newMediaInfo.codec){var t=G.getTime();return D.deactivate(!1),void pe(t,!1,!1)}D.prepareTrackChange(e)}}function Te(e,t){try{return J.get().streaming.buffer.reuseExistingSourceBuffers&&(t.isProtectionCompatible(e)||te)&&(Q&&J.get().streaming.buffer.useChangeTypeForTrackSwitch||t.isMediaCodecCompatible(e,t))}catch(e){return!1}}function Se(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;if(Z&&!e.getPreloaded()){var n=Te(e,t);n&&e.startPreloading(Z,W).then((function(){X.push(e)}))}}function be(e){if(isNaN(e))return null;for(var t=C.length,n=0;n<t;n++){var r=C[n];if(e<parseFloat((r.getStartTime()+r.getDuration()).toFixed(5)))return r}return null}function Ae(){try{var e=g.getIsDynamic(),t=g.getStreamsInfo()[0].manifestInfo,n=G.getTime(),r=N.calcTimeShiftBufferWindow(C,e),i=Le();if(void 0===r.start||void 0===r.end)return;i&&0!==i.length?i.forEach((function(e){h.addDVRInfo(e.getType(),n,t,r)})):h.addDVRInfo(a.Z.VIDEO,n,t,r)}catch(e){}}function Ie(e){if(V&&L){var t=Y.getInitialBufferLevel(),n=[a.Z.TEXT];(isNaN(t)||t<=G.getBufferLevel(n)||g.getIsDynamic()&&t>G.getLiveDelay())&&(V=!1,He($.INITIAL_PLAYOUT_START_REASON),G.play())}e&&e.mediaType&&h.addBufferLevel(e.mediaType,new Date,1e3*e.bufferLevel)}function Re(e){e.streamInfo.id===D.getId()&&e.reason&&e.reason.forceReplace&&ve(),ze(e.streamInfo.id).prepareQualityChange(e)}function we(){if(g.getIsDynamic()&&0!==G.getOriginalLiveDelay()&&D){var e=g.getStreamsInfo();if(e.length>0){var t=e[0].manifestInfo,n=Be(e,t);G.computeAndSetLiveDelay(n,t)}}}function Ne(){if(qe()){var e=B.getPlaybackQuality();e&&h.addDroppedFrames(e)}}function Ce(){t.debug("[onPlaybackStarted]"),!V&&H&&He($.RESUME_FROM_PAUSE_START_REASON),V&&(V=!1),K&&(K=!1,J.get().streaming.applyContentSteering&&!y.shouldQueryBeforeStart()&&y.loadSteeringData()),H=!1}function De(e){t.debug("[onPlaybackPaused]"),e.ended||(H=!0,je(ee.USER_REQUEST_STOP_REASON))}function Oe(e){t.debug("Stream with id ".concat(e.streamInfo.id," finished buffering"));var n=e.streamInfo.isLast;Z&&n?(t.info("[onStreamBufferingCompleted] calls signalEndOfStream of mediaSourceController."),p.signalEndOfStream(Z)):Me()}function Me(){if(D&&D.getHasFinishedBuffering())for(var e=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;try{var t=e||D||null;if(t){var n=t.getStreamInfo();return C.filter((function(e){var t=e.getStreamInfo();return t.start>n.start&&n.id!==t.id}))}}catch(e){return[]}}(D),t=0;t<e.length;){var n=e[t],r=0===t?D:e[t-1];!n.getPreloaded()&&r.getHasFinishedBuffering()&&Z&&Se(n,r),t+=1}}function Pe(){z&&(clearInterval(z),z=null)}function Le(){return D?D.getProcessors():[]}function xe(e){if(D&&!D.getIsEndedEventSignaled()){D.setIsEndedEventSignaled(!0);var n=function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,t=e||D||null;if(!t)return null;for(var n=t.getStreamInfo(),r=n.start,i=0,a=-1,o=NaN;i<C.length;){var s=C[i].getStreamInfo(),u=s.start-r;u>0&&(isNaN(o)||u<o)&&n.id!==s.id&&(o=u,a=i),i+=1}return a>=0?C[a]:null}();n?(t.debug("StreamController onEnded, found next stream with id ".concat(n.getStreamInfo().id,". Switching from ").concat(D.getStreamInfo().id," to ").concat(n.getStreamInfo().id)),he(n,D,NaN)):(t.debug("StreamController no next stream found"),D.setIsEndedEventSignaled(!1)),je(n?ee.END_OF_PERIOD_STOP_REASON:ee.END_OF_CONTENT_STOP_REASON)}e&&e.isLast&&(Pe(),y.stopSteeringRequestTimer())}function Fe(e){var t=e||Ke().manifestInfo.duration;p.setDuration(t)}function ke(e){var t=_.getURIFragmentData();if(!t||!t.t)return NaN;var n=$e()[0].getStreamInfo().start;return t.t=t.t.split(",")[0],Ze(e,t.t,n)}function Ue(e,t){var n=0;return e||(n=$e()[0].getStreamInfo().start),Ze(e,t,n)}function Ze(e,t,n){var r=g.getRegularPeriods()[0],i=t.toString(),a=-1!==i.indexOf("posix:")?"now"===i.substring(6)?Date.now()/1e3:parseFloat(i.substring(6)):NaN;return e&&!isNaN(a)?N.calcPresentationTimeFromWallTime(new Date(1e3*a),r):parseFloat(i)+n}function Be(e,t){try{var n=NaN;if(t&&!isNaN(t.maxFragmentDuration)&&isFinite(t.maxFragmentDuration))return t.maxFragmentDuration;if(e&&1===e.length){var r=e[0],i=[a.Z.VIDEO,a.Z.AUDIO,a.Z.TEXT].reduce((function(e,t){var n=g.getMediaInfoForType(r,t);return n&&!1!==n.isFragmented&&e.push(n),e}),[]).reduce((function(e,t){var n=g.getVoRepresentations(t);return n&&n.length>0&&n.forEach((function(t){t&&e.push(t)})),e}),[]).reduce((function(e,t){var n=g.convertRepresentationToRepresentationInfo(t);return n&&n.fragmentDuration&&!isNaN(n.fragmentDuration)&&e.push(n.fragmentDuration),e}),[]);n=Math.max.apply(Math,function(e){if(Array.isArray(e))return rn(e)}(o=i)||function(e){if("undefined"!=typeof Symbol&&Symbol.iterator in Object(e))return Array.from(e)}(o)||function(e,t){if(e){if("string"==typeof e)return rn(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?rn(e,t):void 0}}(o)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}())}return isFinite(n)?n:NaN}catch(e){return NaN}var o}function Ge(e){if(e.error)U=!0,Qe();else{t.info("Manifest updated... updating data system wide.");var n=e.manifest;g.updatePeriods(n);var i=g.getUTCTimingSources();!g.getIsDynamic()||i&&0!==i.length||oe.trigger(d.Z.CONFORMANCE_VIOLATION,{level:nn.LEVELS.WARNING,event:nn.EVENTS.NO_UTC_TIMING_ELEMENT});var a=g.getIsDynamic()?i.concat(j.getUTCTimingSources()):i;r.filterUnsupportedFeatures(n).then((function(){E.initialize(n),m.attemptSync(a,g.getIsDynamic())}))}}function qe(){return!!D&&D.getHasVideoTrack()}function Ye(){return!!D&&D.getHasAudioTrack()}function je(e,t){t=t||new Date,Le().forEach((function(n){n.finalisePlayList(t,e)})),h.addPlayList()}function He(e){h.createPlaylistMetrics(1e3*G.getTime(),e)}function Ve(e){if(e.error){var n="";switch(e.error.code){case 1:n="MEDIA_ERR_ABORTED";break;case 2:n="MEDIA_ERR_NETWORK";break;case 3:n="MEDIA_ERR_DECODE",ie.counts.mediaErrorDecode+=1;break;case 4:n="MEDIA_ERR_SRC_NOT_SUPPORTED";break;case 5:n="MEDIA_ERR_ENCRYPTED";break;default:n="UNKNOWN"}"MEDIA_ERR_DECODE"===n&&J.get().errors.recoverAttempts.mediaErrorDecode>=ie.counts.mediaErrorDecode?function(){t.warn("A MEDIA_ERR_DECODE occured: Resetting the MediaSource");var e=G.getTime();D.deactivate(!1),t.warn("MediaSource has been resetted. Resuming playback from time ".concat(e)),pe(e,!1,!1)}():(k=!0,e.error.message&&(n+=" ("+e.error.message+")"),e.error.msExtendedCode&&(n+=" (0x"+(e.error.msExtendedCode>>>0).toString(16).toUpperCase()+")"),t.fatal("Video Element Error: "+n),e.error&&t.fatal(e.error),R.error(new S.Z(e.error.code,n)),Qe())}}function Ke(){return D?D.getStreamInfo():null}function ze(e){for(var t=0,n=C.length;t<n;t++)if(C[t].getId()===e)return C[t];return null}function We(e){isNaN(e.newDuration)||Fe(e.newDuration)}function Xe(){C=[],re=NaN,O=null,F=!1,D=null,k=!1,U=!1,V=!0,K=!0,H=!1,L=!0,z=null,te=!1,Q=!1,X=[],ne=null,ie={counts:{mediaErrorDecode:0}}}function Qe(){se(),m.reset(),je(k||U?ee.FAILURE_STOP_REASON:ee.USER_REQUEST_STOP_REASON);for(var t=0,n=C?C.length:0;t<n;t++)C[t].reset(k);oe.off(d.Z.PLAYBACK_TIME_UPDATED,Ne,e),oe.off(d.Z.PLAYBACK_SEEKING,ye,e),oe.off(d.Z.PLAYBACK_ERROR,Ve,e),oe.off(d.Z.PLAYBACK_STARTED,Ce,e),oe.off(d.Z.PLAYBACK_PAUSED,De,e),oe.off(d.Z.PLAYBACK_ENDED,xe,e),oe.off(d.Z.METRIC_ADDED,Je,e),oe.off(d.Z.MANIFEST_VALIDITY_CHANGED,We,e),oe.off(d.Z.BUFFER_LEVEL_UPDATED,Ie,e),oe.off(d.Z.QUALITY_CHANGE_REQUESTED,Re,e),l.Z.KEY_SESSION_UPDATED&&oe.off(l.Z.KEY_SESSION_UPDATED,ce,e),oe.off(l.Z.MANIFEST_UPDATED,Ge,e),oe.off(l.Z.STREAM_BUFFERING_COMPLETED,Oe,e),oe.off(l.Z.TIME_SYNCHRONIZATION_COMPLETED,le,e),oe.off(l.Z.CURRENT_TRACK_CHANGED,_e,e),oe.off(l.Z.SETTING_UPDATED_LIVE_DELAY,we,e),oe.off(l.Z.SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT,we,e),E.reset(),i.reset(),A.reset(),h.clearAllCurrentMetrics(),c.setValue(null),o.reset(),N.reset(),I.reset(),Z&&(p.detachMediaSource(B),Z=null),B=null,O&&(O=null,P=null,c.getValue()&&oe.trigger(l.Z.PROTECTION_DESTROYED,{data:c.getValue().url})),Pe(),oe.trigger(l.Z.STREAM_TEARDOWN_COMPLETE),Xe()}function Je(e){if(e.metric===s.Z.DVR_INFO){var t=Ye()?a.Z.AUDIO:a.Z.VIDEO;e.mediaType===t&&p.setSeekable(e.value.range.start,e.value.range.end)}}function $e(){return C}return e={initialize:function(t,n){se(),L=t,P=n,N.initialize(),(i=zt(ae).create()).setConfig({manifestModel:c,adapter:g,manifestLoader:o,errHandler:R,settings:J,contentSteeringController:y}),i.initialize(),(A=tn(ae).getInstance()).setConfig({manifestUpdater:i,playbackController:G,settings:J}),A.start(),m.setConfig({dashMetrics:h,baseURLController:E,errHandler:R,settings:J}),m.initialize(),p.setConfig({settings:J}),O&&(oe.trigger(l.Z.PROTECTION_CREATED,{controller:O}),O.setMediaElement(B.getElement()),P&&O.setProtectionData(P)),oe.on(d.Z.PLAYBACK_TIME_UPDATED,Ne,e),oe.on(d.Z.PLAYBACK_SEEKING,ye,e),oe.on(d.Z.PLAYBACK_ERROR,Ve,e),oe.on(d.Z.PLAYBACK_STARTED,Ce,e),oe.on(d.Z.PLAYBACK_PAUSED,De,e),oe.on(d.Z.PLAYBACK_ENDED,xe,e),oe.on(d.Z.METRIC_ADDED,Je,e),oe.on(d.Z.MANIFEST_VALIDITY_CHANGED,We,e),oe.on(d.Z.BUFFER_LEVEL_UPDATED,Ie,e),oe.on(d.Z.QUALITY_CHANGE_REQUESTED,Re,e),l.Z.KEY_SESSION_UPDATED&&oe.on(l.Z.KEY_SESSION_UPDATED,ce,e),oe.on(l.Z.MANIFEST_UPDATED,Ge,e),oe.on(l.Z.STREAM_BUFFERING_COMPLETED,Oe,e),oe.on(l.Z.TIME_SYNCHRONIZATION_COMPLETED,le,e),oe.on(l.Z.CURRENT_TRACK_CHANGED,_e,e),oe.on(l.Z.SETTING_UPDATED_LIVE_DELAY,we,e),oe.on(l.Z.SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT,we,e)},getActiveStreamInfo:Ke,addDVRMetric:Ae,hasVideoTrack:qe,hasAudioTrack:Ye,getStreamById:ze,getStreamForTime:be,getTimeRelativeToStreamId:function(e,t){for(var n=null,r=0,i=0,a=null,o=0;o<C.length;o++){if(i=(n=C[o]).getStartTime(),a=n.getDuration(),Number.isFinite(i)&&(r=i),n.getId()===t)return e-r;Number.isFinite(a)&&(r+=a)}return null},load:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:NaN;se(),re=t,o.load(e)},loadWithManifest:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:NaN;ue(),re=t,i.setManifest(e)},getActiveStreamProcessors:Le,setConfig:function(e){e&&(e.capabilities&&(n=e.capabilities),e.capabilitiesFilter&&(r=e.capabilitiesFilter),e.manifestLoader&&(o=e.manifestLoader),e.manifestModel&&(c=e.manifestModel),e.mediaPlayerModel&&(Y=e.mediaPlayerModel),e.customParametersModel&&(j=e.customParametersModel),e.protectionController&&(O=e.protectionController),e.adapter&&(g=e.adapter),e.dashMetrics&&(h=e.dashMetrics),e.errHandler&&(R=e.errHandler),e.timelineConverter&&(N=e.timelineConverter),e.videoModel&&(B=e.videoModel),e.playbackController&&(G=e.playbackController),e.serviceDescriptionController&&(q=e.serviceDescriptionController),e.contentSteeringController&&(y=e.contentSteeringController),e.textController&&(M=e.textController),e.abrController&&(T=e.abrController),e.mediaController&&(b=e.mediaController),e.settings&&(J=e.settings),e.baseURLController&&(E=e.baseURLController),e.uriFragmentModel&&(_=e.uriFragmentModel),e.segmentBaseController&&(v=e.segmentBaseController))},setProtectionData:function(e){P=e,O&&O.setProtectionData(P)},getIsStreamSwitchInProgress:function(){return F},switchToVideoElement:function(e){D&&(G.initialize(Ke()),pe(e,!1,!0))},getHasMediaOrInitialisationError:function(){return k||U},getStreams:$e,getActiveStream:function(){return D},getInitialPlayback:function(){return V},getAutoPlay:function(){return L},reset:Qe},t=(0,f.Z)(ae).getInstance().getLogger(e),m=Qt(ae).getInstance(),p=$t(ae).getInstance(),I=x(ae).getInstance(),Xe(),e}an.__dashjs_factory_name="StreamController";var on=c.Z.getSingletonFactory(an);function sn(){var e,t,n,r,i,o,s,c,d,g,h,p,m=this.context,y=(0,u.Z)(m).getInstance();function E(){p.debug("Stopping the gap controller"),i&&(clearInterval(i),i=null),function(){y.off(l.Z.WALLCLOCK_TIME_UPDATED,b,this),y.off(l.Z.INITIAL_STREAM_SWITCH,S,this),y.off(l.Z.PLAYBACK_SEEKING,v,this),y.off(l.Z.BUFFER_REPLACEMENT_STARTED,_,e),y.off(l.Z.TRACK_CHANGE_RENDERED,T,e)}(),i=null,o=NaN,r=0,g=null,h={}}function v(){g&&(clearTimeout(g),g=null)}function _(e){try{if(e.streamId!==c.getActiveStreamInfo().id||e.mediaType!==a.Z.VIDEO&&e.mediaType!==a.Z.AUDIO)return;e.streamId===c.getActiveStreamInfo().id&&(h[e.mediaType]=!0)}catch(e){p.error(e)}}function T(e){e&&e.mediaType&&(h[e.mediaType]=!1)}function S(){i||function(){try{i||(p.debug("Starting the gap controller"),i=setInterval((function(){A()&&N(s.getTime())}),100))}catch(e){}}()}function b(){if(A(n.get().streaming.gaps.enableSeekFix)&&++r>=10){var e=s.getTime();t===e?N(e,!0):(t=e,o=NaN),r=0}}function A(){var e=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!c.getActiveStream())return!1;var t=Object.keys(h).some((function(e){return h[e]})),r=!!e&&I();return!t&&n.get().streaming.gaps.jumpGaps&&c.getActiveStreamProcessors().length>0&&(!s.isSeeking()||r)&&!s.isPaused()&&!c.getIsStreamSwitchInProgress()&&!c.getHasMediaOrInitialisationError()}function I(){var e=c.getActiveStream(),t=parseFloat((e.getStartTime()+e.getDuration()).toFixed(5));return s.getTime()+n.get().streaming.gaps.threshold>=t}function R(e,t){try{if(!e||e.length<=1&&t>0)return NaN;for(var r=NaN,i=0;isNaN(r)&&i<e.length;){var a=i>0?e.end(i-1):0;t<e.start(i)&&a-t<n.get().streaming.gaps.threshold&&(r=i),i+=1}return r}catch(e){return null}}function w(e,t){for(var n=0,r=e.length;n<r;n++)if(t>=e.start(n)&&t<=e.end(n))return!0;return!1}function N(e){var t,r=arguments.length>1&&void 0!==arguments[1]&&arguments[1],i=n.get().streaming.gaps.enableStallFix,a=n.get().streaming.gaps.stallSeek,u=n.get().streaming.gaps.smallGapLimit,l=n.get().streaming.gaps.jumpLargeGaps,f=d.getBufferRange(),h=NaN,m=!1;if(t=R(f,e),!isNaN(t)){var y=f.start(t),E=y-e;E>0&&(E<=u||l)&&(h=y)}var v=s.getTimeToStreamEnd();if(isNaN(h)&&r&&isFinite(v)&&!isNaN(v)&&v<u&&(h=parseFloat(s.getStreamEndTime().toFixed(5)),m=!0),i&&isNaN(h)&&r&&isNaN(t)&&w(f,e)&&(0===a?(p.warn("Toggle play pause to break stall"),d.pause(),d.play()):(p.warn("Jumping ".concat(a,"s to break stall")),h=e+a)),h>0&&o!==h&&h>e&&!g){var _=h-e;if(m){var T=c.getStreamForTime(h),S=T&&!!T.getPreloaded();p.warn("Jumping to end of stream because of gap from ".concat(e," to ").concat(h,". Gap duration: ").concat(_)),s.seek(h,!0,S)}else{var b=s.getIsDynamic(),A=t>0?f.end(t-1):e,I=b?1e3*Math.max(0,_-.1):0;g=window.setTimeout((function(){s.seek(h,!0,!0),p.warn("Jumping gap occuring in period ".concat(c.getActiveStream().getStreamId()," starting at ").concat(A," and ending at ").concat(h,". Jumping by: ").concat(h-A)),g=null}),I)}o=h}}return e={reset:E,setConfig:function(e){e&&(e.settings&&(n=e.settings),e.playbackController&&(s=e.playbackController),e.streamController&&(c=e.streamController),e.videoModel&&(d=e.videoModel))},initialize:function(){!function(){y.on(l.Z.WALLCLOCK_TIME_UPDATED,b,this),y.on(l.Z.INITIAL_STREAM_SWITCH,S,this),y.on(l.Z.PLAYBACK_SEEKING,v,this),y.on(l.Z.BUFFER_REPLACEMENT_STARTED,_,e),y.on(l.Z.TRACK_CHANGE_RENDERED,T,e)}()}},p=(0,f.Z)(m).getInstance().getLogger(e),E(),e}sn.__dashjs_factory_name="GapController";var un=c.Z.getSingletonFactory(sn);function ln(){var e,t,n,r,i,o,c,g,h,p,m=this.context,y=(0,u.Z)(m).getInstance();function E(){t=!1;var e=Be.Z.parseUserAgent();n=e&&e.browser&&e.browser.name&&"safari"===e.browser.name.toLowerCase()}function v(){t=!1}function _(e){if(e.streamId===o.getActiveStreamInfo().id&&h){var t=c.getLiveDelay();c.getBufferLevel()>t/2&&(h=!1)}}function T(e){e.streamId===o.getActiveStreamInfo().id&&(h=e.state===s.Z.BUFFER_EMPTY)}function S(){g.getCatchupModeEnabled()||r.setPlaybackRate(1)}function b(){c.getIsDynamic()&&g.getCatchupModeEnabled()&&(g.getCatchupPlaybackRates().max>0||g.getCatchupPlaybackRates().min<0)&&!c.isPaused()&&!c.isSeeking()&&function(){try{return!(!c.getTime()>0||t)&&(I()===a.Z.LIVE_CATCHUP_MODE_LOLP?function(e,t){try{return Math.abs(A())>0||e<t}catch(e){return!1}}(c.getBufferLevel(),i.get().streaming.liveCatchup.playbackBufferMin):function(){try{return Math.abs(A())>0}catch(e){return!1}}())}catch(e){return!1}}()&&function(){if(!t&&r){var e,o=r.getPlaybackRate(),s=g.getCatchupPlaybackRates(),u=c.getBufferLevel(),l=A(),f=g.getCatchupMaxDrift();if(!isNaN(f)&&f>0&&l>f)p.info("[CatchupController]: Low Latency catchup mechanism. Latency too high, doing a seek to live point"),t=!0,c.seekToCurrentLive(!0,!1);else{var d=c.getCurrentLiveLatency(),m=c.getLiveDelay();e=I()===a.Z.LIVE_CATCHUP_MODE_LOLP?function(e,t,n,r,i){var a;if(i<r){var o=Math.abs(e.min),s=5*(i-r);a=1-o+2*o/(1+Math.pow(Math.E,-s)),p.debug("[LoL+ playback control_buffer-based] bufferLevel: "+i+", newRate: "+a)}else{if(Math.abs(t-n)<=.02*n)a=1;else{var u=t-n,l=u<0?Math.abs(e.min):e.max,c=5*u;a=1-l+2*l/(1+Math.pow(Math.E,-c))}p.debug("[LoL+ playback control_latency-based] latency: "+t+", newRate: "+a)}return a}(s,d,m,i.get().streaming.liveCatchup.playbackBufferMin,u):function(e,t,n,r){if(h)return 1;var i=t-n,a=i<0?Math.abs(e.min):e.max,o=5*i,s=1-a+2*a/(1+Math.pow(Math.E,-o));return c.getPlaybackStalled()&&r<=n/2&&i>0&&(s=1),s}(s,d,m,u);var y=n?.25:.02/(.5/s.max);e&&Math.abs(o-e)>=y&&(p.debug("[CatchupController]: Setting playback rate to ".concat(e)),r.setPlaybackRate(e))}}}()}function A(){return c.getCurrentLiveLatency()-c.getLiveDelay()}function I(){var e=i.get().streaming.liveCatchup.playbackBufferMin;return i.get().streaming.liveCatchup.mode!==a.Z.LIVE_CATCHUP_MODE_LOLP||null===e||isNaN(e)?a.Z.LIVE_CATCHUP_MODE_DEFAULT:a.Z.LIVE_CATCHUP_MODE_LOLP}function R(){g.getCatchupPlaybackRates(!0)}return e={reset:function(){y.off(d.Z.BUFFER_LEVEL_UPDATED,_,e),y.off(d.Z.BUFFER_LEVEL_STATE_CHANGED,T,e),y.off(d.Z.PLAYBACK_PROGRESS,b,e),y.off(d.Z.PLAYBACK_TIME_UPDATED,b,e),y.off(d.Z.PLAYBACK_SEEKED,v,e),y.off(l.Z.SETTING_UPDATED_CATCHUP_ENABLED,S,e),y.off(l.Z.SETTING_UPDATED_PLAYBACK_RATE_MIN,R,e),y.off(l.Z.SETTING_UPDATED_PLAYBACK_RATE_MAX,R,e),y.off(d.Z.STREAM_INITIALIZED,R,e),E(),r.setPlaybackRate(1,!0)},setConfig:function(e){e&&(e.settings&&(i=e.settings),e.videoModel&&(r=e.videoModel),e.streamController&&(o=e.streamController),e.playbackController&&(c=e.playbackController),e.mediaPlayerModel&&(g=e.mediaPlayerModel))},initialize:function(){y.on(d.Z.BUFFER_LEVEL_UPDATED,_,e),y.on(d.Z.BUFFER_LEVEL_STATE_CHANGED,T,e),y.on(d.Z.PLAYBACK_PROGRESS,b,e),y.on(d.Z.PLAYBACK_TIME_UPDATED,b,e),y.on(d.Z.PLAYBACK_SEEKED,v,e),y.on(l.Z.SETTING_UPDATED_CATCHUP_ENABLED,S,e),y.on(l.Z.SETTING_UPDATED_PLAYBACK_RATE_MIN,R,e),y.on(l.Z.SETTING_UPDATED_PLAYBACK_RATE_MAX,R,e),y.on(d.Z.STREAM_INITIALIZED,R,e),R()}},p=(0,f.Z)(m).getInstance().getLogger(e),E(),e}ln.__dashjs_factory_name="CatchupController";var cn=c.Z.getSingletonFactory(ln),fn=[a.Z.SERVICE_DESCRIPTION_DVB_LL_SCHEME],dn="video",gn="audio";function hn(){var e,t,n,r,i,s=this.context;function u(){t={liveDelay:NaN,liveCatchup:{maxDrift:NaN,playbackRate:{min:NaN,max:NaN}},minBitrate:{},maxBitrate:{},initialBitrate:{},contentSteering:null},n=[]}function l(e,n,i){try{t[e][n]=i/1e3}catch(e){r.error(e)}}return e={getServiceDescriptionSettings:function(){return t},getProducerReferenceTimeOffsets:function(){return n},calculateProducerReferenceTimeOffsets:function(e){try{var t=[];if(e&&e.length>0){var s=[a.Z.VIDEO,a.Z.AUDIO,a.Z.TEXT],u=i.getAvailabilityStartTime()/1e3;e.forEach((function(e){var n=s.reduce((function(t,n){return t.concat(i.getAllMediaInfoForType(e,n))}),[]).reduce((function(t,n){return i.getProducerReferenceTimes(e,n).forEach((function(r){var a=i.getVoRepresentations(n);if(a&&a.length>0&&a[0].adaptation&&a[0].segmentInfoType===o.Z.SEGMENT_TEMPLATE){var s=a[0],l=new Date(r[o.Z.WALL_CLOCK_TIME]).getTime()/1e3-(r[o.Z.PRESENTATION_TIME]/s[o.Z.TIMESCALE]-s[o.Z.PRESENTATION_TIME_OFFSET]+e.start),c=u-l;t.push({id:r[o.Z.ID],to:c})}})),t}),[]);t=t.concat(n)}))}n=t}catch(e){r.error(e),n=[]}},applyServiceDescription:function(e){if(e&&e.serviceDescriptions){var i=e.serviceDescriptions.filter((function(e){return fn.includes(e.schemeIdUri)})),o=e.serviceDescriptions.filter((function(e){return null==e.schemeIdUri})),s=i.length>0?i[i.length-1]:o[o.length-1];s&&(s.latency&&s.latency.target>0&&function(e){var i;if(e.schemeIdUri,a.Z.SERVICE_DESCRIPTION_DVB_LL_SCHEME,i=function(e){return{liveDelay:e.latency.target/1e3,maxDrift:!isNaN(e.latency.max)&&e.latency.max>e.latency.target?(e.latency.max-e.latency.target+500)/1e3:NaN,referenceId:e.latency.referenceId||NaN}}(e),n.length>0){var o=function(e){var t,r=0,i=n.filter((function(t){return t.id===e.referenceId}));return 0===i.length?(r=n.length>0?n[0].to:0,t=n[0].id||NaN):(r=i[0].to||0,t=i[0].id||NaN),{to:r,id:t}}(i),s=o.to,u=o.id;t.liveDelay=i.liveDelay-s,t.liveCatchup.maxDrift=i.maxDrift,r.debug("\\n                Found latency properties coming from service description. Applied time offset of ".concat(s," from ProducerReferenceTime element with id ").concat(u,".\\n                Live Delay: ").concat(i.liveDelay-s,", Live catchup max drift: ").concat(i.maxDrift,"\\n            "))}else t.liveDelay=i.liveDelay,t.liveCatchup.maxDrift=i.maxDrift,r.debug("Found latency properties coming from service description: Live Delay: ".concat(i.liveDelay,", Live catchup max drift: ").concat(i.maxDrift))}(s),s.playbackRate&&function(e){var n=e.playbackRate.min?Math.round(1e3*(e.playbackRate.min-1))/1e3:NaN,i=e.playbackRate.max?Math.round(1e3*(e.playbackRate.max-1))/1e3:NaN;t.liveCatchup.playbackRate.min=n,t.liveCatchup.playbackRate.max=i,r.debug("Found latency properties coming from service description: Live catchup min playback rate: ".concat(n)),r.debug("Found latency properties coming from service description: Live catchup max playback rate: ".concat(i))}(s),s.operatingQuality,s.operatingBandwidth&&function(e){if(e&&e.operatingBandwidth&&e.operatingBandwidth.mediaType&&"all"!==e.operatingBandwidth.mediaType){var t={};t.minBandwidth=e.operatingBandwidth.min,t.maxBandwidth=e.operatingBandwidth.max,t.targetBandwidth=e.operatingBandwidth.target;var n=[];e.operatingBandwidth.mediaType===dn||e.operatingBandwidth.mediaType===gn?n.push(e.operatingBandwidth.mediaType):"any"===e.operatingBandwidth.mediaType&&(n.push(gn),n.push(dn)),n.forEach((function(e){isNaN(t.minBandwidth)||l("minBitrate",e,t.minBandwidth),isNaN(t.maxBandwidth)||l("maxBitrate",e,t.maxBandwidth),isNaN(t.targetBandwidth)||l("initialBitrate",e,t.targetBandwidth)}))}}(s),s.contentSteering&&function(e){t.contentSteering=e.contentSteering}(s))}},reset:function(){u()},setConfig:function(e){e&&e.adapter&&(i=e.adapter)}},r=(0,f.Z)(s).getInstance().getLogger(e),u(),e}hn.__dashjs_factory_name="ServiceDescriptionController";var pn=c.Z.getSingletonFactory(hn),mn=n(3973),yn=n.n(mn),En=n(3039);function vn(){var e,t,n,r,i,o,s,c,d=this.context,g=(0,u.Z)(d).getInstance();function h(e,t){return e&&n[t]&&n[t][e]?n[t][e].list:[]}function p(e,t){return e&&n[t]&&n[t][e]?n[t][e].current:null}function m(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(e&&e.streamInfo){var i=e.type,s=e.streamInfo,u=s.id,f=p(i,u);if(n[u]&&n[u][i]&&(n[u][i].current=e,n[u][i].current&&(i!==a.Z.TEXT&&!v(e,f)||i===a.Z.TEXT&&e.isFragmented)&&g.trigger(l.Z.CURRENT_TRACK_CHANGED,{oldMediaInfo:f,newMediaInfo:e,switchMode:r.get().streaming.trackSwitchMode[i]},{streamId:u}),!t)){var d=T(e);if(!d||!n[u][i].storeLastSettings)return;d.roles&&(d.role=d.roles[0],delete d.roles),d.accessibility&&(d.accessibility=d.accessibility[0]),d.audioChannelConfiguration&&(d.audioChannelConfiguration=d.audioChannelConfiguration[0]),o[i]=d,c.setSavedMediaSettings(i,d)}}}function y(e,t){e&&t&&(i[e]=t)}function E(e){return e?i[e]:null}function v(e,t){if(!e&&!t)return!0;if(!e||!t)return!1;var n=e.id===t.id,r=e.viewpoint===t.viewpoint,i=JSON.stringify(e.viewpointsWithSchemeIdUri)===JSON.stringify(t.viewpointsWithSchemeIdUri),a=e.lang===t.lang,o=e.codec===t.codec,s=e.roles.toString()===t.roles.toString(),u=JSON.stringify(e.rolesWithSchemeIdUri)===JSON.stringify(t.rolesWithSchemeIdUri),l=e.accessibility.toString()===t.accessibility.toString(),c=JSON.stringify(e.accessibilitiesWithSchemeIdUri)===JSON.stringify(t.accessibilitiesWithSchemeIdUri),f=e.audioChannelConfiguration.toString()===t.audioChannelConfiguration.toString(),d=JSON.stringify(e.audioChannelConfigurationsWithSchemeIdUri)===JSON.stringify(t.audioChannelConfigurationsWithSchemeIdUri);return n&&o&&r&&i&&a&&s&&u&&l&&c&&f&&d}function _(){n={},o={},i={audio:null,video:null,text:null}}function T(e){var t={lang:e.lang,viewpoint:e.viewpoint,roles:e.roles,accessibility:e.accessibility,audioChannelConfiguration:e.audioChannelConfiguration,codec:e.codec};return t.lang||t.viewpoint||t.role&&t.role.length>0||t.accessibility&&t.accessibility.length>0||t.audioChannelConfiguration&&t.audioChannelConfiguration.length>0?t:null}function S(e,t,n){var r=[];return e.forEach((function(e){t(n,e)&&r.push(e)})),0!==r.length?r:e}function b(e,t){return!e.lang||e.lang instanceof RegExp?t.lang.match(e.lang):""!==t.lang&&(0,En.extendedFilter)(t.lang,yn()(e.lang)).length>0}function A(e,t){return void 0===e.index||null===e.index||t.index===e.index}function I(e,t){return!e.viewpoint||e.viewpoint===t.viewpoint}function R(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2],r=!e.role||!!t.roles.filter((function(t){return t===e.role}))[0];return r||t.type===a.Z.AUDIO&&n}function w(e,t){return e.accessibility?!!t.accessibility.filter((function(t){return t===e.accessibility}))[0]:!t.accessibility.length}function N(e,t){return!e.audioChannelConfiguration||!!t.audioChannelConfiguration.filter((function(t){return t===e.audioChannelConfiguration}))[0]}function C(e,t){return!e.codec||e.codec===t.codec}function D(e){var t,n=0,r=[];return e.forEach((function(e){(t=Math.max.apply(Math,e.bitrateList.map((function(e){return e.bandwidth}))))>n?(n=t,r=[e]):t===n&&r.push(e)})),r}function O(e){var t,n=1/0,r=[];return e.forEach((function(e){var i=e.bitrateList.reduce((function(e,t){var n=Math.max(1,t.width*t.height);return e+t.bandwidth/n}),0);(t=i/e.bitrateList.length)<n?(n=t,r=[e]):t===n&&r.push(e)})),r}function M(e){var t,n=0,r=[];return e.forEach((function(e){(t=e.representationCount)>n?(n=t,r=[e]):t===n&&r.push(e)})),r}function P(e,n){if(e===a.Z.TEXT)return n[0];var i,o=r.get().streaming.selectionModeForInitialTrack,u=s.getCustomInitialTrackSelectionFunction();if(u&&"function"==typeof u)i=u(n);else switch(o){case a.Z.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY:i=function(e){var t,n,r=(t=0,n=[],e.forEach((function(e){isNaN(e.selectionPriority)||(e.selectionPriority>t?(t=e.selectionPriority,n=[e]):e.selectionPriority===t&&n.push(e))})),n);return r.length>1&&(r=D(r)),r.length>1&&(r=M(r)),r}(n);break;case a.Z.TRACK_SELECTION_MODE_HIGHEST_BITRATE:i=function(e){var t=D(e);return t.length>1&&(t=M(t)),t}(n);break;case a.Z.TRACK_SELECTION_MODE_FIRST_TRACK:i=L(n);break;case a.Z.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY:i=function(e){var t=O(e);return t.length>1&&(t=D(t)),t}(n);break;case a.Z.TRACK_SELECTION_MODE_WIDEST_RANGE:i=function(e){var t=M(e);return t.length>1&&(t=D(e)),t}(n);break;default:t.warn("Track selection mode ".concat(o," is not supported. Falling back to TRACK_SELECTION_MODE_FIRST_TRACK")),i=L(n)}return i.length>0?i[0]:n[0]}function L(e){return e[0]}return e={setInitialMediaSettingsForType:function(e,t){var n=o[e]||E(e),r=h(e,t.id),i=[];n||((n=c.getSavedMediaSettings(e))&&delete n.codec,y(e,n)),r&&0!==r.length&&(n&&(i=S(i=Array.from(r),b,n),i=S(i,A,n),i=S(i,I,n),e===a.Z.AUDIO&&o[e]||(i=S(i,R,n)),i=S(i,w,n),i=S(i,N,n),i=S(i,C,n)),0===i.length?m(P(e,r),!0):i.length>1?m(P(e,i)):m(i[0]))},addTrack:function(e){if(e){var t=e.type;if((i=t)===a.Z.AUDIO||i===a.Z.VIDEO||i===a.Z.TEXT||i===a.Z.IMAGE){var i,o,s=e.streamInfo.id;n[s]||(n[s]={audio:{list:[],storeLastSettings:o=r.get().streaming.saveLastMediaSettingsForCurrentStreamingSession,current:null},video:{list:[],storeLastSettings:o,current:null},text:{list:[],storeLastSettings:o,current:null},image:{list:[],storeLastSettings:o,current:null}});for(var u=n[s][t].list,l=0,c=u.length;l<c;++l)if(v(u[l],e))return;u.push(e)}}},getTracksFor:h,getCurrentTrackFor:p,isCurrentTrack:function(e){if(!e)return!1;var t=e.type,r=e.streamInfo.id;return n[r]&&n[r][t]&&v(n[r][t].current,e)},setTrack:m,selectInitialTrack:P,setInitialSettings:y,getInitialSettings:E,getTracksWithHighestBitrate:D,getTracksWithHighestEfficiency:O,getTracksWithWidestRange:M,isTracksEqual:v,matchSettings:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];try{var r=!1;if(e.lang){if(e.lang instanceof RegExp)r=t.lang.match(e.lang);else if(""!==t.lang){var i=yn()(e.lang);i&&(r=(0,En.extendedFilter)(t.lang,i).length>0)}}else r=!0;var o=void 0===e.index||null===e.index||t.index===e.index,s=!e.viewpoint||e.viewpoint===t.viewpoint,u=!e.role||!!t.roles.filter((function(t){return t===e.role}))[0],l=!e.accessibility||!!t.accessibility.filter((function(t){return t===e.accessibility}))[0],c=!e.audioChannelConfiguration||!!t.audioChannelConfiguration.filter((function(t){return t===e.audioChannelConfiguration}))[0];return r&&o&&s&&(u||t.type===a.Z.AUDIO&&n)&&l&&c}catch(e){return!1}},matchSettingsLang:b,matchSettingsIndex:A,matchSettingsViewPoint:I,matchSettingsRole:R,matchSettingsAccessibility:w,matchSettingsAudioChannelConfig:N,saveTextSettingsDisabled:function(){c.setSavedMediaSettings(a.Z.TEXT,null)},setConfig:function(e){e&&(e.domStorage&&(c=e.domStorage),e.settings&&(r=e.settings),e.customParametersModel&&(s=e.customParametersModel))},reset:_},t=(0,f.Z)(d).getInstance().getLogger(e),_(),e}vn.__dashjs_factory_name="MediaController";var _n=c.Z.getSingletonFactory(vn);c.Z.updateSingletonFactory(vn.__dashjs_factory_name,_n);var Tn=_n,Sn=NaN,bn=function e(t,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.data={baseUrls:t||null,selectedIdx:n||Sn},this.children=[]};function An(){var e,t,n,r,i=this.context,a=Oe(i).getInstance();function o(e,t,n){var r=s(n);e[t]?a.areEqual(r,e[t].data.baseUrls)||(e[t].data.baseUrls=r,e[t].data.selectedIdx=Sn):e[t]=new bn(r)}function s(e){var t=n.getBaseURLsFromElement(e),i=r.getSynthesizedBaseUrlElements(t);return i&&i.length>0&&(t=t.concat(i)),t}function u(e,n){var r=n||t;e(r.data),r.children&&r.children.forEach((function(t){return u(e,t)}))}function l(){t=new bn}return e={reset:l,update:function(e){!function(e){!function(){if(!n||!n.hasOwnProperty("getBaseURLsFromElement")||!n.hasOwnProperty("getRepresentationSortFunction"))throw new Error("setConfig function has to be called previously")}();var r=s(e);a.areEqual(r,t.data.baseUrls)||(t.data.baseUrls=r,t.data.selectedIdx=Sn),e&&e.Period_asArray&&e.Period_asArray.forEach((function(e,r){o(t.children,r,e),e.AdaptationSet_asArray&&e.AdaptationSet_asArray.forEach((function(e,i){o(t.children[r].children,i,e),e.Representation_asArray&&e.Representation_asArray.sort(n.getRepresentationSortFunction()).forEach((function(e,n){o(t.children[r].children[i].children,n,e)}))}))}))}(e)},getForPath:function(e){var n=t,r=[n.data];return e&&e.forEach((function(e){(n=n.children[e])&&r.push(n.data)})),r.filter((function(e){return e.baseUrls.length}))},invalidateSelectedIndexes:function(e){u((function(t){isNaN(t.selectedIdx)||e===t.baseUrls[t.selectedIdx].serviceLocation&&(t.selectedIdx=Sn)}))},setConfig:function(e){e.adapter&&(n=e.adapter),e.contentSteeringController&&(r=e.contentSteeringController)},getBaseUrls:function(e){return s(e)}},l(),e}An.__dashjs_factory_name="BaseURLTreeModel";var In=c.Z.getClassFactory(An);function Rn(e){var t=(e=e||{}).blacklistController;return{select:function(e){return e&&function(e){var t,n,r=0,i=[],a=0;if((n=e.sort((function(e,t){var n=e.dvb_priority-t.dvb_priority;return isNaN(n)?0:n})).filter((function(e,t,n){return!t||n[0].dvb_priority&&e.dvb_priority&&n[0].dvb_priority===e.dvb_priority}))).length)return n.length>1&&(n.forEach((function(e){r+=e.dvb_weight,i.push(r)})),t=Math.floor(Math.random()*(r-1)),i.every((function(e,n){return a=n,!(t<e)}))),n[a]}((n=[],e.filter((function(e){return!t.contains(e.serviceLocation)||(e.dvb_priority&&n.push(e.dvb_priority),!1)})).filter((function(e){return!n.length||!e.dvb_priority||-1===n.indexOf(e.dvb_priority)}))));var n}}}Rn.__dashjs_factory_name="DVBSelector";var wn=c.Z.getClassFactory(Rn);function Nn(e){var t=(e=e||{}).blacklistController;return{select:function(e){var n,r=0;return e&&e.some((function(e,n){return r=n,!t.contains(e.serviceLocation)}))&&(n=e[r]),n}}}Nn.__dashjs_factory_name="BasicSelector";var Cn=c.Z.getClassFactory(Nn);function Dn(){var e,t,n,r=this.context;function i(){for(var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],r=0,i=NaN,a=function(){var a=e[r],o=t.findIndex((function(e){return e.serviceLocation&&e.serviceLocation===a}));if(-1!==o&&!n.contains(t[o].serviceLocation))return i=o,"break";r+=1};r<e.length;){var o=a();if("break"===o)break}return i}return e={selectBaseUrlIndex:function(e){var n=NaN;if(isNaN(e.selectedIdx)){var r=t.getSteeringDataFromManifest();r&&r.defaultServiceLocationArray.length>0&&(n=i(r.defaultServiceLocationArray,e.baseUrls))}var a=t.getCurrentSteeringResponseData();return e.baseUrls&&e.baseUrls.length&&a&&a.pathwayPriority&&a.pathwayPriority.length&&(n=i(a.pathwayPriority,e.baseUrls)),n},setConfig:function(e){e.blacklistController&&(n=e.blacklistController),e.contentSteeringController&&(t=e.contentSteeringController)}},t=jt(r).getInstance(),e}Dn.__dashjs_factory_name="ContentSteeringSelector";var On=c.Z.getClassFactory(Dn);function Mn(){var e,t,n,r,i,a,o=this.context,s=(0,u.Z)(o).getInstance(),c=(0,N.Z)(o).getInstance();function f(){t.reset()}return e={chooseSelector:function(e){(0,z.PS)(e,"boolean"),a=e?r:n},select:function(e){if(e){if(c.get().streaming.applyContentSteering){var t=i.selectBaseUrlIndex(e);isNaN(t)||-1===t||(e.selectedIdx=t)}if(!isNaN(e.selectedIdx))return e.baseUrls[e.selectedIdx];var r=a.select(e.baseUrls);return r?(e.selectedIdx=e.baseUrls.indexOf(r),r):(s.trigger(l.Z.URL_RESOLUTION_FAILED,{error:new S.Z(w.URL_RESOLUTION_FAILED_GENERIC_ERROR_CODE,w.URL_RESOLUTION_FAILED_GENERIC_ERROR_MESSAGE)}),void(a===n&&f()))}},reset:f,setConfig:function(e){e.selector&&(a=e.selector),e.contentSteeringSelector&&(i=e.contentSteeringSelector)}},t=kt(o).create({updateEventName:l.Z.SERVICE_LOCATION_BASE_URL_BLACKLIST_CHANGED,addBlacklistEventName:l.Z.SERVICE_LOCATION_BASE_URL_BLACKLIST_ADD}),n=Cn(o).create({blacklistController:t}),r=wn(o).create({blacklistController:t}),(i=On(o).create()).setConfig({blacklistController:t}),a=n,e}Mn.__dashjs_factory_name="BaseURLSelector";var Pn=c.Z.getClassFactory(Mn);function Ln(){var e,t,n,r,i,a=this.context,o=(0,u.Z)(a).getInstance(),s=(0,Q.Z)(a).getInstance();function c(e){n.update(e),r.chooseSelector(t.getIsDVB(e)),o.trigger(d.Z.BASE_URLS_UPDATED,{baseUrls:f(e)})}function f(e){return n.getBaseUrls(e)}return e={reset:function(){n.reset(),r.reset()},initialize:function(e){n.setConfig({adapter:t,contentSteeringController:i}),c(e)},resolve:function(e){var t=n.getForPath(e).reduce((function(e,t){var n=r.select(t);return n?(s.isRelative(n.url)?e.url=s.resolve(n.url,e.url):(e.url=n.url,e.serviceLocation=n.serviceLocation),e.availabilityTimeOffset=n.availabilityTimeOffset,e.availabilityTimeComplete=n.availabilityTimeComplete,e.queryParams=n.queryParams,e):new Se}),new Se);if(!s.isRelative(t.url))return t},setConfig:function(e){e.baseURLTreeModel&&(n=e.baseURLTreeModel),e.baseURLSelector&&(r=e.baseURLSelector),e.adapter&&(t=e.adapter),e.contentSteeringController&&(i=e.contentSteeringController)},getBaseUrls:f,update:c},n=In(a).create(),r=Pn(a).create(),o.on(l.Z.SERVICE_LOCATION_BASE_URL_BLACKLIST_CHANGED,(function(e){n.invalidateSelectedIndexes(e.entry)}),e),e}Ln.__dashjs_factory_name="BaseURLController";var xn=c.Z.getClassFactory(Ln);function Fn(e){return Fn="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Fn(e)}function kn(e,t){return kn=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},kn(e,t)}function Un(e,t){return!t||"object"!==Fn(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function Zn(e){return Zn=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},Zn(e)}var Bn=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&kn(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=Zn(t);if(n){var i=Zn(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return Un(this,e)});function i(e,t){var n;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),(n=r.call(this)).url=e||null,n.type=t||null,n.mediaType=a.Z.STREAM,n.responseType="",n}return i}(p.Z);function Gn(e){e=e||{};var t=this.context,n=(0,u.Z)(t).getInstance(),r=vt(t).create({errHandler:e.errHandler,dashMetrics:e.dashMetrics,mediaPlayerModel:e.mediaPlayerModel,requestModifier:e.requestModifier,errors:w});return{load:function(e,t,i){var a=function(r,a){t.resolved=!0,t.resolvedContent=r||null,n.trigger(l.Z.XLINK_ELEMENT_LOADED,{element:t,resolveObject:i,error:r||a?null:new S.Z(w.XLINK_LOADER_LOADING_FAILURE_ERROR_CODE,w.XLINK_LOADER_LOADING_FAILURE_ERROR_MESSAGE+e)})};if("urn:mpeg:dash:resolve-to-zero:2013"===e)a(null,!0);else{var o=new Bn(e,C.w.XLINK_EXPANSION_TYPE);r.load({request:o,success:function(e){a(e)},error:function(){a(null)}})}},reset:function(){r&&(r.abort(),r=null)}}}Gn.__dashjs_factory_name="XlinkLoader";var qn=c.Z.getClassFactory(Gn),Yn=function(e){void 0===(e=e||{}).escapeMode&&(e.escapeMode=!0),void 0===e.attributePrefix&&(e.attributePrefix="_"),e.arrayAccessForm=e.arrayAccessForm||"none",e.emptyNodeForm=e.emptyNodeForm||"text",void 0===e.enableToStringFunc&&(e.enableToStringFunc=!0),e.arrayAccessFormPaths=e.arrayAccessFormPaths||[],void 0===e.skipEmptyTextNodesForObj&&(e.skipEmptyTextNodesForObj=!0),void 0===e.stripWhitespaces&&(e.stripWhitespaces=!0),e.datetimeAccessFormPaths=e.datetimeAccessFormPaths||[],void 0===e.useDoubleQuotes&&(e.useDoubleQuotes=!1),e.xmlElementsFilter=e.xmlElementsFilter||[],e.jsonPropertiesFilter=e.jsonPropertiesFilter||[],void 0===e.keepCData&&(e.keepCData=!1),void 0===e.ignoreRoot&&(e.ignoreRoot=!1);function t(e){var t=e.localName;return null==t&&(t=e.baseName),null!=t&&""!=t||(t=e.nodeName),t}function n(e){return"string"==typeof e?e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/\'/g,"&apos;"):e}function r(e,t,n,r){for(var i=0;i<e.length;i++){var a=e[i];if("string"==typeof a){if(a==r)break}else if(a instanceof RegExp){if(a.test(r))break}else if("function"==typeof a&&a(t,n,r))break}return i!=e.length}function i(t,n,i){"property"===e.arrayAccessForm&&(t[n]instanceof Array?t[n+"_asArray"]=t[n]:t[n+"_asArray"]=[t[n]]),!(t[n]instanceof Array)&&e.arrayAccessFormPaths.length>0&&r(e.arrayAccessFormPaths,t,n,i)&&(t[n]=[t[n]])}function a(e){var t=e.split(/[-T:+Z]/g),n=new Date(t[0],t[1]-1,t[2]),r=t[5].split(".");if(n.setHours(t[3],t[4],r[0]),r.length>1&&n.setMilliseconds(r[1]),t[6]&&t[7]){var i=60*t[6]+Number(t[7]);i=0+("-"==(/\\d\\d-\\d\\d:\\d\\d$/.test(e)?"-":"+")?-1*i:i),n.setMinutes(n.getMinutes()-i-n.getTimezoneOffset())}else-1!==e.indexOf("Z",e.length-1)&&(n=new Date(Date.UTC(n.getFullYear(),n.getMonth(),n.getDate(),n.getHours(),n.getMinutes(),n.getSeconds(),n.getMilliseconds())));return n}function o(t,n,i,a){return!(1==n&&e.xmlElementsFilter.length>0)||r(e.xmlElementsFilter,t,i,a)}function s(n,u){if(9==n.nodeType){for(var l=new Object,c=n.childNodes,f=0;f<c.length;f++)1==(g=c[f]).nodeType&&(e.ignoreRoot?l=s(g):(l={})[h=t(g)]=s(g));return l}if(1==n.nodeType){(l=new Object).__cnt=0;var d=[];for(c=n.childNodes,f=0;f<c.length;f++){var g,h=t(g=c[f]);if(8!=g.nodeType){var p=u+"."+h;if(o(l,g.nodeType,h,p))if(l.__cnt++,null==l[h]){var m=s(g,p);("#text"!=h||/[^\\s]/.test(m))&&((y={})[h]=m,d.push(y)),l[h]=m,i(l,h,p)}else{var y;null!=l[h]&&(l[h]instanceof Array||(l[h]=[l[h]],i(l,h,p))),m=s(g,p),("#text"!=h||/[^\\s]/.test(m))&&((y={})[h]=m,d.push(y)),l[h][l[h].length]=m}}}l.__children=d;for(var E=t(n),v=0;v<n.attributes.length;v++){var _=n.attributes[v];l.__cnt++;for(var T=_.value,S=0,b=e.matchers.length;S<b;S++){var A=e.matchers[S];A.test(_,E)&&(T=A.converter(_.value))}l[e.attributePrefix+_.name]=T}var I=function(e){return e.prefix}(n);return null!=I&&""!=I&&(l.__cnt++,l.__prefix=I),null!=l["#text"]&&(l.__text=l["#text"],l.__text instanceof Array&&(l.__text=l.__text.join("\\n")),e.stripWhitespaces&&(l.__text=l.__text.trim()),delete l["#text"],"property"==e.arrayAccessForm&&delete l["#text_asArray"],l.__text=function(t,n,i){if(e.datetimeAccessFormPaths.length>0){var o=i.split(".#")[0];return r(e.datetimeAccessFormPaths,t,n,o)?a(t):t}return t}(l.__text,h,u+"."+h)),null!=l["#cdata-section"]&&(l.__cdata=l["#cdata-section"],delete l["#cdata-section"],"property"==e.arrayAccessForm&&delete l["#cdata-section_asArray"]),0==l.__cnt&&"text"==e.emptyNodeForm?l="":1==l.__cnt&&null!=l.__text?l=l.__text:1!=l.__cnt||null==l.__cdata||e.keepCData?l.__cnt>1&&null!=l.__text&&e.skipEmptyTextNodesForObj&&(e.stripWhitespaces&&""==l.__text||""==l.__text.trim())&&delete l.__text:l=l.__cdata,delete l.__cnt,!e.enableToStringFunc||null==l.__text&&null==l.__cdata||(l.toString=function(){return(null!=this.__text?this.__text:"")+(null!=this.__cdata?this.__cdata:"")}),l}if(3==n.nodeType||4==n.nodeType)return n.nodeValue}function u(t,r,i,a){var o="<"+(null!=t&&null!=t.__prefix?t.__prefix+":":"")+r;if(null!=i)for(var s=0;s<i.length;s++){var u=i[s],l=t[u];e.escapeMode&&(l=n(l)),o+=" "+u.substr(e.attributePrefix.length)+"=",e.useDoubleQuotes?o+=\'"\'+l+\'"\':o+="\'"+l+"\'"}return o+(a?"/>":">")}function l(e,t){return"</"+(null!=e.__prefix?e.__prefix+":":"")+t+">"}function c(t,n){return"property"==e.arrayAccessForm&&(i="_asArray",-1!==(r=n.toString()).indexOf(i,r.length-i.length))||0==n.toString().indexOf(e.attributePrefix)||0==n.toString().indexOf("__")||t[n]instanceof Function;var r,i}function f(e){var t=0;if(e instanceof Object)for(var n in e)c(e,n)||t++;return t}function d(t,n,i){return 0==e.jsonPropertiesFilter.length||""==i||r(e.jsonPropertiesFilter,t,n,i)}function g(t){var n=[];if(t instanceof Object)for(var r in t)-1==r.toString().indexOf("__")&&0==r.toString().indexOf(e.attributePrefix)&&n.push(r);return n}function h(t){var r="";return t instanceof Object?r+=function(t){var r="";return null!=t.__cdata&&(r+="<![CDATA["+t.__cdata+"]]>"),null!=t.__text&&(e.escapeMode?r+=n(t.__text):r+=t.__text),r}(t):null!=t&&(e.escapeMode?r+=n(t):r+=t),r}function p(e,t){return""===e?t:e+"."+t}function m(e,t,n,r){var i="";if(0==e.length)i+=u(e,t,n,!0);else for(var a=0;a<e.length;a++)i+=u(e[a],t,g(e[a]),!1),i+=y(e[a],p(r,t)),i+=l(e[a],t);return i}function y(e,t){var n="";if(f(e)>0)for(var r in e)if(!c(e,r)&&(""==t||d(e,r,p(t,r)))){var i=e[r],a=g(i);null==i||null==i?n+=u(i,r,a,!0):i instanceof Object?i instanceof Array?n+=m(i,r,a,t):i instanceof Date?(n+=u(i,r,a,!1),n+=i.toISOString(),n+=l(i,r)):f(i)>0||null!=i.__text||null!=i.__cdata?(n+=u(i,r,a,!1),n+=y(i,p(t,r)),n+=l(i,r)):n+=u(i,r,a,!0):(n+=u(i,r,a,!1),n+=h(i),n+=l(i,r))}return n+h(e)}this.parseXmlString=function(e){var t;if(window.ActiveXObject||window,void 0===e)return null;if(window.DOMParser){var n=new window.DOMParser;try{(t=n.parseFromString(e,"text/xml")).getElementsByTagNameNS("*","parsererror").length>0&&(t=null)}catch(e){t=null}}else 0==e.indexOf("<?")&&(e=e.substr(e.indexOf("?>")+2)),(t=new ActiveXObject("Microsoft.XMLDOM")).async="false",t.loadXML(e);return t},this.asArray=function(e){return void 0===e||null==e?[]:e instanceof Array?e:[e]},this.toXmlDateTime=function(e){return e instanceof Date?e.toISOString():"number"==typeof e?new Date(e).toISOString():null},this.asDateTime=function(e){return"string"==typeof e?a(e):e},this.xml2json=function(e){return s(e)},this.xml_str2json=function(e){var t=this.parseXmlString(e);return null!=t?this.xml2json(t):null},this.json2xml_str=function(e){return y(e,"")},this.json2xml=function(e){var t=this.json2xml_str(e);return this.parseXmlString(t)},this.getVersion=function(){return"1.2.0"}},jn="onLoad";function Hn(e){e=e||{};var t,n,r,i,a,s,c=this.context,f=(0,u.Z)(c).getInstance(),d=(0,Q.Z)(c).getInstance();function g(e,t,n){var r,i,a={};a.elements=e,a.type=t,a.resolveType=n,0===a.elements.length&&p(a);for(var o=0;o<a.elements.length;o++)r=a.elements[o],i=d.isHTTPURL(r.url)?r.url:r.originalContent.BaseURL+r.url,s.load(i,r,a)}function h(e){var t,n,r="";if(t=e.element,n=e.resolveObject,t.resolvedContent){var i=0;0===t.resolvedContent.indexOf("<?xml")&&(i=t.resolvedContent.indexOf("?>")+2),r=t.resolvedContent.substr(0,i)+"<response>"+t.resolvedContent.substr(i)+"</response>",t.resolvedContent=a.xml_str2json(r)}(function(e){var t;for(t=0;t<e.elements.length;t++)if(!1===e.elements[t].resolved)return!1;return!0})(n)&&p(n)}function p(e){var t,n,a=[];if(function(e){var t,n,a,o,s,u,l=[];for(o=e.elements.length-1;o>=0;o--){if(n=(t=e.elements[o]).type+"_asArray",t.resolvedContent){if(t.resolvedContent)for(s=0;s<t.resolvedContent[n].length;s++)a=t.resolvedContent[n][s],l.push(a)}else delete t.originalContent["xlink:actuate"],delete t.originalContent["xlink:href"],l.push(t.originalContent);for(t.parentElement[n].splice(t.index,1),u=0;u<l.length;u++)t.parentElement[n].splice(t.index+u,0,l[u]);l=[]}e.elements.length>0&&r.run(i)}(e),"onActuate"===e.resolveType&&f.trigger(l.Z.XLINK_READY,{manifest:i}),e.resolveType===jn)switch(e.type){case o.Z.PERIOD:for(t=0;t<i[o.Z.PERIOD+"_asArray"].length;t++)(n=i[o.Z.PERIOD+"_asArray"][t]).hasOwnProperty(o.Z.ADAPTATION_SET+"_asArray")&&(a=a.concat(m(n[o.Z.ADAPTATION_SET+"_asArray"],n,o.Z.ADAPTATION_SET,jn))),n.hasOwnProperty(o.Z.EVENT_STREAM+"_asArray")&&(a=a.concat(m(n[o.Z.EVENT_STREAM+"_asArray"],n,o.Z.EVENT_STREAM,jn)));g(a,o.Z.ADAPTATION_SET,jn);break;case o.Z.ADAPTATION_SET:f.trigger(l.Z.XLINK_READY,{manifest:i})}}function m(e,t,n,r){var i,a,o,s=[];for(a=e.length-1;a>=0;a--)(i=e[a]).hasOwnProperty("xlink:href")&&"urn:mpeg:dash:resolve-to-zero:2013"===i["xlink:href"]&&e.splice(a,1);for(a=0;a<e.length;a++)(i=e[a]).hasOwnProperty("xlink:href")&&i.hasOwnProperty("xlink:actuate")&&i["xlink:actuate"]===r&&(o=y(i["xlink:href"],t,n,a,r,i),s.push(o));return s}function y(e,t,n,r,i,a){return{url:e,parentElement:t,type:n,index:r,resolveType:i,originalContent:a,resolvedContent:null,resolved:!1}}return t={resolveManifestOnLoad:function(e){a=new Yn({escapeMode:!1,attributePrefix:"",arrayAccessForm:"property",emptyNodeForm:"object",stripWhitespaces:!1,enableToStringFunc:!1,ignoreRoot:!0,matchers:n}),(i=e).Period_asArray?g(m(i.Period_asArray,i,o.Z.PERIOD,jn),o.Z.PERIOD,jn):f.trigger(l.Z.XLINK_READY,{manifest:i})},setMatchers:function(e){e&&(n=e)},setIron:function(e){e&&(r=e)},reset:function(){f.off(l.Z.XLINK_ELEMENT_LOADED,h,t),s&&(s.reset(),s=null)}},f.on(l.Z.XLINK_ELEMENT_LOADED,h,t),s=qn(c).create({errHandler:e.errHandler,dashMetrics:e.dashMetrics,mediaPlayerModel:e.mediaPlayerModel,requestModifier:e.requestModifier,settings:e.settings}),t}Hn.__dashjs_factory_name="XlinkController";var Vn=c.Z.getClassFactory(Hn);function Kn(e){return Kn="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Kn(e)}function zn(e){function t(e,t){for(var n in e)t.hasOwnProperty(n)||(t[n]=e[n])}function n(e,n,r){for(var i=0,a=e.length;i<a;++i){var o=e[i];if(n[o.name])if(r[o.name]){if(o.merge){var s=n[o.name],u=r[o.name];"object"===Kn(s)&&"object"===Kn(u)?t(s,u):r[o.name]=s+u}}else r[o.name]=n[o.name]}}function r(e,t){for(var i=0,a=e.children.length;i<a;++i){var o=e.children[i],s=t[o.name+"_asArray"];if(s)for(var u=0,l=s.length;u<l;++u){var c=s[u];n(e.properties,t,c),r(o,c)}}}return{run:function(t){if(null===t||"object"!==Kn(t))return t;if(t.Period_asArray&&"period"in e)for(var n=e.period,i=t.Period_asArray,a=0,o=i.length;a<o;++a){var s=i[a];if(r(n,s),"adaptationset"in e){var u=s.AdaptationSet_asArray;if(u)for(var l=e.adaptationset,c=0,f=u.length;c<f;++c)r(l,u[c])}}return t}}}zn.__dashjs_factory_name="ObjectIron";var Wn=c.Z.getClassFactory(zn);function Xn(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var Qn=function(){function e(t,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this._test=t,this._converter=n}var t,n;return t=e,(n=[{key:"test",get:function(){return this._test}},{key:"converter",get:function(){return this._converter}}])&&Xn(t.prototype,n),e}();function Jn(e){return Jn="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Jn(e)}function $n(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function er(e,t){return er=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},er(e,t)}function tr(e,t){return!t||"object"!==Jn(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function nr(e){return nr=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},nr(e)}var rr=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&er(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=nr(t);if(n){var i=nr(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return tr(this,e)});function i(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),r.call(this,(function(e,t){var n,r=($n(n={},o.Z.MPD,[o.Z.ID,o.Z.PROFILES]),$n(n,o.Z.PERIOD,[o.Z.ID]),$n(n,o.Z.BASE_URL,[o.Z.SERVICE_LOCATION,o.Z.BYTE_RANGE]),$n(n,o.Z.SEGMENT_BASE,[o.Z.INDEX_RANGE]),$n(n,o.Z.INITIALIZATION,[o.Z.RANGE]),$n(n,o.Z.REPRESENTATION_INDEX,[o.Z.RANGE]),$n(n,o.Z.SEGMENT_LIST,[o.Z.INDEX_RANGE]),$n(n,o.Z.BITSTREAM_SWITCHING,[o.Z.RANGE]),$n(n,o.Z.SEGMENT_URL,[o.Z.MEDIA_RANGE,o.Z.INDEX_RANGE]),$n(n,o.Z.SEGMENT_TEMPLATE,[o.Z.INDEX_RANGE,o.Z.MEDIA,o.Z.INDEX,o.Z.INITIALIZATION_MINUS,o.Z.BITSTREAM_SWITCHING_MINUS]),$n(n,o.Z.ASSET_IDENTIFIER,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.EVENT_STREAM,[o.Z.VALUE]),$n(n,o.Z.ADAPTATION_SET,[o.Z.PROFILES,o.Z.MIME_TYPE,o.Z.SEGMENT_PROFILES,o.Z.CODECS,o.Z.CONTENT_TYPE]),$n(n,o.Z.FRAME_PACKING,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.AUDIO_CHANNEL_CONFIGURATION,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.CONTENT_PROTECTION,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.ESSENTIAL_PROPERTY,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.SUPPLEMENTAL_PROPERTY,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.INBAND_EVENT_STREAM,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.ACCESSIBILITY,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.ROLE,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.RATING,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.VIEWPOINT,[o.Z.VALUE,o.Z.ID]),$n(n,o.Z.CONTENT_COMPONENT,[o.Z.CONTENT_TYPE]),$n(n,o.Z.REPRESENTATION,[o.Z.ID,o.Z.DEPENDENCY_ID,o.Z.MEDIA_STREAM_STRUCTURE_ID]),$n(n,o.Z.SUBSET,[o.Z.ID]),$n(n,o.Z.METRICS,[o.Z.METRICS_MINUS]),$n(n,o.Z.REPORTING,[o.Z.VALUE,o.Z.ID]),n);if(r.hasOwnProperty(t)){var i=r[t];return void 0!==i&&i.indexOf(e.name)>=0}return!1}),(function(e){return String(e)}))}return i}(Qn);function ir(e){return ir="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},ir(e)}function ar(e,t){return ar=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},ar(e,t)}function or(e,t){return!t||"object"!==ir(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function sr(e){return sr=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},sr(e)}var ur=/^([-])?P(([\\d.]*)Y)?(([\\d.]*)M)?(([\\d.]*)D)?T?(([\\d.]*)H)?(([\\d.]*)M)?(([\\d.]*)S)?/,lr=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&ar(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=sr(t);if(n){var i=sr(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return or(this,e)});function i(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),r.call(this,(function(e){for(var t=[o.Z.MIN_BUFFER_TIME,o.Z.MEDIA_PRESENTATION_DURATION,o.Z.MINIMUM_UPDATE_PERIOD,o.Z.TIMESHIFT_BUFFER_DEPTH,o.Z.MAX_SEGMENT_DURATION,o.Z.MAX_SUBSEGMENT_DURATION,o.Z.SUGGESTED_PRESENTATION_DELAY,o.Z.START,a.Z.START_TIME,o.Z.DURATION],n=t.length,r=0;r<n;r++)if(e.nodeName===t[r])return ur.test(e.value);return!1}),(function(e){var t=ur.exec(e),n=31536e3*parseFloat(t[3]||0)+2592e3*parseFloat(t[5]||0)+86400*parseFloat(t[7]||0)+3600*parseFloat(t[9]||0)+60*parseFloat(t[11]||0)+parseFloat(t[13]||0);return void 0!==t[1]&&(n=-n),n}))}return i}(Qn);function cr(e){return cr="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},cr(e)}function fr(e,t){return fr=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},fr(e,t)}function dr(e,t){return!t||"object"!==cr(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function gr(e){return gr=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},gr(e)}var hr=/^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})(?::([0-9]*)(\\.[0-9]*)?)?(?:([+-])([0-9]{2})(?::?)([0-9]{2}))?/,pr=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&fr(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=gr(t);if(n){var i=gr(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return dr(this,e)});function i(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),r.call(this,(function(e){return hr.test(e.value)}),(function(e){var t,n=hr.exec(e);if(t=Date.UTC(parseInt(n[1],10),parseInt(n[2],10)-1,parseInt(n[3],10),parseInt(n[4],10),parseInt(n[5],10),n[6]&&parseInt(n[6],10)||0,n[7]&&1e3*parseFloat(n[7])||0),n[9]&&n[10]){var r=60*parseInt(n[9],10)+parseInt(n[10],10);t+=("+"===n[8]?-1:1)*r*60*1e3}return new Date(t)}))}return i}(Qn);function mr(e){return mr="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},mr(e)}function yr(e,t){return yr=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},yr(e,t)}function Er(e,t){return!t||"object"!==mr(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function vr(e){return vr=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},vr(e)}var _r=/^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$/,Tr=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&yr(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=vr(t);if(n){var i=vr(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return Er(this,e)});function i(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),r.call(this,(function(e){return _r.test(e.value)}),(function(e){return parseFloat(e)}))}return i}(Qn);function Sr(e){return Sr="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Sr(e)}function br(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function Ar(e,t){return Ar=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},Ar(e,t)}function Ir(e,t){return!t||"object"!==Sr(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function Rr(e){return Rr=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},Rr(e)}var wr=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&Ar(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=Rr(t);if(n){var i=Rr(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return Ir(this,e)});function i(){return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),r.call(this,(function(e,t){var n,r=(br(n={},o.Z.ADAPTATION_SET,[o.Z.LANG]),br(n,o.Z.REPRESENTATION,[o.Z.LANG]),br(n,o.Z.CONTENT_COMPONENT,[o.Z.LANG]),br(n,o.Z.LABEL,[o.Z.LANG]),br(n,o.Z.GROUP_LABEL,[o.Z.LANG]),n);if(r.hasOwnProperty(t)){var i=r[t];return void 0!==i&&i.indexOf(e.name)>=0}return!1}),(function(e){return yn()(e)||String(e)}))}return i}(Qn);function Nr(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var Cr=function(){function e(t){var n;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this._name=t,this._merge=(n=t)&&n.length&&n.charAt(0)===n.charAt(0).toUpperCase()}var t,n;return t=e,(n=[{key:"name",get:function(){return this._name}},{key:"merge",get:function(){return this._merge}}])&&Nr(t.prototype,n),e}();function Dr(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var Or=function(){function e(t,n,r){var i=this;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this._name=t||"",this._properties=[],this._children=r||[],Array.isArray(n)&&n.forEach((function(e){i._properties.push(new Cr(e))}))}var t,n;return t=e,(n=[{key:"name",get:function(){return this._name}},{key:"children",get:function(){return this._children}},{key:"properties",get:function(){return this._properties}}])&&Dr(t.prototype,n),e}();function Mr(e){return Mr="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Mr(e)}function Pr(e,t){return Pr=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},Pr(e,t)}function Lr(e,t){return!t||"object"!==Mr(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function xr(e){return xr=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},xr(e)}var Fr=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&Pr(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=xr(t);if(n){var i=xr(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return Lr(this,e)});function i(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i);var e=[o.Z.PROFILES,o.Z.WIDTH,o.Z.HEIGHT,o.Z.SAR,o.Z.FRAMERATE,o.Z.AUDIO_SAMPLING_RATE,o.Z.MIME_TYPE,o.Z.SEGMENT_PROFILES,o.Z.CODECS,o.Z.MAXIMUM_SAP_PERIOD,o.Z.START_WITH_SAP,o.Z.MAX_PLAYOUT_RATE,o.Z.CODING_DEPENDENCY,o.Z.SCAN_TYPE,o.Z.FRAME_PACKING,o.Z.AUDIO_CHANNEL_CONFIGURATION,o.Z.CONTENT_PROTECTION,o.Z.ESSENTIAL_PROPERTY,o.Z.ESSENTIAL_PROPERTY+"_asArray",o.Z.SUPPLEMENTAL_PROPERTY,o.Z.INBAND_EVENT_STREAM];return r.call(this,o.Z.ADAPTATION_SET,e,[new Or(o.Z.REPRESENTATION,e,[new Or(o.Z.SUB_REPRESENTATION,e)])])}return i}(Or);function kr(e){return kr="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},kr(e)}function Ur(e,t){return Ur=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},Ur(e,t)}function Zr(e,t){return!t||"object"!==kr(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function Br(e){return Br=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},Br(e)}var Gr=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&Ur(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=Br(t);if(n){var i=Br(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return Zr(this,e)});function i(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i);var e=[o.Z.SEGMENT_BASE,o.Z.SEGMENT_TEMPLATE,o.Z.SEGMENT_LIST];return r.call(this,o.Z.PERIOD,e,[new Or(o.Z.ADAPTATION_SET,e,[new Or(o.Z.REPRESENTATION,e)])])}return i}(Or);function qr(e){e=e||{};var t,n,r,i,a,o=this.context,s=e.debug;return t={parse:function(e){var t,r=window.performance.now();if(!(t=i.xml_str2json(e)))throw new Error("parsing the manifest failed");var o=window.performance.now();t.Patch?((t=t.Patch).add_asArray&&t.add_asArray.forEach((function(e){return a.run(e)})),t.replace_asArray&&t.replace_asArray.forEach((function(e){return a.run(e)}))):(t=t.MPD,a.run(t));var s=window.performance.now();return n.info("Parsing complete: ( xml2json: "+(o-r).toPrecision(3)+"ms, objectiron: "+(s-o).toPrecision(3)+"ms, total: "+((s-r)/1e3).toPrecision(3)+"s)"),t.protocol="DASH",t},getMatchers:function(){return r},getIron:function(){return a}},n=s.getLogger(t),r=[new lr,new pr,new Tr,new wr,new rr],i=new Yn({escapeMode:!1,attributePrefix:"",arrayAccessForm:"property",emptyNodeForm:"object",stripWhitespaces:!1,enableToStringFunc:!0,ignoreRoot:!1,matchers:r}),a=Wn(o).create({adaptationset:new Fr,period:new Gr}),t}qr.__dashjs_factory_name="DashParser";var Yr=c.Z.getClassFactory(qr);function jr(e){e=e||{};var t,n,r,i,s,c=this.context,f=e.debug,d=e.settings,g=(0,u.Z)(c).getInstance(),h=(0,Q.Z)(c).getInstance(),p=e.mssHandler,m=e.errHandler;function y(e){g.trigger(l.Z.INTERNAL_MANIFEST_LOADED,{manifest:e.manifest})}function E(e){var t=null;return e.indexOf("SmoothStreamingMedia")>-1?(p&&(t=p.createMssParser(),p.createMssFragmentProcessor(),p.registerEvents()),t):e.indexOf("MPD")>-1||e.indexOf("Patch")>-1?Yr(c).create({debug:f}):t}return t={load:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,o=new Date,u=new Bn(e,C.w.MPD_TYPE);t&&(u.serviceLocation=t),a&&(u.queryParams=a),u.requestStartDate||(u.requestStartDate=o),g.trigger(l.Z.MANIFEST_LOADING_STARTED,{request:u}),r.load({request:u,success:function(t,r,a){var o,u,c;if(i)if(a&&a!==e?(u=h.parseBaseUrl(a),o=a):(h.isRelative(e)&&(e=h.resolve(e,window.location.href)),u=h.parseBaseUrl(e)),"No Content"!=r)if(null===s&&(s=E(t)),null!==s){i.setMatchers(s.getMatchers()),i.setIron(s.getIron());try{c=s.parse(t)}catch(t){return void g.trigger(l.Z.INTERNAL_MANIFEST_LOADED,{manifest:null,error:new S.Z(w.MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE,w.MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE+"".concat(e))})}if(c){if(c.url=o||e,c.originalUrl||(c.originalUrl=c.url),d&&d.get().streaming.enableManifestDurationMismatchFix&&c.mediaPresentationDuration&&c.Period_asArray.length>1){var f=c.Period_asArray.reduce((function(e,t){return e+t.duration}),0);!isNaN(f)&&c.mediaPresentationDuration>f&&(n.warn("Media presentation duration greater than duration of all periods. Setting duration to total period duration"),c.mediaPresentationDuration=f)}c.baseUri=u,c.loadedTime=new Date,i.resolveManifestOnLoad(c),g.trigger(l.Z.ORIGINAL_MANIFEST_LOADED,{originalManifest:t})}else g.trigger(l.Z.INTERNAL_MANIFEST_LOADED,{manifest:null,error:new S.Z(w.MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE,w.MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE+"".concat(e))})}else g.trigger(l.Z.INTERNAL_MANIFEST_LOADED,{manifest:null,error:new S.Z(w.MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE,w.MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE+"".concat(e))});else g.trigger(l.Z.INTERNAL_MANIFEST_LOADED,{manifest:null})},error:function(t,n,r){g.trigger(l.Z.INTERNAL_MANIFEST_LOADED,{manifest:null,error:new S.Z(w.MANIFEST_LOADER_LOADING_FAILURE_ERROR_CODE,w.MANIFEST_LOADER_LOADING_FAILURE_ERROR_MESSAGE+"".concat(e,", ").concat(r))})}})},reset:function(){g.off(l.Z.XLINK_READY,y,t),p&&p.reset(),i&&(i.reset(),i=null),r&&(r.abort(),r=null)}},n=f.getLogger(t),g.on(l.Z.XLINK_READY,y,t),r=vt(c).create({errHandler:e.errHandler,dashMetrics:e.dashMetrics,mediaPlayerModel:e.mediaPlayerModel,requestModifier:e.requestModifier,urlUtils:h,constants:a.Z,dashConstants:o.Z,errors:w,requestTimeout:e.settings.get().streaming.manifestRequestTimeout}),i=Vn(c).create({errHandler:m,dashMetrics:e.dashMetrics,mediaPlayerModel:e.mediaPlayerModel,requestModifier:e.requestModifier,settings:e.settings}),s=null,t}jr.__dashjs_factory_name="ManifestLoader";var Hr=c.Z.getClassFactory(jr);function Vr(){var e=this.context,t=(0,u.Z)(e).getInstance();return{error:function(e){t.trigger(l.Z.ERROR,{error:e})}}}Vr.__dashjs_factory_name="ErrorHandler";var Kr=c.Z.getSingletonFactory(Vr),zr=n(1715);function Wr(){var e,t,n,r,i,o,s=this.context,c=(0,u.Z)(s).getInstance();function d(e,r){if(!r||!r.Period_asArray||0===r.Period_asArray.length)return Promise.resolve();var i=[];return r.Period_asArray.forEach((function(r){i.push(function(e,r){return new Promise((function(i){if(e&&e.AdaptationSet_asArray&&0!==e.AdaptationSet_asArray.length){var s=[];e.AdaptationSet_asArray.forEach((function(e){t.getIsTypeOf(e,r)&&s.push(function(e,r){return new Promise((function(i){if(e.Representation_asArray&&0!==e.Representation_asArray.length){var s=[],u=[];e.Representation_asArray.forEach((function(i,o){var l=t.getCodec(e,o,!1),c=function(e,t,n){switch(e){case a.Z.VIDEO:return function(e,t){return{codec:t,width:e.width||null,height:e.height||null,framerate:e.frameRate||null,bitrate:e.bandwidth||null}}(t,n);case a.Z.AUDIO:return function(e,t){var n=e.audioSamplingRate||null;return{codec:t,bitrate:e.bandwidth||null,samplerate:n}}(t,n);default:return null}}(r,i,l);u.push(c),s.push(n.supportsCodec(c,r))})),Promise.all(s).then((function(t){e.Representation_asArray=e.Representation_asArray.filter((function(e,n){return t[n]||o.debug("[Stream] Codec ".concat(u[n].codec," not supported ")),t[n]})),i()})).catch((function(){i()}))}else i()}))}(e,r))})),Promise.all(s).then((function(){e.AdaptationSet_asArray=e.AdaptationSet_asArray.filter((function(e){var t=e.Representation_asArray&&e.Representation_asArray.length>0;return t||(c.trigger(l.Z.ADAPTATION_SET_REMOVED_NO_CAPABILITIES,{adaptationSet:e}),o.warn("AdaptationSet has been removed because of no supported Representation")),t})),i()})).catch((function(){i()}))}else i()}))}(r,e))})),Promise.all(i)}return e={setConfig:function(e){e&&(e.adapter&&(t=e.adapter),e.capabilities&&(n=e.capabilities),e.settings&&(r=e.settings),e.customParametersModel&&(i=e.customParametersModel))},filterUnsupportedFeatures:function(e){return new Promise((function(s){var u=[];u.push(d(a.Z.VIDEO,e)),u.push(d(a.Z.AUDIO,e)),Promise.all(u).then((function(){r.get().streaming.capabilities.filterUnsupportedEssentialProperties&&function(e){e&&e.Period_asArray&&0!==e.Period_asArray.length&&e.Period_asArray.forEach((function(e){e.AdaptationSet_asArray=e.AdaptationSet_asArray.filter((function(e){return!e.Representation_asArray||0===e.Representation_asArray.length||(e.Representation_asArray=e.Representation_asArray.filter((function(e){var r=t.getEssentialPropertiesForRepresentation(e);if(r&&r.length>0)for(var i=0;i<r.length;){if(!n.supportsEssentialProperty(r[i]))return o.debug("[Stream] EssentialProperty not supported: "+r[i].schemeIdUri),!1;i+=1}return!0})),e.Representation_asArray&&e.Representation_asArray.length>0)}))}))}(e),function(e){var t=i.getCustomCapabilitiesFilters();t&&0!==t.length&&e&&e.Period_asArray&&0!==e.Period_asArray.length&&e.Period_asArray.forEach((function(e){e.AdaptationSet_asArray=e.AdaptationSet_asArray.filter((function(e){return!e.Representation_asArray||0===e.Representation_asArray.length||(e.Representation_asArray=e.Representation_asArray.filter((function(e){return!t.some((function(t){return!t(e)}))})),e.Representation_asArray&&e.Representation_asArray.length>0)}))}))}(e),s()})).catch((function(){s()}))}))}},o=(0,f.Z)(s).getInstance().getLogger(e),e}Wr.__dashjs_factory_name="CapabilitiesFilter";var Xr=c.Z.getSingletonFactory(Wr),Qr=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.t=null,this.xywh=null,this.track=null,this.id=null,this.s=null,this.r=null};function Jr(){var e;return{initialize:function(t){if(e=new Qr,!t)return null;var n=t.indexOf("#");if(-1!==n)for(var r=t.substr(n+1).split("&"),i=0,a=r.length;i<a;++i){var o=r[i],s=o.indexOf("=");if(-1!==s){var u=o.substring(0,s);e.hasOwnProperty(u)&&(e[u]=o.substr(s+1))}}},getURIFragmentData:function(){return e}}}Jr.__dashjs_factory_name="URIFragmentModel";var $r=c.Z.getSingletonFactory(Jr);function ei(){var e,t=this.context,n=(0,u.Z)(t).getInstance();return{getValue:function(){return e},setValue:function(t){e=t,t&&n.trigger(l.Z.MANIFEST_LOADED,{data:t})}}}ei.__dashjs_factory_name="ManifestModel";var ti=c.Z.getSingletonFactory(ei),ni=-.5;function ri(){var e,t,n,r,i=this.context,a=(0,N.Z)(i).getInstance();function o(e,n){return isNaN(e)?0:e>0?(n&&t.warn("Supplied minimum playback rate is a positive value when it should be negative or 0. The supplied rate will not be applied and set to 0: 100% playback speed."),0):e<ni?(n&&t.warn("Supplied minimum playback rate is out of range and will be limited to ".concat(ni,": ").concat(-50,"% playback speed.")),ni):e}function s(e,n){return isNaN(e)?0:e<0?(n&&t.warn("Supplied maximum playback rate is a negative value when it should be negative or 0. The supplied rate will not be applied and set to 0: 100% playback speed."),0):e>1?(n&&t.warn("Supplied maximum playback rate is out of range and will be limited to ".concat(1,": ").concat(200,"% playback speed.")),1):e}function u(){var e=a.get().streaming.buffer.stableBufferTime>0?a.get().streaming.buffer.stableBufferTime:a.get().streaming.buffer.fastSwitchEnabled?20:12,t=n.getLiveDelay();return!isNaN(t)&&t>0?Math.min(e,t):e}return e={getCatchupMaxDrift:function(){if(!isNaN(a.get().streaming.liveCatchup.maxDrift)&&a.get().streaming.liveCatchup.maxDrift>0)return a.get().streaming.liveCatchup.maxDrift;var e=r.getServiceDescriptionSettings();return e&&e.liveCatchup&&!isNaN(e.liveCatchup.maxDrift)&&e.liveCatchup.maxDrift>0?e.liveCatchup.maxDrift:12},getCatchupModeEnabled:function(){return null!==a.get().streaming.liveCatchup.enabled?a.get().streaming.liveCatchup.enabled:n.getInitialCatchupModeActivated()},getStableBufferTime:u,getInitialBufferLevel:function(){var e=a.get().streaming.buffer.initialBufferLevel;return isNaN(e)||e<0?0:Math.min(u(),e)},getRetryAttemptsForType:function(e){var t=isNaN(a.get().streaming.retryAttempts.lowLatencyMultiplyFactor)?5:a.get().streaming.retryAttempts.lowLatencyMultiplyFactor;return n.getLowLatencyModeEnabled()?a.get().streaming.retryAttempts[e]*t:a.get().streaming.retryAttempts[e]},getRetryIntervalsForType:function(e){var t=isNaN(a.get().streaming.retryIntervals.lowLatencyReductionFactor)?10:a.get().streaming.retryIntervals.lowLatencyReductionFactor;return n.getLowLatencyModeEnabled()?a.get().streaming.retryIntervals[e]/t:a.get().streaming.retryIntervals[e]},getCatchupPlaybackRates:function(e){var t=a.get().streaming.liveCatchup.playbackRate;if(!isNaN(t.min)||!isNaN(t.max))return{min:o(t.min,e),max:s(t.max,e)};var n=r.getServiceDescriptionSettings();if(n&&n.liveCatchup&&(!isNaN(n.liveCatchup.playbackRate.min)||!isNaN(n.liveCatchup.playbackRate.max))){var i=n.liveCatchup.playbackRate;return{min:o(i.min,e),max:s(i.max,e)}}return{min:-.5,max:.5}},getAbrBitrateParameter:function(e,t){try{var n=a.get().streaming.abr[e][t];if(!isNaN(n)&&-1!==n)return n;var i=r.getServiceDescriptionSettings();return i&&i[e]&&!isNaN(i[e][t])?i[e][t]:-1}catch(e){return-1}},setConfig:function(e){e.playbackController&&(n=e.playbackController),e.serviceDescriptionController&&(r=e.serviceDescriptionController)},reset:function(){}},t=(0,f.Z)(i).getInstance().getLogger(e),e}ri.__dashjs_factory_name="MediaPlayerModel";var ii=c.Z.getSingletonFactory(ri),ai=n(1767);function oi(e){var t=(e=e||{}).abrController,n=e.switchHistory,r=e.droppedFramesHistory,i=e.currentRequest,a=e.useBufferOccupancyABR,o=e.useL2AABR,s=e.useLoLPABR,u=e.streamProcessor?e.streamProcessor.getScheduleController():null,l=e.streamProcessor?e.streamProcessor.getRepresentationInfo():null,c=e.videoModel?e.videoModel:null;function f(){return l?l.mediaInfo:null}return{getMediaType:function(){var e=f();return e?e.type:null},getMediaInfo:f,getDroppedFramesHistory:function(){return r},getCurrentRequest:function(){return i},getSwitchHistory:function(){return n},getStreamInfo:function(){var e=f();return e?e.streamInfo:null},getScheduleController:function(){return u},getAbrController:function(){return t},getRepresentationInfo:function(){return l},useBufferOccupancyABR:function(){return a},useL2AABR:function(){return o},useLoLPABR:function(){return s},getVideoModel:function(){return c}}}oi.__dashjs_factory_name="RulesContext";var si=c.Z.getClassFactory(oi),ui=n(2068);function li(){var e=[],t=[];return{push:function(n){n.newValue===ui.Z.NO_CHANGE&&(n.newValue=n.oldValue),e[n.oldValue]||(e[n.oldValue]={noDrops:0,drops:0,dropSize:0});var r=n.newValue-n.oldValue,i=r<0?1:0,a=i?-r:0,o=i?0:1;if(e[n.oldValue].drops+=i,e[n.oldValue].dropSize+=a,e[n.oldValue].noDrops+=o,t.push({idx:n.oldValue,noDrop:o,drop:i,dropSize:a}),t.length>8){var s=t.shift();e[s.idx].drops-=s.drop,e[s.idx].dropSize-=s.dropSize,e[s.idx].noDrops-=s.noDrop}},getSwitchRequests:function(){return e},reset:function(){e=[],t=[]}}}li.__dashjs_factory_name="SwitchRequestHistory";var ci=c.Z.getClassFactory(li);function fi(){var e={},t={},n={};return{push:function(r,i,a){if(i){e[r]||(e[r]=[],t[r]=0,n[r]=0);var o=a&&a.droppedVideoFrames?a.droppedVideoFrames:0,s=a&&a.totalVideoFrames?a.totalVideoFrames:0,u=o-t[r];t[r]=o;var l=s-n[r];n[r]=s;var c=e[r];isNaN(i)||(c[i]?(c[i].droppedVideoFrames+=u,c[i].totalVideoFrames+=l):c[i]={droppedVideoFrames:u,totalVideoFrames:l})}},getFrameHistory:function(t){return e[t]},clearForStream:function(r){try{delete e[r],delete t[r],delete n[r]}catch(e){}},reset:function(){e={},t={},n={}}}}fi.__dashjs_factory_name="DroppedFramesHistory";var di=c.Z.getClassFactory(fi);function gi(e){var t,n,r,i,o,s=this.context,l=(e=e||{}).settings,c=(0,u.Z)(s).getInstance();function f(e,t,n,r){var i=Math.pow(.5,n/r.fast);e.fastEstimate=(1-i)*t+i*e.fastEstimate;var a=Math.pow(.5,n/r.slow);e.slowEstimate=(1-a)*t+a*e.slowEstimate,e.totalWeight+=n}function g(e,s,u){return l.get().streaming.abr.movingAverageMethod!==a.Z.MOVING_AVERAGE_SLIDING_WINDOW?function(e,t){var n=e?o.throughputHalfLife:o.latencyHalfLife,a=e?r[t]:i[t];if(!a||a.totalWeight<=0)return NaN;var s=a.fastEstimate/(1-Math.pow(.5,a.totalWeight/n.fast)),u=a.slowEstimate/(1-Math.pow(.5,a.totalWeight/n.slow));return e?Math.min(s,u):Math.max(s,u)}(e,s):function(e,r,i){var a=function(e,r,i){var a,o;if(e?(a=t[r],o=i?3:4):(a=n[r],o=4),a){if(o>=a.length)o=a.length;else if(e)for(var s=1;s<o;++s){var u=a[a.length-s]/a[a.length-s-1];if((u>=1.3||u<=1/1.3)&&(o+=1)===a.length)break}}else o=0;return o}(e,r,i),o=(e?t:n)[r];return 0!==a&&o&&0!==o.length?(o=o.slice(-a)).reduce((function(e,t){return e+t}))/o.length:NaN}(e,s,u)}function h(e,t){return g(!0,e,t)}function p(e){t[e]=t[e]||[],n[e]=n[e]||[],r[e]=r[e]||{fastEstimate:0,slowEstimate:0,totalWeight:0},i[e]=i[e]||{fastEstimate:0,slowEstimate:0,totalWeight:0}}function m(){t={},n={},r={},i={}}var y={push:function(e,s,u){if(s.trace&&s.trace.length){var g,h=s.tresponse.getTime()-s.trequest.getTime()||1,m=s._tfinish.getTime()-s.tresponse.getTime()||1,y=s.trace.reduce((function(e,t){return e+t.b[0]}),0),E=0;if(0!==(g=s._fileLoaderType&&s._fileLoaderType===a.Z.FILE_LOADER_TYPES.FETCH?s.trace.reduce((function(e,t){return e+t.d}),0):u?m:h+m)&&(E=Math.round(8*y/g)),s.cmsd){var v=s.cmsd.dynamic&&s.cmsd.dynamic.etp?s.cmsd.dynamic.etp:null;if(v){var _=l.get().streaming.cmsd.abr.etpWeightRatio;_>0&&_<=1&&(E=E*(1-_)+v*_)}}if(p(e),function(e,t,n){return e===a.Z.VIDEO?n<l.get().streaming.cacheLoadThresholds[a.Z.VIDEO]:e===a.Z.AUDIO?n<l.get().streaming.cacheLoadThresholds[a.Z.AUDIO]:void 0}(e,0,m)){if(t[e].length>0&&!t[e].hasCachedEntries)return;t[e].hasCachedEntries=!0}else t[e]&&t[e].hasCachedEntries&&function(e){delete t[e],delete n[e],delete r[e],delete i[e],p(e)}(e);t[e].push(E),c.trigger(d.Z.THROUGHPUT_MEASUREMENT_STORED,{throughput:E,mediaType:e,httpRequest:s}),t[e].length>20&&t[e].shift(),n[e].push(h),n[e].length>20&&n[e].shift(),f(r[e],E,.001*m,o.throughputHalfLife),f(i[e],h,1,o.latencyHalfLife)}},getAverageThroughput:h,getSafeAverageThroughput:function(e,t){var n=h(e,t);return isNaN(n)||(n*=l.get().streaming.abr.bandwidthSafetyFactor),n},getAverageLatency:function(e){return g(!1,e)},reset:m};return o={throughputHalfLife:{fast:3,slow:8},latencyHalfLife:{fast:1,slow:2}},m(),y}gi.__dashjs_factory_name="ThroughputHistory";var hi=c.Z.getClassFactory(gi);function pi(){var e,t,n,r,i,o,c,g,h,p,m,y,E,v,_,S,b,A,I,R,w,N,D,O,M,P,L,x=this.context,F=(0,f.Z)(x).getInstance(),k=(0,u.Z)(x).getInstance();function U(){i={},o={},g={},c={},R={},D={},O={},M={},void 0===p&&(p=!1),w&&w.reset(),I=void 0,w=void 0,N=void 0,clearTimeout(h),h=null}function Z(t){var i=t.request.mediaType,a=t.streamId;if(i&&a&&c[a]&&L.get().streaming.abr.autoSwitchBitrate[i]){var o=c[a][i];if(o){var u=si(x).create({abrController:e,streamProcessor:o,currentRequest:t.request,useBufferOccupancyABR:D[i],useL2AABR:O[i],useLoLPABR:M[i],videoModel:v}),l=n.shouldAbandonFragment(u,a);l.quality>ui.Z.NO_CHANGE&&o.getFragmentModel().getRequests({state:T.FRAGMENT_MODEL_LOADING,index:t.request.index})[0]&&(g[a][i].state=s.Z.ABANDON_LOAD,R[a][i].reset(),R[a][i].push({oldValue:j(i,a),newValue:l.quality,confidence:1,reason:l.reason}),H(i,r.getActiveStreamInfo(),l.quality,l.reason),clearTimeout(h),h=setTimeout((function(){g[a][i].state=s.Z.ALLOW_LOAD,h=null}),L.get().streaming.abandonLoadTimeout))}}}function B(e){e.mediaType===a.Z.VIDEO&&(void 0!==I&&w.push(e.streamId,I,v.getPlaybackQuality()),I=e.newQuality)}function G(e){var n,r;e.metric!==s.Z.HTTP_REQUEST||!e.value||e.value.type!==C.w.MEDIA_SEGMENT_TYPE||e.mediaType!==a.Z.AUDIO&&e.mediaType!==a.Z.VIDEO||N.push(e.mediaType,e.value,L.get().streaming.abr.useDeadTimeLatency),e.metric!==s.Z.BUFFER_LEVEL||e.mediaType!==a.Z.AUDIO&&e.mediaType!==a.Z.VIDEO||(n=e.mediaType,r=.001*e.value.level,L.get().streaming.abr.ABRStrategy===a.Z.ABR_STRATEGY_DYNAMIC&&function(e,n){try{var r=_.getStableBufferTime(),i=r,a=.5*r,o=D[e],s=n>(o?a:i);D[e]=s,s!==o&&(s?t.info("["+e+"] switching from throughput to buffer occupancy ABR rule (buffer: "+n.toFixed(3)+")."):t.info("["+e+"] switching from buffer occupancy to throughput ABR rule (buffer: "+n.toFixed(3)+")."))}catch(e){t.error(e)}}(n,r))}function q(e,n){try{var r;return i[n]=i[n]||{},i[n].hasOwnProperty(e)||(i[n][e]=0),r=function(e,t){var n=i[t][e],r=n;if(!c[t]||!c[t][e])return r;var a=Y(e,t);void 0!==a&&(r=Math.max(n,a));var o=function(e,t){try{var n=_.getAbrBitrateParameter("maxBitrate",e);return n>-1?W(c[t][e].getMediaInfo(),n,t):void 0}catch(e){return}}(e,t);return void 0!==o&&(r=Math.min(r,o)),r}(e,n),r=function(e,t,n){var r=i[n][t],a=L.get().streaming.abr.maxRepresentationRatio[t];return isNaN(a)||a>=1||a<0?e:Math.min(e,Math.round(r*a))}(r,e,n),r=function(e,t,n){if(t!==a.Z.VIDEO||!L.get().streaming.abr.limitBitrateByPortal||!c[n]||!c[n][t])return e;p||Q();var r=c[n][t].getStreamInfo(),i=E.getAdaptationForType(r.index,t,r).Representation_asArray,o=e;if(m>0&&y>0){for(;o>0&&i[o]&&m<i[o].width&&m-i[o-1].width<i[o].width-m;)o-=1;for(;o<i.length-1&&i[o].width===i[o+1].width;)o+=1}return o}(r,e,n),L.get().streaming.cmsd.enabled&&L.get().streaming.cmsd.abr.applyMb&&(r=function(e,n,r){if("video"!==n)return e;var i=b.getMaxBitrate(n);if(i<0)return e;var a=K(r,"audio",j("audio",r));i-=a?a.bitrate/1e3:0;var o=W(c[r][n].getMediaInfo(),i,r);return t.debug("Stream ID: "+r+" ["+n+"] Apply max bit rate from CMSD: "+i),Math.min(e,o)}(r,e,n)),r}catch(e){return}}function Y(e,t){try{return function(e,t){try{var n=_.getAbrBitrateParameter("minBitrate",e);if(n>-1){var r=c[t][e].getMediaInfo(),i=X(r),a=W(r,n,t);return i[a]&&a<i.length-1&&i[a].bitrate<1e3*n&&a++,a}return}catch(e){return}}(e,t)}catch(e){return}}function j(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;try{return t||(t=r.getActiveStreamInfo().id),e&&c[t]&&c[t][e]&&t?(o[t]=o[t]||{},o[t].hasOwnProperty(e)||(o[t][e]=0),o[t][e]):0}catch(e){return 0}}function H(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null;if(t&&t.id&&e){var i=t.id,a=j(e,i);(0,z.SE)(n);var o=q(e,i);n!==a&&n>=0&&n<=o&&V(e,a,n,o,r,i)}}function V(e,n,r,i,a,s){if(e&&c[s]&&c[s][e]){var u=c[s][e].getStreamInfo(),f=u&&u.manifestInfo&&u.manifestInfo.isDynamic,d=P.getCurrentBufferLevel(e);t.info("Stream ID: "+s+" ["+e+"] switch from "+n+" to "+r+"/"+i+" (buffer: "+d+") "+(a?JSON.stringify(a):".")),o[s]=o[s]||{},o[s][e]=r;var g=K(s,e,r);k.trigger(l.Z.QUALITY_CHANGE_REQUESTED,{oldQuality:n,newQuality:r,reason:a,streamInfo:u,bitrateInfo:g,maxIdx:i,mediaType:e},{streamId:u.id,mediaType:e});var h=N.getAverageThroughput(e,f);isNaN(h)||A.setSavedBitrateSettings(e,h)}}function K(e,t,n){if(t&&c&&c[e]&&c[e][t]){var r=X(c[e][t].getMediaInfo());return r[n]?r[n]:null}return null}function W(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,i=e&&e.type?c[n][e.type].getRepresentationInfo():null;if(L.get().streaming.abr.useDeadTimeLatency&&r&&i&&i.fragmentDuration){r/=1e3;var a=i.fragmentDuration;if(r>a)return 0;var o=r/a;t*=1-o}for(var s=X(e),u=s.length-1;u>=0;u--){var l=s[u];if(1e3*t>=l.bitrate)return u}return 0}function X(e){var t=[];if(!e||!e.bitrateList)return t;for(var n,r=e.bitrateList,i=e.type,a=0,o=r.length;a<o;a++)(n=new Mt).mediaType=i,n.qualityIndex=a,n.bitrate=r[a].bandwidth,n.width=r[a].width,n.height=r[a].height,n.scanType=r[a].scanType,t.push(n);return t}function Q(){if(v){var e=L.get().streaming.abr.usePixelRatioInLimitBitrateByPortal&&window.hasOwnProperty("devicePixelRatio")?window.devicePixelRatio:1;m=v.getClientWidth()*e,y=v.getClientHeight()*e}}return e={initialize:function(){w=di(x).create(),N=hi(x).create({settings:L}),(n=(0,ai.Z)(x).create({dashMetrics:P,customParametersModel:S,mediaPlayerModel:_,settings:L})).initialize(),k.on(d.Z.QUALITY_CHANGE_RENDERED,B,e),k.on(d.Z.METRIC_ADDED,G,e),k.on(l.Z.LOADING_PROGRESS,Z,e)},isPlayingAtTopQuality:function(e){var t=e?e.id:null,n=j(a.Z.AUDIO,t),r=j(a.Z.VIDEO,t);return n===q(a.Z.AUDIO,t)&&r===q(a.Z.VIDEO,t)},updateTopQualityIndex:function(e){var t=e.type,n=e.streamInfo.id,r=e.representationCount-1;return i[n]=i[n]||{},i[n][t]=r,r},clearDataForStream:function(e){w&&w.clearForStream(e),c[e]&&delete c[e],R[e]&&delete R[e],g[e]&&delete g[e]},getThroughputHistory:function(){return N},getBitrateList:X,getQualityForBitrate:W,getTopBitrateInfoFor:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;if(t||(t=r.getActiveStreamInfo().id),e&&c&&c[t]&&c[t][e]){var n=q(e,t),i=X(c[t][e].getMediaInfo());return i[n]?i[n]:null}return null},getMinAllowedIndexFor:Y,getMaxAllowedIndexFor:q,getInitialBitrateFor:function(e,t){if(function(){if(!A||!A.hasOwnProperty("getSavedBitrateSettings"))throw new Error(a.Z.MISSING_CONFIG_ERROR)}(),e===a.Z.TEXT)return NaN;var n=A.getSavedBitrateSettings(e),r=_.getAbrBitrateParameter("initialBitrate",e),i=L.get().streaming.abr.initialRepresentationRatio[e];if(-1===r)if(i>-1){var o=c[t][e].getStreamInfo(),s=E.getAdaptationForType(o.index,e,o).Representation_asArray;r=Array.isArray(s)?s[Math.max(Math.round(s.length*i)-1,0)].bandwidth/1e3:0}else r=isNaN(n)?e===a.Z.VIDEO?1e3:100:n;return r},getQualityFor:j,getAbandonmentStateFor:function(e,t){return g[e]&&g[e][t]?g[e][t].state:null},setPlaybackQuality:H,checkPlaybackQuality:function(t,r){try{if(!(t&&c&&c[r]&&c[r][t]))return!1;if(w){var i=v.getPlaybackQuality();i&&w.push(r,I,i)}if(!L.get().streaming.abr.autoSwitchBitrate[t])return!1;var a=j(t,r),o=si(x).create({abrController:e,switchHistory:R[r][t],droppedFramesHistory:w,streamProcessor:c[r][t],currentValue:a,useBufferOccupancyABR:D[t],useL2AABR:O[t],useLoLPABR:M[t],videoModel:v}),u=Y(t,r),l=q(t,r),f=n.getMaxQuality(o),d=f.quality;return void 0!==u&&(d>ui.Z.NO_CHANGE?d:a)<u&&(d=u),d>l&&(d=l),R[r][t].push({oldValue:a,newValue:d}),d>ui.Z.NO_CHANGE&&d!==a&&(g[r][t].state===s.Z.ALLOW_LOAD||d<a)&&(V(t,a,d,l,f.reason,r),!0)}catch(e){return!1}},setElementSize:Q,setWindowResizeEventCalled:function(e){p=e},registerStreamType:function(e,t){var n=t.getStreamInfo().id;c[n]||(c[n]={}),R[n]||(R[n]={}),g[n]||(g[n]={}),R[n][e]=ci(x).create(),c[n][e]=t,g[n][e]={},g[n][e].state=s.Z.ALLOW_LOAD,function(e){var t=L.get().streaming.abr.ABRStrategy;t===a.Z.ABR_STRATEGY_L2A?(D[e]=!1,M[e]=!1,O[e]=!0):t===a.Z.ABR_STRATEGY_LoLP?(D[e]=!1,M[e]=!0,O[e]=!1):t===a.Z.ABR_STRATEGY_BOLA?(D[e]=!0,M[e]=!1,O[e]=!1):t===a.Z.ABR_STRATEGY_THROUGHPUT?(D[e]=!1,M[e]=!1,O[e]=!1):t===a.Z.ABR_STRATEGY_DYNAMIC&&(D[e]=!(!D||!D[e])&&D[e],M[e]=!1,O[e]=!1)}(e),e===a.Z.VIDEO&&Q()},unRegisterStreamType:function(e,t){try{c[e]&&c[e][t]&&delete c[e][t],R[e]&&R[e][t]&&delete R[e][t],g[e]&&g[e][t]&&delete g[e][t]}catch(e){}},setConfig:function(e){e&&(e.streamController&&(r=e.streamController),e.domStorage&&(A=e.domStorage),e.mediaPlayerModel&&(_=e.mediaPlayerModel),e.customParametersModel&&(S=e.customParametersModel),e.cmsdModel&&(b=e.cmsdModel),e.dashMetrics&&(P=e.dashMetrics),e.adapter&&(E=e.adapter),e.videoModel&&(v=e.videoModel),e.settings&&(L=e.settings))},reset:function(){U(),k.off(l.Z.LOADING_PROGRESS,Z,e),k.off(d.Z.QUALITY_CHANGE_RENDERED,B,e),k.off(d.Z.METRIC_ADDED,G,e),n&&n.reset()}},t=F.getLogger(e),U(),e}pi.__dashjs_factory_name="AbrController";var mi=c.Z.getSingletonFactory(pi);mi.QUALITY_DEFAULT=0,c.Z.updateSingletonFactory(pi.__dashjs_factory_name,mi);var yi=mi,Ei=new Map([[a.Z.VIDEO_ELEMENT_READY_STATES.HAVE_METADATA,"loadedmetadata"],[a.Z.VIDEO_ELEMENT_READY_STATES.HAVE_CURRENT_DATA,"loadeddata"],[a.Z.VIDEO_ELEMENT_READY_STATES.HAVE_FUTURE_DATA,"canplay"],[a.Z.VIDEO_ELEMENT_READY_STATES.HAVE_ENOUGH_DATA,"canplaythrough"]]);function vi(){var e,t,n,r,i,o,s,c,d=this.context,g=(0,u.Z)(d).getInstance(),h=[];function p(){n&&(n.playbackRate=1,n.removeEventListener("canplay",p))}function m(){return h.length>0}function y(){if(n&&m()&&0===n.playbackRate){var e=document.createEvent("Event");e.initEvent("waiting",!0,!1),n.dispatchEvent(e)}}function E(e,t){n&&n.addEventListener(e,t)}function v(e,t){n&&n.removeEventListener(e,t)}function _(){return n?n.readyState:NaN}function T(){return n?n.buffered:null}function S(e,t,r,i,a){if(n)for(var o=0;o<n.textTracks.length;o++)if(n.textTracks[o].kind===e&&(!t||n.textTracks[o].label==t)&&n.textTracks[o].language===r&&n.textTracks[o].isTTML===i&&n.textTracks[o].isEmbedded===a)return n.textTracks[o];return null}function b(e,t){return e===a.Z.VIDEO_ELEMENT_READY_STATES.HAVE_NOTHING||_()>=e?(t(),null):function(e,t){var n=function n(){v(e,n),t(e)};return E(e,n),{func:n,event:e}}(Ei.get(e),t)}return e={addEventListener:E,addTextTrack:function(e,t,r,i,a){if(!n)return null;var o=S(e,t,r,i,a);return o||((o=n.addTextTrack(e,t,r)).isEmbedded=a,o.isTTML=i),o},appendChild:function(e){n&&(n.appendChild(e),void 0!==e.isTTML&&(n.textTracks[n.textTracks.length-1].isTTML=e.isTTML,n.textTracks[n.textTracks.length-1].isEmbedded=e.isEmbedded))},getBufferRange:T,getClientHeight:function(){return n?n.clientHeight:NaN},getClientWidth:function(){return n?n.clientWidth:NaN},getElement:function(){return n},getEnded:function(){return n?n.ended:null},getPlaybackQuality:function(){if(!n)return null;var e="webkitDroppedFrameCount"in n&&"webkitDecodedFrameCount"in n,t=null;return"getVideoPlaybackQuality"in n?t=n.getVideoPlaybackQuality():e&&(t={droppedVideoFrames:n.webkitDroppedFrameCount,totalVideoFrames:n.webkitDroppedFrameCount+n.webkitDecodedFrameCount,creationTime:new Date}),t},getPlaybackRate:function(){return n?n.playbackRate:null},getPlayedRanges:function(){return n?n.played:null},getReadyState:_,getSource:function(){return n?n.src:null},getTTMLRenderingDiv:function(){return o},getTextTrack:S,getTextTracks:function(){return n?n.textTracks:[]},getTime:function(){return n?isNaN(r)?n.currentTime:r:null},getVideoHeight:function(){return n?n.videoHeight:NaN},getVideoRelativeOffsetLeft:function(){if(n){var e=n.parentNode.host||n.parentNode;return e?n.getBoundingClientRect().left-e.getBoundingClientRect().left:NaN}return NaN},getVideoRelativeOffsetTop:function(){if(n){var e=n.parentNode.host||n.parentNode;return e?n.getBoundingClientRect().top-e.getBoundingClientRect().top:NaN}return NaN},getVideoWidth:function(){return n?n.videoWidth:NaN},getVttRenderingDiv:function(){return s},initialize:function(){g.on(l.Z.PLAYBACK_PLAYING,y,this)},isPaused:function(){return n?n.paused:null},isSeeking:function(){return n?n.seeking||!isNaN(r):null},isStalled:m,pause:function(){n&&(n.pause(),n.autoplay=!1)},play:function(){if(n){n.autoplay=!0;var e=n.play();e&&e.catch&&"undefined"!=typeof Promise&&e.catch((function(e){"NotAllowedError"===e.name&&g.trigger(l.Z.PLAYBACK_NOT_ALLOWED),t.warn("Caught pending play exception - continuing (".concat(e,")"))}))}},removeChild:function(e){n&&n.removeChild(e)},removeEventListener:v,reset:function(){clearTimeout(c),g.off(l.Z.PLAYBACK_PLAYING,y,this)},setCurrentTime:function(e,t){n&&(i&&i.func&&i.event&&v(i.event,i.func),r=e,i=b(a.Z.VIDEO_ELEMENT_READY_STATES.HAVE_METADATA,(function(){if(n)if(n.currentTime!==r)try{r=t?function(e){var t=T(),n=e,r=9999999999;if(t)for(var i=0;i<t.length;i++){var a=t.start(i),o=t.end(i),s=Math.abs(a-e),u=Math.abs(o-e);if(e>=a&&e<=o)return e;s<r&&(r=s,n=a),u<r&&(r=u,n=o)}return n}(r):r,isNaN(r)||(n.currentTime=r),r=NaN}catch(e){0===n.readyState&&e.code===e.INVALID_STATE_ERR&&(c=setTimeout((function(){n.currentTime=r,r=NaN}),400))}else r=NaN})))},setElement:function(e){if(!(null==e||e&&/^(VIDEO|AUDIO)$/i.test(e.nodeName)))throw"element is not video or audio DOM type!";(n=e)&&(n.preload="auto")},setPlaybackRate:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];n&&(!t&&n.readyState<=2&&e>0?n.addEventListener("canplay",p):n.playbackRate=e)},setSource:function(e){n&&(e?n.src=e:(n.removeAttribute("src"),n.load()))},setStallState:function(e,t){!function(e,t){t?function(e){null!==e&&n&&!n.seeking&&-1===h.indexOf(e)&&h.push(e)}(e):function(e){var t=h.indexOf(e);null!==e&&-1!==t&&h.splice(t,1)}(e)}(e,t)},setTTMLRenderingDiv:function(e){(o=e).style.position="absolute",o.style.display="flex",o.style.overflow="hidden",o.style.pointerEvents="none",o.style.top=0,o.style.left=0},setVttRenderingDiv:function(e){s=e},waitForReadyState:b,setDisableRemotePlayback:function(e){n&&(n.disableRemotePlayback=e)}},t=(0,f.Z)(d).getInstance().getLogger(e),r=NaN,e}vi.__dashjs_factory_name="VideoModel";var _i=c.Z.getSingletonFactory(vi),Ti=[{oldKey:"dashjs_vbitrate",newKey:"dashjs_video_bitrate"},{oldKey:"dashjs_abitrate",newKey:"dashjs_audio_bitrate"},{oldKey:"dashjs_vsettings",newKey:"dashjs_video_settings"},{oldKey:"dashjs_asettings",newKey:"dashjs_audio_settings"}],Si="dashjs_?_bitrate",bi="dashjs_?_settings",Ai="localStorage",Ii="lastBitrate",Ri="lastMediaSettings";function wi(e){e=e||{};var t,n,r,i=this.context,o=e.settings;function s(e){if(void 0!==r)return r;var t;r=!1;try{"undefined"!=typeof window&&(t=window[e])}catch(e){return n.warn("DOMStorage access denied: "+e.message),r}if(!t||e!==Ai&&"sessionStorage"!==e)return r;try{t.setItem("1","1"),t.removeItem("1"),r=!0}catch(e){n.warn("DOMStorage is supported, but cannot be used: "+e.message)}return r}function u(){var e=6e5;return Math.round((new Date).getTime()/e)*e}function l(e,t){return s(e)&&o.get().streaming[t+"CachingInfo"].enabled}function c(){if(!o)throw new Error(a.Z.MISSING_CONFIG_ERROR)}return t={getSavedBitrateSettings:function(e){if(c(),!o.get().streaming.lastBitrateCachingInfo.enabled)return NaN;var t=NaN;if(l(Ai,Ii)){var r=Si.replace(/\\?/,e);try{var i=JSON.parse(localStorage.getItem(r))||{},a=(new Date).getTime()-parseInt(i.timestamp,10)>=o.get().streaming.lastBitrateCachingInfo.ttl||!1,s=parseFloat(i.bitrate);isNaN(s)||a?a&&localStorage.removeItem(r):(t=s,n.debug("Last saved bitrate for "+e+" was "+s))}catch(e){return null}}return t},setSavedBitrateSettings:function(e,t){if(l(Ai,Ii)&&t){var r=Si.replace(/\\?/,e);try{localStorage.setItem(r,JSON.stringify({bitrate:t.toFixed(3),timestamp:u()}))}catch(e){n.error(e.message)}}},getSavedMediaSettings:function(e){if(c(),!o.get().streaming.lastMediaSettingsCachingInfo.enabled)return null;var t=null;if(l(Ai,Ri)){var n=bi.replace(/\\?/,e);try{var r=JSON.parse(localStorage.getItem(n))||{},i=(new Date).getTime()-parseInt(r.timestamp,10)>=o.get().streaming.lastMediaSettingsCachingInfo.ttl||!1;t=r.settings,i&&(localStorage.removeItem(n),t=null)}catch(e){return null}}return t},setSavedMediaSettings:function(e,t){if(l(Ai,Ri)){var r=bi.replace(/\\?/,e);try{localStorage.setItem(r,JSON.stringify({settings:t,timestamp:u()}))}catch(e){n.error(e.message)}}}},n=(0,f.Z)(i).getInstance().getLogger(t),s(Ai)&&Ti.forEach((function(e){var t=localStorage.getItem(e.oldKey);if(t){localStorage.removeItem(e.oldKey);try{localStorage.setItem(e.newKey,t)}catch(e){n.error(e.message)}}})),t}wi.__dashjs_factory_name="DOMStorage";var Ni=c.Z.getSingletonFactory(wi),Ci=n(2032),Di=n(2011);function Oi(){var e,t,n,r,i,a,o,s,u,l,c,f,d,g=this.context;function h(e,n,i,a){var o=null,u=e?d.resolve(e.path):null,l=a||{init:!0,url:u?u.url:void 0,range:{start:0,end:1500},searching:!1,bytesLoaded:0,bytesToLoad:1500,mediaType:n};t.debug("Start searching for initialization.");var c=E(l);s.load({request:c,success:function(t){if(l.bytesLoaded=l.range.end,!(o=r.findInitRange(t)))return l.range.end=l.bytesLoaded+l.bytesToLoad,h(e,n,i,l);e.range=o,i(e)},error:function(){i(e)}}),t.debug("Perform init search: "+l.url)}function m(e,n,i,a,o,u){if(i&&(void 0===i.start||void 0===i.end)){var l=i?i.toString().split("-"):null;i=l?{start:parseFloat(l[0]),end:parseFloat(l[1])}:null}o=o||y;var c=null,f=null,g=!!i,h=e?d.resolve(e.path):null,p={init:!1,url:h?h.url:void 0,range:g?i:{start:0,end:1500},searching:!g,bytesLoaded:u?u.bytesLoaded:0,bytesToLoad:1500,mediaType:n},v=E(p);s.load({request:v,success:function(i){var s=p.bytesToLoad,u=i.byteLength;if(p.bytesLoaded=p.range.end-p.range.start,c=r.parse(i),(f=c.getBox("sidx"))&&f.isComplete){var l,d,g=f.references;if(null!=g&&g.length>0&&(l=1===g[0].reference_type),l){var h,y,E,v;t.debug("Initiate multiple SIDX load."),p.range.end=p.range.start+f.size;var _=[],T=0,S=(f.offset||p.range.start)+f.size,b=function(t){t?(_=_.concat(t),++T>=y&&(_.sort((function(e,t){return e.startTime-t.startTime<0?-1:0})),o(_,e,a))):o(null,e,a)};for(h=0,y=g.length;h<y;h++)E=S,v=S+g[h].referenced_size-1,S+=g[h].referenced_size,m(e,n,{start:E,end:v},a,b,p)}else t.debug("Parsing segments from SIDX. representation "+n+" - id: "+e.id+" for range : "+p.range.start+" - "+p.range.end),d=function(e,t){for(var n,r,i,a,o=e.references,s=o.length,u=e.timescale,l=e.earliest_presentation_time,c=t.range.start+e.offset+e.first_offset+e.size,f=[],d=0;d<s;d++)i=o[d].subsegment_duration,a=o[d].referenced_size,(n=new Di.Z).duration=i,n.startTime=l,n.timescale=u,r=c+a-1,n.mediaRange=c+"-"+r,f.push(n),l+=i,c+=a;return f}(f,p),o(d,e,a)}else{if(f)p.range.start=f.offset||p.range.start,p.range.end=p.range.start+(f.size||s);else{if(u<p.bytesLoaded)return void o(null,e,a);var A=c.getLastBox();A&&A.size?(p.range.start=A.offset+A.size,p.range.end=p.range.start+s):p.range.end+=s}m(e,n,p.range,a,null,p)}},error:function(){o(null,e,a)}}),t.debug("Perform SIDX load for type ".concat(n," : ").concat(p.url," with range ").concat(p.range.start," - ").concat(p.range.end))}function y(e,t,n){n({segments:e,representation:t,error:e?void 0:new S.Z(u.SEGMENT_BASE_LOADER_ERROR_CODE,u.SEGMENT_BASE_LOADER_ERROR_MESSAGE)})}function E(e){if(e.url){var t=new p.Z;return t.setInfo(e),t}}return e={setConfig:function(s){s.baseURLController&&(d=s.baseURLController),s.dashMetrics&&(a=s.dashMetrics),s.mediaPlayerModel&&(o=s.mediaPlayerModel),s.errHandler&&(n=s.errHandler),s.boxParser&&(r=s.boxParser),s.debug&&(t=s.debug.getLogger(e)),s.requestModifier&&(i=s.requestModifier),s.errors&&(u=s.errors),s.urlUtils&&(f=s.urlUtils),s.constants&&(l=s.constants),s.dashConstants&&(c=s.dashConstants)},initialize:function(){s=vt(g).create({errHandler:n,dashMetrics:a,mediaPlayerModel:o,requestModifier:i,boxParser:r,errors:u,urlUtils:f,constants:l,dashConstants:c})},loadInitialization:function(e,t){return new Promise((function(n){h(e,t,n)}))},loadSegments:function(e,t,n){return new Promise((function(r){m(e,t,n,r)}))},reset:function(){s&&(s.abort(),s=null)}}}Oi.__dashjs_factory_name="SegmentBaseLoader";var Mi=c.Z.getSingletonFactory(Oi);function Pi(e){var t;e=e||{};var n=new DataView(e.data),r=0;function i(e,t){var i=!0,a=0;if(void 0===t&&(t=!1),e.tag>16777215?(n.getUint32(r)!==e.tag&&(i=!1),a=4):e.tag>65535?(256*n.getUint16(r)+n.getUint8(r+2)!==e.tag&&(i=!1),a=3):e.tag>255?(n.getUint16(r)!==e.tag&&(i=!1),a=2):(n.getUint8(r)!==e.tag&&(i=!1),a=1),!i&&e.required&&!t)throw new Error("required tag not found");return i&&(r+=a),i}function a(e){var t=1,i=128,a=-1,o=0,s=n.getUint8(r),u=0;for(u=0;u<8;u+=1){if((s&i)===i){o=void 0===e?s&~i:s,a=u;break}i>>=1}for(u=0;u<a;u+=1,t+=1)o=o<<8|255&n.getUint8(r+t);return r+=t,o}return t={getPos:function(){return r},setPos:function(e){r=e},consumeTag:i,consumeTagAndSize:function(e,t){var n=i(e,t);return n&&a(),n},parseTag:function(e){var n;return i(e),n=a(),t[e.parse](n)},skipOverElement:function(e,t){var n,o=i(e,t);return o&&(n=a(),r+=n),o},getMatroskaCodedNum:a,getMatroskaFloat:function(e){var t;switch(e){case 4:t=n.getFloat32(r),r+=4;break;case 8:t=n.getFloat64(r),r+=8}return t},getMatroskaUint:function(e){if(e>4)return function(e){for(var t=Math.floor(Number.MAX_SAFE_INTEGER/256),i=0,a=0;a<e;a+=1){if(i>t)throw new Error("Value exceeds safe integer limit");i*=256;var o=n.getUint8(r+a);if(i>Number.MAX_SAFE_INTEGER-o)throw new Error("Value exceeds safe integer limit");i+=o}return r+=e,i}(e);for(var t=0,i=0;i<e;i+=1)t<<=8,t|=255&n.getUint8(r+i);return r+=e,t>>>0},moreData:function(){return r<n.byteLength}}}Pi.__dashjs_factory_name="EBMLParser";var Li=c.Z.getClassFactory(Pi);function xi(){var e,t,n,r,i,o,s,u,l,c,f=this.context;function d(e){var t=new p.Z;return t.setInfo(e),t}return e={setConfig:function(n){if(!(n.baseURLController&&n.dashMetrics&&n.mediaPlayerModel&&n.errHandler))throw new Error(a.Z.MISSING_CONFIG_ERROR);c=n.baseURLController,o=n.dashMetrics,s=n.mediaPlayerModel,r=n.errHandler,l=n.errors,t=n.debug.getLogger(e),i=n.requestModifier},initialize:function(){u=vt(f).create({errHandler:r,dashMetrics:o,mediaPlayerModel:s,requestModifier:i,errors:l})},loadInitialization:function(e,n){return new Promise((function(r){var i=null,a=e?c.resolve(e.path):null,o=e?e.range.split("-"):null,s={range:{start:o?parseFloat(o[0]):null,end:o?parseFloat(o[1]):null},request:i,url:a?a.url:void 0,init:!0,mediaType:n};t.info("Start loading initialization."),i=d(s),u.load({request:i,success:function(){r(e)},error:function(){r(e)}}),t.debug("Perform init load: "+s.url)}))},loadSegments:function(e,r,i){return new Promise((function(a){var o=null,s=e?c.resolve(e.path):null,g=s?s.url:void 0;o=d({bytesLoaded:0,bytesToLoad:8192,range:{start:0,end:8192},request:o,url:g,init:!1,mediaType:r}),t.debug("Parsing ebml header"),u.load({request:o,success:function(r){!function(e,r,i,a){if(e&&0!==e.byteLength){var o,s,l,c,g=Li(f).create({data:e}),h=i?i.split("-"):null,p=null,m={url:r,range:{start:h?parseFloat(h[0]):null,end:h?parseFloat(h[1]):null},request:p};for(t.debug("Parse EBML header: "+m.url),g.skipOverElement(n.EBML),g.consumeTag(n.Segment),l=g.getMatroskaCodedNum(),l+=g.getPos(),c=g.getPos();g.moreData()&&!g.consumeTagAndSize(n.Segment.Info,!0);)if(!(g.skipOverElement(n.Segment.SeekHead,!0)||g.skipOverElement(n.Segment.Tracks,!0)||g.skipOverElement(n.Segment.Cues,!0)||g.skipOverElement(n.Void,!0)))throw new Error("no valid top level element found");for(;void 0===o;){var y=g.getMatroskaCodedNum(!0),E=g.getMatroskaCodedNum();y===n.Segment.Info.Duration.tag?o=g[n.Segment.Info.Duration.parse](E):g.setPos(g.getPos()+E)}p=d(m),u.load({request:p,success:function(e){s=function(e,r,i,a){var o,s,u,l,c,d,g,h;for(u=[],c=0,d=(s=function(e){var t,r,i=[],a=Li(f).create({data:e});for(a.consumeTagAndSize(n.Segment.Cues);a.moreData()&&a.consumeTagAndSize(n.Segment.Cues.CuePoint,!0);){for((t={}).CueTime=a.parseTag(n.Segment.Cues.CuePoint.CueTime),t.CueTracks=[];a.moreData()&&a.consumeTag(n.Segment.Cues.CuePoint.CueTrackPositions,!0);){var o=a.getMatroskaCodedNum(),s=a.getPos();if((r={}).Track=a.parseTag(n.Segment.Cues.CuePoint.CueTrackPositions.CueTrack),0===r.Track)throw new Error("Cue track cannot be 0");r.ClusterPosition=a.parseTag(n.Segment.Cues.CuePoint.CueTrackPositions.CueClusterPosition),t.CueTracks.push(r),a.setPos(s+o)}if(0===t.CueTracks.length)throw new Error("Mandatory cuetrack not found");i.push(t)}if(0===i.length)throw new Error("mandatory cuepoint not found");return i}(e)).length;c<d;c+=1)l=new Di.Z,o=c<s.length-1?s[c+1].CueTime-s[c].CueTime:a-s[c].CueTime,l.duration=o,l.startTime=s[c].CueTime,l.timescale=1e3,g=s[c].CueTracks[0].ClusterPosition+r,h=c<s.length-1?s[c+1].CueTracks[0].ClusterPosition+r-1:i-1,l.mediaRange=g+"-"+h,u.push(l);return t.debug("Parsed cues: "+u.length+" cues."),u}(e,c,l,o),a(s)},error:function(){t.error("Download Error: Cues "+m.url),a(null)}}),t.debug("Perform cues load: "+m.url+" bytes="+m.range.start+"-"+m.range.end)}else a(null)}(r,g,i,(function(t){a({segments:t,representation:e,error:t?void 0:new S.Z(l.SEGMENT_BASE_LOADER_ERROR_CODE,l.SEGMENT_BASE_LOADER_ERROR_MESSAGE)})}))},error:function(){a({representation:e,error:new S.Z(l.SEGMENT_BASE_LOADER_ERROR_CODE,l.SEGMENT_BASE_LOADER_ERROR_MESSAGE)})}})}))},reset:function(){u&&(u.abort(),u=null)}},n={EBML:{tag:440786851,required:!0},Segment:{tag:408125543,required:!0,SeekHead:{tag:290298740,required:!0},Info:{tag:357149030,required:!0,TimecodeScale:{tag:2807729,required:!0,parse:"getMatroskaUint"},Duration:{tag:17545,required:!0,parse:"getMatroskaFloat"}},Tracks:{tag:374648427,required:!0},Cues:{tag:475249515,required:!0,CuePoint:{tag:187,required:!0,CueTime:{tag:179,required:!0,parse:"getMatroskaUint"},CueTrackPositions:{tag:183,required:!0,CueTrack:{tag:247,required:!0,parse:"getMatroskaUint"},CueClusterPosition:{tag:241,required:!0,parse:"getMatroskaUint"}}}}},Void:{tag:236,required:!0}},e}xi.__dashjs_factory_name="WebmSegmentBaseLoader";var Fi=c.Z.getSingletonFactory(xi);function ki(e){e=e||{};var t,n,r,i=this.context,a=e.eventBus,o=e.events,s=e.dashMetrics,u=e.mediaPlayerModel,l=e.errHandler,c=e.baseURLController,f=e.debug,d=e.boxParser,g=e.requestModifier,h=e.errors;function p(e){return"webm"===(e?e.split("/")[1]:"").toLowerCase()}return t={initialize:function(){n.initialize(),r.initialize()},getSegmentBaseInitSegment:function(e){return p(e.representation.mimeType)?r.loadInitialization(e.representation,e.mediaType):n.loadInitialization(e.representation,e.mediaType)},getSegmentList:function(e){return p(e.mimeType)?r.loadSegments(e.representation,e.mediaType,e.representation?e.representation.indexRange:null):n.loadSegments(e.representation,e.mediaType,e.representation?e.representation.indexRange:null)},reset:function(){n.reset(),r.reset()}},n=Mi(i).getInstance(),r=Fi(i).getInstance(),n.setConfig({baseURLController:c,dashMetrics:s,mediaPlayerModel:u,errHandler:l,eventBus:a,events:o,errors:h,debug:f,boxParser:d,requestModifier:g}),r.setConfig({baseURLController:c,dashMetrics:s,mediaPlayerModel:u,errHandler:l,eventBus:a,events:o,errors:h,debug:f,requestModifier:g}),t}ki.__dashjs_factory_name="SegmentBaseController";var Ui=c.Z.getSingletonFactory(ki),Zi=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.id=null,this.quality=null,this.fragmentDuration=null,this.mediaInfo=null,this.MSETimeOffset=null},Bi=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.id=null,this.index=null,this.type=null,this.streamInfo=null,this.representationCount=0,this.labels=null,this.lang=null,this.viewpoint=null,this.viewpointsWithSchemeIdUri=null,this.accessibility=null,this.accessibilitiesWithSchemeIdUri=null,this.audioChannelConfiguration=null,this.audioChannelConfigurationsWithSchemeIdUri=null,this.roles=null,this.rolesWithSchemeIdUri=null,this.codec=null,this.mimeType=null,this.contentProtection=null,this.isText=!1,this.KID=null,this.bitrateList=null,this.isFragmented=null,this.isEmbedded=null,this.selectionPriority=1,this.supplementalProperties={},this.supplementalPropertiesAsArray=[],this.segmentAlignment=!1,this.subSegmentAlignment=!1},Gi=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.id=null,this.index=null,this.start=NaN,this.duration=NaN,this.manifestInfo=null,this.isLast=!0},qi=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.dvrWindowSize=NaN,this.loadedTime=null,this.availableFrom=null,this.minBufferTime=NaN,this.duration=NaN,this.isDynamic=!1,this.maxFragmentDuration=null,this.serviceDescriptions=[],this.protocol=null};function Yi(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var ji=function(){function e(t){var n=this;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.valid="/"==t[0],this.path=t.split("/").filter((function(e){return 0!==e.length})).map((function(e){var t={name:e},r=e.indexOf("[");if(-1!=r){t.name=e.substring(0,r);var i=e.substring(r+1,e.length-1);n.valid=n.valid&&-1==i.indexOf("[");var a=i.indexOf("=");-1!=a?(t.attribute={name:i.substring(1,a),value:i.substring(a+1)},-1!=["\'",\'"\'].indexOf(t.attribute.value[0])&&(t.attribute.value=t.attribute.value.substring(1,t.attribute.value.length-1))):t.position=parseInt(i,10)-1}return t}))}var t,n;return t=e,(n=[{key:"isValid",value:function(){return this.valid}},{key:"findsElement",value:function(){return!this.findsAttribute()}},{key:"findsAttribute",value:function(){return this.path[this.path.length-1].name.startsWith("@")}},{key:"findsTextReplace",value:function(){return"text()"===this.path[this.path.length-1].name}},{key:"getMpdTarget",value:function(e,t){for(var n=null,r=e,i=1,a="MPD";i<this.path.length&&null!==r;){n=r;var o=this.path[i];if(a=o.name,i!==this.path.length-1||!a.startsWith("@")&&"text()"!==a){var s=n[a+"_asArray"]||[];0===s.length&&n[a]&&s.push(n[a]),o.position?r=s[o.position]||null:o.attribute?function(){var e=o.attribute;r=s.filter((function(t){return t[e.name]==e.value}))[0]||null}():r=s[0]||null}i++}return null===r?null:a.startsWith("@")?{name:a.substring(1),leaf:r,target:r}:"text()"===a?{name:"__text",leaf:r,target:r}:{name:a,leaf:r,target:t?n:r}}}])&&Yi(t.prototype,n),e}();function Hi(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var Vi=function(){function e(t,n,r){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.action=t,this.xpath=n,this.value=r,this.position=null}var t,n;return t=e,(n=[{key:"getMpdTarget",value:function(e){var t="remove"===this.action||"replace"===this.action||"before"===this.position||"after"===this.position;return this.xpath.getMpdTarget(e,t)}}])&&Hi(t.prototype,n),e}();function Ki(){var e,t,n=this.context;return e={getIsPatch:function(e){return e&&e.hasOwnProperty(o.Z.ORIGINAL_MPD_ID)||!1},getPublishTime:function(e){return e&&e.hasOwnProperty(o.Z.PUBLISH_TIME)?new Date(e[o.Z.PUBLISH_TIME]):null},getOriginalPublishTime:function(e){return e&&e.hasOwnProperty(o.Z.ORIGINAL_PUBLISH_TIME)?new Date(e[o.Z.ORIGINAL_PUBLISH_TIME]):null},getMpdId:function(e){return e&&e[o.Z.ORIGINAL_MPD_ID]||null},getPatchOperations:function(e){return e?(e.__children||[]).map((function(e){var n=Object.keys(e)[0];if("add"!==n&&"remove"!==n&&"replace"!==n)return t.warn("Ignoring node of invalid action: ".concat(n)),null;var r=e[n],i=r.sel;if("add"===n&&r.type){if(!r.type.startsWith("@"))return t.warn("Ignoring add action for prefixed namespace declaration: ".concat(r.type,"=").concat(r.__text)),null;i="".concat(i,"/").concat(r.type)}var a=new ji(i);if(!a.isValid())return t.warn("Ignoring action with invalid selector: ".concat(n," - ").concat(i)),null;var o=null;a.findsAttribute()||a.findsTextReplace()?o=r.__text||"":"remove"!==n&&(o=r.__children.reduce((function(e,t){var n=Object.keys(t)[0];return"#text"!==n&&(e[n]=e[n]||[],e[n].push(t[n])),e}),{}));var s=new Vi(n,a,o);return"add"===n&&(s.position=r.pos),s})).filter((function(e){return!!e})):[]}},t=(0,f.Z)(n).getInstance().getLogger(e),e}Ki.__dashjs_factory_name="PatchManifestModel";var zi=c.Z.getSingletonFactory(Ki);function Wi(){var e,t,n,r,i,a,s,u=this.context;function l(e,n,a){var s,u=t.getAdaptationsForType(r[0].mpd.manifest,e,n);if(!u||0===u.length)return null;if(u.length>1&&a){var l=d(a,n);if(i[a.id]&&i[a.id][n])for(var f=0,g=u.length;f<g;f++)if(c(i[a.id][n],l[f]))return u[f];for(var h=0,p=u.length;h<p;h++)if(s=u[h],t.getRolesForAdaptation(s).filter((function(e){return e.value===o.Z.MAIN}))[0])return u[h]}return u[0]}function c(e,t){if(!e||!t)return!1;var n=e.id===t.id,r=e.codec===t.codec,i=e.viewpoint===t.viewpoint,a=JSON.stringify(e.viewpointsWithSchemeIdUri)===JSON.stringify(t.viewpointsWithSchemeIdUri),o=e.lang===t.lang,s=e.roles.toString()===t.roles.toString(),u=JSON.stringify(e.rolesWithSchemeIdUri)===JSON.stringify(t.rolesWithSchemeIdUri),l=e.accessibility.toString()===t.accessibility.toString(),c=JSON.stringify(e.accessibilitiesWithSchemeIdUri)===JSON.stringify(t.accessibilitiesWithSchemeIdUri),f=e.audioChannelConfiguration.toString()===t.audioChannelConfiguration.toString(),d=JSON.stringify(e.audioChannelConfigurationsWithSchemeIdUri)===JSON.stringify(t.audioChannelConfigurationsWithSchemeIdUri);return n&&r&&i&&a&&o&&s&&u&&l&&c&&f&&d}function f(e,n,r,i,o,s){var u,l,c,f,d,g,h=[];if(!i||0===i.length)return[];var p=t.getAdaptationsForPeriod(n);for(f=0,g=i.length;f<g;f++)if(u=i[f],l=v(p[c=t.getIndexForAdaptation(u,e,r.index)]),s){var m=l.accessibility.length;for(d=0;d<m;d++)if(l){var y=l.accessibility[d];if(0===y.indexOf("cea-608:")){var E=y.substring(8).split(";");if("CC"===E[0].substring(0,2))for(d=0;d<E.length;d++)l||(l=v.call(this,p[c])),_(l,E[d].substring(0,3),E[d].substring(4)),h.push(l),l=null;else for(d=0;d<E.length;d++)l||(l=v.call(this,p[c])),_(l,"CC"+(d+1),E[d]),h.push(l),l=null}else 0===y.indexOf("cea-608")&&(_(l,a.CC1,"eng"),h.push(l),l=null)}}else o===a.IMAGE?(l.type=a.IMAGE,h.push(l),l=null):l&&h.push(l);return h}function d(e,n,i){var o=r,s=i,u=[];if(s)S(),o=g(s);else{if(!(r.length>0))return u;s=r[0].mpd.manifest}var l=E(e,o),c=t.getAdaptationsForType(s,e?e.index:null,n);return u=f(s,l,e,c,n),n===a.TEXT&&(c=t.getAdaptationsForType(s,e?e.index:null,a.VIDEO),u=u.concat(f(s,l,e,c,n,!0))),u}function g(e){var n=h(e);return t.getRegularPeriods(n)}function h(e){var n=m(e);return t.getMpd(n)}function p(){r=[],i={}}function m(e){return e||(r.length>0?r[0].mpd.manifest:null)}function y(e){try{var n=E(e.streamInfo,r),i=t.getAdaptationsForPeriod(n);return e&&e.streamInfo&&void 0!==e.streamInfo.id&&i?i[e.index]:null}catch(e){return null}}function E(e,t){for(var n=t.length,r=0;r<n;r++){var i=t[r];if(e&&e.id===i.id)return i}return null}function v(e){if(!e)return null;var n,r,i,a,o,u=new Bi,l=e.period.mpd.manifest.Period_asArray[e.period.index].AdaptationSet_asArray[e.index];if(u.id=e.id,u.index=e.index,u.type=e.type,u.streamInfo=T(e.period),u.representationCount=t.getRepresentationCount(l),u.labels=t.getLabelsForAdaptation(l),u.lang=t.getLanguageForAdaptation(l),u.segmentAlignment=t.getSegmentAlignment(l),u.subSegmentAlignment=t.getSubSegmentAlignment(l),n=t.getViewpointForAdaptation(l),u.viewpoint=n.length?n[0].value:void 0,u.viewpointsWithSchemeIdUri=n,o=t.getAccessibilityForAdaptation(l),u.accessibility=o.map((function(e){var t=e.value,n=t;return e.schemeIdUri&&e.schemeIdUri.search("cea-608")>=0&&void 0!==s&&(n=t?"cea-608:"+t:"cea-608",u.embeddedCaptions=!0),n})),u.accessibilitiesWithSchemeIdUri=o,r=t.getAudioChannelConfigurationForAdaptation(l),u.audioChannelConfiguration=r.map((function(e){return e.value})),u.audioChannelConfigurationsWithSchemeIdUri=r,0===u.audioChannelConfiguration.length&&Array.isArray(l.Representation_asArray)&&l.Representation_asArray.length>0&&(i=t.getAudioChannelConfigurationForRepresentation(l.Representation_asArray[0]),u.audioChannelConfiguration=i.map((function(e){return e.value})),u.audioChannelConfigurationsWithSchemeIdUri=i),a=t.getRolesForAdaptation(l),u.roles=a.map((function(e){return e.value})),u.rolesWithSchemeIdUri=a,u.codec=t.getCodec(l),u.mimeType=t.getMimeType(l),u.contentProtection=t.getContentProtectionData(l),u.bitrateList=t.getBitrateListForAdaptation(l),u.selectionPriority=t.getSelectionPriority(l),u.contentProtection){var c=u.contentProtection.map((function(e){return t.getKID(e)})).filter((function(e){return null!==e}));if(c.length){var f=c[0];u.contentProtection.forEach((function(e){e.keyId=f}))}}if(u.isText=t.getIsText(l),u.supplementalProperties=t.getSupplementalPropertiesForAdaptation(l),(!u.supplementalProperties||0===Object.keys(u.supplementalProperties).length)&&Array.isArray(l.Representation_asArray)&&l.Representation_asArray.length>0){var d=l.Representation_asArray.map((function(e){return t.getSupplementalPropertiesForRepresentation(e)}));d.every((function(e){return JSON.stringify(e)===JSON.stringify(d[0])}))&&(u.supplementalProperties=d[0])}if(u.supplementalPropertiesAsArray=t.getSupplementalPropertiesAsArrayForAdaptation(l),(!u.supplementalPropertiesAsArray||0===u.supplementalPropertiesAsArray.length)&&Array.isArray(l.Representation_asArray)&&l.Representation_asArray.length>0){var g=l.Representation_asArray.map((function(e){return t.getSupplementalPropertiesAsArrayForRepresentation(e)}));g.every((function(e){return JSON.stringify(e)===JSON.stringify(g[0])}))&&(u.supplementalPropertiesAsArray=g[0])}return u.isFragmented=t.getIsFragmented(l),u.isEmbedded=!1,u}function _(e,t,n){e.id=t,e.index=100+parseInt(t.substring(2,3)),e.type=a.TEXT,e.codec="cea-608-in-SEI",e.isEmbedded=!0,e.isFragmented=!1;var r=yn()(n);e.lang=r||n,e.roles=["caption"],e.rolesWithSchemeIdUri=[{schemeIdUri:"urn:mpeg:dash:role:2011",value:"caption"}]}function T(e){var n,r,i=new Gi;return i.id=e.id,i.index=e.index,i.start=e.start,i.duration=e.duration,i.manifestInfo=(n=e.mpd,(r=new qi).dvrWindowSize=n.timeShiftBufferDepth,r.loadedTime=n.manifest.loadedTime,r.availableFrom=n.availabilityStartTime,r.minBufferTime=n.manifest.minBufferTime,r.maxFragmentDuration=n.maxSegmentDuration,r.duration=t.getDuration(n.manifest),r.isDynamic=t.getIsDynamic(n.manifest),r.serviceDescriptions=t.getServiceDescriptions(n.manifest),r.protocol=n.manifest.protocol,r),i.isLast=1===e.mpd.manifest.Period_asArray.length||Math.abs(i.start+i.duration-i.manifestInfo.duration)<1,i}function S(){if(!a)throw new Error("setConfig function has to be called previously")}function b(e){return r.length>0?r[0].mpd.manifest.Period_asArray[e]:null}function A(e,t,n){var r,i,a,o,s;if(e)for(r=e.AdaptationSet_asArray,o=0;o<r.length;o+=1)for(a=r[o].Representation_asArray,s=0;s<a.length;s+=1)if(t===(i=a[s]).id)return n?s:i;return null}return e={getBandwidthForRepresentation:function(e,t){var n;return(n=A(b(t),e))?n.bandwidth:null},getIndexForRepresentation:function(e,t){return function(e,t){var n=A(e,t,!0);return null!==n?n:-1}(b(t),e)},getMaxIndexForBufferType:function(e,n){return function(e,n){var r,i,a,o;if(!e||!n)return-1;for(i=e.AdaptationSet_asArray,o=0;o<i.length;o+=1)if(a=(r=i[o]).Representation_asArray,t.getIsTypeOf(r,n))return a.length;return-1}(b(n),e)},convertRepresentationToRepresentationInfo:function(e){if(e){var n=new Zi,r=e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index],i=t.getRepresentationFor(e.index,r);return n.id=e.id,n.quality=e.index,n.bandwidth=t.getBandwidth(i),n.fragmentDuration=e.segmentDuration||(e.segments&&e.segments.length>0?e.segments[0].duration:NaN),n.MSETimeOffset=e.MSETimeOffset,n.mediaInfo=v(e.adaptation),n}return null},getStreamsInfo:function(e,t){var n=[],i=r;if(e&&(S(),i=g(e)),i.length>0){(!t||t>i.length)&&(t=i.length);for(var a=0;a<t;a++)n.push(T(i[a]))}return n},getMediaInfoForType:function(e,n){if(0===r.length||!e)return null;var i=E(e,r);if(!i)return null;var a=t.getAdaptationsForPeriod(i),o=l(e.index,n,e);return o?v(a[t.getIndexForAdaptation(o,r[0].mpd.manifest,e.index)]):null},getAllMediaInfoForType:d,getAdaptationForType:l,getRealAdaptation:function(e,n){var i,a,o=E(e,r);return i=n?n.id:null,r.length>0&&o&&(a=i?t.getAdaptationForId(i,r[0].mpd.manifest,o.index):t.getAdaptationForIndex(n?n.index:null,r[0].mpd.manifest,o.index)),a},getProducerReferenceTimes:function(e,n){var i,a,o=E(e,r);return i=n?n.id:null,r.length>0&&o&&(a=i?t.getAdaptationForId(i,r[0].mpd.manifest,o.index):t.getAdaptationForIndex(n?n.index:null,r[0].mpd.manifest,o.index)),a?t.getProducerReferenceTimesForAdaptation(a):[]},getRealPeriodByIndex:function(e){return t.getRealPeriodForIndex(e,r[0].mpd.manifest)},getEssentialPropertiesForRepresentation:function(e){try{return t.getEssentialPropertiesForRepresentation(e)}catch(e){return[]}},getVoRepresentations:function(e){var n=y(e);return t.getRepresentationsForAdaptation(n)},getEventsFor:function(e,n,i){var a=[];if(r.length>0){var o=r[0].mpd.manifest;if(e instanceof Gi){var s=E(e,r);a=t.getEventsForPeriod(s)}else if(e instanceof Bi){var u=E(i,r);a=t.getEventStreamForAdaptationSet(o,y(e),u)}else if(e instanceof Zi){var l=E(i,r);a=t.getEventStreamForRepresentation(o,n,l)}}return a},getEvent:function(e,t,n,r){try{if(!e||!t||isNaN(n)||!r)return null;var i=e.scheme_id_uri,a=e.value;if(!t[i+"/"+a])return null;var o,s=new _e,u=e.timescale||1,l=r.adaptation.period.start,c=t[i+"/"+a],f=isNaN(r.presentationTimeOffset)?isNaN(c.presentationTimeOffset)?0:c.presentationTimeOffset:r.presentationTimeOffset,d=e.presentation_time_delta/u;o=0===e.version?l+n-f+d:l-f+d;var g=e.event_duration/u,h=e.id,p=e.message_data;return s.eventStream=c,s.eventStream.value=a,s.eventStream.timescale=u,s.duration=g,s.id=h,s.calculatedPresentationTime=o,s.messageData=p,s.presentationTimeDelta=d,s}catch(e){return null}},getMpd:h,setConfig:function(e){e&&(e.constants&&(a=e.constants),e.cea608parser&&(s=e.cea608parser),e.errHandler&&t.setConfig({errHandler:e.errHandler}),e.BASE64&&t.setConfig({BASE64:e.BASE64}))},updatePeriods:function(e){if(!e)return null;S(),r=g(e)},getIsTextTrack:function(e){return t.getIsText(e)},getUTCTimingSources:function(){var e=m();return t.getUTCTimingSources(e)},getSuggestedPresentationDelay:function(){var e=r.length>0?r[0].mpd:null;return t.getSuggestedPresentationDelay(e)},getAvailabilityStartTime:function(e){var n=h(e);return t.getAvailabilityStartTime(n)},getIsTypeOf:function(e,n){return t.getIsTypeOf(e,n)},getIsDynamic:function(e){var n=m(e);return t.getIsDynamic(n)},getDuration:function(e){var n=m(e);return t.getDuration(n)},getRegularPeriods:g,getContentSteering:function(e){return t.getContentSteering(e)},getLocation:function(e){return t.getLocation(e)},getPatchLocation:function(e){var n=t.getPatchLocation(e),r=t.getPublishTime(e);return n&&0!==n.length&&r?n.filter((function(e){return isNaN(e.ttl)||r.getTime()+e.ttl>(new Date).getTime()})):[]},getManifestUpdatePeriod:function(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return t.getManifestUpdatePeriod(e,n)},getPublishTime:function(e){return t.getPublishTime(e)},getIsDVB:function(e){return t.hasProfile(e,"urn:dvb:dash:profile:dvb-dash:2014")},getIsPatch:function(e){return n.getIsPatch(e)},getBaseURLsFromElement:function(e){return t.getBaseURLsFromElement(e)},getRepresentationSortFunction:function(){return t.getRepresentationSortFunction()},getCodec:function(e,n,r){return t.getCodec(e,n,r)},getPeriodById:function(e){if(!e||0===r.length)return null;var t=r.filter((function(t){return t.id===e}));return t&&t.length>0?t[0]:null},setCurrentMediaInfo:function(e,t,n){i[e]=i[e]||{},i[e][t]=i[e][t]||{},i[e][t]=n},isPatchValid:function(e,r){var i=t.getId(e),a=n.getMpdId(r),o=t.getPublishTime(e),s=n.getPublishTime(r),u=n.getOriginalPublishTime(r);return!!(i&&a&&i==a&&o&&u&&o.getTime()==u.getTime()&&s&&o.getTime()<s.getTime())},applyPatchToManifest:function(e,t){n.getPatchOperations(t).forEach((function(t){var n=t.getMpdTarget(e);if(null!==n){var r=n.name,i=n.target,a=n.leaf;if(t.xpath.findsAttribute()||"__text"===r)switch(t.action){case"add":case"replace":i[r]=t.value;break;case"remove":delete i[r]}else{var o=(i[r+"_asArray"]||[]).indexOf(a),s="prepend"===t.position||"before"===t.position;if(("remove"===t.action||"replace"===t.action)&&(delete i[r],-1!=o)){var u=i[r+"_asArray"];u.splice(o,1),u.length>1?i[r]=u:1==u.length?i[r]=u[0]:delete i[r+"_asArray"]}"add"!==t.action&&"replace"!==t.action||Object.keys(t.value).forEach((function(e){var n=t.value[e],a=i[e+"_asArray"]||[];if(0===a.length&&i[e]&&a.push(i[e]),0===a.length)a=n;else{var u=a.length;u=e==r&&-1!=o?o+(s?0:1)+("replace"==t.action?-1:0):s?0:a.length,a.splice.apply(a,[u,0].concat(n))}i[e+"_asArray"]=a,i[e]=1==a.length?a[0]:a}))}}}))},areMediaInfosEqual:c,reset:p},t=Ze(u).getInstance(),n=zi(u).getInstance(),p(),e}Wi.__dashjs_factory_name="DashAdapter";var Xi=c.Z.getSingletonFactory(Wi);function Qi(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var Ji=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e)}var t,n;return t=e,n=[{key:"round10",value:function(e,t){return function(e,t,n){return void 0===n||0==+n?Math[e](t):(n=+n,null===(t=+t)||isNaN(t)||"number"!=typeof n||n%1!=0?NaN:(t=t.toString().split("e"),+((t=(t=Math[e](+(t[0]+"e"+(t[1]?+t[1]-n:-n)))).toString().split("e"))[0]+"e"+(t[1]?+t[1]+n:n))))}("round",e,t)}}],null&&0,n&&Qi(t,n),e}(),$i=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.TcpList=[],this.HttpList=[],this.RepSwitchList=[],this.BufferLevel=[],this.BufferState=[],this.PlayList=[],this.DroppedFrames=[],this.SchedulingInfo=[],this.DVRInfo=[],this.ManifestUpdate=[],this.RequestsQueue=null,this.DVBErrors=[]},ea=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.t=null,this.mt=null,this.to=null,this.lto=null},ta=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.t=null,this.level=null},na=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.target=null,this.state=s.Z.BUFFER_EMPTY},ra=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.time=null,this.range=null,this.manifestInfo=null},ia=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.time=null,this.droppedFrames=null};function aa(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var oa=function e(){aa(this,e),this.mediaType=null,this.type=null,this.requestTime=null,this.fetchTime=null,this.availabilityStartTime=null,this.presentationStartTime=0,this.clientTimeOffset=0,this.currentTime=null,this.buffered=null,this.latency=0,this.streamInfo=[],this.representationInfo=[]},sa=function e(){aa(this,e),this.id=null,this.index=null,this.start=null,this.duration=null},ua=function e(){aa(this,e),this.id=null,this.index=null,this.mediaType=null,this.streamIndex=null,this.presentationTimeOffset=null,this.startNumber=null,this.fragmentInfoType=null},la=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.mediaType=null,this.t=null,this.type=null,this.startTime=null,this.availabilityStartTime=null,this.duration=null,this.quality=null,this.range=null,this.state=null},ca=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.loadingRequests=[],this.executedRequests=[]};function fa(e){var t,n,r=(e=e||{}).settings,i=this.context,o=(0,u.Z)(i).getInstance();function c(){o.trigger(l.Z.METRICS_CHANGED)}function f(e){o.trigger(l.Z.METRIC_CHANGED,{mediaType:e}),c()}function d(e,t,n){o.trigger(l.Z.METRIC_UPDATED,{mediaType:e,metric:t,value:n}),f(e)}function g(e,t,n){o.trigger(l.Z.METRIC_ADDED,{mediaType:e,metric:t,value:n}),f(e)}function h(e,t){var r=null;return e?(n.hasOwnProperty(e)?r=n[e]:t||(r=new $i,n[e]=r),r):r}function p(e,t,n){var i=h(e);null!==i&&(i[t].push(n),i[t].length>r.get().streaming.metrics.maxListDepth&&i[t].shift())}function m(e,t,n){p(e,t,n),g(e,t,n)}return t={clearCurrentMetricsForType:function(e){delete n[e],f(e)},clearAllCurrentMetrics:function(){n={},c()},getMetricsFor:h,addHttpRequest:function e(t,n,r,i,a,o,u,l,c,f,d,g,h,p,y,E,v){var _=new C.w;o&&o!==i&&(e(t,null,r,i,a,null,null,l,c,null,null,null,h,null,null,E,v),_.actualurl=o),_.tcpid=n,_.type=r,_.url=i,_.range=l,_.trequest=c,_.tresponse=f,_.responsecode=g,_.cmsd=v,_._tfinish=d,_._stream=t,_._mediaduration=h,_._quality=a,_._responseHeaders=p,_._serviceLocation=u,_._fileLoaderType=E,y?y.forEach((function(e){!function(e,t,n,r){var i=new C.O;i.s=t,i.d=n,i.b=r,e.trace.push(i),e.interval||(e.interval=0),e.interval+=n}(_,e.s,e.d,e.b)})):(delete _.interval,delete _.trace),m(t,s.Z.HTTP_REQUEST,_)},addRepresentationSwitch:function(e,t,n,r,i){var a=new ea;a.t=t,a.mt=n,a.to=r,i?a.lto=i:delete a.lto,m(e,s.Z.TRACK_SWITCH,a)},addBufferLevel:function(e,t,n){var r=new ta;r.t=t,r.level=n,m(e,s.Z.BUFFER_LEVEL,r)},addBufferState:function(e,t,n){var r=new na;r.target=n,r.state=t,m(e,s.Z.BUFFER_STATE,r)},addDVRInfo:function(e,t,n,r){var i=new ra;i.time=t,i.range=r,i.manifestInfo=n,m(e,s.Z.DVR_INFO,i)},addDroppedFrames:function(e,t){var n=new ia,r=h(e).DroppedFrames;t&&(n.time=t.creationTime,n.droppedFrames=t.droppedVideoFrames,r.length>0&&r[r.length-1]==n||m(e,s.Z.DROPPED_FRAMES,n))},addSchedulingInfo:function(e,t,n,r,i,a,o,u,l){var c=new la;c.mediaType=e,c.t=t,c.type=n,c.startTime=r,c.availabilityStartTime=i,c.duration=a,c.quality=o,c.range=u,c.state=l,m(e,s.Z.SCHEDULING_INFO,c)},addRequestsQueue:function(e,t,n){var r=new ca;r.loadingRequests=t,r.executedRequests=n,h(e).RequestsQueue=r,g(e,s.Z.REQUESTS_QUEUE,r)},addManifestUpdate:function(e,t,n,r,i,o,u,l,c,f){var d=new oa;d.mediaType=e,d.type=t,d.requestTime=n,d.fetchTime=r,d.availabilityStartTime=i,d.presentationStartTime=o,d.clientTimeOffset=u,d.currentTime=l,d.buffered=c,d.latency=f,p(a.Z.STREAM,s.Z.MANIFEST_UPDATE,d),g(e,s.Z.MANIFEST_UPDATE,d)},updateManifestUpdateInfo:function(e,t){if(e){for(var n in t)e[n]=t[n];d(e.mediaType,s.Z.MANIFEST_UPDATE,e)}},addManifestUpdateStreamInfo:function(e,t,n,r,i){if(e){var a=new sa;a.id=t,a.index=n,a.start=r,a.duration=i,e.streamInfo.push(a),d(e.mediaType,s.Z.MANIFEST_UPDATE_STREAM_INFO,e)}},addManifestUpdateRepresentationInfo:function(e,t,n,r,i,a,o,u){if(e&&e.representationInfo){var l=new ua;l.id=t,l.index=n,l.streamIndex=r,l.mediaType=i,l.startNumber=o,l.fragmentInfoType=u,l.presentationTimeOffset=a,e.representationInfo.push(l),d(e.mediaType,s.Z.MANIFEST_UPDATE_TRACK_INFO,e)}},addPlayList:function(e){e.trace&&Array.isArray(e.trace)?e.trace.forEach((function(e){e.hasOwnProperty("subreplevel")&&!e.subreplevel&&delete e.subreplevel})):delete e.trace,m(a.Z.STREAM,s.Z.PLAY_LIST,e)},addDVBErrors:function(e){m(a.Z.STREAM,s.Z.DVB_ERRORS,e)}},n={},t}fa.__dashjs_factory_name="MetricsModel";var da=c.Z.getSingletonFactory(fa);function ga(e){e=e||{};var t,n,r,i,o=this.context,u=e.metricsModel;function l(e){var t=u.getMetricsFor(e,!0);if(!t)return null;var n,r=t.HttpList,i=null;if(!r||r.length<=0)return null;for(n=r.length-1;n>=0;){if(r[n].responsecode){i=r[n];break}n--}return i}function c(e){var t=u.getMetricsFor(e,!0);return t&&t.HttpList?t.HttpList:[]}function f(e,t){if(!e)return null;var n=e[t];return n&&0!==n.length?n[n.length-1]:null}return t={getCurrentRepresentationSwitch:function(e){return f(u.getMetricsFor(e,!0),s.Z.TRACK_SWITCH)},getCurrentBufferState:function(e){return f(u.getMetricsFor(e,!0),s.Z.BUFFER_STATE)},getCurrentBufferLevel:function(e){var t=f(u.getMetricsFor(e,!0),s.Z.BUFFER_LEVEL);return t?Ji.round10(t.level/1e3,-3):0},getCurrentHttpRequest:l,getHttpRequests:c,getCurrentDroppedFrames:function(){return f(u.getMetricsFor(a.Z.VIDEO,!0),s.Z.DROPPED_FRAMES)},getCurrentSchedulingInfo:function(e){return f(u.getMetricsFor(e,!0),s.Z.SCHEDULING_INFO)},getCurrentDVRInfo:function(e){return f(e?u.getMetricsFor(e,!0):u.getMetricsFor(a.Z.VIDEO,!0)||u.getMetricsFor(a.Z.AUDIO,!0),s.Z.DVR_INFO)},getCurrentManifestUpdate:function(){return f(u.getMetricsFor(a.Z.STREAM),s.Z.MANIFEST_UPDATE)},getLatestFragmentRequestHeaderValueByID:function(e,t){if(!t)return null;var n={},r=l(e);r&&(n=Be.Z.parseHttpHeaders(r._responseHeaders));var i=n[t.toLowerCase()];return void 0===i?null:i},getLatestMPDRequestHeaderValueByID:function(e){if(!e)return null;var t,n,r,i={};for(r=(t=c(a.Z.STREAM)).length-1;r>=0;r--)if((n=t[r]).type===C.w.MPD_TYPE){i=Be.Z.parseHttpHeaders(n._responseHeaders);break}var o=i[e.toLowerCase()];return void 0===o?null:o},addRepresentationSwitch:function(e,t,n,r,i){u.addRepresentationSwitch(e,t,n,r,i)},addDVRInfo:function(e,t,n,r){u.addDVRInfo(e,t,n,r)},updateManifestUpdateInfo:function(e){var t=this.getCurrentManifestUpdate();u.updateManifestUpdateInfo(t,e)},addManifestUpdateStreamInfo:function(e){if(e){var t=this.getCurrentManifestUpdate();u.addManifestUpdateStreamInfo(t,e.id,e.index,e.start,e.duration)}},addManifestUpdateRepresentationInfo:function(e,t){if(e){var n=this.getCurrentManifestUpdate();u.addManifestUpdateRepresentationInfo(n,e.id,e.index,e.streamIndex,t,e.presentationTimeOffset,e.startNumber,e.fragmentInfoType)}},addManifestUpdate:function(e){u.addManifestUpdate(a.Z.STREAM,e.type,e.requestStartDate,e.requestEndDate)},addHttpRequest:function(e,t,n,r,i,a){u.addHttpRequest(e.mediaType,null,e.type,e.url,e.quality,t,e.serviceLocation||null,e.range||null,e.requestStartDate,e.firstByteDate,e.requestEndDate,n,e.duration,r,i,e.fileLoaderType,a)},addSchedulingInfo:function(e,t){u.addSchedulingInfo(e.mediaType,new Date,e.type,e.startTime,e.availabilityStartTime,e.duration,e.quality,e.range,t)},addRequestsQueue:function(e,t,n){u.addRequestsQueue(e,t,n)},addBufferLevel:function(e,t,n){u.addBufferLevel(e,t,n)},addBufferState:function(e,t,n){u.addBufferState(e,t,n)},addDroppedFrames:function(e){u.addDroppedFrames(a.Z.VIDEO,e)},addPlayList:function(){i&&(u.addPlayList(i),i=null)},addDVBErrors:function(e){u.addDVBErrors(e)},createPlaylistMetrics:function(e,t){(i=new $).start=new Date,i.mstart=e,i.starttype=t},createPlaylistTraceMetrics:function(e,t,i){!0===n&&(n=!1,(r=new ee).representationid=e,r.start=new Date,r.mstart=t,r.playbackspeed=null!==i?i.toString():null)},updatePlayListTraceMetrics:function(e){if(r)for(var t in r)r[t]=e[t]},pushPlayListTraceMetrics:function(e,t){if(!1===n&&i&&r&&r.start){var a=r.start,o=e.getTime()-a.getTime();r.duration=o,r.stopreason=t,i.trace.push(r),n=!0}},clearAllCurrentMetrics:function(){u.clearAllCurrentMetrics()}},u=u||da(o).getInstance({settings:e.settings}),n=!0,r=null,i=null,t}ga.__dashjs_factory_name="DashMetrics";var ha=c.Z.getSingletonFactory(ga);function pa(){var e,t,n,r,i=this.context,s=(0,u.Z)(i).getInstance(),c=(0,N.Z)(i).getInstance();function f(e){r=e}function g(e,t,n,r){var i,a=t.adaptation.period.mpd,o=a.availabilityStartTime;if(r)i=n&&a.timeShiftBufferDepth!==Number.POSITIVE_INFINITY?new Date(o.getTime()+1e3*(e+a.timeShiftBufferDepth)):a.availabilityEndTime;else if(n){var s=t.availabilityTimeOffset;i=new Date(o.getTime()+1e3*(e-s))}else i=o;return i}function h(e,t){return(e.getTime()-t.mpd.availabilityStartTime.getTime()+1e3*r)/1e3}function p(e,t){return e+(t.adaptation.period.start-t.presentationTimeOffset)}function m(e){var n={start:NaN,end:NaN},r=e[0].getAdapter().getRegularPeriods()[0],i=h(new Date,r);if(!e||0===e.length)return{range:n,now:i};e.forEach((function(e){var r=e.getAdapter(),s=r.getMediaInfoForType(e.getStreamInfo(),a.Z.VIDEO)||r.getMediaInfoForType(e.getStreamInfo(),a.Z.AUDIO),u=r.getVoRepresentations(s)[0],l={start:NaN,end:NaN};if(u)if(u.segmentInfoType===o.Z.SEGMENT_TIMELINE)l=function(e){var n,r,i,a,o=e.adaptation.period.mpd.manifest.Period_asArray[e.adaptation.period.index].AdaptationSet_asArray[e.adaptation.index],s=t.getRepresentationFor(e.index,o),u=s.SegmentTemplate||s.SegmentList,l=u.SegmentTimeline,c=u.timescale,f=l.S_asArray,d={start:0,end:0},g=f[0].t,h=!isNaN(g),m=h?g:0,y=0;for(h&&(d.start=p(m/c,e)),i=0,a=f.length;i<a;i++)r=0,(n=f[i]).hasOwnProperty("r")&&(r=n.r),y+=n.d*(1+r);return d.end=p((m+y)/c,e),d}(u);else{var c=u.adaptation.period;l.start=c.start,l.end=Math.max(i,c.start+c.duration)}!isNaN(l.start)&&(isNaN(n.start)||n.start>l.start)&&(n.start=l.start),!isNaN(l.end)&&(isNaN(n.end)||n.end<l.end)&&(n.end=l.end)})),n.end=Math.min(i,n.end);var s=E(e,n.end,!0);return n.end=isNaN(s)?n.end:s,n.start=r&&r.mpd&&r.mpd.timeShiftBufferDepth&&!isNaN(r.mpd.timeShiftBufferDepth)&&!isNaN(n.end)?Math.max(n.end-r.mpd.timeShiftBufferDepth,n.start):n.start,n.start=E(e,n.start),{range:n,now:i}}function y(e,t){n=e-t.end}function E(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];try{for(var r=0,i=!1,a=NaN;!i&&r<e.length;){var o=e[r].getStreamInfo();o.start<=t&&(!isFinite(o.duration)||o.start+o.duration>=t)?(a=t,i=!0):!n&&o.start>t&&(isNaN(a)||o.start<a)?a=o.start:n&&o.start+o.duration<t&&(isNaN(a)||o.start+o.duration>a)&&(a=o.start+o.duration),r+=1}return a}catch(e){return t}}function v(e){void 0===e.offset||isNaN(e.offset)||f(e.offset/1e3)}function _(){r=0,n=0}function T(){s.off(l.Z.UPDATE_TIME_SYNC_OFFSET,v,this),_()}return e={initialize:function(){_(),s.on(l.Z.UPDATE_TIME_SYNC_OFFSET,v,this)},getClientTimeOffset:function(){return r},setClientTimeOffset:f,getClientReferenceTime:function(){return Date.now()-1e3*n+1e3*r},calcAvailabilityStartTimeFromPresentationTime:function(e,t,n){return g(e,t,n)},calcAvailabilityEndTimeFromPresentationTime:function(e,t,n){return g(e,t,n,!0)},calcPresentationTimeFromWallTime:h,calcPresentationTimeFromMediaTime:p,calcPeriodRelativeTimeFromMpdRelativeTime:function(e,t){return t-e.adaptation.period.start},calcMediaTimeFromPresentationTime:function(e,t){return e-t.adaptation.period.start+t.presentationTimeOffset},calcWallTimeForSegment:function(e,t){var n,r,i;return t&&(n=e.representation.adaptation.period.mpd.suggestedPresentationDelay,r=e.presentationStartTime+n,i=new Date(e.availabilityStartTime.getTime()+1e3*r)),i},calcTimeShiftBufferWindow:function(e,t){if(!t)return function(e){var t={start:NaN,end:NaN},n=0,r=NaN;return e.forEach((function(e){var t=e.getStreamInfo();n+=t.duration,(isNaN(r)||t.start<r)&&(r=t.start)})),t.start=r,t.end=r+n,t}(e);if(c.get().streaming.timeShiftBuffer.calcFromSegmentTimeline){var n=m(e);return y(n.now,n.range),n.range}return function(e){var t={start:NaN,end:NaN};if(!e||0===e.length)return t;var n=e[0].getAdapter().getRegularPeriods()[0],r=h(new Date,n),i=n.mpd.timeShiftBufferDepth,a=isNaN(i)?0:r-i;if(t.start=E(e,a),t.end=!isNaN(t.start)&&r<t.start?r:E(e,r,!0),!isNaN(i)&&t.end<r-i&&(t.end=NaN),c.get().streaming.timeShiftBuffer.fallbackToSegmentTimeline){var o=m(e);if(o.range.end<t.start)return s.trigger(d.Z.CONFORMANCE_VIOLATION,{level:nn.LEVELS.WARNING,event:nn.EVENTS.INVALID_DVR_WINDOW}),y(o.now,o.range),o.range}return t}(e)},reset:T},t=Ze(i).getInstance(),T(),e}pa.__dashjs_factory_name="TimelineConverter";var ma=c.Z.getSingletonFactory(pa),ya=n(4593),Ea=n(6934);function va(e){return va="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},va(e)}function _a(e,t){return _a=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},_a(e,t)}function Ta(e,t){return!t||"object"!==va(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function Sa(e){return Sa=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},Sa(e)}var ba=function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&_a(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=Sa(t);if(n){var i=Sa(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return Ta(this,e)});function i(){var e;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),(e=r.call(this)).captionData=null,e.label=null,e.defaultTrack=!1,e.kind=null,e.isFragmented=!1,e.isEmbedded=!1,e.isTTML=null,e}return i}(Bi),Aa=n(2295);function Ia(){var e=0;function t(e){for(var t="",n=0;n<e.length;++n)t+=e[n].uchar;return t.length-t.replace(/^\\s+/,"").length}function n(e){return"left: "+3.125*e.x+"%; top: "+6.66*e.y1+"%; width: "+(100-3.125*e.x)+"%; height: "+6.66*Math.max(e.y2-1-e.y1,1)+"%; align-items: flex-start; overflow: visible; -webkit-writing-mode: horizontal-tb;"}function r(e){return"red"===e?"rgb(255, 0, 0)":"green"===e?"rgb(0, 255, 0)":"blue"===e?"rgb(0, 0, 255)":"cyan"===e?"rgb(0, 255, 255)":"magenta"===e?"rgb(255, 0, 255)":"yellow"===e?"rgb(255, 255, 0)":"white"===e?"rgb(255, 255, 255)":"black"===e?"rgb(0, 0, 0)":e}function i(e,t){var n=e.videoHeight/15;return t?"font-size: "+n+"px; font-family: Menlo, Consolas, \'Cutive Mono\', monospace; color: "+(t.foreground?r(t.foreground):"rgb(255, 255, 255)")+"; font-style: "+(t.italics?"italic":"normal")+"; text-decoration: "+(t.underline?"underline":"none")+"; white-space: pre; background-color: "+(t.background?r(t.background):"transparent")+";":"font-size: "+n+"px; font-family: Menlo, Consolas, \'Cutive Mono\', monospace; justify-content: flex-start; text-align: left; color: rgb(255, 255, 255); font-style: normal; white-space: pre; line-height: normal; font-weight: normal; text-decoration: none; width: 100%; display: flex;"}function a(e){return e.replace(/^\\s+/g,"")}function o(e){return e.replace(/\\s+$/g,"")}return{createHTMLCaptionsFromScreen:function(r,s,u,l){var c,f,d=null,g=!1,h=-1,p={start:s,end:u,spans:[]},m="style_cea608_white_black",y={},E={},v=[];for(c=0;c<15;++c){var _=l.rows[c],T="",S=null;if(!1===_.isEmpty()){var b=t(_.chars);null===d&&(d={x:b,y1:c,y2:c+1,p:[]}),b!==h&&g&&(d.p.push(p),p={start:s,end:u,spans:[]},d.y2=c,d.name="region_"+d.x+"_"+d.y1+"_"+d.y2,!1===y.hasOwnProperty(d.name)?(v.push(d),y[d.name]=d):y[d.name].p.contat(d.p),d={x:b,y1:c,y2:c+1,p:[]});for(var A=0;A<_.chars.length;++A){var I=_.chars[A],R=I.penState;if(null===S||!R.equals(S)){T.trim().length>0&&(p.spans.push({name:m,line:T,row:c}),T="");var w="style_cea608_"+R.foreground+"_"+R.background;R.underline&&(w+="_underline"),R.italics&&(w+="_italics"),E.hasOwnProperty(w)||(E[w]=JSON.parse(JSON.stringify(R))),S=R,m=w}T+=I.uchar}T.trim().length>0&&p.spans.push({name:m,line:T,row:c}),g=!0,h=b}else g=!1,h=-1,d&&(d.p.push(p),p={start:s,end:u,spans:[]},d.y2=c,d.name="region_"+d.x+"_"+d.y1+"_"+d.y2,!1===y.hasOwnProperty(d.name)?(v.push(d),y[d.name]=d):y[d.name].p.contat(d.p),d=null)}d&&(d.p.push(p),d.y2=c+1,d.name="region_"+d.x+"_"+d.y1+"_"+d.y2,!1===y.hasOwnProperty(d.name)?(v.push(d),y[d.name]=d):y[d.name].p.contat(d.p),d=null);var N=[];for(c=0;c<v.length;++c){var C=v[c],D="sub_cea608_"+e++,O=document.createElement("div");O.id=D;var M=n(C);O.style.cssText="position: absolute; margin: 0; display: flex; box-sizing: border-box; pointer-events: none;"+M;var P=document.createElement("div");P.className="paragraph bodyStyle",P.style.cssText=i(r);var L=document.createElement("div");L.className="cueUniWrapper",L.style.cssText="unicode-bidi: normal; direction: ltr;";for(var x=0;x<C.p.length;++x){var F=C.p[x],k=0;for(f=0;f<F.spans.length;++f){var U=F.spans[f];if(U.line.length>0){if(0!==f&&k!=U.row){var Z=document.createElement("br");Z.className="lineBreak",L.appendChild(Z)}var B=!1;k===U.row&&(B=!0),k=U.row;var G=E[U.name],q=document.createElement("span");q.className="spanPadding "+U.name+" customSpanColor",q.style.cssText=i(r,G),0!==f&&B?f===F.spans.length-1?q.textContent=o(U.line):q.textContent=U.line:F.spans.length>1&&f<F.spans.length-1&&U.row===F.spans[f+1].row?q.textContent=a(U.line):q.textContent=U.line.trim(),L.appendChild(q)}}}P.appendChild(L),O.appendChild(P);var Y={bodyStyle:["%",90]};for(var j in E)E.hasOwnProperty(j)&&(Y[j]=["%",90]);N.push({type:"html",start:s,end:u,cueHTMLElement:O,cueID:D,cellResolution:[32,15],isFromCEA608:!0,fontSize:Y,lineHeight:{},linePadding:{}})}return N}}}Ia.__dashjs_factory_name="EmbeddedTextHtmlRender";var Ra=c.Z.getSingletonFactory(Ia);function wa(e){var t,n,r,o,s,c,d,g,h,p,m,y,E,v,_,T,b,A=e.errHandler,I=e.manifestModel,R=e.mediaController,N=e.videoModel,D=e.textTracks,O=e.vttParser,M=e.vttCustomRenderingParser,P=e.ttmlParser,L=e.streamInfo,x=e.settings,F=this.context,k=(0,u.Z)(F).getInstance(),U=!1;function Z(){c=null,g=NaN,h=[],p=null,d=!1,s=[],o=null}function B(e){var t=new ba;for(var n in e)t[n]=e[n];t.labels=e.labels,t.defaultTrack=function(e){var t=!1;return y.length>1&&e.isEmbedded?t=e.id&&e.id===a.Z.CC1:1===y.length?e.id&&"string"==typeof e.id&&"CC"===e.id.substring(0,2)&&(t=!0):0===y.length&&(t=e.index===s[0].index),t}(e),t.isFragmented=e.isFragmented,t.isEmbedded=!!e.isEmbedded,t.isTTML=function(e){return e.codec&&e.codec.search(a.Z.STPP)>=0||e.mimeType&&e.mimeType.search(a.Z.TTML)>=0}(e),t.kind=function(e,t){var n=e.roles&&e.roles.length>0?t[e.roles[0]]:t.caption;return n=n===t.caption||n===t.subtitle?n:t.caption}(e,{subtitle:"subtitles",caption:"captions"}),D.addTextTrack(t)}function G(e){var t=e.chunk;t.mediaInfo.embeddedCaptions&&Y(t.bytes,t)}function q(e){m=e}function Y(e,s){var u=s.mediaInfo,l=u.type,f=u.mimeType,h=u.codec||f;h?-1!==u.codec.indexOf("application/mp4")?function(e,i,s){var u;if("InitializationSegment"===i.segmentType)d=!0,g=r.getMediaTimescaleFromMoov(e);else{if(!d)return;(u=r.getSamplesInfo(e).sampleList).length>0&&(p=u[0].cts-i.start*g),s.search(a.Z.STPP)>=0?function(e,r,i){var s,u;for(o=null!==o?o:V(i),s=0;s<r.length;s++){var l=r[s],f=l.cts,d=H(),h=d+f/g,p=h+l.duration/g;t.buffered.add(h,p);var y=new DataView(e,l.offset,l.subSizes[0]),E=Ea.Utils.dataViewToString(y,a.Z.UTF8),v=[],_=l.offset+l.subSizes[0];for(u=1;u<l.subSizes.length;u++){var T=new Uint8Array(e,_,l.subSizes[u]),S=String.fromCharCode.apply(null,T);v.push(S),_+=l.subSizes[u]}try{var b=I.getValue().ttmlTimeIsRelative?f/g:0,A=o.parse(E,b,f/g,(f+l.duration)/g,v);D.addCaptions(m,d,A)}catch(e){c.removeExecutedRequestsBeforeTime(),this.remove(),n.error("TTML parser error: "+e.message)}}}(e,u,s):function(e,r){var i,a,o,s=[];for(i=0;i<r.length;i++){var u=r[i];u.cts-=p;var l=H()+u.cts/g,c=l+u.duration/g;t.buffered.add(l,c);var f=e.slice(u.offset,u.offset+u.size),d=Ea.parseBuffer(f);for(a=0;a<d.boxes.length;a++){var h=d.boxes[a];if(n.debug("VTT box1: "+h.type),"vtte"!==h.type&&"vttc"===h.type){n.debug("VTT vttc boxes.length = "+h.boxes.length);var y={styles:{}};for(o=0;o<h.boxes.length;o++){var E=h.boxes[o];if(n.debug("VTT box2: "+E.type),"payl"===E.type)y.start=u.cts/g,y.end=(u.cts+u.duration)/g,y.data=E.cue_text;else if("sttg"===E.type&&E.settings&&""!==E.settings)try{var v=E.settings.split(" ");y.styles=O.getCaptionStyles(v)}catch(e){}}y&&y.data&&(s.push(y),n.debug("VTT  ".concat(y.start," - ").concat(y.end," :  ").concat(y.data)))}}}s.length>0&&D.addCaptions(m,0,s)}(e,u)}}(e,s,h):l===a.Z.VIDEO?function(e,t){var a,o;if(t.segmentType===C.w.INIT_SEGMENT_TYPE)0===E&&(E=r.getMediaTimescaleFromMoov(e));else if(t.segmentType===C.w.MEDIA_SEGMENT_TYPE){if(0===E)return void n.warn("CEA-608: No timescale for embeddedTextTrack yet");var s=(o=r.getSamplesInfo(e)).lastSequenceNumber,u=Math.trunc(t.start),l=Math.trunc(t.end);if(T[0]||T[1]||function(){for(var e,t=0;t<y.length;t++){if(-1===(e=D.getTrackIdxForId(y[t].id)))return void n.warn("CEA-608: data before track is ready.");var r=j(e);T[t]=new(i().Cea608Parser)(t+1,{newCue:r},null)}}(),E){if(function(e,t,n,r,i){return null!==e&&null!==t&&null!==r&&null!==i&&(t===e?r!==i:t!==e+n)}(v,s,o.numSequences,_,u))for(a=0;a<T.length;a++)T[a]&&T[a].reset();for(var c=function(e,t){if(0===t.length)return null;for(var n={splits:[],fields:[[],[]]},r=new DataView(e),a=0;a<t.length;a++)for(var o=t[a],s=i().findCea608Nalus(r,o.offset,o.size),u=null,l=0,c=0;c<s.length;c++)for(var f=i().extractCea608DataFromRange(r,s[c]),d=0;d<2;d++)if(f[d].length>0){o.cts!==u?l=0:l+=1;var g=H();n.fields[d].push([o.cts+g*E,f[d],l]),u=o.cts}return n.fields.forEach((function(e){e.sort((function(e,t){return e[0]===t[0]?e[2]-t[2]:e[0]-t[0]}))})),n}(e,o.sampleList),f=0;f<T.length;f++){var d=c.fields[f],g=T[f];if(g)for(a=0;a<d.length;a++)g.addData(d[a][0]/E,d[a][1])}v=s,_=l}}}(e,s):function(e,n,r){var i,o,s=new DataView(e,0,e.byteLength);o=Ea.Utils.dataViewToString(s,a.Z.UTF8);try{i=V(r).parse(o,0),D.addCaptions(D.getCurrentTrackIdx(),0,i),t.buffered&&t.buffered.add(n.start,n.end)}catch(e){A.error(new S.Z(w.TIMED_TEXT_ERROR_ID_PARSE_CODE,w.TIMED_TEXT_ERROR_MESSAGE_PARSE+e.message,o))}}(e,s,h):n.error("No text type defined")}function j(e){return function(t,n,r){var i;(i=N.getTTMLRenderingDiv()?b.createHTMLCaptionsFromScreen(N.getElement(),t,n,r):[{start:t,end:n,data:r.getDisplayText(),styles:{}}])&&D.addCaptions(e,0,i)}}function H(){return isNaN(t.timestampOffset)?0:t.timestampOffset}function V(e){var t;return e.search(a.Z.VTT)>=0?t=x.get().streaming.text.webvtt.customRenderingEnabled&&M?M:O:(e.search(a.Z.TTML)>=0||e.search(a.Z.STPP)>=0)&&(t=P),t}function K(e){y.forEach((function(t){var n=D.getTrackIdxForId(t.id);n>=0&&D.deleteCuesFromTrackIdx(n,e.from,e.to)}))}return t={initialize:function(){U||(y=[],m=null,E=0,T=[],v=null,_=null,U=!0,b=Ra(F).getInstance(),k.on(l.Z.VIDEO_CHUNK_RECEIVED,G,t),k.on(l.Z.BUFFER_CLEARED,K,t))},addMediaInfos:function(e,n,r){if(s=s.concat(n),e===a.Z.TEXT&&n[0].isFragmented&&!n[0].isEmbedded){c=r,t.buffered=(0,Aa.Z)(F).create(),h=R.getTracksFor(a.Z.TEXT,L.id).filter((function(e){return e.isFragmented}));for(var i=R.getCurrentTrackFor(a.Z.TEXT,L.id),o=0;o<h.length;o++)if(h[o]===i){q(o);break}}for(var u=0;u<n.length;u++)B(n[u])},resetMediaInfos:function(){s=[]},getStreamId:function(){return L.id},append:Y,abort:function(){},addEmbeddedTrack:function(e){if(U&&e)if(e.id===a.Z.CC1||e.id===a.Z.CC3){for(var t=0;t<y.length;t++)if(y[t].id===e.id)return;y.push(e)}else n.warn("Embedded track "+e.id+" not supported!")},resetEmbedded:function(){k.off(l.Z.VIDEO_CHUNK_RECEIVED,G,t),k.off(l.Z.BUFFER_CLEARED,K,t),D&&D.deleteAllTextTracks(),U=!1,y=[],T=[null,null],v=null,_=null},getConfig:function(){return{fragmentModel:c,fragmentedTracks:h,videoModel:N}},setCurrentFragmentedTrackIdx:q,remove:function(e,n){void 0===e&&e===n&&(e=t.buffered.start(0),n=t.buffered.end(t.buffered.length-1)),t.buffered.remove(e,n),D.deleteCuesFromTrackIdx(m,e,n)},reset:function(){Z(),s=[],r=null}},n=(0,f.Z)(F).getInstance().getLogger(t),r=(0,xt.Z)(F).getInstance(),Z(),t}wa.__dashjs_factory_name="TextSourceBuffer";var Na=c.Z.getClassFactory(wa),Ca=n(4403);function Da(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=new Array(t);n<t;n++)r[n]=e[n];return r}var Oa=["text","align","fontSize","id","isd","line","lineAlign","lineHeight","linePadding","position","positionAlign","region","size","snapToLines","vertical"];function Ma(e){var t,n,r,i,o,s,c,g,h,p,m,y,E,v,_,T,S,b,A=this.context,I=(0,u.Z)(A).getInstance(),R=e.videoModel,w=e.streamInfo,N=e.settings;function C(e,t,n,r,i,a){var o=0,s=0;e/t>n/r?o=(s=t)/r*n:s=(o=e)/n*r;var u,l,c=0,f=0;return o/s>i?(f=s,c=s*i):(c=o,f=o/i),u=(e-c)/2,l=(t-f)/2,a?{x:u+.1*c,y:l+.1*f,w:.8*c,h:.8*f}:{x:u,y:l,w:c,h:f}}function D(e,t){var n=R.getClientWidth(),r=R.getClientHeight(),i=R.getVideoWidth(),a=R.getVideoHeight(),o=R.getVideoRelativeOffsetTop(),s=R.getVideoRelativeOffsetLeft();if(0!==i&&0!==a){var u=i/a,l=!1;e.isFromCEA608&&(u=3.5/3,l=!0);var f=C.call(this,n,r,i,a,u,l),y=f.w,E=f.h,T=f.x,b=f.y;if(y!=h||E!=p||T!=c||b!=g||t){if(c=T+s,g=b+o,h=y,p=E,m){var A=m.style;A&&(A.left=c+"px",A.top=g+"px",A.width=h+"px",A.height=p+"px",A.zIndex=v&&document[v]||_?S:null,I.trigger(d.Z.CAPTION_CONTAINER_RESIZE))}var w=e.activeCues;if(w)for(var N=w.length,D=0;D<N;++D){var O=w[D];O.scaleCue(O)}}}}function O(e){var t,n,r,i,a,o=h,s=p;if(e.cellResolution){var u=[o/e.cellResolution[0],s/e.cellResolution[1]];if(e.linePadding)for(t in e.linePadding)if(e.linePadding.hasOwnProperty(t)){n=(e.linePadding[t]*u[0]).toString();for(var l=document.getElementsByClassName("spanPadding"),c=0;c<l.length;c++)l[c].style.cssText=l[c].style.cssText.replace(/(padding-left\\s*:\\s*)[\\d.,]+(?=\\s*px)/gi,"$1"+n),l[c].style.cssText=l[c].style.cssText.replace(/(padding-right\\s*:\\s*)[\\d.,]+(?=\\s*px)/gi,"$1"+n)}if(e.fontSize){for(t in e.fontSize)if(e.fontSize.hasOwnProperty(t)){"%"===e.fontSize[t][0]?r=e.fontSize[t][1]/100:"c"===e.fontSize[t][0]&&(r=e.fontSize[t][1]),n=(r*u[1]).toString(),a="defaultFontSize"!==t?document.getElementsByClassName(t):document.getElementsByClassName("paragraph");for(var f=0;f<a.length;f++)a[f].style.cssText=a[f].style.cssText.replace(/(font-size\\s*:\\s*)[\\d.,]+(?=\\s*px)/gi,"$1"+n)}if(e.lineHeight)for(t in e.lineHeight)if(e.lineHeight.hasOwnProperty(t)){"%"===e.lineHeight[t][0]?i=e.lineHeight[t][1]/100:"c"===e.fontSize[t][0]&&(i=e.lineHeight[t][1]),n=(i*u[1]).toString(),a=document.getElementsByClassName(t);for(var d=0;d<a.length;d++)a[d].style.cssText=a[d].style.cssText.replace(/(line-height\\s*:\\s*)[\\d.,]+(?=\\s*px)/gi,"$1"+n)}}}if(e.isd){var g=document.getElementById(e.cueID);g&&m.removeChild(g),P(e)}}function M(e,t){var n=/^(urn:)(mpeg:[a-z0-9][a-z0-9-]{0,31}:)(subs:)([0-9]+)$/,r=/^#(.*)$/;if(n.test(t)){var i=n.exec(t),a=parseInt(i[4],10)-1;return"data:image/png;base64,"+btoa(e.images[a])}if(r.test(t)){var o=r.exec(t)[1];return"data:image/png;base64,"+e.embeddedImages[o]}return t}function P(e){if(m){var t=document.createElement("div");m.appendChild(t),T=(0,Ca.renderHTML)(e.isd,t,(function(t){return M(e,t)}),m.clientHeight,m.clientWidth,!1,(function(e){n.info("renderCaption :",e)}),T,!0),t.id=e.cueID,I.trigger(d.Z.CAPTION_RENDERED,{captionDiv:t,currentTrackIdx:s})}}function L(e,t){if(!N.get().streaming.text.extendSegmentedCues)return!1;if(!t.cues||0===t.cues.length)return!1;var n=t.cues[t.cues.length-1];return!(n.endTime<e.startTime||!function(e,t,n){for(var r=0;r<n.length;r++){var i=n[r];if(JSON.stringify(e[i])!==JSON.stringify(t[i]))return!1}return!0}(n,e,Oa)||(n.endTime=Math.max(n.endTime,e.endTime),0))}function x(e,t){t&&t.forEach((function(t){t.kind&&"image"===t.kind&&(t.src=M(e,t.src)),x(e,t.contents)}))}function F(e,t,r){var i=G(e);if(i&&Array.isArray(r)&&0!==r.length)for(var a=0;a<r.length;a++){var o=void 0,s=r[a];i.cellResolution=s.cellResolution,i.isFromCEA608=s.isFromCEA608,isNaN(s.start)||isNaN(s.end)||(o="html"===s.type&&m?k(s,t,i):s.data?U(s,t,i):null);try{if(o){j(i,o)||(N.get().streaming.text.webvtt.customRenderingEnabled?(i.manualCueList||(i.manualCueList=[]),i.manualCueList.push(o)):L(o,i)||i.addCue(o));var u=N.get().streaming.buffer.bufferToKeep;V(i,0,R.getTime()-u)}else n.error("Impossible to display subtitles. You might have missed setting a TTML rendering div via player.attachTTMLRenderingDiv(TTMLRenderingDiv)")}catch(e){throw K(i),i.addCue(o),e}}}function k(e,t,i){var o=this,u=new r(e.start+t,e.end+t,"");return u.cueHTMLElement=e.cueHTMLElement,u.isd=e.isd,u.images=e.images,u.embeddedImages=e.embeddedImages,u.cueID=e.cueID,u.scaleCue=O.bind(o),u.cellResolution=e.cellResolution,u.lineHeight=e.lineHeight,u.linePadding=e.linePadding,u.fontSize=e.fontSize,m.style.left=c+"px",m.style.top=g+"px",m.style.width=h+"px",m.style.height=p+"px",u.isd&&x(u,u.isd.contents),u.onenter=function(){i.mode===a.Z.TEXT_SHOWING&&(this.isd?(P(this),n.debug("Cue enter id:"+this.cueID)):(m.appendChild(this.cueHTMLElement),O.call(o,this),I.trigger(d.Z.CAPTION_RENDERED,{captionDiv:this.cueHTMLElement,currentTrackIdx:s})))},u.onexit=function(){if(m)for(var e=m.childNodes,t=0;t<e.length;++t)e[t].id===this.cueID&&(n.debug("Cue exit id:"+e[t].id),m.removeChild(e[t]),--t)},u}function U(e,t,i){var o=new r(e.start-t,e.end-t,e.data);if(o.cueID="".concat(o.startTime,"_").concat(o.endTime),o.isActive=!1,e.styles)try{void 0!==e.styles.align&&"align"in o&&(o.align=e.styles.align),void 0!==e.styles.line&&"line"in o&&(o.line=e.styles.line),void 0!==e.styles.snapToLines&&"snapToLines"in o&&(o.snapToLines=e.styles.snapToLines),void 0!==e.styles.position&&"position"in o&&(o.position=e.styles.position),void 0!==e.styles.size&&"size"in o&&(o.size=e.styles.size)}catch(e){n.error(e)}return o.onenter=function(){i.mode===a.Z.TEXT_SHOWING&&I.trigger(d.Z.CAPTION_RENDERED,{currentTrackIdx:s})},o}function Z(e){if(y)for(var t=y.childNodes,n=0;n<t.length;++n)t[n].id===e.cueID&&(y.removeChild(t[n]),--n)}function B(){var e,t=[],n=function(e,t){var n;if("undefined"==typeof Symbol||null==e[Symbol.iterator]){if(Array.isArray(e)||(n=function(e,t){if(e){if("string"==typeof e)return Da(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?Da(e,t):void 0}}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var r=0,i=function(){};return{s:i,n:function(){return r>=e.length?{done:!0}:{done:!1,value:e[r++]}},e:function(e){throw e},f:i}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var a,o=!0,s=!1;return{s:function(){n=e[Symbol.iterator]()},n:function(){var e=n.next();return o=e.done,e},e:function(e){s=!0,a=e},f:function(){try{o||null==n.return||n.return()}finally{if(s)throw a}}}}(R.getTextTracks());try{for(n.s();!(e=n.n()).done;){var r=e.value;r.manualMode===a.Z.TEXT_SHOWING&&t.push(r)}}catch(e){n.e(e)}finally{n.f()}return t}function G(e){return e>=0&&i[e]?R.getTextTrack(i[e].kind,i[e].id,i[e].lang,i[e].isTTML,i[e].isEmbedded):null}function q(e){var t=this;if(e!==s){var n=G(s=e);Y.call(this,n),E&&(clearInterval(E),E=null),n&&"html"===n.renderingType&&(D.call(this,n,!0),window.ResizeObserver?(b=new window.ResizeObserver((function(){D.call(t,n,!0)}))).observe(R.getElement()):E=setInterval(D.bind(this,n),500))}}function Y(e){X.call(this),e&&"html"===e.renderingType?z.call(this):W.call(this)}function j(e,t){if(!e.cues)return!1;for(var n=0;n<e.cues.length;n++)if(e.cues[n].startTime===t.startTime&&e.cues[n].endTime===t.endTime)return!0;return!1}function H(e,t,n){var r=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];return!!e&&(isNaN(t)||(r?e.startTime:e.endTime)>=t)&&(isNaN(n)||(r?e.endTime:e.startTime)<=n)}function V(e,t,n){var r,i;if(!(n<t)&&e&&(e.cues||e.manualCueList)){var a=e.cues&&e.cues.length>0?"native":"custom",o="native"===a?e.cues:e.manualCueList;if(!o||0===o.length)return;for(var s=o.length-1;s>=0;s--)!H(o[s],t,n,!0)||(r=o[s],void 0,i=R.getTime(),r.startTime>=i&&r.endTime<=i)||("native"===a?e.removeCue(o[s]):(Z(o[s]),delete e.manualCueList[s]))}}function K(e,t,n){var r=!(arguments.length>3&&void 0!==arguments[3])||arguments[3];if(e&&(e.cues||e.manualCueList)){var i=e.cues&&e.cues.length>0?"native":"custom",a="native"===i?e.cues:e.manualCueList;if(!a||0===a.length)return;for(var o=a.length-1,s=o;s>=0;s--)H(a[s],t,n,r)&&("native"===i?(a[s].onexit&&a[s].onexit(),e.removeCue(a[s])):(Z(a[s]),delete e.manualCueList[s]))}}function z(){var e=document.getElementById("native-cue-style");if(!e){(e=document.createElement("style")).id="native-cue-style",document.head.appendChild(e);var t=e.sheet,r=R.getElement();try{r&&(r.id?t.insertRule("#"+r.id+"::cue {background: transparent}",0):0!==r.classList.length?t.insertRule("."+r.className+"::cue {background: transparent}",0):t.insertRule("video::cue {background: transparent}",0))}catch(e){n.info(""+e.message)}}}function W(){var e=document.getElementById("native-cue-style");e&&document.head.removeChild(e)}function X(){if(m)for(;m.firstChild;)m.removeChild(m.firstChild)}return t={initialize:function(){"undefined"!=typeof window&&"undefined"!=typeof navigator&&(r=window.VTTCue||window.TextTrackCue,i=[],o=[],s=-1,c=0,g=0,h=0,p=0,m=null,y=null,E=null,_=!1,S=2147483647,T=null,void 0!==document.fullscreenElement?v="fullscreenElement":void 0!==document.webkitIsFullScreen?v="webkitIsFullScreen":document.msFullscreenElement?v="msFullscreenElement":document.mozFullScreen&&(v="mozFullScreen"))},getStreamId:function(){return w.id},addTextTrack:function(e){i.push(e)},addCaptions:F,createTracks:function(){i.sort((function(e,t){return e.index-t.index})),m=R.getTTMLRenderingDiv(),y=R.getVttRenderingDiv();for(var e,t,n,r,u,c,f=-1,g=0;g<i.length;g++){var h=(void 0,void 0,void 0,void 0,void 0,t=(e=i[g]).kind,n=void 0!==e.id?e.id:e.lang,r=e.lang,u=e.isTTML,c=e.isEmbedded,R.addTextTrack(t,n,r,u,c));o.push(h),i[g].defaultTrack&&(h.default=!0,f=g);var p=G(g);p&&(p.mode=a.Z.TEXT_SHOWING,m&&(i[g].isTTML||i[g].isEmbedded)?p.renderingType="html":p.renderingType="default"),F(g,0,i[g].captionData),I.trigger(d.Z.TEXT_TRACK_ADDED)}if(q.call(this,f),f>=0){I.on(d.Z.PLAYBACK_METADATA_LOADED,(function e(){var t=G(f);t&&"html"===t.renderingType&&D.call(this,t,!0),I.off(d.Z.PLAYBACK_METADATA_LOADED,e,this)}),this);for(var E=0;E<i.length;E++){var v=G(E);v&&(v.mode=E===f?a.Z.TEXT_SHOWING:a.Z.TEXT_HIDDEN,v.manualMode=E===f?a.Z.TEXT_SHOWING:a.Z.TEXT_HIDDEN)}}I.trigger(l.Z.TEXT_TRACKS_QUEUE_INITIALIZED,{index:s,tracks:i,streamId:w.id})},getCurrentTrackIdx:function(){return s},setCurrentTrackIdx:q,getTrackIdxForId:function(e){for(var t=-1,n=0;n<i.length;n++)if(i[n].id===e){t=n;break}return t},getCurrentTrackInfo:function(){return i[s]},setModeForTrackIdx:function(e,t){var n=G(e);n&&n.mode!==t&&(n.mode=t),n&&n.manualMode!==t&&(n.manualMode=t)},deleteCuesFromTrackIdx:function(e,t,n){var r=G(e);r&&K(r,t,n)},deleteAllTextTracks:function(){for(var e=o?o.length:0,t=0;t<e;t++){var n=G(t);n&&K.call(this,n,w.start,w.start+w.duration,!1)}o=[],i=[],E&&(clearInterval(E),E=null),b&&R&&(b.unobserve(R.getElement()),b=null),s=-1,X.call(this)},deleteTextTrack:function(e){R.removeChild(o[e]),o.splice(e,1)},manualCueProcessing:function(e){var t=B();if(t&&t.length>0){var n=t[0].manualCueList;n&&n.length>0&&n.forEach((function(t){t.startTime<=e&&t.endTime>=e&&!t.isActive?(t.isActive=!0,WebVTT.processCues(window,[t],y,t.cueID)):t.isActive&&(t.startTime>e||t.endTime<e)&&(t.isActive=!1,Z(t))}))}},disableManualTracks:function(){var e=B();if(e&&e.length>0){var t=e[0].manualCueList;t&&t.length>0&&t.forEach((function(e){if(e.isActive&&(e.isActive=!1,y))for(var t=y.childNodes,n=0;n<t.length;++n)t[n].id===e.cueID&&(y.removeChild(t[n]),--n)}))}}},n=(0,f.Z)(A).getInstance().getLogger(t),t}Ma.__dashjs_factory_name="TextTracks";var Pa=c.Z.getClassFactory(Ma);function La(){var e,t,n,r,i,a,o=this.context;function s(e){var t=e.split(":"),n=t.length-1;return e=60*parseInt(t[n-1],10)+parseFloat(t[n]),2===n&&(e+=3600*parseInt(t[0],10)),e}function u(e){var t=e.split(r),n=t[1].split(a);return n.shift(),t[1]=n[0],n.shift(),{cuePoints:t,styles:l(n)}}function l(e){var t={};return e.forEach((function(e){if(e.split(/:/).length>1){var n=e.split(/:/)[1],r=!1;n&&-1!=n.search(/%/)&&(r=!0,n=parseInt(n.replace(/%/,""),10)),(e.match(/align/)||e.match(/A/))&&(t.align=n),(e.match(/line/)||e.match(/L/))&&(t.line="auto"===n?n:parseInt(n,10),r&&(t.snapToLines=!1)),(e.match(/position/)||e.match(/P/))&&(t.position=n),(e.match(/size/)||e.match(/S/))&&(t.size=n)}})),t}function c(e,t){for(var n,i=t,a="",o="";""!==e[i]&&i<e.length;)i++;if((n=i-t)>1)for(var s=0;s<n;s++){if((o=e[t+s]).match(r)){a="";break}a+=o,s!==n-1&&(a+="\\n")}else(o=e[t]).match(r)||(a=o);return a}return e={parse:function(e){var a,o,l=[];if(!e)return l;a=(e=e.split(n)).length,o=-1;for(var f=0;f<a;f++){var d=e[f];if(d.length>0&&"WEBVTT"!==d&&d.match(r)){var g=u(d),h=g.cuePoints,p=g.styles,m=c(e,f+1),y=s(h[0].replace(i,"")),E=s(h[1].replace(i,""));!isNaN(y)&&!isNaN(E)&&y>=o&&E>y?""!==m?(o=y,l.push({start:y,end:E,data:m,styles:p})):t.error("Skipping cue due to empty/malformed cue text"):t.error("Skipping cue due to incorrect cue timing")}}return l},getCaptionStyles:l},t=(0,f.Z)(o).getInstance().getLogger(e),n=/(?:\\r\\n|\\r|\\n)/gm,r=/--\x3e/,i=/(^[\\s]+|[\\s]+$)/g,a=/\\s\\b/g,e}La.__dashjs_factory_name="VTTParser";var xa=c.Z.getSingletonFactory(La);function Fa(){var e,t;return e={parse:function(e){var n=[];return t.oncue=function(e){e.start=e.startTime,e.end=e.endTime,e.data=e.text,e.styles={align:e.align,line:e.line,position:e.position,size:e.size},n.push(e)},t.parse(e),n}},function(){try{window&&window.WebVTT&&window.WebVTT.Parser&&(t=new window.WebVTT.Parser(window,window.vttjs,window.WebVTT.StringDecoder()))}catch(e){}}(),e}Fa.__dashjs_factory_name="VttCustomRenderingParser";var ka=c.Z.getSingletonFactory(Fa);function Ua(){var e,t,n=this.context,r=(0,u.Z)(n).getInstance(),i=0;return e={parse:function(e,n,a,o,s){var u,c,f,g="",h=[],p={},m={},y="",E="",v={onOpenTag:function(e,n,i){if(i[" imagetype"]&&!i[" imageType"]&&(r.trigger(d.Z.CONFORMANCE_VIOLATION,{level:nn.LEVELS.ERROR,event:nn.EVENTS.NON_COMPLIANT_SMPTE_IMAGE_ATTRIBUTE}),i[" imageType"]=i[" imagetype"]),"image"===n&&("http://www.smpte-ra.org/schemas/2052-1/2010/smpte-tt"===e||"http://www.smpte-ra.org/schemas/2052-1/2013/smpte-tt"===e)){if(!i[" imageType"]||"PNG"!==i[" imageType"].value)return void t.warn("smpte-tt imageType != PNG. Discarded");y=i["http://www.w3.org/XML/1998/namespace id"].value}},onCloseTag:function(){y&&(m[y]=E.trim()),E="",y=""},onText:function(e){y&&(E+=e)}};if(!e)throw g="no ttml data to parse",new Error(g);p.data=e,r.trigger(l.Z.TTML_TO_PARSE,p);var _=(0,Ca.fromXML)(p.data,(function(e){g=e}),v);r.trigger(l.Z.TTML_PARSED,{ttmlString:p.data,ttmlDoc:_});var T,S=_.getMediaTimeEvents();for(f=0;f<S.length;f++){var b=(0,Ca.generateISD)(_,S[f],(function(e){g=e}));b.contents.some((function(e){return e.contents.length}))&&(u=S[f]+n)<(c=S[f+1]+n)&&h.push({start:u,end:c,type:"html",cueID:(void 0,T="cue_TTML_"+i,i++,T),isd:b,images:s,embeddedImages:m})}if(""!==g)throw t.error(g),new Error(g);return h}},t=(0,f.Z)(n).getInstance().getLogger(e),e}Ua.__dashjs_factory_name="TTMLParser";var Za=c.Z.getSingletonFactory(Ua);function Ba(e){var t,n,r,i,o,s,c,f,g,h,p,m,y=this.context,E=e.adapter,v=e.errHandler,_=e.manifestModel,T=e.mediaController,S=e.videoModel,b=e.settings;function A(e){var t=e.tracks,r=e.index,i=e.streamId;if(!1===b.get().streaming.text.defaultEnabled&&!w()||m)N(i,-1);else{var o=T.getCurrentTrackFor(a.Z.TEXT,i);if(o){var s={lang:o.lang,role:o.roles[0],index:o.index,codec:o.codec,accessibility:o.accessibility[0]};t.some((function(e,t){if(T.matchSettings(s,e))return N(i,t),r=t,!0}))}g=!1}n[i].lastEnabledIndex=r,f.trigger(d.Z.TEXT_TRACKS_ADDED,{enabled:w(),index:r,tracks:t,streamId:i}),p=!0}function I(e){try{var t=e.streamId;if(!i[t]||isNaN(e.time))return;i[t].manualCueProcessing(e.time)}catch(e){}}function R(e){try{var t=e.streamId;if(!i[t])return;i[t].disableManualTracks()}catch(e){}}function w(){var e=!0;return g&&!h&&(e=!1),e}function N(e,t){(g=-1===t)&&T&&T.saveTextSettingsDisabled();var n=C(e);if(n!==t&&i[e]){i[e].disableManualTracks(),i[e].setModeForTrackIdx(n,a.Z.TEXT_HIDDEN),i[e].setCurrentTrackIdx(t),i[e].setModeForTrackIdx(t,a.Z.TEXT_SHOWING);var o=i[e].getCurrentTrackInfo();o&&o.isFragmented&&!o.isEmbedded?function(e,t,n){if(r[e])for(var o=r[e].getConfig().fragmentedTracks,s=0;s<o.length;s++){var u=o[s];if(t.lang===u.lang&&(u.id?t.id===u.id:t.index===u.index)){var c=T.getCurrentTrackFor(a.Z.TEXT,e);(u.id?c.id!==u.id:c.index!==u.index)?(i[e].deleteCuesFromTrackIdx(n),r[e].setCurrentFragmentedTrackIdx(s)):-1===n&&f.trigger(l.Z.SET_FRAGMENTED_TEXT_AFTER_DISABLED,{},{streamId:e,mediaType:a.Z.TEXT})}}}(e,o,n):o&&!o.isFragmented&&function(e,t){f.trigger(l.Z.SET_NON_FRAGMENTED_TEXT,{currentTrackInfo:t},{streamId:e,mediaType:a.Z.TEXT})}(e,o),T.setTrack(o)}}function C(e){return i[e].getCurrentTrackIdx()}function D(){r={},i={},n={},g=!0,p=!1,m=!1}return t={deactivateStream:function(e){if(e){var t=e.id;r[t]&&r[t].resetMediaInfos(),i[t]&&i[t].deleteAllTextTracks()}},initialize:function(){f.on(l.Z.TEXT_TRACKS_QUEUE_INITIALIZED,A,t),b.get().streaming.text.webvtt.customRenderingEnabled&&(f.on(l.Z.PLAYBACK_TIME_UPDATED,I,t),f.on(l.Z.PLAYBACK_SEEKING,R,t))},initializeForStream:function(e){var t=e.id,a=Pa(y).create({videoModel:S,settings:b,streamInfo:e});a.initialize(),i[t]=a;var u=Na(y).create({errHandler:v,adapter:E,manifestModel:_,mediaController:T,videoModel:S,textTracks:a,vttParser:o,vttCustomRenderingParser:s,ttmlParser:c,streamInfo:e,settings:b});u.initialize(),r[t]=u,n[t]={},n[t].lastEnabledIndex=-1},createTracks:function(e){var t=e.id;i[t]&&i[t].createTracks()},getTextSourceBuffer:function(e){var t=e.id;if(r&&r[t])return r[t]},getAllTracksAreDisabled:function(){return g},addEmbeddedTrack:function(e,t){var n=e.id;r[n]&&r[n].addEmbeddedTrack(t)},enableText:function(e,t){return(0,z.PS)(t,"boolean"),w()!==t&&(t&&N(e,n[e].lastEnabledIndex),t||(n[e].lastEnabledIndex=C(e),p?N(e,-1):m=!0)),!0},isTextEnabled:w,setTextTrack:N,getCurrentTrackIdx:C,enableForcedTextStreaming:function(e){return(0,z.PS)(e,"boolean"),h=e,!0},addMediaInfosToBuffer:function(e,t,n){var i=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null,a=e.id;r[a]&&r[a].addMediaInfos(t,n,i)},reset:function(){D(),f.off(l.Z.TEXT_TRACKS_QUEUE_INITIALIZED,A,t),b.get().streaming.text.webvtt.customRenderingEnabled&&(f.off(l.Z.PLAYBACK_TIME_UPDATED,I,t),f.off(l.Z.PLAYBACK_SEEKING,R,t)),Object.keys(r).forEach((function(e){r[e].resetEmbedded(),r[e].reset()}))}},h=!1,p=!1,m=!1,o=xa(y).getInstance(),s=ka(y).getInstance(),c=Za(y).getInstance(),f=(0,u.Z)(y).getInstance(),D(),t}Ba.__dashjs_factory_name="TextController";var Ga=c.Z.getClassFactory(Ba);function qa(){var e,t,n,r,g,p,m,y,E,v,_,T,b,A,I,R,D,O,M,P,L,x,F,k,U,Z,B,G,q,Y,j,H,V,K,W,J,$,ee,te,ne="You must first call initialize() and set a source before calling this method",re="You must first call initialize() and set a valid source and view before calling this method",ie="You must first call attachView() to set the video element before calling this method",ae="You must first call attachSource() with a valid source before calling this method",oe="MediaPlayer not initialized!",se=this.context,ue=(0,u.Z)(se).getInstance(),le=(0,N.Z)(se).getInstance(),ce=(0,f.Z)(se).getInstance({settings:le});function fe(){Ie(null),be(null),r=null,A&&(A.reset(),A=null),I&&(I.reset(),I=null),P&&P.reset(),le.reset(),D&&(D.reset(),D=null)}function de(){return!!n&&!!J.getElement()}function ge(){return(0,Ci.e)()}function he(){if(!m)throw re;return G.isPaused()}function pe(){if(!m)throw re;return G.getIsDynamic()}function me(e){var t=U&&U.hasVideoTrack()?a.Z.VIDEO:a.Z.AUDIO,n=H.getCurrentDVRInfo(t);if(!n)return 0;var r=G.getOriginalLiveDelay(),i=n.range.start+e;return i>n.range.end-r&&(i=n.range.end-r),i}function ye(e){if(!m)throw re;var t=Se().currentTime;if(void 0!==e)t=U.getTimeRelativeToStreamId(t,e);else if(G.getIsDynamic()){var n=U&&U.hasVideoTrack()?a.Z.VIDEO:a.Z.AUDIO,r=H.getCurrentDVRInfo(n);t=null===r||0===t?0:Math.max(0,t-r.range.start)}return t}function Ee(){if(!m)throw re;var e=Se().duration;if(G.getIsDynamic()){var t=U&&U.hasVideoTrack()?a.Z.VIDEO:a.Z.AUDIO,n=H.getCurrentDVRInfo(t);e=n?n.range.end-n.range.start:0}return e}function ve(e){(0,z.PS)(e,"boolean"),y=e}function _e(){P.restoreDefaultUTCTimingSources()}function Te(){return H}function Se(){if(!J.getElement())throw ie;return J.getElement()}function be(e){if(!g)throw oe;J.setElement(e),e&&(De(),function(){if(!I){var e=dashjs.MetricsReporting;if("function"==typeof e){var t=e(se).create();I=t.createMetricsReporting({debug:ce,eventBus:ue,mediaElement:Se(),adapter:O,dashMetrics:H,mediaPlayerModel:M,events:l.Z,constants:a.Z,metricsConstants:s.Z})}}}(),function(){if(!R){var e=dashjs.MssHandler;"function"==typeof e&&(w.extend(e.errors),R=e(se).create({eventBus:ue,mediaPlayerModel:M,dashMetrics:H,manifestModel:V,playbackController:G,streamController:U,protectionController:A,baseURLController:x,errHandler:L,events:l.Z,constants:a.Z,debug:ce,initSegmentType:C.w.INIT_SEGMENT_TYPE,BASE64:ya,ISOBoxer:Ea,settings:le}))}}(),U&&U.switchToVideoElement(E)),m&&we(),Pe(E)}function Ae(e){if(!p)throw ne;var t=U.getActiveStreamInfo();return t?b.getTracksFor(e,t.id):[]}function Ie(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:NaN;if(!g)throw oe;"string"==typeof e&&$.initialize(e),null==t&&(t=NaN),isNaN(t)||(t=Math.max(0,t)),E=t,n=e,(p||m)&&we(),de()&&Pe(E)}function Re(){if(!p)throw ne;var e=U.getActiveStreamInfo();return e?U.getStreamById(e.id):null}function we(){m=!1,p=!1,O.reset(),U.reset(),B.reset(),j.reset(),G.reset(),q.reset(),Y.reset(),v.reset(),b.reset(),te.reset(),A&&(le.get().streaming.protection.keepProtectionMediaKeys?A.stop():(A.reset(),A=null,De())),Z.reset(),K.reset(),W.reset()}function Ne(){var e=Ce();U||(U=on(se).getInstance()),Z||(Z=Ga(se).create({errHandler:L,manifestModel:V,adapter:O,mediaController:b,videoModel:J,settings:le})),k.setConfig({capabilities:F,customParametersModel:P,adapter:O,settings:le,manifestModel:V,errHandler:L}),U.setConfig({capabilities:F,capabilitiesFilter:k,manifestLoader:e,manifestModel:V,mediaPlayerModel:M,customParametersModel:P,protectionController:A,textController:Z,adapter:O,dashMetrics:H,errHandler:L,timelineConverter:T,videoModel:J,playbackController:G,serviceDescriptionController:q,contentSteeringController:Y,abrController:v,mediaController:b,settings:le,baseURLController:x,uriFragmentModel:$,segmentBaseController:te}),B.setConfig({settings:le,playbackController:G,streamController:U,videoModel:J,timelineConverter:T,adapter:O}),G.setConfig({streamController:U,serviceDescriptionController:q,dashMetrics:H,adapter:O,videoModel:J,timelineConverter:T,settings:le}),j.setConfig({streamController:U,playbackController:G,mediaPlayerModel:M,videoModel:J,settings:le}),v.setConfig({streamController:U,domStorage:ee,mediaPlayerModel:M,customParametersModel:P,cmsdModel:W,dashMetrics:H,adapter:O,videoModel:J,settings:le}),K.setConfig({abrController:v,dashMetrics:H,playbackController:G}),W.setConfig({}),v.initialize(),U.initialize(y,r),Z.initialize(),B.initialize(),j.initialize(),K.initialize(),W.initialize(),Y.initialize(),te.initialize()}function Ce(){return Hr(se).create({debug:ce,errHandler:L,dashMetrics:H,mediaPlayerModel:M,requestModifier:(0,X.Z)(se).getInstance(),mssHandler:R,settings:le})}function De(){if(A)return A;var e=dashjs.Protection;if("function"==typeof e){var t=e(se).create();return l.Z.extend(e.events),d.Z.extend(e.events,{publicOnly:!0}),w.extend(e.errors),F||(F=(0,zr.Z)(se).getInstance()),A=t.createProtectionSystem({debug:ce,errHandler:L,videoModel:J,customParametersModel:P,capabilities:F,eventBus:ue,events:l.Z,BASE64:ya,constants:a.Z,cmcdModel:K,settings:le})}return null}function Oe(){if(!g)throw oe;if(D)return D;var e=dashjs.OfflineController;if("function"==typeof e){l.Z.extend(e.events),d.Z.extend(e.events,{publicOnly:!0}),w.extend(e.errors);var t=Ce(),n=zt(se).create();return n.setConfig({manifestModel:V,adapter:O,manifestLoader:t,errHandler:L,contentSteeringController:Y}),D=e(se).create({debug:ce,manifestUpdater:n,baseURLController:x,manifestLoader:t,manifestModel:V,mediaPlayerModel:M,abrController:v,playbackController:G,adapter:O,errHandler:L,dashMetrics:H,timelineConverter:T,segmentBaseController:te,schemeLoaderFactory:_,eventBus:ue,events:l.Z,errors:w,constants:a.Z,settings:le,dashConstants:o.Z,urlUtils:(0,Q.Z)(se).getInstance()})}return null}function Me(e){var t=U&&U.hasVideoTrack()?a.Z.VIDEO:a.Z.AUDIO,n=H.getCurrentDVRInfo(t);return n?e+(n.manifestInfo.availableFrom.getTime()/1e3+n.range.start):0}function Pe(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:NaN;D&&D.resetRecords(),!p&&n&&(p=!0,t.info("Streaming Initialized"),Ne(),"string"==typeof n?U.load(n,e):U.loadWithManifest(n,e)),!m&&de()&&(m=!0,t.info("Playback Initialized"))}return e={initialize:function(e,n,r){var o=arguments.length>3&&void 0!==arguments[3]?arguments[3]:NaN;F||(F=(0,zr.Z)(se).getInstance()).setConfig({settings:le}),L||(L=Kr(se).getInstance()),F.supportsMediaSource()?(g||(g=!0,T=ma(se).getInstance(),v||(v=yi(se).getInstance()).setConfig({settings:le}),_||(_=yt(se).getInstance()),G||(G=h(se).getInstance()),b||(b=Tn(se).getInstance()),U||(U=on(se).getInstance()),B||(B=un(se).getInstance()),j||(j=cn(se).getInstance()),q||(q=pn(se).getInstance()),Y||(Y=jt(se).getInstance()),k||(k=Xr(se).getInstance()),O=Xi(se).getInstance(),V=ti(se).getInstance(),K=je(se).getInstance(),W=lt(se).getInstance(),H=ha(se).getInstance({settings:le}),ee=Ni(se).getInstance({settings:le}),O.setConfig({constants:a.Z,cea608parser:i(),errHandler:L,BASE64:ya}),x||(x=xn(se).create()),x.setConfig({adapter:O,contentSteeringController:Y}),q.setConfig({adapter:O}),te||(te=Ui(se).getInstance({dashMetrics:H,mediaPlayerModel:M,errHandler:L,baseURLController:x,events:l.Z,eventBus:ue,debug:ce,boxParser:(0,xt.Z)(se).getInstance(),requestModifier:(0,X.Z)(se).getInstance(),errors:w})),b.setConfig({domStorage:ee,settings:le,customParametersModel:P}),M.setConfig({playbackController:G,serviceDescriptionController:q}),Y.setConfig({adapter:O,errHandler:L,dashMetrics:H,mediaPlayerModel:M,manifestModel:V,serviceDescriptionController:q,eventBus:ue,requestModifier:(0,X.Z)(se).getInstance()}),_e(),ve(void 0===r||r),Oe()),e&&be(e),n&&Ie(n,o),t.info("[dash.js "+ge()+"] MediaPlayer has been initialized")):L.error(new S.Z(w.CAPABILITY_MEDIASOURCE_ERROR_CODE,w.CAPABILITY_MEDIASOURCE_ERROR_MESSAGE))},setConfig:function(e){e&&(e.capabilities&&(F=e.capabilities),e.capabilitiesFilter&&(k=e.capabilitiesFilter),e.streamController&&(U=e.streamController),e.textController&&(Z=e.textController),e.gapController&&(B=e.gapController),e.playbackController&&(G=e.playbackController),e.serviceDescriptionController&&(q=e.serviceDescriptionController),e.contentSteeringController&&(Y=e.contentSteeringController),e.catchupController&&(j=e.catchupController),e.mediaPlayerModel&&(M=e.mediaPlayerModel),e.customParametersModel&&(P=e.customParametersModel),e.abrController&&(v=e.abrController),e.schemeLoaderFactory&&(_=e.schemeLoaderFactory),e.mediaController&&(b=e.mediaController),e.settings&&(le=e.settings))},on:function(e,t,n,r){ue.on(e,t,n,r)},off:function(e,t,n){ue.off(e,t,n)},extend:function(e,t,n){c.Z.extend(e,t,n,se)},attachView:be,attachSource:Ie,isReady:de,preload:function(){if(!J.getElement()&&!p){if(!n)throw ae;Pe(E)}},play:function(){if(!m)throw re;(!y||he()&&m)&&G.play(!0)},isPaused:he,pause:function(){if(!m)throw re;G.pause()},isSeeking:function(){if(!m)throw re;return G.isSeeking()},isDynamic:pe,getLowLatencyModeEnabled:function(){if(!m)throw re;return G.getLowLatencyModeEnabled()},seek:function(e){if(!m)throw re;if((0,z.PS)(e,"number"),isNaN(e))throw a.Z.BAD_ARGUMENT_ERROR;e<0&&(e=0);var t=G.getIsDynamic()?me(e):e,n=Se();!G.getIsDynamic()&&n.duration&&(t=Math.min(n.duration,t)),G.seek(t,!1,!1,!0)},seekToOriginalLive:function(){m&&pe()&&G.seekToOriginalLive()},setPlaybackRate:function(e){Se().playbackRate=e},getPlaybackRate:function(){return Se().playbackRate},setMute:function(e){(0,z.PS)(e,"boolean"),Se().muted=e},isMuted:function(){return Se().muted},setVolume:function(e){if("number"!=typeof e||isNaN(e)||e<0||e>1)throw a.Z.BAD_ARGUMENT_ERROR;Se().volume=e},getVolume:function(){return Se().volume},time:ye,duration:Ee,timeAsUTC:function(){if(!m)throw re;return ye()<0?NaN:Me(ye())},durationAsUTC:function(){if(!m)throw re;return Me(Ee())},getActiveStream:Re,getDVRWindowSize:function(){var e=U&&U.hasVideoTrack()?a.Z.VIDEO:a.Z.AUDIO,t=H.getCurrentDVRInfo(e);return t?t.manifestInfo.dvrWindowSize:0},getDVRSeekOffset:me,getAvailableBaseUrls:function(){var e=V.getValue();return e?x.getBaseUrls(e):[]},getAvailableLocations:function(){var e=V.getValue();if(!e)return[];var t=O.getLocation(e),n=Y.getSynthesizedLocationElements(t);return t.concat(n)},getTargetLiveDelay:function(){if(!m)throw re;return G.getOriginalLiveDelay()},convertToTimeCode:function(e){e=Math.max(e,0);var t=Math.floor(e/3600),n=Math.floor(e%3600/60),r=Math.floor(e%3600%60);return(0===t?"":t<10?"0"+t.toString()+":":t.toString()+":")+(n<10?"0"+n.toString():n.toString())+":"+(r<10?"0"+r.toString():r.toString())},formatUTC:function(e,t,n){var r=arguments.length>3&&void 0!==arguments[3]&&arguments[3],i=new Date(1e3*e),a=i.toLocaleDateString(t),o=i.toLocaleTimeString(t,{hour12:n});return r?o+" "+a:o},getVersion:ge,getDebug:function(){return ce},getBufferLength:function(e){var n=[a.Z.VIDEO,a.Z.AUDIO,a.Z.TEXT];if(e)return-1!==n.indexOf(e)?Te().getCurrentBufferLevel(e)||NaN:(t.warn("getBufferLength requested for invalid type"),NaN);var r=n.map((function(e){return Ae(e).length>0?Te().getCurrentBufferLevel(e):Number.MAX_VALUE})).reduce((function(e,t){return Math.min(e,t)}));return r===Number.MAX_VALUE?NaN:r},getTTMLRenderingDiv:function(){return J?J.getTTMLRenderingDiv():null},getVideoElement:Se,getSource:function(){if(!n)throw ae;return n},updateSource:function(e){n=e,U.load(n)},getCurrentLiveLatency:function(){if(!g)throw oe;return m?G.getCurrentLiveLatency():NaN},getTopBitrateInfoFor:function(e){if(!p)throw ne;return v.getTopBitrateInfoFor(e)},setAutoPlay:ve,getAutoPlay:function(){return y},getDashMetrics:Te,getQualityFor:function(e){if(!p)throw ne;if(e===a.Z.IMAGE){var t=Re();if(!t)return-1;var n=t.getThumbnailController();return n?n.getCurrentTrackIndex():-1}return v.getQualityFor(e)},setQualityFor:function(e,t){var n=arguments.length>2&&void 0!==arguments[2]&&arguments[2];if(!p)throw ne;if(e===a.Z.IMAGE){var r=Re();if(!r)return;var i=r.getThumbnailController();i&&i.setTrackByIndex(t)}v.setPlaybackQuality(e,U.getActiveStreamInfo(),t,{forceReplace:n})},updatePortalSize:function(){v.setElementSize(),v.setWindowResizeEventCalled(!0)},enableText:function(e){var t=U.getActiveStreamInfo();return!(!t||!Z)&&Z.enableText(t.id,e)},enableForcedTextStreaming:function(e){return!(!U.getActiveStreamInfo()||!Z)&&Z.enableForcedTextStreaming(e)},isTextEnabled:function(){var e=U.getActiveStreamInfo();return!(!e||!Z)&&Z.isTextEnabled(e)},setTextTrack:function(e){if(!m)throw re;var t=U.getActiveStreamInfo();t&&Z&&Z.setTextTrack(t.id,e)},getBitrateInfoListFor:function(e){if(!p)throw ne;var t=Re();return t?t.getBitrateListFor(e):[]},getStreamsFromManifest:function(e){if(!p)throw ne;return O.getStreamsInfo(e)},getTracksFor:Ae,getTracksForTypeFromManifest:function(e,t,n){if(!p)throw ne;return(n=n||O.getStreamsInfo(t,1)[0])?O.getAllMediaInfoForType(n,e,t):[]},getCurrentTrackFor:function(e){if(!p)throw ne;var t=U.getActiveStreamInfo();return b.getCurrentTrackFor(e,t.id)},setInitialMediaSettingsFor:function(e,t){if(!g)throw oe;b.setInitialSettings(e,t)},getInitialMediaSettingsFor:function(e){if(!g)throw oe;return b.getInitialSettings(e)},setCurrentTrack:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!p)throw ne;b.setTrack(e,t)},addABRCustomRule:function(e,t,n){P.addAbrCustomRule(e,t,n)},removeABRCustomRule:function(e){P.removeAbrCustomRule(e)},removeAllABRCustomRule:function(){P.removeAllAbrCustomRule()},getABRCustomRules:function(){return P.getAbrCustomRules()},getAverageThroughput:function(e){var t=v.getThroughputHistory(),n=G.getIsDynamic();return t?t.getAverageThroughput(e,n):0},retrieveManifest:function(e,t){var n=Ce(),r=this;ue.on(l.Z.INTERNAL_MANIFEST_LOADED,(function e(i){i.error?t(null,i.error):t(i.manifest),ue.off(l.Z.INTERNAL_MANIFEST_LOADED,e,r),n.reset()}),r),$.initialize(e),n.load(e)},addUTCTimingSource:function(e,t){P.addUTCTimingSource(e,t)},removeUTCTimingSource:function(e,t){P.removeUTCTimingSource(e,t)},clearDefaultUTCTimingSources:function(){P.clearDefaultUTCTimingSources()},restoreDefaultUTCTimingSources:_e,setXHRWithCredentialsForType:function(e,t){P.setXHRWithCredentialsForType(e,t)},getXHRWithCredentialsForType:function(e){return P.getXHRWithCredentialsForType(e)},getProtectionController:function(){return De()},attachProtectionController:function(e){A=e},setProtectionData:function(e){r=e,U&&U.setProtectionData(r)},registerLicenseRequestFilter:function(e){P.registerLicenseRequestFilter(e)},registerLicenseResponseFilter:function(e){P.registerLicenseResponseFilter(e)},unregisterLicenseRequestFilter:function(e){P.unregisterLicenseRequestFilter(e)},unregisterLicenseResponseFilter:function(e){P.unregisterLicenseResponseFilter(e)},registerCustomCapabilitiesFilter:function(e){P.registerCustomCapabilitiesFilter(e)},unregisterCustomCapabilitiesFilter:function(e){P.unregisterCustomCapabilitiesFilter(e)},setCustomInitialTrackSelectionFunction:function(e){P.setCustomInitialTrackSelectionFunction(e)},resetCustomInitialTrackSelectionFunction:function(){P.resetCustomInitialTrackSelectionFunction(null)},attachTTMLRenderingDiv:function(e){if(!J.getElement())throw ie;J.setTTMLRenderingDiv(e)},attachVttRenderingDiv:function(e){if(!J.getElement())throw ie;J.setVttRenderingDiv(e)},getCurrentTextTrackIndex:function(){var e=U.getActiveStreamInfo();if(e&&Z)return Z.getCurrentTrackIdx(e.id)},provideThumbnail:function(e,t){if("function"==typeof t)if(e<0)t(null);else{var n=G.getIsDynamic()?me(e):e,r=U.getStreamForTime(n);if(null!==r){var i=r.getThumbnailController();if(i)return i.provide(n,t);t(null)}else t(null)}},getDashAdapter:function(){return O},getOfflineController:function(){return Oe()},triggerSteeringRequest:function(){if(Y)return Y.loadSteeringData()},getCurrentSteeringResponseData:function(){if(Y)return Y.getCurrentSteeringResponseData()},getSettings:function(){return le.get()},updateSettings:function(e){le.update(e)},resetSettings:function(){le.reset()},reset:fe,destroy:function(){fe(),c.Z.deleteSingletonInstances(se)}},t=ce.getLogger(e),g=!1,m=!1,p=!1,y=!0,E=NaN,A=null,D=null,r=null,O=null,te=null,l.Z.extend(d.Z),M=ii(se).getInstance(),P=(0,dt.Z)(se).getInstance(),J=_i(se).getInstance(),$=$r(se).getInstance(),e}qa.__dashjs_factory_name="MediaPlayer";var Ya=c.Z.getClassFactory(qa);Ya.events=d.Z,Ya.errors=w,c.Z.updateClassFactory(qa.__dashjs_factory_name,Ya);var ja=Ya},8825:function(e,t,n){"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function i(e,t){return i=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},i(e,t)}function a(e,t){return!t||"object"!==r(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function o(e){return o=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},o(e)}var s=new(function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&i(e,t)}(s,e);var t,n,r=(t=s,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=o(t);if(n){var i=o(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return a(this,e)});function s(){var e;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,s),(e=r.call(this)).AST_IN_FUTURE="astInFuture",e.BASE_URLS_UPDATED="baseUrlsUpdated",e.BUFFER_EMPTY="bufferStalled",e.BUFFER_LOADED="bufferLoaded",e.BUFFER_LEVEL_STATE_CHANGED="bufferStateChanged",e.BUFFER_LEVEL_UPDATED="bufferLevelUpdated",e.DYNAMIC_TO_STATIC="dynamicToStatic",e.ERROR="error",e.FRAGMENT_LOADING_COMPLETED="fragmentLoadingCompleted",e.FRAGMENT_LOADING_PROGRESS="fragmentLoadingProgress",e.FRAGMENT_LOADING_STARTED="fragmentLoadingStarted",e.FRAGMENT_LOADING_ABANDONED="fragmentLoadingAbandoned",e.LOG="log",e.MANIFEST_LOADING_STARTED="manifestLoadingStarted",e.MANIFEST_LOADING_FINISHED="manifestLoadingFinished",e.MANIFEST_LOADED="manifestLoaded",e.METRICS_CHANGED="metricsChanged",e.METRIC_CHANGED="metricChanged",e.METRIC_ADDED="metricAdded",e.METRIC_UPDATED="metricUpdated",e.PERIOD_SWITCH_STARTED="periodSwitchStarted",e.PERIOD_SWITCH_COMPLETED="periodSwitchCompleted",e.QUALITY_CHANGE_REQUESTED="qualityChangeRequested",e.QUALITY_CHANGE_RENDERED="qualityChangeRendered",e.TRACK_CHANGE_RENDERED="trackChangeRendered",e.STREAM_INITIALIZING="streamInitializing",e.STREAM_UPDATED="streamUpdated",e.STREAM_ACTIVATED="streamActivated",e.STREAM_DEACTIVATED="streamDeactivated",e.STREAM_INITIALIZED="streamInitialized",e.STREAM_TEARDOWN_COMPLETE="streamTeardownComplete",e.TEXT_TRACKS_ADDED="allTextTracksAdded",e.TEXT_TRACK_ADDED="textTrackAdded",e.THROUGHPUT_MEASUREMENT_STORED="throughputMeasurementStored",e.TTML_PARSED="ttmlParsed",e.TTML_TO_PARSE="ttmlToParse",e.CAPTION_RENDERED="captionRendered",e.CAPTION_CONTAINER_RESIZE="captionContainerResize",e.CAN_PLAY="canPlay",e.CAN_PLAY_THROUGH="canPlayThrough",e.PLAYBACK_ENDED="playbackEnded",e.PLAYBACK_ERROR="playbackError",e.PLAYBACK_NOT_ALLOWED="playbackNotAllowed",e.PLAYBACK_METADATA_LOADED="playbackMetaDataLoaded",e.PLAYBACK_LOADED_DATA="playbackLoadedData",e.PLAYBACK_PAUSED="playbackPaused",e.PLAYBACK_PLAYING="playbackPlaying",e.PLAYBACK_PROGRESS="playbackProgress",e.PLAYBACK_RATE_CHANGED="playbackRateChanged",e.PLAYBACK_SEEKED="playbackSeeked",e.PLAYBACK_SEEKING="playbackSeeking",e.PLAYBACK_STALLED="playbackStalled",e.PLAYBACK_STARTED="playbackStarted",e.PLAYBACK_TIME_UPDATED="playbackTimeUpdated",e.PLAYBACK_VOLUME_CHANGED="playbackVolumeChanged",e.PLAYBACK_WAITING="playbackWaiting",e.MANIFEST_VALIDITY_CHANGED="manifestValidityChanged",e.EVENT_MODE_ON_START="eventModeOnStart",e.EVENT_MODE_ON_RECEIVE="eventModeOnReceive",e.CONFORMANCE_VIOLATION="conformanceViolation",e.REPRESENTATION_SWITCH="representationSwitch",e.ADAPTATION_SET_REMOVED_NO_CAPABILITIES="adaptationSetRemovedNoCapabilities",e.CONTENT_STEERING_REQUEST_COMPLETED="contentSteeringRequestCompleted",e.INBAND_PRFT="inbandPrft",e.MANAGED_MEDIA_SOURCE_START_STREAMING="managedMediaSourceStartStreaming",e.MANAGED_MEDIA_SOURCE_END_STREAMING="managedMediaSourceEndStreaming",e}return s}(n(8342).Z));t.Z=s},3393:function(e,t){"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var r=new(function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.init()}var t,r;return t=e,(r=[{key:"init",value:function(){this.STREAM="stream",this.VIDEO="video",this.AUDIO="audio",this.TEXT="text",this.MUXED="muxed",this.IMAGE="image",this.STPP="stpp",this.TTML="ttml",this.VTT="vtt",this.WVTT="wvtt",this.CONTENT_STEERING="contentSteering",this.ABR_STRATEGY_DYNAMIC="abrDynamic",this.ABR_STRATEGY_BOLA="abrBola",this.ABR_STRATEGY_L2A="abrL2A",this.ABR_STRATEGY_LoLP="abrLoLP",this.ABR_STRATEGY_THROUGHPUT="abrThroughput",this.ABR_FETCH_THROUGHPUT_CALCULATION_DOWNLOADED_DATA="abrFetchThroughputCalculationDownloadedData",this.ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING="abrFetchThroughputCalculationMoofParsing",this.ABR_FETCH_THROUGHPUT_CALCULATION_AAST="abrFetchThroughputCalculationAAST",this.LIVE_CATCHUP_MODE_DEFAULT="liveCatchupModeDefault",this.LIVE_CATCHUP_MODE_LOLP="liveCatchupModeLoLP",this.MOVING_AVERAGE_SLIDING_WINDOW="slidingWindow",this.MOVING_AVERAGE_EWMA="ewma",this.BAD_ARGUMENT_ERROR="Invalid Arguments",this.MISSING_CONFIG_ERROR="Missing config parameter(s)",this.TRACK_SWITCH_MODE_ALWAYS_REPLACE="alwaysReplace",this.TRACK_SWITCH_MODE_NEVER_REPLACE="neverReplace",this.TRACK_SELECTION_MODE_FIRST_TRACK="firstTrack",this.TRACK_SELECTION_MODE_HIGHEST_BITRATE="highestBitrate",this.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY="highestEfficiency",this.TRACK_SELECTION_MODE_WIDEST_RANGE="widestRange",this.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY="highestSelectionPriority",this.CMCD_MODE_QUERY="query",this.CMCD_MODE_HEADER="header",this.INITIALIZE="initialize",this.TEXT_SHOWING="showing",this.TEXT_HIDDEN="hidden",this.CC1="CC1",this.CC3="CC3",this.UTF8="utf-8",this.SCHEME_ID_URI="schemeIdUri",this.START_TIME="starttime",this.SERVICE_DESCRIPTION_DVB_LL_SCHEME="urn:dvb:dash:lowlatency:scope:2019",this.SUPPLEMENTAL_PROPERTY_DVB_LL_SCHEME="urn:dvb:dash:lowlatency:critical:2019",this.XML="XML",this.ARRAY_BUFFER="ArrayBuffer",this.DVB_REPORTING_URL="dvb:reportingUrl",this.DVB_PROBABILITY="dvb:probability",this.VIDEO_ELEMENT_READY_STATES={HAVE_NOTHING:0,HAVE_METADATA:1,HAVE_CURRENT_DATA:2,HAVE_FUTURE_DATA:3,HAVE_ENOUGH_DATA:4},this.FILE_LOADER_TYPES={FETCH:"fetch_loader",XHR:"xhr_loader"}}}])&&n(t.prototype,r),e}());t.Z=r},3860:function(e,t){"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var r=new(function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.init()}var t,r;return t=e,(r=[{key:"init",value:function(){this.TCP_CONNECTION="TcpList",this.HTTP_REQUEST="HttpList",this.TRACK_SWITCH="RepSwitchList",this.BUFFER_LEVEL="BufferLevel",this.BUFFER_LOADED="bufferLoaded",this.ABANDON_LOAD="abandonload",this.ALLOW_LOAD="allowload",this.BUFFER_EMPTY="bufferStalled",this.BUFFER_STATE="BufferState",this.DVR_INFO="DVRInfo",this.DROPPED_FRAMES="DroppedFrames",this.SCHEDULING_INFO="SchedulingInfo",this.REQUESTS_QUEUE="RequestsQueue",this.MANIFEST_UPDATE="ManifestUpdate",this.MANIFEST_UPDATE_STREAM_INFO="ManifestUpdatePeriodInfo",this.MANIFEST_UPDATE_TRACK_INFO="ManifestUpdateRepresentationInfo",this.PLAY_LIST="PlayList",this.DVB_ERRORS="DVBErrors",this.HTTP_REQUEST_DVB_REPORTING_TYPE="DVBReporting"}}])&&n(t.prototype,r),e}());t.Z=r},8080:function(e,t,n){"use strict";n.d(t,{default:function(){return V}});var r=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.mpdurl=null,this.errorcode=null,this.terror=null,this.url=null,this.ipaddress=null,this.servicelocation=null};r.SSL_CONNECTION_FAILED_PREFIX="SSL",r.DNS_RESOLUTION_FAILED="C00",r.HOST_UNREACHABLE="C01",r.CONNECTION_REFUSED="C02",r.CONNECTION_ERROR="C03",r.CORRUPT_MEDIA_ISOBMFF="M00",r.CORRUPT_MEDIA_OTHER="M01",r.BASE_URL_CHANGED="F00",r.BECAME_REPORTER="S00";var i=r,a=n(1180);function o(e){var t,n,r=(e=e||{}).eventBus,o=e.dashMetrics,s=e.metricsConstants,u=e.events;function l(e){var t=new i;if(n){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r]);t.mpdurl||(t.mpdurl=n.originalUrl||n.url),t.terror||(t.terror=new Date),o.addDVBErrors(t)}}function c(e){e.error||(n=e.manifest)}function f(e){l({errorcode:i.BASE_URL_CHANGED,servicelocation:e.entry})}function d(){l({errorcode:i.BECAME_REPORTER})}function g(e){var t;e.metric===s.HTTP_REQUEST&&(0===(t=e.value).responsecode||null==t.responsecode||t.responsecode>=400||t.responsecode<100||t.responsecode>=600)&&l({errorcode:t.responsecode||i.CONNECTION_ERROR,url:t.url,terror:t.tresponse,servicelocation:t._serviceLocation})}function h(e){var t;switch(e.error?e.error.code:0){case MediaError.MEDIA_ERR_NETWORK:t=i.CONNECTION_ERROR;break;case MediaError.MEDIA_ERR_DECODE:t=i.CORRUPT_MEDIA_OTHER;break;default:return}l({errorcode:t})}return t={initialize:function(){r.on(u.MANIFEST_UPDATED,c,t),r.on(u.SERVICE_LOCATION_BASE_URL_BLACKLIST_CHANGED,f,t),r.on(u.METRIC_ADDED,g,t),r.on(u.METRIC_UPDATED,g,t),r.on(u.PLAYBACK_ERROR,h,t),r.on(a.Z.BECAME_REPORTING_PLAYER,d,t)},reset:function(){r.off(u.MANIFEST_UPDATED,c,t),r.off(u.SERVICE_LOCATION_BASE_URL_BLACKLIST_CHANGED,f,t),r.off(u.METRIC_ADDED,g,t),r.off(u.METRIC_UPDATED,g,t),r.off(u.PLAYBACK_ERROR,h,t),r.off(a.Z.BECAME_REPORTING_PLAYER,d,t)}}}o.__dashjs_factory_name="DVBErrorsTranslator";var s=dashjs.FactoryMaker.getSingletonFactory(o),u=n(2295);function l(e){e=e||{};var t,n,r=!1,i=this.context,a=e.mediaElement;return t={initialize:function(e){e&&e.length&&(e.forEach((function(e){var t=e.starttime,r=t+e.duration;n.add(t,r)})),r=!!e[0]._useWallClockTime)},reset:function(){n.clear()},isEnabled:function(){var e,t=n.length;if(!t)return!0;e=r?(new Date).getTime()/1e3:a.currentTime;for(var i=0;i<t;i+=1){var o=n.start(i),s=n.end(i);if(o<=e&&e<s)return!0}return!1}},n=(0,u.Z)(i).create(),t}l.__dashjs_factory_name="RangeController";var c=dashjs.FactoryMaker.getClassFactory(l);function f(){return{serialise:function e(t){var n,r,i=[],a=[];for(n in t)if(t.hasOwnProperty(n)&&0!==n.indexOf("_")){if(null==(r=t[n])&&(r=""),Array.isArray(r)){if(!r.length)continue;a=[],r.forEach((function(t){var n="Object"!==Object.prototype.toString.call(t).slice(8,-1);a.push(n?t:e(t))})),r=a.map(encodeURIComponent).join(",")}else"string"==typeof r?r=encodeURIComponent(r):r instanceof Date?r=r.toISOString():"number"==typeof r&&(r=Math.round(r));i.push(n+"="+r)}return i.join("&")}}}f.__dashjs_factory_name="MetricSerialiser";var d=dashjs.FactoryMaker.getSingletonFactory(f);function g(){var e,t,n,r=window.crypto||window.msCrypto,i=Uint32Array,a=Math.pow(2,8*i.BYTES_PER_ELEMENT)-1;function o(){r&&(e||(e=new i(10)),r.getRandomValues(e),t=0)}return n={random:function(n,i){var s;return n||(n=0),i||(i=1),r?(t===e.length&&o(),s=e[t]/a,t+=1):s=Math.random(),s*(i-n)+n}},o(),n}g.__dashjs_factory_name="RNG";var h=dashjs.FactoryMaker.getSingletonFactory(g),p=n(5717);function m(e){var t;e=e||{};var n,r,i,a,o,s,u,l=this.context,c=[],f=e.metricsConstants;function g(){a=!1,o=!1,s=null,u=null}return t={report:function(e,t){Array.isArray(t)||(t=[t]),o&&u.isEnabled()&&t.forEach((function(t){var i=n.serialise(t);e!==f.DVB_ERRORS&&(i="metricname=".concat(e,"&").concat(i)),function(e,t,n){var i=new XMLHttpRequest;i.withCredentials=r.getXHRWithCredentialsForType(f.HTTP_REQUEST_DVB_REPORTING_TYPE);var a=function(){var e=c.indexOf(i);-1!==e&&(c.splice(e,1),!(i.status>=200&&i.status<300)&&(n&&n()))};c.push(i);try{i.open("GET",e),i.onloadend=a,i.onerror=a,i.send()}catch(e){i.onerror()}}(i="".concat(s,"?").concat(i),0,(function(){o=!1}))}))},initialize:function(e,t){var n;if(u=t,!(s=e.dvb_reportingUrl))throw new Error("required parameter missing (dvb:reportingUrl)");a||((n=e.dvb_probability)&&(1e3===n||n/1e3>=i.random())&&(o=!0),a=!0)},reset:function(){g()}},n=d(l).getInstance(),i=h(l).getInstance(),r=(0,p.Z)(l).getInstance(),g(),t}m.__dashjs_factory_name="DVBReporting";var y=dashjs.FactoryMaker.getClassFactory(m);function E(e){e=e||{};var t,n={"urn:dvb:dash:reporting:2014":y},r=this.context,i=e.debug?e.debug.getLogger(t):{},a=e.metricsConstants,o=e.mediaPlayerModel||{};return{create:function(e,t){var s;try{(s=n[e.schemeIdUri](r).create({metricsConstants:a,mediaPlayerModel:o})).initialize(e,t)}catch(t){s=null,i.error("ReportingFactory: could not create Reporting with schemeIdUri ".concat(e.schemeIdUri," (").concat(t.message,")"))}return s},register:function(e,t){n[e]=t},unregister:function(e){delete n[e]}}}E.__dashjs_factory_name="ReportingFactory";var v=dashjs.FactoryMaker.getSingletonFactory(E);function _(e){var t=[],n=v(this.context).getInstance(e);return{initialize:function(e,r){e.some((function(e){var i=n.create(e,r);if(i)return t.push(i),!0}))},reset:function(){t.forEach((function(e){return e.reset()})),t=[]},report:function(e,n){t.forEach((function(t){return t.report(e,n)}))}}}_.__dashjs_factory_name="ReportingController";var T=dashjs.FactoryMaker.getClassFactory(_);function S(){return{reconstructFullMetricName:function(e,t,n){var r=e;return t&&(r+="("+t,n&&n.length&&(r+=","+n),r+=")"),r},validateN:function(e){if(!e)throw new Error("missing n");if(isNaN(e))throw new Error("n is NaN");if(e<0)throw new Error("n must be positive");return e}}}S.__dashjs_factory_name="HandlerHelpers";var b=dashjs.FactoryMaker.getSingletonFactory(S);function A(e){var t,n,r,i,a;e=e||{};var o=this.context,s=b(o).getInstance(),u=[],l=e.metricsConstants;function c(){var e=function(){try{return Object.keys(u).map((function(e){return u[e]})).reduce((function(e,t){return e.level<t.level?e:t}))}catch(e){return}}();e&&a!==e.t&&(a=e.t,t.report(r,e))}return{initialize:function(e,a,o){a&&(n=s.validateN(o),t=a,r=s.reconstructFullMetricName(e,o),i=setInterval(c,n))},reset:function(){clearInterval(i),i=null,n=0,t=null,a=null},handleNewMetric:function(e,t,n){e===l.BUFFER_LEVEL&&(u[n]=t)}}}A.__dashjs_factory_name="BufferLevelHandler";var I=dashjs.FactoryMaker.getClassFactory(A),R=dashjs.FactoryMaker.getClassFactory((function(e){var t,n=(e=e||{}).eventBus,r=e.metricsConstants;function i(){n.off(a.Z.METRICS_INITIALISATION_COMPLETE,i,this),n.trigger(a.Z.BECAME_REPORTING_PLAYER)}return{initialize:function(e,r){r&&(t=r,n.on(a.Z.METRICS_INITIALISATION_COMPLETE,i,this))},reset:function(){t=null},handleNewMetric:function(e,n){e===r.DVB_ERRORS&&t&&t.report(e,n)}}}));function w(e){var t,n,r,i,a;e=e||{};var o=[],s=b(this.context).getInstance(),u=e.metricsConstants;function l(){var e=o;e.length&&t&&t.report(i,e),o=[]}return{initialize:function(e,o,u,c){o&&(n=s.validateN(u),t=o,c&&c.length&&(r=c),i=s.reconstructFullMetricName(e,u,c),a=setInterval(l,n))},reset:function(){clearInterval(a),a=null,n=null,r=null,o=[],t=null},handleNewMetric:function(e,t){e===u.HTTP_REQUEST&&(r&&r!==t.type||o.push(t))}}}w.__dashjs_factory_name="HttpListHandler";var N=dashjs.FactoryMaker.getClassFactory(w);function C(){var e,t;return{initialize:function(n,r){e=n,t=r},reset:function(){t=null,e=void 0},handleNewMetric:function(n,r){n===e&&t&&t.report(e,r)}}}C.__dashjs_factory_name="GenericMetricHandler";var D=dashjs.FactoryMaker.getClassFactory(C);function O(e){var t,n=(e=e||{}).debug?e.debug.getLogger(t):{},r=/([a-zA-Z]*)(\\(([0-9]*)(\\,\\s*([a-zA-Z]*))?\\))?/,i=this.context,a={BufferLevel:I,DVBErrors:R,HttpList:N,PlayList:D,RepSwitchList:D,TcpList:D};return{create:function(t,o){var s,u=t.match(r);if(u){try{(s=a[u[1]](i).create({eventBus:e.eventBus,metricsConstants:e.metricsConstants})).initialize(u[1],o,u[3],u[5])}catch(e){s=null,n.error("MetricsHandlerFactory: Could not create handler for type ".concat(u[1]," with args ").concat(u[3],", ").concat(u[5]," (").concat(e.message,")"))}return s}},register:function(e,t){a[e]=t},unregister:function(e){delete a[e]}}}O.__dashjs_factory_name="MetricsHandlerFactory";var M=dashjs.FactoryMaker.getSingletonFactory(O);function P(e){e=e||{};var t,n=[],r=this.context,i=e.eventBus,a=e.events,o=M(r).getInstance({debug:e.debug,eventBus:e.eventBus,metricsConstants:e.metricsConstants});function s(e){n.forEach((function(t){t.handleNewMetric(e.metric,e.value,e.mediaType)}))}return t={initialize:function(e,r){e.split(",").forEach((function(e,t,i){var a;if(-1!==e.indexOf("(")&&-1===e.indexOf(")")){var s=i[t+1];s&&-1===s.indexOf("(")&&-1!==s.indexOf(")")&&(e+=","+s,delete i[t+1])}(a=o.create(e,r))&&n.push(a)})),i.on(a.METRIC_ADDED,s,t),i.on(a.METRIC_UPDATED,s,t)},reset:function(){i.off(a.METRIC_ADDED,s,t),i.off(a.METRIC_UPDATED,s,t),n.forEach((function(e){return e.reset()})),n=[]}}}P.__dashjs_factory_name="MetricsHandlersController";var L=dashjs.FactoryMaker.getClassFactory(P);function x(e){var t,n,r;e=e||{};var i=this.context;function a(){t&&t.reset(),n&&n.reset(),r&&r.reset()}return{initialize:function(o){try{(r=c(i).create({mediaElement:e.mediaElement})).initialize(o.Range),(n=T(i).create({debug:e.debug,metricsConstants:e.metricsConstants,mediaPlayerModel:e.mediaPlayerModel})).initialize(o.Reporting,r),(t=L(i).create({debug:e.debug,eventBus:e.eventBus,metricsConstants:e.metricsConstants,events:e.events})).initialize(o.metrics,n)}catch(e){throw a(),e}},reset:a}}x.__dashjs_factory_name="MetricsController";var F=dashjs.FactoryMaker.getClassFactory(x),k=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.metrics="",this.Range=[],this.Reporting=[]},U=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.starttime=0,this.duration=1/0,this._useWallClockTime=!1},Z=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.schemeIdUri="",this.value="",this.dvb_reportingUrl="",this.dvb_probability=1e3};function B(e){var t=(e=e||{}).adapter,n=e.constants;return{getMetrics:function(e){var r=[];return e&&e.Metrics_asArray&&e.Metrics_asArray.forEach((function(i){var a=new k,o=t.getIsDynamic(e);i.hasOwnProperty("metrics")&&(a.metrics=i.metrics,i.Range_asArray&&i.Range_asArray.forEach((function(r){var i=new U;i.starttime=function(e,r,i){var a,o,s=0;return r?s=t.getAvailabilityStartTime(e)/1e3:(a=t.getRegularPeriods(e)).length&&(s=a[0].start),o=s,i&&i.hasOwnProperty(n.START_TIME)&&(o+=i.starttime),o}(e,o,r),r.hasOwnProperty("duration")?i.duration=r.duration:i.duration=t.getDuration(e),i._useWallClockTime=o,a.Range.push(i)})),i.Reporting_asArray&&(i.Reporting_asArray.forEach((function(e){var t=new Z;e.hasOwnProperty(n.SCHEME_ID_URI)&&(t.schemeIdUri=e.schemeIdUri,e.hasOwnProperty("value")&&(t.value=e.value),e.hasOwnProperty(n.DVB_REPORTING_URL)&&(t.dvb_reportingUrl=e[n.DVB_REPORTING_URL]),e.hasOwnProperty(n.DVB_PROBABILITY)&&(t.dvb_probability=e[n.DVB_PROBABILITY]),a.Reporting.push(t))})),r.push(a)))})),r}}}B.__dashjs_factory_name="ManifestParsing";var G=dashjs.FactoryMaker.getSingletonFactory(B);function q(e){var t;e=e||{};var n={},r=this.context,i=e.eventBus,o=e.events;function s(t){if(!t.error){var o=Object.keys(n);G(r).getInstance({adapter:e.adapter,constants:e.constants}).getMetrics(t.manifest).forEach((function(t){var i=JSON.stringify(t);if(n.hasOwnProperty(i))o.splice(i,1);else try{var a=F(r).create(e);a.initialize(t),n[i]=a}catch(e){}})),o.forEach((function(e){n[e].reset(),delete n[e]})),i.trigger(a.Z.METRICS_INITIALISATION_COMPLETE)}}function u(){Object.keys(n).forEach((function(e){n[e].reset()})),n={}}return t={reset:function(){i.off(o.MANIFEST_UPDATED,s,t),i.off(o.STREAM_TEARDOWN_COMPLETE,u,t)}},i.on(o.MANIFEST_UPDATED,s,t),i.on(o.STREAM_TEARDOWN_COMPLETE,u,t),t}q.__dashjs_factory_name="MetricsCollectionController";var Y=dashjs.FactoryMaker.getClassFactory(q);function j(){var e=this.context;return{createMetricsReporting:function(t){return s(e).getInstance({eventBus:t.eventBus,dashMetrics:t.dashMetrics,metricsConstants:t.metricsConstants,events:t.events}).initialize(),Y(e).create(t)},getReportingFactory:function(){return v(e).getInstance()},getMetricsHandlerFactory:function(){return M(e).getInstance()}}}j.__dashjs_factory_name="MetricsReporting";var H=dashjs.FactoryMaker.getClassFactory(j);H.events=a.Z,dashjs.FactoryMaker.updateClassFactory(j.__dashjs_factory_name,H);var V=H},1180:function(e,t,n){"use strict";function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function i(e,t){return i=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},i(e,t)}function a(e,t){return!t||"object"!==r(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function o(e){return o=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},o(e)}var s=new(function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&i(e,t)}(s,e);var t,n,r=(t=s,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=o(t);if(n){var i=o(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return a(this,e)});function s(){var e;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,s),(e=r.call(this)).METRICS_INITIALISATION_COMPLETE="internal_metricsReportingInitialized",e.BECAME_REPORTING_PLAYER="internal_becameReportingPlayer",e.CMCD_DATA_GENERATED="cmcdDataGenerated",e}return s}(n(8342).Z));t.Z=s},5717:function(e,t,n){"use strict";var r=n(2610),i=n(5448),a=n(1264),o=n(3106),s=n(1767),u=n(3393);function l(){var e,t,n,i,l,c,f,d,g=this.context,h=(0,a.Z)(g).getInstance();function p(){i=[],l=[],c=[],d=[],f=null,t=[]}function m(e,t){var n=-1;e.some((function(e,r){if(e===t)return n=r,!0})),n<0||e.splice(n,1)}function y(e){var t;for(t=0;t<d.length;t++)if(d[t].rulename===e)return t;return-1}function E(e,n){v(e,n);var i=new r.Z;i.schemeIdUri=e,i.value=n,t.push(i)}function v(e,n){(0,o.PS)(e,"string"),(0,o.PS)(n,"string"),t.forEach((function(r,i){r.schemeIdUri===e&&r.value===n&&t.splice(i,1)}))}return e={getCustomInitialTrackSelectionFunction:function(){return f},setCustomInitialTrackSelectionFunction:function(e){f=e},resetCustomInitialTrackSelectionFunction:function(){f=null},getLicenseResponseFilters:function(){return l},getLicenseRequestFilters:function(){return i},getCustomCapabilitiesFilters:function(){return c},registerCustomCapabilitiesFilter:function(e){c.push(e)},registerLicenseResponseFilter:function(e){l.push(e)},registerLicenseRequestFilter:function(e){i.push(e)},unregisterCustomCapabilitiesFilter:function(e){m(c,e)},unregisterLicenseResponseFilter:function(e){m(l,e)},unregisterLicenseRequestFilter:function(e){m(i,e)},addAbrCustomRule:function(e,t,n){if("string"!=typeof e||e!==s.Z.ABANDON_FRAGMENT_RULES&&e!==s.Z.QUALITY_SWITCH_RULES||"string"!=typeof t)throw u.Z.BAD_ARGUMENT_ERROR;var r=y(t);-1===r?d.push({type:e,rulename:t,rule:n}):(d[r].type=e,d[r].rule=n)},removeAllAbrCustomRule:function(){d=[]},removeAbrCustomRule:function(e){if(e){var t=y(e);-1!==t&&d.splice(t,1)}else d=[]},getAbrCustomRules:function(){return d},addUTCTimingSource:E,removeUTCTimingSource:v,getUTCTimingSources:function(){return t},clearDefaultUTCTimingSources:function(){t=[]},restoreDefaultUTCTimingSources:function(){var e=h.get().streaming.utcSynchronization.defaultTimingSource;E(e.scheme,e.value)},setXHRWithCredentialsForType:function e(t,r){t?n[t]=!!r:Object.keys(n).forEach((function(t){e(t,r)}))},getXHRWithCredentialsForType:function(e){var t=n[e];return void 0===t?n.default:t},setConfig:function(){},reset:function(){p()}},n={default:!1},p(),e}l.__dashjs_factory_name="CustomParametersModel",t.Z=i.Z.getSingletonFactory(l)},9032:function(e,t,n){"use strict";var r=n(5448),i=n(7473);function a(e){var t=(e=e||{}).requestModifier;function n(e){var n=new Date,r=e.request,i=new XMLHttpRequest;if(i.open(e.method,e.url,!0),r.responseType&&(i.responseType=r.responseType),r.range&&i.setRequestHeader("Range","bytes="+r.range),r.requestStartDate||(r.requestStartDate=n),t&&t.modifyRequestHeader&&(i=t.modifyRequestHeader(i,{url:e.url})),e.headers)for(var a in e.headers){var o=e.headers[a];o&&i.setRequestHeader(a,o)}i.withCredentials=e.withCredentials,i.onload=e.onload,i.onloadend=e.onend,i.onerror=e.onerror,i.onprogress=e.progress,i.onabort=e.onabort,i.ontimeout=e.ontimeout,i.timeout=e.timeout,i.send(),e.response=i}return{load:function(e){t&&t.modifyRequest?(0,i.k)(e,t).then((function(){return n(e)})):n(e)},abort:function(e){var t=e.response;t.onloadend=t.onerror=t.onprogress=void 0,t.abort()}}}a.__dashjs_factory_name="XHRLoader";var o=r.Z.getClassFactory(a);t.Z=o},1737:function(e,t,n){"use strict";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}n.d(t,{default:function(){return be}});var i={attributes:["Laurl","laurl"],prefixes:["clearkey","dashif"]},a=function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e)}var t,n;return t=e,n=[{key:"findCencContentProtection",value:function(e){for(var t=null,n=0;n<e.length;++n){var r=e[n];"urn:mpeg:dash:mp4protection:2011"!==r.schemeIdUri.toLowerCase()||"cenc"!==r.value.toLowerCase()&&"cbcs"!==r.value.toLowerCase()||(t=r)}return t}},{key:"getPSSHData",value:function(e){var t=8,n=new DataView(e),r=n.getUint8(t);return t+=20,r>0&&(t+=4+16*n.getUint32(t)),t+=4,e.slice(t)}},{key:"getPSSHForKeySystem",value:function(t,n){var r=e.parsePSSHList(n);return t&&r.hasOwnProperty(t.uuid.toLowerCase())?r[t.uuid.toLowerCase()]:null}},{key:"parseInitDataFromContentProtection",value:function(e,t){return"pssh"in e?(e.pssh.__text=e.pssh.__text.replace(/\\r?\\n|\\r/g,"").replace(/\\s+/g,""),t.decodeArray(e.pssh.__text).buffer):null}},{key:"parsePSSHList",value:function(e){if(null==e)return[];for(var t=new DataView(e.buffer||e),n={},r=0;;){var i,a,o=void 0,s=r;if(r>=t.buffer.byteLength)break;if(i=r+t.getUint32(r),r+=4,1886614376===t.getUint32(r))if(r+=4,0===(a=t.getUint8(r))||1===a){r++,r+=3,o="";var u=void 0,l=void 0;for(u=0;u<4;u++)o+=1===(l=t.getUint8(r+u).toString(16)).length?"0"+l:l;for(r+=4,o+="-",u=0;u<2;u++)o+=1===(l=t.getUint8(r+u).toString(16)).length?"0"+l:l;for(r+=2,o+="-",u=0;u<2;u++)o+=1===(l=t.getUint8(r+u).toString(16)).length?"0"+l:l;for(r+=2,o+="-",u=0;u<2;u++)o+=1===(l=t.getUint8(r+u).toString(16)).length?"0"+l:l;for(r+=2,o+="-",u=0;u<6;u++)o+=1===(l=t.getUint8(r+u).toString(16)).length?"0"+l:l;r+=6,r+=4,n[o=o.toLowerCase()]=t.buffer.slice(s,i),r=i}else r=i;else r=i}return n}},{key:"getLicenseServerUrlFromMediaInfo",value:function(e,t){try{if(!e||0===e.length)return null;for(var n=0,r=null;n<e.length&&!r;){var a=e[n];if(a&&a.contentProtection&&a.contentProtection.length>0){var o=a.contentProtection.filter((function(e){return e.schemeIdUri&&e.schemeIdUri===t}));if(o&&o.length>0)for(var s=0;s<o.length&&!r;){for(var u=o[s],l=0;l<i.attributes.length&&!r;){for(var c=0,f=i.attributes[l];c<i.prefixes.length&&!r;){var d=i.prefixes[c];u[f]&&u[f].__prefix&&u[f].__prefix===d&&u[f].__text&&(r=u[f].__text),c+=1}l+=1}s+=1}}n+=1}return r}catch(e){return null}}}],null&&0,n&&r(t,n),e}(),o=function e(t,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.contentType=t,this.robustness=n},s=function e(t,n,r,i,a){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.initDataTypes=["cenc"],t&&t.length&&(this.audioCapabilities=t),n&&n.length&&(this.videoCapabilities=n),this.distinctiveIdentifier=r,this.persistentState=i,this.sessionTypes=a};function u(e){return u="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},u(e)}function l(e,t){return l=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},l(e,t)}function c(e,t){return!t||"object"!==u(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function f(e){return f=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},f(e)}var d=new(function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&l(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=f(t);if(n){var i=f(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return c(this,e)});function i(){var e;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),(e=r.call(this)).MEDIA_KEYERR_CODE=100,e.MEDIA_KEYERR_UNKNOWN_CODE=101,e.MEDIA_KEYERR_CLIENT_CODE=102,e.MEDIA_KEYERR_SERVICE_CODE=103,e.MEDIA_KEYERR_OUTPUT_CODE=104,e.MEDIA_KEYERR_HARDWARECHANGE_CODE=105,e.MEDIA_KEYERR_DOMAIN_CODE=106,e.MEDIA_KEY_MESSAGE_ERROR_CODE=107,e.MEDIA_KEY_MESSAGE_NO_CHALLENGE_ERROR_CODE=108,e.SERVER_CERTIFICATE_UPDATED_ERROR_CODE=109,e.KEY_STATUS_CHANGED_EXPIRED_ERROR_CODE=110,e.MEDIA_KEY_MESSAGE_NO_LICENSE_SERVER_URL_ERROR_CODE=111,e.KEY_SYSTEM_ACCESS_DENIED_ERROR_CODE=112,e.KEY_SESSION_CREATED_ERROR_CODE=113,e.MEDIA_KEY_MESSAGE_LICENSER_ERROR_CODE=114,e.MEDIA_KEYERR_UNKNOWN_MESSAGE="An unspecified error occurred. This value is used for errors that don\'t match any of the other codes.",e.MEDIA_KEYERR_CLIENT_MESSAGE="The Key System could not be installed or updated.",e.MEDIA_KEYERR_SERVICE_MESSAGE="The message passed into update indicated an error from the license service.",e.MEDIA_KEYERR_OUTPUT_MESSAGE="There is no available output device with the required characteristics for the content protection system.",e.MEDIA_KEYERR_HARDWARECHANGE_MESSAGE="A hardware configuration change caused a content protection error.",e.MEDIA_KEYERR_DOMAIN_MESSAGE="An error occurred in a multi-device domain licensing configuration. The most common error is a failure to join the domain.",e.MEDIA_KEY_MESSAGE_ERROR_MESSAGE="Multiple key sessions were creates with a user-agent that does not support sessionIDs!! Unpredictable behavior ahead!",e.MEDIA_KEY_MESSAGE_NO_CHALLENGE_ERROR_MESSAGE="DRM: Empty key message from CDM",e.SERVER_CERTIFICATE_UPDATED_ERROR_MESSAGE="Error updating server certificate -- ",e.KEY_STATUS_CHANGED_EXPIRED_ERROR_MESSAGE="DRM: KeyStatusChange error! -- License has expired",e.MEDIA_KEY_MESSAGE_NO_LICENSE_SERVER_URL_ERROR_MESSAGE="DRM: No license server URL specified!",e.KEY_SYSTEM_ACCESS_DENIED_ERROR_MESSAGE="DRM: KeySystem Access Denied! -- ",e.KEY_SESSION_CREATED_ERROR_MESSAGE="DRM: unable to create session! --",e.MEDIA_KEY_MESSAGE_LICENSER_ERROR_MESSAGE="DRM: licenser error! --",e}return i}(n(2230).Z)),g=n(5459),h=function e(t,n,r,i,a,o,s,u){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.url=t,this.method=n,this.responseType=r,this.headers=i,this.withCredentials=a,this.messageType=o,this.sessionId=s,this.data=u},p=function e(t,n,r){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.url=t,this.headers=n,this.data=r},m=n(7855),y=n(703),E=n(3393),v=n(5448);function _(e){return _="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},_(e)}function T(e){var t,n,r,i,u,l,c,f,v,T,S,b=(e=e||{}).protectionKeyController,A=e.protectionModel,I=e.eventBus,R=e.events,w=e.debug,N=e.BASE64,C=e.constants,D=[],O=e.cmcdModel,M=e.settings,P=e.customParametersModel;function L(){if(!(I&&I.hasOwnProperty("on")&&b&&b.hasOwnProperty("getSupportedKeySystemsFromContentProtection")))throw new Error("Missing config parameter(s)")}function x(e,t){f||v?f&&F():function(e,t){if(!v){v=!0;var r,i=[];e=e.sort((function(t,n){return(u&&u[t.ks.systemString]&&u[t.ks.systemString].priority>=0?u[t.ks.systemString].priority:e.length)-(u&&u[n.ks.systemString]&&u[n.ks.systemString].priority>=0?u[n.ks.systemString].priority:e.length)}));for(var a=0;a<e.length;a++){var o=Y(e[a]);i.push({ks:e[a].ks,configs:[o],protData:e[a].protData})}A.requestKeySystemAccess(i).then((function(e){var t=(r=e.data).mksa&&r.mksa.selectedSystemString?r.mksa.selectedSystemString:r.keySystem.systemString;return n.info("DRM: KeySystem Access Granted for system string ("+t+")!  Selecting key system..."),A.selectKeySystem(r)})).then((function(e){if(f=e,v=!1,A){I.trigger(R.KEY_SYSTEM_SELECTED,{data:r});var t=B(f);t&&t.serverCertificate&&t.serverCertificate.length>0&&A.setServerCertificate(N.decodeArray(t.serverCertificate).buffer),F()}})).catch((function(e){f=null,v=!1,t||I.trigger(R.KEY_SYSTEM_SELECTED,{data:null,error:new g.Z(d.KEY_SYSTEM_ACCESS_DENIED_ERROR_CODE,d.KEY_SYSTEM_ACCESS_DENIED_ERROR_MESSAGE+"Error selecting key system! -- "+e.error)})}))}}(e,t)}function F(){for(var e,t=0;t<r.length;t++)for(e=0;e<r[t].length;e++)if(f===r[t][e].ks){k(r[t][e]);break}r=[]}function k(e){if(b.isClearKey(f)&&e.protData&&e.protData.hasOwnProperty("clearkeys")&&0!==Object.keys(e.protData.clearkeys).length){var t={kids:Object.keys(e.protData.clearkeys)};e.initData=(new TextEncoder).encode(JSON.stringify(t))}e.sessionId?U(e):null!==e.initData&&Z(e)}function U(e){L(),A.loadKeySession(e)}function Z(e){var t=a.getPSSHForKeySystem(f,e?e.initData:null);if(t){if(function(e){if(!e)return!1;try{for(var t=A.getSessions(),n=0;n<t.length;n++)if(t[n].getKeyId()===e)return!0;return!1}catch(e){return!1}}(e.keyId))return;if(G(t))return;try{e.initData=t,A.createKeySession(e)}catch(e){I.trigger(R.KEY_SESSION_CREATED,{data:null,error:new g.Z(d.KEY_SESSION_CREATED_ERROR_CODE,d.KEY_SESSION_CREATED_ERROR_MESSAGE+e.message)})}}else e&&e.initData?A.createKeySession(e):I.trigger(R.KEY_SESSION_CREATED,{data:null,error:new g.Z(d.KEY_SESSION_CREATED_ERROR_CODE,d.KEY_SESSION_CREATED_ERROR_MESSAGE+"Selected key system is "+(f?f.systemString:null)+".  needkey/encrypted event contains no initData corresponding to that key system!")})}function B(e){if(e){var t=e.systemString;if(u)return t in u?u[t]:null}return null}function G(e){if(!e)return!1;try{for(var t=A.getAllInitData(),r=0;r<t.length;r++)if(b.initDataEquals(e,t[r]))return n.debug("DRM: Ignoring initData because we have already seen it!"),!0;return!1}catch(e){return!1}}function q(e){L(),e?(A.setMediaElement(e),I.on(R.NEED_KEY,J,t)):null===e&&(A.setMediaElement(e),I.off(R.NEED_KEY,J,t))}function Y(e){var t=e.protData,n=[],r=[],a=t&&t.audioRobustness&&t.audioRobustness.length>0?t.audioRobustness:c,u=t&&t.videoRobustness&&t.videoRobustness.length>0?t.videoRobustness:c,l=e.sessionType,f=t&&t.distinctiveIdentifier?t.distinctiveIdentifier:"optional",d=t&&t.persistentState?t.persistentState:"temporary"===l?"optional":"required";return i.forEach((function(e){e.type===C.AUDIO?n.push(new o(e.codec,a)):e.type===C.VIDEO&&r.push(new o(e.codec,u))})),new s(n,r,f,d,[l])}function j(e){e.error?I.trigger(R.KEY_STATUSES_CHANGED,{data:null,error:e.error}):n.debug("DRM: key status = "+e.status)}function H(e){n.debug("DRM: onKeyMessage");var t=e.data;I.trigger(R.KEY_MESSAGE,{data:t});var r=t.messageType?t.messageType:"license-request",o=t.message,s=t.sessionToken,u=B(f),l=b.getLicenseServerModelInstance(f,u,r),c={sessionToken:s,messageType:r};if(o&&0!==o.byteLength){if(!l)return n.debug("DRM: License server request not required for this message (type = "+e.data.messageType+").  Session ID = "+s.getSessionId()),void V(c);if(b.isClearKey(f)){var E=b.processClearKeyLicenseRequest(f,u,o);if(E&&E.keyPairs&&E.keyPairs.length>0)return n.debug("DRM: ClearKey license request handled by application!"),V(c),void A.updateKeySession(s,E)}!function(e,t,n){var r=e.sessionToken,o=e.messageType?e.messageType:"license-request",s={sessionToken:r,messageType:o},u=f?f.systemString:null,l=function(e,t,n,r,o){var s=null,u=r.message;if(e&&e.serverURL){var l=e.serverURL;"string"==typeof l&&""!==l?s=l:"object"===_(l)&&l.hasOwnProperty(t)&&(s=l[t])}else if(e&&e.laURL&&""!==e.laURL)s=e.laURL;else if(!(s=a.getLicenseServerUrlFromMediaInfo(i,f.schemeIdURI))&&!b.isClearKey(f)){var c=a.getPSSHData(n.initData);(s=f.getLicenseServerURLFromInitData(c))||(s=r.laURL)}return s=o.getServerURLFromMessage(s,u,t)}(n,o,r,e,t);if(l){var c={},E=!1;n&&W(c,n.httpRequestHeaders);var v=e.message;W(c,f.getRequestHeadersFromMessage(v)),Object.keys(c).forEach((function(e){"authorization"===e.toLowerCase()&&(E=!0)})),n&&"boolean"==typeof n.withCredentials&&(E=n.withCredentials);var T=function(e){if(A)if(e.status>=200&&e.status<=299){var n=y.Z.parseHttpHeaders(e.getAllResponseHeaders?e.getAllResponseHeaders():null),i=new p(e.responseURL,n,e.response);Q(P.getLicenseResponseFilters(),i).then((function(){var n=t.getLicenseMessage(i.data,u,o);null!==n?(V(s),A.updateKeySession(r,n)):X(e,s,u,o,t)}))}else X(e,s,u,o,t)},S=function(e){V(s,new g.Z(d.MEDIA_KEY_MESSAGE_LICENSER_ERROR_CODE,d.MEDIA_KEY_MESSAGE_LICENSER_ERROR_MESSAGE+u+\' update, XHR aborted. status is "\'+e.statusText+\'" (\'+e.status+"), readyState is "+e.readyState))},I=function(e){V(s,new g.Z(d.MEDIA_KEY_MESSAGE_LICENSER_ERROR_CODE,d.MEDIA_KEY_MESSAGE_LICENSER_ERROR_MESSAGE+u+\' update, XHR error. status is "\'+e.statusText+\'" (\'+e.status+"), readyState is "+e.readyState))},R=f.getLicenseRequestFromMessage(v),w=t.getHTTPMethod(o),N=t.getResponseType(u,o),C=n&&!isNaN(n.httpTimeout)?n.httpTimeout:8e3,D=r.getSessionId()||null,O=new h(l,w,N,c,E,o,D,R),L=isNaN(M.get().streaming.retryAttempts[m.w.LICENSE])?3:M.get().streaming.retryAttempts[m.w.LICENSE];Q(P.getLicenseRequestFilters(),O).then((function(){K(O,L,C,T,S,I)}))}else V(s,new g.Z(d.MEDIA_KEY_MESSAGE_NO_LICENSE_SERVER_URL_ERROR_CODE,d.MEDIA_KEY_MESSAGE_NO_LICENSE_SERVER_URL_ERROR_MESSAGE))}(t,l,u)}else V(c,new g.Z(d.MEDIA_KEY_MESSAGE_NO_CHALLENGE_ERROR_CODE,d.MEDIA_KEY_MESSAGE_NO_CHALLENGE_ERROR_MESSAGE))}function V(e,t){I.trigger(R.LICENSE_REQUEST_COMPLETE,{data:e,error:t})}function K(e,t,r,i,a,o){var s=new XMLHttpRequest;if(M.get().streaming.cmcd&&M.get().streaming.cmcd.enabled&&M.get().streaming.cmcd.mode===E.Z.CMCD_MODE_QUERY){var u=O.getQueryParameter({url:e.url,type:m.w.LICENSE});u&&(e.url=y.Z.addAditionalQueryParameterToUrl(e.url,[u]))}for(var l in s.open(e.method,e.url,!0),s.responseType=e.responseType,s.withCredentials=e.withCredentials,r>0&&(s.timeout=r),e.headers)s.setRequestHeader(l,e.headers[l]);if(M.get().streaming.cmcd&&M.get().streaming.cmcd.enabled&&M.get().streaming.cmcd.mode===E.Z.CMCD_MODE_HEADER){var c=O.getHeaderParameters({url:e.url,type:m.w.LICENSE});if(c)for(var f in c){var d=c[f];d&&s.setRequestHeader(f,d)}}var g=function(){t--;var n=isNaN(M.get().streaming.retryIntervals[m.w.LICENSE])?1e3:M.get().streaming.retryIntervals[m.w.LICENSE];S=setTimeout((function(){K(e,t,r,i,a,o)}),n)};s.onload=function(){T=null,this.status>=200&&this.status<=299||t<=0?i(this):(n.warn("License request failed ("+this.status+"). Retrying it... Pending retries: "+t),g())},s.ontimeout=s.onerror=function(){T=null,t<=0?o(this):(n.warn("License request network request failed . Retrying it... Pending retries: "+t),g())},s.onabort=function(){a(this)},I.trigger(R.LICENSE_REQUEST_SENDING,{url:e.url,headers:e.headers,payload:e.data,sessionId:e.sessionId}),T=s,s.send(e.data)}function z(){T&&(T.onloadend=T.onerror=T.onprogress=void 0,T.abort(),T=null),S&&(clearTimeout(S),S=null)}function W(e,t){if(t)for(var n in t)e[n]=t[n]}function X(e,t,n,r,i){var a="NONE",o=null;e.response&&(a=i.getErrorResponse(e.response,n,r),o={serverResponse:e.response||null,responseCode:e.status||null,responseText:e.statusText||null}),V(t,new g.Z(d.MEDIA_KEY_MESSAGE_LICENSER_ERROR_CODE,d.MEDIA_KEY_MESSAGE_LICENSER_ERROR_MESSAGE+n+\' update, XHR complete. status is "\'+e.statusText+\'" (\'+e.status+"), readyState is "+e.readyState+".  Response is "+a,o))}function Q(e,t){return e?e.reduce((function(e,n){return e.then((function(){return n(t)}))}),Promise.resolve()):Promise.resolve()}function J(e,t){if(!M.get().streaming.protection.ignoreEmeEncryptedEvent){if(n.debug("DRM: onNeedKey"),"cenc"!==e.key.initDataType)return void n.warn("DRM:  Only \'cenc\' initData is supported!  Ignoring initData of type: "+e.key.initDataType);if(0===i.length&&(n.warn("DRM: onNeedKey called before initializeForMedia, wait until initialized"),(t=void 0===t?1:t+1)<5))return void D.push(setTimeout((function(){J(e,t)}),500));var o=e.key.initData;if(ArrayBuffer.isView(o)&&(o=o.buffer),f){var s=a.getPSSHForKeySystem(f,o);if(s&&G(s))return}n.debug("DRM: initData:",String.fromCharCode.apply(null,new Uint8Array(o)));var c=b.getSupportedKeySystemsFromSegmentPssh(o,u,l);if(0===c.length)return void n.debug("DRM: Received needkey event with initData, but we don\'t support any of the key systems!");!function(e){r.push(e),x(e,!1)}(c)}}return t={initializeForMedia:function(e){if(!e)throw new Error("mediaInfo can not be null or undefined");L(),i.push(e)},clearMediaInfoArray:function(){i=[]},handleKeySystemFromManifest:function(){if(i&&0!==i.length){var e=[];i.forEach((function(t){var n=b.getSupportedKeySystemsFromContentProtection(t.contentProtection,u,l);n.length>0&&(0===e.length&&(e=n),r.push(n))})),e&&e.length>0&&x(e,!0)}},createKeySession:Z,loadKeySession:U,removeKeySession:function(e){L(),A.removeKeySession(e)},closeKeySession:function(e){L(),A.closeKeySession(e)},setServerCertificate:function(e){L(),A.setServerCertificate(e)},setMediaElement:q,setSessionType:function(e){l=e},setRobustnessLevel:function(e){c=e},setProtectionData:function(e){u=e,b.setProtectionData(e)},getSupportedKeySystemsFromContentProtection:function(e){return L(),b.getSupportedKeySystemsFromContentProtection(e,u,l)},getKeySystems:function(){return b?b.getKeySystems():[]},setKeySystems:function(e){b&&b.setKeySystems(e)},stop:function(){z(),A&&A.stop()},reset:function(){I.off(R.INTERNAL_KEY_MESSAGE,H,t),I.off(R.INTERNAL_KEY_STATUS_CHANGED,j,t),L(),z(),q(null),f=null,v=!1,A&&(A.reset(),A=null),D.forEach((function(e){return clearTimeout(e)})),D=[],i=[],r=[]}},n=w.getLogger(t),r=[],i=[],l="temporary",c="",T=null,S=null,I.on(R.INTERNAL_KEY_MESSAGE,H,t),I.on(R.INTERNAL_KEY_STATUS_CHANGED,j,t),t}T.__dashjs_factory_name="ProtectionController";var S=v.Z.getClassFactory(T),b=function e(t,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.keyID=t,this.key=n};function A(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var I=function(){function e(t,n){if(function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),n&&"persistent"!==n&&"temporary"!==n)throw new Error("Invalid ClearKey key set type!  Must be one of \'persistent\' or \'temporary\'");this.keyPairs=t,this.type=n}var t,n;return t=e,(n=[{key:"toJWK",value:function(){var e,t=this.keyPairs.length,n={keys:[]};for(e=0;e<t;e++){var r={kty:"oct",alg:"A128KW",kid:this.keyPairs[e].keyID,k:this.keyPairs[e].key};n.keys.push(r)}this.type&&(n.type=this.type);var i=JSON.stringify(n),a=i.length,o=new ArrayBuffer(a),s=new Uint8Array(o);for(e=0;e<a;e++)s[e]=i.charCodeAt(e);return o}}])&&A(t.prototype,n),e}();function R(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var w=new(function(){function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.init()}var t,n;return t=e,(n=[{key:"init",value:function(){this.CLEARKEY_KEYSTEM_STRING="org.w3.clearkey",this.WIDEVINE_KEYSTEM_STRING="com.widevine.alpha",this.PLAYREADY_KEYSTEM_STRING="com.microsoft.playready",this.PLAYREADY_RECOMMENDATION_KEYSTEM_STRING="com.microsoft.playready.recommendation",this.INITIALIZATION_DATA_TYPE_CENC="cenc",this.INITIALIZATION_DATA_TYPE_KEYIDS="keyids",this.INITIALIZATION_DATA_TYPE_WEBM="webm"}}])&&R(t.prototype,n),e}()),N="e2719d58-a985-b3c9-781a-b030af78d30e",C=w.CLEARKEY_KEYSTEM_STRING,D="urn:uuid:"+N;function O(e){var t=(e=e||{}).BASE64;return{uuid:N,schemeIdURI:D,systemString:C,getInitData:function(e,n){try{var r=a.parseInitDataFromContentProtection(e,t);if(!r&&n){var i={kids:[function(e){try{var t=e.replace(/-/g,"");return(t=btoa(t.match(/\\w{2}/g).map((function(e){return String.fromCharCode(parseInt(e,16))})).join(""))).replace(/=/g,"").replace(/\\//g,"_").replace(/\\+/g,"-")}catch(e){return null}}(n["cenc:default_KID"])]};r=(new TextEncoder).encode(JSON.stringify(i))}return r}catch(e){return null}},getRequestHeadersFromMessage:function(){return{"Content-Type":"application/json"}},getLicenseRequestFromMessage:function(e){return JSON.stringify(JSON.parse(String.fromCharCode.apply(null,new Uint8Array(e))))},getLicenseServerURLFromInitData:function(){return null},getCDMData:function(){return null},getClearKeysFromProtectionData:function(e,t){var n=null;if(e){for(var r=JSON.parse(String.fromCharCode.apply(null,new Uint8Array(t))),i=[],a=0;a<r.kids.length;a++){var o=r.kids[a],s=e.clearkeys&&e.clearkeys.hasOwnProperty(o)?e.clearkeys[o]:null;if(!s)throw new Error("DRM: ClearKey keyID ("+o+") is not known!");i.push(new b(o,s))}n=new I(i)}return n}}}O.__dashjs_factory_name="KeySystemClearKey";var M=dashjs.FactoryMaker.getSingletonFactory(O),P="1077efec-c0b2-4d02-ace3-3c1e52e2fb4b",L=w.CLEARKEY_KEYSTEM_STRING,x="urn:uuid:"+P;function F(e){var t,n=e.BASE64,r=e.debug.getLogger(t);return{uuid:P,schemeIdURI:x,systemString:L,getInitData:function(e){return a.parseInitDataFromContentProtection(e,n)},getRequestHeadersFromMessage:function(){return null},getLicenseRequestFromMessage:function(e){return new Uint8Array(e)},getLicenseServerURLFromInitData:function(){return null},getCDMData:function(){return null},getClearKeysFromProtectionData:function(e,t){var n=null;if(e){for(var i=JSON.parse(String.fromCharCode.apply(null,new Uint8Array(t))),a=[],o=0;o<i.kids.length;o++){var s=i.kids[o],u=e.clearkeys&&e.clearkeys.hasOwnProperty(s)?e.clearkeys[s]:null;if(!u)throw new Error("DRM: ClearKey keyID ("+s+") is not known!");a.push(new b(s,u))}n=new I(a),r.warn("ClearKey schemeIdURI is using W3C Common PSSH systemID (1077efec-c0b2-4d02-ace3-3c1e52e2fb4b) in Content Protection. See DASH-IF IOP v4.1 section 7.6.2.4")}return n}}}F.__dashjs_factory_name="KeySystemW3CClearKey";var k=dashjs.FactoryMaker.getSingletonFactory(F),U="edef8ba9-79d6-4ace-a3c8-27dcd51d21ed",Z=w.WIDEVINE_KEYSTEM_STRING,B="urn:uuid:"+U;function G(e){var t=(e=e||{}).BASE64;return{uuid:U,schemeIdURI:B,systemString:Z,getInitData:function(e){return a.parseInitDataFromContentProtection(e,t)},getRequestHeadersFromMessage:function(){return null},getLicenseRequestFromMessage:function(e){return new Uint8Array(e)},getLicenseServerURLFromInitData:function(){return null},getCDMData:function(){return null}}}G.__dashjs_factory_name="KeySystemWidevine";var q=dashjs.FactoryMaker.getSingletonFactory(G),Y="9a04f079-9840-4286-ab92-e65be0885f95",j=w.PLAYREADY_KEYSTEM_STRING,H="urn:uuid:"+Y;function V(e){var t="utf-16",n=(e=e||{}).BASE64,r=e.settings;function i(){if(!n||!n.hasOwnProperty("decodeArray")||!n.hasOwnProperty("decodeArray"))throw new Error("Missing config parameter(s)")}return{uuid:Y,schemeIdURI:H,systemString:j,getInitData:function(e){var t,r,o,s,u,l=new Uint8Array([112,115,115,104,0,0,0,0]),c=new Uint8Array([154,4,240,121,152,64,66,134,171,146,230,91,224,136,95,149]),f=0,d=null;if(i(),!e)return null;if("pssh"in e)return a.parseInitDataFromContentProtection(e,n);if("pro"in e)d=n.decodeArray(e.pro.__text);else{if(!("prheader"in e))return null;d=n.decodeArray(e.prheader.__text)}return t=d.length,r=4+l.length+c.length+4+t,o=new ArrayBuffer(r),s=new Uint8Array(o),(u=new DataView(o)).setUint32(f,r),f+=4,s.set(l,f),f+=l.length,s.set(c,f),f+=c.length,u.setUint32(f,t),f+=4,s.set(d,f),f+=t,s.buffer},getRequestHeadersFromMessage:function(e){var n,i,a={},o=new DOMParser;if(r&&r.get().streaming.protection.detectPlayreadyMessageFormat&&"utf-16"===t&&e&&e.byteLength%2==1)return a["Content-Type"]="text/xml; charset=utf-8",a;var s="utf-16"===t?new Uint16Array(e):new Uint8Array(e);n=String.fromCharCode.apply(null,s);for(var u=(i=o.parseFromString(n,"application/xml")).getElementsByTagName("name"),l=i.getElementsByTagName("value"),c=0;c<u.length;c++)a[u[c].childNodes[0].nodeValue]=l[c].childNodes[0].nodeValue;return a.hasOwnProperty("Content")&&(a["Content-Type"]=a.Content,delete a.Content),a.hasOwnProperty("Content-Type")||(a["Content-Type"]="text/xml; charset=utf-8"),a},getLicenseRequestFromMessage:function(e){var a=null,o=new DOMParser;if(r&&r.get().streaming.protection.detectPlayreadyMessageFormat&&"utf-16"===t&&e&&e.byteLength%2==1)return e;var s="utf-16"===t?new Uint16Array(e):new Uint8Array(e);i();var u=String.fromCharCode.apply(null,s),l=o.parseFromString(u,"application/xml");if(!l.getElementsByTagName("PlayReadyKeyMessage")[0])return e;var c=l.getElementsByTagName("Challenge")[0].childNodes[0].nodeValue;return c&&(a=n.decode(c)),a},getLicenseServerURLFromInitData:function(e){if(e)for(var t=new DataView(e),n=t.getUint16(4,!0),r=6,i=new DOMParser,a=0;a<n;a++){var o=t.getUint16(r,!0);r+=2;var s=t.getUint16(r,!0);if(r+=2,1===o){var u=e.slice(r,r+s),l=String.fromCharCode.apply(null,new Uint16Array(u)),c=i.parseFromString(l,"application/xml");if(c.getElementsByTagName("LA_URL")[0]){var f=c.getElementsByTagName("LA_URL")[0].childNodes[0].nodeValue;if(f)return f}if(c.getElementsByTagName("LUI_URL")[0]){var d=c.getElementsByTagName("LUI_URL")[0].childNodes[0].nodeValue;if(d)return d}}else r+=s}return null},getCDMData:function(e){var t,r,a,o;if(i(),!e)return null;for(t=[],o=0;o<e.length;++o)t.push(e.charCodeAt(o)),t.push(0);for(t=String.fromCharCode.apply(null,t),t=n.encode(t),r=\'<PlayReadyCDMData type="LicenseAcquisition"><LicenseAcquisition version="1.0" Proactive="false"><CustomData encoding="base64encoded">%CUSTOMDATA%</CustomData></LicenseAcquisition></PlayReadyCDMData>\'.replace("%CUSTOMDATA%",t),a=[],o=0;o<r.length;++o)a.push(r.charCodeAt(o)),a.push(0);return new Uint8Array(a).buffer},setPlayReadyMessageFormat:function(e){if("utf-8"!==e&&"utf-16"!==e)throw new Error(\'Specified message format is not one of "utf-8" or "utf-16"\');t=e}}}V.__dashjs_factory_name="KeySystemPlayReady";var K=dashjs.FactoryMaker.getSingletonFactory(V);function z(e){var t=(e=e||{}).BASE64,n={};return n[w.WIDEVINE_KEYSTEM_STRING]={responseType:"json",getLicenseMessage:function(e){return t.decodeArray(e.license)},getErrorResponse:function(e){return e}},n[w.PLAYREADY_KEYSTEM_STRING]={responseType:"arraybuffer",getLicenseMessage:function(e){return e},getErrorResponse:function(e){return String.fromCharCode.apply(null,new Uint8Array(e))}},{getServerURLFromMessage:function(e){return e},getHTTPMethod:function(){return"POST"},getResponseType:function(e){return n[e].responseType},getLicenseMessage:function(e,r){return function(){if(!t||!t.hasOwnProperty("decodeArray"))throw new Error("Missing config parameter(s)")}(),n[r].getLicenseMessage(e)},getErrorResponse:function(e,t){return n[t].getErrorResponse(e)}}}z.__dashjs_factory_name="DRMToday";var W=dashjs.FactoryMaker.getSingletonFactory(z);function X(){var e="http://schemas.xmlsoap.org/soap/envelope/";function t(e){var t=String.fromCharCode.apply(null,new Uint8Array(e));return decodeURIComponent(escape(t))}function n(n){if(window.DOMParser){var r=t(n),i=(new window.DOMParser).parseFromString(r,"text/xml"),a=i?i.getElementsByTagNameNS(e,"Envelope")[0]:null,o=a?a.getElementsByTagNameNS(e,"Body")[0]:null;if(o&&o.getElementsByTagNameNS(e,"Fault")[0])return null}return n}function r(n){var r="",i="",a="",o=-1,s=-1;if(window.DOMParser){var u=t(n),l=(new window.DOMParser).parseFromString(u,"text/xml"),c=l?l.getElementsByTagNameNS(e,"Envelope")[0]:null,f=c?c.getElementsByTagNameNS(e,"Body")[0]:null,d=f?f.getElementsByTagNameNS(e,"Fault")[0]:null,g=d?d.getElementsByTagName("detail")[0]:null,h=g?g.getElementsByTagName("Exception")[0]:null,p=null;if(null===d)return u;r=(p=d.getElementsByTagName("faultstring")[0].firstChild)?p.nodeValue:null,null!==h&&(i=(p=h.getElementsByTagName("StatusCode")[0])?p.firstChild.nodeValue:null,o=(a=(p=h.getElementsByTagName("Message")[0])?p.firstChild.nodeValue:null)?a.lastIndexOf("[")+1:-1,s=a?a.indexOf("]"):-1,a=a?a.substring(o,s):"")}var m="code: ".concat(i,", name: ").concat(r);return a&&(m+=", message: ".concat(a)),m}return{getServerURLFromMessage:function(e){return e},getHTTPMethod:function(){return"POST"},getResponseType:function(){return"arraybuffer"},getLicenseMessage:function(e){return n.call(this,e)},getErrorResponse:function(e){return r.call(this,e)}}}X.__dashjs_factory_name="PlayReady";var Q=v.Z.getSingletonFactory(X);function J(){return{getServerURLFromMessage:function(e){return e},getHTTPMethod:function(){return"POST"},getResponseType:function(){return"arraybuffer"},getLicenseMessage:function(e){return e},getErrorResponse:function(e){return String.fromCharCode.apply(null,new Uint8Array(e))}}}J.__dashjs_factory_name="Widevine";var $=dashjs.FactoryMaker.getSingletonFactory(J);function ee(){return{getServerURLFromMessage:function(e){return e},getHTTPMethod:function(){return"POST"},getResponseType:function(){return"json"},getLicenseMessage:function(e){if(!e.hasOwnProperty("keys"))return null;for(var t=[],n=0;n<e.keys.length;n++){var r=e.keys[n],i=r.kid.replace(/=/g,""),a=r.k.replace(/=/g,"");t.push(new b(i,a))}return new I(t)},getErrorResponse:function(e){return String.fromCharCode.apply(null,new Uint8Array(e))}}}ee.__dashjs_factory_name="ClearKey";var te=dashjs.FactoryMaker.getSingletonFactory(ee);function ne(){var e,t,n,r,i,o,s,u,l=this.context;function c(e,t){return t&&e in t?t[e]:null}function f(e,t){return e&&e.sessionId?e.sessionId:t&&t.sessionId?t.sessionId:null}function d(e,t){return e&&e.sessionType?e.sessionType:t}return e={initialize:function(){var e;r=[],e=K(l).getInstance({BASE64:i,settings:o}),r.push(e),e=q(l).getInstance({BASE64:i}),r.push(e),e=M(l).getInstance({BASE64:i}),r.push(e),s=e,e=k(l).getInstance({BASE64:i,debug:t}),r.push(e),u=e},setProtectionData:function(e){for(var t,n,i=0;i<r.length;i++){var a=r[i];a.hasOwnProperty("init")&&a.init((t=a.systemString,n=void 0,n=null,e&&(n=t in e?e[t]:null),n))}},isClearKey:function(e){return e===s||e===u},initDataEquals:function(e,t){if(e.byteLength===t.byteLength){for(var n=new Uint8Array(e),r=new Uint8Array(t),i=0;i<n.length;i++)if(n[i]!==r[i])return!1;return!0}return!1},getKeySystems:function(){return r},setKeySystems:function(e){r=e},getKeySystemBySystemString:function(e){for(var t=0;t<r.length;t++)if(r[t].systemString===e)return r[t];return null},getSupportedKeySystemsFromContentProtection:function(e,t,n){var i,o,s,u,l=[];if(e){var g=a.findCencContentProtection(e);for(s=0;s<r.length;++s){var h=c((o=r[s]).systemString,t);for(u=0;u<e.length;++u)if((i=e[u]).schemeIdUri.toLowerCase()===o.schemeIdURI){var p=o.getInitData(i,g);l.push({ks:r[s],keyId:i.keyId,initData:p,protData:h,cdmData:o.getCDMData(h?h.cdmData:null),sessionId:f(h,i),sessionType:d(h,n)})}}}return l},getSupportedKeySystemsFromSegmentPssh:function(e,t,n){for(var i,o=[],s=a.parsePSSHList(e),u=0;u<r.length;++u){var l=c((i=r[u]).systemString,t);i.uuid in s&&o.push({ks:i,initData:s[i.uuid],protData:l,cdmData:i.getCDMData(l?l.cdmData:null),sessionId:f(l),sessionType:d(l,n)})}return o},getLicenseServerModelInstance:function(e,t,n){if("license-release"===n||"individualization-request"===n)return null;var r=null;return t&&t.hasOwnProperty("drmtoday")?r=W(l).getInstance({BASE64:i}):e.systemString===w.WIDEVINE_KEYSTEM_STRING?r=$(l).getInstance():e.systemString===w.PLAYREADY_KEYSTEM_STRING?r=Q(l).getInstance():e.systemString===w.CLEARKEY_KEYSTEM_STRING&&(r=te(l).getInstance()),r},processClearKeyLicenseRequest:function(e,t,r){try{return e.getClearKeysFromProtectionData(t,r)}catch(e){return n.error("Failed to retrieve clearkeys from ProtectionData"),null}},setConfig:function(r){r&&(r.debug&&(t=r.debug,n=t.getLogger(e)),r.BASE64&&(i=r.BASE64),r.settings&&(o=r.settings))}},e}ne.__dashjs_factory_name="ProtectionKeyController";var re=dashjs.FactoryMaker.getSingletonFactory(ne);function ie(e){return ie="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},ie(e)}function ae(e,t){return ae=Object.setPrototypeOf||function(e,t){return e.__proto__=t,e},ae(e,t)}function oe(e,t){return!t||"object"!==ie(t)&&"function"!=typeof t?function(e){if(void 0===e)throw new ReferenceError("this hasn\'t been initialised - super() hasn\'t been called");return e}(e):t}function se(e){return se=Object.setPrototypeOf?Object.getPrototypeOf:function(e){return e.__proto__||Object.getPrototypeOf(e)},se(e)}var ue=new(function(e){!function(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),t&&ae(e,t)}(i,e);var t,n,r=(t=i,n=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(e){return!1}}(),function(){var e,r=se(t);if(n){var i=se(this).constructor;e=Reflect.construct(r,arguments,i)}else e=r.apply(this,arguments);return oe(this,e)});function i(){var e;return function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,i),(e=r.call(this)).INTERNAL_KEY_MESSAGE="internalKeyMessage",e.INTERNAL_KEY_STATUS_CHANGED="internalkeyStatusChanged",e.KEY_ADDED="public_keyAdded",e.KEY_ERROR="public_keyError",e.KEY_MESSAGE="public_keyMessage",e.KEY_SESSION_CLOSED="public_keySessionClosed",e.KEY_SESSION_CREATED="public_keySessionCreated",e.KEY_SESSION_REMOVED="public_keySessionRemoved",e.KEY_STATUSES_CHANGED="public_keyStatusesChanged",e.KEY_SYSTEM_ACCESS_COMPLETE="public_keySystemAccessComplete",e.KEY_SYSTEM_SELECTED="public_keySystemSelected",e.LICENSE_REQUEST_COMPLETE="public_licenseRequestComplete",e.LICENSE_REQUEST_SENDING="public_licenseRequestSending",e.NEED_KEY="needkey",e.PROTECTION_CREATED="public_protectioncreated",e.PROTECTION_DESTROYED="public_protectiondestroyed",e.SERVER_CERTIFICATE_UPDATED="serverCertificateUpdated",e.TEARDOWN_COMPLETE="protectionTeardownComplete",e.VIDEO_ELEMENT_SELECTED="videoElementSelected",e.KEY_SESSION_UPDATED="public_keySessionUpdated",e}return i}(n(8342).Z)),le=function e(t,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.initData=t,this.initDataType=n},ce=function e(t,n,r,i){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.sessionToken=t,this.message=n,this.defaultURL=r,this.messageType=i||"license-request"},fe=function e(t,n){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.keySystem=t,this.ksConfiguration=n},de={};function ge(e){e=e||{};var t,n,r,i,a,o,s,u,l=this.context,c=e.eventBus,f=e.events,h=e.debug;function p(e,t,n,r){if(void 0===navigator.requestMediaKeySystemAccess||"function"!=typeof navigator.requestMediaKeySystemAccess){var i="Insecure origins are not allowed";return c.trigger(f.KEY_SYSTEM_ACCESS_COMPLETE,{error:i}),void r({error:i})}var a=e[t].protData&&e[t].protData.systemStringPriority?e[t].protData.systemStringPriority:null,o=e[t].configs,s=e[t].ks,u=s.systemString;(function(e,t){return new Promise((function(n,r){m(e,t,0,n,r)}))})(a||(de[u]?de[u]:[u]),o).then((function(e){var t="function"==typeof e.getConfiguration?e.getConfiguration():null,r=new fe(s,t);r.mksa=e,c.trigger(f.KEY_SYSTEM_ACCESS_COMPLETE,{data:r}),n({data:r})})).catch((function(i){if(t+1<e.length)p(e,t+1,n,r);else{var a="Key system access denied! ";c.trigger(f.KEY_SYSTEM_ACCESS_COMPLETE,{error:a+i.message}),r({error:a+i.message})}}))}function m(e,t,r,i,a){var o=e[r];n.debug("Requesting key system access for system string ".concat(o)),navigator.requestMediaKeySystemAccess(o,t).then((function(e){e.selectedSystemString=o,i(e)})).catch((function(n){r+1<e.length?m(e,t,r+1,i,a):a(n)}))}function y(e){if(!e||!e.session)return Promise.resolve;var t=e.session;return t.removeEventListener("keystatuseschange",e),t.removeEventListener("message",e),t.close()}function E(e){for(var t=0;t<o.length;t++)if(o[t]===e){o.splice(t,1);break}}function v(e){var t,n;return e&&e.length>0&&(e[0]&&("string"==typeof e[0]?t=e[0]:n=e[0]),e[1]&&("string"==typeof e[1]?t=e[1]:n=e[1])),{status:t,keyId:n}}function _(e,t){var r={session:e,keyId:t.keyId,initData:t.initData,sessionId:t.sessionId,sessionType:t.sessionType,handleEvent:function(e){switch(e.type){case"keystatuseschange":c.trigger(f.KEY_STATUSES_CHANGED,{data:this}),e.target.keyStatuses.forEach((function(){var e=v(arguments);"expired"===e.status?c.trigger(f.INTERNAL_KEY_STATUS_CHANGED,{error:new g.Z(d.KEY_STATUS_CHANGED_EXPIRED_ERROR_CODE,d.KEY_STATUS_CHANGED_EXPIRED_ERROR_MESSAGE)}):c.trigger(f.INTERNAL_KEY_STATUS_CHANGED,e)}));break;case"message":var t=ArrayBuffer.isView(e.message)?e.message.buffer:e.message;c.trigger(f.INTERNAL_KEY_MESSAGE,{data:new ce(this,t,void 0,e.messageType)})}},getKeyId:function(){return this.keyId},getSessionId:function(){return e.sessionId},getSessionType:function(){return this.sessionType},getExpirationTime:function(){return e.expiration},getKeyStatuses:function(){return e.keyStatuses},getUsable:function(){var t=!1;return e.keyStatuses.forEach((function(){var e=v(arguments);"usable"===e.status&&(t=!0)})),t}};return e.addEventListener("keystatuseschange",r),e.addEventListener("message",r),e.closed.then((function(){E(r),n.debug("DRM: Session closed.  SessionID = "+r.getSessionId()),c.trigger(f.KEY_SESSION_CLOSED,{data:r.getSessionId()})})),o.push(r),r}return t={getAllInitData:function(){for(var e=[],t=0;t<o.length;t++)o[t].initData&&e.push(o[t].initData);return e},getSessions:function(){return o},requestKeySystemAccess:function(e){return new Promise((function(t,n){p(e,0,t,n)}))},selectKeySystem:function(e){return new Promise((function(t,n){e.mksa.createMediaKeys().then((function(t){return r=e.keySystem,a=t,i?i.setMediaKeys(a):Promise.resolve()})).then((function(){t(r)})).catch((function(){n({error:"Error selecting keys system ("+e.keySystem.systemString+")! Could not create MediaKeys -- TODO"})}))}))},setMediaElement:function(e){i!==e&&(i&&(i.removeEventListener("encrypted",s),i.setMediaKeys&&i.setMediaKeys(null)),(i=e)&&(i.addEventListener("encrypted",s),i.setMediaKeys&&a&&i.setMediaKeys(a)))},setServerCertificate:function(e){if(!r||!a)throw new Error("Can not set server certificate until you have selected a key system");a.setServerCertificate(e).then((function(){n.info("DRM: License server certificate successfully updated."),c.trigger(f.SERVER_CERTIFICATE_UPDATED)})).catch((function(e){c.trigger(f.SERVER_CERTIFICATE_UPDATED,{error:new g.Z(d.SERVER_CERTIFICATE_UPDATED_ERROR_CODE,d.SERVER_CERTIFICATE_UPDATED_ERROR_MESSAGE+e.name)})}))},createKeySession:function(e){if(!r||!a)throw new Error("Can not create sessions until you have selected a key system");var t=a.createSession(e.sessionType),i=_(t,e),o=r.systemString===w.CLEARKEY_KEYSTEM_STRING&&(e.initData||e.protData&&e.protData.clearkeys)?w.INITIALIZATION_DATA_TYPE_KEYIDS:w.INITIALIZATION_DATA_TYPE_CENC;t.generateRequest(o,e.initData).then((function(){n.debug("DRM: Session created.  SessionID = "+i.getSessionId()),c.trigger(f.KEY_SESSION_CREATED,{data:i})})).catch((function(e){E(i),c.trigger(f.KEY_SESSION_CREATED,{data:null,error:new g.Z(d.KEY_SESSION_CREATED_ERROR_CODE,d.KEY_SESSION_CREATED_ERROR_MESSAGE+"Error generating key request -- "+e.name)})}))},updateKeySession:function(e,t){var n=e.session;u.isClearKey(r)&&(t=t.toJWK()),n.update(t).then((function(){c.trigger(f.KEY_SESSION_UPDATED)})).catch((function(t){c.trigger(f.KEY_ERROR,{error:new g.Z(d.MEDIA_KEYERR_CODE,"Error sending update() message! "+t.name,e)})}))},loadKeySession:function(e){if(!r||!a)throw new Error("Can not load sessions until you have selected a key system");for(var t=e.sessionId,i=0;i<o.length;i++)if(t===o[i].sessionId)return void n.warn("DRM: Ignoring session ID because we have already seen it!");var s=a.createSession(e.sessionType),u=_(s,e);s.load(t).then((function(e){e?(n.debug("DRM: Session loaded.  SessionID = "+u.getSessionId()),c.trigger(f.KEY_SESSION_CREATED,{data:u})):(E(u),c.trigger(f.KEY_SESSION_CREATED,{data:null,error:new g.Z(d.KEY_SESSION_CREATED_ERROR_CODE,d.KEY_SESSION_CREATED_ERROR_MESSAGE+"Could not load session! Invalid Session ID ("+t+")")}))})).catch((function(e){E(u),c.trigger(f.KEY_SESSION_CREATED,{data:null,error:new g.Z(d.KEY_SESSION_CREATED_ERROR_CODE,d.KEY_SESSION_CREATED_ERROR_MESSAGE+"Could not load session ("+t+")! "+e.name)})}))},removeKeySession:function(e){e.session.remove().then((function(){n.debug("DRM: Session removed.  SessionID = "+e.getSessionId()),c.trigger(f.KEY_SESSION_REMOVED,{data:e.getSessionId()})}),(function(t){c.trigger(f.KEY_SESSION_REMOVED,{data:null,error:"Error removing session ("+e.getSessionId()+"). "+t.name})}))},closeKeySession:function(e){y(e).catch((function(t){E(e),c.trigger(f.KEY_SESSION_CLOSED,{data:null,error:"Error closing session ("+e.getSessionId()+") "+t.name})}))},stop:function(){for(var e,t=0;t<o.length;t++)(e=o[t]).getUsable()||(y(e),E(e))},reset:function(){var e,t=o.length;0!==t?function(){for(var n=function(e){E(e),0===o.length&&(i?(i.removeEventListener("encrypted",s),i.setMediaKeys(null).then((function(){c.trigger(f.TEARDOWN_COMPLETE)}))):c.trigger(f.TEARDOWN_COMPLETE))},r=0;r<t;r++)!function(t){y(e),n(t)}(e=o[r])}():c.trigger(f.TEARDOWN_COMPLETE)}},n=h.getLogger(t),r=null,i=null,a=null,o=[],u=re(l).getInstance(),s={handleEvent:function(e){if("encrypted"===e.type&&e.initData){var t=ArrayBuffer.isView(e.initData)?e.initData.buffer:e.initData;c.trigger(f.NEED_KEY,{key:new le(t,e.initDataType)})}}},t}de[w.PLAYREADY_KEYSTEM_STRING]=[w.PLAYREADY_KEYSTEM_STRING,w.PLAYREADY_RECOMMENDATION_KEYSTEM_STRING],de[w.WIDEVINE_KEYSTEM_STRING]=[w.WIDEVINE_KEYSTEM_STRING],de[w.CLEARKEY_KEYSTEM_STRING]=[w.CLEARKEY_KEYSTEM_STRING],ge.__dashjs_factory_name="ProtectionModel_21Jan2015";var he=dashjs.FactoryMaker.getClassFactory(ge);function pe(e){e=e||{};var t,n,r,i,a,o,u,l,c,f=this.context,h=e.eventBus,p=e.events,m=e.debug,y=e.api;function E(){try{for(var e=0;e<u.length;e++)v(u[e]);r&&r.removeEventListener(y.needkey,l),h.trigger(p.TEARDOWN_COMPLETE)}catch(e){h.trigger(p.TEARDOWN_COMPLETE,{error:"Error tearing down key sessions and MediaKeys! -- "+e.message})}}function v(e){var t=e.session;t.removeEventListener(y.error,e),t.removeEventListener(y.message,e),t.removeEventListener(y.ready,e),t.removeEventListener(y.close,e);for(var n=0;n<u.length;n++)if(u[n]===e){u.splice(n,1);break}t[y.release]()}function _(){var e=null,t=function(){r.removeEventListener("loadedmetadata",e),r[y.setMediaKeys](a),h.trigger(p.VIDEO_ELEMENT_SELECTED)};r.readyState>=1?t():(e=t.bind(this),r.addEventListener("loadedmetadata",e))}return t={getAllInitData:function(){for(var e=[],t=0;t<u.length;t++)e.push(u[t].initData);return e},getSessions:function(){return u},requestKeySystemAccess:function(e){return new Promise((function(t,n){for(var r=!1,i=0;i<e.length;i++)for(var a=e[i].ks.systemString,o=e[i].configs,u=null,l=null,f=0;f<o.length;f++){var d=o[f].audioCapabilities,g=o[f].videoCapabilities;if(d&&0!==d.length){u=[];for(var m=0;m<d.length;m++)window[y.MediaKeys].isTypeSupported(a,d[m].contentType)&&u.push(d[m])}if(g&&0!==g.length){l=[];for(var E=0;E<g.length;E++)window[y.MediaKeys].isTypeSupported(a,g[E].contentType)&&l.push(g[E])}if(!(!u&&!l||u&&0===u.length||l&&0===l.length)){r=!0;var v=new s(u,l),_=c.getKeySystemBySystemString(a),T=new fe(_,v);h.trigger(p.KEY_SYSTEM_ACCESS_COMPLETE,{data:T}),t({data:T});break}}if(!r){var S="Key system access denied! -- No valid audio/video content configurations detected!";h.trigger(p.KEY_SYSTEM_ACCESS_COMPLETE,{error:S}),n({error:S})}}))},selectKeySystem:function(e){return new Promise((function(t,n){try{a=e.mediaKeys=new window[y.MediaKeys](e.keySystem.systemString),i=e.keySystem,o=e,r&&_(),t(i)}catch(e){n({error:"Error selecting keys system ("+i.systemString+")! Could not create MediaKeys -- TODO"})}}))},setMediaElement:function(e){r!==e&&(r&&r.removeEventListener(y.needkey,l),(r=e)&&(r.addEventListener(y.needkey,l),a&&_()))},createKeySession:function(e){if(!i||!a||!o)throw new Error("Can not create sessions until you have selected a key system");var t=null;if(o.ksConfiguration.videoCapabilities&&o.ksConfiguration.videoCapabilities.length>0&&(t=o.ksConfiguration.videoCapabilities[0]),null===t&&o.ksConfiguration.audioCapabilities&&o.ksConfiguration.audioCapabilities.length>0&&(t=o.ksConfiguration.audioCapabilities[0]),null===t)throw new Error("Can not create sessions for unknown content types.");var r=t.contentType,s=a.createSession(r,new Uint8Array(e.initData),e.cdmData?new Uint8Array(e.cdmData):null),l=function(e,t){return{session:e,keyId:t.keyId,initData:t.initData,getKeyId:function(){return this.keyId},getSessionId:function(){return this.session.sessionId},getExpirationTime:function(){return NaN},getSessionType:function(){return"temporary"},handleEvent:function(e){switch(e.type){case y.error:h.trigger(p.KEY_ERROR,{error:new g.Z(d.MEDIA_KEYERR_CODE,"KeyError",this)});break;case y.message:var t=ArrayBuffer.isView(e.message)?e.message.buffer:e.message;h.trigger(p.INTERNAL_KEY_MESSAGE,{data:new ce(this,t,e.destinationURL)});break;case y.ready:n.debug("DRM: Key added."),h.trigger(p.KEY_ADDED);break;case y.close:n.debug("DRM: Session closed.  SessionID = "+this.getSessionId()),h.trigger(p.KEY_SESSION_CLOSED,{data:this.getSessionId()})}}}}(s,e);s.addEventListener(y.error,l),s.addEventListener(y.message,l),s.addEventListener(y.ready,l),s.addEventListener(y.close,l),u.push(l),n.debug("DRM: Session created.  SessionID = "+l.getSessionId()),h.trigger(p.KEY_SESSION_CREATED,{data:l})},updateKeySession:function(e,t){var n=e.session;c.isClearKey(i)?n.update(new Uint8Array(t.toJWK())):n.update(new Uint8Array(t)),h.trigger(p.KEY_SESSION_UPDATED)},closeKeySession:v,setServerCertificate:function(){},loadKeySession:function(){},removeKeySession:function(){},stop:E,reset:E},n=m.getLogger(t),r=null,i=null,a=null,o=null,u=[],c=re(f).getInstance(),l={handleEvent:function(e){if(e.type===y.needkey&&e.initData){var t=ArrayBuffer.isView(e.initData)?e.initData.buffer:e.initData;h.trigger(p.NEED_KEY,{key:new le(t,"cenc")})}}},t}pe.__dashjs_factory_name="ProtectionModel_3Feb2014";var me=dashjs.FactoryMaker.getClassFactory(pe);function ye(e){e=e||{};var t,n,r,i,a,o,u,l,c,f=this.context,h=e.eventBus,p=e.events,m=e.debug,y=e.api,E=e.errHandler;function v(){r&&S();for(var e=0;e<u.length;e++)_(u[e]);h.trigger(p.TEARDOWN_COMPLETE)}function _(e){try{r[y.cancelKeyRequest](i.systemString,e.sessionId)}catch(t){h.trigger(p.KEY_SESSION_CLOSED,{data:null,error:"Error closing session ("+e.sessionId+") "+t.message})}}function T(e,t){if(t&&e){for(var n=e.length,r=0;r<n;r++)if(e[r].sessionId==t)return e[r];return null}return null}function S(){r.removeEventListener(y.keyerror,c),r.removeEventListener(y.needkey,c),r.removeEventListener(y.keymessage,c),r.removeEventListener(y.keyadded,c)}return t={getAllInitData:function(){for(var e=[],t=0;t<o.length;t++)e.push(o[t].initData);for(var n=0;n<u.length;n++)e.push(u[n].initData);return e},getSessions:function(){return u.concat(o)},requestKeySystemAccess:function(e){return new Promise((function(t,n){var i=r;i||(i=document.createElement("video"));for(var o=!1,u=0;u<e.length;u++)for(var l=e[u].ks.systemString,c=e[u].configs,f=null,d=0;d<c.length;d++){var g=c[d].videoCapabilities;if(g&&0!==g.length){f=[];for(var m=0;m<g.length;m++)""!==i.canPlayType(g[m].contentType,l)&&f.push(g[m])}if(f&&(!f||0!==f.length)){o=!0;var y=new s(null,f),E=a.getKeySystemBySystemString(l),v=new fe(E,y);h.trigger(p.KEY_SYSTEM_ACCESS_COMPLETE,{data:v}),t({data:v});break}}if(!o){var _="Key system access denied! -- No valid audio/video content configurations detected!";h.trigger(p.KEY_SYSTEM_ACCESS_COMPLETE,{error:_}),n({error:_})}}))},selectKeySystem:function(e){return i=e.keySystem,Promise.resolve(i)},setMediaElement:function(e){if(r!==e){if(r){S();for(var t=0;t<u.length;t++)_(u[t]);u=[]}(r=e)&&(r.addEventListener(y.keyerror,c),r.addEventListener(y.needkey,c),r.addEventListener(y.keymessage,c),r.addEventListener(y.keyadded,c),h.trigger(p.VIDEO_ELEMENT_SELECTED))}},createKeySession:function(e){if(!i)throw new Error("Can not create sessions until you have selected a key system");if(l||0===u.length){var t={sessionId:null,keyId:e.keyId,initData:e.initData,getKeyId:function(){return this.keyId},getSessionId:function(){return this.sessionId},getExpirationTime:function(){return NaN},getSessionType:function(){return"temporary"}};return o.push(t),r[y.generateKeyRequest](i.systemString,new Uint8Array(e.initData)),t}throw new Error("Multiple sessions not allowed!")},updateKeySession:function(e,t){var n=e.sessionId;if(a.isClearKey(i))for(var o=0;o<t.keyPairs.length;o++)r[y.addKey](i.systemString,t.keyPairs[o].key,t.keyPairs[o].keyID,n);else r[y.addKey](i.systemString,new Uint8Array(t),new Uint8Array(e.initData),n);h.trigger(p.KEY_SESSION_UPDATED)},closeKeySession:_,setServerCertificate:function(){},loadKeySession:function(){},removeKeySession:function(){},stop:v,reset:v},n=m.getLogger(t),r=null,i=null,o=[],u=[],a=re(f).getInstance(),c={handleEvent:function(e){var t=null;switch(e.type){case y.needkey:var r=ArrayBuffer.isView(e.initData)?e.initData.buffer:e.initData;h.trigger(p.NEED_KEY,{key:new le(r,"cenc")});break;case y.keyerror:if((t=T(u,e.sessionId))||(t=T(o,e.sessionId)),t){var i=d.MEDIA_KEYERR_CODE,a="";switch(e.errorCode.code){case 1:i=d.MEDIA_KEYERR_UNKNOWN_CODE,a+="MEDIA_KEYERR_UNKNOWN - "+d.MEDIA_KEYERR_UNKNOWN_MESSAGE;break;case 2:i=d.MEDIA_KEYERR_CLIENT_CODE,a+="MEDIA_KEYERR_CLIENT - "+d.MEDIA_KEYERR_CLIENT_MESSAGE;break;case 3:i=d.MEDIA_KEYERR_SERVICE_CODE,a+="MEDIA_KEYERR_SERVICE - "+d.MEDIA_KEYERR_SERVICE_MESSAGE;break;case 4:i=d.MEDIA_KEYERR_OUTPUT_CODE,a+="MEDIA_KEYERR_OUTPUT - "+d.MEDIA_KEYERR_OUTPUT_MESSAGE;break;case 5:i=d.MEDIA_KEYERR_HARDWARECHANGE_CODE,a+="MEDIA_KEYERR_HARDWARECHANGE - "+d.MEDIA_KEYERR_HARDWARECHANGE_MESSAGE;break;case 6:i=d.MEDIA_KEYERR_DOMAIN_CODE,a+="MEDIA_KEYERR_DOMAIN - "+d.MEDIA_KEYERR_DOMAIN_MESSAGE}a+="  System Code = "+e.systemCode,h.trigger(p.KEY_ERROR,{error:new g.Z(i,a,t)})}else n.error("No session token found for key error");break;case y.keyadded:(t=T(u,e.sessionId))||(t=T(o,e.sessionId)),t?(n.debug("DRM: Key added."),h.trigger(p.KEY_ADDED,{data:t})):n.debug("No session token found for key added");break;case y.keymessage:if((l=null!==e.sessionId&&void 0!==e.sessionId)?!(t=T(u,e.sessionId))&&o.length>0&&(t=o.shift(),u.push(t),t.sessionId=e.sessionId,h.trigger(p.KEY_SESSION_CREATED,{data:t})):o.length>0&&(t=o.shift(),u.push(t),0!==o.length&&E.error(new g.Z(d.MEDIA_KEY_MESSAGE_ERROR_CODE,d.MEDIA_KEY_MESSAGE_ERROR_MESSAGE))),t){var s=ArrayBuffer.isView(e.message)?e.message.buffer:e.message;t.keyMessage=s,h.trigger(p.INTERNAL_KEY_MESSAGE,{data:new ce(t,s,e.defaultURL)})}else n.warn("No session token found for key message")}}},t}ye.__dashjs_factory_name="ProtectionModel_01b";var Ee=dashjs.FactoryMaker.getClassFactory(ye),ve=[{generateKeyRequest:"generateKeyRequest",addKey:"addKey",cancelKeyRequest:"cancelKeyRequest",needkey:"needkey",keyerror:"keyerror",keyadded:"keyadded",keymessage:"keymessage"},{generateKeyRequest:"webkitGenerateKeyRequest",addKey:"webkitAddKey",cancelKeyRequest:"webkitCancelKeyRequest",needkey:"webkitneedkey",keyerror:"webkitkeyerror",keyadded:"webkitkeyadded",keymessage:"webkitkeymessage"}],_e=[{setMediaKeys:"setMediaKeys",MediaKeys:"MediaKeys",release:"close",needkey:"needkey",error:"keyerror",message:"keymessage",ready:"keyadded",close:"keyclose"},{setMediaKeys:"msSetMediaKeys",MediaKeys:"MSMediaKeys",release:"close",needkey:"msneedkey",error:"mskeyerror",message:"mskeymessage",ready:"mskeyadded",close:"mskeyclose"}];function Te(){var e,t=this.context;function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];if("function"==typeof e[r[Object.keys(r)[0]]])return r}return null}return e={createProtectionSystem:function(r){var i=null,a=re(t).getInstance();a.setConfig({debug:r.debug,BASE64:r.BASE64,settings:r.settings}),a.initialize();var o=function(r){var i=r.debug,a=i.getLogger(e),o=r.eventBus,s=r.errHandler,u=r.videoModel?r.videoModel.getElement():null;return u&&void 0===u.onencrypted||u&&void 0===u.mediaKeys?n(u,_e)?(a.info("EME detected on this user agent! (ProtectionModel_3Feb2014)"),me(t).create({debug:i,eventBus:o,events:r.events,api:n(u,_e)})):n(u,ve)?(a.info("EME detected on this user agent! (ProtectionModel_01b)"),Ee(t).create({debug:i,eventBus:o,errHandler:s,events:r.events,api:n(u,ve)})):(a.warn("No supported version of EME detected on this user agent! - Attempts to play encrypted content will fail!"),null):(a.info("EME detected on this user agent! (ProtectionModel_21Jan2015)"),he(t).create({debug:i,eventBus:o,events:r.events}))}(r);return!i&&o&&(i=S(t).create({protectionModel:o,protectionKeyController:a,eventBus:r.eventBus,debug:r.debug,events:r.events,BASE64:r.BASE64,constants:r.constants,cmcdModel:r.cmcdModel,customParametersModel:r.customParametersModel,settings:r.settings}),r.capabilities.setEncryptedMediaSupported(!0)),i}}}Te.__dashjs_factory_name="Protection";var Se=dashjs.FactoryMaker.getClassFactory(Te);Se.events=ue,Se.errors=d,dashjs.FactoryMaker.updateClassFactory(Te.__dashjs_factory_name,Se);var be=Se},2068:function(e,t,n){"use strict";var r=n(5448),i={DEFAULT:.5,STRONG:1,WEAK:0};function a(e,t,n){var r,a;return r=void 0===e?-1:e,a=function(e){var t=i.DEFAULT;return e!==i.DEFAULT&&e!==i.STRONG&&e!==i.WEAK||(t=e),t}(n),{quality:r,reason:void 0===t?null:t,priority:a}}a.__dashjs_factory_name="SwitchRequest";var o=r.Z.getClassFactory(a);o.NO_CHANGE=-1,o.PRIORITY=i,r.Z.updateClassFactory(a.__dashjs_factory_name,o),t.Z=o},1767:function(e,t,n){"use strict";var r=n(5628),i=n(6535),a=n(7423),o=n(895),s=n(6070),u=n(3112),l=n(1914),c=n(5435),f=n(5448),d=n(2068),g=n(3393),h="qualitySwitchRules",p="abandonFragmentRules";function m(e){e=e||{};var t,n,f=this.context,m=e.mediaPlayerModel,y=e.customParametersModel,E=e.dashMetrics,v=e.settings;function _(e){return e.filter((function(e){return e.quality>d.Z.NO_CHANGE}))}function T(e){var t,n,r,i,a,o={},s=null;if(0!==e.length){for(o[d.Z.PRIORITY.STRONG]={quality:d.Z.NO_CHANGE,reason:null},o[d.Z.PRIORITY.WEAK]={quality:d.Z.NO_CHANGE,reason:null},o[d.Z.PRIORITY.DEFAULT]={quality:d.Z.NO_CHANGE,reason:null},t=0,n=e.length;t<n;t+=1)(r=e[t]).quality!==d.Z.NO_CHANGE&&(o[r.priority].quality===d.Z.NO_CHANGE||o[r.priority].quality>r.quality)&&(o[r.priority].quality=r.quality,o[r.priority].reason=r.reason||null);return o[d.Z.PRIORITY.WEAK].quality!==d.Z.NO_CHANGE&&(s=o[d.Z.PRIORITY.WEAK]),o[d.Z.PRIORITY.DEFAULT].quality!==d.Z.NO_CHANGE&&(s=o[d.Z.PRIORITY.DEFAULT]),o[d.Z.PRIORITY.STRONG].quality!==d.Z.NO_CHANGE&&(s=o[d.Z.PRIORITY.STRONG]),s&&(i=s.quality,a=s.reason),(0,d.Z)(f).create(i,a)}}return{initialize:function(){t=[],n=[],v.get().streaming.abr.useDefaultABRRules&&(v.get().streaming.abr.ABRStrategy===g.Z.ABR_STRATEGY_L2A?t.push((0,l.Z)(f).create({dashMetrics:E,settings:v})):v.get().streaming.abr.ABRStrategy===g.Z.ABR_STRATEGY_LoLP?t.push((0,c.Z)(f).create({dashMetrics:E})):(t.push((0,u.Z)(f).create({dashMetrics:E,mediaPlayerModel:m,settings:v})),t.push((0,r.Z)(f).create({dashMetrics:E})),v.get().streaming.abr.additionalAbrRules.insufficientBufferRule&&t.push((0,i.Z)(f).create({dashMetrics:E,settings:v})),v.get().streaming.abr.additionalAbrRules.switchHistoryRule&&t.push((0,s.Z)(f).create()),v.get().streaming.abr.additionalAbrRules.droppedFramesRule&&t.push((0,o.Z)(f).create()),v.get().streaming.abr.additionalAbrRules.abandonRequestsRule&&n.push((0,a.Z)(f).create({dashMetrics:E,mediaPlayerModel:m,settings:v})))),y.getAbrCustomRules().forEach((function(e){e.type===h&&t.push(e.rule(f).create()),e.type===p&&n.push(e.rule(f).create())}))},reset:function(){[t,n].forEach((function(e){e&&e.length&&e.forEach((function(e){return e.reset&&e.reset()}))})),t=[],n=[]},getMaxQuality:function(e){return T(_(t.map((function(t){return t.getMaxIndex(e)}))))||(0,d.Z)(f).create()},getMinSwitchRequest:T,shouldAbandonFragment:function(e,t){var r=T(_(n.map((function(n){return n.shouldAbandon(e,t)}))));return r&&(r.reason.forceAbandon=!0),r||(0,d.Z)(f).create()},getQualitySwitchRules:function(){return t}}}m.__dashjs_factory_name="ABRRulesCollection";var y=f.Z.getClassFactory(m);y.QUALITY_SWITCH_RULES=h,y.ABANDON_FRAGMENT_RULES=p,f.Z.updateSingletonFactory(m.__dashjs_factory_name,y),t.Z=y},7423:function(e,t,n){"use strict";var r=n(2068),i=n(5448),a=n(6398);function o(e){e=e||{};var t,n,i,s,u,l=this.context,c=e.mediaPlayerModel,f=e.dashMetrics,d=e.settings;function g(){i={},s={},u=[]}return t={shouldAbandon:function(e){var t=(0,r.Z)(l).create(r.Z.NO_CHANGE,{name:o.__dashjs_factory_name});if(!(e&&e.hasOwnProperty("getMediaInfo")&&e.hasOwnProperty("getMediaType")&&e.hasOwnProperty("getCurrentRequest")&&e.hasOwnProperty("getRepresentationInfo")&&e.hasOwnProperty("getAbrController")))return t;var a,g,h=e.getMediaInfo(),p=e.getMediaType(),m=e.getStreamInfo(),y=m?m.id:null,E=e.getCurrentRequest();if(!isNaN(E.index)){a=p,g=E.index,i[a]=i[a]||{},i[a][g]=i[a][g]||{};var v=c.getStableBufferTime();if(f.getCurrentBufferLevel(p)>v)return t;var _=i[p][E.index];if(null===_||null===E.firstByteDate||s.hasOwnProperty(_.id))return t;if(void 0===_.firstByteTime&&(u[p]=[],_.firstByteTime=E.firstByteDate.getTime(),_.segmentDuration=E.duration,_.bytesTotal=E.bytesTotal,_.id=E.index),_.bytesLoaded=E.bytesLoaded,_.elapsedTime=(new Date).getTime()-_.firstByteTime,_.bytesLoaded>0&&_.elapsedTime>0&&function(e,t){u[e]=u[e]||[],u[e].push(t)}(p,Math.round(8*_.bytesLoaded/_.elapsedTime)),u[p].length>=d.get().streaming.abr.abrRulesParameters.abandonRequestsRule.minLengthToAverage&&_.elapsedTime>d.get().streaming.abr.abrRulesParameters.abandonRequestsRule.graceTimeThreshold&&_.bytesLoaded<_.bytesTotal){var T=u[p].reduce((function(e,t){return e+t}),0);if(_.measuredBandwidthInKbps=Math.round(T/u[p].length),_.estimatedTimeOfDownload=+(8*_.bytesTotal/_.measuredBandwidthInKbps/1e3).toFixed(2),_.estimatedTimeOfDownload<_.segmentDuration*d.get().streaming.abr.abrRulesParameters.abandonRequestsRule.abandonMultiplier||0===e.getRepresentationInfo().quality)return t;if(!s.hasOwnProperty(_.id)){var S=e.getAbrController(),b=_.bytesTotal-_.bytesLoaded,A=S.getBitrateList(h),I=S.getQualityForBitrate(h,_.measuredBandwidthInKbps*d.get().streaming.abr.bandwidthSafetyFactor,y),R=S.getMinAllowedIndexFor(p,y),w=void 0!==R?Math.max(R,I):I;b>_.bytesTotal*A[w].bitrate/A[S.getQualityFor(p,y)].bitrate&&(t.quality=w,t.reason.throughput=_.measuredBandwidthInKbps,t.reason.fragmentID=_.id,t.reason.rule=this.getClassName(),s[_.id]=_,n.debug("["+p+"] frag id",_.id," is asking to abandon and switch to quality to ",w," measured bandwidth was",_.measuredBandwidthInKbps),delete i[p][_.id])}}else _.bytesLoaded===_.bytesTotal&&delete i[p][_.id]}return t},reset:g},n=(0,a.Z)(l).getInstance().getLogger(t),g(),t}o.__dashjs_factory_name="AbandonRequestsRule",t.Z=i.Z.getClassFactory(o)},3112:function(e,t,n){"use strict";var r=n(3860),i=n(2068),a=n(5448),o=n(7855),s=n(5595),u=n(8512),l=n(6398),c=n(8825),f=n(3393),d=10;function g(e){e=e||{};var t,n,a,g=this.context,h=e.dashMetrics,p=e.mediaPlayerModel,m=(0,s.Z)(g).getInstance();function y(e,t,n){var r=n.reduce((function(e,t,r){return t>n[e]?r:e}),0);if(0===r)return null;var i=Math.max(e,d+2*t.length),a=(n[r]-1)/(i/d-1);return{gp:a,Vp:d/a}}function E(e){e.placeholderBuffer=0,e.mostAdvancedSegmentStart=NaN,e.lastSegmentWasReplacement=!1,e.lastSegmentStart=NaN,e.lastSegmentDurationS=NaN,e.lastSegmentRequestTimeMs=NaN,e.lastSegmentFinishTimeMs=NaN}function v(e,t){var n=p.getStableBufferTime();if(e.stableBufferTime!==n){var r=y(n,e.bitrates,e.utilities);if(r.Vp!==e.Vp||r.gp!==e.gp){var i=h.getCurrentBufferLevel(t),a=i+e.placeholderBuffer;a-=d,a*=r.Vp/e.Vp,a+=d,e.stableBufferTime=n,e.Vp=r.Vp,e.gp=r.gp,e.placeholderBuffer=Math.max(0,a-i)}}}function _(e,t){return e.Vp*(e.utilities[t]+e.gp)}function T(e,t){for(var n=e.bitrates[t],r=e.utilities[t],i=0,a=t-1;a>=0;--a)if(e.utilities[a]<e.utilities[t]){var o=e.bitrates[a],s=e.utilities[a],u=e.Vp*(e.gp+(n*s-o*r)/(n-o));i=Math.max(i,u)}return i}function S(e){var t=e.mediaType===f.Z.AUDIO?[f.Z.AUDIO]:a;for(var n in t)a.hasOwnProperty(n)&&2===a[n].state&&(a[n].placeholderBuffer=0)}function b(){for(var e in a)if(a.hasOwnProperty(e)){var t=a[e];0!==t.state&&(t.state=1,E(t))}}function A(e){if(e&&e.chunk&&e.chunk.mediaInfo){var t=a[e.chunk.mediaInfo.type];if(t&&0!==t.state){var n=e.chunk.start;isNaN(t.mostAdvancedSegmentStart)||n>t.mostAdvancedSegmentStart?(t.mostAdvancedSegmentStart=n,t.lastSegmentWasReplacement=!1):t.lastSegmentWasReplacement=!0,t.lastSegmentStart=n,t.lastSegmentDurationS=e.chunk.duration,t.lastQuality=e.chunk.quality,R(t,e.chunk.mediaInfo.type)}}}function I(e){if(e&&e.metric===r.Z.HTTP_REQUEST&&e.value&&e.value.type===o.w.MEDIA_SEGMENT_TYPE&&e.value.trace&&e.value.trace.length){var t=a[e.mediaType];t&&0!==t.state&&(t.lastSegmentRequestTimeMs=e.value.trequest.getTime(),t.lastSegmentFinishTimeMs=e.value._tfinish.getTime(),R(t,e.mediaType))}}function R(e,t){if(!isNaN(e.lastSegmentStart)&&!isNaN(e.lastSegmentRequestTimeMs)&&!isNaN(e.placeholderBuffer)){if(e.placeholderBuffer*=.99,!isNaN(e.lastSegmentFinishTimeMs)){var n=h.getCurrentBufferLevel(t)+.001*(e.lastSegmentFinishTimeMs-e.lastSegmentRequestTimeMs),r=_(e,e.lastQuality),i=Math.max(0,r-n);e.placeholderBuffer=Math.min(i,e.placeholderBuffer)}e.lastSegmentWasReplacement&&!isNaN(e.lastSegmentDurationS)&&(e.placeholderBuffer+=e.lastSegmentDurationS),e.lastSegmentStart=NaN,e.lastSegmentRequestTimeMs=NaN}}function w(e){if(e){var t=a[e.mediaType];t&&0!==t.state&&(t.abrQuality=e.newQuality)}}function N(e){if(e){var t=a[e.mediaType];if(t&&0!==t.state){var n,r=h.getCurrentBufferLevel(e.mediaType);n=t.abrQuality>0?T(t,t.abrQuality):d;var i=Math.max(0,n-r);t.placeholderBuffer=Math.min(t.placeholderBuffer,i)}}}function C(){a={}}return t={getMaxIndex:function(e){var t=(0,i.Z)(g).create();if(!(e&&e.hasOwnProperty("getMediaInfo")&&e.hasOwnProperty("getMediaType")&&e.hasOwnProperty("getScheduleController")&&e.hasOwnProperty("getStreamInfo")&&e.hasOwnProperty("getAbrController")&&e.hasOwnProperty("useBufferOccupancyABR")))return t;var r=e.getMediaInfo(),o=e.getMediaType(),s=e.getScheduleController(),u=e.getStreamInfo(),l=e.getAbrController(),c=l.getThroughputHistory(),f=u?u.id:null,d=u&&u.manifestInfo&&u.manifestInfo.isDynamic,m=e.useBufferOccupancyABR();if(t.reason=t.reason||{},!m)return t;s.setTimeToLoadDelay(0);var S=function(e){var t=e.getMediaType(),n=a[t];return n?0!==n.state&&v(n,t):(n=function(e){var t={},n=e.getMediaInfo().bitrateList.map((function(e){return e.bandwidth})),r=function(e){return e.map((function(e){return Math.log(e)}))}(n);r=r.map((function(e){return e-r[0]+1}));var i=p.getStableBufferTime(),a=y(i,n,r);return a?(t.state=1,t.bitrates=n,t.utilities=r,t.stableBufferTime=i,t.Vp=a.Vp,t.gp=a.gp,t.lastQuality=0,E(t)):t.state=0,t}(e),a[t]=n),n}(e);if(0===S.state)return t;var b,A=h.getCurrentBufferLevel(o),I=c.getAverageThroughput(o,d),R=c.getSafeAverageThroughput(o,d),w=c.getAverageLatency(o);if(t.reason.state=S.state,t.reason.throughput=I,t.reason.latency=w,isNaN(I))return t;switch(S.state){case 1:b=l.getQualityForBitrate(r,R,f,w),t.quality=b,t.reason.throughput=R,S.placeholderBuffer=Math.max(0,T(S,b)-A),S.lastQuality=b,!isNaN(S.lastSegmentDurationS)&&A>=S.lastSegmentDurationS&&(S.state=2);break;case 2:!function(e,t){var n=Date.now();if(isNaN(e.lastSegmentFinishTimeMs)){if(!isNaN(e.lastCallTimeMs)){var r=.001*(n-e.lastCallTimeMs);e.placeholderBuffer+=Math.max(0,r)}}else{var i=.001*(n-e.lastSegmentFinishTimeMs);e.placeholderBuffer+=Math.max(0,i)}e.lastCallTimeMs=n,e.lastSegmentStart=NaN,e.lastSegmentRequestTimeMs=NaN,e.lastSegmentFinishTimeMs=NaN,v(e,t)}(S,o),b=function(e,t){for(var n=e.bitrates.length,r=NaN,i=NaN,a=0;a<n;++a){var o=(e.Vp*(e.utilities[a]+e.gp)-t)/e.bitrates[a];(isNaN(i)||o>=i)&&(i=o,r=a)}return r}(S,A+S.placeholderBuffer);var N=l.getQualityForBitrate(r,R,f,w);b>S.lastQuality&&b>N&&(b=Math.max(N,S.lastQuality));var C=Math.max(0,A+S.placeholderBuffer-_(S,b));C<=S.placeholderBuffer?(S.placeholderBuffer-=C,C=0):(C-=S.placeholderBuffer,S.placeholderBuffer=0,b<l.getMaxAllowedIndexFor(o,f)?s.setTimeToLoadDelay(1e3*C):C=0),t.quality=b,t.reason.throughput=I,t.reason.latency=w,t.reason.bufferLevel=A,t.reason.placeholderBuffer=S.placeholderBuffer,t.reason.delay=C,S.lastQuality=b;break;default:n.debug("BOLA ABR rule invoked in bad state."),t.quality=l.getQualityForBitrate(r,R,f,w),t.reason.state=S.state,t.reason.throughput=R,t.reason.latency=w,S.state=1,E(S)}return t},reset:function(){C(),m.off(c.Z.BUFFER_EMPTY,S,t),m.off(c.Z.PLAYBACK_SEEKING,b,t),m.off(c.Z.METRIC_ADDED,I,t),m.off(c.Z.QUALITY_CHANGE_REQUESTED,w,t),m.off(c.Z.FRAGMENT_LOADING_ABANDONED,N,t),m.off(u.Z.MEDIA_FRAGMENT_LOADED,A,t)}},n=(0,l.Z)(g).getInstance().getLogger(t),C(),m.on(c.Z.BUFFER_EMPTY,S,t),m.on(c.Z.PLAYBACK_SEEKING,b,t),m.on(c.Z.METRIC_ADDED,I,t),m.on(c.Z.QUALITY_CHANGE_REQUESTED,w,t),m.on(c.Z.FRAGMENT_LOADING_ABANDONED,N,t),m.on(u.Z.MEDIA_FRAGMENT_LOADED,A,t),t}g.__dashjs_factory_name="BolaRule",t.Z=a.Z.getClassFactory(g)},895:function(e,t,n){"use strict";var r=n(5448),i=n(2068),a=n(6398);function o(){var e,t,n=this.context;return e={getMaxIndex:function(e){var r=(0,i.Z)(n).create();if(!e||!e.hasOwnProperty("getDroppedFramesHistory"))return r;var a=e.getDroppedFramesHistory(),o=e.getStreamInfo().id;if(a){var s=a.getFrameHistory(o);if(!s||0===s.length)return r;for(var u=0,l=0,c=i.Z.NO_CHANGE,f=1;f<s.length;f++)if(s[f]&&(u=s[f].droppedVideoFrames,(l=s[f].totalVideoFrames)>375&&u/l>.15)){c=f-1,t.debug("index: "+c+" Dropped Frames: "+u+" Total Frames: "+l);break}return(0,i.Z)(n).create(c,{droppedFrames:u})}return r}},t=(0,a.Z)(n).getInstance().getLogger(e),e}o.__dashjs_factory_name="DroppedFramesRule",t.Z=r.Z.getClassFactory(o)},6535:function(e,t,n){"use strict";var r=n(5595),i=n(8512),a=n(5448),o=n(6398),s=n(2068),u=n(3393),l=n(3860),c=n(8825);function f(e){e=e||{};var t,n,a,f=this.context,d=(0,r.Z)(f).getInstance(),g=e.dashMetrics;function h(){(a={})[u.Z.VIDEO]={ignoreCount:2},a[u.Z.AUDIO]={ignoreCount:2}}function p(){h()}function m(e){isNaN(e.startTime)||e.mediaType!==u.Z.AUDIO&&e.mediaType!==u.Z.VIDEO||a[e.mediaType].ignoreCount>0&&a[e.mediaType].ignoreCount--}return t={getMaxIndex:function(e){var t=(0,s.Z)(f).create();if(!e||!e.hasOwnProperty("getMediaType"))return t;!function(){if(!g||!g.hasOwnProperty("getCurrentBufferLevel")||!g.hasOwnProperty("getCurrentBufferState"))throw new Error(u.Z.MISSING_CONFIG_ERROR)}();var r=e.getMediaType(),i=g.getCurrentBufferState(r),o=e.getRepresentationInfo().fragmentDuration,c=e.getStreamInfo(),d=c?c.id:null,h=e.getScheduleController(),p=c&&c.manifestInfo&&c.manifestInfo.isDynamic;if(function(e,t){return!e&&a[t].ignoreCount>0}(h.getPlaybackController().getLowLatencyModeEnabled(),r)||!o)return t;if(i&&i.state===l.Z.BUFFER_EMPTY)n.debug("["+r+"] Switch to index 0; buffer is empty."),t.quality=0,t.reason="InsufficientBufferRule: Buffer is empty";else{var m=e.getMediaInfo(),y=e.getAbrController(),E=y.getThroughputHistory(),v=g.getCurrentBufferLevel(r),_=E.getAverageThroughput(r,p),T=E.getAverageLatency(r),S=_*(v/o)*.5;t.quality=y.getQualityForBitrate(m,S,d,T),t.reason="InsufficientBufferRule: being conservative to avoid immediate rebuffering"}return t},reset:function(){h(),d.off(c.Z.PLAYBACK_SEEKING,p,t),d.off(i.Z.BYTES_APPENDED_END_FRAGMENT,m,t)}},n=(0,o.Z)(f).getInstance().getLogger(t),h(),d.on(c.Z.PLAYBACK_SEEKING,p,t),d.on(i.Z.BYTES_APPENDED_END_FRAGMENT,m,t),t}f.__dashjs_factory_name="InsufficientBufferRule",t.Z=a.Z.getClassFactory(f)},1914:function(e,t,n){"use strict";var r=n(3860),i=n(2068),a=n(5448),o=n(7855),s=n(5595),u=n(8512),l=n(6398),c=n(3393);function f(e){e=e||{};var t,n,a,f,d=this.context,g=e.dashMetrics,h=(0,s.Z)(d).getInstance();function p(e){e.placeholderBuffer=0,e.mostAdvancedSegmentStart=NaN,e.lastSegmentWasReplacement=!1,e.lastSegmentStart=NaN,e.lastSegmentDurationS=NaN,e.lastSegmentRequestTimeMs=NaN,e.lastSegmentFinishTimeMs=NaN,e.lastSegmentUrl=""}function m(){for(var e in n)if(n.hasOwnProperty(e)){var t=n[e];0!==t.state&&(t.state=1,p(t))}}function y(e){if(e&&e.chunk&&e.chunk.mediaInfo){var t=n[e.chunk.mediaInfo.type],r=a[e.chunk.mediaInfo.type];if(t&&0!==t.state){var i=e.chunk.start;isNaN(t.mostAdvancedSegmentStart)||i>t.mostAdvancedSegmentStart?(t.mostAdvancedSegmentStart=i,t.lastSegmentWasReplacement=!1):t.lastSegmentWasReplacement=!0,t.lastSegmentStart=i,t.lastSegmentDurationS=e.chunk.duration,t.lastQuality=e.chunk.quality,v(t,r)}}}function E(e){if(e&&e.metric===r.Z.HTTP_REQUEST&&e.value&&e.value.type===o.w.MEDIA_SEGMENT_TYPE&&e.value.trace&&e.value.trace.length){var t=n[e.mediaType],i=a[e.mediaType];t&&0!==t.state&&(t.lastSegmentRequestTimeMs=e.value.trequest.getTime(),t.lastSegmentFinishTimeMs=e.value._tfinish.getTime(),v(t,i))}}function v(e,t){isNaN(e.lastSegmentStart)||isNaN(e.lastSegmentRequestTimeMs)||(t.segment_request_start_s=.001*e.lastSegmentRequestTimeMs,t.segment_download_finish_s=.001*e.lastSegmentFinishTimeMs,e.lastSegmentStart=NaN,e.lastSegmentRequestTimeMs=NaN)}function _(e){if(e&&e.mediaType){var t=n[e.mediaType];t&&0!==t.state&&(t.abrQuality=e.newQuality)}}function T(e,t){if(e.length!==t.length)return-1;for(var n=0,r=0;r<e.length;r++)n+=e[r]*t[r];return n}function S(){n={},a={}}return t={getMaxIndex:function(e){var t,r=(0,i.Z)(d).create(),s=Math.pow(4,.99),u=Math.max(Math.pow(4,1),s*Math.sqrt(4)),l=e.getMediaInfo(),h=e.getMediaType(),m=l.bitrateList.map((function(e){return e.bandwidth})),y=m.length,E=e.getScheduleController(),v=e.getStreamInfo(),_=e.getAbrController(),S=_.getThroughputHistory(),b=v&&v.manifestInfo&&v.manifestInfo.isDynamic,A=e.useL2AABR(),I=g.getCurrentBufferLevel(h,!0),R=S.getSafeAverageThroughput(h,b),w=S.getAverageThroughput(h,b),N=S.getAverageLatency(h),C=e.getVideoModel().getPlaybackRate();if(!(e&&e.hasOwnProperty("getMediaInfo")&&e.hasOwnProperty("getMediaType")&&e.hasOwnProperty("getScheduleController")&&e.hasOwnProperty("getStreamInfo")&&e.hasOwnProperty("getAbrController")&&e.hasOwnProperty("useL2AABR")))return r;if(r.reason=r.reason||{},!A||h===c.Z.AUDIO)return r;E.setTimeToLoadDelay(0);var D=function(e){var t=e.getMediaType(),r=n[t];return r||(r=function(e){var t={},n=e.getMediaInfo(),r=n.bitrateList.map((function(e){return e.bandwidth/1e3}));return t.state=1,t.bitrates=r,t.lastQuality=0,function(e){e&&e.type&&(a[e.type]={},a[e.type].w=[],a[e.type].prev_w=[],a[e.type].Q=0,a[e.type].segment_request_start_s=0,a[e.type].segment_download_finish_s=0,a[e.type].B_target=1.5)}(n),p(t),t}(e),n[t]=r),r}(e);if(0===D.state)return r;var O=a[h];if(!O)return r;if(r.reason.state=D.state,r.reason.throughput=w,r.reason.latency=N,isNaN(w))return r;switch(D.state){case 1:if(t=_.getQualityForBitrate(l,R,v.id,N),r.quality=t,r.reason.throughput=R,D.lastQuality=t,!isNaN(D.lastSegmentDurationS)&&I>=O.B_target){D.state=2,O.Q=s;for(var M=0;M<y;++M)M===D.lastQuality?O.prev_w[M]=1:O.prev_w[M]=0}break;case 2:var P=[],L=g.getCurrentHttpRequest(h).trace.reduce((function(e,t){return e+t.d}),0),x=g.getCurrentHttpRequest(h).trace.reduce((function(e,t){return e+t.b[0]}),0),F=Math.round(8*x/L),k=g.getCurrentHttpRequest(h);if(F<1&&(F=1),k.url===D.lastSegmentUrl||k.type===o.w.INIT_SEGMENT_TYPE)t=D.lastQuality;else{for(var U=D.lastSegmentDurationS,Z=1,B=0;B<y;++B)m[B]=m[B]/1e3,C*m[B]>F&&(Z=-1),O.w[B]=O.prev_w[B]+Z*(U/(2*u))*((O.Q+s)*(C*m[B]/F));O.w=function(e){for(var t=e.length,n=!1,r=[],i=0;i<t;++i)r[i]=e[i];for(var a=e.sort((function(e,t){return t-e})),o=0,s=0,u=[],l=0;l<t-1;++l)if((s=((o+=a[l])-1)/(l+1))>=a[l+1]){n=!0;break}n||(s=(o+a[t-1]-1)/t);for(var c=0;c<t;++c)u[c]=Math.max(r[c]-s,0);return u}(O.w);for(var G=0;G<y;++G)P[G]=O.w[G]-O.prev_w[G],O.prev_w[G]=O.w[G];O.Q=Math.max(0,O.Q-U+U*C*((T(m,O.prev_w)+T(m,P))/F));for(var q=[],Y=0;Y<y;++Y)q[Y]=Math.abs(m[Y]-T(O.w,m));(t=q.indexOf(Math.min.apply(Math,q)))>D.lastQuality&&m[D.lastQuality+1]<=F&&(t=D.lastQuality+1),m[t]>=F&&(O.Q=2*Math.max(s,O.Q)),D.lastSegmentUrl=k.url}r.quality=t,r.reason.throughput=w,r.reason.latency=N,r.reason.bufferLevel=I,D.lastQuality=r.quality;break;default:f.debug("L2A ABR rule invoked in bad state."),r.quality=_.getQualityForBitrate(l,R,v.id,N),r.reason.state=D.state,r.reason.throughput=R,r.reason.latency=N,D.state=1,p(D)}return r},reset:function(){S(),h.off(u.Z.PLAYBACK_SEEKING,m,t),h.off(u.Z.MEDIA_FRAGMENT_LOADED,y,t),h.off(u.Z.METRIC_ADDED,E,t),h.off(u.Z.QUALITY_CHANGE_REQUESTED,_,t)}},f=(0,l.Z)(d).getInstance().getLogger(t),S(),h.on(u.Z.PLAYBACK_SEEKING,m,t),h.on(u.Z.MEDIA_FRAGMENT_LOADED,y,t),h.on(u.Z.METRIC_ADDED,E,t),h.on(u.Z.QUALITY_CHANGE_REQUESTED,_,t),t}f.__dashjs_factory_name="L2ARule",t.Z=a.Z.getClassFactory(f)},6070:function(e,t,n){"use strict";var r=n(5448),i=n(6398),a=n(2068);function o(){var e,t,n=this.context;return e={getMaxIndex:function(e){for(var r=e?e.getSwitchHistory():null,i=r?r.getSwitchRequests():[],o=0,s=0,u=0,l=(0,a.Z)(n).create(),c=0;c<i.length;c++)if(void 0!==i[c]&&(o+=i[c].drops,s+=i[c].noDrops,u+=i[c].dropSize,o+s>=6&&o/s>.075)){l.quality=c>0&&i[c].drops>0?c-1:c,l.reason={index:l.quality,drops:o,noDrops:s,dropSize:u},t.debug("Switch history rule index: "+l.quality+" samples: "+(o+s)+" drops: "+o);break}return l}},t=(0,i.Z)(n).getInstance().getLogger(e),e}o.__dashjs_factory_name="SwitchHistoryRule",t.Z=r.Z.getClassFactory(o)},5628:function(e,t,n){"use strict";var r=n(5448),i=n(2068),a=n(3393),o=n(3860);function s(e){e=e||{};var t=this.context,n=e.dashMetrics;return{getMaxIndex:function(e){var r=(0,i.Z)(t).create();if(!(e&&e.hasOwnProperty("getMediaInfo")&&e.hasOwnProperty("getMediaType")&&e.hasOwnProperty("useBufferOccupancyABR")&&e.hasOwnProperty("getAbrController")&&e.hasOwnProperty("getScheduleController")))return r;!function(){if(!n||!n.hasOwnProperty("getCurrentBufferState"))throw new Error(a.Z.MISSING_CONFIG_ERROR)}();var s=e.getMediaInfo(),u=e.getMediaType(),l=n.getCurrentBufferState(u),c=e.getScheduleController(),f=e.getAbrController(),d=e.getStreamInfo(),g=d?d.id:null,h=d&&d.manifestInfo?d.manifestInfo.isDynamic:null,p=f.getThroughputHistory(),m=p.getSafeAverageThroughput(u,h),y=p.getAverageLatency(u),E=e.useBufferOccupancyABR();return isNaN(m)||!l||E||f.getAbandonmentStateFor(g,u)!==o.Z.ABANDON_LOAD&&(l.state===o.Z.BUFFER_LOADED||h)&&(r.quality=f.getQualityForBitrate(s,m,g,y),c.setTimeToLoadDelay(0),r.reason={throughput:m,latency:y}),r},reset:function(){}}}s.__dashjs_factory_name="ThroughputRule",t.Z=r.Z.getClassFactory(s)},4722:function(e,t,n){"use strict";var r=n(5448),i=n(6398);function a(){var e,t,n,r,a,o,s,u,l,c=this.context;function f(){n=null,r=1,a=100,o=0,s=null,u=null,l="dynamic_weight_selection"}function d(){var e=0;if(n)for(var t=0;t<n.length;t++){var r=n[t];r.state.throughput>e&&(e=r.state.throughput)}return e}function g(e,t,n){var r=e.map((function(e,r){return n[r]*Math.pow(e-t[r],2)})).reduce((function(e,t){return e+t}));return(r<0?-1:1)*Math.sqrt(Math.abs(r))}function h(e,t){return g([e.state.throughput,e.state.latency,e.state.rebuffer,e.state.switch],[t.state.throughput,t.state.latency,t.state.rebuffer,t.state.switch],[1,1,1,1])}function p(e,t,n){for(var r=0;r<t.length;r++){var i=t[r],a=h(i,e);m(i,n,Math.exp(-1*Math.pow(a,2)/(2*Math.pow(.1,2))))}}function m(e,t,n){var r=e.state,i=[.01,.01,.01,.01];r.throughput=r.throughput+(t[0]-r.throughput)*i[0]*n,r.latency=r.latency+(t[1]-r.latency)*i[1]*n,r.rebuffer=r.rebuffer+(t[2]-r.rebuffer)*i[2]*n,r.switch=r.switch+(t[3]-r.switch)*i[3]*n}return e={getNextQuality:function(e,i,c,f,h,m,y){var E=c,v=f,_=i,T=function(e){if(!n){n=[];var t=e.bitrateList,i=[];o=t[0].bandwidth,t.forEach((function(e){i.push(e.bandwidth),e.bandwidth<o&&(o=e.bandwidth)})),l=i.map((function(e){return Math.pow(e,2)})).reduce((function(e,t){return e+t})),r=Math.sqrt(l);for(var a=0;a<t.length;a++){var s={qualityIndex:a,bitrate:t[a].bandwidth,state:{throughput:t[a].bandwidth/r,latency:0,rebuffer:0,switch:0}};n.push(s)}u=function(e){var t=[],n=function(e){for(var t=[],n=0;n<e;n++){var r=[Math.random()*d(),Math.random(),Math.random(),Math.random()];t.push(r)}return t}(Math.pow(e.length,2));t.push(n[0]);for(var r=[1,1,1,1],i=1;i<e.length;i++){for(var a=null,o=null,s=0;s<n.length;s++){for(var u=n[s],l=null,c=0;c<t.length;c++){var f=g(u,t[c],r);(null===l||f<l)&&(l=f)}(null===o||l>o)&&(a=u,o=l)}t.push(a)}for(var h=null,p=null,m=0;m<t.length;m++){for(var y=0,E=0;E<t.length;E++)m!==E&&(y+=g(t[m],t[E],r));(null===h||y>h)&&(h=y,p=m)}var v=[];for(v.push(t[p]),t.splice(p,1);t.length>0;){for(var _=null,T=null,S=0;S<t.length;S++){var b=g(v[0],t[S],r);(null===_||b<_)&&(_=b,T=S)}v.push(t[T]),t.splice(T,1)}return v}(n)}var l;return n}(e),S=i/r;S>1&&(S=d()),c/=a,t.debug("getNextQuality called throughput:".concat(S," latency:").concat(c," bufferSize:").concat(f," currentQualityIndex:").concat(m," playbackRate:").concat(h));var b=T[m],A=b.bitrate*y.getSegmentDuration()/_,I=Math.max(0,A-v);if(v-A<y.getMinBuffer())return t.debug("Buffer is low for bitrate= ".concat(b.bitrate," downloadTime=").concat(A," currentBuffer=").concat(v," rebuffer=").concat(I)),function(e,t){var r=0,i=e;if(n)for(var a=0;a<n.length;a++){var o=n[a];o.bitrate<e.bitrate&&o.bitrate>r&&t>o.bitrate&&(r=o.bitrate,i=o)}return i}(b,_).qualityIndex;switch(l){case"manual_weight_selection":s=[.4,.4,.4,.4];break;case"random_weight_selection":!function(e){s=function(e,t){for(var n=[],r=Math.sqrt(2/e),i=0;i<4;i++)n.push(Math.random()*r);return s=n}(e.length)}(T);break;default:!function(e,t,n,r,i,a,o){s||(s=u[u.length-1]);var l=e.findWeightVector(t,n,r,i,a,o);null!==l&&-1!==l&&(s=l)}(y,T,E,v,I,_,h)}for(var R=null,w=null,N=null,C=0;C<T.length;C++){var D=T[C],O=D.state,M=[O.throughput,O.latency,O.rebuffer,O.switch],P=s.slice(),L=y.getNextBufferWithBitrate(D.bitrate,v,_),x=L<y.getMinBuffer();x&&t.debug("Buffer is low for bitrate=".concat(D.bitrate," downloadTime=").concat(A," currentBuffer=").concat(v," nextBuffer=").concat(L)),(D.bitrate>i-1e4||x)&&D.bitrate!==o&&(P[0]=100);var F=g(M,[S,0,0,0],P);(null===R||F<R)&&(R=F,w=D.qualityIndex,N=D)}var k=Math.abs(b.bitrate-N.bitrate)/r;return p(b,T,[S,c,I,k]),p(N,T,[S,0,0,k]),w},reset:function(){f()}},t=(0,i.Z)(c).getInstance().getLogger(e),f(),e}a.__dashjs_factory_name="LearningAbrController",t.Z=r.Z.getClassFactory(a)},5317:function(e,t,n){"use strict";var r=n(5448),i=n(2298);function a(){var e,t,n,r,a;function o(){t=null,n=null,r=null,a=null}function s(e,t,n,r){var a=new i.Z;return a.type=e,a.weights.bitrateReward=t||1,a.weights.bitrateSwitchPenalty=1,a.weights.rebufferPenalty=n||1e3,a.weights.latencyPenalty=[],a.weights.latencyPenalty.push({threshold:1.1,penalty:.05*r}),a.weights.latencyPenalty.push({threshold:1e8,penalty:.1*n}),a.weights.playbackSpeedPenalty=r||200,a}function u(e,t,n,r,i){i.bitrateWSum+=i.weights.bitrateReward*e,i.lastBitrate&&(i.bitrateSwitchWSum+=i.weights.bitrateSwitchPenalty*Math.abs(e-i.lastBitrate)),i.lastBitrate=e,i.rebufferWSum+=i.weights.rebufferPenalty*t;for(var a=0;a<i.weights.latencyPenalty.length;a++){var o=i.weights.latencyPenalty[a];if(n<=o.threshold){i.latencyWSum+=o.penalty*n;break}}i.playbackSpeedWSum+=i.weights.playbackSpeedPenalty*Math.abs(1-r),i.totalQoe=i.bitrateWSum-i.bitrateSwitchWSum-i.rebufferWSum-i.latencyWSum-i.playbackSpeedWSum}return e={setupPerSegmentQoe:function(e,i,o){t=s("segment",e,i,o),n=e,r=i,a=o},logSegmentMetrics:function(e,n,r,i){t&&u(e,n,r,i,t)},getPerSegmentQoe:function(){return t},calculateSingleUseQoe:function(e,t,i,o){var l=null;return n&&r&&a&&(l=s("segment",n,r,a)),l?(u(e,t,i,o,l),l.totalQoe):0},reset:function(){o()}},o(),e}a.__dashjs_factory_name="LoLpQoeEvaluator",t.Z=r.Z.getClassFactory(a)},5435:function(e,t,n){"use strict";var r=n(6398),i=n(5448),a=n(4722),o=n(5317),s=n(2068),u=n(3860),l=n(6523),c=n(3393);function f(e){var t,n,i,f,d=(e=e||{}).dashMetrics,g=this.context;return n={getMaxIndex:function(e){try{var n=(0,s.Z)(g).create(),r=e.getMediaInfo().type,a=e.getAbrController(),o=e.getStreamInfo(),h=a.getQualityFor(r,o.id),p=e.getMediaInfo(),m=d.getCurrentBufferState(r),y=e.getScheduleController(),E=d.getCurrentBufferLevel(r,!0),v=o&&o.manifestInfo?o.manifestInfo.isDynamic:null,_=y.getPlaybackController(),T=_.getCurrentLiveLatency();if(!e.useLoLPABR()||r===c.Z.AUDIO)return n;T||(T=0);var S=_.getPlaybackRate(),b=a.getThroughputHistory().getSafeAverageThroughput(r,v);if(t.debug("Throughput ".concat(Math.round(b)," kbps")),isNaN(b)||!m)return n;if(a.getAbandonmentStateFor(o.id,r)===u.Z.ABANDON_LOAD)return n;for(var A=p.bitrateList,I=e.getRepresentationInfo().fragmentDuration,R=A[0].bandwidth/1e3,w=A[A.length-1].bandwidth/1e3,N=0;N<A.length;N++){var C=A[N].bandwidth/1e3;C>w?w=C:C<R&&(R=C)}var D=A[h].bandwidth/1e3,O=d.getCurrentHttpRequest(r,!0),M=(O.tresponse.getTime()-O.trequest.getTime())/1e3,P=M>I?M-I:0;f.setupPerSegmentQoe(I,w,R),f.logSegmentMetrics(D,P,T,S);var L=(0,l.Z)(g).create({targetLatency:1.5,bufferMin:.3,segmentDuration:I,qoeEvaluator:f});return n.quality=i.getNextQuality(p,1e3*b,T,E,S,h,L),n.reason={throughput:b,latency:T},n.priority=s.Z.PRIORITY.STRONG,y.setTimeToLoadDelay(0),n.quality!==h&&t.debug("[TgcLearningRule]["+r+"] requesting switch to index: ",n.quality,"Average throughput",Math.round(b),"kbps"),n}catch(e){throw e}},reset:function(){i.reset(),f.reset()}},t=(0,r.Z)(g).getInstance().getLogger(n),i=(0,a.Z)(g).create(),f=(0,o.Z)(g).create(),n}f.__dashjs_factory_name="LoLPRule",t.Z=i.Z.getClassFactory(f)},6523:function(e,t,n){"use strict";var r=n(5448);function i(e){var t,n,r,i,a=e.targetLatency,o=e.bufferMin,s=e.segmentDuration,u=e.qoeEvaluator;function l(){return s}function c(e,t){var n=l();return t>n?e-n:e+n-t}return t={getMinBuffer:function(){return o},getSegmentDuration:l,getNextBufferWithBitrate:function(e,t,n){return c(t,e*s/n)},getNextBuffer:c,findWeightVector:function(e,t,i,l,f,d){var g=null,h=null,p=null,m=Math.abs(t-r);return e.forEach((function(e){n.forEach((function(n){n[0];var r=n[1],l=n[2],y=(n[3],e.bitrate*s/f),E=c(i,y),v=(0===l?10:1/l)*Math.max(1e-5,y-E),_=(0===r?10:1/r)*e.state.latency,T=u.calculateSingleUseQoe(e.bitrate,v,_,d);(null===g||T>g)&&function(e,t,n){return!(e>a+n)&&t>=o}(t,E,m)&&(g=T,h=n,p=e.bitrate)}))})),null===h&&null===p&&(h=-1),r=t,h}},4,n=function e(t,n,r){if(r===n)return t;for(var a=t.length,o=0;o<a;o++)for(var s=t.shift(),u=0;u<i.length;u++)t.push(s.concat(i[u]));return e(t,n,r+1)}((i=[.2,.4,.6,.8,1]).map((function(e){return[e]})),4,1),r=0,t}i.__dashjs_factory_name="LoLpWeightSelector",t.Z=r.Z.getClassFactory(i)},2298:function(e,t){"use strict";t.Z=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.type=null,this.lastBitrate=null,this.weights={},this.weights.bitrateReward=null,this.weights.bitrateSwitchPenalty=null,this.weights.rebufferPenalty=null,this.weights.latencyPenalty=null,this.weights.playbackSpeedPenalty=null,this.bitrateWSum=0,this.bitrateSwitchWSum=0,this.rebufferWSum=0,this.latencyWSum=0,this.playbackSpeedWSum=0,this.totalQoe=0}},7803:function(e,t,n){"use strict";n.d(t,{Y:function(){return g}});var r=n(3393),i=n(1553),a=n(5448),o=n(2128),s=n(2594),u=n(7387),l=n(7417),c=n(9032),f=n(9326),d=n(7802),g=["http://dashif.org/thumbnail_tile","http://dashif.org/guidelines/thumbnail_tile"];function h(e){var t,n,a,h,p,m,y,E,v=this.context,_=e.adapter,T=e.baseURLController,S=e.streamInfo,b=e.timelineConverter,A=e.debug,I=e.eventBus,R=e.events,w=e.dashConstants,N=(0,s.Z)(v).getInstance();function C(e,t){var r=new o.Z;r.id=e.id,r.bitrate=e.bandwidth,r.width=e.width,r.height=e.height,r.tilesHor=1,r.tilesVert=1,e.essentialProperties&&e.essentialProperties.forEach((function(e){if(g.indexOf(e.schemeIdUri)>=0&&e.value){var t=e.value.split("x");2!==t.length||isNaN(t[0])||isNaN(t[1])||(r.tilesHor=parseInt(t[0],10),r.tilesVert=parseInt(t[1],10))}})),t?m.updateSegmentData(e).then((function(t){!function(e,t,n){var r=[],i=function(e,t){var n,r,i,a,o=[],s=0;for(n=0,r=e.segments.length;n<r;n++)i=e.segments[n],(a=(0,u.TJ)(b,_.getIsDynamic(),t,i.startTime,i.duration,i.timescale,i.media,i.mediaRange,s))&&(o.push(a),a=null,s++);return o}(n,t);t.segments=i,e.segmentDuration=t.segments[0].duration,e.readThumbnail=function(e,n){var i=null;r.some((function(t){if(t.start<=e&&t.end>e)return i=t.url,!0})),i?n(i):t.segments.some((function(i){if(i.mediaStartTime<=e&&i.mediaStartTime+i.duration>e){var a=T.resolve(t.path);return y.load({method:"get",url:a.url,request:{range:i.mediaRange,responseType:"arraybuffer"},onload:function(e){var t=E.getSamplesInfo(e.target.response),a=new Blob([e.target.response.slice(t.sampleList[0].offset,t.sampleList[0].offset+t.sampleList[0].size)],{type:"image/jpeg"}),o=window.URL.createObjectURL(a);r.push({start:i.mediaStartTime,end:i.mediaStartTime+i.duration,url:o}),n&&n(o)}}),!0}}))}}(r,e,t)})):(r.startNumber=e.startNumber,r.segmentDuration=e.segmentDuration,r.timescale=e.timescale,r.templateUrl=function(e){var t=N.isRelative(e.media)?N.resolve(e.media,T.resolve(e.path).url):e.media;return t?(0,u.Aj)(t,e.id):""}(e)),r.tilesHor>0&&r.tilesVert>0&&(r.widthPerTile=r.width/r.tilesHor,r.heightPerTile=r.height/r.tilesVert,n.push(r))}function D(){n=[],h=-1,p=null}return t={getTracks:function(){return n},addTracks:function(){if(S&&_&&(p=_.getMediaInfoForType(S,r.Z.IMAGE))){var e=_.getVoRepresentations(p);e&&e.length>0&&e.forEach((function(e){(e.segmentInfoType===i.Z.SEGMENT_TEMPLATE&&e.segmentDuration>0&&e.media||e.segmentInfoType===i.Z.SEGMENT_TIMELINE)&&C(e),e.segmentInfoType===i.Z.SEGMENT_BASE&&C(e,!0)})),n.length>0&&n.sort((function(e,t){return e.bitrate-t.bitrate}))}},reset:D,setTrackByIndex:function(e){n&&0!==n.length&&(e>=n.length&&(e=n.length-1),h=e)},getCurrentTrack:function(){return h<0?null:n[h]},getCurrentTrackIndex:function(){return h},getThumbnailRequestForTime:function(e){for(var t,r=_.getVoRepresentations(p),i=0;i<r.length;i++)if(n[h].id===r[i].id){t=r[i];break}return a.getSegmentRequestForTime(p,t,e)}},D(),y=(0,c.Z)(v).create({}),E=(0,l.Z)(v).getInstance(),m=(0,d.Z)(v).create({events:R,eventBus:I,streamInfo:S,timelineConverter:b,dashConstants:w,dashMetrics:e.dashMetrics,segmentBaseController:e.segmentBaseController,type:r.Z.IMAGE}),(a=(0,f.Z)(v).create({streamInfo:S,type:r.Z.IMAGE,timelineConverter:b,segmentsController:m,baseURLController:T,debug:A,eventBus:I,events:R,dashConstants:w,urlUtils:N})).initialize(!!_&&_.getIsDynamic()),t}h.__dashjs_factory_name="ThumbnailTracks",t.Z=a.Z.getClassFactory(h)},7417:function(e,t,n){"use strict";var r=n(6398),i=n(8260),a=n(5448),o=n(6934),s=n(9597);function u(){var e,t,n=this.context;function a(e){if(!e)return null;void 0===e.fileStart&&(e.fileStart=0);var t=o.parseBuffer(e),r=(0,i.Z)(n).create();return r.setData(t),r}function u(e,t){return e[t+3]>>>0|e[t+2]<<8>>>0|e[t+1]<<16>>>0|e[t]<<24>>>0}function l(e,t){return String.fromCharCode(e[t++])+String.fromCharCode(e[t++])+String.fromCharCode(e[t++])+String.fromCharCode(e[t])}return t={parse:a,findLastTopIsoBoxCompleted:function(e,t,n){if(void 0===n&&(n=0),!t||n+8>=t.byteLength)return new s.Z(0,!1);for(var r,i=t instanceof ArrayBuffer?new Uint8Array(t):t,a=0;n<i.byteLength;){var o=u(i,n),c=l(i,n+4);if(0===o)break;n+o<=i.byteLength&&(e.indexOf(c)>=0?r=new s.Z(n,!0,o):a=n+o),n+=o}return r||new s.Z(a,!1)},getMediaTimescaleFromMoov:function(e){var t=a(e),n=t?t.getBox("mdhd"):void 0;return n?n.timescale:NaN},getSamplesInfo:function(e){if(!e||0===e.byteLength)return{sampleList:[],lastSequenceNumber:NaN,totalDuration:NaN,numSequences:NaN};var t,n,r,i,o,s,u,l,c,f,d,g,h,p,m,y,E=a(e),v=E.getBoxes("moof"),_=E.getBoxes("mfhd");m=E.getBoxes("moof").length,p=_[_.length-1].sequence_number,n=0,o=[];var T=-1,S=-1;for(f=0;f<v.length;f++){var b=v[f],A=b.getChildBoxes("traf");for(l=0;l<A.length;l++){var I=A[l],R=I.getChildBox("tfhd"),w=I.getChildBox("tfdt");i=w.baseMediaDecodeTime;var N=I.getChildBoxes("trun"),C=I.getChildBoxes("subs");for(c=0;c<N.length;c++){var D=N[c];for(n=D.sample_count,h=(R.base_data_offset||0)+(D.data_offset||0),u=0;u<n;u++){t=void 0!==(s=D.samples[u]).sample_duration?s.sample_duration:R.default_sample_duration,r=void 0!==s.sample_size?s.sample_size:R.default_sample_size;var O={dts:i,cts:i+(void 0!==s.sample_composition_time_offset?s.sample_composition_time_offset:0),duration:t,offset:b.offset+h,size:r,subSizes:[r]};if(C)for(d=0;d<C.length;d++){var M=C[d];if(T<M.entry_count-1&&u>S&&(T++,S+=M.entries[T].sample_delta),u==S){O.subSizes=[];var P=M.entries[T];for(g=0;g<P.subsample_count;g++)O.subSizes.push(P.subsamples[g].subsample_size)}}o.push(O),h+=r,i+=t}}y=i-w.baseMediaDecodeTime}}return{sampleList:o,lastSequenceNumber:p,totalDuration:y,numSequences:m}},findInitRange:function(t){var n=null,r=a(t);if(!r)return n;var i=r.getBox("ftyp"),o=r.getBox("moov");return e.debug("Searching for initialization."),o&&o.isComplete&&(n=(i?i.offset:o.offset)+"-"+(o.offset+o.size-1),e.debug("Found the initialization.  Range: "+n)),n},parsePayload:function(e,t,n){if(void 0===n&&(n=0),!t||n+8>=t.byteLength)return new s.Z(0,!1);for(var r,i=t instanceof ArrayBuffer?new Uint8Array(t):t,a=0;n<i.byteLength;){var o=u(i,n),c=l(i,n+4);if(0===o)break;n+o<=i.byteLength&&(e.indexOf(c)>=0?r=new s.Z(n,!0,o,c):a=n+o),n+=o}return r||new s.Z(a,!1)}},e=(0,r.Z)(n).getInstance().getLogger(t),t}u.__dashjs_factory_name="BoxParser",t.Z=a.Z.getSingletonFactory(u)},1715:function(e,t,n){"use strict";n.d(t,{B:function(){return s}});var r=n(5448),i=n(7803),a=n(3393),o=[{codec:"avc1",compatibleCodecs:["avc3"]},{codec:"avc3",compatibleCodecs:["avc1"]}];function s(){var e="ManagedMediaSource"in window,t="WebKitMediaSource"in window,n="MediaSource"in window;return e||t||n}function u(){var e,t,n;return e={setConfig:function(e){e&&e.settings&&(t=e.settings)},supportsMediaSource:s,supportsEncryptedMedia:function(){return n},supportsCodec:function(e,n){return n!==a.Z.AUDIO&&n!==a.Z.VIDEO?Promise.resolve(!0):function(e,n){return t.get().streaming.capabilities.useMediaCapabilitiesApi&&navigator.mediaCapabilities&&navigator.mediaCapabilities.decodingInfo&&(e.codec&&n===a.Z.AUDIO||n===a.Z.VIDEO&&e.codec&&e.width&&e.height&&e.bitrate&&e.framerate)}(e,n)?function(e,t){return new Promise((function(n){if(e&&e.codec){var r={type:"media-source"};r[t]={},r[t].contentType=e.codec,r[t].width=e.width,r[t].height=e.height,r[t].bitrate=parseInt(e.bitrate),r[t].framerate=parseFloat(e.framerate),navigator.mediaCapabilities.decodingInfo(r).then((function(e){n(e.supported)})).catch((function(){n(!1)}))}else n(!1)}))}(e,n):function(e){return new Promise((function(t){if(e&&e.codec){var n=e.codec;e.width&&e.height&&(n+=\';width="\'+e.width+\'";height="\'+e.height+\'"\'),"ManagedMediaSource"in window&&ManagedMediaSource.isTypeSupported(n)||"MediaSource"in window&&MediaSource.isTypeSupported(n)||"WebKitMediaSource"in window&&WebKitMediaSource.isTypeSupported(n)?t(!0):t(!1)}else t(!1)}))}(e)},setEncryptedMediaSupported:function(e){n=e},supportsEssentialProperty:function(e){try{return-1!==i.Y.indexOf(e.schemeIdUri)}catch(e){return!0}},codecRootCompatibleWithCodec:function(e,t){for(var n,r=e.split(".")[0],i=0===t.indexOf(r),a=0;a<o.length;a++)if(o[a].codec===r){n=o[a];break}return n?i||n.compatibleCodecs.some((function(e){return 0===t.indexOf(e)})):i}},n=!1,e}u.__dashjs_factory_name="Capabilities",t.Z=r.Z.getSingletonFactory(u)},2295:function(e,t,n){"use strict";var r=n(5448),i=n(3106);function a(){return{customTimeRangeArray:[],length:0,add:function(e,t){var n;for(n=0;n<this.customTimeRangeArray.length&&e>this.customTimeRangeArray[n].start;n++);for(this.customTimeRangeArray.splice(n,0,{start:e,end:t}),n=0;n<this.customTimeRangeArray.length-1;n++)this.mergeRanges(n,n+1)&&n--;this.length=this.customTimeRangeArray.length},clear:function(){this.customTimeRangeArray=[],this.length=0},remove:function(e,t){for(var n=0;n<this.customTimeRangeArray.length;n++)if(e<=this.customTimeRangeArray[n].start&&t>=this.customTimeRangeArray[n].end)this.customTimeRangeArray.splice(n,1),n--;else{if(e>this.customTimeRangeArray[n].start&&t<this.customTimeRangeArray[n].end){this.customTimeRangeArray.splice(n+1,0,{start:t,end:this.customTimeRangeArray[n].end}),this.customTimeRangeArray[n].end=e;break}e>this.customTimeRangeArray[n].start&&e<this.customTimeRangeArray[n].end?this.customTimeRangeArray[n].end=e:t>this.customTimeRangeArray[n].start&&t<this.customTimeRangeArray[n].end&&(this.customTimeRangeArray[n].start=t)}this.length=this.customTimeRangeArray.length},mergeRanges:function(e,t){var n=this.customTimeRangeArray[e],r=this.customTimeRangeArray[t];return n.start<=r.start&&r.start<=n.end&&n.end<=r.end?(n.end=r.end,this.customTimeRangeArray.splice(t,1),!0):r.start<=n.start&&n.start<=r.end&&r.end<=n.end?(n.start=r.start,this.customTimeRangeArray.splice(t,1),!0):r.start<=n.start&&n.start<=r.end&&n.end<=r.end?(this.customTimeRangeArray.splice(e,1),!0):n.start<=r.start&&r.start<=n.end&&r.end<=n.end&&(this.customTimeRangeArray.splice(t,1),!0)},start:function(e){return(0,i.SE)(e),e>=this.customTimeRangeArray.length||e<0?NaN:this.customTimeRangeArray[e].start},end:function(e){return(0,i.SE)(e),e>=this.customTimeRangeArray.length||e<0?NaN:this.customTimeRangeArray[e].end}}}a.__dashjs_factory_name="CustomTimeRanges",t.Z=r.Z.getClassFactory(a)},5:function(e,t,n){"use strict";var r=n(5448);function i(){var e,t=/^[a-z][a-z0-9+\\-_.]*:/i,n=/^https?:\\/\\//i,r=/^https:\\/\\//i,i=/^([a-z][a-z0-9+\\-_.]*:\\/\\/[^\\/]+)\\/?/i,a=function(e,t){try{return new window.URL(e,t).toString()}catch(t){return e}},o=function(e,t){var n=s;if(!t)return e;if(!c(e))return e;f(e)&&(n=u),d(e)&&(n=l);var r=n(t),i="/"!==r.charAt(r.length-1)&&"/"!==e.charAt(0)?"/":"";return[r,e].join(i)};function s(e){var t=e.indexOf("/"),n=e.lastIndexOf("/");return-1!==t?n===t+1?e:(-1!==e.indexOf("?")&&(e=e.substring(0,e.indexOf("?"))),e.substring(0,n+1)):""}function u(e){var t=e.match(i);return t?t[1]:""}function l(e){var n=e.match(t);return n?n[0]:""}function c(e){return!t.test(e)}function f(e){return c(e)&&"/"===e.charAt(0)}function d(e){return 0===e.indexOf("//")}return function(){try{new window.URL("x","http://y"),e=a}catch(e){}finally{e=e||o}}(),{parseBaseUrl:s,parseOrigin:u,parseScheme:l,isRelative:c,isPathAbsolute:f,isSchemeRelative:d,isHTTPURL:function(e){return n.test(e)},isHTTPS:function(e){return r.test(e)},removeHostname:function(e){return/^(?:\\w+\\:\\/\\/)?([^\\/]+)(.*)$/.exec(e)[2].substring(1)},resolve:function(t,n){return e(t,n)}}}i.__dashjs_factory_name="DefaultURLUtils",t.Z=r.Z.getSingletonFactory(i)},8260:function(e,t,n){"use strict";var r=n(2839),i=n(5448);function a(){var e;function t(t){var r=[];if(!t||!e||"function"!=typeof e.fetchAll)return r;for(var i,a=e.fetchAll(t),o=0,s=a.length;o<s;o++)(i=n(a[o]))&&r.push(i);return r}function n(e){if(!e)return null;var t=new r.Z(e);return e.hasOwnProperty("_incomplete")&&(t.isComplete=!e._incomplete),t}return{getBox:function(t){return t&&e&&e.boxes&&0!==e.boxes.length&&"function"==typeof e.fetch?n(e.fetch(t)):null},getBoxes:t,setData:function(t){e=t},getLastBox:function(){if(!e||!e.boxes||!e.boxes.length)return null;var n=t(e.boxes[e.boxes.length-1].type);return n.length>0?n[n.length-1]:null}}}a.__dashjs_factory_name="IsoFile",t.Z=i.Z.getClassFactory(a)},7473:function(e,t,n){"use strict";n.d(t,{k:function(){return i}});var r=n(5448);function i(e,t){var n={url:e.url,method:e.method,headers:Object.assign({},e.headers),credentials:e.withCredentials?"include":void 0};return Promise.resolve(t.modifyRequest(n)).then((function(){return Object.assign(e,n,{withCredentials:"include"===n.credentials})}))}function a(){return{modifyRequest:null,modifyRequestURL:function(e){return e},modifyRequestHeader:function(e,t){return t.url,e}}}a.__dashjs_factory_name="RequestModifier",t.Z=r.Z.getSingletonFactory(a)},3106:function(e,t,n){"use strict";n.d(t,{PS:function(){return a},SE:function(){return o}});var r=n(3393);function i(e){return i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},i(e)}function a(e,t){if(i(e)!==t)throw r.Z.BAD_ARGUMENT_ERROR}function o(e){if(null===e||isNaN(e)||e%1!=0)throw r.Z.BAD_ARGUMENT_ERROR+" : argument is not an integer"}},2594:function(e,t,n){"use strict";var r=n(5448),i=n(5);function a(){var e,t=[],n=this.context;function r(n,r,i){var a=function(n){var r;for(r=0;r<t.length;r++)if(t[r].regex.test(n))return t[r].utils;return e}(i||r);return a&&"function"==typeof a[n]?a[n](r,i):e[n](r,i)}return e=(0,i.Z)(n).getInstance(),{registerUrlRegex:function(e,n){t.push({regex:e,utils:n})},parseBaseUrl:function(e){return r("parseBaseUrl",e)},parseOrigin:function(e){return r("parseOrigin",e)},parseScheme:function(e){return r("parseScheme",e)},isRelative:function(e){return r("isRelative",e)},isPathAbsolute:function(e){return r("isPathAbsolute",e)},isSchemeRelative:function(e){return r("isSchemeRelative",e)},isHTTPURL:function(e){return r("isHTTPURL",e)},isHTTPS:function(e){return r("isHTTPS",e)},removeHostname:function(e){return r("removeHostname",e)},resolve:function(e,t){return r("resolve",e,t)}}}a.__dashjs_factory_name="URLUtils";var o=r.Z.getSingletonFactory(a);t.Z=o},5459:function(e,t){"use strict";t.Z=function e(t,n,r){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.code=t||null,this.message=n||null,this.data=r||null}},3186:function(e,t,n){"use strict";var r=n(7855);function i(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var a=function(){function e(t){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.action=e.ACTION_DOWNLOAD,this.startTime=NaN,this.mediaStartTime=NaN,this.mediaType=null,this.mediaInfo=null,this.type=null,this.duration=NaN,this.timescale=NaN,this.range=null,this.url=t||null,this.serviceLocation=null,this.requestStartDate=null,this.firstByteDate=null,this.requestEndDate=null,this.quality=NaN,this.index=NaN,this.availabilityStartTime=null,this.availabilityEndTime=null,this.wallStartTime=null,this.bytesLoaded=NaN,this.bytesTotal=NaN,this.delayLoadingTime=NaN,this.responseType="arraybuffer",this.representationId=null}var t,n;return t=e,(n=[{key:"isInitializationRequest",value:function(){return this.type&&this.type===r.w.INIT_SEGMENT_TYPE}},{key:"setInfo",value:function(e){this.type=e&&e.init?r.w.INIT_SEGMENT_TYPE:r.w.MEDIA_SEGMENT_TYPE,this.url=e&&e.url?e.url:null,this.range=e&&e.range?e.range.start+"-"+e.range.end:null,this.mediaType=e&&e.mediaType?e.mediaType:null}}])&&i(t.prototype,n),e}();a.ACTION_DOWNLOAD="download",a.ACTION_COMPLETE="complete",t.Z=a},2839:function(e,t){"use strict";function n(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var r=function(){function e(t){if(function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.offset=t._offset,this.type=t.type,this.size=t.size,this.boxes=[],t.boxes)for(var n=0;n<t.boxes.length;n++)this.boxes.push(new e(t.boxes[n]));switch(this.isComplete=!0,t.type){case"sidx":if(this.timescale=t.timescale,this.earliest_presentation_time=t.earliest_presentation_time,this.first_offset=t.first_offset,this.references=t.references,t.references){this.references=[];for(var r=0;r<t.references.length;r++){var i={reference_type:t.references[r].reference_type,referenced_size:t.references[r].referenced_size,subsegment_duration:t.references[r].subsegment_duration};this.references.push(i)}}break;case"emsg":this.id=t.id,this.version=1===t.version?1:0,this.value=t.value,this.timescale=t.timescale,this.scheme_id_uri=t.scheme_id_uri,this.presentation_time_delta=1===t.version?t.presentation_time:t.presentation_time_delta,this.event_duration=t.event_duration,this.message_data=t.message_data;break;case"mdhd":this.timescale=t.timescale;break;case"mfhd":this.sequence_number=t.sequence_number;break;case"subs":this.entry_count=t.entry_count,this.entries=t.entries;break;case"tfhd":this.base_data_offset=t.base_data_offset,this.sample_description_index=t.sample_description_index,this.default_sample_duration=t.default_sample_duration,this.default_sample_size=t.default_sample_size,this.default_sample_flags=t.default_sample_flags,this.flags=t.flags;break;case"tfdt":this.version=t.version,this.baseMediaDecodeTime=t.baseMediaDecodeTime,this.flags=t.flags;break;case"trun":if(this.sample_count=t.sample_count,this.first_sample_flags=t.first_sample_flags,this.data_offset=t.data_offset,this.flags=t.flags,this.samples=t.samples,t.samples){this.samples=[];for(var a=0,o=t.samples.length;a<o;a++){var s={sample_size:t.samples[a].sample_size,sample_duration:t.samples[a].sample_duration,sample_composition_time_offset:t.samples[a].sample_composition_time_offset};this.samples.push(s)}}break;case"prft":this.version=t.version,this.reference_track_ID=t.reference_track_ID,this.ntp_timestamp_sec=t.ntp_timestamp_sec,this.ntp_timestamp_frac=t.ntp_timestamp_frac,this.media_time=t.media_time,this.flags=t.flags}}var t,r;return t=e,(r=[{key:"getChildBox",value:function(e){for(var t=0;t<this.boxes.length;t++)if(this.boxes[t].type===e)return this.boxes[t]}},{key:"getChildBoxes",value:function(e){for(var t=[],n=0;n<this.boxes.length;n++)this.boxes[n].type===e&&t.push(this.boxes[n]);return t}}])&&n(t.prototype,r),e}();t.Z=r},9597:function(e,t){"use strict";t.Z=function e(t,n,r){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.lastCompletedOffset=t,this.found=n,this.size=r}},2128:function(e,t){"use strict";t.Z=function e(){!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.bitrate=0,this.width=0,this.height=0,this.tilesHor=0,this.tilesVert=0,this.widthPerTile=0,this.heightPerTile=0,this.startNumber=0,this.segmentDuration=0,this.timescale=0,this.templateUrl="",this.id=""}},7855:function(e,t,n){"use strict";function r(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}n.d(t,{O:function(){return a},w:function(){return i}});var i=function e(){r(this,e),this.tcpid=null,this.type=null,this.url=null,this.actualurl=null,this.range=null,this.trequest=null,this.tresponse=null,this.responsecode=null,this.interval=null,this.trace=[],this.cmsd=null,this._stream=null,this._tfinish=null,this._mediaduration=null,this._quality=null,this._responseHeaders=null,this._serviceLocation=null,this._fileLoaderType=null},a=function e(){r(this,e),this.s=null,this.d=null,this.b=[]};i.GET="GET",i.HEAD="HEAD",i.MPD_TYPE="MPD",i.XLINK_EXPANSION_TYPE="XLinkExpansion",i.INIT_SEGMENT_TYPE="InitializationSegment",i.INDEX_SEGMENT_TYPE="IndexSegment",i.MEDIA_SEGMENT_TYPE="MediaSegment",i.BITSTREAM_SWITCHING_SEGMENT_TYPE="BitstreamSwitchingSegment",i.MSS_FRAGMENT_INFO_SEGMENT_TYPE="FragmentInfoSegment",i.DVB_REPORTING_TYPE="DVBReporting",i.LICENSE="license",i.CONTENT_STEERING_TYPE="ContentSteering",i.OTHER_TYPE="other"},3039:function(e,t){"use strict";function n(e,t){return function(n,i){for(var a,o,s,u=r(n,"tag"),l=r(null==i?"*":i,"range"),c=[],f=-1;++f<l.length;)if(a=l[f].toLowerCase(),t||"*"!==a){for(o=-1,s=[];++o<u.length;)if(e(u[o].toLowerCase(),a)){if(!t)return u[o];c.push(u[o])}else s.push(u[o]);u=s}return t?c:void 0}}function r(e,t){var n=e&&"string"==typeof e?[e]:e;if(!n||"object"!=typeof n||!("length"in n))throw new Error("Invalid "+t+" `"+n+"`, expected non-empty string");return n}t.basicFilter=n((function(e,t){return"*"===t||e===t||e.indexOf(t+"-")>-1}),!0),t.extendedFilter=n((function(e,t){var n=e.split("-"),r=t.split("-"),i=0,a=0;if("*"!==r[a]&&n[i]!==r[a])return!1;for(i++,a++;a<r.length;)if("*"!==r[a]){if(!n[i])return!1;if(n[i]!==r[a]){if(1===n[i].length)return!1;i++}else i++,a++}else a++;return!0}),!0),t.lookup=n((function(e,t){for(var n,r=t;;){if("*"===r||e===r)return!0;if((n=r.lastIndexOf("-"))<0)return!1;"-"===r.charAt(n-2)&&(n-=2),r=r.slice(0,n)}}))},3973:function(e,t,n){"use strict";e.exports=n(3854)},3854:function(e,t,n){"use strict";var r=n(2415),i=n(3039),a=n(7778),o=n(5813),s=n(3165),u=n(9460);e.exports=function(e,t){var n,c=t||{},m=r.parse(String(e||"").toLowerCase(),c),y=r.stringify(m),E=-1;if(!y)return y;for(;++E<a.length;)i.extendedFilter(y,a[E].from).length&&(d(m,a[E].from,a[E].to),y=r.stringify(m));for(E=-1;++E<o.length;)g(m,o[E].from.field,o[E].from.value)&&h(m,o[E].to.field,o[E].to.value);for(y=r.stringify(Object.assign({},m,f)),E=-1;++E<s.length;)y===s[E]&&(d(m,s[E],s[E].split("-").slice(0,-1).join("-")),y=r.stringify(Object.assign({},m,f)));if(m.extensions.sort(p),c.warning)for(n in u)l.call(u[n],m[n])&&c.warning("Deprecated "+n+" `"+m[n]+"`, expected one of `"+u[n][m[n]].join("`, `")+"`",null,7);return m.script&&(m.script=m.script.charAt(0).toUpperCase()+m.script.slice(1)),m.region&&(m.region=m.region.toUpperCase()),r.stringify(m)};var l={}.hasOwnProperty,c=new Intl.Collator,f={variants:[],extensions:[],privateuse:[],irregular:null,regular:null};function d(e,t,n){var i,a=r.parse(t),o=r.parse(n),s=[];for(i in a)a[i]&&a[i].length&&g(e,i,a[i])&&s.push(i);for(i in o)o[i]&&o[i].length&&(s.indexOf(i)>-1||!e[i]||!e[i].length)&&h(e,i,o[i])}function g(e,t,n){var r,i,a,o,s=!1;if(n){if(i=r=e[t],r&&"object"==typeof r)for(i=[],a=-1;++a<r.length;)o=r[a],n.indexOf(o)<0?i.push(o):s=!0;else r===n&&(i=null,s=!0);e[t]=i}return s}function h(e,t,n){var r,i,a,o=e[t];if(o&&"object"==typeof o)for(r=[].concat(n),i=-1;++i<r.length;)a=r[i],o.indexOf(a)<0&&o.push(a);else e[t]=n}function p(e,t){return c.compare(e.singleton,t.singleton)}},2415:function(e,t,n){"use strict";t.parse=n(6903),t.stringify=n(6713)},6903:function(e,t,n){"use strict";var r=n(2219),i=n(3516),a=n(395),o=n(858),s=n(8589);e.exports=function e(t,n){var l,c,f,d=n||{},g={language:null,extendedLanguageSubtags:[],script:null,region:null,variants:[],extensions:[],privateuse:[],irregular:null,regular:null},h=String(t),p=h.toLowerCase(),m=0;if(null==t)throw new Error("Expected string, got `"+t+"`");if(u.call(s,p))return(null==d.normalize||d.normalize)&&s[p]?e(s[p]):(g[-1===o.indexOf(p)?"irregular":"regular"]=h,g);for(;i(p.charCodeAt(m))&&m<9;)m++;if(m>1&&m<9){if(g.language=h.slice(0,m),m<4)for(c=0;45===p.charCodeAt(m)&&i(p.charCodeAt(m+1))&&i(p.charCodeAt(m+2))&&i(p.charCodeAt(m+3))&&!i(p.charCodeAt(m+4));){if(c>2)return y(m,3,"Too many extended language subtags, expected at most 3 subtags");g.extendedLanguageSubtags.push(h.slice(m+1,m+4)),m+=4,c++}for(45===p.charCodeAt(m)&&i(p.charCodeAt(m+1))&&i(p.charCodeAt(m+2))&&i(p.charCodeAt(m+3))&&i(p.charCodeAt(m+4))&&!i(p.charCodeAt(m+5))&&(g.script=h.slice(m+1,m+5),m+=5),45===p.charCodeAt(m)&&(i(p.charCodeAt(m+1))&&i(p.charCodeAt(m+2))&&!i(p.charCodeAt(m+3))?(g.region=h.slice(m+1,m+3),m+=3):a(p.charCodeAt(m+1))&&a(p.charCodeAt(m+2))&&a(p.charCodeAt(m+3))&&!a(p.charCodeAt(m+4))&&(g.region=h.slice(m+1,m+4),m+=4));45===p.charCodeAt(m);){for(f=l=m+1;r(p.charCodeAt(f));){if(f-l>7)return y(f,1,"Too long variant, expected at most 8 characters");f++}if(!(f-l>4||f-l>3&&a(p.charCodeAt(l))))break;g.variants.push(h.slice(l,f)),m=f}for(;45===p.charCodeAt(m)&&120!==p.charCodeAt(m+1)&&r(p.charCodeAt(m+1))&&45===p.charCodeAt(m+2)&&r(p.charCodeAt(m+3));){for(f=m+2,c=0;45===p.charCodeAt(f)&&r(p.charCodeAt(f+1))&&r(p.charCodeAt(f+2));)for(f=(l=f+1)+2,c++;r(p.charCodeAt(f));){if(f-l>7)return y(f,2,"Too long extension, expected at most 8 characters");f++}if(!c)return y(f,4,"Empty extension, extensions must have at least 2 characters of content");g.extensions.push({singleton:h.charAt(m+1),extensions:h.slice(m+3,f).split("-")}),m=f}}else m=0;if(0===m&&120===p.charCodeAt(m)||45===p.charCodeAt(m)&&120===p.charCodeAt(m+1))for(f=m=m?m+2:1;45===p.charCodeAt(f)&&r(p.charCodeAt(f+1));){for(f=l=m+1;r(p.charCodeAt(f));){if(f-l>7)return y(f,5,"Too long private-use area, expected at most 8 characters");f++}g.privateuse.push(h.slice(m+1,f)),m=f}return m!==h.length?y(m,6,"Found superfluous content after tag"):g;function y(e,t,n){return d.warning&&d.warning(n,t,e),d.forgiving?g:{language:null,extendedLanguageSubtags:[],script:null,region:null,variants:[],extensions:[],privateuse:[],irregular:null,regular:null}}};var u={}.hasOwnProperty},6713:function(e){"use strict";e.exports=function(e){var t,n,r,i=e||{},a=[];if(i.irregular||i.regular)return i.irregular||i.regular;if(i.language)for(a=a.concat(i.language,i.extendedLanguageSubtags||[],i.script||[],i.region||[],i.variants||[]),t=i.extensions||[],n=-1;++n<t.length;)(r=t[n]).singleton&&r.extensions&&r.extensions.length&&(a=a.concat(r.singleton,r.extensions));return i.privateuse&&i.privateuse.length&&(a=a.concat("x",i.privateuse)),a.join("-")}},1549:function(e,t,n){"use strict";var r=n(6693),i=n(2165),a="function"==typeof Symbol&&"function"==typeof Symbol.for?Symbol.for("nodejs.util.inspect.custom"):null;t.Buffer=u,t.SlowBuffer=function(e){return+e!=e&&(e=0),u.alloc(+e)},t.INSPECT_MAX_BYTES=50;var o=2147483647;function s(e){if(e>o)throw new RangeError(\'The value "\'+e+\'" is invalid for option "size"\');var t=new Uint8Array(e);return Object.setPrototypeOf(t,u.prototype),t}function u(e,t,n){if("number"==typeof e){if("string"==typeof t)throw new TypeError(\'The "string" argument must be of type string. Received type number\');return f(e)}return l(e,t,n)}function l(e,t,n){if("string"==typeof e)return function(e,t){if("string"==typeof t&&""!==t||(t="utf8"),!u.isEncoding(t))throw new TypeError("Unknown encoding: "+t);var n=0|p(e,t),r=s(n),i=r.write(e,t);return i!==n&&(r=r.slice(0,i)),r}(e,t);if(ArrayBuffer.isView(e))return function(e){if(G(e,Uint8Array)){var t=new Uint8Array(e);return g(t.buffer,t.byteOffset,t.byteLength)}return d(e)}(e);if(null==e)throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof e);if(G(e,ArrayBuffer)||e&&G(e.buffer,ArrayBuffer))return g(e,t,n);if("undefined"!=typeof SharedArrayBuffer&&(G(e,SharedArrayBuffer)||e&&G(e.buffer,SharedArrayBuffer)))return g(e,t,n);if("number"==typeof e)throw new TypeError(\'The "value" argument must not be of type number. Received type number\');var r=e.valueOf&&e.valueOf();if(null!=r&&r!==e)return u.from(r,t,n);var i=function(e){if(u.isBuffer(e)){var t=0|h(e.length),n=s(t);return 0===n.length||e.copy(n,0,0,t),n}return void 0!==e.length?"number"!=typeof e.length||q(e.length)?s(0):d(e):"Buffer"===e.type&&Array.isArray(e.data)?d(e.data):void 0}(e);if(i)return i;if("undefined"!=typeof Symbol&&null!=Symbol.toPrimitive&&"function"==typeof e[Symbol.toPrimitive])return u.from(e[Symbol.toPrimitive]("string"),t,n);throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof e)}function c(e){if("number"!=typeof e)throw new TypeError(\'"size" argument must be of type number\');if(e<0)throw new RangeError(\'The value "\'+e+\'" is invalid for option "size"\')}function f(e){return c(e),s(e<0?0:0|h(e))}function d(e){for(var t=e.length<0?0:0|h(e.length),n=s(t),r=0;r<t;r+=1)n[r]=255&e[r];return n}function g(e,t,n){if(t<0||e.byteLength<t)throw new RangeError(\'"offset" is outside of buffer bounds\');if(e.byteLength<t+(n||0))throw new RangeError(\'"length" is outside of buffer bounds\');var r;return r=void 0===t&&void 0===n?new Uint8Array(e):void 0===n?new Uint8Array(e,t):new Uint8Array(e,t,n),Object.setPrototypeOf(r,u.prototype),r}function h(e){if(e>=o)throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+o.toString(16)+" bytes");return 0|e}function p(e,t){if(u.isBuffer(e))return e.length;if(ArrayBuffer.isView(e)||G(e,ArrayBuffer))return e.byteLength;if("string"!=typeof e)throw new TypeError(\'The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type \'+typeof e);var n=e.length,r=arguments.length>2&&!0===arguments[2];if(!r&&0===n)return 0;for(var i=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":return U(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":return Z(e).length;default:if(i)return r?-1:U(e).length;t=(""+t).toLowerCase(),i=!0}}function m(e,t,n){var r=!1;if((void 0===t||t<0)&&(t=0),t>this.length)return"";if((void 0===n||n>this.length)&&(n=this.length),n<=0)return"";if((n>>>=0)<=(t>>>=0))return"";for(e||(e="utf8");;)switch(e){case"hex":return D(this,t,n);case"utf8":case"utf-8":return R(this,t,n);case"ascii":return N(this,t,n);case"latin1":case"binary":return C(this,t,n);case"base64":return I(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return O(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function y(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function E(e,t,n,r,i){if(0===e.length)return-1;if("string"==typeof n?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),q(n=+n)&&(n=i?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(i)return-1;n=e.length-1}else if(n<0){if(!i)return-1;n=0}if("string"==typeof t&&(t=u.from(t,r)),u.isBuffer(t))return 0===t.length?-1:v(e,t,n,r,i);if("number"==typeof t)return t&=255,"function"==typeof Uint8Array.prototype.indexOf?i?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):v(e,[t],n,r,i);throw new TypeError("val must be string, number or Buffer")}function v(e,t,n,r,i){var a,o=1,s=e.length,u=t.length;if(void 0!==r&&("ucs2"===(r=String(r).toLowerCase())||"ucs-2"===r||"utf16le"===r||"utf-16le"===r)){if(e.length<2||t.length<2)return-1;o=2,s/=2,u/=2,n/=2}function l(e,t){return 1===o?e[t]:e.readUInt16BE(t*o)}if(i){var c=-1;for(a=n;a<s;a++)if(l(e,a)===l(t,-1===c?0:a-c)){if(-1===c&&(c=a),a-c+1===u)return c*o}else-1!==c&&(a-=a-c),c=-1}else for(n+u>s&&(n=s-u),a=n;a>=0;a--){for(var f=!0,d=0;d<u;d++)if(l(e,a+d)!==l(t,d)){f=!1;break}if(f)return a}return-1}function _(e,t,n,r){n=Number(n)||0;var i=e.length-n;r?(r=Number(r))>i&&(r=i):r=i;var a=t.length;r>a/2&&(r=a/2);for(var o=0;o<r;++o){var s=parseInt(t.substr(2*o,2),16);if(q(s))return o;e[n+o]=s}return o}function T(e,t,n,r){return B(U(t,e.length-n),e,n,r)}function S(e,t,n,r){return B(function(e){for(var t=[],n=0;n<e.length;++n)t.push(255&e.charCodeAt(n));return t}(t),e,n,r)}function b(e,t,n,r){return B(Z(t),e,n,r)}function A(e,t,n,r){return B(function(e,t){for(var n,r,i,a=[],o=0;o<e.length&&!((t-=2)<0);++o)r=(n=e.charCodeAt(o))>>8,i=n%256,a.push(i),a.push(r);return a}(t,e.length-n),e,n,r)}function I(e,t,n){return 0===t&&n===e.length?r.fromByteArray(e):r.fromByteArray(e.slice(t,n))}function R(e,t,n){n=Math.min(e.length,n);for(var r=[],i=t;i<n;){var a,o,s,u,l=e[i],c=null,f=l>239?4:l>223?3:l>191?2:1;if(i+f<=n)switch(f){case 1:l<128&&(c=l);break;case 2:128==(192&(a=e[i+1]))&&(u=(31&l)<<6|63&a)>127&&(c=u);break;case 3:a=e[i+1],o=e[i+2],128==(192&a)&&128==(192&o)&&(u=(15&l)<<12|(63&a)<<6|63&o)>2047&&(u<55296||u>57343)&&(c=u);break;case 4:a=e[i+1],o=e[i+2],s=e[i+3],128==(192&a)&&128==(192&o)&&128==(192&s)&&(u=(15&l)<<18|(63&a)<<12|(63&o)<<6|63&s)>65535&&u<1114112&&(c=u)}null===c?(c=65533,f=1):c>65535&&(c-=65536,r.push(c>>>10&1023|55296),c=56320|1023&c),r.push(c),i+=f}return function(e){var t=e.length;if(t<=w)return String.fromCharCode.apply(String,e);for(var n="",r=0;r<t;)n+=String.fromCharCode.apply(String,e.slice(r,r+=w));return n}(r)}t.kMaxLength=o,u.TYPED_ARRAY_SUPPORT=function(){try{var e=new Uint8Array(1),t={foo:function(){return 42}};return Object.setPrototypeOf(t,Uint8Array.prototype),Object.setPrototypeOf(e,t),42===e.foo()}catch(e){return!1}}(),u.TYPED_ARRAY_SUPPORT||"undefined"==typeof console||"function"!=typeof console.error||console.error("This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."),Object.defineProperty(u.prototype,"parent",{enumerable:!0,get:function(){if(u.isBuffer(this))return this.buffer}}),Object.defineProperty(u.prototype,"offset",{enumerable:!0,get:function(){if(u.isBuffer(this))return this.byteOffset}}),u.poolSize=8192,u.from=function(e,t,n){return l(e,t,n)},Object.setPrototypeOf(u.prototype,Uint8Array.prototype),Object.setPrototypeOf(u,Uint8Array),u.alloc=function(e,t,n){return function(e,t,n){return c(e),e<=0?s(e):void 0!==t?"string"==typeof n?s(e).fill(t,n):s(e).fill(t):s(e)}(e,t,n)},u.allocUnsafe=function(e){return f(e)},u.allocUnsafeSlow=function(e){return f(e)},u.isBuffer=function(e){return null!=e&&!0===e._isBuffer&&e!==u.prototype},u.compare=function(e,t){if(G(e,Uint8Array)&&(e=u.from(e,e.offset,e.byteLength)),G(t,Uint8Array)&&(t=u.from(t,t.offset,t.byteLength)),!u.isBuffer(e)||!u.isBuffer(t))throw new TypeError(\'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array\');if(e===t)return 0;for(var n=e.length,r=t.length,i=0,a=Math.min(n,r);i<a;++i)if(e[i]!==t[i]){n=e[i],r=t[i];break}return n<r?-1:r<n?1:0},u.isEncoding=function(e){switch(String(e).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},u.concat=function(e,t){if(!Array.isArray(e))throw new TypeError(\'"list" argument must be an Array of Buffers\');if(0===e.length)return u.alloc(0);var n;if(void 0===t)for(t=0,n=0;n<e.length;++n)t+=e[n].length;var r=u.allocUnsafe(t),i=0;for(n=0;n<e.length;++n){var a=e[n];if(G(a,Uint8Array))i+a.length>r.length?u.from(a).copy(r,i):Uint8Array.prototype.set.call(r,a,i);else{if(!u.isBuffer(a))throw new TypeError(\'"list" argument must be an Array of Buffers\');a.copy(r,i)}i+=a.length}return r},u.byteLength=p,u.prototype._isBuffer=!0,u.prototype.swap16=function(){var e=this.length;if(e%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var t=0;t<e;t+=2)y(this,t,t+1);return this},u.prototype.swap32=function(){var e=this.length;if(e%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var t=0;t<e;t+=4)y(this,t,t+3),y(this,t+1,t+2);return this},u.prototype.swap64=function(){var e=this.length;if(e%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var t=0;t<e;t+=8)y(this,t,t+7),y(this,t+1,t+6),y(this,t+2,t+5),y(this,t+3,t+4);return this},u.prototype.toString=function(){var e=this.length;return 0===e?"":0===arguments.length?R(this,0,e):m.apply(this,arguments)},u.prototype.toLocaleString=u.prototype.toString,u.prototype.equals=function(e){if(!u.isBuffer(e))throw new TypeError("Argument must be a Buffer");return this===e||0===u.compare(this,e)},u.prototype.inspect=function(){var e="",n=t.INSPECT_MAX_BYTES;return e=this.toString("hex",0,n).replace(/(.{2})/g,"$1 ").trim(),this.length>n&&(e+=" ... "),"<Buffer "+e+">"},a&&(u.prototype[a]=u.prototype.inspect),u.prototype.compare=function(e,t,n,r,i){if(G(e,Uint8Array)&&(e=u.from(e,e.offset,e.byteLength)),!u.isBuffer(e))throw new TypeError(\'The "target" argument must be one of type Buffer or Uint8Array. Received type \'+typeof e);if(void 0===t&&(t=0),void 0===n&&(n=e?e.length:0),void 0===r&&(r=0),void 0===i&&(i=this.length),t<0||n>e.length||r<0||i>this.length)throw new RangeError("out of range index");if(r>=i&&t>=n)return 0;if(r>=i)return-1;if(t>=n)return 1;if(this===e)return 0;for(var a=(i>>>=0)-(r>>>=0),o=(n>>>=0)-(t>>>=0),s=Math.min(a,o),l=this.slice(r,i),c=e.slice(t,n),f=0;f<s;++f)if(l[f]!==c[f]){a=l[f],o=c[f];break}return a<o?-1:o<a?1:0},u.prototype.includes=function(e,t,n){return-1!==this.indexOf(e,t,n)},u.prototype.indexOf=function(e,t,n){return E(this,e,t,n,!0)},u.prototype.lastIndexOf=function(e,t,n){return E(this,e,t,n,!1)},u.prototype.write=function(e,t,n,r){if(void 0===t)r="utf8",n=this.length,t=0;else if(void 0===n&&"string"==typeof t)r=t,n=this.length,t=0;else{if(!isFinite(t))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");t>>>=0,isFinite(n)?(n>>>=0,void 0===r&&(r="utf8")):(r=n,n=void 0)}var i=this.length-t;if((void 0===n||n>i)&&(n=i),e.length>0&&(n<0||t<0)||t>this.length)throw new RangeError("Attempt to write outside buffer bounds");r||(r="utf8");for(var a=!1;;)switch(r){case"hex":return _(this,e,t,n);case"utf8":case"utf-8":return T(this,e,t,n);case"ascii":case"latin1":case"binary":return S(this,e,t,n);case"base64":return b(this,e,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return A(this,e,t,n);default:if(a)throw new TypeError("Unknown encoding: "+r);r=(""+r).toLowerCase(),a=!0}},u.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};var w=4096;function N(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;i<n;++i)r+=String.fromCharCode(127&e[i]);return r}function C(e,t,n){var r="";n=Math.min(e.length,n);for(var i=t;i<n;++i)r+=String.fromCharCode(e[i]);return r}function D(e,t,n){var r=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>r)&&(n=r);for(var i="",a=t;a<n;++a)i+=Y[e[a]];return i}function O(e,t,n){for(var r=e.slice(t,n),i="",a=0;a<r.length-1;a+=2)i+=String.fromCharCode(r[a]+256*r[a+1]);return i}function M(e,t,n){if(e%1!=0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function P(e,t,n,r,i,a){if(!u.isBuffer(e))throw new TypeError(\'"buffer" argument must be a Buffer instance\');if(t>i||t<a)throw new RangeError(\'"value" argument is out of bounds\');if(n+r>e.length)throw new RangeError("Index out of range")}function L(e,t,n,r,i,a){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function x(e,t,n,r,a){return t=+t,n>>>=0,a||L(e,0,n,4),i.write(e,t,n,r,23,4),n+4}function F(e,t,n,r,a){return t=+t,n>>>=0,a||L(e,0,n,8),i.write(e,t,n,r,52,8),n+8}u.prototype.slice=function(e,t){var n=this.length;(e=~~e)<0?(e+=n)<0&&(e=0):e>n&&(e=n),(t=void 0===t?n:~~t)<0?(t+=n)<0&&(t=0):t>n&&(t=n),t<e&&(t=e);var r=this.subarray(e,t);return Object.setPrototypeOf(r,u.prototype),r},u.prototype.readUintLE=u.prototype.readUIntLE=function(e,t,n){e>>>=0,t>>>=0,n||M(e,t,this.length);for(var r=this[e],i=1,a=0;++a<t&&(i*=256);)r+=this[e+a]*i;return r},u.prototype.readUintBE=u.prototype.readUIntBE=function(e,t,n){e>>>=0,t>>>=0,n||M(e,t,this.length);for(var r=this[e+--t],i=1;t>0&&(i*=256);)r+=this[e+--t]*i;return r},u.prototype.readUint8=u.prototype.readUInt8=function(e,t){return e>>>=0,t||M(e,1,this.length),this[e]},u.prototype.readUint16LE=u.prototype.readUInt16LE=function(e,t){return e>>>=0,t||M(e,2,this.length),this[e]|this[e+1]<<8},u.prototype.readUint16BE=u.prototype.readUInt16BE=function(e,t){return e>>>=0,t||M(e,2,this.length),this[e]<<8|this[e+1]},u.prototype.readUint32LE=u.prototype.readUInt32LE=function(e,t){return e>>>=0,t||M(e,4,this.length),(this[e]|this[e+1]<<8|this[e+2]<<16)+16777216*this[e+3]},u.prototype.readUint32BE=u.prototype.readUInt32BE=function(e,t){return e>>>=0,t||M(e,4,this.length),16777216*this[e]+(this[e+1]<<16|this[e+2]<<8|this[e+3])},u.prototype.readIntLE=function(e,t,n){e>>>=0,t>>>=0,n||M(e,t,this.length);for(var r=this[e],i=1,a=0;++a<t&&(i*=256);)r+=this[e+a]*i;return r>=(i*=128)&&(r-=Math.pow(2,8*t)),r},u.prototype.readIntBE=function(e,t,n){e>>>=0,t>>>=0,n||M(e,t,this.length);for(var r=t,i=1,a=this[e+--r];r>0&&(i*=256);)a+=this[e+--r]*i;return a>=(i*=128)&&(a-=Math.pow(2,8*t)),a},u.prototype.readInt8=function(e,t){return e>>>=0,t||M(e,1,this.length),128&this[e]?-1*(255-this[e]+1):this[e]},u.prototype.readInt16LE=function(e,t){e>>>=0,t||M(e,2,this.length);var n=this[e]|this[e+1]<<8;return 32768&n?4294901760|n:n},u.prototype.readInt16BE=function(e,t){e>>>=0,t||M(e,2,this.length);var n=this[e+1]|this[e]<<8;return 32768&n?4294901760|n:n},u.prototype.readInt32LE=function(e,t){return e>>>=0,t||M(e,4,this.length),this[e]|this[e+1]<<8|this[e+2]<<16|this[e+3]<<24},u.prototype.readInt32BE=function(e,t){return e>>>=0,t||M(e,4,this.length),this[e]<<24|this[e+1]<<16|this[e+2]<<8|this[e+3]},u.prototype.readFloatLE=function(e,t){return e>>>=0,t||M(e,4,this.length),i.read(this,e,!0,23,4)},u.prototype.readFloatBE=function(e,t){return e>>>=0,t||M(e,4,this.length),i.read(this,e,!1,23,4)},u.prototype.readDoubleLE=function(e,t){return e>>>=0,t||M(e,8,this.length),i.read(this,e,!0,52,8)},u.prototype.readDoubleBE=function(e,t){return e>>>=0,t||M(e,8,this.length),i.read(this,e,!1,52,8)},u.prototype.writeUintLE=u.prototype.writeUIntLE=function(e,t,n,r){e=+e,t>>>=0,n>>>=0,r||P(this,e,t,n,Math.pow(2,8*n)-1,0);var i=1,a=0;for(this[t]=255&e;++a<n&&(i*=256);)this[t+a]=e/i&255;return t+n},u.prototype.writeUintBE=u.prototype.writeUIntBE=function(e,t,n,r){e=+e,t>>>=0,n>>>=0,r||P(this,e,t,n,Math.pow(2,8*n)-1,0);var i=n-1,a=1;for(this[t+i]=255&e;--i>=0&&(a*=256);)this[t+i]=e/a&255;return t+n},u.prototype.writeUint8=u.prototype.writeUInt8=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,1,255,0),this[t]=255&e,t+1},u.prototype.writeUint16LE=u.prototype.writeUInt16LE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,2,65535,0),this[t]=255&e,this[t+1]=e>>>8,t+2},u.prototype.writeUint16BE=u.prototype.writeUInt16BE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,2,65535,0),this[t]=e>>>8,this[t+1]=255&e,t+2},u.prototype.writeUint32LE=u.prototype.writeUInt32LE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,4,4294967295,0),this[t+3]=e>>>24,this[t+2]=e>>>16,this[t+1]=e>>>8,this[t]=255&e,t+4},u.prototype.writeUint32BE=u.prototype.writeUInt32BE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,4,4294967295,0),this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e,t+4},u.prototype.writeIntLE=function(e,t,n,r){if(e=+e,t>>>=0,!r){var i=Math.pow(2,8*n-1);P(this,e,t,n,i-1,-i)}var a=0,o=1,s=0;for(this[t]=255&e;++a<n&&(o*=256);)e<0&&0===s&&0!==this[t+a-1]&&(s=1),this[t+a]=(e/o>>0)-s&255;return t+n},u.prototype.writeIntBE=function(e,t,n,r){if(e=+e,t>>>=0,!r){var i=Math.pow(2,8*n-1);P(this,e,t,n,i-1,-i)}var a=n-1,o=1,s=0;for(this[t+a]=255&e;--a>=0&&(o*=256);)e<0&&0===s&&0!==this[t+a+1]&&(s=1),this[t+a]=(e/o>>0)-s&255;return t+n},u.prototype.writeInt8=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,1,127,-128),e<0&&(e=255+e+1),this[t]=255&e,t+1},u.prototype.writeInt16LE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,2,32767,-32768),this[t]=255&e,this[t+1]=e>>>8,t+2},u.prototype.writeInt16BE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,2,32767,-32768),this[t]=e>>>8,this[t+1]=255&e,t+2},u.prototype.writeInt32LE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,4,2147483647,-2147483648),this[t]=255&e,this[t+1]=e>>>8,this[t+2]=e>>>16,this[t+3]=e>>>24,t+4},u.prototype.writeInt32BE=function(e,t,n){return e=+e,t>>>=0,n||P(this,e,t,4,2147483647,-2147483648),e<0&&(e=4294967295+e+1),this[t]=e>>>24,this[t+1]=e>>>16,this[t+2]=e>>>8,this[t+3]=255&e,t+4},u.prototype.writeFloatLE=function(e,t,n){return x(this,e,t,!0,n)},u.prototype.writeFloatBE=function(e,t,n){return x(this,e,t,!1,n)},u.prototype.writeDoubleLE=function(e,t,n){return F(this,e,t,!0,n)},u.prototype.writeDoubleBE=function(e,t,n){return F(this,e,t,!1,n)},u.prototype.copy=function(e,t,n,r){if(!u.isBuffer(e))throw new TypeError("argument should be a Buffer");if(n||(n=0),r||0===r||(r=this.length),t>=e.length&&(t=e.length),t||(t=0),r>0&&r<n&&(r=n),r===n)return 0;if(0===e.length||0===this.length)return 0;if(t<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("Index out of range");if(r<0)throw new RangeError("sourceEnd out of bounds");r>this.length&&(r=this.length),e.length-t<r-n&&(r=e.length-t+n);var i=r-n;return this===e&&"function"==typeof Uint8Array.prototype.copyWithin?this.copyWithin(t,n,r):Uint8Array.prototype.set.call(e,this.subarray(n,r),t),i},u.prototype.fill=function(e,t,n,r){if("string"==typeof e){if("string"==typeof t?(r=t,t=0,n=this.length):"string"==typeof n&&(r=n,n=this.length),void 0!==r&&"string"!=typeof r)throw new TypeError("encoding must be a string");if("string"==typeof r&&!u.isEncoding(r))throw new TypeError("Unknown encoding: "+r);if(1===e.length){var i=e.charCodeAt(0);("utf8"===r&&i<128||"latin1"===r)&&(e=i)}}else"number"==typeof e?e&=255:"boolean"==typeof e&&(e=Number(e));if(t<0||this.length<t||this.length<n)throw new RangeError("Out of range index");if(n<=t)return this;var a;if(t>>>=0,n=void 0===n?this.length:n>>>0,e||(e=0),"number"==typeof e)for(a=t;a<n;++a)this[a]=e;else{var o=u.isBuffer(e)?e:u.from(e,r),s=o.length;if(0===s)throw new TypeError(\'The value "\'+e+\'" is invalid for argument "value"\');for(a=0;a<n-t;++a)this[a+t]=o[a%s]}return this};var k=/[^+/0-9A-Za-z-_]/g;function U(e,t){var n;t=t||1/0;for(var r=e.length,i=null,a=[],o=0;o<r;++o){if((n=e.charCodeAt(o))>55295&&n<57344){if(!i){if(n>56319){(t-=3)>-1&&a.push(239,191,189);continue}if(o+1===r){(t-=3)>-1&&a.push(239,191,189);continue}i=n;continue}if(n<56320){(t-=3)>-1&&a.push(239,191,189),i=n;continue}n=65536+(i-55296<<10|n-56320)}else i&&(t-=3)>-1&&a.push(239,191,189);if(i=null,n<128){if((t-=1)<0)break;a.push(n)}else if(n<2048){if((t-=2)<0)break;a.push(n>>6|192,63&n|128)}else if(n<65536){if((t-=3)<0)break;a.push(n>>12|224,n>>6&63|128,63&n|128)}else{if(!(n<1114112))throw new Error("Invalid code point");if((t-=4)<0)break;a.push(n>>18|240,n>>12&63|128,n>>6&63|128,63&n|128)}}return a}function Z(e){return r.toByteArray(function(e){if((e=(e=e.split("=")[0]).trim().replace(k,"")).length<2)return"";for(;e.length%4!=0;)e+="=";return e}(e))}function B(e,t,n,r){for(var i=0;i<r&&!(i+n>=t.length||i>=e.length);++i)t[i+n]=e[i];return i}function G(e,t){return e instanceof t||null!=e&&null!=e.constructor&&null!=e.constructor.name&&e.constructor.name===t.name}function q(e){return e!=e}var Y=function(){for(var e="0123456789abcdef",t=new Array(256),n=0;n<16;++n)for(var r=16*n,i=0;i<16;++i)t[r+i]=e[n]+e[i];return t}()},6693:function(e,t){"use strict";t.byteLength=function(e){var t=u(e),n=t[0],r=t[1];return 3*(n+r)/4-r},t.toByteArray=function(e){var t,n,a=u(e),o=a[0],s=a[1],l=new i(function(e,t,n){return 3*(t+n)/4-n}(0,o,s)),c=0,f=s>0?o-4:o;for(n=0;n<f;n+=4)t=r[e.charCodeAt(n)]<<18|r[e.charCodeAt(n+1)]<<12|r[e.charCodeAt(n+2)]<<6|r[e.charCodeAt(n+3)],l[c++]=t>>16&255,l[c++]=t>>8&255,l[c++]=255&t;return 2===s&&(t=r[e.charCodeAt(n)]<<2|r[e.charCodeAt(n+1)]>>4,l[c++]=255&t),1===s&&(t=r[e.charCodeAt(n)]<<10|r[e.charCodeAt(n+1)]<<4|r[e.charCodeAt(n+2)]>>2,l[c++]=t>>8&255,l[c++]=255&t),l},t.fromByteArray=function(e){for(var t,r=e.length,i=r%3,a=[],o=16383,s=0,u=r-i;s<u;s+=o)a.push(l(e,s,s+o>u?u:s+o));return 1===i?(t=e[r-1],a.push(n[t>>2]+n[t<<4&63]+"==")):2===i&&(t=(e[r-2]<<8)+e[r-1],a.push(n[t>>10]+n[t>>4&63]+n[t<<2&63]+"=")),a.join("")};for(var n=[],r=[],i="undefined"!=typeof Uint8Array?Uint8Array:Array,a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",o=0,s=a.length;o<s;++o)n[o]=a[o],r[a.charCodeAt(o)]=o;function u(e){var t=e.length;if(t%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var n=e.indexOf("=");return-1===n&&(n=t),[n,n===t?0:4-n%4]}function l(e,t,r){for(var i,a,o=[],s=t;s<r;s+=3)i=(e[s]<<16&16711680)+(e[s+1]<<8&65280)+(255&e[s+2]),o.push(n[(a=i)>>18&63]+n[a>>12&63]+n[a>>6&63]+n[63&a]);return o.join("")}r["-".charCodeAt(0)]=62,r["_".charCodeAt(0)]=63},2165:function(e,t){t.read=function(e,t,n,r,i){var a,o,s=8*i-r-1,u=(1<<s)-1,l=u>>1,c=-7,f=n?i-1:0,d=n?-1:1,g=e[t+f];for(f+=d,a=g&(1<<-c)-1,g>>=-c,c+=s;c>0;a=256*a+e[t+f],f+=d,c-=8);for(o=a&(1<<-c)-1,a>>=-c,c+=r;c>0;o=256*o+e[t+f],f+=d,c-=8);if(0===a)a=1-l;else{if(a===u)return o?NaN:1/0*(g?-1:1);o+=Math.pow(2,r),a-=l}return(g?-1:1)*o*Math.pow(2,a-r)},t.write=function(e,t,n,r,i,a){var o,s,u,l=8*a-i-1,c=(1<<l)-1,f=c>>1,d=23===i?Math.pow(2,-24)-Math.pow(2,-77):0,g=r?0:a-1,h=r?1:-1,p=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,o=c):(o=Math.floor(Math.log(t)/Math.LN2),t*(u=Math.pow(2,-o))<1&&(o--,u*=2),(t+=o+f>=1?d/u:d*Math.pow(2,1-f))*u>=2&&(o++,u/=2),o+f>=c?(s=0,o=c):o+f>=1?(s=(t*u-1)*Math.pow(2,i),o+=f):(s=t*Math.pow(2,f-1)*Math.pow(2,i),o=0));i>=8;e[n+g]=255&s,g+=h,s/=256,i-=8);for(o=o<<i|s,l+=i;l>0;e[n+g]=255&o,g+=h,o/=256,l-=8);e[n+g-h]|=128*p}},6934:function(e,t){var n={parseBuffer:function(e){return new r(e).parse()},addBoxProcessor:function(e,t){"string"==typeof e&&"function"==typeof t&&(i.prototype._boxProcessors[e]=t)},createFile:function(){return new r},createBox:function(e,t,n){var r=i.create(e);return t&&t.append(r,n),r},createFullBox:function(e,t,r){var i=n.createBox(e,t,r);return i.version=0,i.flags=0,i},Utils:{}};n.Utils.dataViewToString=function(e,t){var n=t||"utf-8";if("undefined"!=typeof TextDecoder)return new TextDecoder(n).decode(e);var r=[],i=0;if("utf-8"===n)for(;i<e.byteLength;){var a=e.getUint8(i++);a<128||(a<224?(a=(31&a)<<6,a|=63&e.getUint8(i++)):a<240?(a=(15&a)<<12,a|=(63&e.getUint8(i++))<<6,a|=63&e.getUint8(i++)):(a=(7&a)<<18,a|=(63&e.getUint8(i++))<<12,a|=(63&e.getUint8(i++))<<6,a|=63&e.getUint8(i++))),r.push(String.fromCharCode(a))}else for(;i<e.byteLength;)r.push(String.fromCharCode(e.getUint8(i++)));return r.join("")},n.Utils.utf8ToByteArray=function(e){var t,n;if("undefined"!=typeof TextEncoder)t=(new TextEncoder).encode(e);else for(t=[],n=0;n<e.length;++n){var r=e.charCodeAt(n);r<128?t.push(r):r<2048?(t.push(192|r>>6),t.push(128|63&r)):r<65536?(t.push(224|r>>12),t.push(128|63&r>>6),t.push(128|63&r)):(t.push(240|r>>18),t.push(128|63&r>>12),t.push(128|63&r>>6),t.push(128|63&r))}return t},n.Utils.appendBox=function(e,t,n){if(t._offset=e._cursor.offset,t._root=e._root?e._root:e,t._raw=e._raw,t._parent=e,-1!==n)if(null!=n){var r,i=-1;if("number"==typeof n)i=n;else{if("string"==typeof n)r=n;else{if("object"!=typeof n||!n.type)return void e.boxes.push(t);r=n.type}for(var a=0;a<e.boxes.length;a++)if(r===e.boxes[a].type){i=a+1;break}}e.boxes.splice(i,0,t)}else e.boxes.push(t)},t.parseBuffer=n.parseBuffer,t.addBoxProcessor=n.addBoxProcessor,t.createFile=n.createFile,t.createBox=n.createBox,t.createFullBox=n.createFullBox,t.Utils=n.Utils,n.Cursor=function(e){this.offset=void 0===e?0:e};var r=function(e){this._cursor=new n.Cursor,this.boxes=[],e&&(this._raw=new DataView(e))};r.prototype.fetch=function(e){var t=this.fetchAll(e,!0);return t.length?t[0]:null},r.prototype.fetchAll=function(e,t){var n=[];return r._sweep.call(this,e,n,t),n},r.prototype.parse=function(){for(this._cursor.offset=0,this.boxes=[];this._cursor.offset<this._raw.byteLength;){var e=i.parse(this);if(void 0===e.type)break;this.boxes.push(e)}return this},r._sweep=function(e,t,n){for(var i in this.type&&this.type==e&&t.push(this),this.boxes){if(t.length&&n)return;r._sweep.call(this.boxes[i],e,t,n)}},r.prototype.write=function(){var e,t=0;for(e=0;e<this.boxes.length;e++)t+=this.boxes[e].getLength(!1);var n=new Uint8Array(t);for(this._rawo=new DataView(n.buffer),this.bytes=n,this._cursor.offset=0,e=0;e<this.boxes.length;e++)this.boxes[e].write();return n.buffer},r.prototype.append=function(e,t){n.Utils.appendBox(this,e,t)};var i=function(){this._cursor=new n.Cursor};i.parse=function(e){var t=new i;return t._offset=e._cursor.offset,t._root=e._root?e._root:e,t._raw=e._raw,t._parent=e,t._parseBox(),e._cursor.offset=t._raw.byteOffset+t._raw.byteLength,t},i.create=function(e){var t=new i;return t.type=e,t.boxes=[],t},i.prototype._boxContainers=["dinf","edts","mdia","meco","mfra","minf","moof","moov","mvex","stbl","strk","traf","trak","tref","udta","vttc","sinf","schi","encv","enca"],i.prototype._boxProcessors={},i.prototype._procField=function(e,t,n){this._parsing?this[e]=this._readField(t,n):this._writeField(t,n,this[e])},i.prototype._procFieldArray=function(e,t,n,r){var i;if(this._parsing)for(this[e]=[],i=0;i<t;i++)this[e][i]=this._readField(n,r);else for(i=0;i<this[e].length;i++)this._writeField(n,r,this[e][i])},i.prototype._procFullBox=function(){this._procField("version","uint",8),this._procField("flags","uint",24)},i.prototype._procEntries=function(e,t,n){var r;if(this._parsing)for(this[e]=[],r=0;r<t;r++)this[e].push({}),n.call(this,this[e][r]);else for(r=0;r<t;r++)n.call(this,this[e][r])},i.prototype._procSubEntries=function(e,t,n,r){var i;if(this._parsing)for(e[t]=[],i=0;i<n;i++)e[t].push({}),r.call(this,e[t][i]);else for(i=0;i<n;i++)r.call(this,e[t][i])},i.prototype._procEntryField=function(e,t,n,r){this._parsing?e[t]=this._readField(n,r):this._writeField(n,r,e[t])},i.prototype._procSubBoxes=function(e,t){var n;if(this._parsing)for(this[e]=[],n=0;n<t;n++)this[e].push(i.parse(this));else for(n=0;n<t;n++)this._rawo?this[e][n].write():this.size+=this[e][n].getLength()},i.prototype._readField=function(e,t){switch(e){case"uint":return this._readUint(t);case"int":return this._readInt(t);case"template":return this._readTemplate(t);case"string":return-1===t?this._readTerminatedString():this._readString(t);case"data":return this._readData(t);case"utf8":return this._readUTF8String();default:return-1}},i.prototype._readInt=function(e){var t=null,n=this._cursor.offset-this._raw.byteOffset;switch(e){case 8:t=this._raw.getInt8(n);break;case 16:t=this._raw.getInt16(n);break;case 32:t=this._raw.getInt32(n);break;case 64:var r=this._raw.getInt32(n),i=this._raw.getInt32(n+4);t=r*Math.pow(2,32)+i}return this._cursor.offset+=e>>3,t},i.prototype._readUint=function(e){var t,n,r=null,i=this._cursor.offset-this._raw.byteOffset;switch(e){case 8:r=this._raw.getUint8(i);break;case 16:r=this._raw.getUint16(i);break;case 24:r=((t=this._raw.getUint16(i))<<8)+(n=this._raw.getUint8(i+2));break;case 32:r=this._raw.getUint32(i);break;case 64:t=this._raw.getUint32(i),n=this._raw.getUint32(i+4),r=t*Math.pow(2,32)+n}return this._cursor.offset+=e>>3,r},i.prototype._readString=function(e){for(var t="",n=0;n<e;n++){var r=this._readUint(8);t+=String.fromCharCode(r)}return t},i.prototype._readTemplate=function(e){return this._readUint(e/2)+this._readUint(e/2)/Math.pow(2,e/2)},i.prototype._readTerminatedString=function(){for(var e="";this._cursor.offset-this._offset<this._raw.byteLength;){var t=this._readUint(8);if(0===t)break;e+=String.fromCharCode(t)}return e},i.prototype._readData=function(e){var t=e>0?e:this._raw.byteLength-(this._cursor.offset-this._offset);if(t>0){var n=new Uint8Array(this._raw.buffer,this._cursor.offset,t);return this._cursor.offset+=t,n}return null},i.prototype._readUTF8String=function(){var e=this._raw.byteLength-(this._cursor.offset-this._offset),t=null;return e>0&&(t=new DataView(this._raw.buffer,this._cursor.offset,e),this._cursor.offset+=e),t?n.Utils.dataViewToString(t):t},i.prototype._parseBox=function(){if(this._parsing=!0,this._cursor.offset=this._offset,this._offset+8>this._raw.buffer.byteLength)this._root._incomplete=!0;else{switch(this._procField("size","uint",32),this._procField("type","string",4),1===this.size&&this._procField("largesize","uint",64),"uuid"===this.type&&this._procFieldArray("usertype",16,"uint",8),this.size){case 0:this._raw=new DataView(this._raw.buffer,this._offset);break;case 1:this._offset+this.size>this._raw.buffer.byteLength?(this._incomplete=!0,this._root._incomplete=!0):this._raw=new DataView(this._raw.buffer,this._offset,this.largesize);break;default:this._offset+this.size>this._raw.buffer.byteLength?(this._incomplete=!0,this._root._incomplete=!0):this._raw=new DataView(this._raw.buffer,this._offset,this.size)}this._incomplete||(this._boxProcessors[this.type]&&this._boxProcessors[this.type].call(this),-1!==this._boxContainers.indexOf(this.type)?this._parseContainerBox():this._data=this._readData())}},i.prototype._parseFullBox=function(){this.version=this._readUint(8),this.flags=this._readUint(24)},i.prototype._parseContainerBox=function(){for(this.boxes=[];this._cursor.offset-this._raw.byteOffset<this._raw.byteLength;)this.boxes.push(i.parse(this))},i.prototype.append=function(e,t){n.Utils.appendBox(this,e,t)},i.prototype.getLength=function(){if(this._parsing=!1,this._rawo=null,this.size=0,this._procField("size","uint",32),this._procField("type","string",4),1===this.size&&this._procField("largesize","uint",64),"uuid"===this.type&&this._procFieldArray("usertype",16,"uint",8),this._boxProcessors[this.type]&&this._boxProcessors[this.type].call(this),-1!==this._boxContainers.indexOf(this.type))for(var e=0;e<this.boxes.length;e++)this.size+=this.boxes[e].getLength();return this._data&&this._writeData(this._data),this.size},i.prototype.write=function(){switch(this._parsing=!1,this._cursor.offset=this._parent._cursor.offset,this.size){case 0:this._rawo=new DataView(this._parent._rawo.buffer,this._cursor.offset,this.parent._rawo.byteLength-this._cursor.offset);break;case 1:this._rawo=new DataView(this._parent._rawo.buffer,this._cursor.offset,this.largesize);break;default:this._rawo=new DataView(this._parent._rawo.buffer,this._cursor.offset,this.size)}if(this._procField("size","uint",32),this._procField("type","string",4),1===this.size&&this._procField("largesize","uint",64),"uuid"===this.type&&this._procFieldArray("usertype",16,"uint",8),this._boxProcessors[this.type]&&this._boxProcessors[this.type].call(this),-1!==this._boxContainers.indexOf(this.type))for(var e=0;e<this.boxes.length;e++)this.boxes[e].write();return this._data&&this._writeData(this._data),this._parent._cursor.offset+=this.size,this.size},i.prototype._writeInt=function(e,t){if(this._rawo){var n=this._cursor.offset-this._rawo.byteOffset;switch(e){case 8:this._rawo.setInt8(n,t);break;case 16:this._rawo.setInt16(n,t);break;case 32:this._rawo.setInt32(n,t);break;case 64:var r=Math.floor(t/Math.pow(2,32)),i=t-r*Math.pow(2,32);this._rawo.setUint32(n,r),this._rawo.setUint32(n+4,i)}this._cursor.offset+=e>>3}else this.size+=e>>3},i.prototype._writeUint=function(e,t){if(this._rawo){var n,r,i=this._cursor.offset-this._rawo.byteOffset;switch(e){case 8:this._rawo.setUint8(i,t);break;case 16:this._rawo.setUint16(i,t);break;case 24:n=(16776960&t)>>8,r=255&t,this._rawo.setUint16(i,n),this._rawo.setUint8(i+2,r);break;case 32:this._rawo.setUint32(i,t);break;case 64:r=t-(n=Math.floor(t/Math.pow(2,32)))*Math.pow(2,32),this._rawo.setUint32(i,n),this._rawo.setUint32(i+4,r)}this._cursor.offset+=e>>3}else this.size+=e>>3},i.prototype._writeString=function(e,t){for(var n=0;n<e;n++)this._writeUint(8,t.charCodeAt(n))},i.prototype._writeTerminatedString=function(e){if(0!==e.length){for(var t=0;t<e.length;t++)this._writeUint(8,e.charCodeAt(t));this._writeUint(8,0)}},i.prototype._writeTemplate=function(e,t){var n=Math.floor(t),r=(t-n)*Math.pow(2,e/2);this._writeUint(e/2,n),this._writeUint(e/2,r)},i.prototype._writeData=function(e){if(e)if(this._rawo){if(e instanceof Array){for(var t=this._cursor.offset-this._rawo.byteOffset,n=0;n<e.length;n++)this._rawo.setInt8(t+n,e[n]);this._cursor.offset+=e.length}e instanceof Uint8Array&&(this._root.bytes.set(e,this._cursor.offset),this._cursor.offset+=e.length)}else this.size+=e.length},i.prototype._writeUTF8String=function(e){var t=n.Utils.utf8ToByteArray(e);if(this._rawo)for(var r=new DataView(this._rawo.buffer,this._cursor.offset,t.length),i=0;i<t.length;i++)r.setUint8(i,t[i]);else this.size+=t.length},i.prototype._writeField=function(e,t,n){switch(e){case"uint":this._writeUint(t,n);break;case"int":this._writeInt(t,n);break;case"template":this._writeTemplate(t,n);break;case"string":-1==t?this._writeTerminatedString(n):this._writeString(t,n);break;case"data":this._writeData(n);break;case"utf8":this._writeUTF8String(n)}},i.prototype._boxProcessors.avc1=i.prototype._boxProcessors.avc2=i.prototype._boxProcessors.avc3=i.prototype._boxProcessors.avc4=i.prototype._boxProcessors.hvc1=i.prototype._boxProcessors.hev1=i.prototype._boxProcessors.encv=function(){this._procFieldArray("reserved1",6,"uint",8),this._procField("data_reference_index","uint",16),this._procField("pre_defined1","uint",16),this._procField("reserved2","uint",16),this._procFieldArray("pre_defined2",3,"uint",32),this._procField("width","uint",16),this._procField("height","uint",16),this._procField("horizresolution","template",32),this._procField("vertresolution","template",32),this._procField("reserved3","uint",32),this._procField("frame_count","uint",16),this._procFieldArray("compressorname",32,"uint",8),this._procField("depth","uint",16),this._procField("pre_defined3","int",16),this._procField("config","data",-1)},i.prototype._boxProcessors.ctts=function(){this._procFullBox(),this._procField("entry_count","uint",32),this._procEntries("entries",this.entry_count,(function(e){this._procEntryField(e,"sample_count","uint",32),this._procEntryField(e,"sample_offset",1===this.version?"int":"uint",32)}))},i.prototype._boxProcessors.dref=function(){this._procFullBox(),this._procField("entry_count","uint",32),this._procSubBoxes("entries",this.entry_count)},i.prototype._boxProcessors.elst=function(){this._procFullBox(),this._procField("entry_count","uint",32),this._procEntries("entries",this.entry_count,(function(e){this._procEntryField(e,"segment_duration","uint",1===this.version?64:32),this._procEntryField(e,"media_time","int",1===this.version?64:32),this._procEntryField(e,"media_rate_integer","int",16),this._procEntryField(e,"media_rate_fraction","int",16)}))},i.prototype._boxProcessors.emsg=function(){this._procFullBox(),1==this.version?(this._procField("timescale","uint",32),this._procField("presentation_time","uint",64),this._procField("event_duration","uint",32),this._procField("id","uint",32),this._procField("scheme_id_uri","string",-1),this._procField("value","string",-1)):(this._procField("scheme_id_uri","string",-1),this._procField("value","string",-1),this._procField("timescale","uint",32),this._procField("presentation_time_delta","uint",32),this._procField("event_duration","uint",32),this._procField("id","uint",32)),this._procField("message_data","data",-1)},i.prototype._boxProcessors.free=i.prototype._boxProcessors.skip=function(){this._procField("data","data",-1)},i.prototype._boxProcessors.frma=function(){this._procField("data_format","uint",32)},i.prototype._boxProcessors.ftyp=i.prototype._boxProcessors.styp=function(){this._procField("major_brand","string",4),this._procField("minor_version","uint",32);var e=-1;this._parsing&&(e=(this._raw.byteLength-(this._cursor.offset-this._raw.byteOffset))/4),this._procFieldArray("compatible_brands",e,"string",4)},i.prototype._boxProcessors.hdlr=function(){this._procFullBox(),this._procField("pre_defined","uint",32),this._procField("handler_type","string",4),this._procFieldArray("reserved",3,"uint",32),this._procField("name","string",-1)},i.prototype._boxProcessors.mdat=function(){this._procField("data","data",-1)},i.prototype._boxProcessors.mdhd=function(){this._procFullBox(),this._procField("creation_time","uint",1==this.version?64:32),this._procField("modification_time","uint",1==this.version?64:32),this._procField("timescale","uint",32),this._procField("duration","uint",1==this.version?64:32),this._parsing||"string"!=typeof this.language||(this.language=this.language.charCodeAt(0)-96<<10|this.language.charCodeAt(1)-96<<5|this.language.charCodeAt(2)-96),this._procField("language","uint",16),this._parsing&&(this.language=String.fromCharCode(96+(this.language>>10&31),96+(this.language>>5&31),96+(31&this.language))),this._procField("pre_defined","uint",16)},i.prototype._boxProcessors.mehd=function(){this._procFullBox(),this._procField("fragment_duration","uint",1==this.version?64:32)},i.prototype._boxProcessors.mfhd=function(){this._procFullBox(),this._procField("sequence_number","uint",32)},i.prototype._boxProcessors.mfro=function(){this._procFullBox(),this._procField("mfra_size","uint",32)},i.prototype._boxProcessors.mp4a=i.prototype._boxProcessors.enca=function(){this._procFieldArray("reserved1",6,"uint",8),this._procField("data_reference_index","uint",16),this._procFieldArray("reserved2",2,"uint",32),this._procField("channelcount","uint",16),this._procField("samplesize","uint",16),this._procField("pre_defined","uint",16),this._procField("reserved3","uint",16),this._procField("samplerate","template",32),this._procField("esds","data",-1)},i.prototype._boxProcessors.mvhd=function(){this._procFullBox(),this._procField("creation_time","uint",1==this.version?64:32),this._procField("modification_time","uint",1==this.version?64:32),this._procField("timescale","uint",32),this._procField("duration","uint",1==this.version?64:32),this._procField("rate","template",32),this._procField("volume","template",16),this._procField("reserved1","uint",16),this._procFieldArray("reserved2",2,"uint",32),this._procFieldArray("matrix",9,"template",32),this._procFieldArray("pre_defined",6,"uint",32),this._procField("next_track_ID","uint",32)},i.prototype._boxProcessors.payl=function(){this._procField("cue_text","utf8")},i.prototype._boxProcessors.prft=function(){this._procFullBox(),this._procField("reference_track_ID","uint",32),this._procField("ntp_timestamp_sec","uint",32),this._procField("ntp_timestamp_frac","uint",32),this._procField("media_time","uint",1==this.version?64:32)},i.prototype._boxProcessors.pssh=function(){this._procFullBox(),this._procFieldArray("SystemID",16,"uint",8),this._procField("DataSize","uint",32),this._procFieldArray("Data",this.DataSize,"uint",8)},i.prototype._boxProcessors.schm=function(){this._procFullBox(),this._procField("scheme_type","uint",32),this._procField("scheme_version","uint",32),1&this.flags&&this._procField("scheme_uri","string",-1)},i.prototype._boxProcessors.sdtp=function(){this._procFullBox();var e=-1;this._parsing&&(e=this._raw.byteLength-(this._cursor.offset-this._raw.byteOffset)),this._procFieldArray("sample_dependency_table",e,"uint",8)},i.prototype._boxProcessors.sidx=function(){this._procFullBox(),this._procField("reference_ID","uint",32),this._procField("timescale","uint",32),this._procField("earliest_presentation_time","uint",1==this.version?64:32),this._procField("first_offset","uint",1==this.version?64:32),this._procField("reserved","uint",16),this._procField("reference_count","uint",16),this._procEntries("references",this.reference_count,(function(e){this._parsing||(e.reference=(1&e.reference_type)<<31,e.reference|=2147483647&e.referenced_size,e.sap=(1&e.starts_with_SAP)<<31,e.sap|=(3&e.SAP_type)<<28,e.sap|=268435455&e.SAP_delta_time),this._procEntryField(e,"reference","uint",32),this._procEntryField(e,"subsegment_duration","uint",32),this._procEntryField(e,"sap","uint",32),this._parsing&&(e.reference_type=e.reference>>31&1,e.referenced_size=2147483647&e.reference,e.starts_with_SAP=e.sap>>31&1,e.SAP_type=e.sap>>28&7,e.SAP_delta_time=268435455&e.sap)}))},i.prototype._boxProcessors.smhd=function(){this._procFullBox(),this._procField("balance","uint",16),this._procField("reserved","uint",16)},i.prototype._boxProcessors.ssix=function(){this._procFullBox(),this._procField("subsegment_count","uint",32),this._procEntries("subsegments",this.subsegment_count,(function(e){this._procEntryField(e,"ranges_count","uint",32),this._procSubEntries(e,"ranges",e.ranges_count,(function(e){this._procEntryField(e,"level","uint",8),this._procEntryField(e,"range_size","uint",24)}))}))},i.prototype._boxProcessors.stsd=function(){this._procFullBox(),this._procField("entry_count","uint",32),this._procSubBoxes("entries",this.entry_count)},i.prototype._boxProcessors.sttg=function(){this._procField("settings","utf8")},i.prototype._boxProcessors.stts=function(){this._procFullBox(),this._procField("entry_count","uint",32),this._procEntries("entries",this.entry_count,(function(e){this._procEntryField(e,"sample_count","uint",32),this._procEntryField(e,"sample_delta","uint",32)}))},i.prototype._boxProcessors.subs=function(){this._procFullBox(),this._procField("entry_count","uint",32),this._procEntries("entries",this.entry_count,(function(e){this._procEntryField(e,"sample_delta","uint",32),this._procEntryField(e,"subsample_count","uint",16),this._procSubEntries(e,"subsamples",e.subsample_count,(function(e){this._procEntryField(e,"subsample_size","uint",1===this.version?32:16),this._procEntryField(e,"subsample_priority","uint",8),this._procEntryField(e,"discardable","uint",8),this._procEntryField(e,"codec_specific_parameters","uint",32)}))}))},i.prototype._boxProcessors.tenc=function(){this._procFullBox(),this._procField("default_IsEncrypted","uint",24),this._procField("default_IV_size","uint",8),this._procFieldArray("default_KID",16,"uint",8)},i.prototype._boxProcessors.tfdt=function(){this._procFullBox(),this._procField("baseMediaDecodeTime","uint",1==this.version?64:32)},i.prototype._boxProcessors.tfhd=function(){this._procFullBox(),this._procField("track_ID","uint",32),1&this.flags&&this._procField("base_data_offset","uint",64),2&this.flags&&this._procField("sample_description_offset","uint",32),8&this.flags&&this._procField("default_sample_duration","uint",32),16&this.flags&&this._procField("default_sample_size","uint",32),32&this.flags&&this._procField("default_sample_flags","uint",32)},i.prototype._boxProcessors.tfra=function(){this._procFullBox(),this._procField("track_ID","uint",32),this._parsing||(this.reserved=0,this.reserved|=(48&this.length_size_of_traf_num)<<4,this.reserved|=(12&this.length_size_of_trun_num)<<2,this.reserved|=3&this.length_size_of_sample_num),this._procField("reserved","uint",32),this._parsing&&(this.length_size_of_traf_num=(48&this.reserved)>>4,this.length_size_of_trun_num=(12&this.reserved)>>2,this.length_size_of_sample_num=3&this.reserved),this._procField("number_of_entry","uint",32),this._procEntries("entries",this.number_of_entry,(function(e){this._procEntryField(e,"time","uint",1===this.version?64:32),this._procEntryField(e,"moof_offset","uint",1===this.version?64:32),this._procEntryField(e,"traf_number","uint",8*(this.length_size_of_traf_num+1)),this._procEntryField(e,"trun_number","uint",8*(this.length_size_of_trun_num+1)),this._procEntryField(e,"sample_number","uint",8*(this.length_size_of_sample_num+1))}))},i.prototype._boxProcessors.tkhd=function(){this._procFullBox(),this._procField("creation_time","uint",1==this.version?64:32),this._procField("modification_time","uint",1==this.version?64:32),this._procField("track_ID","uint",32),this._procField("reserved1","uint",32),this._procField("duration","uint",1==this.version?64:32),this._procFieldArray("reserved2",2,"uint",32),this._procField("layer","uint",16),this._procField("alternate_group","uint",16),this._procField("volume","template",16),this._procField("reserved3","uint",16),this._procFieldArray("matrix",9,"template",32),this._procField("width","template",32),this._procField("height","template",32)},i.prototype._boxProcessors.trex=function(){this._procFullBox(),this._procField("track_ID","uint",32),this._procField("default_sample_description_index","uint",32),this._procField("default_sample_duration","uint",32),this._procField("default_sample_size","uint",32),this._procField("default_sample_flags","uint",32)},i.prototype._boxProcessors.trun=function(){this._procFullBox(),this._procField("sample_count","uint",32),1&this.flags&&this._procField("data_offset","int",32),4&this.flags&&this._procField("first_sample_flags","uint",32),this._procEntries("samples",this.sample_count,(function(e){256&this.flags&&this._procEntryField(e,"sample_duration","uint",32),512&this.flags&&this._procEntryField(e,"sample_size","uint",32),1024&this.flags&&this._procEntryField(e,"sample_flags","uint",32),2048&this.flags&&this._procEntryField(e,"sample_composition_time_offset",1===this.version?"int":"uint",32)}))},i.prototype._boxProcessors["url "]=i.prototype._boxProcessors["urn "]=function(){this._procFullBox(),"urn "===this.type&&this._procField("name","string",-1),this._procField("location","string",-1)},i.prototype._boxProcessors.vlab=function(){this._procField("source_label","utf8")},i.prototype._boxProcessors.vmhd=function(){this._procFullBox(),this._procField("graphicsmode","uint",16),this._procFieldArray("opcolor",3,"uint",16)},i.prototype._boxProcessors.vttC=function(){this._procField("config","utf8")},i.prototype._boxProcessors.vtte=function(){}},5530:function(e,t,n){"use strict";e.exports=n(6146).polyfill()},6146:function(e,t,n){e.exports=function(){"use strict";function e(e){return"function"==typeof e}var t=Array.isArray?Array.isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)},r=0,i=void 0,a=void 0,o=function(e,t){g[r]=e,g[r+1]=t,2===(r+=2)&&(a?a(h):v())};var s="undefined"!=typeof window?window:void 0,u=s||{},l=u.MutationObserver||u.WebKitMutationObserver,c="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),f="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function d(){var e=setTimeout;return function(){return e(h,1)}}var g=new Array(1e3);function h(){for(var e=0;e<r;e+=2)(0,g[e])(g[e+1]),g[e]=void 0,g[e+1]=void 0;r=0}var p,m,y,E,v=void 0;function _(e,t){var n=this,r=new this.constructor(b);void 0===r[S]&&L(r);var i=n._state;if(i){var a=arguments[i-1];o((function(){return M(i,r,a,n._result)}))}else D(n,r,e,t);return r}function T(e){if(e&&"object"==typeof e&&e.constructor===this)return e;var t=new this(b);return R(t,e),t}v=c?function(){return process.nextTick(h)}:l?(m=0,y=new l(h),E=document.createTextNode(""),y.observe(E,{characterData:!0}),function(){E.data=m=++m%2}):f?((p=new MessageChannel).port1.onmessage=h,function(){return p.port2.postMessage(0)}):void 0===s?function(){try{var e=Function("return this")().require("vertx");return void 0!==(i=e.runOnLoop||e.runOnContext)?function(){i(h)}:d()}catch(e){return d()}}():d();var S=Math.random().toString(36).substring(2);function b(){}var A=void 0;function I(t,n,r){n.constructor===t.constructor&&r===_&&n.constructor.resolve===T?function(e,t){1===t._state?N(e,t._result):2===t._state?C(e,t._result):D(t,void 0,(function(t){return R(e,t)}),(function(t){return C(e,t)}))}(t,n):void 0===r?N(t,n):e(r)?function(e,t,n){o((function(e){var r=!1,i=function(e,t,n,r){try{e.call(t,n,r)}catch(e){return e}}(n,t,(function(n){r||(r=!0,t!==n?R(e,n):N(e,n))}),(function(t){r||(r=!0,C(e,t))}),e._label);!r&&i&&(r=!0,C(e,i))}),e)}(t,n,r):N(t,n)}function R(e,t){if(e===t)C(e,new TypeError("You cannot resolve a promise with itself"));else if(i=typeof(r=t),null===r||"object"!==i&&"function"!==i)N(e,t);else{var n=void 0;try{n=t.then}catch(t){return void C(e,t)}I(e,t,n)}var r,i}function w(e){e._onerror&&e._onerror(e._result),O(e)}function N(e,t){e._state===A&&(e._result=t,e._state=1,0!==e._subscribers.length&&o(O,e))}function C(e,t){e._state===A&&(e._state=2,e._result=t,o(w,e))}function D(e,t,n,r){var i=e._subscribers,a=i.length;e._onerror=null,i[a]=t,i[a+1]=n,i[a+2]=r,0===a&&e._state&&o(O,e)}function O(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r=void 0,i=void 0,a=e._result,o=0;o<t.length;o+=3)r=t[o],i=t[o+n],r?M(n,r,i,a):i(a);e._subscribers.length=0}}function M(t,n,r,i){var a=e(r),o=void 0,s=void 0,u=!0;if(a){try{o=r(i)}catch(e){u=!1,s=e}if(n===o)return void C(n,new TypeError("A promises callback cannot return that same promise."))}else o=i;n._state!==A||(a&&u?R(n,o):!1===u?C(n,s):1===t?N(n,o):2===t&&C(n,o))}var P=0;function L(e){e[S]=P++,e._state=void 0,e._result=void 0,e._subscribers=[]}var x=function(){function e(e,n){this._instanceConstructor=e,this.promise=new e(b),this.promise[S]||L(this.promise),t(n)?(this.length=n.length,this._remaining=n.length,this._result=new Array(this.length),0===this.length?N(this.promise,this._result):(this.length=this.length||0,this._enumerate(n),0===this._remaining&&N(this.promise,this._result))):C(this.promise,new Error("Array Methods must be provided an Array"))}return e.prototype._enumerate=function(e){for(var t=0;this._state===A&&t<e.length;t++)this._eachEntry(e[t],t)},e.prototype._eachEntry=function(e,t){var n=this._instanceConstructor,r=n.resolve;if(r===T){var i=void 0,a=void 0,o=!1;try{i=e.then}catch(e){o=!0,a=e}if(i===_&&e._state!==A)this._settledAt(e._state,t,e._result);else if("function"!=typeof i)this._remaining--,this._result[t]=e;else if(n===F){var s=new n(b);o?C(s,a):I(s,e,i),this._willSettleAt(s,t)}else this._willSettleAt(new n((function(t){return t(e)})),t)}else this._willSettleAt(r(e),t)},e.prototype._settledAt=function(e,t,n){var r=this.promise;r._state===A&&(this._remaining--,2===e?C(r,n):this._result[t]=n),0===this._remaining&&N(r,this._result)},e.prototype._willSettleAt=function(e,t){var n=this;D(e,void 0,(function(e){return n._settledAt(1,t,e)}),(function(e){return n._settledAt(2,t,e)}))},e}();var F=function(){function t(e){this[S]=P++,this._result=this._state=void 0,this._subscribers=[],b!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(e,t){try{t((function(t){R(e,t)}),(function(t){C(e,t)}))}catch(t){C(e,t)}}(this,e):function(){throw new TypeError("Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(e){return this.then(null,e)},t.prototype.finally=function(t){var n=this,r=n.constructor;return e(t)?n.then((function(e){return r.resolve(t()).then((function(){return e}))}),(function(e){return r.resolve(t()).then((function(){throw e}))})):n.then(t,t)},t}();return F.prototype.then=_,F.all=function(e){return new x(this,e).promise},F.race=function(e){var n=this;return t(e)?new n((function(t,r){for(var i=e.length,a=0;a<i;a++)n.resolve(e[a]).then(t,r)})):new n((function(e,t){return t(new TypeError("You must pass an array to race."))}))},F.resolve=T,F.reject=function(e){var t=new this(b);return C(t,e),t},F._setScheduler=function(e){a=e},F._setAsap=function(e){o=e},F._asap=o,F.polyfill=function(){var e=void 0;if(void 0!==n.g)e=n.g;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){var r=null;try{r=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===r&&!t.cast)return}e.Promise=F},F.Promise=F,F}()},1159:function(e){"use strict";var t,n="object"==typeof Reflect?Reflect:null,r=n&&"function"==typeof n.apply?n.apply:function(e,t,n){return Function.prototype.apply.call(e,t,n)};t=n&&"function"==typeof n.ownKeys?n.ownKeys:Object.getOwnPropertySymbols?function(e){return Object.getOwnPropertyNames(e).concat(Object.getOwnPropertySymbols(e))}:function(e){return Object.getOwnPropertyNames(e)};var i=Number.isNaN||function(e){return e!=e};function a(){a.init.call(this)}e.exports=a,e.exports.once=function(e,t){return new Promise((function(n,r){function i(n){e.removeListener(t,a),r(n)}function a(){"function"==typeof e.removeListener&&e.removeListener("error",i),n([].slice.call(arguments))}p(e,t,a,{once:!0}),"error"!==t&&function(e,t,n){"function"==typeof e.on&&p(e,"error",t,{once:!0})}(e,i)}))},a.EventEmitter=a,a.prototype._events=void 0,a.prototype._eventsCount=0,a.prototype._maxListeners=void 0;var o=10;function s(e){if("function"!=typeof e)throw new TypeError(\'The "listener" argument must be of type Function. Received type \'+typeof e)}function u(e){return void 0===e._maxListeners?a.defaultMaxListeners:e._maxListeners}function l(e,t,n,r){var i,a,o,l;if(s(n),void 0===(a=e._events)?(a=e._events=Object.create(null),e._eventsCount=0):(void 0!==a.newListener&&(e.emit("newListener",t,n.listener?n.listener:n),a=e._events),o=a[t]),void 0===o)o=a[t]=n,++e._eventsCount;else if("function"==typeof o?o=a[t]=r?[n,o]:[o,n]:r?o.unshift(n):o.push(n),(i=u(e))>0&&o.length>i&&!o.warned){o.warned=!0;var c=new Error("Possible EventEmitter memory leak detected. "+o.length+" "+String(t)+" listeners added. Use emitter.setMaxListeners() to increase limit");c.name="MaxListenersExceededWarning",c.emitter=e,c.type=t,c.count=o.length,l=c,console&&console.warn&&console.warn(l)}return e}function c(){if(!this.fired)return this.target.removeListener(this.type,this.wrapFn),this.fired=!0,0===arguments.length?this.listener.call(this.target):this.listener.apply(this.target,arguments)}function f(e,t,n){var r={fired:!1,wrapFn:void 0,target:e,type:t,listener:n},i=c.bind(r);return i.listener=n,r.wrapFn=i,i}function d(e,t,n){var r=e._events;if(void 0===r)return[];var i=r[t];return void 0===i?[]:"function"==typeof i?n?[i.listener||i]:[i]:n?function(e){for(var t=new Array(e.length),n=0;n<t.length;++n)t[n]=e[n].listener||e[n];return t}(i):h(i,i.length)}function g(e){var t=this._events;if(void 0!==t){var n=t[e];if("function"==typeof n)return 1;if(void 0!==n)return n.length}return 0}function h(e,t){for(var n=new Array(t),r=0;r<t;++r)n[r]=e[r];return n}function p(e,t,n,r){if("function"==typeof e.on)r.once?e.once(t,n):e.on(t,n);else{if("function"!=typeof e.addEventListener)throw new TypeError(\'The "emitter" argument must be of type EventEmitter. Received type \'+typeof e);e.addEventListener(t,(function i(a){r.once&&e.removeEventListener(t,i),n(a)}))}}Object.defineProperty(a,"defaultMaxListeners",{enumerable:!0,get:function(){return o},set:function(e){if("number"!=typeof e||e<0||i(e))throw new RangeError(\'The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received \'+e+".");o=e}}),a.init=function(){void 0!==this._events&&this._events!==Object.getPrototypeOf(this)._events||(this._events=Object.create(null),this._eventsCount=0),this._maxListeners=this._maxListeners||void 0},a.prototype.setMaxListeners=function(e){if("number"!=typeof e||e<0||i(e))throw new RangeError(\'The value of "n" is out of range. It must be a non-negative number. Received \'+e+".");return this._maxListeners=e,this},a.prototype.getMaxListeners=function(){return u(this)},a.prototype.emit=function(e){for(var t=[],n=1;n<arguments.length;n++)t.push(arguments[n]);var i="error"===e,a=this._events;if(void 0!==a)i=i&&void 0===a.error;else if(!i)return!1;if(i){var o;if(t.length>0&&(o=t[0]),o instanceof Error)throw o;var s=new Error("Unhandled error."+(o?" ("+o.message+")":""));throw s.context=o,s}var u=a[e];if(void 0===u)return!1;if("function"==typeof u)r(u,this,t);else{var l=u.length,c=h(u,l);for(n=0;n<l;++n)r(c[n],this,t)}return!0},a.prototype.addListener=function(e,t){return l(this,e,t,!1)},a.prototype.on=a.prototype.addListener,a.prototype.prependListener=function(e,t){return l(this,e,t,!0)},a.prototype.once=function(e,t){return s(t),this.on(e,f(this,e,t)),this},a.prototype.prependOnceListener=function(e,t){return s(t),this.prependListener(e,f(this,e,t)),this},a.prototype.removeListener=function(e,t){var n,r,i,a,o;if(s(t),void 0===(r=this._events))return this;if(void 0===(n=r[e]))return this;if(n===t||n.listener===t)0==--this._eventsCount?this._events=Object.create(null):(delete r[e],r.removeListener&&this.emit("removeListener",e,n.listener||t));else if("function"!=typeof n){for(i=-1,a=n.length-1;a>=0;a--)if(n[a]===t||n[a].listener===t){o=n[a].listener,i=a;break}if(i<0)return this;0===i?n.shift():function(e,t){for(;t+1<e.length;t++)e[t]=e[t+1];e.pop()}(n,i),1===n.length&&(r[e]=n[0]),void 0!==r.removeListener&&this.emit("removeListener",e,o||t)}return this},a.prototype.off=a.prototype.removeListener,a.prototype.removeAllListeners=function(e){var t,n,r;if(void 0===(n=this._events))return this;if(void 0===n.removeListener)return 0===arguments.length?(this._events=Object.create(null),this._eventsCount=0):void 0!==n[e]&&(0==--this._eventsCount?this._events=Object.create(null):delete n[e]),this;if(0===arguments.length){var i,a=Object.keys(n);for(r=0;r<a.length;++r)"removeListener"!==(i=a[r])&&this.removeAllListeners(i);return this.removeAllListeners("removeListener"),this._events=Object.create(null),this._eventsCount=0,this}if("function"==typeof(t=n[e]))this.removeListener(e,t);else if(void 0!==t)for(r=t.length-1;r>=0;r--)this.removeListener(e,t[r]);return this},a.prototype.listeners=function(e){return d(this,e,!0)},a.prototype.rawListeners=function(e){return d(this,e,!1)},a.listenerCount=function(e,t){return"function"==typeof e.listenerCount?e.listenerCount(t):g.call(e,t)},a.prototype.listenerCount=g,a.prototype.eventNames=function(){return this._eventsCount>0?t(this._events):[]}},3101:function(e){"use strict";var t=Array.isArray,n=Object.keys,r=Object.prototype.hasOwnProperty;e.exports=function e(i,a){if(i===a)return!0;if(i&&a&&"object"==typeof i&&"object"==typeof a){var o,s,u,l=t(i),c=t(a);if(l&&c){if((s=i.length)!=a.length)return!1;for(o=s;0!=o--;)if(!e(i[o],a[o]))return!1;return!0}if(l!=c)return!1;var f=i instanceof Date,d=a instanceof Date;if(f!=d)return!1;if(f&&d)return i.getTime()==a.getTime();var g=i instanceof RegExp,h=a instanceof RegExp;if(g!=h)return!1;if(g&&h)return i.toString()==a.toString();var p=n(i);if((s=p.length)!==n(a).length)return!1;for(o=s;0!=o--;)if(!r.call(a,p[o]))return!1;for(o=s;0!=o--;)if(!e(i[u=p[o]],a[u]))return!1;return!0}return i!=i&&a!=a}},3362:function(e,t,n){!function(e,t,n,r,i){function a(e){if("contents"in e)for(var t=("styleAttrs"in e?e.styleAttrs[r.byName.ruby.qname]:null),n="span"===e.kind&&("container"===t||"textContainer"===t||"baseContainer"===t),i=e.contents.length-1;i>=0;i--)!n||"styleAttrs"in e.contents[i]&&r.byName.ruby.qname in e.contents[i].styleAttrs?a(e.contents[i]):delete e.contents[i]}function o(e,t,n,r){var i=r&&"seq"===r.timeContainer,a=0;r&&(a=i&&n?n.end:r.begin),t.begin=t.explicit_begin?t.explicit_begin+a:a;var s=t.begin,u=null;if("sets"in t)for(var l=0;l<t.sets.length;l++)o(e,t.sets[l],u,t),s="seq"===t.timeContainer?t.sets[l].end:Math.max(s,t.sets[l].end),u=t.sets[l];if("contents"in t){if("contents"in t)for(var c=0;c<t.contents.length;c++)o(e,t.contents[c],u,t),s="seq"===t.timeContainer?t.contents[c].end:Math.max(s,t.contents[c].end),u=t.contents[c]}else s=i?t.begin:Number.POSITIVE_INFINITY;null!==t.explicit_end&&null!==t.explicit_dur?t.end=Math.min(t.begin+t.explicit_dur,a+t.explicit_end):null===t.explicit_end&&null!==t.explicit_dur?t.end=t.begin+t.explicit_dur:null!==t.explicit_end&&null===t.explicit_dur?t.end=a+t.explicit_end:t.end=s,delete t.explicit_begin,delete t.explicit_dur,delete t.explicit_end,e._registerEvent(t)}function s(e){this.node=e}function u(){this.events=[],this.head=new l,this.body=null}function l(){this.styling=new c,this.layout=new g}function c(){this.styles={},this.initials={}}function f(){this.id=null,this.styleAttrs=null,this.styleRefs=null}function d(){this.styleAttrs=null}function g(){this.regions={}}function h(e,t){p.call(this,"image"),this.src=e,this.type=t}function p(e){this.kind=e}function m(e){this.id=e}function y(e){this.regionID=e}function E(e){this.styleAttrs=e}function v(e){this.sets=e}function _(e){this.contents=e}function T(e,t,n){this.explicit_begin=e,this.explicit_end=t,this.explicit_dur=n}function S(){p.call(this,"body")}function b(){p.call(this,"div")}function A(){p.call(this,"p")}function I(){p.call(this,"span")}function R(){p.call(this,"span")}function w(){p.call(this,"br")}function N(){}function C(){}function D(e){return e&&"xml:id"in e.attributes&&e.attributes["xml:id"].value||null}function O(e){return e&&"style"in e.attributes?e.attributes.style.value.split(" "):[]}function M(e,t){var n={};if(null!==e)for(var i in e.attributes){var a=e.attributes[i].uri+" "+e.attributes[i].local,o=r.byQName[a];if(void 0!==o){var s=o.parse(e.attributes[i].value);null!==s?(n[a]=s,o===r.byName.zIndex&&U(t,"zIndex attribute present but not used by IMSC1 since regions do not overlap")):Z(t,"Cannot parse styling attribute "+a+" --\\x3e "+e.attributes[i].value)}}return n}function P(e,t,n){for(var r in e.attributes)if(e.attributes[r].uri===t&&e.attributes[r].local===n)return e.attributes[r].value;return null}function L(e,t,n){var r,i=null;return null!==(r=/^(\\d+(?:\\.\\d+)?)f$/.exec(n))?null!==t&&(i=parseFloat(r[1])/t):null!==(r=/^(\\d+(?:\\.\\d+)?)t$/.exec(n))?null!==e&&(i=parseFloat(r[1])/e):null!==(r=/^(\\d+(?:\\.\\d+)?)ms$/.exec(n))?i=parseFloat(r[1])/1e3:null!==(r=/^(\\d+(?:\\.\\d+)?)s$/.exec(n))?i=parseFloat(r[1]):null!==(r=/^(\\d+(?:\\.\\d+)?)h$/.exec(n))?i=3600*parseFloat(r[1]):null!==(r=/^(\\d+(?:\\.\\d+)?)m$/.exec(n))?i=60*parseFloat(r[1]):null!==(r=/^(\\d{2,}):(\\d\\d):(\\d\\d(?:\\.\\d+)?)$/.exec(n))?i=3600*parseInt(r[1])+60*parseInt(r[2])+parseFloat(r[3]):null!==(r=/^(\\d{2,}):(\\d\\d):(\\d\\d)\\:(\\d{2,})$/.exec(n))&&null!==t&&(i=3600*parseInt(r[1])+60*parseInt(r[2])+parseInt(r[3])+(null===r[4]?0:parseInt(r[4])/t)),i}function x(e,t,n){for(;t.styleRefs.length>0;){var r=t.styleRefs.pop();r in e.styles?(x(e,e.styles[r],n),k(e.styles[r].styleAttrs,t.styleAttrs)):Z(n,"Non-existant style id referenced")}}function F(e,t,n,r){for(var i=t.length-1;i>=0;i--){var a=t[i];a in e.styles?k(e.styles[a].styleAttrs,n):Z(r,"Non-existant style id referenced")}}function k(e,t){for(var n in e)e.hasOwnProperty(n)&&(n in t||(t[n]=e[n]))}function U(e,t){if(e&&e.warn&&e.warn(t))throw t}function Z(e,t){if(e&&e.error&&e.error(t))throw t}function B(e,t){throw e&&e.fatal&&e.fatal(t),t}function G(e,t){for(var n,r=0,i=e.length-1;r<=i;){var a=e[n=Math.floor((r+i)/2)];if(a<t)r=n+1;else{if(!(a>t))return{found:!0,index:n};i=n-1}}return{found:!1,index:r}}e.fromXML=function(e,i,p){var m=t.parser(!0,{xmlns:!0}),y=[],E=[],v=[],_=0,T=null;m.onclosetag=function(e){if(y[0]instanceof N)null!==T.head&&null!==T.head.styling&&F(T.head.styling,y[0].styleRefs,y[0].styleAttrs,i),delete y[0].styleRefs;else if(y[0]instanceof c)for(var t in y[0].styles)y[0].styles.hasOwnProperty(t)&&x(y[0],y[0].styles[t],i);else if(y[0]instanceof A||y[0]instanceof I){if(y[0].contents.length>1){var r,a=[y[0].contents[0]];for(r=1;r<y[0].contents.length;r++)y[0].contents[r]instanceof R&&a[a.length-1]instanceof R?a[a.length-1].text+=y[0].contents[r].text:a.push(y[0].contents[r]);y[0].contents=a}y[0]instanceof I&&1===y[0].contents.length&&y[0].contents[0]instanceof R&&(y[0].text=y[0].contents[0].text,delete y[0].contents)}else y[0]instanceof s&&(y[0].node.uri===n.ns_tt&&"metadata"===y[0].node.local?_--:_>0&&p&&"onCloseTag"in p&&p.onCloseTag());v.shift(),E.shift(),y.shift()},m.ontext=function(e){if(void 0===y[0]);else if(y[0]instanceof I||y[0]instanceof A){if(y[0]instanceof I){var t=y[0].styleAttrs[r.byName.ruby.qname];if("container"===t||"textContainer"===t||"baseContainer"===t)return}var n=new R;n.initFromText(T,y[0],e,E[0],v[0],i),y[0].contents.push(n)}else y[0]instanceof s&&_>0&&p&&"onText"in p&&p.onText(e)},m.onopentag=function(e){var t=e.attributes["xml:space"];t?v.unshift(t.value):0===v.length?v.unshift("default"):v.unshift(v[0]);var a=e.attributes["xml:lang"];if(a?E.unshift(a.value):0===E.length?E.unshift(""):E.unshift(E[0]),e.uri===n.ns_tt)if("tt"===e.local)null!==T&&B(i,"Two <tt> elements at ("+this.line+","+this.column+")"),(T=new u).initFromNode(e,E[0],i),y.unshift(T);else if("head"===e.local)y[0]instanceof u||B(i,"Parent of <head> element is not <tt> at ("+this.line+","+this.column+")"),y.unshift(T.head);else if("styling"===e.local)y[0]instanceof l||B(i,"Parent of <styling> element is not <head> at ("+this.line+","+this.column+")"),y.unshift(T.head.styling);else if("style"===e.local){var o;y[0]instanceof c?((o=new f).initFromNode(e,i),o.id?T.head.styling.styles[o.id]=o:Z(i,"<style> element missing @id attribute"),y.unshift(o)):y[0]instanceof N?((o=new f).initFromNode(e,i),k(o.styleAttrs,y[0].styleAttrs),y.unshift(o)):B(i,"Parent of <style> element is not <styling> or <region> at ("+this.line+","+this.column+")")}else if("initial"===e.local){var m;if(y[0]instanceof c){for(var R in(m=new d).initFromNode(e,i),m.styleAttrs)m.styleAttrs.hasOwnProperty(R)&&(T.head.styling.initials[R]=m.styleAttrs[R]);y.unshift(m)}else B(i,"Parent of <initial> element is not <styling> at ("+this.line+","+this.column+")")}else if("layout"===e.local)y[0]instanceof l||B(i,"Parent of <layout> element is not <head> at "+this.line+","+this.column+")"),y.unshift(T.head.layout);else if("region"===e.local){y[0]instanceof g||B(i,"Parent of <region> element is not <layout> at "+this.line+","+this.column+")");var D=new N;D.initFromNode(T,e,E[0],i),!D.id||D.id in T.head.layout.regions?Z(i,"Ignoring <region> with duplicate or missing @id at "+this.line+","+this.column+")"):T.head.layout.regions[D.id]=D,y.unshift(D)}else if("body"===e.local){y[0]instanceof u||B(i,"Parent of <body> element is not <tt> at "+this.line+","+this.column+")"),null!==T.body&&B(i,"Second <body> element at "+this.line+","+this.column+")");var O=new S;O.initFromNode(T,e,E[0],i),T.body=O,y.unshift(O)}else if("div"===e.local){y[0]instanceof b||y[0]instanceof S||B(i,"Parent of <div> element is not <body> or <div> at "+this.line+","+this.column+")");var M=new b;M.initFromNode(T,y[0],e,E[0],i);var P=M.styleAttrs[r.byName.backgroundImage.qname];P&&(M.contents.push(new h(P)),delete M.styleAttrs[r.byName.backgroundImage.qname]),y[0].contents.push(M),y.unshift(M)}else if("image"===e.local){y[0]instanceof b||B(i,"Parent of <image> element is not <div> at "+this.line+","+this.column+")");var L=new h;L.initFromNode(T,y[0],e,E[0],i),y[0].contents.push(L),y.unshift(L)}else if("p"===e.local){y[0]instanceof b||B(i,"Parent of <p> element is not <div> at "+this.line+","+this.column+")");var x=new A;x.initFromNode(T,y[0],e,E[0],i),y[0].contents.push(x),y.unshift(x)}else if("span"===e.local){y[0]instanceof I||y[0]instanceof A||B(i,"Parent of <span> element is not <span> or <p> at "+this.line+","+this.column+")");var F=new I;F.initFromNode(T,y[0],e,E[0],v[0],i),y[0].contents.push(F),y.unshift(F)}else if("br"===e.local){y[0]instanceof I||y[0]instanceof A||B(i,"Parent of <br> element is not <span> or <p> at "+this.line+","+this.column+")");var U=new w;U.initFromNode(T,y[0],e,E[0],i),y[0].contents.push(U),y.unshift(U)}else if("set"===e.local){y[0]instanceof I||y[0]instanceof A||y[0]instanceof b||y[0]instanceof S||y[0]instanceof N||y[0]instanceof w||B(i,"Parent of <set> element is not a content element or a region at "+this.line+","+this.column+")");var G=new C;G.initFromNode(T,y[0],e,i),y[0].sets.push(G),y.unshift(G)}else y.unshift(new s(e));else y.unshift(new s(e));if(y[0]instanceof s)if(e.uri===n.ns_tt&&"metadata"===e.local)_++;else if(_>0&&p&&"onOpenTag"in p){var q=[];for(var Y in e.attributes)q[e.attributes[Y].uri+" "+e.attributes[Y].local]={uri:e.attributes[Y].uri,local:e.attributes[Y].local,value:e.attributes[Y].value};p.onOpenTag(e.uri,e.local,q)}},m.write(e).close(),delete T.head.styling.styles;var D=!1;for(var O in T.head.layout.regions)if(T.head.layout.regions.hasOwnProperty(O)){D=!0;break}if(!D){var M=N.prototype.createDefaultRegion(T.lang);T.head.layout.regions[M.id]=M}for(var P in T.head.layout.regions)T.head.layout.regions.hasOwnProperty(P)&&o(T,T.head.layout.regions[P],null,null);return T.body&&o(T,T.body,null,null),T.body&&a(T.body),T},u.prototype.initFromNode=function(e,t,r){var a=function(e,t){var r=P(e,n.ns_ttp,"cellResolution"),i=15,a=32;if(null!==r){var o=/(\\d+) (\\d+)/.exec(r);null!==o?(a=parseInt(o[1]),i=parseInt(o[2])):U(t,"Malformed cellResolution value (using initial value instead)")}return{w:a,h:i}}(e,r);this.cellLength={h:new i.ComputedLength(0,1/a.h),w:new i.ComputedLength(1/a.w,0)};var o=function(e,t){var r,i=P(e,n.ns_ttp,"frameRate"),a=30;null!==i&&(null!==(r=/(\\d+)/.exec(i))?a=parseInt(r[1]):U(t,"Malformed frame rate attribute (using initial value instead)"));var o=P(e,n.ns_ttp,"frameRateMultiplier"),s=1;null!==o&&(null!==(r=/(\\d+) (\\d+)/.exec(o))?s=parseInt(r[1])/parseInt(r[2]):U(t,"Malformed frame rate multiplier attribute (using initial value instead)"));var u=s*a,l=1,c=P(e,n.ns_ttp,"tickRate");return null===c?null!==i&&(l=u):null!==(r=/(\\d+)/.exec(c))?l=parseInt(r[1]):U(t,"Malformed tick rate attribute (using initial value instead)"),{effectiveFrameRate:u,tickRate:l}}(e,r);this.effectiveFrameRate=o.effectiveFrameRate,this.tickRate=o.tickRate,this.aspectRatio=function(e,t){var r=P(e,n.ns_ittp,"aspectRatio");null===r&&(r=P(e,n.ns_ttp,"displayAspectRatio"));var i=null;if(null!==r){var a=/(\\d+)\\s+(\\d+)/.exec(r);if(null!==a){var o=parseInt(a[1]),s=parseInt(a[2]);0!==o&&0!==s?i=o/s:Z(t,"Illegal aspectRatio values (ignoring)")}else Z(t,"Malformed aspectRatio attribute (ignoring)")}return i}(e,r);var s=P(e,n.ns_ttp,"timeBase");null!==s&&"media"!==s&&B(r,"Unsupported time base");var u=function(e,t){var r=P(e,n.ns_tts,"extent");if(null===r)return null;var a=r.split(" ");if(2!==a.length)return U(t,"Malformed extent (ignoring)"),null;var o=i.parseLength(a[0]),s=i.parseLength(a[1]);return s&&o?{h:s,w:o}:(U(t,"Malformed extent values (ignoring)"),null)}(e,r);null===u?this.pxLength={h:null,w:null}:("px"===u.h.unit&&"px"===u.w.unit||B(r,"Extent on TT must be in px or absent"),this.pxLength={h:new i.ComputedLength(0,1/u.h.value),w:new i.ComputedLength(1/u.w.value,0)}),this.dimensions={h:new i.ComputedLength(0,1),w:new i.ComputedLength(1,0)},this.lang=t},u.prototype._registerEvent=function(e){if(!(e.end<=e.begin)){var t=G(this.events,e.begin);if(t.found||this.events.splice(t.index,0,e.begin),e.end!==Number.POSITIVE_INFINITY){var n=G(this.events,e.end);n.found||this.events.splice(n.index,0,e.end)}}},u.prototype.getMediaTimeRange=function(){return[this.events[0],this.events[this.events.length-1]]},u.prototype.getMediaTimeEvents=function(){return this.events},f.prototype.initFromNode=function(e,t){this.id=D(e),this.styleAttrs=M(e,t),this.styleRefs=O(e)},d.prototype.initFromNode=function(e,t){for(var r in this.styleAttrs={},e.attributes)if(e.attributes[r].uri===n.ns_itts||e.attributes[r].uri===n.ns_ebutts||e.attributes[r].uri===n.ns_tts){var i=e.attributes[r].uri+" "+e.attributes[r].local;this.styleAttrs[i]=e.attributes[r].value}},h.prototype.initFromNode=function(e,t,n,r,i){this.src="src"in n.attributes?n.attributes.src.value:null,this.src||Z(i,"Invalid image@src attribute"),this.type="type"in n.attributes?n.attributes.type.value:null,this.type||Z(i,"Invalid image@type attribute"),E.prototype.initFromNode.call(this,e,t,n,i),T.prototype.initFromNode.call(this,e,t,n,i),v.prototype.initFromNode.call(this,e,t,n,i),y.prototype.initFromNode.call(this,e,t,n,i),this.lang=r},m.prototype.initFromNode=function(e,t,n,r){this.id=D(n)},y.prototype.initFromNode=function(e,t,n,r){this.regionID=function(e){return e&&"region"in e.attributes?e.attributes.region.value:""}(n)},E.prototype.initFromNode=function(e,t,n,r){this.styleAttrs=M(n,r),null!==e.head&&null!==e.head.styling&&F(e.head.styling,O(n),this.styleAttrs,r)},v.prototype.initFromNode=function(e,t,n,r){this.sets=[]},_.prototype.initFromNode=function(e,t,n,r){this.contents=[]},T.prototype.initFromNode=function(e,t,n,r){var i=function(e,t,n,r){var i=null;n&&"begin"in n.attributes&&null===(i=L(e.tickRate,e.effectiveFrameRate,n.attributes.begin.value))&&U(r,"Malformed begin value "+n.attributes.begin.value+" (using 0)");var a=null;n&&"dur"in n.attributes&&null===(a=L(e.tickRate,e.effectiveFrameRate,n.attributes.dur.value))&&U(r,"Malformed dur value "+n.attributes.dur.value+" (ignoring)");var o=null;return n&&"end"in n.attributes&&null===(o=L(e.tickRate,e.effectiveFrameRate,n.attributes.end.value))&&U(r,"Malformed end value (ignoring)"),{explicit_begin:i,explicit_end:o,explicit_dur:a}}(e,0,n,r);this.explicit_begin=i.explicit_begin,this.explicit_end=i.explicit_end,this.explicit_dur=i.explicit_dur,this.timeContainer=function(e,t){var n=e&&"timeContainer"in e.attributes?e.attributes.timeContainer.value:null;return n&&"par"!==n?"seq"===n?"seq":(Z(t,"Illegal value of timeContainer (assuming \'par\')"),"par"):"par"}(n,r)},S.prototype.initFromNode=function(e,t,n,r){E.prototype.initFromNode.call(this,e,null,t,r),T.prototype.initFromNode.call(this,e,null,t,r),v.prototype.initFromNode.call(this,e,null,t,r),y.prototype.initFromNode.call(this,e,null,t,r),_.prototype.initFromNode.call(this,e,null,t,r),this.lang=n},b.prototype.initFromNode=function(e,t,n,r,i){E.prototype.initFromNode.call(this,e,t,n,i),T.prototype.initFromNode.call(this,e,t,n,i),v.prototype.initFromNode.call(this,e,t,n,i),y.prototype.initFromNode.call(this,e,t,n,i),_.prototype.initFromNode.call(this,e,t,n,i),this.lang=r},A.prototype.initFromNode=function(e,t,n,r,i){E.prototype.initFromNode.call(this,e,t,n,i),T.prototype.initFromNode.call(this,e,t,n,i),v.prototype.initFromNode.call(this,e,t,n,i),y.prototype.initFromNode.call(this,e,t,n,i),_.prototype.initFromNode.call(this,e,t,n,i),this.lang=r},I.prototype.initFromNode=function(e,t,n,r,i,a){E.prototype.initFromNode.call(this,e,t,n,a),T.prototype.initFromNode.call(this,e,t,n,a),v.prototype.initFromNode.call(this,e,t,n,a),y.prototype.initFromNode.call(this,e,t,n,a),_.prototype.initFromNode.call(this,e,t,n,a),this.space=i,this.lang=r},R.prototype.initFromText=function(e,t,n,r,i,a){T.prototype.initFromNode.call(this,e,t,null,a),this.text=n,this.space=i,this.lang=r},w.prototype.initFromNode=function(e,t,n,r,i){y.prototype.initFromNode.call(this,e,t,n,i),T.prototype.initFromNode.call(this,e,t,n,i),this.lang=r},N.prototype.createDefaultRegion=function(e){var t=new N;return m.call(t,""),E.call(t,{}),v.call(t,[]),T.call(t,0,Number.POSITIVE_INFINITY,null),this.lang=e,t},N.prototype.initFromNode=function(e,t,n,r){m.prototype.initFromNode.call(this,e,null,t,r),T.prototype.initFromNode.call(this,e,null,t,r),v.prototype.initFromNode.call(this,e,null,t,r),this.styleAttrs=M(t,r),this.styleRefs=O(t),this.lang=n},C.prototype.initFromNode=function(e,t,n,r){T.prototype.initFromNode.call(this,e,t,n,r);var i=M(n,r);for(var a in this.qname=null,this.value=null,i)if(i.hasOwnProperty(a)){if(this.qname){Z(r,"More than one style specified on set");break}this.qname=a,this.value=i[a]}}}(t,"undefined"==typeof sax?n(5378):sax,"undefined"==typeof imscNames?n(210):imscNames,"undefined"==typeof imscStyles?n(6811):imscStyles,"undefined"==typeof imscUtils?n(5926):imscUtils)},506:function(e,t,n){var r=/firefox/i.test(navigator.userAgent);!function(e,t,n){function i(e,t,f,g){var h;if("region"===f.kind)(h=document.createElement("div")).style.position="absolute";else if("body"===f.kind)h=document.createElement("div");else if("div"===f.kind)h=document.createElement("div");else if("image"===f.kind){if(h=document.createElement("img"),null!==e.imgResolver&&null!==f.src){var y=e.imgResolver(f.src,h);y&&(h.src=y),h.height=e.regionH,h.width=e.regionW}}else if("p"===f.kind)h=document.createElement("p");else if("span"===f.kind)if("container"===f.styleAttrs[n.byName.ruby.qname])h=document.createElement("ruby"),e.ruby=!0;else if("base"===f.styleAttrs[n.byName.ruby.qname])h=document.createElement("span");else if("text"===f.styleAttrs[n.byName.ruby.qname])h=document.createElement("rt");else if("baseContainer"===f.styleAttrs[n.byName.ruby.qname])h=document.createElement("rbc");else if("textContainer"===f.styleAttrs[n.byName.ruby.qname])h=document.createElement("rtc");else{if("delimiter"===f.styleAttrs[n.byName.ruby.qname])return;h=document.createElement("span")}else"br"===f.kind&&(h=document.createElement("br"));if(h){if(f.lang&&("region"!==f.kind&&f.lang===g.lang||(h.lang=f.lang)),t.appendChild(h),h.style.margin="0","region"===f.kind){var _=f.styleAttrs[n.byName.writingMode.qname];"lrtb"===_||"lr"===_?(e.ipd="lr",e.bpd="tb"):"rltb"===_||"rl"===_?(e.ipd="rl",e.bpd="tb"):"tblr"===_?(e.ipd="tb",e.bpd="lr"):"tbrl"!==_&&"tb"!==_||(e.ipd="tb",e.bpd="rl")}else if("p"===f.kind&&"tb"===e.bpd){var T=f.styleAttrs[n.byName.direction.qname];e.ipd="ltr"===T?"lr":"rl"}for(var S=0;S<d.length;S++){var b=d[S],A=f.styleAttrs[b.qname];void 0!==A&&null!==b.map&&b.map(e,h,f,A)}var I=h,R=f.styleAttrs[n.byName.linePadding.qname];if(R&&!R.isZero()){var w=R.toUsedLength(e.w,e.h);if(w>0){var N=Math.ceil(w)+"px";"tb"===e.bpd?(I.style.paddingLeft=N,I.style.paddingRight=N):(I.style.paddingTop=N,I.style.paddingBottom=N),e.lp=R}}var C=f.styleAttrs[n.byName.multiRowAlign.qname];if(C&&"auto"!==C){var D=document.createElement("span");D.style.display="inline-block",D.style.textAlign=C,h.appendChild(D),I=D,e.mra=C}var O=f.styleAttrs[n.byName.rubyReserve.qname];if(O&&"none"!==O[0]&&(e.rubyReserve=O),f.styleAttrs[n.byName.fillLineGap.qname]&&(e.flg=!0),"span"===f.kind&&f.text){var M=f.styleAttrs[n.byName.textEmphasis.qname];if(M&&"none"!==M.style&&(e.textEmphasis=!0),n.byName.textCombine.qname in f.styleAttrs&&"all"===f.styleAttrs[n.byName.textCombine.qname])h.textContent=f.text,h._isd_element=f,M&&c(e,h,0,M);else for(var P="",L=0;L<f.text.length;L++){P+=f.text.charAt(L);var x=f.text.charCodeAt(L);if(x<55296||x>56319||L===f.text.length-1){var F=document.createElement("span");F.textContent=P,M&&c(e,F,0,M),h.appendChild(F),P="",F._isd_element=f}}}if("contents"in f)for(var k=0;k<f.contents.length;k++)i(e,I,f.contents[k],f);var U=[];if("p"===f.kind&&(l(e,I,U,null),e.rubyReserve&&(function(e,t){for(var n=0;n<e.length;n++){var r,i,a=document.createElement("ruby"),o=document.createElement("span");o.textContent="​",a.appendChild(o);var s,u=t.rubyReserve[1].toUsedLength(t.w,t.h)+"px";"both"===t.rubyReserve[0]||"outside"===t.rubyReserve[0]&&1==e.length?((r=document.createElement("rtc")).style[m]=p?"after":"under",r.textContent="​",r.style.fontSize=u,(i=document.createElement("rtc")).style[m]=p?"before":"over",i.textContent="​",i.style.fontSize=u,a.appendChild(r),a.appendChild(i)):((r=document.createElement("rtc")).textContent="​",r.style.fontSize=u,s="after"===t.rubyReserve[0]||"outside"===t.rubyReserve[0]&&n>0?p?"after":"tb"===t.bpd||"rl"===t.bpd?"under":"over":p?"before":"tb"===t.bpd||"rl"===t.bpd?"over":"under",r.style[m]=s,a.appendChild(r));for(var l=null,c=0;c<e[n].rbc.length;c++)if("ruby"===e[n].rbc[c].localName){l=e[n].rbc[c];for(var f=0;f<l.style.length;f++)a.style.setProperty(l.style.item(f),l.style.getPropertyValue(l.style.item(f)));break}(l=l||e[n].elements[0].node).parentElement.insertBefore(a,l)}}(U,e),e.rubyReserve=null),(e.ruby||e.rubyReserve)&&(function(e,t){for(var n=0;n<e.length;n++)for(var r=0;r<e[n].rbc.length;r++){var i;e[n].rbc[r].style[m]||(i=p?0===n?"before":"after":"tb"===t.bpd||"rl"===t.bpd?0===n?"over":"under":0===n?"under":"over",e[n].rbc[r].style[m]=i)}}(U,e),e.ruby=null),e.textEmphasis&&(function(e,t){for(var n=0;n<e.length;n++)for(var r=0;r<e[n].te.length;r++){var i;e[n].te[r].style[E]&&"none"!==e[n].te[r].style[E]||(i="tb"===t.bpd?0===n?"left over":"left under":"rl"===t.bpd?0===n?"right under":"left under":0===n?"left under":"right under",e[n].te[r].style[E]=i)}}(U,e),e.textEmphasis=null),e.mra&&(function(e){for(var t=0;t<e.length-1;t++){var n=e[t].elements.length;if(0!==n&&!1===e[t].br){var r=document.createElement("br"),i=e[t].elements[n-1].node;i.parentElement.insertBefore(r,i.nextSibling)}}}(U),e.mra=null),e.lp&&(function(e,t,n){if(null!==e)for(var i=0;i<e.length;i++){var a=e[i].elements.length,o=Math.ceil(t)+"px",s="-"+Math.ceil(t)+"px";if(0!==a){var u=e[i].elements[e[i].start_elem],l=e[i].elements[e[i].end_elem];if(u===l){var c=u.node.getBoundingClientRect();if(0==c.width||0==c.height)continue}"lr"===n.ipd?(u.node.style.marginLeft=s,u.node.style.paddingLeft=o):"rl"===n.ipd?(u.node.style.paddingRight=o,u.node.style.marginRight=s):"tb"===n.ipd&&(u.node.style.paddingTop=o,u.node.style.marginTop=s),"lr"===n.ipd?(r||(l.node.style.marginRight=s),l.node.style.paddingRight=o):"rl"===n.ipd?(l.node.style.paddingLeft=o,r||(l.node.style.marginLeft=s)):"tb"===n.ipd&&(l.node.style.paddingBottom=o,l.node.style.marginBottom=s)}}}(U,e.lp.toUsedLength(e.w,e.h),e),e.lp=null),function(e,t){for(var n=0;n<e.length;n++)for(var r=e[n],i=1;i<r.elements.length;){var s=r.elements[i-1],u=r.elements[i];o(s.node,u.node,t)?r.elements.splice(i,1):i++}for(var l,c,f=[],d=0;d<e.length;d++)for(var g=0;g<e[d].elements.length;g++)(c=a(l=e[d].elements[g].node,f,!1))&&(l.style.backgroundColor=c);for(var h=0;h<f.length;h++)f[h].style.backgroundColor=""}(U,e),e.flg)){var Z=u(I.getBoundingClientRect(),e);!function(e,t,n,r,i){for(var a=Math.sign(n-t),o=0;o<=e.length;o++){var s,u,l,c;if(s=0===o?Math.round(t):o===e.length?Math.round(n):Math.round((e[o-1].after+e[o].before)/2),o>0&&e[o-1])for(l=0;l<e[o-1].elements.length;l++)u=a*(s-(c=e[o-1].elements[l]).after)+"px","lr"===r.bpd?c.node.style.paddingRight=u:"rl"===r.bpd?c.node.style.paddingLeft=u:"tb"===r.bpd&&(c.node.style.paddingBottom=u);if(o<e.length)for(l=0;l<e[o].elements.length;l++)u=a*((c=e[o].elements[l]).before-s)+"px","lr"===r.bpd?c.node.style.paddingLeft=u:"rl"===r.bpd?c.node.style.paddingRight=u:"tb"===r.bpd&&(c.node.style.paddingTop=u)}}(U,Z.before,Z.after,e),e.flg=null}if("region"===f.kind&&"tb"===e.bpd&&e.enableRollUp&&f.contents.length>0&&"after"===f.styleAttrs[n.byName.displayAlign.qname]){l(e,I,U,null);var B=new s(""===f.id?"_":f.id,U);if(e.currentISDState[B.id]=B,e.previousISDState&&B.id in e.previousISDState&&e.previousISDState[B.id].plist.length>0&&B.plist.length>1&&B.plist[B.plist.length-2].text===e.previousISDState[B.id].plist[e.previousISDState[B.id].plist.length-1].text){var G=h.firstElementChild,q=B.plist[B.plist.length-1].after-B.plist[B.plist.length-1].before;G.style.bottom="-"+q+"px",G.style.transition="transform 0.4s",G.style.position="relative",G.style.transform="translateY(-"+q+"px)"}}}else v(e.errorHandler,"Error processing ISD element kind: "+f.kind)}function a(e,t,n){return e.style.backgroundColor?(n&&!t.includes(e)&&t.push(e),e.style.backgroundColor):"SPAN"===e.parentElement.nodeName||"RUBY"===e.parentElement.nodeName||"RBC"===e.parentElement.nodeName||"RTC"===e.parentElement.nodeName||"RT"===e.parentElement.nodeName?a(e.parentElement,t,!0):void 0}function o(e,t,n){if("SPAN"===e.tagName&&"SPAN"===t.tagName&&e._isd_element===t._isd_element){if(!e._isd_element)return v(n.errorHandler,"Internal error: HTML span is not linked to a source element; cannot merge spans."),!1;e.textContent+=t.textContent;for(var r=0;r<t.style.length;r++){var i=t.style[r];(i.indexOf("border")>=0||i.indexOf("padding")>=0||i.indexOf("margin")>=0)&&(e.style[i]=t.style[i])}return t.parentElement.removeChild(t),!0}return!1}function s(e,t){this.id=e,this.plist=t}function u(e,t){var n={before:null,after:null,start:null,end:null};return"tb"===t.bpd?(n.before=e.top,n.after=e.bottom,"lr"===t.ipd?(n.start=e.left,n.end=e.right):(n.start=e.right,n.end=e.left)):"lr"===t.bpd?(n.before=e.left,n.after=e.right,n.start=e.top,n.end=e.bottom):"rl"===t.bpd&&(n.before=e.right,n.after=e.left,n.start=e.top,n.end=e.bottom),n}function l(e,t,n,r){if("rt"!==t.localName&&"rtc"!==t.localName){var i,a,o,s,c=t.style.backgroundColor||r;if(0===t.childElementCount)if("span"===t.localName||"rb"===t.localName){var f=u(t.getBoundingClientRect(),e);if(0!==n.length&&(i=f.before,a=f.after,o=n[n.length-1].before,a<(s=n[n.length-1].after)&&i>o||s<=a&&o>=i)){var d=Math.sign(f.after-f.before),g=Math.sign(f.end-f.start);d*(f.before-n[n.length-1].before)<0&&(n[n.length-1].before=f.before),d*(f.after-n[n.length-1].after)>0&&(n[n.length-1].after=f.after),g*(f.start-n[n.length-1].start)<0&&(n[n.length-1].start=f.start,n[n.length-1].start_elem=n[n.length-1].elements.length),g*(f.end-n[n.length-1].end)>0&&(n[n.length-1].end=f.end,n[n.length-1].end_elem=n[n.length-1].elements.length)}else n.push({before:f.before,after:f.after,start:f.start,end:f.end,start_elem:0,end_elem:0,elements:[],rbc:[],te:[],text:"",br:!1});n[n.length-1].text+=t.textContent,n[n.length-1].elements.push({node:t,bgcolor:c,before:f.before,after:f.after})}else"br"===t.localName&&0!==n.length&&(n[n.length-1].br=!0);else for(var h=t.firstChild;h;)h.nodeType===Node.ELEMENT_NODE&&(l(e,h,n,c),"ruby"===h.localName||"rtc"===h.localName?n.length>0&&n[n.length-1].rbc.push(h):"span"===h.localName&&h.style[y]&&"none"!==h.style[y]&&n.length>0&&n[n.length-1].te.push(h)),h=h.nextSibling}}function c(e,t,n,r){var i;"none"!==r.style&&("auto"===r.style?t.style[y]="filled":t.style[y]=r.style+" "+r.symbol,("before"===r.position||"after"===r.position)&&(i="tb"===e.bpd?"before"===r.position?"left over":"left under":"rl"===e.bpd?"before"===r.position?"right under":"left under":"before"===r.position?"left under":"right under",t.style[E]=i))}function f(e,t){this.qname=e,this.map=t}e.render=function(e,t,n,r,a,o,s,u,l){var c=r||t.clientHeight,f=a||t.clientWidth;if(null!==e.aspectRatio){var d=c*e.aspectRatio;d>f?c=Math.round(f/e.aspectRatio):f=d}var g=document.createElement("div");g.style.position="relative",g.style.width=f+"px",g.style.height=c+"px",g.style.margin="auto",g.style.top=0,g.style.bottom=0,g.style.left=0,g.style.right=0,g.style.zIndex=0;var h={h:c,w:f,regionH:null,regionW:null,imgResolver:n,displayForcedOnlyMode:o||!1,isd:e,errorHandler:s,previousISDState:u,enableRollUp:l||!1,currentISDState:{},flg:null,lp:null,mra:null,ipd:null,bpd:null,ruby:null,textEmphasis:null,rubyReserve:null};if(t.appendChild(g),"contents"in e)for(var p=0;p<e.contents.length;p++)i(h,g,e.contents[p],e);return h.currentISDState};for(var d=[new f("http://www.w3.org/ns/ttml#styli