"""Simple model end tools to record tweets"""

VERSION = (0, 82, 0, "final", 0)

VERSION_STR = ".".join(map(lambda i:"%02d" % (i,), VERSION[:2]))


def get_version():
    version = '%s.%s' % (VERSION[0], VERSION[1])
    if VERSION[2]:
        version = '%s.%s' % (version, VERSION[2])
    if VERSION[3:] == ('alpha', 0):
        version = '%s pre-alpha' % version
    else:
        if VERSION[3] != 'final':
            version = '%s %s %s' % (version, VERSION[3], VERSION[4])
    return version

__version__ = get_version()
__author__ = "Yves-Marie Haussonne"
__contact__ = "ymh.work@gmail.com"
__homepage__ = ""
__docformat__ = "restructuredtext"


"""
 .. data:: USER_AGENT

     The default user agent string for stream objects
"""

USER_AGENT = "IRITweet %s" % __version__


class IRITweetError(Exception):
    """Base class for all IRITweet errors"""
    pass


class AuthenticationError(IRITweetError):
    """Exception raised if the username/password is not accepted"""
    pass


class ConnectionError(IRITweetError):
    """Raised when there are network problems. This means when there are
    dns errors, network errors, twitter issues"""

    def __init__(self, reason, details=None):
        self.reason = reason
        self.details = details

    def __str__(self):
        return '<ConnectionError %s>' % self.reason
