<?php
$config = array(
    'event_list' => array(
        'enmi15/session-1',
        'enmi15/session-2',
        'enmi15/session-3',
        'enmi15/session-4',
    ),
    'hashtag'    => '#enmi15',

    'title' => 'Entretiens du Nouveau Monde Industriel 2015',

    'abstract'   => "<b>LA TOILE QUE NOUS VOULONS</b><br>Du web sémantique au web herméneutique<br><em>Paris. Centre Pompidou. Grande Salle.<br>14 et 15 décembre 2015</em>",

    'description' => "<h3>LA TOILE QUE NOUS VOULONS</h3>
    <h4>Du web sémantique au web herméneutique</h4>
    <p>Paris. Centre Pompidou. Grande Salle.<br>
    14 et 15 décembre 2015<br>
    <a href=\"http://enmi-conf.org\" target=\"_blank\">http://enmi-conf.org</a>
    </p>
    <br>
    <strong>9ème édition</strong>
    <p>Au printemps 2014, dans le sillage des effets provoqués par les révélations d’Edward Snowden, Tim Berners Lee et le W3C lançaient l’initiative « The Web We Want ».
    C’est dans la suite de cette démarche que l’IRI a proposé à ses partenaires (Cap digital, France Télévisions, Strate Ecole de Design, Institut Mines-Télécom, W3C)
    de consacrer la neuvième édition des Entretiens du nouveau monde industriel à l’hypothèse d’une refondation et d’une réinvention du World Wide Web,
    et sous le titre « La toile que nous voulons » – la toile que l’on perçoit désormais aussi bien comme le dispositif de capture de l’araignée que comme l’écran de projection d’un avenir meilleur.
    </p>
    <br>
    <h3>Programme</h3>
    <br>
    <p><strong>Lundi 14 décembre</strong></p>
    <p><strong>9h30 : 9h45 - Ouverture</strong></p>
    <p>
        <ul>
          <li><p>par <strong>Serge Lasvignes</strong>, Président du Centre Georges Pompidou</p></li>
        </ul>
    </p>
    <p><strong>9h45 - 10h15 : Table-ronde introductive avec Xavier de La Porte de Rue 89</strong></p>
    <p>
        <ul>
          <li><p><strong>Axelle Lemaire</strong>, Secrétaire d’Etat chargée du numérique</p></li>
          <li><p><strong>Bernard Stiegler</strong>, Directeur de l’Institut de Recherche et d’Innovation</p></li>
          <li><p><strong>Dominique Cardon</strong>, Sociologue</p></li>
        </ul>
    </p>
    <br>
    <p><strong>10h15 : 13h00 - Session 1 : Anthropocène et entropie du web</strong></p>
    <p>En 1993, le World Wide Web fut conçu au sein du CERN en vue d’instrumenter des relations entre pairs éditeurs, contribuant par leur activité à enrichir les savoirs et débats publics de controverses fécondes, c’est à dire, dans un langage systémique, de bifurcations néguentropiques. Ce n’est pas internet mais le World Wide Web qui, avec Mosaic, puis avec Netscape, a permis la constitution d’une réticulation planétaire à laquelle, vingt deux ans plus tard, sont connectés près de trois milliards d’êtres humains, et où sont apparues de nouvelles plateformes.
    <br>Désormais, cette connectivité généralisée reconduit le plus souvent à une standardisation massive des relations – c’est à dire aussi à une augmentation de l’entropie cognitive. Dans le contexte où l’Anthropocène, qui constitue désormais le cadre des négociations internationales, notamment quant au changement climatique, est toxique pour lui-même en ce qu’il augmente massivement le taux d’entropie thermodynamique dans la biosphère, le web ne pourrait-il pas et ne devrait-il pas être repensé en vue de réactiver sa capacité initiale à intensifier la qualité à la fois des savoirs, des débats publics et des économies industrielles elles-mêmes ?</p>
    <ul>
        <li>
            <p><strong>10h15</strong>&nbsp;: <strong>Bernard Stiegler</strong> (IRI)</p>
            <p>Le WEB dans l’anthropocène</p>
        </li>
        <li>
            <p><strong>10h30</strong>&nbsp;:  <strong>Evgeny Morozov</strong> (journaliste, écrivain)</p>
        </li>
        <li>
            <p><strong>11h45</strong>&nbsp;: <strong>Dominique Cardon</strong> (Orange Labs, université de Marne la Vallée)</p>
            <p>Le bazar et les algorithmes : à propos de l’espace public numérique</p>
        </li>
        <li>
            <p><strong>12h30</strong>&nbsp;: <strong>Guiseppe Longo</strong> (ENS)</p>
            <p>De la collaboration des diversités à la compétition vers l’identique : les très grandes bases de données et les régularités sans sens</p>
        </li>
    </ul>
    <br>
    <p><strong>Lundi 14 décembre</strong></p>
    <p><strong>14h30 : 19h00 - Session 2 : Architecture, traces et modèles de valeur</strong></p>
    <p>Comment réarchitecturer le Web dans une telle perspective « néguentropique » ? Le protocole de transfert HTTP et le format de données HTML ont rendu possible sur la base du protocole TCP/IP la constitution de pages et de sites web qui se sont multipliés de façon exponentielle lorsque que le Web est devenu accessible à tous. Les investissements dans des infrastructures capables d’assurer les services et les trafics qui se sont imposés ont mis le marché au cœur du réseau, le ramenant de plus en plus près des modèles d’audiences propres aux médias de masse.
    <br>De nos jours, des architectures nouvelles émergent, telle la blockchain à la base du bitcoin, dans un contexte où se développent l’open access scientifique, les plateformes d’annotation contributive, qui relancent des questions posées dès les années 1960 par Ted Nelson et Douglas Engelbart, tandis que les modèles de territoires augmentés et d’industrie 4.0 conduisent vers de nouveaux scénarios de valorisation des traces qui bouleversent les fondements des sociétés industrielles configurées au XXè siècle.</p>
    <ul>
        <li>
            <p><strong>14h30</strong>&nbsp;: <strong>Julian Assange</strong> (Wikileaks - par conférence vidéo)</p>
        </li>
        <li>
            <p><i>Débat</i></p>
        </li>
        <li>
            <p><strong>16h00</strong>&nbsp;: <strong>Christian Fauré</strong> (Octo technologies - Ars Industrialis)</p>
        </li>
        <li>
            <p><strong>16h45</strong>&nbsp;: <strong>Pierre Guehenneux</strong> (Vinci construction)</p>
            <p>BTP du futur, accélérateur du nouveau monde industriel européen</p>
        </li>
        <li>
            <p><strong>17h30</strong>&nbsp;: <i>Pause/Débat</i></p>
        </li>
        <li>
            <p><strong>18h00</strong>&nbsp;: <strong>Yuk Hui</strong> (Leuphana Un)</p>
            <p>Le concept de groupe dans les réseaux sociaux</p>
        </li>
        <li>
            <p><strong>18h30</strong>&nbsp;: <strong>Harry Halpin</strong> (Inria, projet NextLeap)</p>
        </li>
    </ul>
    <br>
    <p><strong>Mardi 15 décembre</strong></p>
    <p><strong>09h30 : 12h45 - Session 3 : Espace public, études digitales et éditorialisation</strong></p>
    <p>Les big data configurent un processus social qui a été décrit par Thomas Berns et Antoinette Rouvroy comme l’avènement d’une gouvernementalité algorithmique. Outre la crise de la science statistique et de l’épistémè contemporaine (c’est à dire de l’articulation entre les savoir-faire, les savoir vivre et les savoirs académiques) que provoque le corrélationnisme des mathématiques algorithmiquement appliquées, la gouvernementalité algorithmique s’achemine vers l’époque du deep learning.
    <br>Comment concevoir des agencements entre artifices computationnels et actions rationnelles des individus psychiques et collectifs qui ne conduisent pas à la standardisation massive des comportements et des représentations – c’est à dire à l’effondrement des capacités néguentropiques caractéristiques de l’homme ?</p>
    <ul>
        <li>
            <p><strong>9h30</strong>&nbsp;: <strong>Olivier Grise</strong> (Inria)</p>
            <p>Modélisation prédictive et Deep Learning</p>
        </li>
        <li>
            <p><strong>10h00</strong>&nbsp;: <strong>David Berry</strong> (Université de Sussex)</p>
            <p>Algorithms, Big Data, and Critical Theory</p>
        </li>
        <li>
            <p><strong>10h30</strong>&nbsp;: <i>Discussion</i></p>
        </li>
        <li>
            <p><strong>11h00</strong>&nbsp;: <i>Pause</i></p>
        </li>
        <li>
            <p><strong>11h15</strong>&nbsp;: <strong>Thomas Berns</strong> (Université libre de Bruxelles)</p>
            <p>La réflexivité algorithmique</p>
        </li>
        <li>
            <p><strong>12h00</strong>&nbsp;: <strong>Paul Jorion</strong> (Anthropologue)</p>
            <p>La mise à l’écart de l’homme par la machine est-elle irréversible ?</p>
        </li>
    </ul>
    <br>
    <p><strong>Mardi 15 décembre</strong></p>
    <p><strong>14h00 : 17h30 - Session 4 : Chercher, enseigner, éduquer dans l’anthropocène digitalisé</strong></p>
    <p>La question de l’open access déjà évoquée doit être étendue et approfondie – en s’enrichissant des analyses critiques de la bibliométrie et de la scientométrie – dans la perspective beaucoup plus générale d’une réinvention de la chose publique, laquelle suppose des activités de publication de toute sorte. Si, comme Jean-Pierre Vernant le mit en évidence, la polis grecque apparut avec la géométrie, c’est parce que la parité des citoyens est fondée sur la parité qui structure les coopérations rationnelles. Quelles conséquences en tirer pour les territoires à l’époque de la nouvelle parité à la fois rendue possible et menacée par l’hypercontrôle computationnel, pour la production et la transmission des savoirs académiques, et pour l’avenir des industries éditoriales françaises et européennes ?</p>
    <ul>
        <li>
            <p><strong>14h00</strong>&nbsp;: <strong>Ariel Kyrou</strong> et <strong>Bruno Teboul</strong> (Keyrus, Université Paris Dauphine)</p>
            <p>Pour une contre–université du numérique</p>
        </li>
        <li>
            <p><strong>14h30</strong>&nbsp;: <strong>Boris Razon</strong> (France Télévisions)</p>
        </li>
        <li>
            <p><strong>15h00</strong>&nbsp;: <strong>Xavier de La Porte</strong> (Rue89)</p>
        </li>
        <li>
            <p><strong>15h30</strong>&nbsp;: <strong>François Bon</strong> (Ecrivain)</p>
        </li>
        <li>
            <p><strong>16h00</strong>&nbsp;: <i>Questions</i></p>
        </li>
        <li>
            <p><strong>16h45</strong>&nbsp;: <strong>Table-ronde : Le Web des Territoires</strong></p>
            <p>
            <ul>
              <li><p><strong>Patrick Braouezec</strong>, Président de Plaine Commune</p></li>
              <li><p><strong>Bernard Stiegler</strong>, Ars Industrialis</p></li>
              <li><p><strong>Catherine Beaugrand</strong>, Artiste</p></li>
            </ul>
            </p>
        </li>
    </ul>",

   'link' => 'http://enmi-conf.org/wp/enmi15/',

   'islive'     => true,

   'keywords'   => 'iri, nouveau monde industriel, automatisation, algorithmes',

   'rep' => basename(__DIR__),

   'partenaires'=> "Organisateurs: <a href='http://www.iri.centrepompidou.fr/' class='footerLink' target='_blank'>IRI</a>
   | <a href='http://www.capdigital.com/' class='footerLink' target='_blank'>Cap Digital</a>
    - Partenaires Scientifiques: <a href='http://www.mines-telecom.fr/fr_accueil.html' class='footerLink' target='_blank'>Institut Mines-Télécom</a>
   | <a href='http://www.francetelevisions.fr/' class='footerLink' target='_blank'>France Télévisions</a>
   | <a href='https://www.strate.design' class='footerLink' target='_blank' title='strate école de design' rel='nofollow noopener'>Strate</a>",

    'client_visual' => 'images/client_visual.jpg',// 480 × 320 pixels

    'head_logo' => 'images/logo-enmi.png', // 171 × 63 pixels

    'slide_background' => 'images/slide_background.jpg', // 606 × 282 pixels

    'archive_img' => 'images/archive_img.jpg', // 270 × 150 pixels

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2015",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou les 14 et 15 décembre 2015',

    // After the event
    'metadata'    => "00",
    'annotation_protocol_version' => '2',
);
