<?php
$config = array(
    'hashtag'    => '#seminaireCNSAD',

    'title' => 'CNSAD - Séminaire Téléprésence 2017',

    'abstract'   => "<b>CNSAD - Séminaire téléprésence 2017</b><br><em>CNSAD, 21 novembre 2017</em>",

    'description' => "<p>Le théâtre pose la question de la présence en scène. Il pose donc aujourd'hui la question de la téléprésence des scènes. La téléprésence, c'est la présence à distance ; c'est l'utilisation d'outils techniques et technologiques au service de la rencontre d'êtres vivants que la distance géographique sépare. Si le théâtre est la rencontre au présent d'acteurs vivants entre eux et avec un public, la téléprésence permet d'explorer et de repousser les notions de présence et d'absence ; d'échange et de mise en commun. Par la puissance et l'omniprésence des outils Internet, le monde d'aujourd'hui est de plus en plus interconnecté, les savoirs et cultures dialoguent et s'entrechoquent. Au-delà d'un nivellement par le bas d'une culture mondialisée, comment pouvons-nous utiliser ces outils au service du dialogue et de la création d'œuvres scéniques communes?</p><br>
   <p>« Cela pose la question de la scène : où se joue la pièce? [...] Le réseau devient le théâtre [.] Ce lieu, ou ce non-lieu, constitue le cœur du questionnement social, qui s’attaque à la nouvelle réalité de notre monde, de plus en plus virtuel »<br>
   Guillaume Corbeil, Dramaturge du projet DIEU EST UN DJ</p><br>

   <p>Après une première création entre Montréal et Genève en 2012 et dans une philosophie à la fois de recherche et de développement d’un processus pédagogique, Julien Brun, metteur en scène, et le Conservatoire National Supérieur d’Art Dramatique ont mis en place une série d’ateliers avec les étudiants comédiens et des étudiants en master, sous l’égide de l‘Idéfi-Créatic. Ces ateliers ont permis de développer une réflexion théâtrale et philosophique autour de la téléprésence artistique et des ses tenants et aboutissants dans la société occidentale contemporaine.</p><br>

   <p>A la suite d’un atelier de création en téléprésence donné pendant trois semaines au CNSAD, Julien Brun, Bernard Stiegler, ainsi que les équipes du CNSAD et de l’IRI, ont le plaisir de vous inviter à participer le 21 novembre de 10:00 à 17:00 à un séminaire autour de ces questions, au centre Pompidou. Ce séminaire s’adresse aux chercheurs en arts vivants, philosophie,  sociologie, sciences de la communication et sciences politiques, ainsi qu’à tout personne qui aimerait participer à une journée de réflexion à ce sujet. Ensemble, nous nous questionnerons sur la nécessité d’utiliser les réseaux et technologies Internet pour la création artistique de demain. Nous nous questionnerons sur le “comment ?” de cette utilisation (téléprésence et autres moyens de communication et de création) ; mais également “dans quel but?” et “quels liens avec la société d’aujourd’hui et le public?”.</p>",

    'link' => '',

    'islive'     => false,
    'islive_embed' => '<img src="./images/client_visual.jpg">',

    'keywords'   => 'CNSAD, téléprésence',

    'rep' => basename(__DIR__),

    'partenaires'=> "<a href='http://www.cnsad.fr/' class='footerLink' target='_blank'>CNSAD</a>
    | <a href='http://www.iri.centrepompidou.fr/' class='footerLink' target='_blank'>IRI</a>",

    'client_visual' => 'images/client_visual.jpg',// 480 × 320 pixels

    'head_logo' => 'images/logo_cnsad.png', // 171 × 63 pixels

    'slide_background' => 'images/slide_background.jpg', // 606 × 282 pixels

    'archive_img' => 'images/archive_img.jpg', // 270 × 150 pixels

    'archive_title' => "CNSAD Séminaire téléprésence 2017",
    'archive_description' => '<b>Séminaire téléprésence 2017</b><br><em>CNSAD, 21 novembre 2017</em>',

    // After the event
    'metadata'    => "00",
    'annotation_protocol_version' => '2'
);
