<?php
$config = array(
    'hashtag'    => '#enmi17',

    'title' => 'Entretiens du Nouveau Monde Industriel 2017',

    'abstract'   => "<b>BÊTISE ET INTELLIGENCE ARTIFICIELLES</b><br><em>Paris. Centre Pompidou. Grande Salle.<br>19 et 20 décembre 2017</em>",

    'description' => "<h3>BÊTISE ET INTELLIGENCE ARTIFICIELLES</h3>
    <p>Paris. Centre Pompidou. Grande Salle.<br>
    19 et 20 décembre 2017<br>
    <a href=\"https://enmi-conf.org/wp/enmi17\" target=\"_blank\">https://enmi-conf.org</a>
    </p>
    <br>
    <strong>11ème édition</strong>
    <p>Dans le cadre d’une réflexion globale sur une nouvelle articulation des processus de traitement de données dans la data economy (intelligence artificielle réticulée, deep learning, machine learning en général et calcul intensif), d’une part, et de l’interprétation de ces données et de ces traitements, d’autre part, et dans le contexte scientifique aussi bien que dans l’exercice de la citoyenneté et plus généralement de la responsabilité, cette dixième édition des Entretiens du Nouveau Monde Industriel se propose d’analyser l’impact des instruments de calculs automatisés sur la constitution des savoirs académiques au moment où les technologies issues des mathématiques appliquées à l’informatique en réseau tendent à s’imposer au monde scientifique à partir des critères d’efficience prescrits par les marchés.
    </p>
    <br>
    <h3>Programme</h3>
    <br>
    <p><strong>Mardi 19 décembre</strong></p>
    <p><strong>10h30-13h00 - Session 1 : Intelligence artificielle, bêtise artificielle et fonction du calcul</strong></p>
    <p>Norbert Wiener pose dès 1948 et à propos de la cybernétique – dont l’intelligence artificielle est évidemment un cas spécifique – qu’elle suppose une reconsidération fondamentale des caractéristiques et de la place des savoirs humains dans les sociétés fondées sur les machines, faute de quoi on serait porté à craindre qu’advienne une grande régression. Cette matinée tentera de reprendre en vue ces méditations dans le contexte spécifique du XXIème siècle et tel que le hante ce qu’on appelle la “post-vérité”, dont les weapons of math destruction sont opératrices.</p>
    <p>
        <ul>
          <li><p><strong>10h00 : Bernard Stiegler</strong>, philosophe (Institut de recherche et d'innovation)</p></li>
          <li><p><strong>10h45 : David Bates</strong>, histoire des sciences (Un. Berkeley)</p></li>
          <li><p><strong>11h30 : Giuseppe Longo</strong>, mathématiques et biologie (ENS)</p></li>
          <li><p><strong>12h15 : Laurence Devillers</strong>, robotique (Limsi/CNRS).</p></li>
        </ul>
    </p>
    <br>
    <p><strong>14h30 : 18h30 - Session 2 : Structures de données et production des savoirs</strong></p>
    <p>Wiener faisait de l’entropie et de sa réduction l’enjeu de la cybernétique – et il faut considérer ici l’entropie dans les champs thermodynamique, biologique et informationnel, ce qui reste un chantier à part entière. Alors qu’on parle de “management par la bêtise fonctionnelle”, et tandis que les plateformes computationnelles constituent des infrastructures automatisées de portée biosphérique, comment est-il possible de mettre la puissance de calcul au service de la lutte contre l’entropie plutôt que d’augmenter l’entropie (et le désordre – climat et pollution, réduction de la biodiversité et de la noodiversité) au profit de quelques-uns ? Quelles fonctions faut-il ici conférer aux structures des données ?</p>
    <ul>
      <li><p><strong>14h30 : André Spicer</strong>, business &amp; management (Université de Londres)</p></li>
      <li><p><strong>15h15 : Benjamin Bratton</strong>, design (Université de San Diego)</p></li>
      <li><p><strong>16h00 : Christian Fauré</strong>, informatique (Octo Technology)</p></li>
      <li><p><strong>16h45 : Pause</strong></p></li>
      <li><p><strong>17h00 : Yuk Hui</strong>, informatique et philosophie (Leuphana Un) (sous réserve)</p></li>
      <li><p><strong>17h45 : Rand Hindi</strong>, intelligence artificielle (SPIPS)</p></li>
    </ul>
    <br>
    <p><strong>Mercredi 20 décembre</strong></p>
    <br>
    <p><strong>10h00 : 13h00 - Session 3 : Opacité des instruments scientifiques et conséquences épistémologiques</strong></p>
    <p>Imagine-t-on Galilée étant obligé d’utiliser une lunette d’observation acquise sur le marché qu’il n’aurait ni le droit ni la possibilité effective d’étudier, d’analyser, de formaliser et de modifier en vue d’expérimenter selon ses thèses et hypothèses ? Un tel état de fait aurait évidemment fait obstruction à l’avènement de la physique et de la science modernes. C’est pourtant ce qui paraît caractériser la science contemporaine, au point qu’il n’est pas illégitime de se demander dans quelle mesure on peut encore concevoir une unité de la science – cependant que l’Europe semble tout à fait dépassée par ce qui constitue évidemment un enjeu majeur dans une compétition pour le pouvoir sur les savoirs, et à travers les instruments et leurs capacités prescriptrices cachées.</p>
    <ul>
      <li><p><strong>10h00 : Vincent Bontems</strong>, épistémologie (CEA)</p></li>
      <li><p><strong>10h35 : Cédric Mattews</strong>, biologie (CNRS)</p></li>
      <li><p><strong>11h10 : Peter Lemmens</strong>, philosophie (ISIS)</p></li>
      <li><p><strong>11h45 : Pause</strong></p></li>
      <li><p><strong>11h50 :</strong> <strong>Bruno Bachimont </strong>(UTC) (sous réserve)</p></li>
      <li><p><strong>12h25 :</strong> <strong>Maël Montévil</strong>, Biologie (IRI)</p></li>
    </ul>
    <br>
    <p><strong>14h30 : 18h30 - Session 4 : Données, traitements, contributions et délibérations</strong></p>
    <p>Les données sont de plus en plus prescrites en vue de leurs traitements automatisés - à la différence de ce qui caractérisait la liberté apportée en son temps (1993) par HTML et le world wide web. Rien pourtant n'oblige à tout livrer aux quantifications probabilistes, aux chaînes de Markov et aux corrélations extraites des \"big data\" sous forme de <em>patterns</em>. Si la lutte contre l'entropie - que le <em>pharmakon</em> cybernétique risque évidemment d'aggraver considérablement avec les nouvelles avancées de <em>l'intelligence artificielle généralisée</em>, devenant ainsi <em>bêtise artificiellement généralisée</em> - est bien l'enjeu que pointait Wiener il y a près de 70 ans en affirmant la nécessité de reconsidérer et de réaffirmer la précellence des savoirs humains à l'ère cybernétique, il est urgent de relancer une politique de recherche et de développement alternative à une logique de plateforme devenue ravageuse aussi bien pour l'économie et la société que pour les savoirs sous toutes leurs formes. Cette dernière session permettra de montrer comment le territoire apprenant contributif de Plaine Commune met ces questions au cœur de ses projets.</p>
    <ul>
      <li><p><strong>14h30 : Paul-Emile Geoffroy </strong>(IRI)</p></li>
      <li><p><strong>15h15 : Jean-Pierre Girard</strong>, archéologie (MOM)</p></li>
      <li><p><strong>16h00 : Thibaut d’Orso</strong>, informatique (Spidéo)</p></li>
      <li><p><strong>16h45 : Pause</strong></p></li>
      <li><p><strong>17h00 : Warren Sack, </strong>artiste, software studies (UC Santa Cruz) (en vidéo)</p></li>
      <li><p><strong>17h45 : Johan Mathé</strong>, informatique (Bay Labs)</p></li>
    </ul>",

   'link' => 'http://enmi-conf.org/wp/enmi17/',

   'islive'     => true,
   'islive_embed' => '',

   'keywords'   => 'iri, nouveau monde industriel, intélligence artificielle, bêtise',

   'rep' => basename(__DIR__),

   'partenaires'=> "Organisateurs: <a href='http://www.iri.centrepompidou.fr/' class='footerLink' target='_blank'>IRI</a>
   | <a href='http://www.capdigital.com/' class='footerLink' target='_blank'>Cap Digital</a>
    - Partenaires:<a href='https://nextleap.eu/' class='footerLink' target='_blank'>Projet NEXTLEAP</a>
   | <a href='https://projet-episteme.org/' class='footerLink' target='_blank'>Projet Épistémè</a>
   | <a href='https://recherchecontributive.org/' class='footerLink' target='_blank'>Chaire de Recherche Contributive Plaine Commune</a>",

    'client_visual' => 'images/client_visual.jpg',// 480 × 320 pixels

    'head_logo' => 'images/logo-enmi.png', // 171 × 63 pixels

    'slide_background' => 'images/slide_background.jpg', // 606 × 282 pixels

    'archive_img' => 'images/archive_img.jpg', // 270 × 150 pixels

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2017",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou les 19 et 20 décembre 2017',

    // After the event
    'metadata'    => "00",
    'annotation_protocol_version' => '2',
);
