<?php

/**
 * If you haven't edited php.ini to add the Zend Framework and the
 * Zend Framework Incubator to the PHP include_path, then do so here.
 * Don't use mine!
 */
set_include_path(
    'lib'
    . PATH_SEPARATOR . get_include_path()
);

/**
* Base configuration
*/
date_default_timezone_set('UTC');

$ldt_platform = 'http://ldt.iri.centrepompidou.fr/';
$project_url_base = 'ldtplatform/ldt/cljson/id/';

$C_default_rep = 'attention-1314-04-pathologies-attention-memoire';
$C_feedback_form_url = 'https://spreadsheets.google.com/spreadsheet/viewform?hl=en_US&formkey=dDZILVdXVHRzd0xhWGVZXzkweHN2RGc6MQ#gid=0';
$C_event_props = __DIR__ . "/event_props";
$C_event_users = array('polemictweet' => 'polemictweet'.date('Y/m/d'));

$C_openssl_cipher_iv_length = 16; //openssl_cipher_iv_length('aes256')

$archives_list = array(
    "rsln", "rsln-opendata", "rsln-mercedes-bunz",
    "enmi2011-technologie-confiance", "CPV", array("fens_FabLab_Design_Metadata","fablab"),
array("fens_FabLab_Design_Metadata","designmd"), array("mashup","conference"), array("mashup","tableronde"),
    "sig-chi-paris-2011", "rwd-meetup-patrimoine", "2011-2012-museo-ouverture"/*, "JaneMcGonigal-gameDesign"*/,
    "iii-catastrophe", "edito-inaugurale", "enmi2011", "2011-2012-museo-structured-data",
    "edito-webdoc","edito-intelligence", "2011-2012-museo-contribution",
    "2011-2012-museo-ingenierie", "edito-serious-games", "enmi2012-seminaire-1", "2011-2012-museo-audiovisuel", "edito-reseaux-sociaux",
    "edito-arts-numeriques",
    'fens2012-gamestudies',
    'fens2012-designmetadata',
    'fens2012-museo-culture-opendata',
    'fens2012-vinyl-numerique',
    'fens2012-edito-datajournalisme',
    'fens2012-wiid',
    'museo-1213-01-inaugurale', 'edito-1213-01-contextes',
    'museo-1213-02-vecteurs-numerique', 'edito-1213-02-collectifs-auteurs',
    "enmi12", "bpidoudou", 'museo-1213-03-techniques-humanites', 'museo-1213-04-web-ingenierie-philosophie',
    'edito-1213-04-lire-ecrire', 'eduinov-2013',
    'edito-1213-05-supports-ecriture', 'edito-1213-06-modeles-economiques',
    'museo-1213-07-quels-outils-pour-apprendre', 'edito-1213-07-lecteur-auteur-droits',
    'fens2013-design-metadata',
    'fens2013-museo-cultural-data',
    'fens2013-edito-verite-fiction',
    'mediapartlive-comment-combattre-le-fn',
    'attention-1314-01-notion-attention',
    'attention-1314-02-syndrome-saturation-cognitive',
    'edito-1314-01-quest-ce-quun-support',
    'enmi13', 'museo-1314-03-cognition-apprentissage', 'attention-1314-03-nouvelle-valeur-economique',
    'edito-1314-02-lannotation-le-savoir-dans-la-marge',
);


$configuration = array(
    'siteUrl'        => 'https://api.twitter.com/oauth',
    'consumerKey' 	 => '***REMOVED***',
    'consumerSecret' => '***REMOVED***'
);


$req_rep = $C_default_rep;
if(isset($config) && isset($config['rep'])) {
    $req_rep = $config['rep'];
}

foreach (glob(dirname(__FILE__).'/traductions/*.php') as $trad_filename)
{
    include_once $trad_filename;
}
if(file_exists(dirname(__FILE__)."/$req_rep/traduction.php")) {
    include_once dirname(__FILE__)."/$req_rep/traduction.php";
}


/**
 * Make sure Zend_Oauth's Consumer is loaded
 */
require_once dirname(__FILE__).'/lib/Zend/Oauth/Consumer.php';

/** Zend_Locale */
require_once dirname(__FILE__).'/lib/Zend/Locale.php';
 
/** Zend_Translate_Adapter */
require_once dirname(__FILE__).'/lib/Zend/Translate/Adapter.php';

/**
 * Start up the ol' session engine
 */
session_start();

/**
 * Include the configuration data for our OAuth Client (array $configuration)
 */
include_once dirname(__FILE__).'/config.php';
 

$configuration['callbackUrl'] = URL_ROOT."$req_rep/callback.php";


/**
 * Setup an instance of the Consumer for use
 */
$consumer = new Zend_Oauth_Consumer($configuration);

/**
 * TRADUCTION
**/
function get_config_translations($config) {

    $fr = array();
    $en = array();
    $jp = array();

    $array_loop = array("fr"=>&$fr,"en"=>&$en,"jp"=>&$jp);
    /**
     * add all config key as translation.
     * translation key is "config__<config_key>"
     */
    foreach ($config as $key => $value) {
        $translation_key = "config__$key";

        foreach ($array_loop as $lang => &$lang_array) {
            if(is_array($value) && count(array_intersect_key($value,$array_loop)) > 0 ) {
                if (array_key_exists($lang, $value)) {
                    $lang_array[$translation_key] = $value[$lang];
                }
                elseif (array_key_exists('fr', $value)) {
                    $lang_array[$translation_key] = $value['fr'];
                }
            }
            else {
                $lang_array[$translation_key] = $value;
            }
        }
    }

    return $array_loop;

}

function set_config_translations(&$config, &$translate) {
    
    $config_translations = get_config_translations($config);
    
    // save the locale because it gets changed when adding translations
    $locale = $translate->getLocale();
    
    $translate->addTranslation($config_translations['en'], 'en');
    $translate->addTranslation($config_translations['jp'], 'ja_JP');
    $translate->addTranslation($config_translations['fr'], 'fr');
    
    // set the locale back
    $translate->setLocale($locale);
}


Zend_Loader::loadClass('Zend_Translate');
Zend_Loader::loadClass('Zend_Http_Cookie');


$client = new Zend_Http_Client();
$translate = new Zend_Translate('array', $init, 'fr');


$translate->addTranslation($traduction_en, 'en');
$translate->addTranslation($traduction_ja, 'ja_JP');
$translate->addTranslation($traduction_fr, 'fr');

if(isset($config)) {
    
    set_config_translations($config, $translate);
//     $config_translations = get_config_translations($config);
    
    
//     $translate->addTranslation($config_translations['en'], 'en');
//     $translate->addTranslation($config_translations['jp'], 'ja_JP');
//     $translate->addTranslation($config_translations['fr'], 'fr');
}
    
$actual = $translate->getLocale();

//$translate->setLocale("en");
// $acceptCookie = $this->_request->getCookie('acceptCookie',0);

if(isset($_GET['lang'])==false and isset($_SESSION['lang'])==false){
    
    if($actual!='fr' and $actual!='en' and $actual!='ja_JP'){
        $translate->setLocale("fr");
         $_SESSION['lang']="fr";
    }
    
} else if (isset($_GET['lang'])==true){
    $translate->setLocale($_GET['lang']);
    $_SESSION['lang'] = $_GET['lang'];
    $actual = $_SESSION['lang'];

} else if (isset($_SESSION['lang'])==true){
    $translate->setLocale( $_SESSION['lang']);
    $actual = $_SESSION['lang'];
    
}

$js_registry = array(
    'local' => array(
        'libdir'        => URL_ROOT.'res/js/',
        'jquery' 		=> URL_ROOT.'res/js/jquery-1.10.2.min.js',
        'raphael' 		=> URL_ROOT.'res/js/raphael-min.js',
        'jquery-ui' 	=> URL_ROOT.'res/js/jquery-ui.min.js',
        'niceforms' 	=> URL_ROOT.'res/js/niceforms.js',
        'jquery-url' 	=> URL_ROOT.'res/js/jquery.url.js',
        'ldtplayer' 	=> URL_ROOT.'res/metadataplayer/src/js/LdtPlayer.js',
        'fancybox' 		=> URL_ROOT.'res/js/fancybox/jquery.fancybox.pack.js',
        'jquery-tools' 	=> URL_ROOT.'res/js/jquery.tools.min.js',
        'jquery-migrate' => URL_ROOT.'res/js/jquery-migrate-1.2.1.min.js',
        'tw-widget' 	=> URL_ROOT.'res/js/tw_widget.js',
        'jquery-mousewheel' => URL_ROOT.'res/js/jquery.mousewheel.js',
        'swfobject' 	=> URL_ROOT.'res/js/swfobject.js',
        'json-js' 		=> URL_ROOT.'res/js/json2.js',
        'underscore'    => URL_ROOT.'res/js/underscore-min.js' ,
        'jquery-scrollto'=>URL_ROOT.'res/js/jquery.scrollTo-1.4.2-min.js' ,
        'twcx-main'     => URL_ROOT.'res/js/live-polemic.js' ,
        'semanticboard' => URL_ROOT.'res/js/semanticboard.js' ,
        'metadataplayer'=> URL_ROOT.'res/metadataplayer/LdtPlayer-core.js' ,
        'ldtwidgets'    => URL_ROOT.'res/metadataplayer/' ,
        'tracemanager'  => URL_ROOT.'res/js/tracemanager.js' ,
        'jwplayer-js'   => URL_ROOT.'res/js/jwplayer.js',
        'jquery-tinymce' => URL_ROOT.'res/js/tinymce/jquery.tinymce.min.js',
        'tinymce'        => URL_ROOT.'res/js/tinymce/tinymce.min.js',
    ),
    'cdn' => array(
        'libdir'        => URL_ROOT.'res/js/',
        'jquery' 		=> 'http://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js',
        'raphael' 		=> URL_ROOT.'res/js/raphael-min.js',
        'jquery-ui' 	=> 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js',
        'niceforms' 	=> URL_ROOT.'res/js/niceforms.js',
        'jquery-url' 	=> URL_ROOT.'res/js/jquery.url.js',
        'ldtplayer' 	=> URL_ROOT.'res/metadataplayer/src/js/LdtPlayer.js',
        'fancybox' 		=> URL_ROOT.'res/js/fancybox/jquery.fancybox.pack.js',
        'jquery-tools' 	=> 'http://cdn.jquerytools.org/1.2.7/all/jquery.tools.min.js',
        'jquery-migrate' => 'http://code.jquery.com/jquery-migrate-1.2.1.min.js',
        'tw-widget' 	=> 'http://widgets.twimg.com/j/2/widget.js',
        'jquery-mousewheel' => URL_ROOT.'res/js/jquery.mousewheel.js',
        'swfobject' 	=> 'http://ajax.googleapis.com/ajax/libs/swfobject/2.2/swfobject.js',
        'json-js'       => URL_ROOT.'res/js/json2.js',
        'underscore'    => URL_ROOT.'res/js/underscore-min.js' ,
        'jquery-scrollto'=>URL_ROOT.'res/js/jquery.scrollTo-1.4.2-min.js' ,
        'twcx-main'     => URL_ROOT.'res/js/live-polemic.js' ,
        'semanticboard' => URL_ROOT.'res/js/semanticboard.js' ,
        'metadataplayer'=> URL_ROOT.'res/metadataplayer/LdtPlayer-core.js' ,
        'ldtwidgets'    => URL_ROOT.'res/metadataplayer/' ,
        'tracemanager'  => URL_ROOT.'res/js/tracemanager.js' ,
        'jwplayer-js'   => URL_ROOT.'res/js/jwplayer.js',
        'jquery-tinymce' => URL_ROOT.'res/js/tinymce/jquery.tinymce.min.js',
        'tinymce'        => URL_ROOT.'res/js/tinymce/tinymce.min.js',
    )
);

$font_registry = array(
    'local' => array(
        'PT-Sans_Narrow' => URL_ROOT.'res/fonts/PTSansNarrow.css',
        'PT-Sans' 		 => URL_ROOT.'res/fonts/PTSans.css'
    ),
    'cdn' => array(
        'PT-Sans_Narrow' => 'http://fonts.googleapis.com/css?family=PT+Sans+Narrow&subset=latin',
        'PT-Sans' 		 => 'http://fonts.googleapis.com/css?family=PT+Sans&subset=latin'
    )
);


$css_registry = array(
    'local' => array(
       	'blueprint-screen' => URL_ROOT.'res/css/blueprint-screen.css',
        'blueprint-print' => URL_ROOT.'res/css/blueprint-print.css',
        'blueprint-ie' => URL_ROOT.'res/css/blueprint-ie.css',
        'blueprint-plugins-fancy-type' => URL_ROOT.'res/css/blueprint-plugins/fancy-type/screen.css',
        'custom' => URL_ROOT.'res/css/custom.css',
        'fancybox' => URL_ROOT.'res/js/fancybox/jquery.fancybox.css',
        'jquery-ui' => URL_ROOT.'res/metadataplayer/res/css/jq-css/themes/base/jquery-ui.css',
        'tabs-slideshow' => URL_ROOT.'res/css/tabs-slideshow.css',
        'tweetcast' => URL_ROOT.'res/css/tweetcast.css',
        'semanticboard' =>  URL_ROOT.'res/css/semanticboard.css',
        'archives-iframe' => URL_ROOT.'res/css/archives-iframe.css',
        'metadataplayer' => URL_ROOT.'res/metadataplayer/LdtPlayer-core.css',
        'jquery-te' => URL_ROOT.'res/css/jquery-te.css',
    ),
    'cdn' => array(
        'blueprint-screen' => URL_ROOT.'res/css/blueprint-screen.css',
        'blueprint-print' => URL_ROOT.'res/css/blueprint-print.css',
        'blueprint-ie' => URL_ROOT.'res/css/blueprint-ie.css',
        'blueprint-plugins-fancy-type' => URL_ROOT.'res/css/blueprint-plugins/fancy-type/screen.css',
        'custom' => URL_ROOT.'res/css/custom.css',
        'fancybox' => URL_ROOT.'res/js/fancybox/jquery.fancybox.css',
        'jquery-ui' => "http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.13/themes/base/jquery-ui.css",
        'tabs-slideshow' => URL_ROOT.'res/css/tabs-slideshow.css',
        'tweetcast' => URL_ROOT.'res/css/tweetcast.css',
        'semanticboard' =>  URL_ROOT.'res/css/semanticboard.css',
        'archives-iframe' => URL_ROOT.'res/css/archives-iframe.css',
        'metadataplayer' => URL_ROOT.'res/metadataplayer/LdtPlayer-core.css',
        'jquery-te' => URL_ROOT.'res/css/jquery-te.css',
    )
);


function registry_url($key, $type, $registry_def=null) {

    global $js_registry, $font_registry, $css_registry, $C_default_registry;

    if($registry_def != null) {
        $registry = $registry_def;
    }
    elseif(isset($C_default_registry)) {
        $registry = $C_default_registry;
    }
    else {
        $registry = 'local';
    }
    $registry_name = $type."_registry";
    return ${
        $registry_name}[$registry][$key];

}

function get_archive_box($rep, $metadata, $url_root, $basepath, &$translate) {

    include("$basepath$rep/config.php");
    
    set_config_translations($config, $translate);
/* 	$config_translations = get_config_translations($config);
    
// 	save the locale because it gets changed when adding translations
    $locale = $translate->getLocale();
    
    $translate->addTranslation($config_translations['en'], 'en');
    $translate->addTranslation($config_translations['jp'], 'ja_JP');
    $translate->addTranslation($config_translations['fr'], 'fr');
    
// 	set the locale back
    $translate->setLocale($locale);
 */
    $id = "abox_$rep".(($metadata!=null)?"_$metadata":"");
    $hash = ($metadata!=null)?"#metadata=$metadata":"";
    $tail_img = $translate->_('config__archive_img');
    if(is_array($tail_img)) {
        $tail_img = $tail_img[$metadata];
    }
    $archive_title = $translate->_('config__archive_title');
    if(is_array($archive_title)) {
        $archive_title = $archive_title[$metadata];
    }
    $archive_description = $translate->_('config__archive_description');
    if(is_array($archive_description)) {
        $archive_description = $archive_description[$metadata];
    }


    $res  = "<div id=\"$id\" class=\"archivesVideoBox\">\n";
    $res .= "    <a href=\"$rep/polemicaltimeline.php$hash\">\n";
    $res .= "        <img src=\"$url_root$rep/$tail_img\" width=\"270\" height=\"150\" class=\"AVBimg\" />";
    $res .= "    </a>";
    $res .= "    <div class=\"AVBtitle\">$archive_title</div>\n";
    $res .= "    <div class=\"AVBtext\">\n";
    $res .= "        $archive_description\n";
    $res .= "    </div>\n";
    $res .= "</div>\n";

    return $res;

}

function display_archives_list($archives_list, $box_class, $url_root, $basepath, &$translate) {
    
    
    for($i=0;$i<count($archives_list);$i++) {
        if(($i % 3)==0) {
            print("			    <div class=\"$box_class\">\n");
        }
        $archive_ref = $archives_list[$i];
    
        $archive_name = $archive_ref;
        $metadata = null;
        if(is_array($archive_ref)) {
            $archive_name = $archive_ref[0];
            $metadata = $archive_ref[1];
        }
        print(get_archive_box($archive_name,$metadata, $url_root, $basepath, $translate));
        if(($i % 3)==2 || $i == (count($archives_list)-1)) {
            print("			    </div>\n");
        }
    }
}

function get_metadata_url($metadata) {
    global $ldt_platform, $project_url_base;
    if (preg_match('/^https?:\/\//', $metadata)) {
        return $metadata;
    } else {
        return $ldt_platform.$project_url_base.$metadata;
    }
}

function get_metadata_json_url($metadata) {
    if (is_array($metadata)) {
        $metadata["url"] = get_metadata_url($metadata["url"]);
        return $metadata;
    } else {
        return get_metadata_url($metadata);
    }
}


$realm = 'Polemictweet restricted area';


function authenticate($users, $translate) {

    global $realm;
    
    
    if (empty($_SERVER['PHP_AUTH_DIGEST']) || !isset($_SESSION['http_digest_nonce'])) {
        $_SESSION['http_digest_nonce'] = uniqid();
        header('HTTP/1.1 401 Unauthorized');
        header('WWW-Authenticate: Digest realm="'.$realm.
        '",qop="auth",nonce="'.$_SESSION['http_digest_nonce'].'",opaque="'.md5($realm).'"');
        return array('error' => $translate->_('This area is restricted, please authenticate'));
    }


    //analyze the PHP_AUTH_DIGEST variable
    if (!($data = http_digest_parse($_SERVER['PHP_AUTH_DIGEST'])) ||
        !isset($users[$data['username']])) {
        $_SERVER['PHP_AUTH_DIGEST'] = '';
        unset($_SESSION['auth']);
        unset($_SESSION['http_digest_nonce']);
        return array('error' => $translate->_('Wrong Credentials!'));
    }


    //generate the valid response
    $A1 = md5($data['username'] . ':' . $realm . ':' . $users[$data['username']]);
    $A2 = md5($_SERVER['REQUEST_METHOD'].':'.$data['uri']);
    $valid_response = md5($A1.':'.$data['nonce'].':'.$data['nc'].':'.$data['cnonce'].':'.$data['qop'].':'.$A2);

    if ($data['response'] != $valid_response) {
        $_SERVER['PHP_AUTH_DIGEST'] = '';
        unset($_SESSION['http_digest_nonce']);
        unset($_SESSION['auth']);
        return array('error' => $translate->_('Wrong Credentials!'));
    }

    // ok, valid username & password
    $_SESSION['auth'] = $data['username'];
    return $data;
}

function logout() {
    global $realm;
    
    unset($_SESSION['auth']);
    unset($_SESSION['http_digest_nonce']);
}


//function to parse the http auth header
function http_digest_parse($txt)
{
    // protect against missing data
    $needed_parts = array('nonce'=>1, 'nc'=>1, 'cnonce'=>1, 'qop'=>1, 'username'=>1, 'uri'=>1, 'response'=>1);
    $data = array();
    $keys = implode('|', array_keys($needed_parts));

    preg_match_all('@(' . $keys . ')=(?:([\'"])([^\2]+?)\2|([^\s,]+))@', $txt, $matches, PREG_SET_ORDER);

    foreach ($matches as $m) {
        $data[$m[1]] = $m[3] ? $m[3] : $m[4];
        unset($needed_parts[$m[1]]);
    }

    return $needed_parts ? false : $data;
}

/**
 * Modifies a string to remove all non ASCII characters and spaces.
 */
function slugify($text)
{
    // replace non letter or digits by -
    $text = preg_replace('~[^\\pL\d]+~u', '-', $text);

    // trim
    $text = trim($text, '-');

    // transliterate
    if (function_exists('iconv'))
    {
        $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    }

    // lowercase
    $text = strtolower($text);

    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);

    if (empty($text))
    {
        return 'n-a';
    }

    return $text;
}


// from http://www.house6.com/blog/?p=83
function sanitize_filename($f) {
    // a combination of various methods
    // we don't want to convert html entities, or do any url encoding
    // we want to retain the "essence" of the original file name, if possible
    // char replace table found at:
    // http://www.php.net/manual/en/function.strtr.php#98669
    $replace_chars = array(
            'Š'=>'S', 'š'=>'s', 'Ð'=>'Dj','Ž'=>'Z', 'ž'=>'z', 'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A',
            'Å'=>'A', 'Æ'=>'A', 'Ç'=>'C', 'È'=>'E', 'É'=>'E', 'Ê'=>'E', 'Ë'=>'E', 'Ì'=>'I', 'Í'=>'I', 'Î'=>'I',
            'Ï'=>'I', 'Ñ'=>'N', 'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ù'=>'U', 'Ú'=>'U',
            'Û'=>'U', 'Ü'=>'U', 'Ý'=>'Y', 'Þ'=>'B', 'ß'=>'Ss','à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a',
            'å'=>'a', 'æ'=>'a', 'ç'=>'c', 'è'=>'e', 'é'=>'e', 'ê'=>'e', 'ë'=>'e', 'ì'=>'i', 'í'=>'i', 'î'=>'i',
            'ï'=>'i', 'ð'=>'o', 'ñ'=>'n', 'ò'=>'o', 'ó'=>'o', 'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ø'=>'o', 'ù'=>'u',
            'ú'=>'u', 'û'=>'u', 'ý'=>'y', 'ý'=>'y', 'þ'=>'b', 'ÿ'=>'y', 'ƒ'=>'f'
    );
    $f = strtr($f, $replace_chars);
    // convert & to "and", @ to "at", and # to "number"
    $f = preg_replace(array('/[\&]/', '/[\@]/', '/[\#]/'), array('-and-', '-at-', '-number-'), $f);
    $f = preg_replace('/[^(\x20-\x7F)]*/','', $f); // removes any special chars we missed
    $f = str_replace(' ', '-', $f); // convert space to hyphen
    $f = str_replace('\'', '', $f); // removes apostrophes
    $f = preg_replace('/[^\w\-\.]+/', '', $f); // remove non-word chars (leaving hyphens and periods)
    $f = preg_replace('/[\-]+/', '-', $f); // converts groups of hyphens into one
    if (function_exists('iconv'))
    {
        $f = iconv('utf-8', 'us-ascii//TRANSLIT', $f);
    }
    
    return strtolower($f);
}
