// Web Socket definitions

WEB_SOCKET_SWF_LOCATION = "lib/websocket-js/WebSocketMain.swf";
WEB_SOCKET_DEBUG = true;
var ws, tweets = [];

$(document).ready(function() {
  ws = new WebSocket("ws://" + document.location.hostname + ":9000/");
  ws.onopen = function() {
  	console.log("open");
  }
  ws.onmessage = function(e) {
	d = $.parseJSON(e.data);
	console.log(d);
	if (d.tweets) {
		tweets = tweets.concat(d.tweets);
		html = '';
		for (var i = d.tweets.length - 1; i >= 0; i--) {
			html += Mustache.to_html('<li class="tweet{{#annotations}} a_{{name}}{{/annotations}}" id="tweet_{{id}}"><img class="tweet_profile_image" src="{{profile_image_url}}" /><h4 class="tweet_title"><a href="http://twitter.com/{{screen_name}}" target="_blank">@{{screen_name}}:</a></h4><p class="tweet_created_at">{{created_at}}</p><p class="tweet_text">{{text}}</p></li>',d.tweets[i]);
		}
		console.log(html);
		$("#tweetlist").prepend(html);
	}
  };
  ws.onclose = function() {
	console.log("close");
  };
  ws.onerror = function() {
	console.log("error");
  };
  
  
})