var fs = require('fs'),
    https = require('https'),
    io = require('socket.io')
        .listen(8000)
    keyword = "Bieber",
    tweets = [],
    tweet_ids = [],
    annkw = {
        'positive' : '++',
        'negative' : '--',
        'reference' : '==',
        'question' : '??'
    }

function textids(object) {
    for (var key in object) {
        if (key.substr(-2) == 'id') {
            object[key] = object[key + '_str'];
            delete object[key + '_str'];
        }
    }
}

var fd = fs.createWriteStream('tweets.txt');

req = https.request({
    host: "stream.twitter.com",
    path: "/1/statuses/filter.json",
    method: "POST",
    headers: {
        'Authorization': 'Basic cmFwaHY6N3czMzdMZkMyM2dF',
        'Content-Type': 'application/x-www-form-urlencoded'
    }
}, function(res) {
    console.log('STATUS: ' + res.statusCode);
    console.log('HEADERS: ' + JSON.stringify(res.headers));
    res.setEncoding('utf8');
    res.on('data', function(chunk) {
        newdata = chunk.split('\r\n');
        try {
            for (var i in newdata) {
                if (newdata[i].length > 0) {
                    tweet = JSON.parse(newdata[i]);
                    annotations = [];
                    for (var a in annkw) {
                        if (tweet.text.indexOf(annkw[a]) != -1) {
                            annotations.push(a);
                        }
                    }
                    tweet.annotations = annotations;
                    tweets.push(tweet);
                    textids(tweet);
                    tweet_ids.push(tweet.id_str);
                    io.sockets.emit('newtweet', tweet);
                }
            }
            fd.write(chunk); 
        }
        catch(err) {
            console.log(err);
        }
    });
});

req.write('track=' + encodeURIComponent(keyword));
req.end();
io.set('log level', 0);
io.sockets.on('connection', function(socket) {
    socket.emit('tweets', tweets.slice(-10));
    socket.on('tweetsbefore', function(data) {
        tweetpos = tweet_ids.indexOf(data);
        socket.emit('oldtweets', tweets.slice(0, tweetpos).slice(-10));
    });
});