<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>RSLN  - Live Video and Annotation</title>
	
	
	<!-- JAVASCRIPT --> 
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js"></script>
	<script type="text/javascript" src="res/raphael/raphael-min.js"></script>
	
	<!-- Framework CSS -->
    <link rel="stylesheet" href="res/blueprint/screen.css" type="text/css" media="screen, projection">
    <link rel="stylesheet" href="res/blueprint/print.css" type="text/css" media="print">
	<link rel="stylesheet" href="res/blueprint/plugins/fancy-type/screen.css" type="text/css" media="screen, projection">
	<link rel="stylesheet" href="custom.css" type="text/css" media="screen, projection">
	

	
	<!-- FONT -->
	<link href='http://fonts.googleapis.com/css?family=PT+Sans+Narrow&subset=latin' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=PT+Sans&subset=latin' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Geo&subset=latin' rel='stylesheet' type='text/css'>
	<style type="text/css"> 
		.tweetButton{float:left;margin-right:5px;}
		.videoLivePlayer{border:1px solid #c3c3c3;width:650px;height:638px;}
		.videoLive{width:650px;height:640px;background:#fff;float:right;margin-top:20px;padding:5px;}
					
					.tweetExplain{background-image:url(images/tweetExplainBgd.gif);width:250px;height:640px;padding:10px;position:absolute; margin-top:70px;}
		.footer{margin-top:740px;width:960px;height:20px;position:absolute;text-align:center;}
		.tooltip{
			 z-index: 10000000000;
		}
		#tip{
			 position : absolute;
			 padding : 3px;
			 z-index: 10000000000;
			 max-width: 200px;
		}	
		#tip {
				display: none;
				background: transparent url("images/white_arrow_long.png");
				font-size: 12px;
				height: 125px;
				width: 180px;
				padding: 10px;
				padding-left: 15px;
				padding-top: 15px;
				padding-right: 15px;
				color: black;
				z-index: 10000000000;
				font-family: "Trebuchet MS", "Helvetica", "Arial", "Verdana", "sans-serif";
				overflow:hidden;
		}
		#chartTimeline{
			padding-top: 410px;
			z-index: 100000;
			position : absolute;
		}

	</style>
	<script type="text/javascript">
	
	  var _gaq = _gaq || [];
	  _gaq.push(['_setAccount', 'UA-9955524-3']);
	  _gaq.push(['_setDomainName', '.iri.centrepompidou.fr']);
	  _gaq.push(['_trackPageview']);
	
	  (function() {
	    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
	    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	  })();
	
	</script>
  </head>
  
  	<script type="text/javascript">	
	// CHART TIMELINE / VERSION PROTOTYPE  ::

	// configuration 
	var config = {
					target:"chartTimeline",
					x:8,
					y:418,
					width:650,
					height:70,
					heightmax:70
					}
	// Make and define the Raphael area
	//var paper = Raphael(document.getElementById(config.target),config.width, config.height);
		
	function ChartTimeLine (){
		
		//var paper = Raphael(config.x, config.y,config.width, config.height);
		
		//paper.rect(0,20,1,1).attr({fill:"#fff",stroke: "none"});	
		
		// variable 
		
		var yCoef	  		= 2; 					// coef for height of 1 tweet 
		var frameSize 		= 5; 					// frame size 
		var margin 	  		= 1;					// marge between frame
		var lineSize  		= 650;				// timeline pixel width 
		var nbrframes 		= lineSize/frameSize; // frame numbers
		var numberOfTweet 	= 0;				// number of tweet overide later 
		var duration  		= 4299820 ;			// timescale width 
		var frameLenght 	= lineSize/frameSize;// frame timescale	
		var timeline;
		var colors  = new Array("","#1D973D","#C5A62D","#CE0A15","#036AAE","#585858");
		
		// array 
		var tweets  = new Array();
		var element = new Array();
		var cluster = new Array();
		var frames  = new Array(frameLenght);
		var slices  = new Array();
		
		
		// Classes =======================================================================
		var Frames = function(){
			
			var Myclusters;
			var x;
			var y;
			var width;
			var height;
		};
		Frames = function(json){
			// make my clusters
			// ou Frame vide 
		};
		Frames.prototype.draw = function(){
		}
		Frames.prototype.zoom = function(){
		}
		Frames.prototype.inside = function(){
		}
		var Clusters = function(){
			var Object;
			var yDist;
			var x;
			var y;
			var width;
			var height;
		};
		Clusters = function(json){
			// make my object
		};
		var Tweet = function(){
		}
		// Classes =======================================================================
		
		// trace function 
		var traceNum = 0;
		function trace(msg,value){
			traceNum += 1;
			__IriSP.jQuery("<div>"+traceNum+" - "+msg+" : "+value+"</div>").appendTo("#output");
		}
		
		// Refactoring (parametere) ************************************************************
		// color translastion
		function colorTranslation(value){
			if(value == "Q"){
				return 2;
			}else if(value =="REF"){
				return 4;
			}else if(value =="OK"){
				return 1;
			}else if(value =="KO"){
				return 3;
			}else if(value ==""){
				return 5;
			}
		}
		
		
		// Refactoring (parametere) ************************************************************
		// load tweets send in parameters 
		__IriSP.jQuery.ajax({
		  dataType: "jsonp",
		  url:"http://www.iri.centrepompidou.fr/dev/ldt/ldtplatform/ldt/cljson/id/f410655c-5a4d-11e0-a392-00145ea49a02",
		  success : function(json){
			trace("load","");
				__IriSP.jQuery.each(json.annotations, function(i,item) {
					
					var MyTime  = Math.floor(item.begin/duration*lineSize);
					var Myframe = Math.floor(MyTime/lineSize*frameLenght);

					if (item.content['polemics'] != undefined) {
						if (item.content['polemics'][0] != null) {
							
								for(var j=0; j<item.content['polemics'].length; j++){

										tweets[numberOfTweet] = {
													id:i,
													qualification:colorTranslation(item.content['polemics'][j]),
													yIndicator:MyTime,
													yframe:Myframe,
													title:item.content['title'],
													timeframe:item.begin
													}
										numberOfTweet+=1;
								}
						}else{
							//trace("k = ",i);
							tweets[numberOfTweet] = {
										id:i,
										qualification:colorTranslation(""),
										yIndicator:MyTime,
										yframe:Myframe,
										title:item.content['title'],
										timeframe:item.begin
							}
							numberOfTweet+=1;
						}
						
					} else {
						//trace("tweet qualification = ","null");
					}
				});	
			trace("======= ",numberOfTweet);
		   DrawTweets ();
		   
		  }
		 });
			

		// tweet Drawing (in raphael) 
		function DrawTweets (){
		// GROUPES TWEET ============================================
		// Count nbr of cluster and tweet in a frame an save int in "frames"
			numberOfTweet = tweets.length;
			for(var i=0; i<nbrframes; i++) {	
				for(var j=0; j<numberOfTweet; j++) {	
				
					if (i==tweets[j].yframe){
						
						var k = tweets[j].qualification;
						
						// make array for frame cluster
						if(frames[i]==undefined){
							frames[i] = {id:i,
										 qualifVol:new Array(),
										 mytweetsID:new Array()
										};
						}
						// add my tweet to frame
						frames[i].mytweetsID.push(tweets[j]);
						
						// count opinion by frame
						if( frames[i].qualifVol[k] == undefined){
							frames[i].qualifVol[k] = 1;
						}else{
							frames[i].qualifVol[k] += 1;
						}
						
					}
				}
			}
		
		// GROUPES TWEET ============================================		
		// max of tweet by Frame 
			var max = 0; 
			for(var i=0; i<nbrframes; i++) {
				var moy	= 0;
				for (var j=0; j<6; j++){		
					if (frames[i]!=undefined){
						if (frames[i].qualifVol[j]!=undefined){
							moy += frames[i].qualifVol[j]
						}
					}
				}
				//trace("frame "+i,moy);
				if (moy>max){max=moy;}
			}
		
			var tweetDrawed = new Array();
			var TweetHeight = 5;
			// DRAW  TWEETS ============================================
			for(var i=0; i<nbrframes;i++) {
				var addEheight = 5;
				if (frames[i]!=undefined){
					trace (i+" k=",frames[i].mytweetsID.length);
					// by type 
					for (var j=6; j>-1; j--){
						if (frames[i].qualifVol[j]!=undefined){
							// show tweet by type 
							for (var k=0; k<frames[i].mytweetsID.length; k++){
								if (frames[i].mytweetsID[k].qualification==j){
									e = paper.rect( i*frameSize, 					// x
													config.heightmax-addEheight,	// y
													frameSize-margin,				// width
													TweetHeight						// height
													).attr({stroke:"#00","stroke-width":0.1,  fill: colors[j]});	
									addEheight +=TweetHeight;
									e.time= frames[i].mytweetsID[k].timeframe;
									e.title= frames[i].mytweetsID[k].title;
									e.mouseover(function () {
										//this.attr({stroke:"#fff","stroke-width":5});
										//this.toFront();
									}).mouseout(function () {
										//this.attr({stroke:"#00","stroke-width":0.1});	
									}).mousedown(function () {
										__IriSP.MyApiPlayer.seek(this.time/1000)
									});
									__IriSP.jQuery(e.node).attr('id', 't'+k+'');
									__IriSP.jQuery(e.node).attr('title', frames[i].mytweetsID[k].title);
									__IriSP.jQuery(e.node).attr('begin',  frames[i].mytweetsID[k].timeframe);
									var tempPosition = {x:i*frameSize,y:config.heightmax-addEheight}
									addTip(e.node, frames[i].mytweetsID[k].title,colors[j],tempPosition);
									//frames[i].mytweetsID.pop();
								}
							}
						}
					}
				}
				PaperSlider.toFront();
			}
				
		}
	//
		PaperSlider.toFront();
	}

	
	$(document).mousemove(function(e){
		if (over){
			__IriSP.jQuery("#tip").css("left", e.pageX-106).css("top", e.pageY-160);
			__IriSP.jQuery("#tipcolor").css("background-color", tipColor)
			__IriSP.jQuery("#tiptext").text(tipText);
			__IriSP.jQuery("#tip").show();
		}else{
			 __IriSP.jQuery("#tip").css("left", -10000).css("top", -100000);
			 //tweetSelection.attr({x:-100,y:-100});
		}
	});
	
	var over 	 = false;
	var tipText  = "";
	var tipColor = "#efefef";
	var tweetSelection;
	var PaperSlider;
	
	// AddTip  ******************************************************************************
	function addTip(node, txt,color,tempPosition){
			__IriSP.jQuery(node).mouseover(function(){
			   tipText = txt;
			   //tip.hide();//fadeIn(0);
			   tipColor = color;
			   over = true;
			   //tweetSelection.attr(tempPosition);
			   //tweetSelection.toFront();
			}).mouseout(function(){
			   //tip.show()//tip.fadeOut(0);
			   over = false;
			});
			

	}
	
		$(document).ready(function() {
			var tip 	 = __IriSP.jQuery("#tip").hide();
			//ChartTimeLine();
			
		});
	</script>	
  
  <body>
  
<!-- SCRIPT RAPHAEL -->


  
  <!-- tooltip --> 
  <div id="tip">
  <div id="tipcolor" style="height:10px;width:10px"></div>
  <div id="tiptext"></div>
  </div>


  
  
  
  
    <div class="container">
	
	
	
      <img src="images/ENMI_2010_logo.gif" class="logo">
	  <ul class="menu"> 
		  <li class="menuUnderline"><a href="index.php" class="menuLink" id="About"> À propos</a></li>
		  <li class="menuUnderline" ><a href="http://www.rslnmag.fr/blog/2011/3/13/_nous-en-sommes-2020_toutes-les-donnees-sont-liberees_/" class="menuLink" target="_blank"> Programme</a>
		  <li  ><a href="polemicaltimeline.php" class="menuLink">Lecteur polémique</a></li>

	  </ul>

	



	
	  <div class="tweetExplain"  >
		<h3 class="tweetWriterTitle">Annotations pol&eacute;mique : </h3><br/>
		l’Institut de recherche et d’innovation (Iri) vous a proposé une expérimentation et une démonstration d’un dispositif d’annotation polémique basé sur twitter.
Cette qualification de vos tweets nous a permis de créer une timeline polemique représentant les positions de 
l'auditoire durant la conférence.
<br/><br/>

	Cette syntaxe polémique vous a premis de prendre position relativement à l’intervenant ou aux autres participants au débat : 
	<table>
	<tr>
	<td>
			<a 
					
					id="positive"
					title="accord"
					class="tweetButton">++</a> </td><td>correspond à un tweet d’assentiment</td>
	</tr>
	<tr>
	<td>
					
					<a 
					
					id="negative"
					title="désaccord"
					class="tweetButton">--</a></td><td> à un tweet de désaccord,</td>
	</tr>
	<tr>
	<td>
					<a
					
					id="reference"
					title="reference"
					class="tweetButton">==</a></td><td> à un tweet de référence</td>
	</tr>
	<tr>
	<td>			
					<a 
					
					id="question"  
					title="question"
					class="tweetButton"> ??</a></td><td> à une question</td>
	</tr>
	</table>

	Suite a cette phase d’annotation, vous trouverez à droite de ce texte <b>la version alpha</b> de l'interface de navigation et de représentation de la polémique durant la conférence.
		
		<br/><br/>
Ce dispositif, outre qu’il approfondit la dimension critique de la discussion avec la salle et les auditeurs présents ou distants, permet ainsi également de pérenniser et de valoriser les commentaires produits en les rendant accessibles en temps différé lors de tout visionnage ultérieur de la vidéo 
		<br/>
		<br/>Merci a RSLN pour cette expérimentation !
	  </div>
  
  
  
  
  
	  <div class="videoLive" >
		<div class="videoLivePlayer">

		<div id="chartTimeline"> </div>	
		<script type="text/javascript">
var paper = Raphael(document.getElementById("chartTimeline"),config.width, config.height);
			paper.rect(0,20,config.width,config.heightmax-20).attr({fill:"#fff","stroke-width":0.1,opacity: 0.1});	
			paper.rect(0,20,config.width,2).attr({fill:"#fff",stroke: "none",opacity: 1});	
			PaperSlider = paper.rect(0,20,1,50).attr({fill:"#fff",stroke: "none",opacity: 1});	
			// decalage 
			tweetSelection = paper.rect(-100,-100,5,5).attr({fill:"#fff",stroke: "none",opacity: 1});	
		</script>
		
		<script type='text/javascript' src='res/metadataplayer/src/js/LdtPlayer.js'></script>
		<script type="text/javascript">
			$.extend(__IriSP.lib,{jQueryToolTip:"res/metadataplayer/res/js/jquery.tools.min.js"});
		</script>
		<div id="player_project_13b0aa52-336b-11e0-b233-00145ea49a02_embed" class="iri_player_embed"> </div>
		
			<script type="text/javascript">
				var configMP = {
						/*metadata:{
							format:'cinelab',
							src:'metadata.json',
							load:'json'},*/
						metadata:{
							format:'cinelab',
							src:'http://www.iri.centrepompidou.fr/dev/ldt/ldtplatform/ldt/cljson/id/f410655c-5a4d-11e0-a392-00145ea49a02',
							load:'jsonp'},
						gui:{
							width:650,
							height:480,
							mode:'video',
							container:'player_project_13b0aa52-336b-11e0-b233-00145ea49a02_embed',
							debug:false,
							css:'http://amateur.iri.centrepompidou.fr/live/rsln/res/css/LdtPlayer.css'},
	
						player:{
							type:'jwplayer',
							src:'http://www.iri.centrepompidou.fr//dev/ldt/static/ldt/swf/player.swf'}
					};
				__IriSP.init(configMP);     
			</script>
			
		</div>	
		
	  </div>
 
 
 
 
 
      <div class="footer">
		<hr>
		 <a href="http://www.iri.centrepompidou.fr/" class="footerLink" target="_blank">
 IRI </a>
		 |  <a href="http://www.rslnmag.fr/" class="footerLink" target="_blank" > RSLN  </a>
		 |  <a href="http://wegf.org/" class="footerLink"  target="_blank"> World e.gov Forum </a>
		 |  <a href="http://www.microsoft.fr/" class="footerLink" target="_blank"> MICROSOFT.fr  </a>
		 <?php 
				if (isset($_SESSION['TWITTER_ACCESS_TOKEN'])){
					echo("| 	<a href='clear.php'  class='footerLink'>D&eacute;connexion</a>");
				}
		 ?>
	  </div>   
	
    </div>
	


	
	
  </body>
</html>
