<?php
$config = array(
    'rep' => basename(__DIR__),
    'title' => 'Entretiens du Nouveau Monde Industriel 2020 - Session 4',
    'hashtag' => "#enmi20",
    'abstract' => "<b>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</b><br><em>Paris. Centre Pompidou. Grande Salle.<br>22 et 23 décembre 2020</em>", 

    'description' => "
    <h3>Session 4 : L’individuation psychique et collective dans les milieux digitaux : données et profils, addictions et attentions</h3>
    <p>
    Depuis la surexposition aux écrans des jeunes enfants jusqu’aux nouvelles formes d’addictions aux applications, depuis l’exploitation des données personnelles jusqu’à la diffusion des fake news, en passant par la généralisation de la surveillance, l’extension des technologies numériques dans toutes les sphères de l’existence (notamment par l’intermédiaire des smartphones) engendrent de nouvelles pathologies, à la fois psychiques et sociales, et soulèvent de nouvelles questions, à la fois juridiques et politiques. Longtemps restés inaperçus, ces phénomènes inquiètent aujourd’hui massivement : aussi bien les citoyens (parents et adolescents) que les organisations internationales, aussi bien les professionnels de la santé, de l’éducation et du soin, que les designers de la Silicon Valley. Quels sont les effets psycho-sociaux engendrés par les nouvelles formes de télé-communication numérisée ? En quoi transforment-elles les manières de se rapporter à soi-même et aux autres ? En quoi les processus d’individuation psychiques et collectives sont-ils perturbés ? Comment transformer les modèles comportementalistes et neurologiques qui sous-tendent le fonctionnement des « réseaux anti-sociaux » et l’économie des données ?
    </p>
    <br>
    <h4>Mercredi 23 décembre – 9h30-13h00</h4>
    <ul>
    <li><b>09h30</b> : Introduction générale</li>

    <li><b>10h00</b> : Marie-Claude Bossière (Pédopsychiatrie, Institut de recherche et d’innovation)</li>

    <li><b>10h30</b> : Simon Woillet (Philosophie, littérature et psychanalyse, université Paris 3)</li>

    <li><b>11h00</b> : Pause</li>

    <li><b>11h15</b> : Gerald Moore  (Philosophie et anthropologie, Durham university)</li>

    <li><b>11h45</b> : Peter Szendy (Philosophie et musicologie, université Paris Nanterre)</li>

    <li><b>12h15</b> : Discussion</li>
    </ul>
    <br>
    <br>
    <h3>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</h3>
    <p>22 et 23 décembre 2020<br>
    <a href=\"https://enmi-conf.org/wp/enmi20\" target=\"_blank\">https://enmi-conf.org</a>
    </p>
    <br>
    <strong>14ème édition</strong>
    <br><br>

    <p>
    Argumentaire et programme rédigés par Anne Alombert (UCL), 
    Victor Chaix (IRI) et Maël Montévil (IRI)
    </p>

    <p>
    En proposant de prendre soin de l’informatique et des générations, 
    les Entretiens du Nouveau Monde Industriel 2020 poursuivent deux objectifs principaux&nbsp;:
    </p>

    <p>
    . interroger les fondements théoriques de l’informatique 
    qui commandent le fonctionnement des technologies numériques contemporaines&nbsp;;
    </p>

    <p>
    . et concevoir de nouveaux dispositifs et de nouvelles pratiques pour mettre 
    ces technologies au service de la transmission, du partage et de la constitution de savoirs transgénérationnels.
    </p>

    <p>
    Nous tenterons ainsi de repenser la question de l’intelligence artificielle à partir 
    d’un nouveau paradigme théorique, qui ne se fonde plus sur l’analogie entre l’humain 
    et la machine, mais qui prenne en compte les interactions entre individus psychiques, 
    milieux techniques et organisations sociales : au lieu d’envisager la vie ou l’esprit 
    comme des processus de traitement d’information, comme le propose les paradigmes cybernétiques 
    et cognitivistes dominants, nous nous interrogerons sur le processus d’exosomatisation, à travers
    lequel les vivants humains extériorisent leurs fonctions noétiques dans des organes artificiels, 
    qui peuvent ainsi devenir les supports d’une mémoire collective et de savoirs transgénérationnels dont il faut prendre soin.
    </p>

    <p>
    Nous tenterons ensuite de traduire ces questions théoriques en terme de conception 
    et de développement technologiques. Comment réaliser des plateformes numériques au service 
    des relations sociales et intergénérationnelles, aujourd’hui menacées par les applications addictives 
    et l’économie des données ? Comment intégrer dans les dispositifs computationnels des fonctions délibératives
    et interprétatives, qui dépassent toujours les programmes calculables en produisant des bifurcations improbables ? 
    Comment transformer les technologies de l’information et de la communication en supports de mémoire, d’interprétation, 
    de délibération et d’invention, au service du partage des savoirs et de l’intelligence collective, et pour répondre aux 
    enjeux de l’ère post-vérité ? En un mot, comment penser un web herméneutique et transgénérationnel ?
    </p>
    <br>",

    'link' => "https://enmi-conf.org/wp/enmi20/",
    'islive' => false,
    'islive_embed' => "",
    'keywords' => "Informatique, générations, ENMI, Centre Pompidou, soin",
    'annotation_protocol_version' => "3",
    'partenaires' => "<a href=\"http://www.iri.centrepompidou.fr/\" class=\"footerLink\" target=\"_blank\">&nbsp;IRI </a> |&nbsp; <a href=\"https://www.univ-catholille.fr/\" class=\"footerLink\" target=\"_blank\">Université Catholique de Lille</a> |&nbsp; <a href=\"https://www.capdigital.com/\" class=\"footerLink\" target=\"_blank\">Cap Digital</a>  &nbsp;|&nbsp; <a href=\"http://realsms.eu/\" class=\"footerLink\" target=\"_blank\"> Real Smart Cities </a>",

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2020 - Session 4",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou le 23 décembre 2020',

    'client_visual' => "images/client_visual.jpg",
    'head_logo' => "images/logo-enmi.png",
    'slide_background' => "images/slide_background.jpg",
    'archive_img' => "images/archive_img.jpg",
    'metadata'    => "1c5e157d-54c1-11eb-aff6-00145ea4a2be",
);
