from lxml import etree
from optparse import OptionParser #@UnresolvedImport

def get_options():

    parser = OptionParser()

    parser.add_option("-f", "--file", dest="outputfile",
                      help="destination filename", metavar="FILE", default="twitter_export_conf.xml")
    parser.add_option("-i", "--input", dest="inputfile", 
                      help="inputfile", metavar="INPUT", default=None)

    return parser.parse_args()

if __name__ == "__main__":
    (options, args) = get_options()
    
    dest_filename = options.outputfile
    
    path_list = []
    if options.inputfile is None:
        path_list = args
    else:
        with open(options.inputfile, 'r') as fi:
            path_list = fi
    
    
    root = etree.Element("twitter_export")
    
    
    for path in path_list:
        
        iri_doc = etree.parse(path)
        media_nodes = iri_doc.xpath("/iri/body/medias/media[@id='video']/video")
        duration = int(media_nodes[0].get("dur"))/1000
        
        file_elem = etree.SubElement(root, "file")
        etree.SubElement(file_elem, "path").text = path
        etree.SubElement(file_elem, "start_date")
        etree.SubElement(file_elem, "duration").text = unicode(duration)
         
    tree = etree.ElementTree(root)
    tree.write(dest_filename, encoding="utf-8", pretty_print=True, xml_declaration=True)