<?php
$config = array(
    'rep' => basename(__DIR__),
    'title' => 'Entretiens du Nouveau Monde Industriel 2021',
    'hashtag' => "#enmi21",
    'abstract' => "<b>LA SOCIÉTÉ INTERMITTENTE</b><br><em>Paris. Centre Pompidou. Grande Salle.<br>29 et 30 novembre 2021</em>", 

    'description' => "<h3>LA SOCIÉTÉ INTERMITTENTE</h3>
    <p>29 et 30 décembre 2021<br>
    <a href=\"https://enmi-conf.org/wp/enmi21\" target=\"_blank\">https://enmi-conf.org</a>
    </p>
    <br>
    <strong>14ème édition</strong>
    <br><br>

    <p>
    Argumentaire et programme rédigés par Anne Alombert (UCL), 
    Victor Chaix (IRI) et Maël Montévil (IRI)
    </p>

    <p>
    En proposant de prendre soin de l’informatique et des générations, 
    les Entretiens du Nouveau Monde Industriel 2020 poursuivent deux objectifs principaux&nbsp;:
    </p>

    <p>
    . interroger les fondements théoriques de l’informatique 
    qui commandent le fonctionnement des technologies numériques contemporaines&nbsp;;
    </p>

    <p>
    . et concevoir de nouveaux dispositifs et de nouvelles pratiques pour mettre 
    ces technologies au service de la transmission, du partage et de la constitution de savoirs transgénérationnels.
    </p>

    <p>
    Nous tenterons ainsi de repenser la question de l’intelligence artificielle à partir 
    d’un nouveau paradigme théorique, qui ne se fonde plus sur l’analogie entre l’humain 
    et la machine, mais qui prenne en compte les interactions entre individus psychiques, 
    milieux techniques et organisations sociales : au lieu d’envisager la vie ou l’esprit 
    comme des processus de traitement d’information, comme le propose les paradigmes cybernétiques 
    et cognitivistes dominants, nous nous interrogerons sur le processus d’exosomatisation, à travers
    lequel les vivants humains extériorisent leurs fonctions noétiques dans des organes artificiels, 
    qui peuvent ainsi devenir les supports d’une mémoire collective et de savoirs transgénérationnels dont il faut prendre soin.
    </p>

    <p>
    Nous tenterons ensuite de traduire ces questions théoriques en terme de conception 
    et de développement technologiques. Comment réaliser des plateformes numériques au service 
    des relations sociales et intergénérationnelles, aujourd’hui menacées par les applications addictives 
    et l’économie des données ? Comment intégrer dans les dispositifs computationnels des fonctions délibératives
    et interprétatives, qui dépassent toujours les programmes calculables en produisant des bifurcations improbables ? 
    Comment transformer les technologies de l’information et de la communication en supports de mémoire, d’interprétation, 
    de délibération et d’invention, au service du partage des savoirs et de l’intelligence collective, et pour répondre aux 
    enjeux de l’ère post-vérité ? En un mot, comment penser un web herméneutique et transgénérationnel ?
    </p>

    <br>
    <h3>Programme initial</h3>
    <h4><strong>ATTENTION, ce programme est encore susceptible de varier.</strong></h4>
    <br>
    <p><strong>Mardi 22 décembre&nbsp;: Repenser l’informatique théorique</strong></p>
    </br>
    <p><strong>09h30-12h30 - Session 1 : Vers une nouvelle informatique théorique : de l’information à l’exosomatisation, enjeux philosophiques, économiques et politiques</strong></p>
    <ul>
    <li><p><strong>09h30 : Introduction générale</strong></p></li>
    <li><p><strong>10h15 : Anne Alombert (Philosophie, université catholique de Lille)</strong></p></li>
    <li><p><strong>10h45 : Mathieu Triclot  (Philosophie, université de technologie de Belfort-Montbéliard)</strong></p></li>
    <li><p><strong>11h15 : <i>Pause</i></strong></p></li>
    <li><p><strong>11h30 : Daniel Ross (Philosophie politique, collectif Internation)</strong></p></li>
    <li><p><strong>12h00 : <i>Discussion</i></strong></p></li>
    <li><p><strong>12h30 : <i>Pause</i></strong></p></li>
    </ul>
    <br>
    <p><strong>13h30 : 16h30 - Session 2 : Information et signification, de la vie endosomatique à la vie exosomatique : entre calcul et incalculable, entre biologie et informatique</strong></p>
    <ul> 
    <li><p><strong>13h30 : Yuk Hui (Informatique, philosophie de la technique, Hong Kong University)</strong></p></li>
    <li><p><strong>14h00 : Maël Montévil (Biologie théorique et épistémologie, IRI et IHPST, université paris 1)</strong></p></li>
    <li><p><strong>14h30 : <i>Pause</i></strong></p></li>
    <li><p><strong>14h45 : Giuseppe Longo (Mathématiques et épistémologie, CNRS et ENS) & Jean Lassègue (anthropologie philosophique, CNRS LIAS)</strong></p></li>
    <li><p><strong>15h45 : <i>Discussion</i></strong></p></li>
    <li><p><strong>16h30 : <i>Pause</i></strong></p></li>
    </ul>
    <br>
    <p><strong>17h00 : 19h30 - Session 3 : Technologies de la langue, programmes musicaux et langages informatiques : des données calculables aux improvisations interprétatives</strong></p>
    <ul>
    <li><p><strong>17h00 : Frédéric Kaplan (Informatique et linguistique, École Polytechnique Fédérale de Lausanne)</strong></p></li>
    <li><p><strong>17h30 : Michal Krzykawski (Philosophie, université de Silésie à Katowice)</strong></p></li>
    <li><p><strong>18h00 : <i>Pause</i></strong></p></li>
    <li><p><strong>18h15 : Gerard Assayag (Musicologie et informatique, IRCAM)</strong></p></li>
    <li><p><strong>18h45 : <i>Discussion</i></strong></p></li>
    </ul>
    <br>
    <br>
    <p><strong>Mercredi 23 décembre&nbsp;: Renouer les technologies et les générations</strong></p>
    <br>
    <p><strong>09h30 : 13h00 - Session 4 : L’individuation psychique et collective dans les milieux digitaux : données et profils, addictions et attentions</strong></p>
    <ul>
    <li><p><strong>09h30 : Introduction générale</strong></p></li>
    <li><p><strong>10h00 : Marie-Claude Bossière (Pédopsychiatrie, Institut de recherche et d’innovation)</strong></p></li>
    <li><p><strong>10h30 : Simon Woillet (Philosophie et psychanalyse, Université Paris 3)</strong></p></li>
    <li><p><strong>11h00 : <i>Pause</i></strong></p></li>
    <li><p><strong>11h15 : Gerald Moore (Philosophie et anthropologie, Durham University)</strong></p></li>
    <li><p><strong>11h45 : Peter Szendy (Philosophie et musicologie, Université Paris Nanterre)</strong></p></li>
    <li><p><strong>12h15 : <i>Discussion</i></strong></p></li>
    <li><p><strong>13h00 : <i>Pause</i></strong></p></li>
    </ul>
    <br>
    <p><strong>14h00 : 16h30 - Session 5 : Éducations et capacitation dans l'ère post-véridique : technologies numériques, médias sociaux et savoirs transgénérationnels</strong></p>
    <ul> 
    <li><p><strong>14h00 : Victor Chaix (Étudiant et activiste, Institut de Recherche et d’Innovation et Association des amis de la génération Thunberg)</strong></p></li>
    <li><p><strong>14h15 : Tyler Reigeluth (Philosophie, Université Catholique de Lille)</strong></p></li>
    <li><p><strong>14h45 : Franck Cormerais (Sciences de l’information et de la communication, Université Bordeaux Montaigne)</strong></p></li>
    <li><p><strong>15h15 : Maxime Barillaud (Enseignement et référent numérique, Collège Poincaré)</strong></p></li>
    <li><p><strong>15h45 : <i>Discussion</i></strong></p></li>
    <li><p><strong>16h30 : <i>Pause</i></strong></p></li>
    </ul>
    <br>
    <p><strong>17h00 : 19h30 - Session 6 : Recherche et design dans les milieux digitaux : des programmes aux bifurcations</strong></p>
    <ul>
    <li><p><strong>17h00 : Tallulah Frappier (Design d’interaction et plateformes de délibérations, ENS Cachan) & Samuel Huron (Mines-Telecom)</strong></p></li>
    <li><p><strong>17h20 : Anthony Masure (Philosophie et design, HEAD - Genève et université Toulouse - Jean Jaurès)</strong></p></li>
    <li><p><strong>17h40 : Stéphane Crozat (Framasoft et UTC)</strong></p></li>
    <li><p><strong>18h00 : Sébastien Massart (Directeur de la stratégie de Dassault Systèmes)</strong></p></li>
    <li><p><strong>18h20 : Noël Fitzpatrick (Arts et technologie, Université Technologique de Dublin)</strong></p></li>
    <li><p><strong>18h45 : <i>Discussion</i></strong></p></li>
    </ul>",

    'link' => "https://enmi-conf.org/wp/enmi21/",
    'islive' => true,
    'islive_embed' => "",
    'keywords' => "Informatique, société, ENMI, Centre Pompidou, intermittence",
    'annotation_protocol_version' => "3",
    'partenaires' => "<a href=\"http://www.iri.centrepompidou.fr/\" class=\"footerLink\" target=\"_blank\">&nbsp;IRI </a> |&nbsp; <a href=\"https://www.univ-catholille.fr/\" class=\"footerLink\" target=\"_blank\">Université Catholique de Lille</a> |&nbsp; <a href=\"https://www.capdigital.com/\" class=\"footerLink\" target=\"_blank\">Cap Digital</a>  &nbsp;|&nbsp; <a href=\"http://realsms.eu/\" class=\"footerLink\" target=\"_blank\"> Real Smart Cities </a>",

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2020",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou les 29 et 30 novembre 2021',

    'client_visual' => "images/client_visual.jpg",
    'head_logo' => "images/logo-enmi.png",
    'slide_background' => "images/slide_background.jpg",
    'archive_img' => "images/archive_img.jpg",
    // 'semantic_board' => true,
    // 'js_config' => "
    //     tracking_keywords = [ '#enmi18' ],
    //     suggested_keywords = []
    // ",
);
