var socket,
    tweetData = {
        "tweetcount" : 0,
        "position" : -1,
        "zoomLevel" : 3,
        "timeLevel" : 2
    }
    zoomLevels = [
        {
            "description" : "160 tweets per page",
            "className" : "icons",
            "displayCount" : 160
        },
        {
            "description" : "24 tweets per page",
            "className" : "quarter",
            "displayCount" : 24
        },
        {
            "description" : "12 tweets per page",
            "className" : "half",
            "displayCount" : 12
        },
        {
            "description" : "6 tweets per page",
            "className" : "full",
            "displayCount" : 6
        }
    ];

function tweetToHtml(tweet) {
	html = '<li class="tweet ' + zoomLevels[tweetData.zoomLevel].className;
	for (var i in tweet.annotations) {
		html += ' a_' + tweet.annotations[i]
	}
	html += '" id="tweet_' + tweet.id + '">';
	a_user = '<a href="http://twitter.com/' + tweet.user.screen_name + '" target="_blank" title="' + tweet.user.name + '">';
	if (tweet.user.profile_image_url) {
		html += a_user + '<img class="tweet_profile_image" src="' + tweet.user.profile_image_url + '" /></a>';
	}
	html += '<h4>' + a_user + '@' + tweet.user.screen_name + '</a></h4><p class="tweet_created_at">' + new Date(tweet.created_at).toLocaleTimeString() + '</p><p>';
	lastend = 0;
	txt = '';
	entities = [];
	for (var i in tweet.entities.hashtag) {
	    entities.push({
	        "start" : tweet.entities.hashtag[i].indices[0],
	        "end" : tweet.entities.hashtag[i].indices[1],
	        "html" : '<a href="http://twitter.com/search?q=%23' + tweet.entities.hashtag[i].text + '" target="_blank">#' + tweet.entities.hashtag[i].text + '</a>'
	    });
	}
	for (var i in tweet.entities.urls) {
	    entities.push({
	        "start" : tweet.entities.urls[i].indices[0],
	        "end" : tweet.entities.urls[i].indices[1],
	        "html" : '<a href="' + tweet.entities.urls[i].expanded_url + '" target="_blank">' + tweet.entities.urls[i].display_url + '</a>'
	    });
	}
	for (var i in tweet.entities.user_mentions) {
	    entities.push({
	        "start" : tweet.entities.user_mentions[i].indices[0],
	        "end" : tweet.entities.user_mentions[i].indices[1],
	        "html" : '<a href="http://twitter.com/' + tweet.entities.user_mentions[i].screen_name + '" target="_blank" title="' + tweet.entities.user_mentions[i].name + '">@' + tweet.entities.user_mentions[i].screen_name + '</a>'
	    });
	}
 	entities.sort(function(a, b) { return a.start - b.start });
    for (var i in entities) {
 		txt += tweet.text.substring(lastend, entities[i].start) + entities[i].html;
        lastend = entities[i].end;
    }
	txt += tweet.text.substring(lastend);
	html += txt + '</p></li>';
	return html;
}

function getTweets() {
    var to = tweetData.position + 1,
        from = Math.max(0, to - zoomLevels[tweetData.zoomLevel].displayCount);
    socket.emit('getTweets',{ "from": from, "to": to });
}

function setZoom(level) {
    tweetData.zoomLevel = Math.max(0, Math.min( zoomLevels.length - 1 , level ) );
    getTweets();
}

$(document).ready(function() {
    socket = io.connect('http://' + S_IO_HOST + ':' + S_IO_PORT );
    socket.on('tweetSummary', function (data) {
        if (tweetData.position == tweetData.tweetcount - 1) {
            tweetData.position = data.tweetcount - 1;
            getTweets();
        }
        tweetData.tweetcount = data.tweetcount;
    });
    socket.on('tweets', function (data) {
        tweetData.tweetsOnDisplay = data;
        data.reverse();
        html = '';
        for (var i in data) {
            html += tweetToHtml(data[i]);
        }
        $("#tweetlist").html(html);
    });
});