<?php
include_once 'common.php';

$user_data = authenticate($C_event_users, $translate);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
	header("Location: ./event_form.php");
	exit;
}

function create_zip($zip_path,$zip_folder, $config_values, $files) {
    $zip = new ZipArchive;
    if($zip->open($zip_path, ZipArchive::CREATE | ZipArchive::OVERWRITE) === FALSE) {
    	return FALSE;
    }
    $config_content = "<?php\n\$config = array(\n    'rep' => basename(__DIR__),\n";
    foreach ($config_values as $key => $value) {
    	if($value === "__TRUE__") {
    		$config_content .= "    '$key' => true,\n";
    	}
    	elseif ($value === "__FALSE__") {
    		$config_content .= "    '$key' => false,\n";
    	}
    	else {
    		$config_content .= "    '$key' => \"".addslashes($value)."\",\n";
    	}
    }
    $config_content .= ");\n";
    
    $zip->addEmptyDir($zip_folder);
    $zip->addFromString("$zip_folder/config.php", $config_content);
    $zip->addFromString("$zip_folder/index.php", "<?php\n// Permanent redirection\n\nheader(\"HTTP/1.1 301 Moved Permanently\");\nheader(\"Location: client.php\");\nexit();");
    
    $zip->addEmptyDir("$zip_folder/images");
    foreach ($files as $key => $file_desc) {
    	if($file_desc['size']>0) {
            $zip->addFile($file_desc['tmp_name'], "$zip_folder/images/".sanitize_filename($file_desc['name']));
    	}
    }
    
    return $zip->close();
}


?>

<!DOCTYPE html>
<html lang="<?php echo($actual); ?>">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Polemic Tweet &mdash; event form</title>
    <meta http-equiv="X-UA-Compatible" content="IE=9" />

    <!-- FONT -->
    <link href='<?php echo(registry_url('PT-Sans_Narrow','font'))?>' rel='stylesheet' type='text/css'>
    <link href='<?php echo(registry_url('PT-Sans','font'))?>' rel='stylesheet' type='text/css'>
    
    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo(registry_url('blueprint-screen','css'));?>" type="text/css" media="screen, projection"/>
    <link rel="stylesheet" href="<?php echo(registry_url('blueprint-print','css'));?>" type="text/css" media="print"/>
    <!--[if lt IE 8]><link rel="stylesheet" href="<?php echo(registry_url('blueprint-ie','css'));?>" type="text/css" media="screen, projection"><![endif]-->
	<link rel="stylesheet" href="<?php echo(registry_url('blueprint-plugins-fancy-type','css'));?>" type="text/css" media="screen, projection"/>
	<link rel="stylesheet" href="<?php echo(registry_url('custom','css'));?>" type="text/css" media="screen, projection"/>
    
    <!-- JAVASCRIPT -->
    <script type="text/javascript" src="<?php echo(registry_url('jquery','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('underscore','js'))?>"></script>
    
    
</head>
<body>
	<!--div id="sendUsFeedBack"><a href="<?php echo($C_feedback_form_url); ?>" target="_blank"><img src="<?php echo(URL_ROOT); ?>images/sendusfeedback.png"></a></div-->
    <div class="container">
      <img src="images/ENMI_2010_logo.gif" class="logo">
	  <ul class="menu">
		  <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>" class="menuLink">
		  	<?php print $translate->_("Accueil"); ?></a></li>
		  <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>about.php" class="menuLink">
		  	<?php print $translate->_("A propos"); ?></a></li>
		  <li ><a href="mailto:contact@iri.centrepompidou.fr" class="menuLink" >
		  	<?php print $translate->_("Contact"); ?></a></li>
	  </ul>
	  <ul class="menu">
		  <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>archives.php" class="menuLink">
		  	<?php print $translate->_("Archives"); ?></a></li>
		<?php
		if($_SESSION['auth']) { ?>
		  <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>logout.php" class="menuLink">
		  	<?php print $translate->_("Logout"); ?></a></li>
		<?php
		}
		?>
	  </ul>
	  
	  
	  <ul class="menu lang" >
	  <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>index.php?lang=ja_JP" class="menuLink" >
	       <img src='images/flag_jp.gif'<?php if($actual!="ja_JP"){echo("style='opacity: .5;'"); } ?> />
	        <?php print $translate->_("Japonais"); ?></a></li>
	  <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>index.php?lang=fr" class="menuLink">
	       <img src='images/flag_fr.gif' <?php if($actual!="fr"){echo("style='opacity: .5;'"); } ?> />
	       <?php print $translate->_("Français"); ?></a></li>
	  <li ><a href="<?php echo(URL_ROOT); ?>index.php?lang=en" class="menuLink">
	       <img src='images/flag_en.gif' <?php if($actual!="en"){echo("style='opacity: .5;'"); } ?> />
	       <?php print $translate->_("Anglais"); ?></a></li>
	  </ul>
	</div>
	<div class="container">
	<?php
	if(!isset($user_data) || isset($user_data['error'])) {
		print "<div class=\"error-message\"><h2>".$user_data['error']."</h2></div>";
	}
	else {
		
		$config_values = array_merge($_POST);
		
		if(!isset($config_values['title']) || empty($config_values['title'])) {
			print "<div class=\"error-message\"><h2>".$translate->_("Event_error_empty_title")."</h2></div>";
			exit;
		}
		
		foreach ($_FILES as $key => $value) {
			$config_values[$key] = "images/".sanitize_filename(basename($value['name']));
		}
		
		$event_title = slugify($config_values['title']);
		
		$zip_filename = "$C_event_props/$event_title.zip";
		
		create_zip($zip_filename, $event_title, $config_values, $_FILES);
		
		print("<div class=\"process-message\">");
		print $translate->_("Event_recorded_message");
		print("</div>");
	}
	?>
	</div>
</body>