<?php
include_once 'common.php';

$user_data = authenticate($C_event_users, $translate);

?>
<!DOCTYPE html>
<html lang="<?php echo($actual); ?>">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>Polemic Tweet &mdash; event form</title>
    <meta http-equiv="X-UA-Compatible" content="IE=9" />

    <!-- FONT -->
    <link href='<?php echo(registry_url('PT-Sans_Narrow','font'))?>' rel='stylesheet' type='text/css'>
    <link href='<?php echo(registry_url('PT-Sans','font'))?>' rel='stylesheet' type='text/css'>

    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo(registry_url('blueprint-screen','css'));?>" type="text/css" media="screen, projection"/>
    <link rel="stylesheet" href="<?php echo(registry_url('blueprint-print','css'));?>" type="text/css" media="print"/>
    <!--[if lt IE 8]><link rel="stylesheet" href="<?php echo(registry_url('blueprint-ie','css'));?>" type="text/css" media="screen, projection"><![endif]-->
    <link rel="stylesheet" href="<?php echo(registry_url('blueprint-plugins-fancy-type','css'));?>" type="text/css" media="screen, projection"/>
    <link rel="stylesheet" href="<?php echo(registry_url('custom','css'));?>" type="text/css" media="screen, projection"/>
    <link rel="stylesheet" href="<?php echo(registry_url('jquery-te','css'));?>" type="text/css" media="screen, projection"/>

    <!-- JAVASCRIPT -->
    <script type="text/javascript" src="<?php echo(registry_url('jquery','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('underscore','js'))?>"></script>
    <script type="text/javascript" src="<?php echo(registry_url('jquery-tinymce','js'))?>"></script>
    <script type="text/javascript">
        $(function() {
            $("textarea").tinymce({
                script_url : '<?php echo(registry_url('tinymce','js'))?>',
                menubar:false,
                toolbar: "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link unlink | code preview",
                resize: true,
                valid_styles : { '*' : 'color,font-size,font-weight,font-style,text-decoration' },
                paste_use_dialog : true,
                paste_auto_cleanup_on_paste : true,
                convert_fonts_to_spans: true,
                plugins: "code, preview, link, paste",
            });
        });
    </script>
</head>
<body>
    <div id="sendUsFeedBack"><a href="<?php echo($C_feedback_form_url); ?>" target="_blank"><img src="<?php echo(URL_ROOT); ?>images/sendusfeedback.png"></a></div>
    <div class="container">
      <img src="images/ENMI_2010_logo.gif" class="logo">
      <ul class="menu">
          <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>" class="menuLink">
          	<?php print $translate->_("Accueil"); ?></a></li>
          <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>about.php" class="menuLink">
          	<?php print $translate->_("A propos"); ?></a></li>
          <li ><a href="mailto:contact@iri.centrepompidou.fr" class="menuLink" >
          	<?php print $translate->_("Contact"); ?></a></li>
      </ul>
      <ul class="menu">
          <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>archives.php" class="menuLink">
          	<?php print $translate->_("Archives"); ?></a></li>
        <?php
        if($_SESSION['auth']) { ?>
          <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>logout.php" class="menuLink">
          	<?php print $translate->_("Logout"); ?></a></li>
        <?php
        }
        ?>
      </ul>


      <ul class="menu lang" >
      <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>event_form.php?lang=ja_JP" class="menuLink" >
           <img src='images/flag_jp.gif'<?php if($actual!="ja_JP"){echo("style='opacity: .5;'"); } ?> />
            <?php print $translate->_("Japonais"); ?></a></li>
      <li class="menuUnderline"><a href="<?php echo(URL_ROOT); ?>event_form.php?lang=fr" class="menuLink">
           <img src='images/flag_fr.gif' <?php if($actual!="fr"){echo("style='opacity: .5;'"); } ?> />
           <?php print $translate->_("Français"); ?></a></li>
      <li ><a href="<?php echo(URL_ROOT); ?>event_form.php?lang=en" class="menuLink">
           <img src='images/flag_en.gif' <?php if($actual!="en"){echo("style='opacity: .5;'"); } ?> />
           <?php print $translate->_("Anglais"); ?></a></li>
      </ul>
    </div>
    <div class="container">
<?php
    if(!isset($user_data) || isset($user_data['error'])) {
        print "<div class=\"error-message\"><h2>".$user_data['error']."</h2></div>";
    }
    else {
?>
        <form id="event-form" method="post" enctype="multipart/form-data" action="./event_process.php">
            <fieldset id="event-fields">
                <div class="event-field">
                    <label for="title"><?php print $translate->_("title"); ?>*</label>
                    <input type="text" id="title" name="title" />
                    <div class="event-field-help"><?php print $translate->_("title_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>attention-1314-01-notion-attention/client.php?highlight=%23event-title" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="hashtag"><?php print $translate->_("hashtag"); ?></label>
                    <input type="text" id="hashtag" name="hashtag" alt="format: #hastag"/>
                    <div class="event-field-help"><?php print $translate->_("hashtag_help"); ?></div>
                </div>
                <div class="event-field">
                    <label for="abstract"><?php print $translate->_("abstract");?></label>
                    <textarea name="abstract" id="abstract"></textarea>
                    <div class="event-field-help"><?php print $translate->_("abstract_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>index.php?highlight=%23event-abstract" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="description"><?php print $translate->_("description");?></label>
                    <textarea name="description" id="description"></textarea>
                    <div class="event-field-help"><?php print $translate->_("description_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>attention-1314-01-notion-attention/client.php?highlight=%23event-description" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="link"><?php print $translate->_("link");?></label>
                    <input type="text" name="link" id="link"/>
                    <div class="event-field-help"><?php print $translate->_("link_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>attention-1314-01-notion-attention/client.php?highlight=%23event-link" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="islive"><?php print $translate->_("islive");?></label>
                    <input type="hidden" name="islive" value="__FALSE__"/>
                    <input type="checkbox" name="islive" id="islive" value="__TRUE__"/>
                    <div class="event-field-help"><?php print $translate->_("islive_help"); ?></div>
                </div>
                <div class="event-field">
                    <label for="islive_embed"><?php print $translate->_("islive_embed");?></label>
                    <input type="text" name="islive_embed" id="islive_embed"/>
                    <div class="event-field-help"><?php print $translate->_("islive_embed_help"); ?></div>
                </div>
                <div class="event-field">
                    <label for="keywords"><?php print $translate->_("keywords");?></label>
                    <input type="text" name="keywords" id="keywords"/>
                    <div class="event-field-help"><?php print $translate->_("keywords_help"); ?></div>
                </div>
                <div class="event-field">
                    <label for="annotation_protocol_version"><?php print $translate->_("annotation_protocol_version");?></label>
                    <select name="annotation_protocol_version" id="annotation_protocol_version">
                        <option value="1">1</option>
                        <option value="2" selected>2</option>
                    </select>
                    <div class="event-field-help"><?php print $translate->_("annotation_protocol_version_help"); ?></div>
                </div>
                <div class="event-field">
                    <label for="partenaires"><?php print $translate->_("partenaires");?></label>
                    <textarea name="partenaires" id="partenaires"></textarea>
                    <div class="event-field-help"><?php print $translate->_("partenaires_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>attention-1314-01-notion-attention/client.php?highlight=%23event-partenaires" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="client_visual"><?php print $translate->_("client_visual");?></label>
                    <input type="file" name="client_visual" id="client_visual"/>
                    <div class="event-field-help"><?php print $translate->_("client_visual_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>attention-1314-01-notion-attention/client.php?highlight=%23vlWrap&highlight_effect=pulsate" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="head_logo"><?php print $translate->_("head_logo");?></label>
                    <input type="file" name="head_logo" id="head_logo" />
                    <div class="event-field-help"><?php print $translate->_("head_logo_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>attention-1314-01-notion-attention/client.php?highlight=%23headlogo" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="slide_background"><?php print $translate->_("slide_background");?></label>
                    <input type="file" name="slide_background" id="slide_background"/>
                    <div class="event-field-help"><?php print $translate->_("slide_background_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>index.php?highlight=.slider&highlight_effect=pulsate" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="archive_img"><?php print $translate->_("archive_img");?></label>
                    <input type="file" name="archive_img" id="archive_img" />
                    <div class="event-field-help"><?php print $translate->_("archive_img_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>archives.php?highlight=.AVBimg&highlight_effect=pulsate" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="archive_title"><?php print $translate->_("archive_title");?></label>
                    <input type="text" name="archive_title" id="archive_title"/>
                    <div class="event-field-help"><?php print $translate->_("archive_title_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>index.php?highlight=.AVBtitle" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>
                <div class="event-field">
                    <label for="archive_description"><?php print $translate->_("archive_description");?></label>
                    <textarea name="archive_description" id="archive_description"></textarea>
                    <div class="event-field-help"><?php print $translate->_("archive_description_help"); ?></div>
                    <div class="event-field-example"><a href="<?php echo(URL_ROOT); ?>index.php?highlight=.AVBtext" target="_blank"><?php print $translate->_("Event_example"); ?></a></div>
                </div>

            </fieldset>
            <input type="submit" />
        </form>
    <?php
    }
    ?>
    </div>
</body>
</html>
