<?php
$config = array(
    'rep' => basename(__DIR__),
    'title' => 'Entretiens du Nouveau Monde Industriel 2020 - Sessions 2 et 3',
    'hashtag' => "#enmi20",
    'abstract' => "<b>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</b><br><em>Paris. Centre Pompidou. Grande Salle.<br>22 et 23 décembre 2020</em>", 

    'description' => "
    <h3>Session 2 : Information et signification, de la vie endosomatique à la vie exosomatique : entre calcul et incalculable, entre biologie et informatique</h3>
    <p>
    La notion d’information a été introduite en biologie à la suite de plusieurs événements scientifiques : la publication de la théorie de la communication de Shannon en 1948, la mécanisation de certains calculs avec la première implémentation d’une machine équivalente à celle de Turing (ENIAC) en 1945, et la découverte de la structure de l’ADN en 1953. Et pourtant, d’un point de vue théorique, le concept d’information demeure encore flou aujourd’hui : les biologistes se réfèrent à la fois à Shannon et à Turing, alors que les deux cadres sont fort différents. Surtout, le concept d’information tend à faire accroire que la compréhension du vivant pourrait être obtenue par le “décryptage” de l’ADN, qui donnerait sa forme à l’organisme. De même, dans la vie exosomatique, à l’époque de la génération automatique d’articles par les systèmes d’intelligence artificielle, certains tendent à penser que les textes et plus généralement les données auraient un sens intrinsèque, accessible par une mécanique calculatoire. Dans les deux cas, la notion d’information fait disparaître l’activité vivante au profit d’une interprétation mécanique des processus en jeu, sans que cette dernière ne soit justifiée ou même réellement élaborée théoriquement. Comment dépasser ce paradigme informationnel pour penser non seulement le vivant, mais aussi la forme technique de la vie et les nouvelles machines computationnelles qui constituent son milieu ambiant ?
    </p>
    <br>
    <h4>Mardi 22 décembre – 13h30-16h30</h4>
    <ul>
    <li><b>13h30</b> : Yuk Hui (Informatique, philosophie de la technique, Hong Kong university)</li>

    <li><b>14h00</b> : Maël Montévil (Biologie théorique et épistémologie, IRI et IHPST, université paris 1)</li>

    <li><b>14h30</b> : Pause</li>

    <li><b>14h45</b> : Jean Lassègue (Anthropologie philosophique, CNRS LIAS) & Giuseppe Longo (Mathématiques et épistémologie, CNRS et ENS)</li>

    <li><b>15h45</b> : Discussion</li>

    <li><b>16h30</b> : Pause</li>
    </ul>
    <br>
    <h3>Session 3 : Technologies de la langue, programmes musicaux et langages informatiques : des données calculables aux improvisations interprétatives</h3>
    <p>
    Le stade numérique du processus de grammatisation transforme radicalement les conditions de la lecture, de l’écriture, de la traduction et de l’expression. Si l’informatique émane du langage et si l’ordinateur peut être défini comme une machine à réécriture automatique, cela ne signifie pas pour autant que la pratique des langues puisse être réduite à un processus computationnel. Au contraire, les pratiques linguistiques, y compris la traduction, comportent toujours une dimension diachronique, qui rend possible leurs évolutions à travers les expressions locales et singulières. Or, c’est précisément cette dynamique et cette diversité langagière qui semblent aujourd’hui menacées par le « capitalisme linguistique » de Google, qui exerce un contrôle sur la pratique des langues au moyen d’outils de correction, d’auto-complétion et de traduction automatique, transformant ainsi les savoirs linguistiques locaux en ressources économiques. Comment lutter contre les effets homogénéisants, régularisant et synchronisant de ces nouvelles technologies d’écritures, qui tendent à désidiomatiser les langues ? Aussi performante soit-elle, la génération automatique de textes par les logiciels peut-elle combler le désir d’histoire qui relie les générations entre elles ? La génération automatique de musiques ne manque-t-elle pas la dimension d’improvisation inattendue qui caractérise toute œuvre nouvelle ? A quelles conditions un programme peut-il assister des pratiques créatives ? Cela suppose de comprendre le rôle de l’interprétation dans sa capacité à produire du sens au-delà du calculable, et d’en tirer les conséquences pour transformer les technologies de l’information et de la communication en supports de mémoire, d’interprétation et d’invention.
    </p>
    <br>
    <h4>Mardi 22 décembre – 17h00-19h30</h4>
    <ul>
    <li><b>17h00</b> : Frédéric Kaplan (Informatique et linguistique, école Polytechnique Fédérale de Lausanne)</li>
    
    <li><b>17h30</b> : Michal Krzykawski (Philosophie, université de Silésie à Katowice)</li>
    
    <li><b>18h00</b> : Pause</li>
    
    <li><b>18h15</b> : Gerard Assayag (Musique et informatique, IRCAM)</li>
    
    <li><b>18h45</b> : Discussion</li>
    </ul>
    <br>
    <br>
    <h3>PRENDRE SOIN DE l'INFORMATIQUE ET DES GÉNÉRATIONS</h3>
    <p>22 et 23 décembre 2020<br>
    <a href=\"https://enmi-conf.org/wp/enmi20\" target=\"_blank\">https://enmi-conf.org</a>
    </p>
    <br>
    <strong>14ème édition</strong>
    <br><br>

    <p>
    Argumentaire et programme rédigés par Anne Alombert (UCL), 
    Victor Chaix (IRI) et Maël Montévil (IRI)
    </p>

    <p>
    En proposant de prendre soin de l’informatique et des générations, 
    les Entretiens du Nouveau Monde Industriel 2020 poursuivent deux objectifs principaux&nbsp;:
    </p>

    <p>
    . interroger les fondements théoriques de l’informatique 
    qui commandent le fonctionnement des technologies numériques contemporaines&nbsp;;
    </p>

    <p>
    . et concevoir de nouveaux dispositifs et de nouvelles pratiques pour mettre 
    ces technologies au service de la transmission, du partage et de la constitution de savoirs transgénérationnels.
    </p>

    <p>
    Nous tenterons ainsi de repenser la question de l’intelligence artificielle à partir 
    d’un nouveau paradigme théorique, qui ne se fonde plus sur l’analogie entre l’humain 
    et la machine, mais qui prenne en compte les interactions entre individus psychiques, 
    milieux techniques et organisations sociales : au lieu d’envisager la vie ou l’esprit 
    comme des processus de traitement d’information, comme le propose les paradigmes cybernétiques 
    et cognitivistes dominants, nous nous interrogerons sur le processus d’exosomatisation, à travers
    lequel les vivants humains extériorisent leurs fonctions noétiques dans des organes artificiels, 
    qui peuvent ainsi devenir les supports d’une mémoire collective et de savoirs transgénérationnels dont il faut prendre soin.
    </p>

    <p>
    Nous tenterons ensuite de traduire ces questions théoriques en terme de conception 
    et de développement technologiques. Comment réaliser des plateformes numériques au service 
    des relations sociales et intergénérationnelles, aujourd’hui menacées par les applications addictives 
    et l’économie des données ? Comment intégrer dans les dispositifs computationnels des fonctions délibératives
    et interprétatives, qui dépassent toujours les programmes calculables en produisant des bifurcations improbables ? 
    Comment transformer les technologies de l’information et de la communication en supports de mémoire, d’interprétation, 
    de délibération et d’invention, au service du partage des savoirs et de l’intelligence collective, et pour répondre aux 
    enjeux de l’ère post-vérité ? En un mot, comment penser un web herméneutique et transgénérationnel ?
    </p>
    <br>",

    'link' => "https://enmi-conf.org/wp/enmi20/",
    'islive' => false,
    'islive_embed' => "",
    'keywords' => "Informatique, générations, ENMI, Centre Pompidou, soin",
    'annotation_protocol_version' => "3",
    'partenaires' => "<a href=\"http://www.iri.centrepompidou.fr/\" class=\"footerLink\" target=\"_blank\">&nbsp;IRI </a> |&nbsp; <a href=\"https://www.univ-catholille.fr/\" class=\"footerLink\" target=\"_blank\">Université Catholique de Lille</a> |&nbsp; <a href=\"https://www.capdigital.com/\" class=\"footerLink\" target=\"_blank\">Cap Digital</a>  &nbsp;|&nbsp; <a href=\"http://realsms.eu/\" class=\"footerLink\" target=\"_blank\"> Real Smart Cities </a>",

    'archive_title' => "Entretiens du Nouveau Monde Industriel 2020 - Sessions 2 et 3",
    'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou le 22 décembre 2020',

    'client_visual' => "images/client_visual.jpg",
    'head_logo' => "images/logo-enmi.png",
    'slide_background' => "images/slide_background.jpg",
    'archive_img' => "images/archive_img.jpg",
    'metadata'    => "66a961f9-54bd-11eb-aff6-00145ea4a2be",
);
