<?php
$config = array(
    'hashtag'    => '#enmi18',

    'title' => 'Entretiens du Nouveau Monde Industriel 2018 - Session 1 / Session 2',

    'abstract'   => "<b>L'INTELLIGENCE DES VILLES ET LA NOUVELLE RÉVOLUTION URBAINE</b> <br/> <em>Paris. Centre Pompidou. Grande Salle.<br>18 et 19 décembre 2018</em>",
    
    'description' => "<h3>Session 1 : Introduction / Session 2 : Smartness et infrastructures</h3>
    <p>Paris. Centre Pompidou. Grande Salle.<br>
    18 décembre 2018<br>
    <a href=\"https://enmi-conf.org/wp/enmi18/session-1/\" target=\"_blank\">https://enmi-conf.org/wp/enmi18/session-1/</a>
    <br>
    <a href=\"https://enmi-conf.org/wp/enmi18/session-2/\" target=\"_blank\">https://enmi-conf.org/wp/enmi18/session-2/</a>
    <br>
    <p><strong>Mardi 18 décembre</strong></p>
    <p><strong>09h30-10h30 - Session 1 : Introduction</strong></p>
    <p>
    Comme cela a été maintes fois souligné, de Jean-Pierre Vernant à Henri Lefèbvre en passant par Vere Gordon Childe, l’urbanisation, telle qu’elle s’engage au Néolithique, conduisant à la concentration de richesses autour de palais qui sont aussi des greniers, intensifie les relations sociales et fait apparaître des «&nbsp;technologies intellectuelles&nbsp;» (au sens de Jack Goody, comme écritures et systèmes de numération) qui engagent l’histoire citadine de l’intelligence individuelle et collective.
    Que doit-on retenir de cette teneur foncièrement urbaine de l’intelligence collective qui aura caractérisé les temps proto-historiques et historiques&nbsp;? Que devient cette forme de l’intelligence au moment où, tandis qu’une ceinture satellitaire permet désormais un contrôle planétaire par ce que Frank Pasquale (université du Maryland) a appelé les souverainetés fonctionnelles de plateformes assurant le contrôle dans ce que l’on appelle les «&nbsp;smart cities&nbsp;», et au moment où l’urbanisation accrue annoncée pour les prochaines décennies transforme la biosphère en technosphère cependant que l’Anthropocène requiert l’intelligence humaine comme jamais&nbsp;?
    </p>
    <p>
      <ul>
        <li><p><strong>09h30 : Patrick Braouezec</strong>, Introduction (&nbsp;Président de l’EPT Plaine Commune&nbsp;)</p></li>
        <li><p><strong>09h45 : Bernard Stiegler</strong>, Efficience et finalité dans le nouveau génie urbain&nbsp;: principaux enjeux de la troisième révolution urbaine (Institut de Recherche et d'Innovation, IRI)</p></li>
      </ul>
    </p>
    <br>
    <p><strong>10h30-13h00 - Session 2 : Smartness et infrastructures</strong></p>
    <p>
    Nous faisons l’hypothèse qu’une nouvelle révolution urbaine s’accomplit – dont les discours sur l’intelligence calculée et répartie dans les espaces communs sinon publics, ce qui est appelé smartness au sens de Sam Palmisano (IBM) – , désignent une facette, où les fonctions urbaines se reconfigurent très profondément à travers la réticulation généralisée et la digitalisation opérées comme ubiquitous computing, conduisant aux «&nbsp;villes connectées&nbsp;», c’est à dire calculées en permanence et en totalité. Comment spécifier ce qui advient ainsi du côté des infrastructures telles que David Berry les appréhende comme processus d’«&nbsp;infrasomatisation&nbsp;»&nbsp;? Quels sont les nouveaux agencements qui s’opèrent entre le global et le local dans ce contexte&nbsp;? Qu’est-ce qui caractérise la supposée «&nbsp;smartness&nbsp;», et en quoi pourrait-elle et devrait-elle participer d’une nouvelle intelligence des Habitants des villes, cités et tissus urbains et conurbains&nbsp;?
    </p>
    <p>
    <ul>
      <li><p><strong>10h30 : David Berry</strong>, The Neguentropic University&nbsp;: Infrasomatization, Data Intensive Society, and Anti-Smart Technologies (Sussex University)</p></li>
      <li><p><strong>11h10 : Robert Mitchell</strong>, Smartness & Populations as Infrastructure (Duke University)</p></li>
      <li><p><strong>11h50 : Daniel Kaplan et Mathieu Saujot</strong>, Innover, imaginer et gouverner dans la ville numérique réelle (Fing et IDDRI)</p></li>
      <li><p><strong>12h30 : Discussion</strong></p></li>
      <li><p><strong>13h00 : Fin de session</strong></p></li>
    </ul>
    </p>",

   'link' => 'http://enmi-conf.org/wp/enmi18/session-1/',

   'islive'     => true,
   'islive_embed' => '',

   'keywords'   => 'Iri, Nouveau Monde Industriel, Smartness, Samrt Cities, Territoire, Localité, Economie Contributive, Building Information Modeling',

   'rep' => basename(__DIR__),

   'partenaires' => "<a href=\"http://www.iri.centrepompidou.fr/\" class=\"footerLink\" target=\"_blank\">&nbsp;IRI </a> |&nbsp; <a href=\"https://www.capdigital.com/\" class=\"footerLink\" target=\"_blank\">Cap Digital</a>  |&nbsp; <a href=\"https://www.caissedesdepots.fr/\" class=\"footerLink\" target=\"_blank\">Caisse de dépots </a> |&nbsp; <a href=\"https://nextleap.eu/\" class=\"footerLink\" target=\"_blank\">NextLeap </a> |&nbsp; <a href=\"http://realsms.eu/\" class=\"footerLink\" target=\"_blank\"> Real Smart Cities </a>",

   'client_visual' => "images/client_visual.jpg",

   'head_logo' => "images/logo-enmi.png",

   'slide_background' => "images/slide_background.jpg",

   'archive_img' => "images/archive_img.jpg",

   'archive_title' => "Entretiens du Nouveau Monde Industriel 2018 - Session 1 / Session 2",
   'archive_description' => 'par l\'<a href="http://www.iri.centrepompidou.fr" target="_blank">IRI</a><br/>au Centre Pompidou les 18 et 19 décembre 2018',

    // After the event
    'metadata'    => "9099461a-0373-11e9-9cee-00145ea4a2be",
    'annotation_protocol_version' => '3',
);
