var AVATARWIDTH = 35,
    COLUMNWIDTH = 2,
    COLUMNHEIGHT = 420,
    THRESHOLD = 24,
    DROPCOUNT = 12;

var swTw = {
    "keyword" : "#enmi",
    "columns_words" : [
        "confiance",
        "croyance",
        "crédit",
        "trace",
        "foi",
        "risque", 
        "assurance", 
        "démocratie", 
        "expertise",
        "catastrophe",
        "transparence", 
        "politique"
    ],
    "tweets" : [],
    "tweetsIndex" : [],
    "firstDisplayedTweet" : 0,
    "cursor" : -1,
/*    "annotations" : {
        "positive" : {
            "keyword" : "+",
            "colors" : {
                "tweet" : "#c5e7cd",
                "timeline" : "#00ff00"
            }
        },
        "negative" : {
            "keyword" : "-",
            "colors" : {
                "tweet" : "#f6ced0",
                "timeline" : "#ff0000"
            }
        },
        "reference" : {
            "keyword" : "#",
            "colors" : {
                "tweet" : "#efefa1",
                "timeline" : "#ffff00"
            }
        },
        "question" : {
            "keyword" : "?",
            "colors" : {
                "tweet" : "#bfdbec",
                "timeline" : "#0000ff"
            }
        }
} */
}

function highlightKeyword(stra, strb) {
    var rgxp = RegExp( '(' + strb.replace(/(\W)/gm, '\\$1') + ')', "gim");
    return stra.replace(rgxp, '<span class="highlight">$1</span>');
}

function highlightText(txt) {
    var res = highlightKeyword(txt, swTw.keyword);
    res = swTw.columns_words.reduce(function(a, b) {
        return highlightKeyword(a,b);
    }, res);
/*    res = _(swTw.annotations).reduce(function(a, b) {
        return (b.keyword ? highlightKeyword(a,b.keyword) : a);
    }, res); */
    return res;
}

function nextTweet() {
    if (!swTw.tweets.length) {
        return;
    }
    if (swTw.cursor < swTw.tweets.length - 1) {
        swTw.cursor = Math.max(swTw.cursor + 1, swTw.tweets.length - 120);
        var nTweet = swTw.cursor;
    } else {
        var nTweet = swTw.tweets.length - 1 - ~~( Math.random() * Math.min(swTw.tweets.length,50) );
    }
    var tweet = swTw.tweets[nTweet];
    $("#tweetcont").html('<img src="'
        + tweet.profile_image_url
        + '" /><p>@'
        + tweet.from_user
        + ' ('
        + tweet.from_user_name
        + ')'
        + '</p><p class="tweet_text">'
        + highlightText(tweet.text)
        + '</p>');
/*    var bgcolor = '';
    for (var i in swTw.annotations) {
        if (swTw.annotations[i].keyword) {
            if (tweet.text.indexOf(swTw.annotations[i].keyword) != -1) {
                bgcolor = swTw.annotations[i].colors.tweet;
                break;
            }
        }
    } */
    $("#tweetcont").css("background",bgcolor);
}

function dropOldTweets() {
    var _newPos = swTw.firstDisplayedTweet + DROPCOUNT;
    _(swTw.tweets.slice(swTw.firstDisplayedTweet,_newPos)).each(function(tweet) {
        swTw.twInCol = _(swTw.twInCol).map(function(col) {
           return _(col).without(tweet.id_str);
        });
        _(tweet.elements).each(function(elid) {
            $("#" + elid).fadeOut(2000, function() {
                $(this).detach();
            });
        });
    });
    
    _(swTw.tweets.slice(_newPos)).each(function(tweet) {
        _(tweet.elements).each(function(elid) {
            var iword = parseInt(elid.split('_')[2]),
                iel = swTw.twInCol[iword].indexOf(tweet.id_str),
                posx = COLUMNHEIGHT - AVATARWIDTH * (1 + ~~( iel / COLUMNWIDTH)),
                posy = AVATARWIDTH * (iel % COLUMNWIDTH);
            $("#" + elid).delay(500).animate({
                "top" : posy + "px",
                "left" : posx + "px"
            },
            500);
        });
    });
    console.log("fin");
    swTw.firstDisplayedTweet = _newPos;
}

function callbackTweets(tweets) {
    _(tweets).each(function(tweet) {
        var tl = tweet.text.toLowerCase();
        tweet.columns = swTw.columns_words.filter(function(word) {
            return tl.search(word) != -1
        });
        tweet.elements = [];
        _(tweet.columns).each(function(word) {
            var iword = swTw.columns_words.indexOf(word),
                tcl = swTw.twInCol[iword],
                tclen = tcl.length;
            var posx = COLUMNHEIGHT - AVATARWIDTH * (1 + ~~( tclen / COLUMNWIDTH)),
                posy = AVATARWIDTH * (tclen % COLUMNWIDTH),
                elid = 'avatar_' + tweet.id_str + '_' + iword,
                bgcolor = '#999999';
/*            for (var i in swTw.annotations) {
                if (swTw.annotations[i].keyword) {
                    if (tweet.text.indexOf(swTw.annotations[i].keyword) != -1) {
                        bgcolor = swTw.annotations[i].colors.timeline;
                        break;
                    }
                }
        } */
            $('#column_' + iword).append(
                '<div class="avatar" id="'
                + elid
                + '" style="left: -200px; top: '
                + posy
                + 'px; background: '
                + bgcolor
                + '"><img src="'
                + tweet.profile_image_url
                + '" /></div>'
            );
            tweet.elements.push(elid);
            tcl.push(tweet.id_str);
            $("#" + elid).animate({
                "left" : posx + "px"
            }, 2000);
        })
        swTw.tweets.push(tweet);
        swTw.tweetsIndex.push(tweet.id_str);
    });
    while (_(swTw.twInCol).any(function(col) {
        return col.length > THRESHOLD
    })) {
        dropOldTweets();
    }
}

function retrieveTweets() {
    var options =  {
        "keyword" : swTw.columns_words.join(" OR "),
        "lang" : "fr",
//        "keyword" : "#enmi",
        "pages" : 1,
        "rpp" : 50,
        "cbEnd" : function() {
            callbackTweets(this.tweets);
            }
        }
    if (swTw.tweets.length) {
        options.since_id = swTw.tweets[swTw.tweets.length - 1].id_str;
    }
    getTweets(options);
}

function getTweets(options) {
    function getTweetUrl(url) {
        $.getJSON(url, function(data) {
            options.tweets = options.tweets.concat(data.results);
            options.currentPage = data.page;
            if (options.cbData) {
                options.cbData();
            }
            if (data.next_page && data.page < options.pages) {
                getTweetUrl(baseurl + data.next_page + suffix);
            } else {
                options.tweets.sort(function(a,b) {
                   return a.id - b.id; 
                });
                if (options.cbEnd) {
                    options.cbEnd();
                }
            }
        });
    }
    
    options.tweets = [];
    options.pages || (options.pages = 1);
    options.rpp || (options.rpp = 100);
    options.currentPage = 0;
    
    var baseurl = "http://search.twitter.com/search.json",
        suffix = (options.since_id ? "&since_id=" + options.since_id : '' ) + "&callback=?",
        jsonurl = baseurl + "?q=" + encodeURIComponent(options.keyword)+ "&rpp=" + options.rpp
            + (options.lang ? "&lang=" + options.lang : '' ) + suffix;
    getTweetUrl(jsonurl);
}

$(document).ready(function() {
    $("#columncont").html( swTw.columns_words.map(
        function(mot, i) {
            return '<div class="column" id="column_'
            + i
            + '"><div class="column-tube"></div><div class="column-title"><h3>'
            + mot
            + '</h3></div></div>'
        }
    ).join("") );
    
   swTw.twInCol = swTw.columns_words.map(function() {
       return [];
   });
   
   retrieveTweets();
   
   setInterval(retrieveTweets,5000);
   
   setInterval(nextTweet, 3000);
    
});
