<?php

/**
 * include some common code (like we did in the 90s)
 * People still do this? ;)
 */
include_once './common.php';

/**
 * Do we already have a valid Access Token or need to go get one?
 */
if (!isset($_SESSION['TWITTER_ACCESS_TOKEN']) && isset($_GET['CONNECT']) ) {
    /**
     * Guess we need to go get one!
     */
    $token = $consumer->getRequestToken();
    $_SESSION['TWITTER_REQUEST_TOKEN'] = serialize($token);

    /**
     * Now redirect user to Twitter site so they can log in and
     * approve our access
     */
    $consumer->redirect();
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN"
   "http://www.w3.org/TR/html4/strict.dtd">

<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title>RSLN  - Live Video and Annotation</title>
	<meta http-equiv="X-UA-Compatible" content="IE=8" /> 

    <!-- Framework CSS -->
    <link rel="stylesheet" href="res/blueprint/screen.css" type="text/css" media="screen, projection">
    <link rel="stylesheet" href="res/blueprint/print.css" type="text/css" media="print">
    <!--[if lt IE 8]><link rel="stylesheet" href="blueprint/ie.css" type="text/css" media="screen, projection"><![endif]-->

    <!-- Import fancy-type plugin for the sample page. -->
    
	<link rel="stylesheet" href="res/blueprint/plugins/fancy-type/screen.css" type="text/css" media="screen, projection">
	<link rel="stylesheet" href="custom.css" type="text/css" media="screen, projection">
	<link rel="stylesheet" type="text/css" href="res/jquery.fancybox/fancybox/jquery.fancybox-1.3.4.css" media="screen">
	<link rel="stylesheet" type="text/css" href="res/niceforms/niceforms-custom.css" media="screen" >

	<!-- JAVASCRIPT --> 
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.4.2/jquery.min.js"></script>
	<script type="text/javascript" src="http://cdn.jquerytools.org/1.2.5/jquery.tools.min.js"></script>
	<script type="text/javascript" src="res/jquery.fancybox/fancybox/jquery.mousewheel-3.0.4.pack.js"></script>
	<script type="text/javascript" src="res/jquery.fancybox/fancybox/jquery.fancybox-1.3.4.pack.js"></script>
	<script type="text/javascript" src="res/niceforms/niceforms.js"></script>
	<script src="http://widgets.twimg.com/j/2/widget.js"></script>
	
	<!-- FONT -->
	<link href='http://fonts.googleapis.com/css?family=PT+Sans+Narrow&subset=latin' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=PT+Sans&subset=latin' rel='stylesheet' type='text/css'>
	<link href='http://fonts.googleapis.com/css?family=Geo&subset=latin' rel='stylesheet' type='text/css'>
	<style type="text/css"> 
		.tweetButton{float:left;margin-right:5px;}
		.videoLivePlayer{border:1px solid #c3c3c3;width:650px;height:638px;}
		.videoLive{width:650px;height:640px;background:#fff;float:right;margin-top:20px;padding:5px;}
					
					.tweetExplain{background-image:url(images/tweetExplainBgd.gif);width:250px;height:640px;padding:10px;position:absolute; margin-top:70px;}
		.footer{margin-top:740px;width:960px;height:20px;position:absolute;text-align:center;}
		
		#tip{
			 position : absolute;
			 padding : 3px;
			 z-index: 1000000;
			 max-width: 200px;
		}	
		#tip {
				display: none;
				background: transparent url("images/white_arrow_long.png");
				font-size: 12px;
				height: 125px;
				width: 180px;
				padding: 10px;
				padding-left: 15px;
				padding-top: 15px;
				padding-right: 15px;
				color: black;
				z-index: 1000000;
				font-family: "Trebuchet MS", "Helvetica", "Arial", "Verdana", "sans-serif";
				overflow:hidden;
		}
		#chartTimeline{
			padding-top: 410px;
			z-index: 100000;
			position : absolute;
		}

	</style>
	<script type="text/javascript">	
	$(document).ready(function() {

			doTimer();
			//$("txt").hide();
			$(".loginbutton").click(function() {
				document.location.href="<?php URL_ROOT ?>?CONNECT=true";
			});
			$("#IDENTIFIER").click(function() {
				document.location.href="<?php URL_ROOT ?>?CONNECT=true";
			});
			
			$("#messageSuccess").hide();
			$("#messageFailed").hide();
			$("#txt").hide();
			
			// BUTTONS
			$("#positive").click(function(){
				var MyValue = $('#status').attr("value");
				 $('#status').attr("value",MyValue+"++ ");
			});
			$("#negative").click(function(){
				var MyValue = $('#status').attr("value");
				$('#status').attr("value",MyValue+"-- ");
			});
			$("#reference").click(function(){
				var MyValue = $('#status').attr("value");
				$('#status').attr("value",MyValue+"== ");
			});
			$("#question").click(function(){
				var MyValue = $('#status').attr("value");
				$('#status').attr("value",MyValue+"?? ");
			});
			
			// SEND TWEETS 
			$("#sendTweet").click(function(){
				var MyStatus = $('#status').attr("value");
				$.post('tweet_ajax.php', {status:MyStatus}
				,function(data) {
				
					if(data=="true"){
						$("#messageSuccess").show('fast');
						$("#messageSuccess").delay(800).hide('slow');
						$('#status').attr("value","#rsln");
						//$('#status').css("background-image","images/greenTweet.png");
						//$('#status').delay(800).css("background-image","images/tweetWriterBgdTxtArea.gif");
					}else{
						$("#error").text(data);
						$("#messageFailed").show('fast');
						$("#messageFailed").delay(800).hide('slow');
						//$('#status').css("background-image","images/redTweet.png");
						//$('#status').delay(800).css("background-image","images/tweetWriterBgdTxtArea.gif");
					}
					
				});
				
			});			
			

		});
		
		
		<!-- LIMIT TEXTAREA:
		function imposemax(Object)
		{
		  return (Object.value.length <= 140);
		}
		// End -->
		
		<!-- TIMER 
		var c=0;
		var t;
		var timer_is_on=0;

		function timedCount()
		{
			document.getElementById('txt').value=c;
			c = c+1;
			t = window.setTimeout("timedCount()",1000);
			$(".twtr-ft").hide();
			$(".twtr-hd").hide();
			
			//twtr-tweet
			$(".twtr-tweet").each(colorTweetings);
		
		}

		function colorTweetings (){
			/*
			efc1f0 > violet
			c5e7cd > vert
			f6ced0 > rouge
			bfdbec > blue 
			ecedc1 > yellow
			*/
				var tweettemp = $(this).html();
				//alert(tweettemp);
				//$(".videoLiveProgramDescription").text(tweettemp);
				//$(".videoLiveProgramTitle").text(tweettemp.search(/\x2D\x2D/));
				
				/*
				<a target="_blank" class="twtr-reply" href="http://twitter.com/?status=@LaurentChic%20&amp;in_reply_to_status_id=12411225795198976&amp;in_reply_to=LaurentChic">reply</a>
				*/	//alert("tweettemp");
				
				if (tweettemp.search(/\x3F\x3F/)!=-1){
				
					 $(this).css({'background-color': '#ecedc1','color':"#000"});
				}
				
				if (tweettemp.search(/\x2B\x2B/)!=-1){
					 $(this).css({'background-color': '#c5e7cd','color':"#fff"});
				}
				
				if (tweettemp.search(/\x2D\x2D/)!=-1){
					 $(this).css({'background-color': '#f6ced0','color':"#fff"});
				}
				
				if (tweettemp.search(/\x3D\x3D/)!=-1){
					 $(this).css({'background-color': '#bfdbec','color':"#000"});
				}
		};
			

		
		function doTimer()
		{
		if (!timer_is_on)
		  {
		  timer_is_on=1;
		  timedCount();
		  }
		}

		function stopCount()
		{
			clearTimeout(t);
			timer_is_on=0;
		}
		//
		
		//-->
		
		
	</script>

	
  </head>
  <body>
  
  <div id="tip"></div>
  <script type="text/javascript"> 
  	$(document).mousemove(function(e){
		if (over){
			tip.css("left", e.pageX-106).css("top", e.pageY-160);
			tip.css("color", tipColor)
			tip.text(tipText);
		}
	});
	var over = false;
	var tip = $("#tip").hide();
	var tipText  = "";
	var tipColor = "#efefef";
	
	function addTip(node, txt,color){
			$(node).mouseenter(function(){
			   tipText = txt;
			   tip.fadeIn(0);
			   tipColor = color;
			   over = true;
			}).mouseleave(function(){
			   tip.fadeOut(0);
			   over = false;
			});
	}	
  </script>
  
  
    <div class="container">
      <img src="images/ENMI_2010_logo.gif" class="logo">
	  <ul class="menu"> 
	  <li class="menuUnderline"><a href="index.php" class="menuLink" id="About"> À propos</a></li>
	  <li class="menuUnderline" ><a href="http://www.rslnmag.fr/blog/2011/1/17/clay-shirky_-personne-n-est-titulaire-du-code-source-de-la-democratie_/" class="menuLink" target="_blank"> Programme</a></li>
	  <li  ><a href="polemicaltimeline.php" class="menuLink">Lecteur polémique</a></li>

	  </ul>

		  
	  <div class="tweetExplain"  >
		<h3 class="tweetWriterTitle">Annotations pol&eacute;mique : </h3><br/>
		l’Institut de recherche et d’innovation (Iri) vous a proposer une expérimentation et une démonstration d’un dispositif d’annotation polémique basé sur twitter.
Cette qualification de vos tweets nous a permis de créer une timeline polemique représentant les positions de 
l'auditoire durant la conférence.
<br/><br/>

	Cette syntaxe polémique vous a premis de prendre position relativement à l’intervenant ou aux autres participants au débat : 
	<table>
	<tr>
	<td>
			<a 
					
					id="positive"
					title="accord"
					class="tweetButton">++</a> </td><td>correspond à un tweet d’assentiment</td>
	</tr>
	<tr>
	<td>
					
					<a 
					
					id="negative"
					title="désaccord"
					class="tweetButton">--</a></td><td> à un tweet de désaccord,</td>
	</tr>
	<tr>
	<td>
					<a
					
					id="reference"
					title="reference"
					class="tweetButton">==</a></td><td> à un tweet de complément</td>
	</tr>
	<tr>
	<td>			
					<a 
					
					id="question"  
					title="question"
					class="tweetButton"> ??</a></td><td> à une question</td>
	</tr>
	</table>

	Suite a cette phase d’annotation, vous trouverez à droite de ce texte <b>la version alpha</b> de l'interface de navigation et de représentation de la polémique durant la conférence.
		
		<br/><br/>
Ce dispositif, outre qu’il approfondit la dimension critique de la discussion avec la salle et les auditeurs présents ou distants, permet ainsi également de pérenniser et de valoriser les commentaires produits en les rendant accessibles en temps différé lors de tout visionnage ultérieur de la vidéo 
		<br/>
		<br/>Merci a RSLN pour cette expérimentation !
	  </div>
  
	  <div class="videoLive" >
		<div class="videoLivePlayer">

		<div id="chartTimeline"> </div>		
		<script type='text/javascript' src='res/metadataplayer/src/js/LdtPlayer.js'></script>
		<div id="player_project_13b0aa52-336b-11e0-b233-00145ea49a02_embed" class="iri_player_embed"> </div>
		
			<script type="text/javascript">
				var configMP = {
						/*metadata:{
							format:'cinelab',
							src:'metadata.json',
							load:'json'},*/
						metadata:{
							format:'cinelab',
							src:'http://www.iri.centrepompidou.fr/dev/ldt/ldtplatform/ldt/cljson/id/13b0aa52-336b-11e0-b233-00145ea49a02',
							load:'jsonp'},
						gui:{
							width:650,
							height:480,
							mode:'video',
							container:'player_project_13b0aa52-336b-11e0-b233-00145ea49a02_embed',
							debug:false,
							css:'http://amateur.iri.centrepompidou.fr/live/rsln/res/css/LdtPlayer.css'},
	
						player:{
							type:'jwplayer',
							src:'http://www.iri.centrepompidou.fr//dev/ldt/static/ldt/swf/player.swf'}
					};
				__IriSP.init(configMP);     
			</script>
			
		</div>	
		
	  </div>

      <div class="footer">
		<hr>
		 <a href="http://www.iri.centrepompidou.fr/" class="footerLink" target="_blank">
 IRI </a>
		 |  <a href="http://www.rslnmag.fr/" class="footerLink" target="_blank" > RSLN  </a>
		 |  <a href="http://www.slate.fr/" class="footerLink"  target="_blank"> SLATE.fr  </a>
		 |  <a href="http://www.microsoft.fr/" class="footerLink" target="_blank"> MICROSOFT.fr  </a>
		 <?php 
				if (isset($_SESSION['TWITTER_ACCESS_TOKEN'])){
					echo("| 	<a href='clear.php'  class='footerLink'>D&eacute;connexion</a>");
				}
		 ?>
		  <input type="text" id="txt" size="3"/>
	  </div>   
	
    </div>
	
	<!-- LIGHTBOX --> 
	<div style="display:none;">
		<div id="Aboutbox" >
		<div class="lightBorder">
			<div class="lightTitle" style="height:45px;">&nbsp;  </div>
			<div class="lightSubTitle">Annotation polémique par tweet </div>
			<div class="lightDescription">Lors de la conférence du 31 janvier 2011 organiser par RSLN vous avez expérimenté une syntaxe polémique pour "tweeter". Cette qualification de vos tweets nous a permis de créer une timeline polemique. Cette timeline vous permet de naviguer dans la vidéo <br/>tout en représentant les positions de <br/>l'auditoire durant la conférence.
			</div>
			<br/>
			<div>
			<!--
				<br/>
				<a class="button_b" href="#"  id="IDENTIFIER"><span>S'identifier</span></a> <br/><br/>
			-->
				<a class="button_w" href="#"  id="ACCES"><span>voir la vidéo</span></a> 
				
			</div>
		</div>
		</div>
	</div>

	
		<script type="text/javascript" src="res/raphael/raphael-min.js"></script>
<script type="text/javascript"> 

// CHART TIMELINE / VERSION PROTOTYPE  ::
//		- config
// 		- organisation classe
// 		!!!- rollover !! 
// 		!!!!- legend  !!
//		- time cursor
// 		- seek !!

/*
	1 | 1D973D > vert 	> ++ > OK
	2 | C5A62D > orange	> ?? > Q
	3 | CE0A15 > rouge  > -- > KO
	4 | 036AAE > bleu   > == > REF
	5 | 585858 > gris   > NQ > ""
*/
	

	// configuration 
	var config = {
					target:"chartTimeline",
					x:8,
					y:418,
					width:650,
					height:70,
					heightmax:70
					}
	// Make and define the Raphael area
	//var paper = Raphael(document.getElementById(config.target),config.width, config.height);
	
	
	function ChartTimeLine (){
		
		//var paper = Raphael(config.x, config.y,config.width, config.height);
		var paper = Raphael(document.getElementById("chartTimeline"),config.width, config.height);
		paper.rect(0,20,config.width,config.heightmax-20).attr({fill:"#fff","stroke-width":0.1,opacity: 0.1});	
		paper.rect(0,20,config.width,1).attr({fill:"#fff",stroke: "none"});	
		paper.rect(0,20,config.width,1).attr({fill:"#fff",stroke: "none"});	
		paper.rect(0,20,1,1).attr({fill:"#fff",stroke: "none"});	
		
		// variable 
		
		var yCoef	  = 2; 					// coef for height of 1 tweet 
		var frameSize = 5; 					// frame size 
		var margin 	  = 1;					// marge between frame
		var lineSize  = 650;				// timeline pixel width 
		var nbrframes = lineSize/frameSize; // frame numbers
		var numberOfTweet = 0;				// number of tweet overide later 
		var duration  = 4299820 ;			// timescale width 
		var frameLenght =lineSize/frameSize;// frame timescale	
		var timeline;
		var colors  = new Array("","#1D973D","#C5A62D","#CE0A15","#036AAE","#585858");
		
		// array 
		var tweets  = new Array();
		var element = new Array();
		var cluster = new Array();
		var frames  = new Array(frameLenght);
		var slices  = new Array();
		
		
		// Classes =======================================================================
		var Frames = function(){
			
			var Myclusters;
			var x;
			var y;
			var width;
			var height;
		};
		Frames = function(json){
			// make my clusters
			// ou Frame vide 
		};
		Frames.prototype.draw = function(){
		}
		Frames.prototype.zoom = function(){
		}
		Frames.prototype.inside = function(){
		}
		var Clusters = function(){
			var Object;
			var yDist;
			var x;
			var y;
			var width;
			var height;
		};
		Clusters = function(json){
			// make my object
		};
		var Tweet = function(){
		}
		// Classes =======================================================================
		
		


		// trace function 
		var traceNum = 0;
		function trace(msg,value){
			traceNum += 1;
			$("<div>"+traceNum+" - "+msg+" : "+value+"</div>").appendTo("#output");
		}
		
		// Refactoring (parametere) ************************************************************
		// color translastion
		function colorTranslation(value){
			if(value == "Q"){
				return 2;
			}else if(value =="REF"){
				return 4;
			}else if(value =="OK"){
				return 1;
			}else if(value =="KO"){
				return 3;
			}else if(value ==""){
				return 5;
			}
		}
		
		
		// Refactoring (parametere) ************************************************************
		// load tweets send in parameters 
		$.ajax({
		  dataType: "jsonp",
		  url:"http://www.iri.centrepompidou.fr/dev/ldt/ldtplatform/ldt/cljson/id/13b0aa52-336b-11e0-b233-00145ea49a02",
		  success : function(json){
			trace("load","");
				$.each(json.annotations, function(i,item) {
					
					var MyTime  = Math.floor(item.begin/duration*lineSize);
					var Myframe = Math.floor(MyTime/lineSize*frameLenght);

					if (item.content['polemics'] != undefined) {
						if (item.content['polemics'][0] != null) {
							
								for(var j=0; j<item.content['polemics'].length; j++){

										tweets[numberOfTweet] = {
													id:i,
													qualification:colorTranslation(item.content['polemics'][j]),
													yIndicator:MyTime,
													yframe:Myframe,
													title:item.content['title'],
													timeframe:item.begin
													}
										numberOfTweet+=1;
								}
						}else{
							//trace("k = ",i);
							tweets[numberOfTweet] = {
										id:i,
										qualification:colorTranslation(""),
										yIndicator:MyTime,
										yframe:Myframe,
										title:item.content['title'],
										timeframe:item.begin
							}
							numberOfTweet+=1;
						}
						
					} else {
						//trace("tweet qualification = ","null");
					}
				});	
			trace("======= ",numberOfTweet);
		   DrawTweets ();
		   
		  }
		 });
			

			
		// tweet Drawing (in raphael) 
		function DrawTweets (){
		// GROUPES TWEET ============================================
		// Count nbr of cluster and tweet in a frame an save int in "frames"
			numberOfTweet = tweets.length;
			for(var i=0; i<nbrframes; i++) {	
				for(var j=0; j<numberOfTweet; j++) {	
				
					if (i==tweets[j].yframe){
						
						var k = tweets[j].qualification;
						
						// make array for frame cluster
						if(frames[i]==undefined){
							frames[i] = {id:i,
										 qualifVol:new Array(),
										 mytweetsID:new Array()
										};
						}
						// add my tweet to frame
						frames[i].mytweetsID.push(tweets[j]);
						
						// count opinion by frame
						if( frames[i].qualifVol[k] == undefined){
							frames[i].qualifVol[k] = 1;
						}else{
							frames[i].qualifVol[k] += 1;
						}
						
					}
				}
			}
		
		// GROUPES TWEET ============================================		
		// max of tweet by Frame 
			var max = 0; 
			for(var i=0; i<nbrframes; i++) {
				var moy	= 0;
				for (var j=0; j<6; j++){		
					if (frames[i]!=undefined){
						if (frames[i].qualifVol[j]!=undefined){
							moy += frames[i].qualifVol[j]
						}
					}
				}
				//trace("frame "+i,moy);
				if (moy>max){max=moy;}
			}
		
			var tweetDrawed = new Array();
			var TweetHeight = 5;
			// DRAW  TWEETS ============================================
			for(var i=0; i<nbrframes;i++) {
				var addEheight = 5;
				if (frames[i]!=undefined){
					trace (i+" k=",frames[i].mytweetsID.length);
					// by type 
					for (var j=6; j>-1; j--){
						if (frames[i].qualifVol[j]!=undefined){
							// show tweet by type 
							for (var k=0; k<frames[i].mytweetsID.length; k++){
								if (frames[i].mytweetsID[k].qualification==j){
									e = paper.rect( i*frameSize, 					// x
													config.heightmax-addEheight,	// y
													frameSize-margin,				// width
													TweetHeight						// height
													).attr({stroke:"#00","stroke-width":0.1,  fill: colors[j]});	
									addEheight +=TweetHeight;
									e.time= frames[i].mytweetsID[k].timeframe;
									e.title= frames[i].mytweetsID[k].title;
									e.mouseover(function () {
										this.attr({stroke:"#fff","stroke-width":5});
										this.toFront();
									}).mouseout(function () {
										this.attr({stroke:"#00","stroke-width":0.1});	
									}).mousedown(function () {
										__IriSP.MyApiPlayer.seek(this.time/1000)
									});
									$(e.node).attr('id', 't'+k+'');
									$(e.node).attr('title', frames[i].mytweetsID[k].title);
									$(e.node).attr('begin',  frames[i].mytweetsID[k].timeframe);
									addTip(e.node, frames[i].mytweetsID[k].title,colors[j]);
									//frames[i].mytweetsID.pop();
								}
							}
						}
					}
				}
			}
			
			
		}

		// AddTip  ******************************************************************************
	
	}
	
	ChartTimeLine();

</script>

	
	
  </body>
</html>
