<?php

$embed_code_list = [
    [new DateTime('2018-09-22T08:30:00Z'), new DateTime('2018-09-22T12:50:00Z'), '<iframe width="560" height="315" src="https://www.youtube.com/embed/KfXwcNruncg?autoplay=1" frameborder="0" allow="autoplay; encrypted-media" modestbranding=1 allowfullscreen></iframe>'],
    [new DateTime('2018-09-22T12:50:01Z'), new DateTime('2018-09-22T20:30:00Z'), '<iframe id="ls_embed_1537527835" src="https://livestream.com/accounts/27752410/events/8379051/player?width=560&height=315&enableInfoAndActivity=true&defaultDrawer=&autoPlay=true&mute=false" width="560" height="315" frameborder="0" scrolling="no" allowfullscreen></iframe>'],
    [new DateTime('2018-09-23T07:30:00Z'), new DateTime('2018-09-23T16:30:00Z'), '<iframe width="560" height="315" src="https://www.youtube.com/embed/iHygIOIkZ0A?autoplay=1" frameborder="0" allow="autoplay; encrypted-media" modestbranding=1 allowfullscreen></iframe>'],
];

$islive_embed = null;
$current_time = new DateTime();

foreach ($embed_code_list as $time_entry) {
    if($current_time >= $time_entry[0] &&  $current_time <= $time_entry[1]) {
        $islive_embed = $time_entry[2];
        break;
    }
}

$config = array(
    'rep' => basename(__DIR__),
    'title' => "Work Marathon 2018",
    'hashtag' => "#workmarathon",
    'abstract'   => "«&nbsp;<b>Work Marathon 2018</b>&nbsp;» <br/> <small>September 22nd, from 10am to 10pm @Serpentine Galleries (London)</small> 
<br/>«&nbsp;<b>Writing Workshop</b>&nbsp;» <br/> <small>September 23rd, from 9am to 4pm @Goethe-Institut (London)</small>", 

    'description'=> "<p><b>BERNARD STIEGLER: A MANIFESTO</b></p>
<p>
The 2018 Work Marathon will invite artists, sociologists, anthropologists, writers,
musicians, architects, scientists and philosophers to address cultural, political, physical
and environmental debates on the complex and timely question of work, labour,
automation and leisure.</br>
This year, the Work Marathon is conceived in collaboration with Professor Bernard Stiegler who
will gather experts from around the world to consider economics for an age of
planetary-scale environmental crisis, looking to reduce the human footprint on the
planet and reverse the phenomenon of entropy that follows. With Stiegler’s advice, the
2018 Serpentine Marathon has the goal of contributing to the writing of a manifesto, the
first version of which will be issued on 23 September, and the definitive version of which
will be sent to the United Nations, in Geneva, on 10 January 2020 – the day of the
centenary anniversary of the League of Nations.</br></br>
See his argument for the Marathon here:</br>
https://drive.google.com/file/d/11pC-QRI6SZbqyBVLummHtXbMPHbMdQH9/view?usp=sharing
<br/><br/>



<b><small>September 22</small></b><br/>
<i>please note that due to the nature of the event, timings are subject to change without warning on the day</i><br/><br/>


<b>10AM - 1PM</b><br/> 
Hans Ulrich Obrist<br/>
Steffi Czerny<br/>
*Lily Cole and Mark Boyle, <i>Marblehill</i><br/>
Mark Boyle and James Suzman in
conversation, <i>Primitive Affluence</i><br/>
Wilson Oryema, <i>A Working Miracle
in Three Parts</i><br/>
Beatriz Colomina<br/>
Amal Khalaf, <i>Radio Ballads</i><br/>
*Simon Lincelles (Ars Industrialis),
Ars Industrialis’ Vocabulary, 2018<br/>
Bernard Stiegler, <i>Too Late?
The Final Warning</i><br/>
*Data Gueule, <i>La faim du travail</i>, 2016<br/>
Olivier Landau, <i>Contributive Economy</i><br/>
Maël Montévil, <i>Entropy and the Anthropocene</i><br/>
Paolo Vignola, <i>Perspective and Locality:
Notes for a Collective Ecological
Individuation</i><br/>
Daniel Ross, <i>Escapement: The Mainspring
of Humanity is Running Down</i><br/>
Giacomo Gilmozzi, <i>Smart Cities or Smart
(Data) Mines</i><br/>
Anne Alombert, <i>Contributive Research,
Social Sculpture and Digital Studies:
An Attempt to Adopt Disruption</i><br/>
GCC, GCC <i>Lunch Break</i><br/><br/>

<b>1.30 - 4.30PM</b><br/>
*Aurélien Barrau, <i>Ecologie et Nouveau
Pacte avec le Vivant</i>, 2018<br/>
Julien Dossier, Olivier Landau and
Clément Morlat, <i>The Economy of
Contribution in the Anthropocene
and Beyond</i><br/>
*Institut de Recherche et d’Innovation,
<i>Entropy, Contributive Economy and
Management of the Commons</i> -
Interview with Gaël Giraud, 2018<br/>
*Institut de Recherche et d’Innovation,
Giuseppe Longo, Maël Montévil and
Bernard Stiegler, <i>Mathematics,
Life Science, Finance, Work and Economy</i><br/>
*Institut de Recherche et d’Innovation,
<i>Law in the Anthropocene</i> - Interview
with Alain Supiot, 2018<br/>
*Institut de Recherche et d’Innovation,
Divya Dwivedi, Yuk Hui, Bernard Stiegler
and Paolo Vignola, Locality, <i>Post-
Colonial Studies, Cosmotechnics,
Internation (according to Marcel Mauss)
and 'Negantropy'</i><br/><br/>

<b>5 - 8PM</b><br/>
*Werner Herzog, <i>Lo and Behold, Reveries
of the Connected World</i>, excerpt, 2016<br/>
Shaj Mohan, Gerald Moore and Daniel
Ross, <i>Acceleration, Disruption,
Bifurcation</i><br/>
*Autodesk Building Solution, <i>What is BIM
(Building Information Modeling)?</i>, 2017<br/>
Sara Baranzoni, David Berry, Giacomo
Gilmozzi and Saskia Sassen,
<i>Really Smart Cities, Platforms,
Infrasomatisation</i><br/>
*Joseph Beuys, video excerpt<br/>
*United Nations Foundation, <i>Welcome to
the Anthropocene, excerpt</i>, 2012<br/>
Anne Alombert, Noel Fitzpatrick,
Glenn Loughran and Vincent Puig,
<i>Contributive Research, Social Sculpture,
Art & Technology</i><br/></br>

*Denotes pre-recorded and video
contribution<br/></br>

<b><small>September 23</small> - 9AM - 4PM<br/>
WRITING WORKSHOP<br/>
DRAFT FOR A NEGANTHROPOCENE MANIFESTO</b>
<br/><br/>
<b>Participants include: Anne Alombert, Sara Baranzoni, David Berry, Mark Boyle, Lily Cole, Beatriz Colomina, Stella Creasy, Adam
Curtis, Rana Dasgupta, Aria Dean, Julien Dossier, Marcus du Sautoy, Divya Dwivedi, Cao Fei, Peter Fischli, Noel Fitzpatrick,
Formafantasma, Fernando Garcia Dory, GCC, Anna Bella Geiger, Giacomo Gilmozzi, Goldin + Senneby, Jon Gray, Madeline
Hollander, Yuk Hui, Anne Imhof, Josh Kline, Olivier Landau, Helen Lewis, Giuseppe Longo, Glenn Loughran, Shaj Mohan, Maël
Montévil, Gerald Moore, Clément Morlat, Richard Mosse, Oscar Murillo, Precious Okoyomon, Wilson Oryema, Vincent Puig,
Venkatesh Rao, Pedro Reyes, Daniel Ross, Saskia Sassen, Emily Segal, Nick Srnicek, Patrick Staff, Bernard Stiegler, Daniel
Susskind, James Suzman, Phoebe Tickell, Paolo Vignola, Marina Vishmidt and Nil Yalter.</b>
</p>"
,

    'link' 		 => '',
    'islive'     => false,
    'islive_embed' => $islive_embed,
    'keywords'   => 'Work Marathon, Neganthropocene, Neganthropy, Samrt Cities, Economy of Contribution, Contributive research, Internation, Building Information Modeling, Disruption',

    'partenaires'=> "<a href='http://www.serpentinegalleries.org/'
class='footerLink' target='_blank'> Serpentine Galleries </a><a href='http://www.iri.centrepompidou.fr/' class='footerLink' target='_blank'> IRI </a>",

    'client_visual' => "images/Serpentine_Image-Polemic_Tweet_480x320.png", // 501 × 376 pixels
    
    'head_logo' => 'images/Serpentine_Image-Polemic_Tweet_171x63.png', // 171 × 63 pixels
     
    'slide_background' => "images/Serpentine_Image-Polemic_Tweet_606x282.png", // 606 × 282 pixels
    
    'archive_img' => "images/Serpentine_Image-Polemic_Tweet_270x150.png", // 270 × 150 pixels

    'archive_title' => "Work Marathon 2018",
    'archive_description' => "from <a href=\"http://www.iri.centrepompidou.fr/\" target=\"_blank\">IRI</a> at Serpentine Galleries and Goethe-Institut<br/> September 22nd | 10am - 10pm and September 23rd | 9am - 4pm",
    'annotation_protocol_version' => '3',
    'additional_js' => ['reloader.php?a='.rand(),],

    // After the event
    // 'metadata'		=> "fc62350e-69d9-11e1-9089-00145ea4a2be",
    // 'duration'  	=> 10876600,
    // 'player'        => "res/metadataplayer/src/js/LdtPlayer.js",
    // 'div_height'    => 740,
    // 'player_width'  => 650,
    // 'player_height' => 500,
);