import csv
import re
import math

TC_RE = re.compile("(\d{2}) (\d{2}) (\d{2}) ?, ?(\d{2})")

def conver_tc(tc_str):
    m = TC_RE.match(tc_str)
    if not m:
        return math.inf
    return int(m.group(1))*3600000 + int(m.group(2))*60000 + int(m.group(3)) * 1000 + int(m.group(4)) * 10

if __name__ == "__main__":
    with open('timecodes_webinaire_fcpe.csv') as csvfilein, \
        open('timecodes_webinaire_fcpe_out.csv', 'w') as csvfileout:
        chap_reader = csv.DictReader(csvfilein, delimiter=';')
        chap_writer = csv.DictWriter(csvfileout, fieldnames=chap_reader.fieldnames, delimiter=';')

        chap_writer.writeheader()
        for row in chap_reader:
            if not row['START']:
                next
            row['START'] = conver_tc(row['START'])
            row['END'] = conver_tc(row['END'])
            chap_writer.writerow(row)